﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{

    public class EficienciaTrabajoHomologados : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault() != null)
            {
                var percepcionCalculo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault();
                if (percepcionCalculo.Calcular)

                {
                    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();
                    if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria == "SUPERVISOR" ||
                       ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria == "INGENIERO EN SISTEMAS" ||
                       ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria == "SECRETARIA DE DIRECTOR DE AREA" ||
                       ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria == "SECRETARIA DE DIRECTOR GENERAL" ||
                       ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.Contains("DE TECNICOS ESPECIALIZADOS")


                    )
                    {
                        percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        percepcion.IdNomina = NominaTrabajador.IdNomina;
                        percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdPlantillaNominaPercepcion;
                        percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;


                        Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                        percepcion.Importe = ((costos.CostoEficienciaJornada * NominaTrabajador.DiasNomina * costos.Catalogos_ctJornadaLaboral.HorasMaximo) * NominaTrabajador.DiasPagados) / NominaTrabajador.DiasNomina;



                        

                        percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                    }
                }
            }
        }

        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }
    }

}