﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{

    public class EficienciaTrabajoDocenteDefinitivo : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO DE JORNADA").FirstOrDefault() != null)
            {
                if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                {
                    
                     
                       
                            PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                            percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            percepcion.IdNomina = NominaTrabajador.IdNomina;
                            percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO DE JORNADA").FirstOrDefault().IdPlantillaNominaPercepcion;
                            percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO DE JORNADA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                            Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();


                            percepcion.Importe = Decimal.Round((decimal)costos.CostoEficienciaJornada * NominaTrabajador.HorasSemanaMes, 4);



                            percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO DE JORNADA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;

                            PercepcionesNominaTrabajador percepcionExcedente = new PercepcionesNominaTrabajador();

                            percepcionExcedente.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            percepcionExcedente.IdNomina = NominaTrabajador.IdNomina;

                            Percepciones_stPlantillaNominaPercepciones excedente = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO DE HORAS EXCEDENTES").FirstOrDefault();
                            if (excedente != null)
                            {
                                percepcionExcedente.IdPlantillaNominaPercepcion = excedente.IdPlantillaNominaPercepcion;
                                percepcionExcedente.EsGrabable = excedente.Percepciones_ctPercepcion.EsGravable;

                                percepcionExcedente.Importe = Decimal.Round((decimal)costos.CostoEficienciaExcedente * NominaTrabajador.HorasTrabajadasExcedentes * 2, 4);

                                percepcionExcedente.EsPrevisionSocial = excedente.Percepciones_ctPercepcion.EsPrevisionSocial;
                            }

                            if (percepcion.Importe > 0)
                                NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                            if (percepcionExcedente.Importe > 0)
                                NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcionExcedente);

                       
                }
            }
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }
    }

}