﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Percepciones
{

    public class DiaEmpleadoCECyTE : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.ValidarEmpleadoRestriccionSincuota(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador, ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador))
                if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍA DEL EMPLEADO CECyTE").FirstOrDefault() != null)
            {
                if (NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes == "09")
                    if (ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.EsCuotaSindical==true)
                {
                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                    if (costos == null) throw new ApplicationException("No existe costo-hora-jornada para la categoría: " + ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.ToString());

                    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                    percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    percepcion.IdNomina = NominaTrabajador.IdNomina;
                    percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍA DEL EMPLEADO CECyTE").FirstOrDefault().IdPlantillaNominaPercepcion;
                    percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍA DEL EMPLEADO CECyTE").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                    decimal Sueldodiario = 0M;
                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral.Contains("DOCENTE"))
                    {
                        //Sueldo tabular
                        Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPrima.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().ImporteSinMatQuin;
                    }
                    else
                    {
                        Sueldodiario = NominaTrabajador.Truncate(costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora, 2);
                    }

                    var trabajadorconprestacionescongasto = NominaTrabajador.TrabajadoresConPercepcionesCongasto.Where(f => f.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                    if (trabajadorconprestacionescongasto != null)
                    {
                        var apoyoNomina = NominaTrabajador.ListaNominaApoyoEstudios.Where(z => z.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                        Decimal PorcentajeApoyo = 0M;
                        if (apoyoNomina != null)
                            PorcentajeApoyo = apoyoNomina.PorcentajeApoyo;

                        var GASTO = NominaTrabajador.PercepcionPersonalizada.Where(c => c.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault();

                        if (PorcentajeApoyo > 0)
                            GASTO.Importe = (PorcentajeApoyo * GASTO.Importe) / 100;

                        var diariogastoadministrativo = (GASTO.Importe / 15) ;

                        

                        //DÍA DEL EMPLEADO CECyTE GASTO ADMINISTRATIVO
                        var diagtoadmivo=NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍA DEL EMPLEADO CECyTE GASTO ADMINISTRATIVO").FirstOrDefault();
                        if (diagtoadmivo != null)
                        {
                            PercepcionesNominaTrabajador percepcionGasto = new PercepcionesNominaTrabajador();

                            percepcionGasto.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            percepcionGasto.IdNomina = NominaTrabajador.IdNomina;
                            percepcionGasto.IdPlantillaNominaPercepcion = diagtoadmivo.IdPlantillaNominaPercepcion;
                            percepcionGasto.EsGrabable = diagtoadmivo.Percepciones_ctPercepcion.EsGravable;
                            percepcionGasto.EsPrevisionSocial = diagtoadmivo.Percepciones_ctPercepcion.EsPrevisionSocial;
                            percepcionGasto.Importe = diariogastoadministrativo;
                            NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcionGasto);
                        }

                    }
                        percepcion.Importe = Sueldodiario;
                    //percepcion.Importe = costos.CostoPorHora * costos.Catalogos_ctJornadaLaboral.HorasMaximo;

                    //var idpercesueldo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().IdPlantillaNominaPercepcion;
                    //percepcion.Importe = NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    //&& z.IdPlantillaNominaPercepcion == idpercesueldo).FirstOrDefault().Importe / 15;

                    percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍA DEL EMPLEADO CECyTE").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                }
            }
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }
    }

}