﻿using Nova.Models.Nomina;
using Seguridad;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
 

namespace Nova.Models.Calculos.Percepciones
{
    public class DevolucionesDeFaltasBase : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            TimeSpan intervalo;
            int diasfaltas = 0;
            int totaldiasfaltas = 0;

            if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
            {
                var faltastrabajador = NominaTrabajador.DevolucionesFaltasTrabajador.ToList();
                var diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador
                    .FirstOrDefault(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS")?.Importe ?? 0;
                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes
                    .FirstOrDefault(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria);

                foreach (var item in faltastrabajador)
                {
                    int diasn = 15;
                    intervalo = item.FechaTermino.Value - item.FechaInicio;
                    diasfaltas = Convert.ToInt32(intervalo.TotalDays) + 1;
                    totaldiasfaltas += diasfaltas;

                    // EFICIENCIA EN EL TRABAJO
                    if (NominaTrabajador.PlantillaNominaPercepciones.Any(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO"))
                    {
                        PercepcionesNominaTrabajador percepcionEficiencia = new PercepcionesNominaTrabajador();

                        if (diaslaborados < diasn)
                        {
                            percepcionEficiencia.Importe = ((costos.CostoEficienciaJornada * diaslaborados * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo) / diasn) * diasfaltas;
                        }
                        else
                        {
                            var existerenuncia = NominaTrabajador.BajasPorRenunciasEnlaQuincena
                                .FirstOrDefault(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria);

                            if (existerenuncia != null ||
                                ConvenioLaboralTrabajadorCategoria.FechaTermino < NominaTrabajador.Nomina_stNomina.FechaTermino ||
                                NominaTrabajador.Nomina_stNomina.FechaInicio.AddDays(1) == ConvenioLaboralTrabajadorCategoria.FechaInicio)
                            {
                                percepcionEficiencia.Importe = ((costos.CostoEficienciaJornada * diaslaborados * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo) / diasn) * diasfaltas;
                            }
                            else
                            {
                                percepcionEficiencia.Importe = ((costos.CostoEficienciaJornada * diasn * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo) / diasn) * diasfaltas;
                            }
                        }

                        // Configurar propiedades
                        ConfigurarPercepcion(percepcionEficiencia, ConvenioLaboralTrabajadorCategoria, NominaTrabajador, "EFICIENCIA EN EL TRABAJO");

                        // Actualizar o agregar percepción
                        ActualizarOAgregarPercepcion(NominaTrabajador, percepcionEficiencia);
                    }

                    // AYUDA PARA TRANSPORTE
                    if (NominaTrabajador.PlantillaNominaPercepciones.Any(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE"))
                    {
                        PercepcionesNominaTrabajador percepcionAyuda = new PercepcionesNominaTrabajador();

                        if (diaslaborados < diasn)
                        {
                            percepcionAyuda.Importe = ((costos.CostoAyudaTransporte * diaslaborados * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo) / diasn) * diasfaltas;
                        }
                        else
                        {
                            var existerenuncia = NominaTrabajador.BajasPorRenunciasEnlaQuincena
                                .FirstOrDefault(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria);

                            if (existerenuncia != null ||
                                ConvenioLaboralTrabajadorCategoria.FechaTermino < NominaTrabajador.Nomina_stNomina.FechaTermino ||
                                NominaTrabajador.Nomina_stNomina.FechaInicio.AddDays(1) == ConvenioLaboralTrabajadorCategoria.FechaInicio)
                            {
                                percepcionAyuda.Importe = ((costos.CostoAyudaTransporte * diaslaborados * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo) / diasn) * diasfaltas;
                            }
                            else
                            {
                                percepcionAyuda.Importe = ((costos.CostoAyudaTransporte * diasn * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo) / diasn) * diasfaltas;
                            }
                        }

                        // Configurar propiedades
                        ConfigurarPercepcion(percepcionAyuda, ConvenioLaboralTrabajadorCategoria, NominaTrabajador, "AYUDA PARA TRANSPORTE");

                        // Actualizar o agregar percepción
                        ActualizarOAgregarPercepcion(NominaTrabajador, percepcionAyuda);
                    }

                    // QUINQUENIO
                    if (NominaTrabajador.PlantillaNominaPercepciones.Any(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO"))
                    {
                        PercepcionesNominaTrabajador percepcionQuinquenio = new PercepcionesNominaTrabajador();

                        var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones
                            .FirstOrDefault(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO")?.IdPlantillaNominaPercepcion;

                        var importequinquenio = NominaTrabajador.ListaPercepcionesTrabajadores
                            .FirstOrDefault(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                            && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion);

                        if (importequinquenio != null)
                        {
                            percepcionQuinquenio.Importe = (importequinquenio.Importe / diaslaborados) * diasfaltas;
                        

                        // Configurar propiedades
                        ConfigurarPercepcion(percepcionQuinquenio, ConvenioLaboralTrabajadorCategoria, NominaTrabajador, "QUINQUENIO");

                        // Actualizar o agregar percepción
                        ActualizarOAgregarPercepcion(NominaTrabajador, percepcionQuinquenio);
                        }
                    }

                    // SUELDO
                    if (!NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
                    {
                        PercepcionesNominaTrabajador percepcionSueldo = new PercepcionesNominaTrabajador();
                        percepcionSueldo.Importe = costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora * diasfaltas;

                        // Configurar propiedades
                        ConfigurarPercepcion(percepcionSueldo, ConvenioLaboralTrabajadorCategoria, NominaTrabajador, "SUELDO");

                        // Actualizar o agregar percepción
                        ActualizarOAgregarPercepcion(NominaTrabajador, percepcionSueldo);
                    }
                }
            }
        }

        // Método para configurar las propiedades comunes de la percepción
        private void ConfigurarPercepcion(PercepcionesNominaTrabajador percepcion, Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string conceptoPercepcion)
        {
            percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
            percepcion.IdNomina = NominaTrabajador.IdNomina;
            var idPercepcion = NominaTrabajador.PlantillaNominaPercepciones
                .FirstOrDefault(x => x.Percepciones_ctPercepcion.Percepcion == conceptoPercepcion);
            percepcion.IdPlantillaNominaPercepcion = (short)NominaTrabajador.PlantillaNominaPercepciones
                .FirstOrDefault(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN FALTA")?.IdPlantillaNominaPercepcion;

            
            percepcion.EsDevolucionFaltas = true;
            percepcion.Tipo = "NORMAL";
            var percepcionDevFalta = NominaTrabajador.PlantillaNominaPercepciones
                .FirstOrDefault(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN FALTA")?.Percepciones_ctPercepcion;
            percepcion.EsGrabable = percepcionDevFalta?.EsGravable ?? false;
            percepcion.EsVariable = percepcionDevFalta?.EsVariable ?? false;
            percepcion.EsPrevisionSocial = percepcionDevFalta?.EsPrevisionSocial ?? false;

            percepcion.Concepto = $"{idPercepcion?.Percepciones_ctPercepcion.Percepcion}";
        }

        // Método para actualizar o agregar la percepción
        private void ActualizarOAgregarPercepcion(Nomina_stNominaTrabajador NominaTrabajador, PercepcionesNominaTrabajador percepcion)
        {
            var percepcionExistente = NominaTrabajador.ListaPercepcionesTrabajadores
                .FirstOrDefault(p => p.IdConvenioLaboralTrabajadorCategoria == percepcion.IdConvenioLaboralTrabajadorCategoria
                    && p.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion
                    && p.EsDevolucionFaltas == percepcion.EsDevolucionFaltas
                    && p.Concepto == percepcion.Concepto);

            if (percepcionExistente != null)
            {
                percepcionExistente.Importe += percepcion.Importe;
            }
            else
            {
                if (percepcion.Importe>0)
                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
            }
        }

    }
}