﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
namespace Nova.Models.Calculos.Percepciones
{
    
    public class ApoyoConvivio : IPercepcionBehavior
    {

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            //if (NominaTrabajador.ValidarEmpleadoRestriccionSincuota(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador, ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador))
                if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO PARA CONVIVIO DE FIN DE AÑO").FirstOrDefault() != null)
            {
                var percepcionCalculo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => !x.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && x.Percepciones_ctPercepcion.Percepcion == "APOYO PARA CONVIVIO DE FIN DE AÑO").FirstOrDefault();


                if (percepcionCalculo.Calcular || AyudaDespensaExcepciones.Calcular(ConvenioLaboralTrabajadorCategoria))
                {
                    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


                    var diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;

                    percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    percepcion.IdNomina = NominaTrabajador.IdNomina;
                    percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO PARA CONVIVIO DE FIN DE AÑO").FirstOrDefault().IdPlantillaNominaPercepcion;
                    percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO PARA CONVIVIO DE FIN DE AÑO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                    percepcion.Importe = (decimal)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO PARA CONVIVIO DE FIN DE AÑO").FirstOrDefault().Importe;

                    if (diaslaborados < 15 && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONFIANZA"))
                        diaslaborados = 15;

                    if (diaslaborados < NominaTrabajador.DiasNomina)
                        percepcion.Importe = (diaslaborados * percepcion.Importe) / 15;
                    else

                    {
                        var existerenuncia = NominaTrabajador.BajasPorRenunciasEnlaQuincena.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                        if (existerenuncia != null || ConvenioLaboralTrabajadorCategoria.FechaTermino < NominaTrabajador.Nomina_stNomina.FechaTermino || NominaTrabajador.Nomina_stNomina.FechaInicio.AddDays(1) == ConvenioLaboralTrabajadorCategoria.FechaInicio)
                            percepcion.Importe = (diaslaborados * percepcion.Importe) / 15;
                        else
                            percepcion.Importe = (15 * percepcion.Importe) / 15;
                    }


                    percepcion.Tipo = "NORMAL";
                    percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO PARA CONVIVIO DE FIN DE AÑO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                    percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO PARA CONVIVIO DE FIN DE AÑO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);

                }
            }
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

    }
}