﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Libraries;
using Dapper;

namespace Nova.Models.Calculos.Percepciones
{
    public class AjusteDiasCalendarioGastoAdministrativo : IPercepcionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE DIAS DE CALENDARIO GASTO ADMINISTRATIVO").FirstOrDefault() != null)
            {
                int diasAjuste = 0;
                bool calcular = false;
                int añocalculo = 0;
                var ajuste = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE DIAS DE CALENDARIO GASTO ADMINISTRATIVO").FirstOrDefault();

                if (NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "24")

                {
                    //   calcular = true;
                    añocalculo = NominaTrabajador.Nomina_stNomina.Año;
                }
                //else
                if (NominaTrabajador.Nomina_PartesProporcionales.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault() != null
                    && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud)
                {
                    var pp = NominaTrabajador.Nomina_PartesProporcionales.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                    if (pp != null)
                        if (!NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONFIANZA"))
                        {
                            calcular = true;
                            añocalculo = pp.Año;
                        }
                        else
                        {
                            //if (pp.Año <= 2020)
                            //{
                            //    calcular = true;
                            //    añocalculo = pp.Año;
                            //}


                        }
                }
                else
                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "CONFIANZA")
                {  // solo oficinas centrales
                    var plaza = NominaTrabajador.Plazas_stDistribucionPlazaCategoria.Where(q => q.IdDistribucionPlazaCategoria == ConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria).FirstOrDefault();
                    // solo oficinas centrales
                    var convenioltc = NominaTrabajador.ConveniosTrabajadoresTodos.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                    if (convenioltc.Catalogos_ctEstructuraOrganica.IdModalidadEstudio == 0)
                        if (plaza.Plazas_ctCategoria.Categoria == "COORDINADOR DE TÉCNICOS ESPECIALIZADOS"
                        || plaza.Plazas_ctCategoria.Categoria == "SUPERVISOR"
                        || plaza.Plazas_ctCategoria.Categoria == "SECRETARIA DE DIRECTOR DE ÁREA"
                        || plaza.Plazas_ctCategoria.Categoria == "INGENIERO EN SISTEMAS"
                        )
                            calcular = true;
                }
                else
                //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral != "CONTRATO")
                {
                    calcular = true;
                }

                int idtrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;

                //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral != "BASE" || añocalculo <= 2020)

                if (calcular)
                {
                    if (ajuste != null)
                        if (ajuste.Calcular)
                        {
                            DapperQuery dp = new DapperQuery("bdNovaEntities");




                            string query = @" select g.IdTrabajador,b.IdConvenioLaboralTrabajadorCategoria ,
                      min(a.FechaInicio)FechaInicio,MAX(a.FechaTermino)as FechaTermino,
                      max(SueldoDiario) SueldoDiario
                      from Nomina_stNomina a
                    inner join Nomina_stNominaTrabajador b on a.idnomina=b.IdNomina
                    inner join Nomina_ctPlantillaNomina c on c.IdPlantillaNomina=a.IdPlantillaNomina
                    inner join Nomina_stNominaTrabajadorEstatus d on d.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus
                    inner join Convenios_stConvenioLaboralTrabajadorCategoria f on f.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                    inner join Convenios_stConvenioLaboralTrabajador g on g.IdConvenioLaboralTrabajador =f.IdConvenioLaboralTrabajador
                    inner join Nomina_stNominaTrabajadorEstatusGrupo w on w.IdNominaTrabajadorEstatusGrupo=d.IdNominaTrabajadorEstatusGrupo
                    where a.EsCerrada=1 and   b.IdConvenioLaboralTrabajadorCategoria=" + ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria + @" and c.Plantilla like '%sueldo%'
                    and w.EstatusNominaGrupo='PARA PAGO' AND YEAR(A.FECHATERMINO)=" + añocalculo + @"
                    group by  g.IdTrabajador,b.IdConvenioLaboralTrabajadorCategoria order by g.IdTrabajador,b.IdConvenioLaboralTrabajadorCategoria ";


                            List<AjustesDiasCalendarioTrabajador> diasContratos = (List<AjustesDiasCalendarioTrabajador>)dp.connection.Query<AjustesDiasCalendarioTrabajador>(query.ToString());
                            decimal subtotal = 0;
                            dp.Close();

                            int diasfebrero = 0;
                            //bool existeterminooinicioenfebreo = false;
                            //bool existeDiasSinContrato = false;

                            DateTime fechaContratoAnterior = DateTime.Now;

                            //int contador = 0;

                            var trabajadorconprestacionescongasto = NominaTrabajador.TrabajadoresConPercepcionesCongasto.Where(f => f.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                            var apoyoNomina = NominaTrabajador.ListaNominaApoyoEstudios.Where(z => z.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                            Decimal PorcentajeApoyo = 0M;
                            Decimal Sueldodiario = 0M;

                            if (apoyoNomina != null)
                                PorcentajeApoyo = apoyoNomina.PorcentajeApoyo;

                            if (trabajadorconprestacionescongasto != null)
                            {

                                var GASTO = NominaTrabajador.PercepcionPersonalizada.Where(c => c.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault();

                                if (PorcentajeApoyo > 0)
                                    GASTO.Importe = (PorcentajeApoyo * GASTO.Importe) / 100;

                                Sueldodiario = (GASTO.Importe / 15);
                            }

                            if (trabajadorconprestacionescongasto != null)
                            {
                                //foreach (var item in diasContratos)
                                //{
                                // contador++;
                                // fechaContratoAnterior = ConvenioLaboralTrabajadorCategoria.FechaTermino.Value;

                                //if (contador > 1)
                                //{
                                //   var dias=(fechaContratoAnterior- item.FechaInicio).Days;
                                //    if (dias > 0)
                                //        existeDiasSinContrato=true;
                                //}

                                //if (item.FechaInicio.Month == 2 || item.FechaTermino.Month == 2)
                                //    existeterminooinicioenfebreo = true;


                                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                                {
                                    if (ConvenioLaboralTrabajadorCategoria.FechaTermino != null)
                                    {
                                        var fechanicio = ConvenioLaboralTrabajadorCategoria.FechaInicio;
                                        if (ConvenioLaboralTrabajadorCategoria.FechaInicio.Year < añocalculo)
                                            fechanicio = DateTime.Parse(añocalculo.ToString() + "-01-01");

                                        diasAjuste = Libraries.Meses.NumeroDeMesesCon31Dias(fechanicio, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value);
                                        var existeyaunajustedefeb = NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "diasfebreroAjuste" && a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                                        if (existeyaunajustedefeb == null)
                                        {
                                            diasfebrero = diasfebrero + Libraries.Meses.SumarDiasSiEsFebreroa30(fechanicio, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value);
                                            var diasf = Libraries.Meses.SumarDiasSiEsFebreroa30(fechanicio, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value);
                                            if (diasAjuste > diasf)
                                                diasAjuste = diasAjuste - diasf;
                                        }
                                        subtotal = subtotal + (Sueldodiario * diasAjuste);
                                    }
                                    else
                                    {
                                        var solicitud = NominaTrabajador.Nomina_PartesProporcionales.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                                        string sqlnomina = @"select b.* from Nomina_stNominaTrabajador a
  inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
where    EstatusNominaGrupo ='PARA PAGO' and b.EsCerrada=1 and year(b.fechainicio)=" + solicitud.Año + " and  c.Plantilla like '%sueldo%' and a.IdConvenioLaboralTrabajadorCategoria=" + ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria + "  order by b.fechatermino Asc";

                                        List<Nomina_stNomina> ultimanominas = (List<Nomina_stNomina>)dp.connection.Query<Nomina_stNomina>(sqlnomina).ToList();

                                        dp.Close();

                                        var fechanicio = ConvenioLaboralTrabajadorCategoria.FechaInicio;
                                        if (ConvenioLaboralTrabajadorCategoria.FechaInicio.Year < añocalculo)
                                            fechanicio = DateTime.Parse(añocalculo.ToString() + "-01-01");
                                        //double diasremanentes = 0;
                                        //TimeSpan Diff_dates = ultimanominas.LastOrDefault().FechaTermino.AddDays(1).Subtract(fechanicio);
                                        //diasremanentes = Diff_dates.Days;

                                        diasAjuste = Libraries.Meses.NumeroDeMesesCon31Dias(fechanicio, ultimanominas.LastOrDefault().FechaTermino);
                                        var existeyaunajustedefeb = NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "diasfebreroAjuste" && a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                                        if (existeyaunajustedefeb == null)
                                        {
                                            diasfebrero = diasfebrero + Libraries.Meses.SumarDiasSiEsFebreroa30(fechanicio, ultimanominas.LastOrDefault().FechaTermino);
                                            diasAjuste = diasAjuste - Libraries.Meses.SumarDiasSiEsFebreroa30(fechanicio, ultimanominas.LastOrDefault().FechaTermino);
                                        }
                                        //  var factor = (diasAjuste * 12) / 365;
                                        subtotal = subtotal + (Sueldodiario * diasAjuste);
                                    }
                                }
                                else
                                {
                                    DateTime fi;
                                    DateTime ft;

                                    if (ConvenioLaboralTrabajadorCategoria.FechaInicio.Year != NominaTrabajador.Nomina_stNomina.FechaInicio.Year)
                                    {
                                        fi = DateTime.Parse($"{NominaTrabajador.Nomina_stNomina.FechaInicio.Year}-01-01");
                                    }
                                    else
                                        fi = ConvenioLaboralTrabajadorCategoria.FechaInicio;

                                    if (ConvenioLaboralTrabajadorCategoria.FechaTermino == null)
                                    {
                                        ft = DateTime.Parse($"{NominaTrabajador.Nomina_stNomina.FechaInicio.Year}-12-31");
                                    }
                                    else
                                        ft = ConvenioLaboralTrabajadorCategoria.FechaTermino.Value;


                                    diasAjuste = Libraries.Meses.NumeroDeMesesCon31Dias(fi, ft);
                                    var existeyaunajustedefeb = NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "diasfebreroAjuste" && a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                                    if (existeyaunajustedefeb == null)
                                    {
                                        diasfebrero = diasfebrero + Libraries.Meses.SumarDiasSiEsFebreroa30(fi, ft);
                                        diasAjuste = diasAjuste - Libraries.Meses.SumarDiasSiEsFebreroa30(fi, ft);
                                    }


                                    subtotal = subtotal + (Sueldodiario * diasAjuste);
                                }
                            }

                            if (diasfebrero > 0)
                            {
                                VariablesNominaTrabajador vnt44 = new VariablesNominaTrabajador();
                                vnt44.Concepto = "diasfebreroAjuste";
                                vnt44.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                                vnt44.Importe = diasfebrero;
                                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt44);

                                //    var fechaniciofeb = DateTime.Parse(añocalculo.ToString() + "-02-01");
                                //var fechaterminofeb = DateTime.Parse(añocalculo.ToString() + "-02-"+ System.DateTime.DaysInMonth(añocalculo, 2).ToString());
                                //diasAjuste = diasAjuste - Libraries.Meses.SumarDiasSiEsFebreroa30(fechaniciofeb, fechaterminofeb);
                            }

                            decimal importeAjustes = 0;



                            if (!NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONTRATO"))
                            {
                                //busca si tiene mas de 2 contratos en el mismo año
                                var idspercepcionesaguinaldo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("AJUSTE DIAS DE CALENDARIO GASTO ADMINISTRATIVO")).Select(q => q.IdPlantillaNominaPercepcion).ToArray();

                                var existenaguinaldosdeconvenios = NominaTrabajador.ListaPercepcionesTrabajadores.Where(a => a.IdTrabajador == idtrabajador && idspercepcionesaguinaldo.Contains(a.IdPlantillaNominaPercepcion)).ToList();
                                foreach (var item in existenaguinaldosdeconvenios)
                                {
                                    importeAjustes = importeAjustes + item.Importe;
                                    NominaTrabajador.ListaPercepcionesTrabajadores.Remove(item);
                                }

                                subtotal = subtotal + importeAjustes;

                            }

                            if (subtotal > 0)
                            {
                                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();
                                percepcion.Importe = subtotal;
                                percepcion.IdTrabajador = idtrabajador;

                                percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                percepcion.IdNomina = NominaTrabajador.IdNomina;
                                percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE DIAS DE CALENDARIO GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaPercepcion;
                                percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE DIAS DE CALENDARIO GASTO ADMINISTRATIVO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                percepcion.EsImprimibleRecibo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE DIAS DE CALENDARIO GASTO ADMINISTRATIVO").FirstOrDefault().Percepciones_ctPercepcion.EsImprimible; ;
                                percepcion.Tipo = "NORMAL";
                                percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE DIAS DE CALENDARIO GASTO ADMINISTRATIVO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                percepcion.IdPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().IdPercepcion;
                                percepcion.Percepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;

                                NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                            }
                            else
                            if (diasAjuste < 0)
                            {
                                DeduccionesNominaTrabajador deduccioncuotafija = new DeduccionesNominaTrabajador();
                                deduccioncuotafija.EsImprimibleRecibo = true;
                                deduccioncuotafija.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                deduccioncuotafija.IdNomina = NominaTrabajador.Nomina.IdNomina;
                                deduccioncuotafija.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO").SingleOrDefault().IdPlantillaNominaDeduccion;
                                deduccioncuotafija.Importe = (subtotal * diasAjuste) * -1;
                                deduccioncuotafija.Concepto = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE DIAS DE CALENDARIO GASTO ADMINISTRATIVO").FirstOrDefault().Percepciones_ctPercepcion.Percepcion;
                                NominaTrabajador.ListaDeduccionesTrabajadores.Add(deduccioncuotafija);

                            }



                        }

                }

            }

           
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

    }
}