﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using DevExpress.XtraSpreadsheet.Model;
 

namespace Nova.Models.Calculos.Percepciones
{
    public class Aguinaldo : IPercepcionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string per = null)
        {
            if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Nomina_ctPlantillaNomina.CalculoPorSolicitud == false).FirstOrDefault() != null)
                if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO").FirstOrDefault() != null)
            {
                    try
                    {

                        var percepcionCalculo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO").FirstOrDefault();
                if (percepcionCalculo.Calcular)
                {

                    int idtrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                    //  string conveniolaboral = NominaTrabajador.ParametrosRelacionLaboral.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral;

                    if (NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes == "24")
                    {
                        decimal sueldobrutoqna24 = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);
                        var idquinqueniopercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault();
                        if (idquinqueniopercepcion != null)
                            sueldobrutoqna24 = sueldobrutoqna24 + NominaTrabajador.ListaPercepcionesTrabajadores.Where(g => g.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && idquinqueniopercepcion.IdPlantillaNominaPercepcion == g.IdPlantillaNominaPercepcion).Sum(r => r.Importe);


                        PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();
                        bdNovaEntities aa = new bdNovaEntities();
                        percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        percepcion.IdNomina = NominaTrabajador.IdNomina;
                        percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO").FirstOrDefault().IdPlantillaNominaPercepcion;
                        percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                            percepcion.IdPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().IdPercepcion;
                            percepcion.Percepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;

                                var añob = 365;
                                if (DateTime.IsLeapYear(NominaTrabajador.Nomina_stNomina.FechaTermino.Year))
                                    añob = 366;

                                int diasTrabajador = 0;

                                List<TrabajadorNominaParaAguinaldo> nominas = new List<TrabajadorNominaParaAguinaldo>();
                                //*************
                                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("GASTO ADMINISTRATIVO"))
                                {
                                    
                                          nominas = NominaTrabajador.TrabajadorNominaParaAguinaldoGastoAdmivo.Where(z => z.IdTrabajador == idtrabajador).ToList();

                                    var nominastodos = NominaTrabajador.TrabajadorNominaParaAguinaldo.Where(z => z.IdTrabajador == idtrabajador).ToList();
                                    var resumen = NominaTrabajador.ObtenerResumenQuincenal(nominastodos);

                                    // Para ver los días trabajados por un trabajador específico
                                    diasTrabajador = resumen
                                      .Where(r => r.IdTrabajador == idtrabajador)
                                      .Sum(r => r.DiasTrabajados);
                                }
                                else
                                {
                                      nominas = NominaTrabajador.TrabajadorNominaParaAguinaldo.Where(z => z.IdTrabajador == idtrabajador).ToList();
                                    var resumen = NominaTrabajador.ObtenerResumenQuincenal(nominas);

                                    // Para ver los días trabajados por un trabajador específico
                                    diasTrabajador = resumen
                                      .Where(r => r.IdTrabajador == idtrabajador)
                                      .Sum(r => r.DiasTrabajados);
                                }

                                decimal aguinaldo = 0;

                                int diasaguinaldotrabajados = 0;

                            

                                foreach (var item in nominas)
                                {

                                    
                                    string RelacionConvenioLaboral = item.RelacionConvenioLaboral;
                                    var aguinaldodias = NominaTrabajador.ParametrosRelacionesLaborales.Where(a => a.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral == RelacionConvenioLaboral).FirstOrDefault();
                                    int diasaguinaldo = 0;
                                    if (aguinaldodias != null)
                                        diasaguinaldo = aguinaldodias.DiasAguinaldo;
                                    else
                                        throw new ApplicationException("No existe configurado para este año los dias de aguinaldo para el convenio laboral : " + RelacionConvenioLaboral);

                                    decimal factore = (decimal)diasaguinaldo / añob;
                                    var salariodiario = item.Importe / item.DiasEfectivosLaborados;

                                    diasaguinaldotrabajados = diasaguinaldotrabajados + item.DiasEfectivosLaborados;

                                    int diascalendariolaboradosqna = ((item.FechaTermino - item.FechaInicio).Days + 1); // El +1 es para incluir el último día
                                    if (item.DiasEfectivosLaborados < 15 )
                                    {
                                        if (item.FechaTermino.Month == 2)
                                        {
                                            if (item.DiasEfectivosLaborados < 13)
                                            {
                                                diascalendariolaboradosqna = item.DiasEfectivosLaborados;
                                            }
                                        }
                                        else {
                                            diascalendariolaboradosqna = item.DiasEfectivosLaborados;
                                        }
                                    }

                                    percepcion.Importe = percepcion.Importe + ( salariodiario * diascalendariolaboradosqna * factore);

                                }



                                VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();
                                vnt4.Concepto = "DIAS AGUINALDO TRABAJADOS";
                                vnt4.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                vnt4.Importe = diasTrabajador;
                                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt4);

                                //****************


                                //var contratostrabajador = NominaTrabajador.ListaAguinaldoTrabajadores.Where(z => z.IdTrabajador == idtrabajador).ToList();
                                //foreach (var item in contratostrabajador)
                                //{


                                //    // Decimal SueldoBrutoQuinquenioDiarioCLTC = sueldobrutoqna24 + NominaTrabajador.ListaAguinaldoTrabajadores.Where(z => z.IdTrabajador == idtrabajador).Select(x => x.SueldoBrutoQuinquenioDiario).FirstOrDefault();
                                //    Decimal SueldoBrutoQuinquenioDiarioCLTC = 0;

                                //    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "DOCENTE")
                                //        SueldoBrutoQuinquenioDiarioCLTC = item.SueldoBrutoQuinquenioDiarioDocente;
                                //    else
                                //        SueldoBrutoQuinquenioDiarioCLTC = item.SueldoBrutoQuinquenioDiario;

                                //    //short diasefectivoslaborados = (short)(NominaTrabajador.ListaAguinaldoTrabajadores.Where(z => z.IdTrabajador == idtrabajador).Select(x => x.DiasEfectivosLaborados).FirstOrDefault());
                                //    short diasefectivoslaborados = 0;
                                //    short diascalendariolaborados = 0;

                                //            if (NominaTrabajador.EsProyeccion)
                                //                diasefectivoslaborados = 360;
                                //            else

                                //            {

                                //            diasefectivoslaborados = (short)(item.DiasEfectivosLaborados-item.DiasFaltas);
                                //            }

                                //            //diascalendariolaborados = item.DiasCalendarioLaborados;
                                //            diascalendariolaborados = (short)((item.FechaTermino - item.FechaInicio).Days + 1); // El +1 es para incluir el último día

                                //            Decimal SueldoQuinquenioDiario = SueldoBrutoQuinquenioDiarioCLTC / diasefectivoslaborados;

                                //    string RelacionConvenioLaboral = item.RelacionConvenioLaboral;
                                //    var aguinaldodias = NominaTrabajador.ParametrosRelacionesLaborales.Where(a => a.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral== RelacionConvenioLaboral).FirstOrDefault();
                                //    int diasaguinaldo = 0;
                                //    if (aguinaldodias != null)
                                //        diasaguinaldo = aguinaldodias.DiasAguinaldo;
                                //    else
                                //        throw new ApplicationException("No existe configurado para este año los dias de aguinaldo para el convenio laboral : " + RelacionConvenioLaboral);
                                //    //percepcion.Importe = - (ImporteFaltasTrabajadorAño + ImporteFaltasTrabajadorNominaActual);
                                //    decimal factor = 0;

                                //        //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AGUINALDO ESTATAL"))
                                //        //    diasaguinaldo = diasaguinaldo - 40;
                                //        //else
                                //        //    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("BASE"))
                                //        //        diasaguinaldo = diasaguinaldo - 50;



                                //             //factor = (diasefectivoslaborados * diasaguinaldo) / 360M;
                                //             factor = (diascalendariolaborados * diasaguinaldo) / añob;
                                //            percepcion.Importe = percepcion.Importe + (SueldoQuinquenioDiario * factor);

                                //    //switch (conveniolaboral)
                                //    //{

                                //    //    case "MANDO MEDIO Y SUPERIOR":
                                //    //        factor = (diasefectivoslaborados * diasaguinaldo) / 360M;
                                //    //        percepcion.Importe = percepcion.Importe + (SueldoQuinquenioDiario * factor);
                                //    //        break;
                                //    //    case "CONFIANZA":
                                //    //        factor = (diasefectivoslaborados * diasaguinaldo) / 360M;
                                //    //        percepcion.Importe = percepcion.Importe+(SueldoQuinquenioDiario * factor);
                                //    //        break;
                                //    //    case "ADMINISTRATIVO-BASE":
                                //    //        factor = (diasefectivoslaborados * diasaguinaldo) / 360M;
                                //    //        percepcion.Importe = percepcion.Importe + (SueldoQuinquenioDiario * factor);
                                //    //        break;
                                //    //    case "ADMINISTRATIVO DEFINITIVO-BASE":
                                //    //        factor = (diasefectivoslaborados * diasaguinaldo) / 360M;
                                //    //        percepcion.Importe = percepcion.Importe+(SueldoQuinquenioDiario * factor);
                                //    //        break;
                                //    //    case "CONTRATO":
                                //    //        factor = (diasefectivoslaborados * diasaguinaldo) / 360M;
                                //    //        percepcion.Importe = percepcion.Importe+(SueldoQuinquenioDiario * factor);
                                //    //        break;
                                //    //    default:
                                //    //        break;
                                //    //}
                                //}

                                percepcion.Importe = percepcion.Importe - (30 * NominaTrabajador.ctUMA.Monto);
                        percepcion.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                if (percepcion.Importe>0)
                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);

                                if (!NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("GASTO ADMINISTRATIVO"))
                                {

                                    PercepcionesNominaTrabajador percepcion1 = new PercepcionesNominaTrabajador();

                                    percepcion1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    percepcion1.IdNomina = NominaTrabajador.IdNomina;
                                    percepcion1.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO EXENTO").FirstOrDefault().IdPlantillaNominaPercepcion;
                                    percepcion1.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO EXENTO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                    percepcion1.Importe = (30 * NominaTrabajador.ctUMA.Monto);
                                    percepcion1.EsPrevisionSocial = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO EXENTO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                    if (percepcion1.Importe > 0)
                                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion1);
                                }

                    }
                }

                    }
                    catch (Exception ex)
                    {

                        throw new Exception(ex.Message);
                    }
                }
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null, string concepto = null)
        {
            throw new NotImplementedException();
        }

        public void Grabar(Nomina_stNominaTrabajador NominaTrabajador)
        {
            throw new NotImplementedException();
        }

 
        void IPercepcionBehavior.Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste)
        {
            throw new NotImplementedException();
        }

      
    }
}