﻿using Dapper;
using DevExpress.CodeParser;
using DevExpress.Data.Mask;
using DevExpress.DataProcessing;
using DevExpress.DirectX;
using DevExpress.Web.ASPxHtmlEditor.Internal;
using DevExpress.XtraPrinting.Native;
using DevExpress.XtraRichEdit.Commands;
using DevExpress.XtraSpreadsheet.Model.History;
using DevExpress.XtraSpreadsheet.Utils;
using DocumentFormat.OpenXml.Office.CustomUI;
using FastMember;
using Microsoft.Ajax.Utilities;
using Nova.Libraries;
using Nova.Models.Calculos;
using Nova.Models.Calculos.Percepciones;
using Nova.Models.Calculos.SUA;
using Nova.Models.Nomina;
 
using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.Entity;
using System.Data.Entity.Core.EntityClient;
using System.Data.SqlClient;
using System.Globalization;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using System.Transactions;
using System.Web;
using static Nova.Models.PlantillasNomina;

namespace Nova.Models
{
    public partial class Nomina_stNominaTrabajador : NominaLogger
    {


        private Logger LogProcesos = new Logger();
        public int IdNominaTrabajadorEstatusRecalculo = 0;
        public long IdNominaTrabajadorRecalculo = 0;
        public int? IdAjustePresupuestalRecalculo = 0;
        public bool EsRecalculoPorTrabajador = false;
        public int MotivoDevolucionId = 0;
        public bool EsProyeccion = false;
        public bool CerrarNomina = false;
        public bool NoResetAntiguedad = false;
        public bool EsCalculoUnSoloTrabajador = false;

        public volatile bool BorradoCompletado = false;

        public volatile bool ProcesoHorariosCompletado = false;
        public volatile bool ProcesoHorariosCompletadoAjustes = false;
        public volatile bool ProcesoAntiguedaCompletado = false;
        public volatile bool ProcesoDiasTrabajadosCompletado = false;

        public List<Nomina_stNominaTrabajador> Nomina_stNominaTrabajadorLista = new List<Nomina_stNominaTrabajador>();

        public DateTime HoraInicioBorrar;
        public DateTime HoraFinBorrar;

        public DateTime HoraInicioProceso;
        public DateTime HoraFinProceso;

        public DateTime HoraInicioGuardar;
        public DateTime HoraFinGuardar;

        public string ProcesoCadena;



        public short IdCicloEscolarVigentePlantel;
        public short IdCicloEscolarAnteriorPlantel;

        public string CicloEscolarVigentePlantel;
        public string CicloEscolarAnteriorPlantel;
        public short IdCicloEscolarVigenteEmsad;
        public short IdCicloEscolarAnteriorEmsad;

        public List<stHorarioNomina> DocentesHorasAPagar = new List<stHorarioNomina>();


        public List<Nomina_DocentesHorasPago> ListaNomina_DocentesHorasPago= new List<Nomina_DocentesHorasPago>();

        public List<NominaHorariosDocentesDetalle> NominaHorariosDocentesDetalle;
        public List<NominaHorariosDocentesDetalle> NominaHorariosDocentesDetallePorFecha;
        public string QueryHorariosDocentesDetalle;

        public List<HorasPorDocente> ListaHorasPorDocente;
        public List<NominasAnterioresPagadas> NominasAnterioresPagadas;
        public List<vwLicenciasTrabajadores> LicenciasTrabajadores;
        public List<ConvenioLaboralTrabajadorCategoriaPlazas> Convenios;
        public List<NominaHorariosDocentesDetalle> HorariosPagadoDocentes;
        public List<HorasDocentesPorCiclo> HorasDocentesPorCiclo;
      



        List<ContratoSegunNomina> ConveniosVigentesSegunNominas;

        List<IncidenciaPermiso_stIncidenciaTrabajador> LicenciasSinGoceSueldoSegunNominas;
        List<IncidenciaPermiso_stIncidenciaTrabajador> AjustesLicenciasSinGoceSueldoSegunNominas = new List<IncidenciaPermiso_stIncidenciaTrabajador>();
        List<IncidenciaComision> LicenciasPorCambiodeNominas;

        List<ResultadoMetodoDiasDePago> resultadoMetodoDiasDePago;

        public List<NominaHorariosDocentesDetalle> NominaHorariosDocentesDetalleAnterior;
        public List<ctCicloescolar> ctCicloescolar;

        public List<HorariosVigenteAnteriorDiferencias> HorariosVigenteAnteriorDiferencias;

        public List<stHorariosDetalleNomina> ListastHorariosDetalleNomina;

        public List<Nomina_stNominaTrabajador> ListaDocentesConPosibleAjusteSueldo = new List<Nomina_stNominaTrabajador>();

        public List<Kardex_ctTrabajador> ListaCambiosdeContratos = new List<Kardex_ctTrabajador>();

        public HorariosVigenteAnterior HorariosVigenteAnteriorTrabajador = new HorariosVigenteAnterior();

        public List<NominaNominaHorariosDocentes> HorariosUtilizadosParaNomina = new List<NominaNominaHorariosDocentes>();


        public List<Nomina_ApoyoEstudios> ListaNominaApoyoEstudios;

        public List<SalariosDiarioDocentesParaPrima> SalariosDiarioDocentesParaPrima;
        public List<SalariosDiarioDocentesParaPrima> SalariosDiarioDocentesParaPrimaHorasExtras;

        public List<SalariosDiarioDocentesParaPrima> SalariosDiarioDocentesParaPartesProporcionales;



        public List<SdiImportesVariables> SdiImportesVariablesTrabajadores;
        public List<Percepciones_stNominaTrabajadorPercepcionesRDLBimestre> SdiImportesVariablesRDL;




        public List<AjustesSueldoTrabajador> ListaDocentesConAjusteSueldo = new List<AjustesSueldoTrabajador>();
        public List<Nomina_stQuinquenioConfianza> TrabajadoresQuinquenioConfianza = new List<Nomina_stQuinquenioConfianza>();
        public List<Percepciones_stPercepcionesConcedidas> TrabajadoresConPercepcionesCongasto = new List<Percepciones_stPercepcionesConcedidas>();

        public List<IncidenciaPermiso_stIncidenciaTrabajador> TrabajadoresConPrimaDominical = new List<IncidenciaPermiso_stIncidenciaTrabajador>();
        public List<IncidenciaPermiso_stIncidenciaTrabajador> TrabajadoresConDiasDescanso = new List<IncidenciaPermiso_stIncidenciaTrabajador>();

        public List<Percepciones_stPlantillaNominaPercepciones> PercepcionesPlantillaRetroActivo = new List<Percepciones_stPlantillaNominaPercepciones>();

        public List<Convenios_stConvenioLaboralTrabajadorCategoria> TrabajadoresConCalculoConFechaAnterior = new List<Convenios_stConvenioLaboralTrabajadorCategoria>();

        public List<Catalogos_ctTipoCredito> Catalogos_ctTipoCredito = new List<Catalogos_ctTipoCredito>();

        public List<Nomina_PartesProporcionales> Nomina_PartesProporcionales = new List<Nomina_PartesProporcionales>();
        public List<PartesProporcionalesUltimoContrato> PartesProporcionalesUltimoContrato = new List<PartesProporcionalesUltimoContrato>();


        public List<vwLicenciasTrabajadores> LicenciasTrabajadoresPrimavacacional = new List<vwLicenciasTrabajadores>();
        public List<vwLicenciasTrabajadores> LicenciasTrabajadoresDiasEconomicosPuntualidad = new List<vwLicenciasTrabajadores>();

        public List<vwLicenciasTrabajadores> LicenciasTrabajadoresIncapacidades = new List<vwLicenciasTrabajadores>();

        public List<Nomina_TrabajadoresPrimerPagoControl> ListaTrabajadoresPrimerPagoControl = new List<Nomina_TrabajadoresPrimerPagoControl>();

        public List<PuntualidadYAsistenciaPerdidas> TrabajadoresPuntualidadYAsistenciaPerdidas = new List<PuntualidadYAsistenciaPerdidas>();
        public List<PuntualidadYAsistenciaPerdidas> TrabajadoresPuntualidadYAsistenciaPerdidasAñoAnterior = new List<PuntualidadYAsistenciaPerdidas>();
        public List<PuntualidadYAsistenciaPerdidas> TrabajadoresPuntualidadYAsistenciaPerdidasPorMes = new List<PuntualidadYAsistenciaPerdidas>();
        public List<PuntualidadYAsistenciaPerdidas> TrabajadoresPuntualidadYAsistenciaPerdidasPorMesAñoAnterior = new List<PuntualidadYAsistenciaPerdidas>();

        public List<DiasEconomicosDisfrutados> diasdifrutados = new List<DiasEconomicosDisfrutados>();
        public List<DiasEconomicosDisfrutados> DiasEconomicosDifrutadosAñoAnterior = new List<DiasEconomicosDisfrutados>();

        public List<Nomina_AnticipoAguinaldo> TrabajadoresConAnticipoAguinaldo = new List<Nomina_AnticipoAguinaldo>();
        public List<Percepciones_stUtilesEscolares> TrabajadoresConUtilesEscolares = new List<Percepciones_stUtilesEscolares>();

        public List<Plazas_ctCategoria> Plazas_ctCategoria = new List<Plazas_ctCategoria>();

        public List<Convenios_stConvenioLaboralTrabajadorCategoria> ListaLicenciasVigentesTrabajadores = new List<Convenios_stConvenioLaboralTrabajadorCategoria>();
        public List<Plazas_stDistribucionPlazaCategoria> Plazas_stDistribucionPlazaCategoria = new List<Plazas_stDistribucionPlazaCategoria>();

        public Boolean TrabajadorConIncapacipdadActiva = false;


        public string TrabajadorConIncapacipdadActivaConcepto = "";

        public Boolean TrabajadorConTerminodeSaldoIncapacidad = false;

        public Boolean TrabajadorTerminaGuarderiaQuincenaActual = false;
        public Decimal TrabajadorTotalPercepcionesGuarderiaOrdinarias = 0M;

        List<ComparativoHoras> ListaComparativoHoras = new List<ComparativoHoras>();

        public List<long> ListaNominaSueldoValidarIsr = new List<long>();

        public int diasBimestre { get; set; } = 0;



        public List<vwDatosAspirantesTrabajadores> LicenciasVigentesYProximasTrabajadores = new List<vwDatosAspirantesTrabajadores>();

        public List<Nomina_ctTipoPartesProporcionales> Nomina_ctTipoPartesProporcionales = new List<Nomina_ctTipoPartesProporcionales>();

        public List<Nomina_PagosDiasEconomicosyPuntualidad> Nomina_PagosDiasEconomicosyPuntualidad = new List<Nomina_PagosDiasEconomicosyPuntualidad>();
        public List<Nomina_PagosDiasEconomicosyPuntualidad> Lista_PagosDiasEconomicosyPuntualidad = new List<Nomina_PagosDiasEconomicosyPuntualidad>();

        public TrabajadorAntiguedad TrabajadorAntiguedad = new TrabajadorAntiguedad();
        public TrabajadorAntiguedad QuinquenioTrabajadorAntiguedad = new TrabajadorAntiguedad();


        public  bool DeberiaRecibirPagoEnEstaNomina(DateTime fechaIngreso, DateTime inicioNomina, DateTime finNomina)
        {
            // Obtener el año de la nómina actual
            int anioNomina = inicioNomina.Year;

            // Calcular la fecha de aniversario para el año de la nómina
            DateTime fechaAniversario = new DateTime(anioNomina, fechaIngreso.Month, fechaIngreso.Day);

            // Si el aniversario ya pasó este año, ajustar al próximo año
            if (fechaAniversario < inicioNomina)
            {
                fechaAniversario = fechaAniversario.AddYears(1);
            }

            // Caso 1: El aniversario cae en la primera quincena del mes actual
            if (fechaAniversario.Month == inicioNomina.Month && fechaAniversario.Day <= 15
                //&& inicioNomina.Day == 16 && finNomina.Day == 31)
                //&& inicioNomina.Day == 16 && finNomina.Day == 31)
                && inicioNomina.Day == 16 )
            {
                return true;
            }

            // Caso 2: El aniversario cae en la segunda quincena del mes anterior
            if (fechaAniversario.Month == inicioNomina.AddMonths(-1).Month && fechaAniversario.Day > 15
                && inicioNomina.Day == 1 && finNomina.Day == 15)
            {
                return true;
            }

            // En cualquier otro caso, no se paga en esta nómina
            return false;
        }

        public static IEnumerable ObtenerUltimaProyeccion()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            var datos = @"select Año,Mes,QuincenaMes,Plantilla,Percepcion,SUM(a.Importe) as Importe,max(cast (b.EsCerrada as smallint)) EsCerrada
 FROM Percepciones_Proyeccion a 
inner join Nomina_stProyeccion b on a.idproyeccion=b.idproyeccion
inner join Percepciones_stPlantillaNominaPercepciones c on c.IdPlantillaNominaPercepcion=a.IdPlantillaNominaPercepcion
inner join Percepciones_ctPercepcion f on f.IdPercepcion=c.IdPercepcion
inner join Catalogos_ctQuincenaMes t on t.IdQuincenaMes=b.IdQuincenaMes
inner join Catalogos_ctMes r on t.IdMes=r.IdMes
inner join Nomina_ctPlantillaNomina h on h.IdPlantillaNomina=c.IdPlantillaNomina
where 
 b.EsCerrada=0
 group by Año,Mes,QuincenaMes,Plantilla,Percepcion";
            var regresa = dp.connection.Query(datos);
            dp.Close();
            return regresa;

        }

        private int VerificaDiasPrimaBaja(int mesinicial, int mesfinal, int qnainicial, int qnafinal, DateTime FechaBaja)
        {
            int dias = 0;


            int periodoinicialconta = mesinicial;


            int incremento = 0;

            for (int i = qnainicial; i < qnafinal; i++)
            {

                int dia = 1;

                if (Convert.ToInt16(i) % 2 != 0)
                {
                    dia = 1;
                }
                else
                {

                    dia = 16;
                }

                incremento = incremento + 1;

                if (incremento > 2)
                    periodoinicialconta = periodoinicialconta + 1;

                DateTime fecha = new DateTime(this.Nomina_stNomina.FechaTermino.Year, periodoinicialconta, dia);
                int res = DateTime.Compare(FechaBaja, fecha);

                if (FechaBaja < fecha)
                {
                    dias = dias + 1;

                }



            }
            return dias;
        }

        public int DiasEconomicosADescontarPorLicencias(DateTime FechaRegreso, DateTime FechaInicio,int AñoAvalidar=0)
        {
            DateTime FechaNomina;
            if (AñoAvalidar > 0)
                FechaNomina = DateTime.Parse($"{AñoAvalidar}-12-31");
            else
                FechaNomina = this.Nomina_stNomina.FechaTermino;

            const int DiasVacacionalAnuales = 12; // 12 días de prima vacacional al año
            var meses = new Dictionary<string, string>
    {
        { "01", "Enero" }, { "02", "Febrero" }, { "03", "Marzo" }, { "04", "Abril" },
        { "05", "Mayo" }, { "06", "Junio" }, { "07", "Julio" }, { "08", "Agosto" },
        { "09", "Septiembre" }, { "10", "Octubre" }, { "11", "Noviembre" }, { "12", "Diciembre" }
    };

            // Si la fecha de regreso es de un año anterior al de la nómina, empezar a contar desde enero
            int mesInicio = FechaInicio.Month;
            if (FechaInicio.Year < FechaNomina.Year)
                mesInicio = 1; // Enero

            int diasDescontados = 0;
            for (int mes = mesInicio; mes <= 12; mes++)
            {
                // Si el mes de la fecha de regreso es mayor al mes actual, descontar 1 día
                if (FechaRegreso.Month >= mes)
                    diasDescontados++;
            }

            // Asegurarse de que no se descuenten más días de los 12 totales
            return Math.Min(diasDescontados, DiasVacacionalAnuales);
        }


        //-----------------------

        public int CalcularDiasProporcionalesPuntualidad(DateTime FechaRegreso, DateTime? FechaInicio = null, List<PuntualidadYAsistenciaPerdidas> perdidas = null,DateTime? FechaNominaCalculo=null)
        {
            
            DateTime FechaNomina = this.Nomina_stNomina.FechaTermino;

            if (FechaNominaCalculo != null)
                FechaNomina = FechaNominaCalculo.Value;

                const int DiasPorPeriodo = 6; // Ajustado a 6 días por periodo

            var periodos = new Dictionary<string, List<Tuple<string, string>>>
    {
        { "enero_junio", new List<Tuple<string, string>>
            {
                Tuple.Create("01-01", "31-01"),
                Tuple.Create("01-02", "28-02"),
                Tuple.Create("01-03", "31-03"),
                Tuple.Create("01-04", "30-04"),
                Tuple.Create("01-05", "31-05"),
                Tuple.Create("01-06", "30-06")
            }
        },
        { "julio_diciembre", new List<Tuple<string, string>>
            {
                Tuple.Create("01-07", "31-07"),
                Tuple.Create("01-08", "31-08"),
                Tuple.Create("01-09", "30-09"),
                Tuple.Create("01-10", "31-10"),
                Tuple.Create("01-11", "30-11"),
                Tuple.Create("01-12", "31-12")
            }
        }
    };

            // Función auxiliar para determinar el periodo
            string GetPeriodo(DateTime fecha)
            {
                int mes = fecha.Month;
                if (mes >= 1 && mes <= 6)
                    return "enero_junio";
                else
                    return "julio_diciembre";
            }

            // Determinar el periodo de la nómina
            string periodoNomina = GetPeriodo(FechaNomina);
            string periodoRegreso = GetPeriodo(FechaRegreso);

            // Si la fecha de regreso es de un periodo anterior a la nómina actual, retornar 0
            if (FechaRegreso.Year < FechaNomina.Year ||
                (FechaRegreso.Year == FechaNomina.Year && periodoRegreso != periodoNomina))
            {
                return 0;
            }

            // Si estamos en el mismo periodo y tenemos fecha de inicio
            if (FechaInicio.HasValue)
            {
                int mesesNoTrabajados = 0;
                string periodoActual = GetPeriodo(FechaRegreso);
                var mesesDelPeriodo = periodos[periodoActual];

                foreach (var mes in mesesDelPeriodo)
                {
                    var fechaInicioMes = DateTime.ParseExact($"{mes.Item1}-{FechaRegreso.Year}", "dd-MM-yyyy", null);
                    var fechaFinMes = DateTime.ParseExact($"{mes.Item2}-{FechaRegreso.Year}", "dd-MM-yyyy", null);

                    

                    
                    // Si el mes está completamente dentro del periodo de licencia
                    if ((FechaInicio.Value <= fechaFinMes && FechaRegreso >= fechaInicioMes) )
                    {
                        // Comprobar si el mes está en la lista de pérdidas
                        bool esMesPerdido = perdidas?.Any(p => p.Meses == FechaInicio.Value.Month) ?? false;
                        bool esMesPerdidoFin = perdidas?.Any(p => p.Meses == FechaRegreso.Month) ?? false;
                        if (!esMesPerdido && !esMesPerdidoFin)
                        {
                            mesesNoTrabajados++;
                        }

                        if (esMesPerdido)
                        {
                            perdidas?.ForEach(p =>
                            {
                                if (p.Meses == FechaInicio.Value.Month) // Ejemplo de condición
                                {
                                    p.Meses = 0;
                                }
                            });

                        }

                        if (esMesPerdidoFin)
                        {
                            perdidas?.ForEach(p =>
                            {
                                if (p.Meses == FechaRegreso.Month) // Ejemplo de condición
                                {
                                    p.Meses = 0;
                                }
                            });

                        }

                    }
                }

                // Cada mes vale 1 día (6 días / 6 meses = 1 día por mes)
                return mesesNoTrabajados;
            }

            // Si no hay fecha de inicio, retornamos 0
            return 0;
        }
        //----------------------------

        public int CalcularDiasProporcionalesPrima(DateTime FechaRegreso, DateTime? FechaInicio = null)
        {
            DateTime FechaNomina = this.Nomina_stNomina.FechaTermino;
            const int DiasPorPeriodo = 8;
            var periodos = new Dictionary<string, List<Tuple<string, string>>>
    {
        { "enero_abril", new List<Tuple<string, string>>
            {
                Tuple.Create("01-01", "15-01"), Tuple.Create("16-01", "31-01"),
                Tuple.Create("01-02", "15-02"), Tuple.Create("16-02", "28-02"),
                Tuple.Create("01-03", "15-03"), Tuple.Create("16-03", "31-03"),
                Tuple.Create("01-04", "15-04"), Tuple.Create("16-04", "30-04")
            }
        },
        { "mayo_agosto", new List<Tuple<string, string>>
            {
                Tuple.Create("01-05", "15-05"), Tuple.Create("16-05", "31-05"),
                Tuple.Create("01-06", "15-06"), Tuple.Create("16-06", "30-06"),
                Tuple.Create("01-07", "15-07"), Tuple.Create("16-07", "31-07"),
                Tuple.Create("01-08", "15-08"), Tuple.Create("16-08", "31-08")
            }
        },
        { "septiembre_diciembre", new List<Tuple<string, string>>
            {
                Tuple.Create("01-09", "15-09"), Tuple.Create("16-09", "30-09"),
                Tuple.Create("01-10", "15-10"), Tuple.Create("16-10", "31-10"),
                Tuple.Create("01-11", "15-11"), Tuple.Create("16-11", "30-11"),
                Tuple.Create("01-12", "15-12"), Tuple.Create("16-12", "31-12")
            }
        }
    };

            // Determinar el periodo de la nómina
            string periodoNomina = GetPeriodo(FechaNomina);
            string periodoRegreso = GetPeriodo(FechaRegreso);

            // Si la fecha de regreso es de un periodo anterior al de la nómina
            // o de un año anterior, retornar 0 días
            if (FechaRegreso.Year < FechaNomina.Year ||
                (FechaRegreso.Year == FechaNomina.Year && periodoRegreso != periodoNomina))
            {
                return 0;
            }

            // Si estamos en el mismo periodo y tenemos fecha de inicio
            if (FechaInicio.HasValue && GetPeriodo(FechaInicio.Value) == periodoNomina)
            {
                int quincenasTotales = periodos[periodoNomina].Count; // 8 quincenas en total
                int quincenasNoTrabajadas = 0;

                foreach (var quincena in periodos[periodoNomina])
                {
                    var fechaInicioQuincena = DateTime.ParseExact($"{quincena.Item1}-{FechaRegreso.Year}", "dd-MM-yyyy", null);
                    var fechaFinQuincena = DateTime.ParseExact($"{quincena.Item2}-{FechaRegreso.Year}", "dd-MM-yyyy", null);

                    // Si la quincena está completamente dentro del periodo de licencia
                    // o si la quincena se traslapa con el periodo de licencia
                    if ((FechaInicio.Value <= fechaFinQuincena && FechaRegreso >= fechaInicioQuincena))
                    {
                        quincenasNoTrabajadas++;
                    }
                }

                // Cada quincena vale 1 día (8 días / 8 quincenas = 1 día por quincena)
                return quincenasNoTrabajadas;
            }

            // Si no hay fecha de inicio, retornamos 0 para que no se reste nada
            return 0;
        }

        private string GetPeriodo(DateTime fecha)
        {
            if (fecha.Month >= 1 && fecha.Month <= 4)
                return "enero_abril";
            if (fecha.Month >= 5 && fecha.Month <= 8)
                return "mayo_agosto";
            return "septiembre_diciembre";
        }

        //public int CalcularDiasProporcionalesPrima(DateTime FechaRegreso)
        //{
        //    int DiasTotales = 8;
        //    var periodos = new Dictionary<string, List<Tuple<string, string>>>
        //    {
        //        { "enero_abril", new List<Tuple<string, string>>
        //            {
        //                Tuple.Create("01-01", "15-01"), Tuple.Create("16-01", "31-01"),
        //                Tuple.Create("01-02", "15-02"), Tuple.Create("16-02", "28-02"),
        //                Tuple.Create("01-03", "15-03"), Tuple.Create("16-03", "31-03"),
        //                Tuple.Create("01-04", "15-04"), Tuple.Create("16-04", "30-04")
        //            }
        //        },
        //        { "mayo_agosto", new List<Tuple<string, string>>
        //            {
        //                Tuple.Create("01-05", "15-05"), Tuple.Create("16-05", "31-05"),
        //                Tuple.Create("01-06", "15-06"), Tuple.Create("16-06", "30-06"),
        //                Tuple.Create("01-07", "15-07"), Tuple.Create("16-07", "31-07"),
        //                Tuple.Create("01-08", "15-08"), Tuple.Create("16-08", "31-08")
        //            }
        //        },
        //        { "septiembre_diciembre", new List<Tuple<string, string>>
        //            {
        //                Tuple.Create("01-09", "15-09"), Tuple.Create("16-09", "30-09"),
        //                Tuple.Create("01-10", "15-10"), Tuple.Create("16-10", "31-10"),
        //                Tuple.Create("01-11", "15-11"), Tuple.Create("16-11", "30-11"),
        //                Tuple.Create("01-12", "15-12"), Tuple.Create("16-12", "31-12")
        //            }
        //        }
        //    };

        //    string periodo;
        //    if (FechaRegreso.Month >= 1 && FechaRegreso.Month <= 4)
        //        periodo = "enero_abril";
        //    else if (FechaRegreso.Month >= 5 && FechaRegreso.Month <= 8)
        //        periodo = "mayo_agosto";
        //    else
        //        periodo = "septiembre_diciembre";

        //    int quincenasTrabajadas = 0;


        //    foreach (var quincena in periodos[periodo])
        //    {
        //        var fechaInicio = DateTime.ParseExact($"{quincena.Item1}-{FechaRegreso.Year}", "dd-MM-yyyy", null);
        //        if (fechaInicio >= FechaRegreso)
        //            quincenasTrabajadas++;
        //    }

        //    return (int)Math.Round((quincenasTrabajadas / 8.0) * DiasTotales);
        //}

        private int DiasDePrimaPeriodo(int mesinicial, int mesfinal, int qnainicial, int qnafinal, DateTime FechaTerminoIncidencia)
        {
            int dias = 0;


            int periodoinicialconta = mesinicial;


            int incremento = 0;

            for (int i = qnainicial; i < qnafinal && periodoinicialconta < 12; i++)
            {

                int dia = 1;

                if (Convert.ToInt16(i) % 2 != 0)
                {
                    dia = 1;
                }
                else
                {

                    dia = 16;
                }

                incremento = incremento + 1;

                if (incremento > 2)
                    if (periodoinicialconta < 12)
                        periodoinicialconta = periodoinicialconta + 1;

                DateTime fecha = new DateTime(this.Nomina_stNomina.FechaTermino.Year, periodoinicialconta, dia);
                int res = DateTime.Compare(FechaTerminoIncidencia, fecha);

                if (FechaTerminoIncidencia > fecha)
                {
                    dias = dias + 1;

                }



            }
            return dias;
        }
        public int DiasdePrima(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, vwLicenciasTrabajadores licencia)
        {
            int dias = 0;

            int periodoinicial = 1;
            int periodofinal = 4;



            if (this.ParametrosRelacionLaboral.Prima1 == Libraries.ConvertToInt.ConvertToInt16(this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes))
            {

                dias = DiasDePrimaPeriodo(1, 4, 1, 8, licencia.FechaTerminoIncidencia.Value.AddDays(1));
            }
            else
            if (this.ParametrosRelacionLaboral.Prima2 == Libraries.ConvertToInt.ConvertToInt16(this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes))
            {
                dias = DiasDePrimaPeriodo(5, 8, 9, 16, licencia.FechaTerminoIncidencia.Value.AddDays(1));



            }
            else
            if (this.ParametrosRelacionLaboral.Prima3 == Libraries.ConvertToInt.ConvertToInt16(this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes))
            {
                dias = DiasDePrimaPeriodo(9, 12, 17, 24, licencia.FechaTerminoIncidencia.Value.AddDays(1));

            }
            return dias;

        }

        public int DiasdePrimaPorbajaPartesProporcionales(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria)
        {
            int dias = 0;

            if (ConvenioLaboralTrabajadorCategoria.FechaTermino != null)
            {
                int mesbaja = ConvenioLaboralTrabajadorCategoria.FechaTermino.Value.Month;
                int periodoinicial = 1;
                int periodofinal = 4;



                if (mesbaja >= 1 && mesbaja <= 4)
                {

                    dias = VerificaDiasPrimaBaja(1, 4, 1, 8, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value);
                }
                else
                if (mesbaja >= 5 && mesbaja <= 8)
                {
                    dias = VerificaDiasPrimaBaja(5, 8, 9, 16, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value);

                }
                else
                if (mesbaja >= 9 && mesbaja <= 12)
                {
                    dias = VerificaDiasPrimaBaja(9, 12, 17, 24, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value);

                }
            }
            return dias;

        }

        public int DiasdePrimaPorbaja(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria)
        {
            int dias = 0;

            if (ConvenioLaboralTrabajadorCategoria.FechaTermino != null)
            {
                int periodoinicial = 1;
                int periodofinal = 4;



                if (this.ParametrosRelacionLaboral.Prima1 == Libraries.ConvertToInt.ConvertToInt16(this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes))
                {

                    dias = VerificaDiasPrimaBaja(1, 4, 1, 8, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value);
                }
                else
                if (this.ParametrosRelacionLaboral.Prima2 == Libraries.ConvertToInt.ConvertToInt16(this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes))
                {
                    dias = VerificaDiasPrimaBaja(5, 8, 9, 16, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value);

                }
                else
                if (this.ParametrosRelacionLaboral.Prima3 == Libraries.ConvertToInt.ConvertToInt16(this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes))
                {
                    dias = VerificaDiasPrimaBaja(9, 12, 17, 24, ConvenioLaboralTrabajadorCategoria.FechaTermino.Value);

                }
            }
            return dias;

        }



        public void setUtilesEscolares()
        {
            var QuincenaMes = Nova.Libraries.ConvertToInt.ConvertToInt16(this.Nomina.Catalogos_ctQuincenaMes.QuincenaMes);
            if (QuincenaMes == this.ParametrosRelacionLaboral.QnaUtilesEscolares)


            {


                string query = @"SELECT   [IdUtiles]
      ,[Año]
      ,[IdTrabajador]
      ,[IdConvenioLaboralTrabajadorCategoriaMovimiento]
      ,[FechaMovimiento]
  FROM Percepciones_stUtilesEscolares
  where año=" + this.Nomina_stNomina.Año;

                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");



                this.TrabajadoresConUtilesEscolares = (List<Percepciones_stUtilesEscolares>)dp.connection.Query<Percepciones_stUtilesEscolares>(query);
                dp.Close();
            }


        }
        public void setAnticipoAguinaldo()
        {


            if (this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "15")
            {


                string query = @"SELECT IdNominaAnticipoAguinaldo
      ,IdTrabajador
      ,Año
      ,FechaRegistro
      ,UsuarioRegistro
  FROM Nomina_AnticipoAguinaldo
  where año=" + this.Nomina_stNomina.Año;

                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");



                TrabajadoresConAnticipoAguinaldo = (List<Nomina_AnticipoAguinaldo>)dp.connection.Query<Nomina_AnticipoAguinaldo>(query);
                dp.Close();
            }


        }

        public void setDiasEconomicosDisfrutadosAñoAnterior()
            {

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string diasecon = $@"SELECT a.*,t.Idtrabajador
FROM IncidenciaPermiso_stIncidenciaTrabajador a
inner join Catalogos_ctTipoIncidencia c on a.IdTipoIncidencia=c.IdTipoIncidencia
inner join Convenios_stConvenioLaboralTrabajadorCategoria s on s.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador t on t.IdConvenioLaboralTrabajador=s.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=s.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria r on r.IdCategoria=p.IdCategoria
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=r.IdRelacionConvenioLaboral
  inner join  Catalogos_ctTipoIncidenciaPermiso d on c.IdTipoIncidenciaPermiso=d.IdTipoIncidenciaPermiso
left join Incidencia_ctJustificacion j on j.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
                    WHERE  
(IncidenciaJustificacion in ( 'DÍA ECONÓMICO') )
					and (h.RelacionConvenioLaboral like '%BASE%' or
					(h.RelacionConvenioLaboral like '%CONFIANZA%' 
					and   Categoria in ('COORDINADOR DE TÉCNICOS ESPECIALIZADOS','SUPERVISOR','SECRETARIA DE DIRECTOR DE ÁREA'
,'INGENIERO EN SISTEMAS')
					))  and 
year(a.FechaInicio)={this.Nomina_stNomina.Año-1} 
";
           DiasEconomicosDifrutadosAñoAnterior = (List<DiasEconomicosDisfrutados>)dp.connection.Query<DiasEconomicosDisfrutados>(diasecon).ToList();

            setLicenciasDescuentosDiasEconomicosYPuntualidad();

            setPuntualidadYAsistenciaAñoAnterior();
        }  
        
        public void setDiasEconomicosDisfrtuados()
            {

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            string diasecon = $@"SELECT a.*,t.Idtrabajador
FROM IncidenciaPermiso_stIncidenciaTrabajador a
inner join Catalogos_ctTipoIncidencia c on a.IdTipoIncidencia=c.IdTipoIncidencia
inner join Convenios_stConvenioLaboralTrabajadorCategoria s on s.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador t on t.IdConvenioLaboralTrabajador=s.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=s.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria r on r.IdCategoria=p.IdCategoria
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=r.IdRelacionConvenioLaboral
  inner join  Catalogos_ctTipoIncidenciaPermiso d on c.IdTipoIncidenciaPermiso=d.IdTipoIncidenciaPermiso
left join Incidencia_ctJustificacion j on j.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
                    WHERE  
(IncidenciaJustificacion in ( 'DÍA ECONÓMICO') )
					and (h.RelacionConvenioLaboral like '%BASE%' or
					(h.RelacionConvenioLaboral like '%CONFIANZA%' 
					and   Categoria in ('COORDINADOR DE TÉCNICOS ESPECIALIZADOS','SUPERVISOR','SECRETARIA DE DIRECTOR DE ÁREA'
,'INGENIERO EN SISTEMAS')
					)) and 
year(a.FechaInicio)={this.Nomina_stNomina.Año}  
";
           diasdifrutados = (List<DiasEconomicosDisfrutados>)dp.connection.Query<DiasEconomicosDisfrutados>(diasecon).ToList();

        }

        public void setPuntualidadYAsistenciaAñoAnterior()
        {
            string where = "";
                   where = $"and month(a.FechaInicio) > 6 and month(a.FechaInicio)< 13 and year(a.FechaInicio)={(this.Nomina_stNomina.Año-1)}";


                string query = @"select q.IdTrabajador,COUNT( *) as Meses from (
SELECT IdTrabajador,month(a.FechaInicio) as Mes
FROM IncidenciaPermiso_stIncidenciaTrabajador a
inner join Catalogos_ctTipoIncidencia c on a.IdTipoIncidencia=c.IdTipoIncidencia
inner join Convenios_stConvenioLaboralTrabajadorCategoria s on s.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador t on t.IdConvenioLaboralTrabajador=s.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=s.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria r on r.IdCategoria=p.IdCategoria
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=r.IdRelacionConvenioLaboral
  inner join  Catalogos_ctTipoIncidenciaPermiso d on c.IdTipoIncidenciaPermiso=d.IdTipoIncidenciaPermiso
  left join Incidencia_ctJustificacion j on j.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
                    WHERE  incidencia <> 'FALTA HORAS CLUB' and  (((incidencia likE '%FALTA%' and a.IdIncidenciaJustificacion=0) OR incidencia likE '%RETARDO%' )
					or (IncidenciaJustificacion in ( 'OMISIÓN DE SALIDA','OMISIÓN DE ENTRADA'  ) )) 
					and (h.RelacionConvenioLaboral like '%BASE%' or h.RelacionConvenioLaboral like '%CONFIANZA%')
                     and EsCerrada=1 
						" + where + @"
						group by T.IdTrabajador,month(a.FechaInicio)
) as q
group by q.IdTrabajador";

                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");



                TrabajadoresPuntualidadYAsistenciaPerdidasAñoAnterior = (List<PuntualidadYAsistenciaPerdidas>)dp.connection.Query<PuntualidadYAsistenciaPerdidas>(query);



            query = @"
SELECT IdTrabajador,month(a.FechaInicio) as Meses
FROM IncidenciaPermiso_stIncidenciaTrabajador a
inner join Catalogos_ctTipoIncidencia c on a.IdTipoIncidencia=c.IdTipoIncidencia
inner join Convenios_stConvenioLaboralTrabajadorCategoria s on s.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador t on t.IdConvenioLaboralTrabajador=s.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=s.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria r on r.IdCategoria=p.IdCategoria
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=r.IdRelacionConvenioLaboral
  inner join  Catalogos_ctTipoIncidenciaPermiso d on c.IdTipoIncidenciaPermiso=d.IdTipoIncidenciaPermiso
  left join Incidencia_ctJustificacion j on j.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
                    WHERE  incidencia <> 'FALTA HORAS CLUB' and  (((incidencia likE '%FALTA%' and a.IdIncidenciaJustificacion=0) OR incidencia likE '%RETARDO%' )
					or (IncidenciaJustificacion in ( 'OMISIÓN DE SALIDA','OMISIÓN DE ENTRADA'  ) )) 
					and (h.RelacionConvenioLaboral like '%BASE%' or h.RelacionConvenioLaboral like '%CONFIANZA%')
                     and EsCerrada=1 
						" + where;




            TrabajadoresPuntualidadYAsistenciaPerdidasPorMesAñoAnterior = (List<PuntualidadYAsistenciaPerdidas>)dp.connection.Query<PuntualidadYAsistenciaPerdidas>(query);

            dp.Close();
            }


            public void setPuntaulidadYAsistencia()
        {
            string where = "";
            if (this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "14" || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "24")
            {

                if (this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "14")
                    where = "and month(a.FechaInicio) >= 1 and month(a.FechaInicio)<= 6 and year(a.FechaInicio)=" + this.Nomina_stNomina.Año;
                else
                if (this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "24")
                    where = "and month(a.FechaInicio) > 6 and month(a.FechaInicio)< 13 and year(a.FechaInicio)=" + this.Nomina_stNomina.Año;


                string query = @"select q.IdTrabajador,COUNT( *) as Meses from (
SELECT IdTrabajador,month(a.FechaInicio) as Mes
FROM IncidenciaPermiso_stIncidenciaTrabajador a
inner join Catalogos_ctTipoIncidencia c on a.IdTipoIncidencia=c.IdTipoIncidencia
inner join Convenios_stConvenioLaboralTrabajadorCategoria s on s.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador t on t.IdConvenioLaboralTrabajador=s.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=s.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria r on r.IdCategoria=p.IdCategoria
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=r.IdRelacionConvenioLaboral
  inner join  Catalogos_ctTipoIncidenciaPermiso d on c.IdTipoIncidenciaPermiso=d.IdTipoIncidenciaPermiso
  left join Incidencia_ctJustificacion j on j.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
                    WHERE  incidencia <> 'FALTA HORAS CLUB' and  (((incidencia likE '%FALTA%' and a.IdIncidenciaJustificacion=0) OR incidencia likE '%RETARDO%' )
					or (IncidenciaJustificacion in ( 'OMISIÓN DE SALIDA','OMISIÓN DE ENTRADA'  ) )) 
					and (h.RelacionConvenioLaboral like '%BASE%' or h.RelacionConvenioLaboral like '%CONFIANZA%')
                     and EsCerrada=1 
						" + where + @"
						group by T.IdTrabajador,month(a.FechaInicio)
) as q
group by q.IdTrabajador";

                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");



                TrabajadoresPuntualidadYAsistenciaPerdidas = (List<PuntualidadYAsistenciaPerdidas>)dp.connection.Query<PuntualidadYAsistenciaPerdidas>(query);

                  query = @"
SELECT IdTrabajador,month(a.FechaInicio) as Meses
FROM IncidenciaPermiso_stIncidenciaTrabajador a
inner join Catalogos_ctTipoIncidencia c on a.IdTipoIncidencia=c.IdTipoIncidencia
inner join Convenios_stConvenioLaboralTrabajadorCategoria s on s.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador t on t.IdConvenioLaboralTrabajador=s.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=s.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria r on r.IdCategoria=p.IdCategoria
inner join Convenios_stRelacionConvenioLaboral h on h.IdRelacionConvenioLaboral=r.IdRelacionConvenioLaboral
  inner join  Catalogos_ctTipoIncidenciaPermiso d on c.IdTipoIncidenciaPermiso=d.IdTipoIncidenciaPermiso
  left join Incidencia_ctJustificacion j on j.IdIncidenciaJustificacion=a.IdIncidenciaJustificacion
                    WHERE  incidencia <> 'FALTA HORAS CLUB' and  (((incidencia likE '%FALTA%' and a.IdIncidenciaJustificacion=0) OR incidencia likE '%RETARDO%' )
					or (IncidenciaJustificacion in ( 'OMISIÓN DE SALIDA','OMISIÓN DE ENTRADA'  ) )) 
					and (h.RelacionConvenioLaboral like '%BASE%' or h.RelacionConvenioLaboral like '%CONFIANZA%')
                     and EsCerrada=1 
						" + where ;

                


                TrabajadoresPuntualidadYAsistenciaPerdidasPorMes = (List<PuntualidadYAsistenciaPerdidas>)dp.connection.Query<PuntualidadYAsistenciaPerdidas>(query);
                dp.Close();

            }

        }
        public static List<IncidenciasControlNominas> MesasPorConcluir()
        {
            string query = @"SELECT  z.EstructuraOrganica,
             f.ApellidoPaterno+' '+f.ApellidoMaterno+' '+f.Nombre as Nombre,Cerradas
   from Nomina_RelojChecadorControlUsuarios a
            inner join Nomina_RelojChecadorAreasEstructuraOrganica b on a.IdRelojChecadorAreas=b.IdRelojChecadorAreas
            inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
            inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
            inner join Kardex_ctTrabajador e on e.IdTrabajador=d.IdTrabajador
            inner join Kardex_ctDatosPersonales f on f.IdKardex=e.IdKardex
            inner join Catalogos_ctEstructuraOrganica z on z.IdEstructuraOrganica=b.IdEstructuraOrganica
inner join (
 select ee.IdEstructuraOrganica,ee.TotalIncidencias,rr.Cerradas from 
 (SELECT b.IdEstructuraOrganica,COUNT(a.IdIncidenciaTrabajador) as TotalIncidencias
            FROM IncidenciaPermiso_stIncidenciaTrabajador a inner join 
            Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
            inner join Catalogos_ctTipoIncidencia c on a.IdTipoIncidencia=c.IdTipoIncidencia
            inner join Catalogos_ctEstructuraOrganica f on f.IdEstructuraOrganica=b.IdEstructuraOrganica
            inner join Catalogos_ctTipoIncidenciaPermiso d on d.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
             where  d.TipoIncidenciaPermiso in ('INCIDENCIA','PERCEPCION')

                AND EsAplicada=0 AND ((Autorizo=1 and a.IdIncidenciaJustificacion=0) or Autorizo=0 OR EsCancelada=1 ) 
            group by b.IdEstructuraOrganica) as ee
            left join (
            
            
            
             SELECT b.IdEstructuraOrganica,COUNT(a.IdIncidenciaTrabajador) as Cerradas
            FROM IncidenciaPermiso_stIncidenciaTrabajador a inner join 
            Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
            inner join Catalogos_ctTipoIncidencia c on a.IdTipoIncidencia=c.IdTipoIncidencia
            inner join Catalogos_ctEstructuraOrganica f on f.IdEstructuraOrganica=b.IdEstructuraOrganica
            inner join Catalogos_ctTipoIncidenciaPermiso d on d.IdTipoIncidenciaPermiso=c.IdTipoIncidenciaPermiso
             where  d.TipoIncidenciaPermiso in ('INCIDENCIA','PERCEPCION')

                AND ESCERRADA=1 AND EsAplicada=0 AND ((Autorizo=1 and a.IdIncidenciaJustificacion=0) or Autorizo=0 OR EsCancelada=1 ) 
            group by b.IdEstructuraOrganica) as rr 
            on ee.IdEstructuraOrganica=rr.IdEstructuraOrganica
             )as tt on tt.IdEstructuraOrganica=b.IdEstructuraOrganica and tt.Cerradas is null";

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");


            var control = (List<IncidenciasControlNominas>)dp.connection.Query<IncidenciasControlNominas>(query);
            dp.Close();

            return control;
        }
        public static IEnumerable ObtenerQuincenas()
        {
            bdNovaEntities bd = new bdNovaEntities();
            List<Catalogos_ctQuincenaMes> regresa;
            using (var basenova = new bdNovaEntities())
            {
                regresa = basenova.Catalogos_ctQuincenaMes.AsNoTracking().Include("Catalogos_ctMes").OrderBy(v => v.Catalogos_ctMes.Orden).ToList();
                basenova.Database.Connection.Close();
            }
            return regresa;


        }


        public void setSdiPercepcionesVariablesdelBimestre()
        {
            int año = this.Nomina_stNomina.Año;
            string qnasBimestre = "";

            if (this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "01"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "02"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "03"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "04")
            {
                año = this.Nomina_stNomina.Año - 1;
                qnasBimestre = "'24','23','22','21'";
                diasBimestre = 61;

            }
            else
                 if (this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "05"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "06"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "07"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "08")
            {

                qnasBimestre = "'01','02','03','04'";

                if (DateTime.IsLeapYear(año))
                    diasBimestre = 60;
                else
                    diasBimestre = 59;
            }
            else
                 if (this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "09"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "10"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "11"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "12")
            {

                qnasBimestre = "'05','06','07','08'";
                diasBimestre = 61;

            }
            else
                 if (this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "13"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "14"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "15"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "16")
            {

                qnasBimestre = "'09','10','11','12'";
                diasBimestre = 61;

            }
            else
                 if (this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "17"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "18"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "19"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "20")
            {

                qnasBimestre = "'13','14','15','16'";
                diasBimestre = 62;

            }
            else
                 if (this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "21"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "22"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "23"
                || this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "24")
            {

                qnasBimestre = "'17','18','19','20'";
                diasBimestre = 61;

            }



            string query = @" select 
d.idtrabajador,
 qq.IMPORTE,
k.Percepcion
  from Percepciones_stNominaTrabajadorPercepciones qq inner join Nomina_stNominaTrabajador a on qq.idnominatrabajador=a.idnominatrabajador 
  inner join Nomina_stNominaTrabajador s on qq.IdNominaTrabajador=s.IdNominaTrabajador
  inner join Nomina_stNomina b on a.IdNomina=b.IdNomina 
  inner join Nomina_ctTipoCalculo y on y.IdTipoCalculo=b.IdTipoCalculo
  inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria 
  inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
   inner join Percepciones_stPlantillaNominaPercepciones j on j.IdPlantillaNominaPercepcion=qq.IdPlantillaNominaPercepcion 
   inner join Nomina_ctPlantillaNomina z on z.IdPlantillaNomina=b.IdPlantillaNomina 
   inner join Nomina_ctPlantillaGrupo x on x.IdPlantillaGrupo=z.IdPlantillaGrupo 
   inner join Percepciones_ctPercepcion k on k.IdPercepcion=j.IdPercepcion 
   inner join Catalogos_ctQuincenaMes w on w.IdQuincenaMes=b.IdQuincenaMes
 inner join Nomina_stNominaTrabajadorEstatus  q on q.IdNominaTrabajadorEstatus=s.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
  where  b.Año=" + año + " and   y.TipoCalculo!='RETROACTIVO' and k.EsVariable=1 and b.EsCerrada=1 and EstatusNominaGrupo ='PARA PAGO' and w.QuincenaMes in (" + qnasBimestre + ") ";

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            SdiImportesVariablesTrabajadores = (List<SdiImportesVariables>)dp.connection.Query<SdiImportesVariables>(query);

            query = $@"select 
d.idtrabajador
,qq.IdNominaTrabajadorPercepcion
      ,qq.IdPlantillaNominaPercepcion
      ,qq.IdNominaTrabajador
      ,qq.Importe / {diasBimestre} as Importe
      ,qq.EsAjusteHorasInterinas
      ,qq.EsAjusteHorasExcedentes
      ,qq.EsDevolucionFaltas
      ,qq.Concepto
      ,qq.IdNominaAjustePresupuestal
  from Percepciones_stNominaTrabajadorPercepciones qq inner join Nomina_stNominaTrabajador a on qq.idnominatrabajador=a.idnominatrabajador 
  inner join Nomina_stNominaTrabajador s on qq.IdNominaTrabajador=s.IdNominaTrabajador
  inner join Nomina_stNomina b on a.IdNomina=b.IdNomina 
  inner join Nomina_ctTipoCalculo y on y.IdTipoCalculo=b.IdTipoCalculo
  inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria 
  inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
   inner join Percepciones_stPlantillaNominaPercepciones j on j.IdPlantillaNominaPercepcion=qq.IdPlantillaNominaPercepcion 
   inner join Nomina_ctPlantillaNomina z on z.IdPlantillaNomina=b.IdPlantillaNomina 
   inner join Nomina_ctPlantillaGrupo x on x.IdPlantillaGrupo=z.IdPlantillaGrupo 
   inner join Percepciones_ctPercepcion k on k.IdPercepcion=j.IdPercepcion 
   inner join Catalogos_ctQuincenaMes w on w.IdQuincenaMes=b.IdQuincenaMes
 inner join Nomina_stNominaTrabajadorEstatus  q on q.IdNominaTrabajadorEstatus=s.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
  where  b.Año={año} and   y.TipoCalculo!='RETROACTIVO' and b.EsCerrada=1 and EstatusNominaGrupo ='PARA PAGO' 
  and w.QuincenaMes in ({qnasBimestre})  and Concepto='REMUNERACIÓN AL DESEMPEÑO LABORAL'";

             SdiImportesVariablesRDL = (List<Percepciones_stNominaTrabajadorPercepcionesRDLBimestre>)dp.connection.Query<Percepciones_stNominaTrabajadorPercepcionesRDLBimestre>(query);

             

            
            dp.Close();

        }
        public void setTrabajadoresConPrimaDominical()
        {
            var inicio = Nomina.FechaInicio;
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                TrabajadoresConPrimaDominical = basenova.IncidenciaPermiso_stIncidenciaTrabajador.
                    Where(z => z.Catalogos_ctTipoIncidencia.Incidencia == "PRIMA DOMINICAL"
                          && z.EsAplicada == false
              && z.EsCerrada == true
              && z.Autorizo == true
              && z.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
              && z.AñoParaNomina == this.Nomina_stNomina.Año
              && z.EsCancelada == false)
              .Include(a => a.Convenios_stConvenioLaboralTrabajadorCategoria)
              .Include(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador).
              ToList();
                basenova.Database.Connection.Close();
            }

        }

        public void setSalariosDiariosDocentesPartesProporcionales(int añocalculo, int idtrabajador)
        {


            string query = $@"select gg.*,rr.ImporteSinMatQuin,ss.ImporteSueldoTotal from (
  select 
  t3.idtrabajador,
  SUM(t3.IMPORTE)/max(DiasEfectivosLaborados) AS ImporteSinMatQuin 
  from (
  select  top  100 PERCENT RANK() OVER(PARTITION BY d.idtrabajador ORDER BY b.fechatermino desc) AS idrow,qq.IMPORTE,DiasEfectivosLaborados,d.idtrabajador
  from Percepciones_stNominaTrabajadorPercepciones qq inner join Nomina_stNominaTrabajador a on qq.idnominatrabajador=a.idnominatrabajador inner join Nomina_stNomina b on a.IdNomina=b.IdNomina inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador inner join Percepciones_stPlantillaNominaPercepciones j on j.IdPlantillaNominaPercepcion=qq.IdPlantillaNominaPercepcion inner join Nomina_ctPlantillaNomina z on z.IdPlantillaNomina=b.IdPlantillaNomina inner join Nomina_ctPlantillaGrupo x on x.IdPlantillaGrupo=z.IdPlantillaGrupo inner join Percepciones_ctPercepcion k on k.IdPercepcion=j.IdPercepcion 
    inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO'
  and Percepcion not like '%CLUB%' and Percepcion like '%SUELDO%'
  and x.PlantillaGrupo='SUELDO' 
  and b.Año={añocalculo}  and d.idtrabajador={idtrabajador}) as t3
  where t3.idrow=1
  group by t3.idtrabajador
  ) as rr inner join
  (select 
  t2.idtrabajador,
  SUM(t2.IMPORTE)/max(DiasEfectivosLaborados) AS Importe 
  from (
  select  top  100 PERCENT RANK() OVER(PARTITION BY d.idtrabajador ORDER BY b.fechatermino desc) AS idrow,qq.IMPORTE,DiasEfectivosLaborados,d.idtrabajador
  from 
  Percepciones_stNominaTrabajadorPercepciones qq inner join Nomina_stNominaTrabajador a on qq.idnominatrabajador=a.idnominatrabajador inner join Nomina_stNomina b on a.IdNomina=b.IdNomina inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador inner join Percepciones_stPlantillaNominaPercepciones j on j.IdPlantillaNominaPercepcion=qq.IdPlantillaNominaPercepcion inner join Nomina_ctPlantillaNomina z on z.IdPlantillaNomina=b.IdPlantillaNomina inner join Nomina_ctPlantillaGrupo x on x.IdPlantillaGrupo=z.IdPlantillaGrupo inner join Percepciones_ctPercepcion k on k.IdPercepcion=j.IdPercepcion 
    inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO'
  and Percepcion not like '%CLUB%' 
    and (Percepcion like '%SUELDO%' OR Percepcion like '%QUINQUENIO%' OR Percepcion like '%MATERIAL%' )
  and x.PlantillaGrupo='SUELDO' 
  and b.Año={añocalculo}  and d.idtrabajador={idtrabajador}) as t2
  where t2.idrow=1
  group by t2.idtrabajador) as gg on rr.IdTrabajador=gg.IdTrabajador 
   inner join 
( select 
  idtrabajador,
  SUM(IMPORTE)/max(DiasEfectivosLaborados) AS ImporteSueldoTotal
  from (
  select top  100 PERCENT
    RANK() OVER(PARTITION BY d.idtrabajador ORDER BY b.fechatermino desc) AS idrow,qq.IMPORTE,DiasEfectivosLaborados,d.IdTrabajador
  from Percepciones_stNominaTrabajadorPercepciones qq inner join Nomina_stNominaTrabajador a on qq.idnominatrabajador=a.idnominatrabajador inner join Nomina_stNomina b on a.IdNomina=b.IdNomina inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador inner join Percepciones_stPlantillaNominaPercepciones j on j.IdPlantillaNominaPercepcion=qq.IdPlantillaNominaPercepcion inner join Nomina_ctPlantillaNomina z on z.IdPlantillaNomina=b.IdPlantillaNomina inner join Nomina_ctPlantillaGrupo x on x.IdPlantillaGrupo=z.IdPlantillaGrupo inner join Percepciones_ctPercepcion k on k.IdPercepcion=j.IdPercepcion 
    inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO'
  and Percepcion like '%SUELDO%'
  and x.PlantillaGrupo='SUELDO' 
and b.Año={añocalculo}  and d.idtrabajador={idtrabajador}
order by b.fechatermino desc
  ) as t1 where t1.idrow=1
  group by t1.idtrabajador ) as ss on ss.IdTrabajador=gg.IdTrabajador 
";


            DapperQuery dp = new DapperQuery("bdNovaEntities");



            SalariosDiarioDocentesParaPartesProporcionales = (List<SalariosDiarioDocentesParaPrima>)dp.connection.Query<SalariosDiarioDocentesParaPrima>(query.ToString());


            dp.Close();
        }
        public void setSalariosDiariosDocentes()
        {

          

            string query = @"select gg.*,rr.ImporteSinMatQuin,ss.ImporteSueldoTotal from (
  select 
  d.idtrabajador,
  SUM(qq.IMPORTE)/max(DiasEfectivosLaborados) AS ImporteSinMatQuin 
  from Percepciones_stNominaTrabajadorPercepciones qq inner join Nomina_stNominaTrabajador a on qq.idnominatrabajador=a.idnominatrabajador inner join Nomina_stNomina b on a.IdNomina=b.IdNomina inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador inner join Percepciones_stPlantillaNominaPercepciones j on j.IdPlantillaNominaPercepcion=qq.IdPlantillaNominaPercepcion inner join Nomina_ctPlantillaNomina z on z.IdPlantillaNomina=b.IdPlantillaNomina inner join Nomina_ctPlantillaGrupo x on x.IdPlantillaGrupo=z.IdPlantillaGrupo inner join Percepciones_ctPercepcion k on k.IdPercepcion=j.IdPercepcion 
  where Percepcion not like '%CLUB%' and Percepcion like '%SUELDO%'
  and x.PlantillaGrupo='SUELDO' 
  and b.Año=" + this.Nomina_stNomina.Año + " and b.IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + @"
  group by d.idtrabajador
  ) as rr inner join
  (select 
  d.idtrabajador,
  SUM(qq.IMPORTE)/max(DiasEfectivosLaborados) AS Importe 
  from Percepciones_stNominaTrabajadorPercepciones qq inner join Nomina_stNominaTrabajador a on qq.idnominatrabajador=a.idnominatrabajador inner join Nomina_stNomina b on a.IdNomina=b.IdNomina inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador inner join Percepciones_stPlantillaNominaPercepciones j on j.IdPlantillaNominaPercepcion=qq.IdPlantillaNominaPercepcion inner join Nomina_ctPlantillaNomina z on z.IdPlantillaNomina=b.IdPlantillaNomina inner join Nomina_ctPlantillaGrupo x on x.IdPlantillaGrupo=z.IdPlantillaGrupo inner join Percepciones_ctPercepcion k on k.IdPercepcion=j.IdPercepcion 
  where Percepcion not like '%CLUB%' 
    and (Percepcion like '%SUELDO%' OR Percepcion like '%QUINQUENIO%' OR Percepcion like '%MATERIAL%' )
  and x.PlantillaGrupo='SUELDO' 
  and b.Año=" + this.Nomina_stNomina.Año + " and b.IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + @"
  group by d.idtrabajador) as gg on rr.IdTrabajador=gg.IdTrabajador 
   inner join 
( select 
  d.idtrabajador,
  SUM(qq.IMPORTE)/max(DiasEfectivosLaborados) AS ImporteSueldoTotal
  from Percepciones_stNominaTrabajadorPercepciones qq inner join Nomina_stNominaTrabajador a on qq.idnominatrabajador=a.idnominatrabajador inner join Nomina_stNomina b on a.IdNomina=b.IdNomina inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador inner join Percepciones_stPlantillaNominaPercepciones j on j.IdPlantillaNominaPercepcion=qq.IdPlantillaNominaPercepcion inner join Nomina_ctPlantillaNomina z on z.IdPlantillaNomina=b.IdPlantillaNomina inner join Nomina_ctPlantillaGrupo x on x.IdPlantillaGrupo=z.IdPlantillaGrupo inner join Percepciones_ctPercepcion k on k.IdPercepcion=j.IdPercepcion 
  where Percepcion like '%SUELDO%'
  and x.PlantillaGrupo='SUELDO' 
and b.Año=" + this.Nomina_stNomina.Año + " and b.IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + @"
  group by d.idtrabajador ) as ss on ss.IdTrabajador=gg.IdTrabajador ";


            DapperQuery dp = new DapperQuery("bdNovaEntities");



            SalariosDiarioDocentesParaPrima = (List<SalariosDiarioDocentesParaPrima>)dp.connection.Query<SalariosDiarioDocentesParaPrima>(query.ToString());


              query = @"select gg.*,rr.ImporteSinMatQuin,ss.ImporteSueldoTotal from (
  select 
  d.idtrabajador,
  SUM(qq.IMPORTE)/max(DiasEfectivosLaborados) AS ImporteSinMatQuin 
  from Percepciones_stNominaTrabajadorPercepciones qq inner join Nomina_stNominaTrabajador a on qq.idnominatrabajador=a.idnominatrabajador inner join Nomina_stNomina b on a.IdNomina=b.IdNomina inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador inner join Percepciones_stPlantillaNominaPercepciones j on j.IdPlantillaNominaPercepcion=qq.IdPlantillaNominaPercepcion inner join Nomina_ctPlantillaNomina z on z.IdPlantillaNomina=b.IdPlantillaNomina inner join Nomina_ctPlantillaGrupo x on x.IdPlantillaGrupo=z.IdPlantillaGrupo inner join Percepciones_ctPercepcion k on k.IdPercepcion=j.IdPercepcion 
  where Percepcion not like '%CLUB%' and Percepcion like '%SUELDO%'
  and x.PlantillaGrupo='SUELDO' and z.Plantilla like '%HORAS EXTRAORDINARIAS%'
  and b.Año=" + this.Nomina_stNomina.Año + " and b.IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + @"
  group by d.idtrabajador
  ) as rr inner join
  (select 
  d.idtrabajador,
  SUM(qq.IMPORTE)/max(DiasEfectivosLaborados) AS Importe 
  from Percepciones_stNominaTrabajadorPercepciones qq inner join Nomina_stNominaTrabajador a on qq.idnominatrabajador=a.idnominatrabajador inner join Nomina_stNomina b on a.IdNomina=b.IdNomina inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador inner join Percepciones_stPlantillaNominaPercepciones j on j.IdPlantillaNominaPercepcion=qq.IdPlantillaNominaPercepcion inner join Nomina_ctPlantillaNomina z on z.IdPlantillaNomina=b.IdPlantillaNomina inner join Nomina_ctPlantillaGrupo x on x.IdPlantillaGrupo=z.IdPlantillaGrupo inner join Percepciones_ctPercepcion k on k.IdPercepcion=j.IdPercepcion 
  where Percepcion not like '%CLUB%' 
    and (Percepcion like '%SUELDO%' OR Percepcion like '%QUINQUENIO%' OR Percepcion like '%MATERIAL%' )
  and x.PlantillaGrupo='SUELDO' and z.Plantilla like '%HORAS EXTRAORDINARIAS%'
  and b.Año=" + this.Nomina_stNomina.Año + " and b.IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + @"
  group by d.idtrabajador) as gg on rr.IdTrabajador=gg.IdTrabajador 
   inner join 
( select 
  d.idtrabajador,
  SUM(qq.IMPORTE)/max(DiasEfectivosLaborados) AS ImporteSueldoTotal
  from Percepciones_stNominaTrabajadorPercepciones qq inner join Nomina_stNominaTrabajador a on qq.idnominatrabajador=a.idnominatrabajador inner join Nomina_stNomina b on a.IdNomina=b.IdNomina inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador inner join Percepciones_stPlantillaNominaPercepciones j on j.IdPlantillaNominaPercepcion=qq.IdPlantillaNominaPercepcion inner join Nomina_ctPlantillaNomina z on z.IdPlantillaNomina=b.IdPlantillaNomina inner join Nomina_ctPlantillaGrupo x on x.IdPlantillaGrupo=z.IdPlantillaGrupo inner join Percepciones_ctPercepcion k on k.IdPercepcion=j.IdPercepcion 
  where Percepcion like '%SUELDO%'
  and x.PlantillaGrupo='SUELDO'  and z.Plantilla like '%HORAS EXTRAORDINARIAS%'
and b.Año=" + this.Nomina_stNomina.Año + " and b.IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + @"
  group by d.idtrabajador ) as ss on ss.IdTrabajador=gg.IdTrabajador ";

            SalariosDiarioDocentesParaPrimaHorasExtras = (List<SalariosDiarioDocentesParaPrima>)dp.connection.Query<SalariosDiarioDocentesParaPrima>(query.ToString());

            query = @"SELECT  IdDocentesHorasPago 
      , IdConvenioLaboralTrabajadorCategoria 
      , TotalHorasPago 
      , ImparteClases 
        ,HorasClub
  FROM   Nomina_DocentesHorasPago ";

            //DocentesHorasAPagar.Clear();

            ListaNomina_DocentesHorasPago = (List<Nomina_DocentesHorasPago>)dp.connection.Query<Nomina_DocentesHorasPago>(query.ToString());



            dp.Close();
        }
        public void setTrabajadoresConDiasDescanso()
        {
            var inicio = Nomina.FechaInicio;
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                TrabajadoresConDiasDescanso = basenova.IncidenciaPermiso_stIncidenciaTrabajador.AsNoTracking()
                    .Where(z => z.Catalogos_ctTipoIncidencia.Incidencia == "DIAS DE DESCANSO OBLIGATORIO"

                           && z.EsAplicada == false
               && z.EsCerrada == true
               && z.Autorizo == true
               && z.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
              && z.AñoParaNomina == this.Nomina_stNomina.Año
               && z.EsCancelada == false)
                    .Include( a=> a.Convenios_stConvenioLaboralTrabajadorCategoria)
              .Include(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                    .ToList();
                basenova.Database.Connection.Close();
            }

        }

        private void setDiasNoTrabajadosPorTrabajadorLista(List<Convenios_stConvenioLaboralTrabajadorCategoria> lista)
        {
            // bdNovaEntities basenova = new bdNovaEntities();
            //por si termina el permiso en la misma qna

            List<Catalogos_ctTipoIncidenciaPermiso> filtros = new List<Catalogos_ctTipoIncidenciaPermiso>();
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                //Select(s => s.IdTipoIncidenciaPermiso)
                filtros = basenova.Catalogos_ctTipoIncidenciaPermiso.Where(s => s.TipoIncidenciaPermiso == "PERMISO"
                   || s.TipoIncidenciaPermiso == "COMISIÓN"
                   || s.TipoIncidenciaPermiso == "PERMISO CON GOCE DE SUELDO").ToList();

                basenova.Database.Connection.Close();
            }

            DapperQuery dp2 = new DapperQuery("bdNovaEntities");

            string query2 = @"select * from vwDatosAspirantesTrabajadoresHistorial
                    where IdTrabajador in (
select IdTrabajador from vwDatosAspirantesTrabajadores
                    where EstatusTrabajador<>'PROXIMAMENTE' and (RestringirMenu is not null
and Incidencia<>'LICENCIA PREJUBILATORIA CON GOCE DE SUELDO') ) order by idtrabajador,fechainicio desc";




            List<vwDatosAspirantesTrabajadores> TrabajadoresComisionadosListado = (List<vwDatosAspirantesTrabajadores>)dp2.connection.Query<vwDatosAspirantesTrabajadores>(query2);

            // dp2.Close();

            string querylic = $@"select * from vwLicenciasTrabajadores
     where  (tipoIncidenciaPermiso='COMISIÓN' or (tipoIncidenciaPermiso='PERMISO' 
and Incidencia like '%LICENCIA SIN GOCE DE SUELDO%')) 
and (fechainicioincidencia BETWEEN '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'
or FechaTerminoIncidencia BETWEEN '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}')
 order by fechaterminoincidencia desc";
            List<vwLicenciasTrabajadores> terminosdelicencias = (List<vwLicenciasTrabajadores>)dp2.connection.Query<vwLicenciasTrabajadores>(querylic);

            string querylicsontinuacion = "";
            //  if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL")
            // considera a las noiminas de 30 dias por si una licencia interviene en el inter
            querylicsontinuacion = @"select * from vwLicenciasTrabajadores
     where  (tipoIncidenciaPermiso='COMISIÓN' or (tipoIncidenciaPermiso='PERMISO' and Incidencia like '%LICENCIA SIN GOCE DE SUELDO%')) and  
(fechainicioincidencia>='" + this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") + "' or  fechainicioincidencia>='" + this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd") + "')";
            // caso MARIELA TRIANA VIÑAZ ella co9ntinua su licencia con fecha 23/08/2021 se queda solo el query mensual 
            // 18/08/2021 correcion

            //else
            //  querylicsontinuacion = @"select * from vwLicenciasTrabajadores
            //  where  (tipoIncidenciaPermiso='COMISIÓN' or (tipoIncidenciaPermiso='PERMISO' and Incidencia like '%LICENCIA SIN GOCE DE SUELDO%')) and  
            //fechainicioincidencia>='" + this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") + "' ";

            List<vwLicenciasTrabajadores> Continuaciondelicencias = (List<vwLicenciasTrabajadores>)dp2.connection.Query<vwLicenciasTrabajadores>(querylicsontinuacion);

            bool existecontratoproximayexistelicenciaactiva = false;

            string inciosdeqns = $@"select * from vwLicenciasTrabajadores
     WHERE (TIPOINCIDENCIAPERMISO='PERMISO' OR TIPOINCIDENCIAPERMISO='COMISIÓN')
and (
(FechaInicioIncidencia < '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' AND fechaterminoincidencia > '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}')
    OR (FechaInicioIncidencia <= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND fechaterminoincidencia > '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND fechaterminoincidencia > '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}')
    OR (FechaInicioIncidencia <= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND fechaterminoincidencia >= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}')
	) ";
            List<vwLicenciasTrabajadores> licenciasinicnaenestaqna = (List<vwLicenciasTrabajadores>)dp2.connection.Query<vwLicenciasTrabajadores>(inciosdeqns);

            var iniciacontratocuandoterminaunacomision = false;

            foreach (var item in lista)

            {


                Boolean Existenuevocontratoyterminacomision = false;

                existecontratoproximayexistelicenciaactiva = false;
                //aqui se da el caso de que una persona 1 tiene el estatus de alta con licencia, 2 tiene un alta (comision), y 3 tiene un registro de proximamente 
                //si cumple con los 3 tien que eliminar al contrato original
                if (this.LicenciasVigentesYProximasTrabajadores.Where(s => s.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Count() == 3)
                {
                    var existeincapacidad = this.LicenciasVigentesYProximasTrabajadores.Where(x => x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && x.RestringirMenu != null).FirstOrDefault();
                    if (existeincapacidad != null)
                    {
                        if (existeincapacidad.Incidencia!=null)
                        if (!existeincapacidad.Incidencia.Contains("INCAPACIDAD"))
                            existecontratoproximayexistelicenciaactiva = true;
                    }
                }
                ////verifica si hay primeros pagos y cambia el valor en el 
                ////conveniolaboralrabajdorcategoria
                //if (this.ListaTrabajadoresPrimerPagoControl.Count > 0)
                //{
                //    var primerpago = this.ListaTrabajadoresPrimerPagoControl.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                //    if (primerpago != null)
                //        item.EsPrimerCalculo = true;
                //}


                TimeSpan intervalo;
                int diasfaltas = 0;
                int totaldiasfaltas = 0;
                int agregadias = 0;

                foreach (var ele in getIncidenciasTrabajadores().Where(s =>
                    s.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
            && s.EsAplicada == false
            && s.EsCerrada == true
            && s.EsCancelada == false
            && s.AñoParaNomina == this.Nomina_stNomina.Año && s.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
            && s.Catalogos_ctTipoIncidencia.EsAfectacionCalculoNomina == true
                     && (s.Catalogos_ctTipoIncidencia.Incidencia == "FALTA POR DÍA"
                     || s.Catalogos_ctTipoIncidencia.Incidencia == "FALTA POR EXCEDER HORAS DE PASES DE SALIDA"
                     || s.Catalogos_ctTipoIncidencia.Incidencia == "FALTA POR RETARDOS")
            && (s.IdIncidenciaJustificacion == 0 || s.Autorizo == false)
                     ).OrderBy(g => g.FechaInicio).ToList())
                {
                    FaltasTrabajador ft = new FaltasTrabajador();
                    FaltasTrabajador faltaAyuda = new FaltasTrabajador();
                    FaltasTrabajador faltaEficiencia = new FaltasTrabajador();

                    intervalo = ele.FechaTermino.Value - ele.FechaInicio;
                    diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
                    totaldiasfaltas = totaldiasfaltas + diasfaltas;
                }

                int totalfaltasPorHoras = 0;
                foreach (var ele in getIncidenciasTrabajadores().Where(s =>
                  s.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
          && s.EsAplicada == false
          && s.EsCerrada == true
          && s.EsCancelada == false
            && s.AñoParaNomina == this.Nomina_stNomina.Año && s.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
          && s.Catalogos_ctTipoIncidencia.EsAfectacionCalculoNomina == true
                   && s.Catalogos_ctTipoIncidencia.Incidencia == "FALTA POR HORAS"
          && (s.IdIncidenciaJustificacion == 0 || s.Autorizo == false)
                   ).OrderBy(g => g.FechaInicio).ToList())
                {



                    totalfaltasPorHoras = totalfaltasPorHoras + ele.Horas;
                }


                double diasTotalesContrato = 0;
                short DIASLABORADOS = 0;

                var plazatrabajador = this.Plazas_ctCategoria.Where(s => s.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria).FirstOrDefault();

                //if (plazatrabajador.CalcularNominaDiasCalendario)
                //    DIASLABORADOS = (short)(this.DiasNominaCalendario);
                //else
                    DIASLABORADOS = (short)(this.DiasNomina);

                bool TerminaComision = false;

                bool regresaLSg = false;

                bool regresaLSgYesBaja = false;
                bool terminacomisionytienebaja_iniciacontratoconcategoriadecomision = false;

                var iniciaunacomisionenestaqna = licenciasinicnaenestaqna.Where(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                bool eliminadoporiniciodecomisionyesplaza = false;
                if (iniciaunacomisionenestaqna != null
                    )
                {
                    if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.PeriodoNomina != "MENSUAL")
                    {
                        if (iniciaunacomisionenestaqna.FechaInicioIncidencia.Year == this.Nomina_stNomina.FechaInicio.Year
                            && iniciaunacomisionenestaqna.FechaInicioIncidencia.Month == this.Nomina_stNomina.FechaInicio.Month)
                            if (iniciaunacomisionenestaqna.FechaInicioIncidencia > this.Nomina_stNomina.FechaInicio)
                            {
                                if (iniciaunacomisionenestaqna.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria
                                    && item.FechaTermino == null && !iniciaunacomisionenestaqna.Incidencia.Contains("LICENCIA SIN GOCE DE SUELDO"))
                                {
                                    TrabajadoresVigentesConContinuidaComision.Add(item);
                                    eliminadoporiniciodecomisionyesplaza = true;
                                }
                                else
                                {
                                    var Diasnominacomision = (iniciaunacomisionenestaqna.FechaInicioIncidencia - this.Nomina_stNomina.FechaInicio).Days;
                                    DIASLABORADOS = (short)(Diasnominacomision);
                                }
                            }
                    }
                    else {
                        if (item.FechaTermino == null && !this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("VALES DE DESPENSA"))
                        {// si la fecha es null se trata de la plaza la cual tiene una comision
                            // es la que se quita porqeu ya solo de deja la comision
                            TrabajadoresVigentesConContinuidaComision.Add(item);
                            eliminadoporiniciodecomisionyesplaza = true;
                        }
                    }

                }

                //verifica regreso de licencias sin goce de sueldo
                var existetermino = terminosdelicencias.Where(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && a.FechaTerminoIncidencia <= this.Nomina.FechaTermino).FirstOrDefault();
                //por idtrabajador
                vwLicenciasTrabajadores existeterminoPorTrabajador;
                if (terminosdelicencias.Where(a => a.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador && a.FechaTerminoIncidencia <= this.Nomina.FechaTermino).Count() > 1)
                    existeterminoPorTrabajador = terminosdelicencias.Where(a => a.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador).OrderByDescending(a => a.FechaInicioIncidencia).FirstOrDefault();
                else
                    existeterminoPorTrabajador = terminosdelicencias.Where(a => a.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador && a.FechaTerminoIncidencia <= this.Nomina.FechaTermino).FirstOrDefault();

                Boolean terminaPorTrabajador = false;
                Boolean Licenciasingocesueldo = false;
                Boolean continuacontratoactual = false;

                Boolean conveniorelaciolaboraligual = true;
                bool terminayempiezaenlamismaqna = false;
                if (existetermino == null)
                    if (existeterminoPorTrabajador != null)
                    {
                        if (Continuaciondelicencias.Where(a => a.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault() == null)
                        {
                            existetermino = existeterminoPorTrabajador;
                            terminaPorTrabajador = true;
                        }
                        else
                        {
                            terminayempiezaenlamismaqna = true;
                        }
                    }


                if (eliminadoporiniciodecomisionyesplaza == false)
                {

                    if (existetermino != null || terminayempiezaenlamismaqna)
                    {
                        var existecontinuacion = Continuaciondelicencias.Where(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                        //mismo convenio entonces puede ser una licencia o permiso sin goce qeu inicia deontro del 
                        if (existecontinuacion != null)
                            if (existecontinuacion.Incidencia.Contains("LICENCIA SIN GOCE DE SUELDO"))
                            {
                                //se agrega este if caso MAEVA TIENE UNA LICENCIA SIN GOCE DE SUELDO QEU EMPIEZA SIN CONTINUACION DE UNA PREVIA
                                //                            IdIncidenciaTrabajador IdConvenioLaboralTrabajadorCategoria    IdTipoIncidencia FechaInicioIncidencia   FechaTerminoIncidencia
                                //426239  5844    10  2015 - 01 - 26 00:00:00.000 2015 - 08 - 09 00:00:00.000
                                //409960  5844    10  2019 - 08 - 19 00:00:00.000 2020 - 02 - 03 00:00:00.000
                                //426867  5844    10  2021 - 08 - 23 00:00:00.000 2022 - 02 - 13 00:00:00.000

                                if (existecontinuacion.FechaInicioIncidencia > this.Nomina_stNomina.FechaTermino)
                                {
                                    Licenciasingocesueldo = false;
                                    continuacontratoactual = true;
                                }
                                else
                                    Licenciasingocesueldo = true;
                            }

                        var existecontinuacionPorTrabajador = Continuaciondelicencias.Where(a => a.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                        if (existecontinuacion == null)
                        {

                            if (existecontinuacionPorTrabajador != null)
                            {
                                //si la fecha de es nula quiee decir qeu el contrato quedo abierto aunque la licencia haya terminado
                                // entonces se omite
                                if (item.FechaTermino != null)
                                {
                                    var diasdiferencia = (existecontinuacionPorTrabajador.FechaInicioIncidencia - item.FechaTermino.Value).Days;
                                    if (diasdiferencia > 1)
                                        existecontinuacion = existecontinuacionPorTrabajador;
                                    else
                                    {
                                        continuacontratoactual = true;
                                        if (existecontinuacionPorTrabajador.FechaInicioIncidencia > item.FechaTermino.Value
                                            )
                                        {
                                            vwDatosAspirantesTrabajadoresHistorial TrabajadoresComisionado = null;


                                            TrabajadoresComisionado = HistoriaPersonal.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                                            var TrabajadorContinuidad = HistoriaPersonal.Where(s => s.IdTrabajador == existecontinuacionPorTrabajador.IdTrabajador
                                            && s.FechaInicio == existecontinuacionPorTrabajador.FechaInicioIncidencia
                                            && s.FechaTermino == existecontinuacionPorTrabajador.FechaTerminoIncidencia).FirstOrDefault();

                                            if (TrabajadorContinuidad != null)
                                                if (TrabajadoresComisionado.IdCategoria == TrabajadorContinuidad.IdCategoria)
                                                    TrabajadoresVigentesConContinuidaComision.Add(item);

                                        }
                                    }
                                }
                                else
                                    continuacontratoactual = true;

                                if (existecontinuacionPorTrabajador.IdRelacionConvenioLaboral != item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdRelacionConvenioLaboral)
                                    conveniorelaciolaboraligual = false;

                            }
                        }
                        else
                        {
                            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL" && Licenciasingocesueldo == true)
                                if (existetermino.FechaInicioIncidencia >= this.Nomina_stNomina.FechaInicio)
                                {
                                    string q3 = " select * from vwLicenciasTrabajadores where IdConvenioLaboralTrabajadorCategoria=" + existecontinuacion.IdConvenioLaboralTrabajadorCategoria + " and IdTipoIncidencia=" + existecontinuacion.IdTipoIncidencia + " and IdIncidenciaTrabajador<>" + existecontinuacion.IdIncidenciaTrabajador + " order by fechaTerminoIncidencia desc";

                                    List<vwLicenciasTrabajadores> liccenciaprevia = (List<vwLicenciasTrabajadores>)dp2.connection.Query<vwLicenciasTrabajadores>(q3);
                                    if (liccenciaprevia.Count > 0)
                                        if (liccenciaprevia[0].FechaTerminoIncidencia.Value.AddDays(1) == existecontinuacion.FechaInicioIncidencia)
                                            TrabajadoresVigentesConContinuidaComision.Add(item);
                                        else
                                            continuacontratoactual = true;
                                    else
                                        continuacontratoactual = true;
                                }
                        }

                        if (existecontinuacion == null && (continuacontratoactual == false))
                        {
                            bool esvales30 = false;
                            // PARA EL CASO DE LAS NOMINAS MENSUALES Y QUE LA COMISION TERMINA EL MISMO 
                            //DIA QEU LA INCIDENCIA NO SE CONSIDERA PARA EL PAGO , SINO HASTA LA PROXIMA
                            // QUINCENA -- caso id 1313 NUBIA ANABEL
                            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL")
                            {
                                int diasdiferencia = 0;
                                bool esfeb = false;
                                if (terminaPorTrabajador || (existetermino != null && existecontinuacion == null))
                                {
                                    if (item.FechaInicio >= this.Nomina_stNomina.FechaInicio &&
                                        item.FechaInicio <= this.Nomina_stNomina.FechaTermino
                                        && item.FechaTermino == null)
                                    // empieza un contrato aqui
                                    {

                                        iniciacontratocuandoterminaunacomision = true;

                                    }
                                    else
                                    if (
                                        item.FechaInicio <= this.Nomina_stNomina.FechaTermino
                                        )

                                    {
                                        if (item.FechaTermino != null)
                                        {
                                            if (item.FechaTermino <= this.Nomina_stNomina.FechaTermino && !this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("VALES"))
                                                //termina una comision en l amismaquiencena que inicia
                                                //un nuevo contrato poara ayuda o nominas mensuales
                                                // se debe de eliminar del la nomina
                                                TrabajadoresVigentesConContinuidaComision.Add(item);
                                            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("VALES"))
                                            {
                                                esvales30 = true;
                                            }
                                        }
                                        else
                                        {
                                            if (existetermino.FechaTerminoIncidencia < this.Nomina_stNomina.FechaTermino)
                                            {
                                                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL"
                                                    && !this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("VALES"))
                                                {
                                                    diasdiferencia = (this.Nomina_stNomina.FechaTermino - existetermino.FechaTerminoIncidencia.Value).Days;
                                                    DIASLABORADOS = (short)(diasdiferencia);
                                                }

                                                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("VALES"))
                                                {
                                                    esvales30 = true;
                                                }

                                            }
                                        }

                                    }
                                    else

                                        if (this.Nomina_stNomina.FechaTermino.Day == 28)
                                    {
                                        if (existetermino.FechaTerminoIncidencia.Value > this.Nomina_stNomina.FechaTermino)
                                            diasdiferencia = (existetermino.FechaInicioIncidencia.AddDays(1) - this.Nomina_stNomina.FechaInicio).Days;
                                        else
                                        {
                                            if (existetermino.FechaTerminoIncidencia.Value.Day <= 15)
                                            {//caso diego gil 11/feb/22 se cambiaron las condiciones
                                             //    diasdiferencia = (existetermino.FechaTerminoIncidencia.Value.AddDays(1) - this.Nomina_stNomina.FechaInicio).Days;
                                                if (terminaPorTrabajador)
                                                    diasdiferencia = (existetermino.FechaTerminoIncidencia.Value.AddDays(1) - this.Nomina_stNomina.FechaInicio).Days;
                                                else
                                                    diasdiferencia = (this.Nomina_stNomina.FechaTermino.AddDays(2) - existetermino.FechaTerminoIncidencia.Value).Days;

                                            }
                                            else
                                            {
                                                if (terminaPorTrabajador)
                                                    diasdiferencia = (this.Nomina_stNomina.FechaTermino.AddDays(2) - existetermino.FechaTerminoIncidencia.Value).Days;
                                                else
                                                    diasdiferencia = (existetermino.FechaTerminoIncidencia.Value.AddDays(1) - this.Nomina_stNomina.FechaInicio).Days;
                                            }
                                        }

                                        DIASLABORADOS = (short)(diasdiferencia);
                                        esfeb = true;
                                    }
                                    else
                                        if (this.Nomina_stNomina.FechaTermino.Day == 29)
                                    {
                                        if (existetermino.FechaTerminoIncidencia.Value > this.Nomina_stNomina.FechaTermino)
                                            diasdiferencia = (existetermino.FechaInicioIncidencia.AddDays(1) - this.Nomina_stNomina.FechaInicio).Days;
                                        else
                                            if (existetermino.FechaTerminoIncidencia.Value.Day <= 15)
                                            diasdiferencia = (existetermino.FechaTerminoIncidencia.Value.AddDays(1) - this.Nomina_stNomina.FechaInicio).Days;
                                        else
                                            diasdiferencia = (this.Nomina_stNomina.FechaTermino.AddDays(1) - existetermino.FechaTerminoIncidencia.Value).Days;

                                        DIASLABORADOS = (short)(diasdiferencia);
                                        esfeb = true;
                                    }
                                    else
                                    //diasdiferencia = (this.Nomina_stNomina.FechaTermino - existetermino.FechaTerminoIncidencia.Value).Days;
                                    //caso norma irma 1a 08 2021
                                    //FechaInicio	FechaTermino
                                    //2020 - 02 - 04 00:00:00.000 NULL
                                    //2021 - 02 - 15 00:00:00.000 2021 - 08 - 22 00:00:00.000
                                    // debe de restar los dias desde el inicio de la nomina al termino de su comision
                                    {
                                        var escomisionado = TrabajadoresComisionadosListado.Where(q => q.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                                        bool NOcomision = false;
                                        if (escomisionado != null)
                                            if (escomisionado.RestringirMenu == null)
                                                NOcomision = true;

                                        if (NOcomision)
                                        {


                                            //diasdiferencia = 30 - existetermino.FechaTerminoIncidencia.Value.Day;
                                            diasdiferencia = existetermino.FechaTerminoIncidencia.Value.Day;
                                            DIASLABORADOS = (short)(diasdiferencia);
                                        }
                                        else
                                        {
                                            diasdiferencia = (existetermino.FechaTerminoIncidencia.Value.AddDays(1) - this.Nomina_stNomina.FechaInicio).Days;
                                            DIASLABORADOS = (short)(diasdiferencia);
                                        }
                                    }

                                }
                                else
                                   if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL")
                                {
                                    if (this.Nomina_stNomina.FechaTermino.Day == 28)
                                    {
                                        if (existetermino.FechaTerminoIncidencia.Value > this.Nomina_stNomina.FechaTermino)
                                            diasdiferencia = (existetermino.FechaInicioIncidencia.AddDays(1) - this.Nomina_stNomina.FechaInicio).Days;
                                        else
                                        {
                                            if (existetermino.FechaTerminoIncidencia.Value.Day <= 15)
                                                diasdiferencia = (this.Nomina_stNomina.FechaTermino.AddDays(2) - existetermino.FechaTerminoIncidencia.Value).Days;

                                            else
                                                diasdiferencia = (existetermino.FechaTerminoIncidencia.Value.AddDays(1) - this.Nomina_stNomina.FechaInicio).Days;

                                        }

                                        DIASLABORADOS = (short)(diasdiferencia);
                                        esfeb = true;
                                    }
                                    else
                                        if (this.Nomina_stNomina.FechaTermino.Day == 29)
                                    {
                                        if (existetermino.FechaTerminoIncidencia.Value > this.Nomina_stNomina.FechaTermino)
                                            diasdiferencia = (existetermino.FechaInicioIncidencia.AddDays(1) - this.Nomina_stNomina.FechaInicio).Days;
                                        else
                                            if (existetermino.FechaTerminoIncidencia.Value.Day <= 15)
                                            diasdiferencia = (this.Nomina_stNomina.FechaTermino.AddDays(1) - existetermino.FechaTerminoIncidencia.Value).Days;

                                        else
                                            diasdiferencia = (existetermino.FechaTerminoIncidencia.Value.AddDays(1) - this.Nomina_stNomina.FechaInicio).Days;

                                        DIASLABORADOS = (short)(diasdiferencia);
                                        esfeb = true;
                                    }

                                }
                                else
                                    diasdiferencia = (this.Nomina_stNomina.FechaTermino - existetermino.FechaTerminoIncidencia.Value).Days;

                                if (esfeb == false && iniciacontratocuandoterminaunacomision == false && esvales30 == false)
                                {
                                    if (diasdiferencia <= 0)
                                        TrabajadoresVigentesConContinuidaComision.Add(item);
                                    else
                                        regresaLSg = true;
                                }
                            }
                            else
                            {
                                int diasdiferencia = 0;
                                if (terminaPorTrabajador == false)
                                {
                                    // se agregfo esta compracion caso sanjuanita qna termin 15/08/2021 su comision terminaba el 22 de agosto y la resta la hacia negativa
                                    // y si es mayor es que sigue de comision
                                    if (existetermino.FechaTerminoIncidencia <= this.Nomina_stNomina.FechaTermino)
                                    {
                                        diasdiferencia = (this.Nomina_stNomina.FechaTermino - existetermino.FechaTerminoIncidencia.Value).Days;
                                        if (plazatrabajador.CalcularNominaDiasCalendario == false && this.Nomina_stNomina.FechaTermino.Day == 31)
                                            diasdiferencia = diasdiferencia - 1;

                                        if (diasdiferencia > 0)
                                            regresaLSg = true;
                                        else
                                        {
                                            TrabajadoresVigentesConContinuidaComision.Add(item);
                                            //DIASLABORADOS = 0;
                                        }
                                    }
                                }

                                else
                                {
                                    bool existebaja = false;
                                    string sqlbaja = $@"SELECT b.*,p.*,w.*
                                  FROM [IncidenciaPermiso_stIncidenciaTrabajador] a
                                  inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                                  inner join Convenios_stConvenioLaboralTrabajador c on c.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
                                inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
                                inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=b.IdDistribucionPlazaCategoria
                                  inner join Kardex_ctTrabajador d on d.IdTrabajador=c.IdTrabajador
                                  inner join [Catalogos_ctTipoIncidencia] i on i.IdTipoIncidencia=a.IdTipoIncidencia
                                  where (a.FechaInicio BETWEEN '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'
                                or b.FechaTermino BETWEEN '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}'
                                AND '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}') 
                                and  d.IdTrabajador={item.Convenios_stConvenioLaboralTrabajador.IdTrabajador}
                                  and (i.Incidencia like '%renun%' or Incidencia like '%baja%') order by b.fechatermino desc";

                                    //                         List<IncidenciaPermiso_stIncidenciaTrabajador> haybaja = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp2.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(sqlbaja);



                                    var haybaja = dp2.connection.Query<Convenios_stConvenioLaboralTrabajadorCategoria, Plazas_stDistribucionPlazaCategoria, Convenios_stConvenioLaboralTrabajador, Convenios_stConvenioLaboralTrabajadorCategoria>(
                                     sqlbaja,
                                     (s, c1, c2) =>
                                     {
                                         s.Convenios_stConvenioLaboralTrabajador = c2;
                                         s.Plazas_stDistribucionPlazaCategoria = c1; // Asignación de la relación con Plazas_stDistribucionPlazaCategoria

                                         return s;
                                     },
                                     splitOn: "IdDistribucionPlazaCategoria,IdConvenioLaboralTrabajador"
                                 ).ToList();
                                    if (item.FechaTermino != null)
                                    {



                                        if (haybaja.Count() > 0)

                                        {
                                            string convenicontrol = "";
                                            var ultimabaja = haybaja.FirstOrDefault();
                                            if (ultimabaja.IdIncidenciaTrabajador != null)
                                            {
                                                convenicontrol = $@"SELECT s.*,p.* FROM Nomina_SuplenciasSolicitudes a
                                         inner join Convenios_SuplenciasControl b on a.IdSuplenciaSolicitud=b.IdSuplenciaSolicitud
                                         inner join Convenios_stConvenioLaboralTrabajadorCategoria s on s.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                                         inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=s.IdDistribucionPlazaCategoria
                                         WHERE a.IdIncidenciaTrabajador={ultimabaja.IdIncidenciaTrabajador}";
                                            }
                                            else
                                            {
                                                convenicontrol = $@"SELECT s.*,p.* FROM Nomina_SuplenciasSolicitudes a
                                         inner join Convenios_SuplenciasControl b on a.IdSuplenciaSolicitud=b.IdSuplenciaSolicitud
                                         inner join Convenios_stConvenioLaboralTrabajadorCategoria s on s.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                                        inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=s.IdConvenioLaboralTrabajador
                                         inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=s.IdDistribucionPlazaCategoria
                                         WHERE  b.IdConvenioLaboralTrabajadorCategoriaCubierto={ultimabaja.IdConvenioLaboralTrabajadorCategoria}
                                                and w.IdTrabajador={ultimabaja.Convenios_stConvenioLaboralTrabajador.IdTrabajador}
                                             and (s.FechaInicio BETWEEN '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'
                                            or s.FechaTermino BETWEEN '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}')";

                                            }

                                            var haycomision = dp2.connection.Query<Convenios_stConvenioLaboralTrabajadorCategoria, Plazas_stDistribucionPlazaCategoria, Convenios_stConvenioLaboralTrabajadorCategoria>(
                                                convenicontrol,
                                                (s, c2) =>
                                                {


                                                    s.Plazas_stDistribucionPlazaCategoria = c2; // Asignación de la relación con Plazas_stDistribucionPlazaCategoria

                                                    return s;
                                                },
                                                splitOn: "IdDistribucionPlazaCategoria"
                                                ).ToList();

                                            if (item.FechaTermino.Value == ultimabaja.FechaTermino

                                               )
                                            {
                                                var hayuncontratomismacategoria = false;
                                                // tiene una baja pero estaba comisionada y termina su comision
                                                // y se agrega un uevo contrato , entonces hay qeu eliminar
                                                //viejo contrato siemprey cuando la cateogia seal lamisma
                                                if (haycomision.Count() > 0)
                                                {

                                                    var ultimacomision = haycomision.FirstOrDefault();
                                                    if (ultimabaja.Plazas_stDistribucionPlazaCategoria.IdCategoria
                                                        != item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                                    {
                                                        // para el caso de sandra avendaño, seria buscar si existe un nuevo contrato
                                                        // con la cateporia de la umtima comision para quitar la comision que termina
                                                        // y solo dejar el contrato
                                                        string querynuevoscontrato = $@"select * from vwDatosAspirantesTrabajadores 
                                                        where (FEchaInicio BETWEEN  '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND  '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}')
                                                            and idtrabajador={item.Convenios_stConvenioLaboralTrabajador.IdTrabajador} order by fechainicio ";
                                                        List<vwDatosAspirantesTrabajadores> nuevoscontratos = (List<vwDatosAspirantesTrabajadores>)dp2.connection.Query<vwDatosAspirantesTrabajadores>(querynuevoscontrato);

                                                        if (nuevoscontratos.Count() > 0)
                                                        {
                                                            var contrato = nuevoscontratos.FirstOrDefault();
                                                            if (contrato.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                                            {
                                                                hayuncontratomismacategoria = true;
                                                            }

                                                        }

                                                        //if (ultimacomision.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria)
                                                        //    bajacondiferentecategoria = false;
                                                        //else
                                                        //    bajacondiferentecategoria = true;

                                                    }

                                                    if (
                                                        ultimabaja.FechaTermino == ultimacomision.FechaTermino
                                                        && ultimacomision.Plazas_stDistribucionPlazaCategoria.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                                    {
                                                        if (hayuncontratomismacategoria)
                                                            TrabajadoresVigentesConContinuidaComision.Add(item);
                                                        else
                                                        {
                                                            var diasrestantes = (short)(item.FechaTermino.Value - this.Nomina_stNomina.FechaInicio.AddDays(-1)).Days;
                                                            DIASLABORADOS = diasrestantes;
                                                        }
                                                    }
                                                }
                                                else
                                                {
                                                    //se restan lkos dias
                                                    string querynuevoscontrato = $@"select * from vwDatosAspirantesTrabajadores 
                                                        where (FEchaInicio BETWEEN  '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND  '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}')
                                                            and idtrabajador={item.Convenios_stConvenioLaboralTrabajador.IdTrabajador} order by fechainicio ";
                                                    List<vwDatosAspirantesTrabajadores> nuevoscontratos = (List<vwDatosAspirantesTrabajadores>)dp2.connection.Query<vwDatosAspirantesTrabajadores>(querynuevoscontrato);

                                                    if (nuevoscontratos.Count() > 0)
                                                    {
                                                        var contrato = nuevoscontratos.FirstOrDefault();
                                                        if (contrato.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                                        {
                                                            TrabajadoresVigentesConContinuidaComision.Add(item);
                                                        }
                                                        else
                                                        {
                                                            var diasrestantes = (short)(item.FechaTermino.Value - this.Nomina_stNomina.FechaInicio.AddDays(-1)).Days;
                                                            DIASLABORADOS = diasrestantes;
                                                        }

                                                    }
                                                    else
                                                    {
                                                        var diasrestantes = (short)(item.FechaTermino.Value - this.Nomina_stNomina.FechaInicio.AddDays(-1)).Days;
                                                        DIASLABORADOS = diasrestantes;
                                                    }
                                                }

                                            }
                                        }
                                        else
                                        {
                                            if (item.FechaTermino != null && item.FechaTermino.Value <= this.Nomina_stNomina.FechaTermino
                                               && item.FechaTermino.Value >= this.Nomina_stNomina.FechaInicio)
                                            {
                                                var diasrestantes = (short)(item.FechaTermino.Value - this.Nomina_stNomina.FechaInicio.AddDays(-1)).Days;
                                                DIASLABORADOS = diasrestantes;
                                            }
                                        }
                                    }
                                    else
                                    {
                                        bool noentroaningunaopcion = true;
                                        if (haybaja.Count() > 0)
                                        {
                                            var ultimabaja = haybaja.FirstOrDefault();
                                            string convenicontrol = $@"SELECT s.*,p.* FROM Nomina_SuplenciasSolicitudes a
                                         inner join Convenios_SuplenciasControl b on a.IdSuplenciaSolicitud=b.IdSuplenciaSolicitud
                                         inner join Convenios_stConvenioLaboralTrabajadorCategoria s on s.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                                        inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=s.IdConvenioLaboralTrabajador
                                         inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=s.IdDistribucionPlazaCategoria
                                         WHERE  b.IdConvenioLaboralTrabajadorCategoriaCubierto={ultimabaja.IdConvenioLaboralTrabajadorCategoria}
                                                and w.IdTrabajador={ultimabaja.Convenios_stConvenioLaboralTrabajador.IdTrabajador}
                                             and (s.FechaInicio BETWEEN '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'
                                            or s.FechaTermino BETWEEN '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}')";

                                            var haycomision = dp2.connection.Query<Convenios_stConvenioLaboralTrabajadorCategoria, Plazas_stDistribucionPlazaCategoria, Convenios_stConvenioLaboralTrabajadorCategoria>(
                                                convenicontrol,
                                                (s, c2) =>
                                                {
                                                    s.Plazas_stDistribucionPlazaCategoria = c2; // Asignación de la relación con Plazas_stDistribucionPlazaCategoria

                                                    return s;
                                                },
                                                splitOn: "IdDistribucionPlazaCategoria"
                                                ).ToList();

                                            if (haycomision.Count() > 0)
                                            {
                                                var ultimacomision = haycomision.FirstOrDefault();
                                                if (
                                                    ultimabaja.FechaTermino == ultimacomision.FechaTermino
                                                    &&
                                                    ultimacomision.Plazas_stDistribucionPlazaCategoria.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                                {
                                                    terminacomisionytienebaja_iniciacontratoconcategoriadecomision = true;


                                                }
                                                else
                                                {
                                                    terminacomisionytienebaja_iniciacontratoconcategoriadecomision = true;
                                                    var diasrestantes = (short)(this.Nomina_stNomina.FechaTermino - item.FechaInicio.AddDays(-1)).Days;
                                                    DIASLABORADOS = diasrestantes;
                                                }
                                            }
                                            else
                                            {
                                                string terminacomisionsql = $@"
select * from vwLicenciasTrabajadores
     WHERE idtrabajador={item.Convenios_stConvenioLaboralTrabajador.IdTrabajador} and  (TIPOINCIDENCIAPERMISO='PERMISO' OR TIPOINCIDENCIAPERMISO='COMISIÓN')
and idcategoria={item.Plazas_stDistribucionPlazaCategoria.IdCategoria}
  and fechaterminoincidencia between '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' and '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' order by FechaTerminoIncidencia desc,IdIncidenciaTrabajador desc";

                                                List<vwLicenciasTrabajadores> buscacomisionanterior = (List<vwLicenciasTrabajadores>)dp2.connection.Query<vwLicenciasTrabajadores>(terminacomisionsql);
                                                var verificasiterminacomision = buscacomisionanterior.Where(q =>
                                                    q.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                                                    && (q.FechaTerminoIncidencia == item.FechaInicio
                                                    || q.FechaTerminoIncidencia == item.FechaInicio.AddDays(-1))).FirstOrDefault();
                                                if (verificasiterminacomision != null)
                                                {
                                                    if (verificasiterminacomision.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                                    {
                                                        terminacomisionytienebaja_iniciacontratoconcategoriadecomision = true;
                                                    }
                                                    else
                                                    {
                                                        //hay un conotrato que inicia en dia sde esta qna
                                                        // asi que se toman los dias de diferencia de este contrato
                                                        terminacomisionytienebaja_iniciacontratoconcategoriadecomision = true;
                                                        var diasrestantes = (short)(this.Nomina_stNomina.FechaTermino - item.FechaInicio.AddDays(-1)).Days;
                                                        DIASLABORADOS = diasrestantes;
                                                    }
                                                }
                                                else
                                                {
                                                    //verificamos si termino alguna comision
                                                    //con la misma plaza
                                                    string sqlcom = $@"SELECT *
  FROM vwDatosAspirantesTrabajadoresHistorial
  where idtrabajador={item.Convenios_stConvenioLaboralTrabajador.IdTrabajador} and IdCategoria={item.Plazas_stDistribucionPlazaCategoria.IdCategoria}
  and FechaTermino between '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' and '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'
  order by FechaTermino  desc ";
                                                    List<vwDatosAspirantesTrabajadoresHistorial> terminacontatroigual = (List<vwDatosAspirantesTrabajadoresHistorial>)dp2.connection.Query<vwDatosAspirantesTrabajadoresHistorial>(sqlcom);
                                                    bool categoriasiguales = false;
                                                    if (terminacontatroigual.Count() > 0)
                                                    {
                                                        var ultiamcontra = terminacontatroigual.FirstOrDefault();
                                                        if (ultiamcontra.FechaTermino == item.FechaInicio ||
                                                            ultiamcontra.FechaTermino == item.FechaInicio.AddDays(-1))
                                                            categoriasiguales = true;
                                                    }

                                                    if (categoriasiguales)
                                                    {
                                                        terminacomisionytienebaja_iniciacontratoconcategoriadecomision = true;
                                                    }
                                                    else
                                                    {
                                                        //hay un conotrato que inicia en dia sde esta qna
                                                        // asi que se toman los dias de diferencia de este contrato
                                                        terminacomisionytienebaja_iniciacontratoconcategoriadecomision = true;
                                                        var diasrestantes = (short)(this.Nomina_stNomina.FechaTermino - item.FechaInicio.AddDays(-1)).Days;
                                                        DIASLABORADOS = diasrestantes;
                                                    }
                                                }
                                            }
                                        }

                                        if (continuacontratoactual == false && terminacomisionytienebaja_iniciacontratoconcategoriadecomision == false)
                                        {
                                            diasdiferencia = (existetermino.FechaTerminoIncidencia.Value.AddDays(1) - this.Nomina_stNomina.FechaInicio).Days;
                                            DIASLABORADOS = (short)diasdiferencia;
                                        }
                                    }
                                }


                            }
                        }
                        else
                        {

                            bool existecambionomina = false;
                            if (iniciaunacomisionenestaqna!=null)
                                if (iniciaunacomisionenestaqna.Incidencia != null)
                                    if (iniciaunacomisionenestaqna.Incidencia.Contains("LICENCIA SIN GOCE DE SUELDO POR CAMBIO DE NOMINA"))
                                        {
                                            existecambionomina = true;
                                        }

                            if (continuacontratoactual == false && !existecambionomina)
                                TrabajadoresVigentesConContinuidaComision.Add(item);
                        }


                    }
                    else
                    {
                        bool existebaja = false;
                        string sqlbaja = $@"SELECT b.*,p.*,w.*
                                  FROM [IncidenciaPermiso_stIncidenciaTrabajador] a
                                  inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                                  inner join Convenios_stConvenioLaboralTrabajador c on c.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
                                inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
                                inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=b.IdDistribucionPlazaCategoria
                                  inner join Kardex_ctTrabajador d on d.IdTrabajador=c.IdTrabajador
                                  inner join [Catalogos_ctTipoIncidencia] i on i.IdTipoIncidencia=a.IdTipoIncidencia
                                  where (a.FechaInicio BETWEEN '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'
                                or b.FechaTermino BETWEEN '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}'
                                AND '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}') 
                                and  d.IdTrabajador={item.Convenios_stConvenioLaboralTrabajador.IdTrabajador}
                                  and (i.Incidencia like '%renun%' or Incidencia like '%baja%') order by b.fechatermino desc";

                        //                         List<IncidenciaPermiso_stIncidenciaTrabajador> haybaja = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp2.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(sqlbaja);



                        var haybaja = dp2.connection.Query<Convenios_stConvenioLaboralTrabajadorCategoria, Plazas_stDistribucionPlazaCategoria, Convenios_stConvenioLaboralTrabajador, Convenios_stConvenioLaboralTrabajadorCategoria>(
                         sqlbaja,
                         (s, c1, c2) =>
                         {
                             s.Convenios_stConvenioLaboralTrabajador = c2;
                             s.Plazas_stDistribucionPlazaCategoria = c1; // Asignación de la relación con Plazas_stDistribucionPlazaCategoria

                             return s;
                         },
                         splitOn: "IdDistribucionPlazaCategoria,IdConvenioLaboralTrabajador"
                     ).ToList();
                        if (haybaja.Count() > 0)
                        {
                            var ultimabaja = haybaja.FirstOrDefault();

                            string convenicontrol = $@"SELECT s.*,p.* FROM Nomina_SuplenciasSolicitudes a
                                         inner join Convenios_SuplenciasControl b on a.IdSuplenciaSolicitud=b.IdSuplenciaSolicitud
                                         inner join Convenios_stConvenioLaboralTrabajadorCategoria s on s.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                                        inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=s.IdConvenioLaboralTrabajador
                                         inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=s.IdDistribucionPlazaCategoria
                                         WHERE  b.IdConvenioLaboralTrabajadorCategoriaCubierto={item.IdConvenioLaboralTrabajadorCategoria}
                                                and w.IdTrabajador={ultimabaja.Convenios_stConvenioLaboralTrabajador.IdTrabajador}
                                             and (s.FechaInicio BETWEEN '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'
                                            or s.FechaTermino BETWEEN '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}')";

                            var haycomision = dp2.connection.Query<Convenios_stConvenioLaboralTrabajadorCategoria, Plazas_stDistribucionPlazaCategoria, Convenios_stConvenioLaboralTrabajadorCategoria>(
                                convenicontrol,
                                (s, c2) =>
                                {
                                    s.Plazas_stDistribucionPlazaCategoria = c2; // Asignación de la relación con Plazas_stDistribucionPlazaCategoria

                                    return s;
                                },
                                splitOn: "IdDistribucionPlazaCategoria"
                                ).ToList();

                            if (haycomision.Count() == 0)
                            {
                                // aqui se compara que no  hay acomision par ael caso especifico
                                // de juventino ruiz
                                convenicontrol = $@"SELECT s.*,p.* FROM
                                         Convenios_stConvenioLaboralTrabajadorCategoria s
                                        inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador = s.IdConvenioLaboralTrabajador
                                         inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria = s.IdDistribucionPlazaCategoria
                                         WHERE
                                                
                                                w.IdTrabajador={ultimabaja.Convenios_stConvenioLaboralTrabajador.IdTrabajador}
                                             and (s.FechaInicio BETWEEN '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'
                                            and  s.FechaTermino is null )";

                                var haynuevocontrato = dp2.connection.Query<Convenios_stConvenioLaboralTrabajadorCategoria, Plazas_stDistribucionPlazaCategoria, Convenios_stConvenioLaboralTrabajadorCategoria>(
                                    convenicontrol,
                                    (s, c2) =>
                                    {
                                        s.Plazas_stDistribucionPlazaCategoria = c2; // Asignación de la relación con Plazas_stDistribucionPlazaCategoria

                                        return s;
                                    },
                                    splitOn: "IdDistribucionPlazaCategoria"
                                    ).ToList();

                                if (haynuevocontrato.Count() > 0)
                                {
                                    var hayiniciodecomision = licenciasinicnaenestaqna.Where(q => q.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                                    var nuevocontrato = haynuevocontrato.FirstOrDefault();
                                    if (nuevocontrato.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria)
                                    {
                                        if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL")
                                        {
                                            Existenuevocontratoyterminacomision = true;
                                        }
                                        else
                                        {
                                            string sqlcom = $@"SELECT *
  FROM vwDatosAspirantesTrabajadoresHistorial
  where idtrabajador={item.Convenios_stConvenioLaboralTrabajador.IdTrabajador} and IdCategoria={item.Plazas_stDistribucionPlazaCategoria.IdCategoria}
  and FechaTermino between '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' and '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'
  order by FechaTermino  desc ";
                                            List<vwDatosAspirantesTrabajadoresHistorial> terminacontatroigual = (List<vwDatosAspirantesTrabajadoresHistorial>)dp2.connection.Query<vwDatosAspirantesTrabajadoresHistorial>(sqlcom);
                                            bool categoriasiguales = false;
                                            if (terminacontatroigual.Count() > 0)
                                            {
                                                var mismcat = terminacontatroigual.FirstOrDefault();
                                                if (mismcat.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria
                                                    && (mismcat.FechaTermino == item.FechaInicio
                                                    || mismcat.FechaTermino == item.FechaInicio.AddDays(-1)
                                                    ))
                                                    categoriasiguales = true;
                                            }

                                            if (categoriasiguales)
                                            {
                                                Existenuevocontratoyterminacomision = true;

                                            }
                                            else
                                            {
                                                var diasrestantes = (short)(this.Nomina_stNomina.FechaTermino - item.FechaInicio.AddDays(-1)).Days;
                                                DIASLABORADOS = diasrestantes;
                                                Existenuevocontratoyterminacomision = true;
                                            }
                                        }
                                    }
                                    else
                                    if (hayiniciodecomision == null && item.FechaTermino != null && item.FechaTermino <= this.Nomina_stNomina.FechaTermino)
                                    {
                                        if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL"
                                            && nuevocontrato.Plazas_stDistribucionPlazaCategoria.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                        {
                                            TrabajadoresVigentesConContinuidaComision.Add(item);
                                        }
                                        else
                                        {
                                            if (nuevocontrato.Plazas_stDistribucionPlazaCategoria.IdCategoria ==
                                               item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                            {
                                                terminacomisionytienebaja_iniciacontratoconcategoriadecomision = true;
                                                TrabajadoresVigentesConContinuidaComision.Add(item);
                                            }
                                            else
                                            {
                                                var diasrestantes = (short)(item.FechaTermino.Value - this.Nomina_stNomina.FechaInicio.AddDays(-1)).Days;
                                                DIASLABORADOS = diasrestantes;
                                                Existenuevocontratoyterminacomision = true;
                                            }

                                        }

                                    }
                                    else
                                    if (hayiniciodecomision != null
                                        && item.FechaTermino != null && item.FechaTermino <= this.Nomina_stNomina.FechaTermino &&
                                        (hayiniciodecomision.FechaInicioIncidencia == item.FechaTermino
                                        || hayiniciodecomision.FechaInicioIncidencia == item.FechaTermino.Value.AddDays(1)))
                                    {
                                        TrabajadoresVigentesConContinuidaComision.Add(item);
                                        terminacomisionytienebaja_iniciacontratoconcategoriadecomision = true;
                                    }
                                    else
                                    if (
                                        (nuevocontrato.FechaInicio == item.FechaTermino ||
                                        nuevocontrato.FechaInicio.AddDays(-1) == item.FechaTermino)
                                        &&
                                        nuevocontrato.Plazas_stDistribucionPlazaCategoria.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                    {
                                        TrabajadoresVigentesConContinuidaComision.Add(item);
                                        terminacomisionytienebaja_iniciacontratoconcategoriadecomision = true;
                                    }
                                    else
                                        Existenuevocontratoyterminacomision = true;
                                }
                            }
                            else
                            {
                                if (
                                        (ultimabaja.FechaTermino == item.FechaInicio ||
                                        ultimabaja.FechaTermino.Value.AddDays(1) == item.FechaInicio)
                                        &&
                                        ultimabaja.Plazas_stDistribucionPlazaCategoria.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                {
                                    TrabajadoresVigentesConContinuidaComision.Add(item);
                                    terminacomisionytienebaja_iniciacontratoconcategoriadecomision = true;
                                }
                            }

                        }
                        else
                        if (item.FechaTermino != null)
                        {

                            var diasremanentes = 0;

                            if (item.FechaTermino <= this.Nomina_stNomina.FechaInicio)
                            {//var tempo = (TimeSpan)(item.FechaTermino.Value - (DateTime)item.FechaInicio);
                             //se agrego un dia caso  
                             //JORGE ANTONIO   ZAVALETA RAMOS 07-jun-2021 calcula 11 dias
                             //FechaInicio	FechaTermino
                             //2021 - 06 - 14 00:00:00.000 2021 - 06 - 25 00:00:00.000

                                int diasenmex = System.DateTime.DaysInMonth(item.FechaInicio.Year, item.FechaInicio.Month);
                                var tempo = (TimeSpan)(item.FechaTermino.Value.AddDays(1) - (DateTime)item.FechaInicio);

                                diasTotalesContrato = tempo.TotalDays;
                                if (diasenmex > 30 && item.FechaInicio.Month <= item.FechaTermino.Value.Month)
                                    if (plazatrabajador.CalcularNominaDiasCalendario == false && item.FechaTermino.Value.Day > 30)
                                        diasTotalesContrato = diasTotalesContrato - 1;



                            }

                            DateTime conveniofecha = DateTime.Parse(item.FechaTermino.ToString());
                            DateTime nominafecha = DateTime.Parse(this.Nomina_stNomina.FechaInicio.ToString());
                            short diasrestantes = 0;



                            // si el convenio es menor a la fecha de la nomina
                            // el pago se esta haciendo fuera de tiempo y se trata de 
                            // establecer uqe se page en la qna a procesar 15 dias
                            // y el remanente seria el ajuste
                            int idt = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                            var existeComisionLicencia = TrabajadoresComisionadosListado.Where(a =>
                            a.IdTrabajador == idt
                            ).ToList();

                            bool mismoconvenioRelacion = false;
                            bool EsComisionEscalafon = false;

                            if (DIASLABORADOS > 15 || (conveniofecha <= nominafecha))
                                if (existeComisionLicencia.Count > 0)
                                {
                                    if (existeComisionLicencia[0].Incidencia != null)
                                        if (existeComisionLicencia[0].Incidencia.Contains("ESCALAF") || existeComisionLicencia[0].Incidencia.Contains("COMISI"))
                                            EsComisionEscalafon = true;

                                    if (existeComisionLicencia.Count > 1)
                                    {
                                        if (existeComisionLicencia[1].Incidencia != null)
                                            if (existeComisionLicencia[1].Incidencia.Contains("ESCALAF") || existeComisionLicencia[1].Incidencia.Contains("COMISI"))
                                                EsComisionEscalafon = true;


                                        if (existeComisionLicencia[0].RelacionLaboral == existeComisionLicencia[1].RelacionLaboral
                                            && existeComisionLicencia[0].ConvenioLaboral == existeComisionLicencia[1].ConvenioLaboral)
                                            mismoconvenioRelacion = true;
                                    }
                                }


                            if (conveniofecha < nominafecha && EsComisionEscalafon == false)
                            {

                                diasrestantes = (short)diasTotalesContrato;
                                DIASLABORADOS = diasrestantes;


                                VariablesNominaTrabajador vnt_t = new VariablesNominaTrabajador();

                                vnt_t.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                vnt_t.Concepto = "SinAjuste";
                                vnt_t.Importe = 1;
                                ListaVariablesNominaTrabajador.Add(vnt_t);
                            }
                            else
                            if (EsComisionEscalafon == false)
                            {
                                if (conveniofecha == nominafecha)
                                {

                                    diasrestantes = (short)(conveniofecha.Date - nominafecha.Date.AddDays(-1)).Days;

                                    //caso nereyda su contrato termino el 1 de enero y se contiunaba entonces no hay que hacerle
                                    // ajuste de un dia, se debe de poner en 0
                                    if (existeComisionLicencia.Count > 0)
                                    {
                                        if (diasrestantes == 1)
                                        {
                                            diasrestantes = 0;
                                            TrabajadoresVigentesConContinuidaComision.Add(item);
                                        }
                                    }

                                }
                                else
                                    if (mismoconvenioRelacion == false)
                                {
                                    string querynuevoscontrato = $@"select * from vwDatosAspirantesTrabajadores 
                                                        where (fechatermino <= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' or fechatermino is null)
                                                            and idtrabajador={item.Convenios_stConvenioLaboralTrabajador.IdTrabajador} 
                                                and IdConvenioLaboralTrabajadorCategoria!={item.IdConvenioLaboralTrabajadorCategoria} 
                                        and FechaInicio>='{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}'
                                                            order by fechainicio ";

                                    List<vwDatosAspirantesTrabajadores> nuevoscontratos = (List<vwDatosAspirantesTrabajadores>)dp2.connection.Query<vwDatosAspirantesTrabajadores>(querynuevoscontrato);

                                    if (nuevoscontratos.Count() > 0)
                                    {
                                        var nuevo = nuevoscontratos.FirstOrDefault();
                                        if (nuevo.FechaTermino == null &&
                                            nuevo.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                            Existenuevocontratoyterminacomision = true;

                                    }
                                    else
                                        diasrestantes = (short)(conveniofecha.Date.AddDays(1) - nominafecha.Date).Days;
                                }
                            }
                            else
                            {
                                if (conveniofecha == nominafecha)
                                //existe escalafon y hay que separar los pagos de los contratos
                                // y el escalafon o comision termina exactamente al inicio de una nomina
                                {
                                    diasrestantes = (short)(conveniofecha.Date - nominafecha.Date.AddDays(-1)).Days;

                                    var otrocontrato = existeComisionLicencia.Where(a => a.IdConvenioLaboralTrabajadorCategoria != item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();


                                    //agrega al calculo al convenio normal del trabajador
                                    var contratooriginal = ConveniosTrabajadoresTodos.Where(z => z.IdConvenioLaboralTrabajadorCategoria == otrocontrato.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();



                                    TrabajadoresVigentesPorTerminoComision.Add(contratooriginal);
                                    TerminaComision = true;



                                }
                            }
                            //modif caso CHRIS GLADIANA FechaInicio	FechaTermino
                            //2020 - 03 - 02 00:00:00.000 2020 - 03 - 24 00:00:00.000
                            //diasrestantes = (short)(conveniofecha.Date - nominafecha.Date).Days;

                            if (diasrestantes < this.DiasNomina && diasrestantes > 0)
                            {

                                DIASLABORADOS = diasrestantes;


                                VariablesNominaTrabajador vnt_t = new VariablesNominaTrabajador();
                                vnt_t.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                vnt_t.IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                                vnt_t.Concepto = "TerminoContratoDiasPagados";
                                vnt_t.Importe = DIASLABORADOS;
                                ListaVariablesNominaTrabajador.Add(vnt_t);
                            }
                        }
                    }


                    //si fecha de inicio del contrato es mayor a la fevcha de inicio de la nomina
                    //calculada s eel tiene que pagar menos dias
                    if (!terminacomisionytienebaja_iniciacontratoconcategoriadecomision
                        && !Existenuevocontratoyterminacomision
                        && item.FechaInicio > this.Nomina_stNomina.FechaInicio || regresaLSg)
                    {


                        DateTime conveniofecha = DateTime.Parse(item.FechaInicio.ToString());

                        if (regresaLSg)
                        {
                            //var existetermino = terminosdelicencias.Where(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                            conveniofecha = (DateTime)existetermino.FechaTerminoIncidencia;
                        }

                        DateTime nominafecha = DateTime.Parse(this.Nomina_stNomina.FechaTermino.ToString());
                        short diasrestantes = 0;

                        // si el convenio es menor a la fecha de la nomina
                        // el pago se esta haciendo fuera de tiempo y se trata de 
                        // establecer uqe se page en la qna a procesar 15 dias
                        // y el remanente seria el ajuste

                        if (regresaLSg)
                        {
                            //diasdiferencia = (this.Nomina_stNomina.FechaTermino - existetermino.FechaTerminoIncidencia.Value).Days;
                            //caso norma irma 1a 08 2021
                            //FechaInicio	FechaTermino
                            //2020 - 02 - 04 00:00:00.000 NULL
                            //2021 - 02 - 15 00:00:00.000 2021 - 08 - 22 00:00:00.000
                            // debe de restar los dias desde el inicio de la nomina al termino de su comision
                            //NO HABIA if (terminaPorTrabajador==false) PARA ESTE CASO , SE AGREGO
                            if (terminaPorTrabajador == false)
                            {
                                //verifica que no haya baja
                                if (item.FechaTermino != null)
                                {
                                    if (item.FechaTermino <= conveniofecha.Date)
                                    {
                                        regresaLSgYesBaja = true;
                                        this.TrabajadoresVigentesPorBaja.Add(item);
                                    }
                                    else
                                    {
                                        diasrestantes = (short)(item.FechaTermino.Value - conveniofecha.Date).Days;
                                        if (plazatrabajador.CalcularNominaDiasCalendario == false && nominafecha.Date.Day == 31)
                                            diasrestantes--;
                                    }
                                }
                                else
                                {
                                    diasrestantes = (short)(nominafecha.Date - conveniofecha.Date).Days;
                                    if (plazatrabajador.CalcularNominaDiasCalendario == false && nominafecha.Date.Day == 31)
                                        diasrestantes--;
                                }
                            }
                        }
                        else
                        {
                            if (item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("ADMINISTRATIVO-CONTRATO"))
                            {
                                var utimocontrato = HistoriaPersonalContrato.Where(a => a.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                                  && a.IdConvenioLaboralTrabajadorCategoria != item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                                if (utimocontrato != null)
                                { // verifica qeu tenga continuidad al comparar las fechas del ultimo contrato con el vigente solo qei no sean iguales
                                  //emtonces hace la resta para determinar solo los dias de la qna
                                    if (utimocontrato.FechaTermino.Value.AddDays(1) != item.FechaInicio)
                                        diasrestantes = (short)(nominafecha.Date - conveniofecha.Date.AddDays(-1)).Days;
                                }
                            }
                            else
                            {
                                diasrestantes = (short)(nominafecha.Date - conveniofecha.Date.AddDays(-1)).Days;
                                if (continuacontratoactual)
                                {
                                    int idt = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                                    ///var contratosactualesvigentes = db.vwDatosAspirantesTrabajadores.Where(a => a.IdTrabajador == idt).Select(q => q.IdConvenioLaboralTrabajadorCategoria).ToArray();

                                    //           string vwdas= " select IdConvenioLaboralTrabajadorCategoria from vwDatosAspirantesTrabajadores where IdTrabajador=" + idt  ;

                                    //List<Int64> contratosactualesvigentes = (List<Int64>)dp2.connection.Query<Int64>(vwdas);

                                    var existeComisionLicencia = TrabajadoresComisionadosListado.Where(a =>
                       a.IdTrabajador == idt

                       //&& contratosactualesvigentes.Contains((Int64)a.IdConvenioLaboralTrabajadorCategoria)
                       ).ToList();
                                    var otrocontrato = existeComisionLicencia.Where(a => a.IdConvenioLaboralTrabajadorCategoria != item.IdConvenioLaboralTrabajadorCategoria).Select(w => w.IdConvenioLaboralTrabajadorCategoria).ToList();


                                    //agrega al calculo al convenio normal del trabajador
                                    var contratosoriginal = ConveniosTrabajadoresTodos.Where(z => otrocontrato.Contains(z.IdConvenioLaboralTrabajadorCategoria)).ToList();

                                    TrabajadoresVigentesConContinuidaComision.AddRange(contratosoriginal);
                                    diasrestantes = this.DiasNomina;
                                    TerminaComision = true;
                                }
                            }

                        }


                        if (diasrestantes > 0 && diasrestantes < this.DiasNomina && !iniciacontratocuandoterminaunacomision)
                        {
                            DIASLABORADOS = diasrestantes;

                        }
                    }
                    else
                        if (existecontratoproximayexistelicenciaactiva)
                        TrabajadoresVigentesConContinuidaComision.Add(item);

                }

                foreach (var ele in getIncidenciasTrabajadores().Where(s =>
                    s.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
            && s.EsAplicada == false
            && s.EsCerrada == true
            && s.EsCancelada == false

            && s.Catalogos_ctTipoIncidencia.EsAfectacionCalculoNomina == true
            && s.Catalogos_ctTipoIncidencia.Incidencia != "INCAPACIDAD POR MATERNIDAD PAGADA POR EL PATRON"
                     && (filtros.Select(q => q.IdTipoIncidenciaPermiso).Contains(s.Catalogos_ctTipoIncidencia.IdTipoIncidenciaPermiso))

                     && s.EsAplicada == false
                     ).OrderBy(g => g.FechaInicio).ToList())
                {


                    if (ele.FechaInicio.Date > this.Nomina_stNomina.FechaInicio.Date
                        && ele.FechaInicio.Date < this.Nomina_stNomina.FechaTermino.Date
                        )
                    {
                        DateTime fechaMayor = DateTime.Parse(ele.FechaInicio.ToString());
                        DateTime fechaMenor = DateTime.Parse(this.Nomina_stNomina.FechaInicio.ToString());

                        //short diasrestantes = (short)(fechaMayor.Date - fechaMenor.Date.AddDays(-1)).Days;
                        // caso maeva 01 jul 2021
                        //FechaInicioIncidencia FechaTerminoIncidencia
                        //2021 - 08 - 23 00:00:00.000 2022 - 02 - 13 00:00:00.000
                        //licencia sin goce de sueldo daba 23 dias y deben de ser 22
                        // para la nomina de 30 dias Vales de Despensa
                        // el periodo de comienzo de la comision estaba en tre el rango de la nomina
                        short diasrestantes = (short)(fechaMayor.Date - fechaMenor.Date).Days;

                        DIASLABORADOS = diasrestantes;
                    }
                    else
                    if (ele.FechaTermino != null)
                        if (ele.FechaTermino.Value.Date == this.Nomina_stNomina.FechaInicio.Date)
                        {
                            int mesescon31dias = 0;
                            int diasfeb = 0;

                            int diasrestantes = (this.Nomina_stNomina.FechaTermino.Date - ele.FechaTermino.Value.Date).Days;
                            if (plazatrabajador.CalcularNominaDiasCalendario == false)
                            {
                                mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(ele.FechaTermino.Value.Date, this.Nomina_stNomina.FechaTermino.Date);
                                diasfeb = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(ele.FechaTermino.Value.Date, this.Nomina_stNomina.FechaTermino.Date);
                            }

                            diasrestantes = (diasrestantes - mesescon31dias) + diasfeb;


                            DIASLABORADOS = (short)diasrestantes;
                        }
                        else
                        if (ele.FechaTermino.Value.Date < this.Nomina_stNomina.FechaTermino.Date &&
                           ele.FechaTermino.Value.Date >= this.Nomina_stNomina.FechaInicio.Date && regresaLSgYesBaja == false
                           )
                        {
                            DateTime fechaMayor = DateTime.Parse(this.Nomina_stNomina.FechaTermino.Date.ToString());
                            DateTime fechaMenor = DateTime.Parse(ele.FechaTermino.Value.Date.ToString());

                            short diasrestantes = (short)(fechaMayor.Date - fechaMenor.Date).Days;
                            if (plazatrabajador.CalcularNominaDiasCalendario == false && this.Nomina_stNomina.FechaTermino.Date.Day == 31)
                                diasrestantes--;

                            DIASLABORADOS = diasrestantes;
                        }






                }

                // deben de haber 2 contratos diferentes para el mismo trabajador
                // y no debe de encontrar el mismo  que esta procesando
                var ExisteTerminoContratoDiasPagados = this.ListaVariablesNominaTrabajador.Where(s => s.Concepto == "TerminoContratoDiasPagados" && s.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                && s.IdConvenioLaboralTrabajadorCategoria != item.IdConvenioLaboralTrabajadorCategoria
                ).FirstOrDefault();

                if (ExisteTerminoContratoDiasPagados != null && TerminaComision == false && regresaLSg == false)
                {
                    DIASLABORADOS = (short)(DIASLABORADOS - ExisteTerminoContratoDiasPagados.Importe);
                }
                else
                    if (item.FechaTermino != null)
                {
                    var diastempo = 0;
                    if (plazatrabajador.CalcularNominaDiasCalendario)
                        diastempo = (short)(this.DiasNominaCalendario);
                    else
                        diastempo = (short)(this.DiasNomina);

                    if (item.FechaTermino.Value < this.Nomina_stNomina.FechaTermino && diastempo == DIASLABORADOS
                //&& (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.PeriodoNomina != "MENSUAL")
                //&& existeterminoPorTrabajador == null 
                )
                    {
                        short diasrestantes = (short)(item.FechaTermino.Value.AddDays(1) - this.Nomina_stNomina.FechaInicio).Days;
                        DIASLABORADOS = diasrestantes;
                    }
                }

                if (this.EsRecalculoPorTrabajador)
                    DIASLABORADOS = DiasPagados;

                VariablesNominaTrabajador vnt2 = new VariablesNominaTrabajador();

                vnt2.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                vnt2.Concepto = "DIASLABORADOS";
                vnt2.Importe = DIASLABORADOS;
                ListaVariablesNominaTrabajador.Add(vnt2);




                VariablesNominaTrabajador vnt3 = new VariablesNominaTrabajador();

                vnt3.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                vnt3.Concepto = "FALTAS";
                vnt3.Importe = totaldiasfaltas;
                ListaVariablesNominaTrabajador.Add(vnt3);

                VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();

                vnt4.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                vnt4.Concepto = "FALTA POR HORAS";
                vnt4.Importe = totalfaltasPorHoras;
                ListaVariablesNominaTrabajador.Add(vnt4);


                dp2.Close();

            }
        }

        public  void ConveniosSegunNominas()
        {
           
            string query = $@"SELECT 
    c.*,d.IdTrabajador,t.IdCategoria,t.IdRelacionConvenioLaboral
    ,
    r.FechaRenuncia -- Aquí se agrega la columna de la fecha de renuncia si existe
,q.RelacionConvenioLaboral
FROM 
    [Convenios_stConvenioLaboralTrabajadorCategoria] c
	inner join [Convenios_stConvenioLaboralTrabajador] d on c.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=c.IdDistribucionPlazaCategoria
	inner join Plazas_ctCategoria t on t.IdCategoria=p.IdCategoria
	inner join Convenios_stRelacionConvenioLaboral q on q.IdRelacionConvenioLaboral=t.IdRelacionConvenioLaboral

LEFT JOIN (
    -- Subconsulta para obtener la fecha de renuncia si existe
    SELECT 
        [IdConvenioLaboralTrabajadorCategoria],
        MAX(FechaInicio) AS FechaRenuncia -- Cambia MAX por MIN según corresponda a tu lógica de renuncia
    FROM 
         [IncidenciaPermiso_stIncidenciaTrabajador]
    WHERE 
        IdTipoIncidencia = 54 and
        FechaInicio <= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' AND FechaTermino >= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}'
    GROUP BY 
        [IdConvenioLaboralTrabajadorCategoria]
) r ON c.IdConvenioLaboralTrabajadorCategoria = r.IdConvenioLaboralTrabajadorCategoria
WHERE 
    c.FechaTermino >= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}'
    AND c.FechaInicio <= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' 

union 

	SELECT 
    c.*,d.IdTrabajador,t.IdCategoria,t.IdRelacionConvenioLaboral
    ,
    r.FechaRenuncia -- Aquí se agrega la columna de la fecha de renuncia si existe
,q.RelacionConvenioLaboral
FROM 
    [Convenios_stConvenioLaboralTrabajadorCategoria] c
	inner join [Convenios_stConvenioLaboralTrabajador] d on c.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=c.IdDistribucionPlazaCategoria
	inner join Plazas_ctCategoria t on t.IdCategoria=p.IdCategoria
	inner join Convenios_stRelacionConvenioLaboral q on q.IdRelacionConvenioLaboral=t.IdRelacionConvenioLaboral

	LEFT JOIN (
    -- Subconsulta para obtener la fecha de renuncia si existe
    SELECT 
        [IdConvenioLaboralTrabajadorCategoria],
        MAX(FechaInicio) AS FechaRenuncia -- Cambia MAX por MIN según corresponda a tu lógica de renuncia
    FROM 
         [IncidenciaPermiso_stIncidenciaTrabajador]
    WHERE 
        IdTipoIncidencia = 54 and
        FechaInicio <= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' AND FechaTermino >= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}'
    GROUP BY 
        [IdConvenioLaboralTrabajadorCategoria]
) r ON c.IdConvenioLaboralTrabajadorCategoria = r.IdConvenioLaboralTrabajadorCategoria
WHERE 
    c.FechaTermino is null 
union  

SELECT 
    c.*,d.IdTrabajador,t.IdCategoria,t.IdRelacionConvenioLaboral
    ,
    r.FechaRenuncia -- Aquí se agrega la columna de la fecha de renuncia si existe
,q.RelacionConvenioLaboral
FROM 
    [Convenios_stConvenioLaboralTrabajadorCategoria] c
	inner join [Convenios_stConvenioLaboralTrabajador] d on c.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria=c.IdDistribucionPlazaCategoria
	inner join Plazas_ctCategoria t on t.IdCategoria=p.IdCategoria
	inner join Convenios_stRelacionConvenioLaboral q on q.IdRelacionConvenioLaboral=t.IdRelacionConvenioLaboral

LEFT JOIN (
    -- Subconsulta para obtener la fecha de renuncia si existe
    SELECT 
        [IdConvenioLaboralTrabajadorCategoria],
        MAX(FechaInicio) AS FechaRenuncia -- Cambia MAX por MIN según corresponda a tu lógica de renuncia
    FROM 
         [IncidenciaPermiso_stIncidenciaTrabajador]
    WHERE 
        IdTipoIncidencia = 54 and
        FechaInicio <= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' AND FechaTermino >= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}'
    GROUP BY 
        [IdConvenioLaboralTrabajadorCategoria]
) r ON c.IdConvenioLaboralTrabajadorCategoria = r.IdConvenioLaboralTrabajadorCategoria
WHERE 
    (c.FechaTermino <= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}'
    or  c.FechaTermino <= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' ) and c.EsPrimerCalculo=1 and FechaInicioPago='{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}'
order by d.IdTrabajador, c.fechainicio";

            DapperQuery dp2 = new DapperQuery("bdNovaEntities");

            this.ConveniosVigentesSegunNominas = (List<ContratoSegunNomina>)dp2.connection.Query<ContratoSegunNomina>(query);

            string queryin = $@"SELECT *
  FROM  [IncidenciaPermiso_stIncidenciaTrabajador] a
  inner join [Catalogos_ctTipoIncidencia] b on a.IdTipoIncidencia=b.IdTipoIncidencia
  where a.EsCancelada=0 and   incidencia in ( 'LICENCIA SIN GOCE DE SUELDO PARA ATENDER SITUACIONES PERSONALES','LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE ELECCIÓN POPULAR','LICENCIA SIN GOCE DE SUELDO POR ENFERMEDAD TEMPORAL DEFINITIVA')
  and a. FechaTermino >= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}'
 
    AND FechaInicio <= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'
order by fechainicio";

            LicenciasSinGoceSueldoSegunNominas = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp2.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(queryin);


            queryin = $@"SELECT *
  FROM  [IncidenciaPermiso_stIncidenciaTrabajador] a
  inner join [Catalogos_ctTipoIncidencia] b on a.IdTipoIncidencia=b.IdTipoIncidencia
  where a.EsCancelada=1 and      
  a.EsDevolucionPorLicencia=1  
  and EsDevolucionPorLicenciaAplicada=0";


            AjustesLicenciasSinGoceSueldoSegunNominas = (List<IncidenciaPermiso_stIncidenciaTrabajador>)dp2.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(queryin);

            string querycin = $@" SELECT a.*,d.IdTrabajador,r.IdCategoria,w.IdRelacionConvenioLaboral
  FROM  [IncidenciaPermiso_stIncidenciaTrabajador] a
  inner join [Catalogos_ctTipoIncidencia] b on a.IdTipoIncidencia=b.IdTipoIncidencia
 inner join [Convenios_stConvenioLaboralTrabajadorCategoria] c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
 inner join Plazas_stDistribucionPlazaCategoria r on r.IdDistribucionPlazaCategoria=c.IdDistribucionPlazaCategoria
 inner join Plazas_ctCategoria w on w.IdCategoria=r.IdCategoria
	inner join [Convenios_stConvenioLaboralTrabajador] d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
  where  a.EsCancelada=0 and   incidencia in ( 'LICENCIA SIN GOCE DE SUELDO POR CAMBIO DE NOMINA','LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE CONFIANZA')
  and a.FechaTermino >= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}'
 
    AND a.FechaInicio <= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'
order by a.fechainicio";

            LicenciasPorCambiodeNominas = (List<IncidenciaComision>)dp2.connection.Query<IncidenciaComision>(querycin);

            

        }



        private List<ContratoSegunNomina> ConsolidarContratosConsecutivos(List<ContratoSegunNomina> contratos, DateTime inicioNomina, DateTime finNomina, string tipoNomina)
        {
            var contratosConsolidados = new List<ContratoSegunNomina>();
            var contratosAgrupados = contratos.GroupBy(c => c.IdTrabajador);

            foreach (var grupoTrabajador in contratosAgrupados)
            {
               var contratosOrdenados = grupoTrabajador.OrderBy(c => c.FechaInicio).ToList();
                var diasPagadosAcumulados = 0;

                // Identificar todos los contratos que deben ser procesados
                var contratosAProcesar = contratosOrdenados.Where(c =>
                    (c.FechaInicio <= finNomina && (c.FechaTermino == null || c.FechaTermino >= inicioNomina)) ||
                    (c.EsPlazaBase && c.FechaTermino == null) ||
                    (c.FechaTermino.HasValue && c.FechaTermino.Value >= inicioNomina && c.FechaTermino.Value <= finNomina) ||
                    (c.FechaInicio >= inicioNomina && c.FechaInicio <= finNomina)
                ).ToList();

                // Consolidar contratos de la misma categoría
                contratosAProcesar = ConsolidarContratosMismaCategoria(contratosAProcesar);

                if (contratosAProcesar.Count() == 0 && contratosOrdenados.Count()==1)
                //verificar si es proximamente ,termino antes de qeu fuera calculado
                {
                    var contrato = contratosOrdenados.FirstOrDefault();
                    if (contrato.EsPrimerCalculo == true && (contrato.FechaTermino <= finNomina || contrato.FechaTermino <= inicioNomina))
                        {
                        contratosAProcesar = contratosOrdenados.Where(s=> s.IdConvenioLaboralTrabajadorCategoria==contrato.IdConvenioLaboralTrabajadorCategoria).ToList();

                        var vnt_t = new VariablesNominaTrabajador
                        {
                            IdConvenioLaboralTrabajadorCategoria = contrato.IdConvenioLaboralTrabajadorCategoria,
                            Concepto = "PROCESARTRABAJADOR",
                            ConceptoExtra = contrato.FechaInicio.ToString("yyyy-MM-dd"),
                            Importe = 1
                        };
                        ListaVariablesNominaTrabajador.Add(vnt_t);
                    }
                }

                    if (tipoNomina.Contains("BASE"))
                {
                    ProcesarNominaBase(contratosAProcesar, inicioNomina, finNomina, contratosConsolidados, tipoNomina, ref diasPagadosAcumulados);
                }
                else
                {
                    ProcesarOtraNomina(contratosAProcesar, inicioNomina, finNomina, tipoNomina, contratosConsolidados, ref diasPagadosAcumulados);
                }
            }

            return contratosConsolidados;
        }
        private void ProcesarNominaBase(List<ContratoSegunNomina> contratosAProcesar, DateTime inicioNomina, DateTime finNomina,
     List<ContratoSegunNomina> contratosConsolidados, string tipoNomina, ref int diasPagadosAcumulados)
        {
            // Verificar si hay comisiones activas durante el período de la nómina en otras relaciones laborales
            var comisionesActivasOtrasNominas = contratosAProcesar.Where(c =>
                !c.EsPlazaBase &&
                c.RelacionConvenioLaboral != tipoNomina &&
                c.FechaInicio <= finNomina &&
                (c.FechaTermino == null || c.FechaTermino >= inicioNomina)).ToList();

            if (comisionesActivasOtrasNominas.Any())
            {
                if (comisionesActivasOtrasNominas.Any(c => c.FechaTermino == null || c.FechaTermino > finNomina))
                {
                    return; // Si hay comisiones activas en otras nóminas que se extienden más allá del fin de la nómina, no procesamos ningún contrato
                }
                // Si las comisiones terminan dentro del período de nómina, continuamos con el procesamiento
            }

            DateTime fechaActual = inicioNomina;

            while (fechaActual <= finNomina)
            {
                var contratosActivos = contratosAProcesar.Where(c =>
                    c.FechaInicio <= fechaActual &&
                    (c.FechaTermino == null || c.FechaTermino >= fechaActual)).ToList();

                if (contratosActivos.Any())
                {
                    var plazaBaseActiva = contratosActivos.FirstOrDefault(c => c.EsPlazaBase);
                    var comisionActiva = contratosActivos.FirstOrDefault(c => !c.EsPlazaBase);

                    ContratoSegunNomina contratoAProcesar;

                    bool esTerminoLicencia = EsTerminoLicencia(fechaActual, plazaBaseActiva?.IdConvenioLaboralTrabajadorCategoria ?? comisionActiva.IdConvenioLaboralTrabajadorCategoria);

                    if (plazaBaseActiva != null && comisionActiva != null)
                    {
                        if (esTerminoLicencia)
                        {
                            // Si es término de licencia, priorizamos la plaza base
                            contratoAProcesar = plazaBaseActiva;
                        }
                        else
                        {
                            // Si no es término de licencia, mantenemos la prioridad de la comisión
                            contratoAProcesar = comisionActiva;
                        }
                    }
                    else
                    {
                        // Si solo hay uno activo, lo procesamos
                        contratoAProcesar = comisionActiva ?? plazaBaseActiva;
                    }

                    var finEfectivo = contratoAProcesar.FechaTermino.HasValue && contratoAProcesar.FechaTermino.Value < finNomina
                        ? contratoAProcesar.FechaTermino.Value
                        : finNomina;

                    // Si estamos procesando una plaza base, verificamos si hay comisiones futuras
                    if (contratoAProcesar.EsPlazaBase)
                    {
                        var proximaComision = contratosAProcesar
                            .FirstOrDefault(c => !c.EsPlazaBase && c.FechaInicio > fechaActual && c.FechaInicio <= finNomina);

                        if (proximaComision != null && proximaComision.FechaInicio < finEfectivo)
                        {
                            finEfectivo = proximaComision.FechaInicio.AddDays(-1);
                        }
                    }

                    if (esTerminoLicencia)
                    {
                        ProcesarContrato(contratoAProcesar, fechaActual, finEfectivo, contratosConsolidados, contratoAProcesar.EsPlazaBase, inicioNomina, tipoNomina, ref diasPagadosAcumulados);

                    }
                    else
                    if (!ExisteIncidenciaEnPeriodo(contratoAProcesar.IdConvenioLaboralTrabajadorCategoria, fechaActual, finEfectivo))
                    {
                        ProcesarContrato(contratoAProcesar, fechaActual, finEfectivo, contratosConsolidados, contratoAProcesar.EsPlazaBase, inicioNomina, tipoNomina, ref diasPagadosAcumulados);

                    }

                    fechaActual = finEfectivo.AddDays(1);
                }
                else
                {
                    fechaActual = fechaActual.AddDays(1);
                }
            }
        }

        private bool EsTerminoLicencia(DateTime fecha, int idConvenioLaboralTrabajadorCategoria)
        {

            var licencias = ObtenerLicenciasEnPeriodo(idConvenioLaboralTrabajadorCategoria, fecha.AddDays(-1), fecha);
            return licencias.Any(l => l.FechaTermino == fecha.AddDays(-1));
        }

        private void ProcesarOtraNomina(List<ContratoSegunNomina> contratosAProcesar, DateTime inicioNomina, DateTime finNomina,
     string tipoNomina, List<ContratoSegunNomina> contratosConsolidados, ref int diasPagadosAcumulados)
        {
            // Filtrar contratos relevantes para esta nómina
            var contratosRelevantes = contratosAProcesar.Where(c => c.RelacionConvenioLaboral == tipoNomina).ToList();

            // Consolidar contratos de la misma categoría
            var contratosConsolidadosPorCategoria = ConsolidarContratosMismaCategoria(contratosRelevantes);

            DateTime fechaActual = inicioNomina;

            while (fechaActual <= finNomina)
            {
                var contratosActivos = contratosConsolidadosPorCategoria.Where(c =>
                    c.FechaInicio <= fechaActual &&
                    (c.FechaTermino == null || c.FechaTermino >= fechaActual))
                    .OrderBy(c => c.FechaInicio)
                    .ToList();

            var contra = contratosConsolidadosPorCategoria.FirstOrDefault();
                if (contra != null)
                {
                    //buscar si ya se proceso este trabajador para que no se cicle
                    var yaprocesado = this.ListaVariablesNominaTrabajador.Where(a => a.IdConvenioLaboralTrabajadorCategoria == contra.IdConvenioLaboralTrabajadorCategoria
                    && a.Concepto == "PROCESADO_TRABAJADORDIASTOTALES").FirstOrDefault();

                    //busca la variabel procesartrabajadro qeu indica qeu termino y unca se le pago
                    if (contratosActivos.Count() == 0 && yaprocesado == null)
                    {

                        var procesar = this.ListaVariablesNominaTrabajador.Where(a => a.IdConvenioLaboralTrabajadorCategoria == contra.IdConvenioLaboralTrabajadorCategoria
                        && a.Concepto == "PROCESARTRABAJADOR").FirstOrDefault();
                        if (procesar != null && contratosConsolidadosPorCategoria.Count() == 1)
                        {
                            contratosActivos = contratosConsolidadosPorCategoria;
                        }
                    }
                }

                if (contratosActivos.Any())
                {
                    foreach (var contratoAProcesar in contratosActivos)
                    {
                        var finEfectivo = contratoAProcesar.FechaTermino.HasValue && contratoAProcesar.FechaTermino.Value < finNomina
                            ? contratoAProcesar.FechaTermino.Value
                            : finNomina;

                        // Verificar si hay un próximo contrato que comience antes del fin efectivo
                        var proximoContrato = contratosConsolidadosPorCategoria
                            .FirstOrDefault(c => c.FechaInicio > fechaActual && c.FechaInicio <= finEfectivo);

                        if (proximoContrato != null)
                        {
                            finEfectivo = proximoContrato.FechaInicio.AddDays(-1);
                        }

                        if (!ExisteIncidenciaEnPeriodo(contratoAProcesar.IdConvenioLaboralTrabajadorCategoria, fechaActual, finEfectivo))
                        {
                            ProcesarContrato(contratoAProcesar, fechaActual, finEfectivo, contratosConsolidados, contratoAProcesar.EsPlazaBase, inicioNomina, tipoNomina, ref diasPagadosAcumulados);

                        }

                        fechaActual = finEfectivo.AddDays(1);
                    }
                }
                else
                {
                    fechaActual = fechaActual.AddDays(1);
                }
            }
        }

        private List<ContratoSegunNomina> ConsolidarContratosMismaCategoria(List<ContratoSegunNomina> contratos)
        {
            var contratosConsolidados = new List<ContratoSegunNomina>();
            var contratosAgrupadosPorTrabajador = contratos.GroupBy(c => c.IdTrabajador);

            foreach (var grupoTrabajador in contratosAgrupadosPorTrabajador)
            {
                var contratosOrdenados = grupoTrabajador.OrderBy(c => c.FechaInicio).ToList();
                var plazaBase = contratosOrdenados.FirstOrDefault(c => c.EsPlazaBase);
                //si es contrato puede haber 2 plazas bases
                var PlazasBase = contratos.Where(c => c.EsPlazaBase).ToList();
                var comisiones = contratosOrdenados.Where(c => !c.EsPlazaBase).ToList();

                ContratoSegunNomina comisionConsolidada= new ContratoSegunNomina();
                var idcategoria = 0;
                bool plazabase2contratos = false;
                if (plazaBase != null)
                {
                    idcategoria = plazaBase.IdCategoria;
                }
                if (PlazasBase.Count > 1)
                {
                    if (PlazasBase[0].FechaTermino == PlazasBase[1].FechaInicio.AddDays(1))
                    {
                        if (PlazasBase[0].IdCategoria == PlazasBase[1].IdCategoria)
                            comisionConsolidada = PlazasBase[1];
                        else
                            comisionConsolidada = PlazasBase[0];
                    }
                    else
                        comisionConsolidada = PlazasBase[0];

                    plazabase2contratos = true;
                }
                if (comisiones.Any())
                {
                    var comisionesEnPeriodo = comisiones.Where(c =>
                        c.FechaInicio <= this.Nomina_stNomina.FechaTermino &&
                        (c.FechaTermino == null || c.FechaTermino >= this.Nomina_stNomina.FechaInicio)
                    ).OrderBy(c => c.FechaInicio).ToList();

                    if (comisionesEnPeriodo.Any())
                    {
                        bool hayComisionContinua = comisionesEnPeriodo.Any(c =>
                  c.FechaTermino < this.Nomina_stNomina.FechaTermino &&
                  comisionesEnPeriodo.Any(nextC => nextC.FechaInicio == c.FechaTermino.Value.AddDays(1)));


                        bool hayCambioDeCategoriaEnComisionesContinuas = hayComisionContinua &&
                      comisionesEnPeriodo.Select(c => c.IdCategoria).Distinct().Count() > 1;

                        if (!hayComisionContinua && comisionesEnPeriodo.Any(c => (c.FechaTermino == null || c.FechaTermino < this.Nomina_stNomina.FechaTermino)
                        && c.IdCategoria != idcategoria))
                        {
                            // Si hay una comisión que se extiende más allá, procesamos todos los contratos normalmente
                            ProcesarContratosNormalmente(contratosOrdenados, contratosConsolidados);
                        }
                        //else if (hayCambioDeCategoriaEnComisionesContinuas && c.IdCategoria != plazaBase.IdCategoria)
                        else if (hayCambioDeCategoriaEnComisionesContinuas && comisionesEnPeriodo.Any(c => (c.FechaTermino == null || c.FechaTermino < this.Nomina_stNomina.FechaTermino)
                        && c.IdCategoria != idcategoria))
                        {
                            // Procesamos las comisiones normalmente si hay cambio de categoría
                            ProcesarContratosNormalmente(comisionesEnPeriodo, contratosConsolidados);
                        }
                        else
                        {


                            bool usarcomision = false;
                            var comisionenperiodo = comisionesEnPeriodo.Where(c => (c.FechaTermino == null || c.FechaTermino < this.Nomina_stNomina.FechaTermino)
                        && c.IdCategoria == idcategoria).FirstOrDefault();
                            if (comisionenperiodo != null)
                            {
                                if (comisionenperiodo.FechaTermino > this.Nomina_stNomina.FechaTermino)
                                //usar al comision
                                {
                                    usarcomision = true;
                                }
                                else
                                {
                                    var comisionenperiodocontinua = comisionesEnPeriodo.Where(c => (c.FechaTermino == null || c.FechaTermino > this.Nomina_stNomina.FechaTermino)
                        && c.IdCategoria == idcategoria).FirstOrDefault();
                                    if (comisionenperiodocontinua != null)
                                    {
                                        usarcomision = true;
                                    }
                                }
                            }

                            if (usarcomision)
                            {
                                comisionConsolidada = comisionenperiodo;
                            }
                            else
                                if (comisionesEnPeriodo.Any(c => (c.FechaTermino == null || c.FechaTermino < this.Nomina_stNomina.FechaTermino)
                        && c.IdCategoria == idcategoria))
                                comisionConsolidada = plazaBase;
                            else
                                comisionConsolidada = ConsolidarComisiones(comisionesEnPeriodo);

                            if (comisionConsolidada.FechaInicio <= this.Nomina_stNomina.FechaInicio &&
                                comisionConsolidada.FechaTermino >= this.Nomina_stNomina.FechaTermino || usarcomision)
                            {
                                // Las comisiones cubren todo el período de nómina
                                var contratoConsolidado = new ContratoSegunNomina
                                {
                                    IdConvenioLaboralTrabajadorCategoria = comisionConsolidada.IdConvenioLaboralTrabajadorCategoria,
                                    IdTrabajador = comisionConsolidada.IdTrabajador,
                                    FechaInicio = this.Nomina_stNomina.FechaInicio,
                                    FechaTermino = this.Nomina_stNomina.FechaTermino,
                                    FechaInicioPago = comisionConsolidada.FechaInicioPago,
                                    IdCategoria = comisionConsolidada.IdCategoria,
                                    IdRelacionConvenioLaboral = comisionConsolidada.IdRelacionConvenioLaboral,
                                    RelacionConvenioLaboral = comisionConsolidada.RelacionConvenioLaboral,
                                    EsPlazaBase = comisionConsolidada.EsPlazaBase,
                                    //EsPlazaBase = false,
                                    EsPrimerCalculo = comisionConsolidada.EsPrimerCalculo,
                                    DiasPagados = (this.Nomina_stNomina.FechaTermino - this.Nomina_stNomina.FechaInicio).Days + 1
                                };
                                contratosConsolidados.Add(contratoConsolidado);
                            }
                            else if (plazaBase != null && plazaBase.IdCategoria == comisionConsolidada.IdCategoria)
                            {
                                // La comisión y la plaza base tienen la misma categoría
                                var contratoConsolidado = new ContratoSegunNomina
                                {
                                    IdConvenioLaboralTrabajadorCategoria = plazaBase.IdConvenioLaboralTrabajadorCategoria,
                                    IdTrabajador = plazaBase.IdTrabajador,
                                    FechaInicio = this.Nomina_stNomina.FechaInicio,
                                    FechaTermino = this.Nomina_stNomina.FechaTermino,
                                    FechaInicioPago = plazaBase.FechaInicioPago,
                                    IdCategoria = plazaBase.IdCategoria,
                                    IdRelacionConvenioLaboral = plazaBase.IdRelacionConvenioLaboral,
                                    RelacionConvenioLaboral = plazaBase.RelacionConvenioLaboral,
                                    //EsPlazaBase = true,
                                    EsPlazaBase = plazaBase.EsPlazaBase,
                                    EsPrimerCalculo = plazaBase.EsPrimerCalculo,
                                    DiasPagados = (this.Nomina_stNomina.FechaTermino - this.Nomina_stNomina.FechaInicio).Days + 1
                                };
                                contratosConsolidados.Add(contratoConsolidado);
                            }
                            else
                            {
                                // Procesamos las comisiones normalmente
                                ProcesarContratosNormalmente(comisionesEnPeriodo, contratosConsolidados);
                                if (plazaBase != null)
                                {
                                    ProcesarContratosNormalmente(new List<ContratoSegunNomina> { plazaBase }, contratosConsolidados);
                                }
                            }
                        }
                    }
                    else if (plazaBase != null)
                    {
                        // No hay comisiones en el período, procesamos solo la plaza base
                        ProcesarContratosNormalmente(new List<ContratoSegunNomina> { plazaBase }, contratosConsolidados);
                    }
                }
                else
                if (plazabase2contratos)
                        {
                    ContratoSegunNomina  contrato = new ContratoSegunNomina();

                    contrato.IdConvenioLaboralTrabajadorCategoria = comisionConsolidada.IdConvenioLaboralTrabajadorCategoria;
                        contrato.IdTrabajador = comisionConsolidada.IdTrabajador;

                    
                        contrato.FechaTermino = comisionConsolidada.FechaTermino.Value;
                        contrato.FechaInicioPago = comisionConsolidada.FechaInicioPago;
                        contrato.IdCategoria = comisionConsolidada.IdCategoria;
                        contrato.IdRelacionConvenioLaboral = comisionConsolidada.IdRelacionConvenioLaboral;
                        contrato.RelacionConvenioLaboral = comisionConsolidada.RelacionConvenioLaboral;
                        
                        contrato.EsPlazaBase = comisionConsolidada.EsPlazaBase;
                        contrato.EsPrimerCalculo = comisionConsolidada.EsPrimerCalculo;
                    if (comisionConsolidada.EsPrimerCalculo &&
                comisionConsolidada.FechaInicio < this.Nomina_stNomina.FechaInicio)
                    {
                        contrato.FechaInicio = comisionConsolidada.FechaInicio;
                        contrato.DiasPagados = (comisionConsolidada.FechaTermino.Value - comisionConsolidada.FechaInicio).Days + 1; }
                    else
                    {
                        contrato.FechaInicio = this.Nomina_stNomina.FechaInicio;
                        contrato.DiasPagados = (comisionConsolidada.FechaTermino.Value - this.Nomina_stNomina.FechaInicio).Days + 1; }
                    
                    contratosConsolidados.Add(contrato);
                }
                else
                if (plazaBase != null  )
                {
                    // No hay comisiones, procesamos solo la plaza base
                    ProcesarContratosNormalmente(new List<ContratoSegunNomina> { plazaBase }, contratosConsolidados);
                }
            }

            return contratosConsolidados.OrderBy(c => c.FechaInicio).ToList();
        }

        private ContratoSegunNomina ConsolidarComisiones(List<ContratoSegunNomina> comisiones)
        {
            if (!comisiones.Any())
                return null;

            var ultimaComision = comisiones.OrderByDescending(c => c.FechaInicio).First();

            var comisionConsolidada = new ContratoSegunNomina
            {
                IdConvenioLaboralTrabajadorCategoria = ultimaComision.IdConvenioLaboralTrabajadorCategoria,
                IdTrabajador = ultimaComision.IdTrabajador,
                FechaInicio = comisiones.Min(c => c.FechaInicio),
                FechaTermino = comisiones.Max(c => c.FechaTermino),
                FechaInicioPago = ultimaComision.FechaInicioPago,
                IdCategoria = ultimaComision.IdCategoria,
                IdRelacionConvenioLaboral = ultimaComision.IdRelacionConvenioLaboral,
                RelacionConvenioLaboral = ultimaComision.RelacionConvenioLaboral,
                EsPlazaBase = false
            };

            return comisionConsolidada;
        }

        private int AjustarDiasPorMes(int diasPagados, DateTime fechaFinEfectiva, bool esAjustePorLicencia)
        {
            if (!esAjustePorLicencia)
            {
                return diasPagados; // No aplicamos ajustes si no hay licencia
            }

            int diasEnMes = DateTime.DaysInMonth(fechaFinEfectiva.Year, fechaFinEfectiva.Month);

            if (diasEnMes == 31)
            {
                // Si el mes tiene 31 días, restamos un día
                return diasPagados - 1;
            }
            else if (fechaFinEfectiva.Month == 2)
            {
                // Para febrero, sumamos días dependiendo de si es año bisiesto
                if (DateTime.IsLeapYear(fechaFinEfectiva.Year))
                {
                    return diasPagados + 2; // Año bisiesto
                }
                else
                {
                    return diasPagados + 1; // Año no bisiesto
                }
            }

            // Para los demás meses, no hacemos ajustes
            return diasPagados;
        }

        private void ProcesarContratosNormalmente(List<ContratoSegunNomina> contratosOrdenados, List<ContratoSegunNomina> contratosConsolidados)
        {
            for (int i = 0; i < contratosOrdenados.Count; i++)
            {
                var contrato = contratosOrdenados[i];
                var fechaInicioEfectiva = contrato.FechaInicio > this.Nomina_stNomina.FechaInicio ? contrato.FechaInicio : this.Nomina_stNomina.FechaInicio;
                var fechaFinEfectiva = contrato.FechaTermino.HasValue && contrato.FechaTermino.Value < this.Nomina_stNomina.FechaTermino
                    ? contrato.FechaTermino.Value
                    : this.Nomina_stNomina.FechaTermino;

                bool hayAjustePorLicencia = false;
                DateTime? fechaFinLicencia = null;

                // Ajustar fechas según licencias
                if (contrato.EsPlazaBase)
                {
                    var licencias = ObtenerLicenciasEnPeriodo(contrato.IdConvenioLaboralTrabajadorCategoria, this.Nomina_stNomina.FechaInicio, this.Nomina_stNomina.FechaTermino);
                    foreach (var licencia in licencias)
                    {
                        if (licencia.FechaInicio <= fechaInicioEfectiva && licencia.FechaTermino >= fechaInicioEfectiva)
                        {
                            fechaInicioEfectiva = licencia.FechaTermino.Value.AddDays(1);
                            fechaFinLicencia = licencia.FechaTermino;
                            hayAjustePorLicencia = true;
                        }
                        else if (licencia.FechaInicio > fechaInicioEfectiva && licencia.FechaInicio <= fechaFinEfectiva)
                        {
                            fechaFinEfectiva = licencia.FechaInicio.AddDays(-1);
                            hayAjustePorLicencia = true;
                        }
                    }
                }

                int diasPagados;
                if (hayAjustePorLicencia && fechaFinLicencia.HasValue)
                {
                    diasPagados = (fechaFinEfectiva - fechaFinLicencia.Value).Days;
                    // Ya no restamos 1 día aquí
                }
                else
                {
                    diasPagados = (fechaFinEfectiva - fechaInicioEfectiva).Days + 1;
                }

                diasPagados = Math.Max(diasPagados, 0);
                diasPagados = AjustarDiasPorMes(diasPagados, fechaFinEfectiva, hayAjustePorLicencia);

                if (!hayAjustePorLicencia)
                {
                    bool esUltimo = (i == contratosOrdenados.Count - 1);
                    diasPagados = AjustarDiasPagados(contrato, fechaInicioEfectiva, fechaFinEfectiva, diasPagados, esUltimo);
                }

                var contratoConsolidado = new ContratoSegunNomina
                {
                    IdConvenioLaboralTrabajadorCategoria = contrato.IdConvenioLaboralTrabajadorCategoria,
                    IdTrabajador = contrato.IdTrabajador,
                    FechaInicio = fechaInicioEfectiva,
                    FechaTermino = fechaFinEfectiva,
                    IdCategoria = contrato.IdCategoria,
                    FechaInicioPago = contrato.FechaInicioPago,
                    IdRelacionConvenioLaboral = contrato.IdRelacionConvenioLaboral,
                    RelacionConvenioLaboral = contrato.RelacionConvenioLaboral,
                    EsPlazaBase = contrato.EsPlazaBase,
                    EsPrimerCalculo=contrato.EsPrimerCalculo,
                    DiasPagados = diasPagados
                };
                contratosConsolidados.Add(contratoConsolidado);
            }
        }
        private List<IncidenciaComision> ObtenerLicenciasEnPeriodo(int idConvenioLaboralTrabajadorCategoria, DateTime fechaInicio, DateTime fechaFin)
        {
            // Implementar la lógica para obtener las licencias del trabajador en el período especificado
            // Este método debe devolver una lista de objetos Licencia con FechaInicio y FechaTermino
            // Ejemplo:
            return LicenciasPorCambiodeNominas
                .Where(l => l.IdConvenioLaboralTrabajadorCategoria == idConvenioLaboralTrabajadorCategoria &&
                            l.FechaInicio <= fechaFin && l.FechaTermino >= fechaInicio)
                .ToList();
        }
        private bool ExisteIncidenciaEnPeriodo(int IdConvenioLaboralTrabajadorCategoria, DateTime inicioNomina, DateTime finNomina)
        {
            return LicenciasPorCambiodeNominas
                .Any(i => i.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria);
        }

        private void ProcesarContrato(ContratoSegunNomina contrato, DateTime inicioEfectivo, DateTime finEfectivo,
        List<ContratoSegunNomina> contratosConsolidados, bool esPlazaBase, DateTime inicioNomina, string tipoNominaProcesando, ref int diasPagadosAcumulados)
        {
            // Verificar si la FechaInicioPago es válida y posterior al inicio efectivo
            if (contrato.FechaInicioPago.HasValue && contrato.FechaInicioPago.Value > inicioEfectivo)
            {
                inicioEfectivo = contrato.FechaInicioPago.Value;
                if (inicioEfectivo > finEfectivo)
                {
                    return; // No hay días a pagar en este período
                }
            }

            var diasPagados = CalcularDiasPagados(contrato, inicioEfectivo, finEfectivo, esPlazaBase);
            int diasAAsignar = 0;
            var verificasiespagoybaja = this.ListaVariablesNominaTrabajador.Where(a => a.IdConvenioLaboralTrabajadorCategoria == contrato.IdConvenioLaboralTrabajadorCategoria
                  && a.Concepto == "PROCESARTRABAJADORDIASTOTALES").FirstOrDefault();
            if (verificasiespagoybaja != null)
            {
                diasAAsignar = diasPagados;


                var vnt_t2 = new VariablesNominaTrabajador
                {
                    IdConvenioLaboralTrabajadorCategoria = contrato.IdConvenioLaboralTrabajadorCategoria,
                    Concepto = "PROCESADO_TRABAJADORDIASTOTALES",

                    Importe = 1
                };
                this.ListaVariablesNominaTrabajador.Add(vnt_t2);
            }
            else
            {
                int diasMaximosPeriodo = this.Nomina_stNomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL" ? 30 : 15;
                int diasDisponibles = Math.Max(0, diasMaximosPeriodo - diasPagadosAcumulados);

                // Aplicar el ajuste de días pagados
                diasPagados = AjustarDiasPagados(contrato, inicioEfectivo, finEfectivo, diasPagados, diasPagadosAcumulados == 0);

                 diasAAsignar = Math.Min(diasPagados, diasDisponibles);

                // Calcular los días efectivos del período
                int diasEfectivosPeriodo = (finEfectivo - inicioEfectivo).Days + 1;

                //// Ahora ajustamos por licencias sin goce de sueldo
                //var licenciasSinGoce = LicenciasSinGoceSueldoSegunNominas
                //    .Where(l => l.IdConvenioLaboralTrabajadorCategoria == contrato.IdConvenioLaboralTrabajadorCategoria &&
                //                l.FechaInicio <= finEfectivo && l.FechaTermino >= inicioEfectivo)
                //    .ToList();

                //foreach (var licencia in licenciasSinGoce)
                //{
                //    var inicioLicencia = licencia.FechaInicio > inicioEfectivo ? licencia.FechaInicio : inicioEfectivo;
                //    var finLicencia = licencia.FechaTermino < finEfectivo ? licencia.FechaTermino.Value : finEfectivo;
                //    var diasLicencia = (finLicencia - inicioLicencia).Days + 1;
                //    // Calculamos la proporción de días de licencia respecto a los días efectivos del período
                //    double proporcionLicencia = (double)diasLicencia / diasEfectivosPeriodo;

                //    // Ajustamos los días a asignar proporcionalmente
                //    diasAAsignar = (int)Math.Round(diasAAsignar * (1 - proporcionLicencia));


                //}


                // Ajustamos por licencias sin goce de sueldo
                var licenciasSinGoce = LicenciasSinGoceSueldoSegunNominas
                    .Where(l => l.IdConvenioLaboralTrabajadorCategoria == contrato.IdConvenioLaboralTrabajadorCategoria &&
                                l.FechaInicio <= finEfectivo && l.FechaTermino >= inicioEfectivo)
                    .OrderBy(l => l.FechaInicio) // Aseguramos que estén ordenadas por fecha de inicio
                    .ToList();

                // HashSet para llevar un registro de los días ya contabilizados
                var diasContados = new HashSet<DateTime>();

                foreach (var licencia in licenciasSinGoce)
                {
                    var inicioLicencia = licencia.FechaInicio > inicioEfectivo ? licencia.FechaInicio : inicioEfectivo;
                    var finLicencia = licencia.FechaTermino < finEfectivo ? licencia.FechaTermino.Value : finEfectivo;

                    // Recorremos los días de la licencia
                    for (var dia = inicioLicencia; dia <= finLicencia; dia = dia.AddDays(1))
                    {
                        // Solo contamos el día si no ha sido registrado antes
                        if (!diasContados.Contains(dia))
                        {
                            diasContados.Add(dia);
                        }
                    }
                }

                // Total de días de licencia sin goce dentro del período efectivo
                var diasLicencia = diasContados.Count;

                // Calculamos la proporción de días de licencia respecto a los días efectivos del período
                double proporcionLicencia = (double)diasLicencia / diasEfectivosPeriodo;

                // Ajustamos los días a asignar proporcionalmente
                diasAAsignar = (int)Math.Round(diasAAsignar * (1 - proporcionLicencia));

            }

            if (diasAAsignar > 0)
            {
                var contratoAjustado = new ContratoSegunNomina
                {
                    IdConvenioLaboralTrabajadorCategoria = contrato.IdConvenioLaboralTrabajadorCategoria,
                    IdTrabajador = contrato.IdTrabajador,
                    FechaInicio = inicioEfectivo,
                    FechaTermino = finEfectivo,
                    IdCategoria = contrato.IdCategoria,
                    FechaInicioPago = contrato.FechaInicioPago,
                    IdRelacionConvenioLaboral = contrato.IdRelacionConvenioLaboral,
                    RelacionConvenioLaboral = contrato.RelacionConvenioLaboral,
                    EsPrimerCalculo=contrato.EsPrimerCalculo,
                    DiasPagados = diasAAsignar
                };
                contratosConsolidados.Add(contratoAjustado);

                diasPagadosAcumulados += diasAAsignar;

                // Verificar si es primer cálculo y si requiere ajuste
                if (contrato.EsPrimerCalculo && contrato.FechaInicio < inicioNomina)
                {
                    var fechaInicioCalculo = contrato.FechaInicio;
                    var diasAdicionales = CalcularDiasAdicionales(fechaInicioCalculo, inicioNomina);
                    if (diasAdicionales > 0)
                    {
                        var vnt_t = new VariablesNominaTrabajador
                        {
                            IdConvenioLaboralTrabajadorCategoria = contrato.IdConvenioLaboralTrabajadorCategoria,
                            Concepto = "SinAjuste",
                            Importe = 1
                        };
                        ListaVariablesNominaTrabajador.Add(vnt_t);
                        // Nota: Ya no agregamos días adicionales al contrato ajustado
                    }
                }
            }
        }

        private int CalcularDiasAdicionales(DateTime fechaInicioContrato, DateTime inicioNomina)
        {


            // Si la fecha de inicio del contrato es posterior o igual al inicio de la nómina, no hay días adicionales
            if (fechaInicioContrato >= inicioNomina)
            {
                return 0;
            }


            int diasAdicionales = 0;
            DateTime fechaActual = fechaInicioContrato;

            while (fechaActual < inicioNomina)
            {
                // Determinar el fin de la quincena actual
                DateTime finQuincena = new DateTime(fechaActual.Year, fechaActual.Month,
                    fechaActual.Day <= 15 ? 15 : DateTime.DaysInMonth(fechaActual.Year, fechaActual.Month));

                // Si el fin de la quincena es después del inicio de la nómina, ajustar al inicio de la nómina
                if (finQuincena > inicioNomina)
                {
                    finQuincena = inicioNomina.AddDays(-1);
                }

                // Calcular días para esta quincena
                int diasQuincena = (finQuincena - fechaActual).Days + 1;

                // Ajuste especial para febrero
                if (fechaActual.Month == 2)
                {
                    int diasEnFebrero = DateTime.IsLeapYear(fechaActual.Year) ? 29 : 28;
                    if (fechaActual.Day <= 15 && finQuincena.Day == 15)
                    {
                        diasQuincena = 15; // Primera quincena de febrero siempre es 15 días
                    }
                    else if (fechaActual.Day > 15 || (finQuincena.Day == diasEnFebrero && diasQuincena < 15))
                    {
                        // Segunda quincena de febrero, ajustar a 15 días
                        diasQuincena = 15;
                    }
                }
                else
                {
                    // Para otros meses, ajustar a 15 días si es más y no es un mes con 31 días
                    if (diasQuincena > 15 && finQuincena.Day != 31)
                    {
                        diasQuincena = 15;
                    }
                    else if (finQuincena.Day == 31)
                    {
                        diasQuincena--; // Restar el día 31
                    }
                }

                diasAdicionales += diasQuincena;

                // Mover a la siguiente quincena
                fechaActual = finQuincena.AddDays(1);
            }

            return diasAdicionales;
        }

        private int CalcularDiasPagados(ContratoSegunNomina contrato, DateTime inicioEfectivo, DateTime finEfectivo, bool esUltimo)
    {
            if (contrato.EsPrimerCalculo == true && contrato.FechaTermino.Value != null)
            {
                if ((contrato.FechaTermino.Value <= this.Nomina_stNomina.FechaTermino ||
                    contrato.FechaTermino.Value <= this.Nomina_stNomina.FechaInicio)
                    && contrato.FechaInicioPago == this.Nomina_stNomina.FechaInicio && contrato.EsPrimerCalculo)
                {
                    var procesar = this.ListaVariablesNominaTrabajador.Where(a => a.IdConvenioLaboralTrabajadorCategoria == contrato.IdConvenioLaboralTrabajadorCategoria
                   && a.Concepto == "PROCESARTRABAJADOR").FirstOrDefault();

                    DateTime fechaini = inicioEfectivo;
                    if (procesar != null )
                    {
                        fechaini = DateTime.Parse(procesar.ConceptoExtra);

                        var vnt_t = new VariablesNominaTrabajador
                        {
                            IdConvenioLaboralTrabajadorCategoria = contrato.IdConvenioLaboralTrabajadorCategoria,
                            Concepto = "PROCESARTRABAJADORDIASTOTALES",
                            
                            Importe = 1
                        };
                        ListaVariablesNominaTrabajador.Add(vnt_t);
                    }

                    TimeSpan totalfechas = (TimeSpan)(finEfectivo - fechaini);
                    return totalfechas.Days + 1;
                }
                else
                    return (finEfectivo - inicioEfectivo).Days + 1;

            }
            else
            return (finEfectivo - inicioEfectivo).Days + 1;

        }

        public void CalcularDiasDePago(DateTime inicioNomina, DateTime finNomina, int idRelacionConvenioLaboral, string RelacionConvenioLaboral)
        {
            ConveniosSegunNominas();

            var contratosConsolidados = ConsolidarContratosConsecutivos(ConveniosVigentesSegunNominas, inicioNomina, finNomina, RelacionConvenioLaboral);

            this.resultadoMetodoDiasDePago = contratosConsolidados.Select(c => new ResultadoMetodoDiasDePago
            {
                IdTrabajador = c.IdTrabajador,
                SePaga = true,
                DiasPagados = c.DiasPagados,
                IdConvenioLaboralTrabajadorCategoria = c.IdConvenioLaboralTrabajadorCategoria
            }).ToList();

            this.ListaVariablesNominaTrabajador = this.resultadoMetodoDiasDePago.Select(rp => new VariablesNominaTrabajador
            {
                IdConvenioLaboralTrabajadorCategoria = rp.IdConvenioLaboralTrabajadorCategoria,
                Importe = rp.DiasPagados,
                Concepto = "DIASLABORADOS",
                IdTrabajador = rp.IdTrabajador
            }).ToList();

              var vigentes=contratosConsolidados.Select(a => a.IdConvenioLaboralTrabajadorCategoria).ToList();
            var noexisten = TrabajadoresVigentes.Where(z => !vigentes.Contains(z.IdConvenioLaboralTrabajadorCategoria)).ToList();

            this.TrabajadoresVigentes = this.TrabajadoresVigentes.Where(tv =>
                contratosConsolidados.Any(cc => cc.IdConvenioLaboralTrabajadorCategoria == tv.IdConvenioLaboralTrabajadorCategoria)
            ).ToList();

            CalcularFaltasTrabajadores();
        }


        private int AjustarDiasPagados(ContratoSegunNomina contrato, DateTime fechaInicio, DateTime fechaFin, int diasPagados, bool esUltimo)
        {
            int diasBase = this.Nomina_stNomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL" ? 30 : 15;

            // Si el contrato termina antes del fin del período, no ajustamos
            if (contrato.FechaTermino.HasValue && contrato.FechaTermino.Value < fechaFin)
            {
                return diasPagados;
            }

            // Si es el último contrato y los días pagados son mayores que el base, ajustamos al base
            if (esUltimo && diasPagados > diasBase)
            {
                return diasBase;
            }

            int diasAjustados = diasPagados;
            if (fechaInicio.Month != 2 && fechaFin.Month != 2 )
            // Si los días pagados son menos que el base, no ajustamos
            if (diasPagados < diasBase)
            {
                return diasPagados;
            }

            
            // Ajuste para febrero
            if (fechaInicio.Month == 2 && fechaFin.Month == 2 && diasPagados < diasBase &&
                (!contrato.FechaTermino.HasValue || contrato.FechaTermino.Value >= new DateTime(fechaFin.Year, 2, DateTime.DaysInMonth(fechaFin.Year, 2))))
            {
                diasAjustados = diasBase;
            }
            // Ajuste para meses con más de 30 días
            else if (diasPagados > diasBase &&
                     ((fechaFin.Day == DateTime.DaysInMonth(fechaFin.Year, fechaFin.Month) &&
                       DateTime.DaysInMonth(fechaFin.Year, fechaFin.Month) > 30) ||
                      (fechaInicio.Day == (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.PeriodoNomina != "MENSUAL" ? 16 : 1) &&
                       fechaInicio.AddDays(-1).Day == 31)))
            {
                diasAjustados = diasBase;
            }

            return diasAjustados;
        }

 
        public void CalcularFaltasTrabajadores()
        {
           
            var faltasPorConvenio = TrabajadoresVigentes
                .GroupBy(t => t.IdConvenioLaboralTrabajadorCategoria)
                .Select(g => new
                {
                    IdConvenioLaboralTrabajadorCategoria = g.Key,
                    FaltasDias = getIncidenciasTrabajadores()
                        .Where(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == g.Key
                            && i.EsAplicada == false
                            && i.EsCerrada == true
                            && i.EsCancelada == false
                            && i.AñoParaNomina == this.Nomina_stNomina.Año
                            && i.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
                            && i.Catalogos_ctTipoIncidencia.EsAfectacionCalculoNomina == true
                            && (i.IdIncidenciaJustificacion == 0 || i.Autorizo == false)
                            && (i.Catalogos_ctTipoIncidencia.Incidencia == "FALTA POR DÍA"
                                || i.Catalogos_ctTipoIncidencia.Incidencia == "FALTA POR EXCEDER HORAS DE PASES DE SALIDA"
                                || i.Catalogos_ctTipoIncidencia.Incidencia == "FALTA POR RETARDOS"))
                        .Sum(i => (i.FechaTermino.Value - i.FechaInicio).Days + 1),
                    FaltasPorHoras = getIncidenciasTrabajadores()
                        .Where(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == g.Key
                            && i.EsAplicada == false
                            && i.EsCerrada == true
                            && i.EsCancelada == false
                            && i.AñoParaNomina == this.Nomina_stNomina.Año
                            && i.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
                            && i.Catalogos_ctTipoIncidencia.EsAfectacionCalculoNomina == true
                            && (i.IdIncidenciaJustificacion == 0 || i.Autorizo == false)
                            && i.Catalogos_ctTipoIncidencia.Incidencia == "FALTA POR HORAS")
                        .Sum(i => i.Horas)
                })
                .ToList();

            foreach (var falta in faltasPorConvenio)
            {
                if (falta.FaltasDias > 0)
                {
                    ListaVariablesNominaTrabajador.Add(new VariablesNominaTrabajador
                    {
                        IdConvenioLaboralTrabajadorCategoria = falta.IdConvenioLaboralTrabajadorCategoria,
                        Concepto = "FALTAS",
                        Importe = falta.FaltasDias
                    });
                }

                if (falta.FaltasPorHoras > 0)
                {
                    ListaVariablesNominaTrabajador.Add(new VariablesNominaTrabajador
                    {
                        IdConvenioLaboralTrabajadorCategoria = falta.IdConvenioLaboralTrabajadorCategoria,
                        Concepto = "FALTA POR HORAS",
                        Importe = falta.FaltasPorHoras
                    });
                }
            }
        }

        private void creaFaltasPorConvenio(ContratoSegunNomina item)
        {

            TimeSpan intervalo;
            int diasfaltas = 0;
            int totaldiasfaltas = 0;
            int agregadias = 0;

            foreach (var ele in getIncidenciasTrabajadores().Where(s =>
                s.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
        && s.EsAplicada == false
        && s.EsCerrada == true
        && s.EsCancelada == false
        && s.AñoParaNomina == this.Nomina_stNomina.Año && s.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
        && s.Catalogos_ctTipoIncidencia.EsAfectacionCalculoNomina == true
                 && (s.Catalogos_ctTipoIncidencia.Incidencia == "FALTA POR DÍA"
                 || s.Catalogos_ctTipoIncidencia.Incidencia == "FALTA POR EXCEDER HORAS DE PASES DE SALIDA"
                 || s.Catalogos_ctTipoIncidencia.Incidencia == "FALTA POR RETARDOS")
        && (s.IdIncidenciaJustificacion == 0 || s.Autorizo == false)
                 ).OrderBy(g => g.FechaInicio).ToList())
            {
                FaltasTrabajador ft = new FaltasTrabajador();
                FaltasTrabajador faltaAyuda = new FaltasTrabajador();
                FaltasTrabajador faltaEficiencia = new FaltasTrabajador();

                intervalo = ele.FechaTermino.Value - ele.FechaInicio;
                diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
                totaldiasfaltas = totaldiasfaltas + diasfaltas;
            }

            int totalfaltasPorHoras = 0;
            foreach (var ele in getIncidenciasTrabajadores().Where(s =>
              s.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
      && s.EsAplicada == false
      && s.EsCerrada == true
      && s.EsCancelada == false
        && s.AñoParaNomina == this.Nomina_stNomina.Año && s.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
      && s.Catalogos_ctTipoIncidencia.EsAfectacionCalculoNomina == true
               && s.Catalogos_ctTipoIncidencia.Incidencia == "FALTA POR HORAS"
      && (s.IdIncidenciaJustificacion == 0 || s.Autorizo == false)
               ).OrderBy(g => g.FechaInicio).ToList())
            {



                totalfaltasPorHoras = totalfaltasPorHoras + ele.Horas;
            }



            VariablesNominaTrabajador vnt3 = new VariablesNominaTrabajador();

            vnt3.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
            vnt3.Concepto = "FALTAS";
            vnt3.Importe = totaldiasfaltas;
            ListaVariablesNominaTrabajador.Add(vnt3);

            VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();

            vnt4.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
            vnt4.Concepto = "FALTA POR HORAS";
            vnt4.Importe = totalfaltasPorHoras;
            ListaVariablesNominaTrabajador.Add(vnt4);

        }

        //public  void  CalcularDiasDePago(   DateTime inicioNomina, DateTime finNomina)
        //    {
        //    ConveniosSegunNominas();

        //    this.resultadoMetodoDiasDePago = new List<ResultadoMetodoDiasDePago>();

        //    // Filtrar contratos relevantes para el período de nómina



        //    //foreach (var grupoTrabajador in ConveniosVigentesSegunNominas)
        //    //{
        //    //    var contratosOrdenados = grupoTrabajador.OrderBy(c => c.FechaInicio).ToList();
        //    //    var licenciasTrabajador = licencias.Where(l =>
        //    //        l.IdTrabajador == grupoTrabajador.Key &&
        //    //        l.FechaInicio <= finNomina &&
        //    //        l.FechaFin >= inicioNomina
        //    //    ).ToList();

        //   // var contratosPorTrabajador = ConveniosVigentesSegunNominas.GroupBy(c => c.IdTrabajador).ToList();


        //    var contratosConsolidados = ConsolidarContratosConsecutivos(ConveniosVigentesSegunNominas, inicioNomina, finNomina, Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.IdRelacionConvenioLaboral);


        //    foreach (var contrato in contratosConsolidados)
        //            {
        //                var fechaInicioCalculo = contrato.FechaInicio > inicioNomina ? contrato.FechaInicio : inicioNomina;
        //                var fechaFinCalculo = DeterminarFechaFinCalculo(contrato, finNomina);

        //                if (fechaInicioCalculo <= fechaFinCalculo)
        //                {
        //                    var diasPagados = CalcularDiasPagados(contrato,  fechaInicioCalculo, fechaFinCalculo);
        //                      diasPagados = AjustarDiasPagados(contrato, fechaInicioCalculo, fechaFinCalculo, diasPagados);

        //            if (diasPagados > 0 && contrato.IdRelacionConvenioLaboral== Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.IdRelacionConvenioLaboral)
        //                    {
        //                resultadoMetodoDiasDePago.Add(new ResultadoMetodoDiasDePago
        //                        {
        //                            IdTrabajador = contrato.IdTrabajador,
        //                            SePaga = true,
        //                            DiasPagados = diasPagados,
        //                            IdConvenioLaboralTrabajadorCategoria = contrato.IdConvenioLaboralTrabajadorCategoria,
        //                            IdRelacionConvenioLaboral=contrato.IdRelacionConvenioLaboral
        //                        });
        //                    }
        //                }


        //            creaFaltasPorConvenio(contrato);

        //            }
        //    //}

        //    // Transformación usando LINQ
        //    this.ListaVariablesNominaTrabajador = resultadoMetodoDiasDePago.Where( c=>
        //        c.IdRelacionConvenioLaboral == Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.IdRelacionConvenioLaboral
        //        )
        //        .Select(rp => new VariablesNominaTrabajador
        //        {
        //            IdConvenioLaboralTrabajadorCategoria = rp.IdConvenioLaboralTrabajadorCategoria,
        //            Importe = rp.DiasPagados,  // Asignamos DiasPagados al campo Importe
        //            Concepto = "DIASLABORADOS",
        //            IdTrabajador = rp.IdTrabajador  // Si deseas asignar IdTrabajador, puedes hacerlo aquí
        //        })
        //        .ToList();

        //    // Filtrar lista1 según los criterios de lista2
        //    TrabajadoresVigentes = TrabajadoresVigentes
        //        .Where(item1 =>
        //            resultadoMetodoDiasDePago.Any(item2 =>
        //                item2.IdConvenioLaboralTrabajadorCategoria == item1.IdConvenioLaboralTrabajadorCategoria &&
        //               item2.IdRelacionConvenioLaboral== Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.IdRelacionConvenioLaboral
        //               &&
        //                item2.SePaga == true
        //            )
        //        )
        //        .ToList();



           


        //}

        private  DateTime DeterminarFechaFinCalculo(ContratoSegunNomina contrato, DateTime finNomina)
            {
                var fechaFinEfectiva = contrato.FechaTermino ?? DateTime.MaxValue;
                if (contrato.FechaRenuncia.HasValue && contrato.FechaRenuncia < fechaFinEfectiva)
                {
                    fechaFinEfectiva = contrato.FechaRenuncia.Value;
                }
                return fechaFinEfectiva < finNomina ? fechaFinEfectiva : finNomina;
            }

            //private  int CalcularDiasPagados(ContratoSegunNomina contrato,  DateTime fechaInicio, DateTime fechaFin)
            //{
            //    int diasPagados = 0;
            //    for (var fecha = fechaInicio; fecha <= fechaFin; fecha = fecha.AddDays(1))
            //    {
            //        if (!LicenciasSinGoceSueldoSegunNominas.Any(l => l.FechaInicio <= fecha && fecha <= l.FechaTermino && 
            //        l.IdConvenioLaboralTrabajadorCategoria==contrato.IdConvenioLaboralTrabajadorCategoria ))
            //        {
            //            diasPagados++;
            //        }
            //    }
            //    return diasPagados;
            //}
        

        public void setDiasNoTrabajadosPorTrabajador()
        {

            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
            {
                List<Convenios_stConvenioLaboralTrabajadorCategoria> TrabajadoresVigentesPP = new List<Convenios_stConvenioLaboralTrabajadorCategoria>();
                //                using (var dbContext = new bdNovaEntities())
                //                {
                //                    dbContext.Database.Connection.Open();
                //                    //var solopropporcionales = TrabajadoresVigentes.Where(a => !Nomina_PartesProporcionales.Select(q => q.IdTrabajador).Contains(a.Convenios_stConvenioLaboralTrabajador.IdTrabajador)).ToList();

                //                    TrabajadoresVigentesPP = dbContext.Convenios_stConvenioLaboralTrabajadorCategoria
                //.AsNoTracking()
                //.Where(x => Nomina_PartesProporcionales.Select(a => a.IdConvenioLaboralTrabajadorCategoria).Contains(x.IdConvenioLaboralTrabajadorCategoria) &&
                //       x.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdRelacionConvenioLaboral == this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral
                //       )
                //.Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral)
                //.Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral)
                //.Include(u => u.Convenios_stConvenioLaboralTrabajador)
                //.Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador)
                //.Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales)
                //.Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Kardex_stDatosFamiliares)
                //.Include(x => x.Plazas_stDistribucionPlazaCategoria)
                //.Include(x => x.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria)
                //.Include(x => x.Plazas_stDistribucionPlazaCategoria.Catalogos_ctEstructuraOrganica)
                //.ToList();
                //                    dbContext.Database.Connection.Close();
                //                }
                TrabajadoresVigentes.Clear();
                TrabajadoresVigentes.AddRange(ConveniosTrabajadoresTodos.Where(x =>
 Nomina_PartesProporcionales.Select(a => a.IdConvenioLaboralTrabajadorCategoria).Contains(x.IdConvenioLaboralTrabajadorCategoria)).ToList());

                //ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral
                foreach (var trab in TrabajadoresVigentes)
                {
                    VariablesNominaTrabajador vnt2 = new VariablesNominaTrabajador();

                    vnt2.IdConvenioLaboralTrabajadorCategoria = trab.IdConvenioLaboralTrabajadorCategoria;
                    vnt2.Concepto = "DIASLABORADOS";
                    vnt2.Importe = this.DiasNomina;
                    ListaVariablesNominaTrabajador.Add(vnt2);
                }

                //var trab = TrabajadoresVigentes.Select(q => q.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToArray();

                //foreach (var eledel in solopropporcionales)
                //{
                //    TrabajadoresVigentes.Remove(eledel);
                //}
            }
            else
            {
                if (this.EsRecalculoPorTrabajador)
                {
                    foreach (var trab in TrabajadoresVigentes)
                    {
                        VariablesNominaTrabajador vnt2 = new VariablesNominaTrabajador();

                        vnt2.IdConvenioLaboralTrabajadorCategoria = trab.IdConvenioLaboralTrabajadorCategoria;
                        vnt2.Concepto = "DIASLABORADOS";
                        vnt2.Importe = this.DiasPagados;
                        ListaVariablesNominaTrabajador.Add(vnt2);
                    }
                }
                else
                {
                    CalcularDiasDePago(this.Nomina_stNomina.FechaInicio, this.Nomina_stNomina.FechaTermino, (int)this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral, this.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral);
                }

               // var trabajadores = this.TrabajadoresVigentes;


             //   setDiasNoTrabajadosPorTrabajadorLista(trabajadores);

               // setDiasNoTrabajadosPorTrabajadorLista(this.TrabajadoresVigentesPorTerminoComision);

            //    this.TrabajadoresVigentes.AddRange(TrabajadoresVigentesPorTerminoComision);

                //if (this.EsRecalculoPorTrabajador == false)
                //{
                //    foreach (var dato in TrabajadoresVigentesConContinuidaComision)
                //    {
                //        this.TrabajadoresVigentes.Remove(dato);
                //    }

                //    foreach (var dato in TrabajadoresVigentesPorBaja)
                //    {
                //        this.TrabajadoresVigentes.Remove(dato);
                //    }
                //}


                //elimina de la lista a los de permiso y/O licencias vigentes
                // que entren en el periodo de la nomina

                //ai l nomina es mayo a 15 dias puede ser una prima vacaional
                // solo se toman 15 dias de la qna para efectos de permisos
                //por eso no se toma la fecha de inicio de la nomina
                var fi_nomina = this.Nomina_stNomina.FechaInicio;

                if (this.Nomina_stNomina.FechaInicio.Month != this.Nomina_stNomina.FechaTermino.Month)
                {

                    if (this.Nomina_stNomina.FechaTermino.Day == 15)
                        fi_nomina = new DateTime(this.Nomina_stNomina.FechaTermino.Year, this.Nomina_stNomina.FechaTermino.Month, 1);
                    else
                        fi_nomina = new DateTime(this.Nomina_stNomina.FechaTermino.Year, this.Nomina_stNomina.FechaTermino.Month, 16);
                }

                //string query = @"select d.* from IncidenciaPermiso_stIncidenciaTrabajador a
                //inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
                //inner join Catalogos_ctTipoIncidenciaPermiso c on c.IdTipoIncidenciaPermiso = b.IdTipoIncidenciaPermiso
                //inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                //where c.TipoIncidenciaPermiso in( 'PERMISO', 'COMISIÓN') 
                //and a.FechaInicio <= '" + fi_nomina.ToString("yyyyMMdd") + @"' and ((a.FechaTermino>= '" + this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") + @"' or a.FechaTermino is null ) or ( a.FechaInicio >= '" + fi_nomina.ToString("yyyyMMdd") + @"' and a.FechaTermino>= '" + this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") + @"'))
                //  and a.EsCerrada = 1 and a.Autorizo = 1
                //union all
                //select d.* from IncidenciaPermiso_stIncidenciaTrabajador a
                //inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia = b.IdTipoIncidencia
                //inner join Catalogos_ctTipoIncidenciaPermiso c on c.IdTipoIncidenciaPermiso = b.IdTipoIncidenciaPermiso
                //inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
                //where c.TipoIncidenciaPermiso in(  'COMISIÓN') 
                //and a.FechaInicio >= '" + fi_nomina.ToString("yyyyMMdd") + @"' and ((a.FechaTermino>= '" + this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") + @"' or a.FechaTermino is null ) or ( a.FechaInicio >= '" + fi_nomina.ToString("yyyyMMdd") + @"' and a.FechaTermino>= '" + this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") + @"'))
                //  and a.EsCerrada = 1 and a.Autorizo = 1";



                ////elimina a lso trabajadores qeu su fecha de inicio de pago sea mayor al de la nomina
                //string sqleli = @" select IdConvenioLaboralTrabajadorCategoria FROM Convenios_stConvenioLaboralTrabajadorCategoria where EsPrimerCalculo=1 and fechainiciopago>'" + this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") + "'";

                //var pagosproximos = (List<Int64>)dp.connection.Query<Int64>(sqleli.ToString());

                //TrabajadoresVigentes.RemoveAll(a => pagosproximos.Contains(a.IdConvenioLaboralTrabajadorCategoria));

                DapperQuery dp = new DapperQuery("bdNovaEntities");


                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud)
                    if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES")
                       || this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PRESTACIONES ADICIONALES")
                        || this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("INDEMNIZA"))
                    {
                        string consulta = @"select IdConvenioLaboralTrabajadorCategoria from vwDatosAspirantesTrabajadoresHistorial where 
                    IdRelacionConvenioLaboral=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + @"
                 and cast(IdConvenioLaboralTrabajadorCategoria as nvarchar(20))+'-'+cast(year(fechatermino) as nvarchar(4)) in( 
                 select cast(IdConvenioLaboralTrabajadorCategoria as nvarchar(20))+'-'+cast(año as nvarchar(4)) from  Nomina_PartesProporcionales where IdNominaTrabajador is null)
                union 

                select IdConvenioLaboralTrabajadorCategoria from vwDatosAspirantesTrabajadores where 
                     EstatusTrabajador='BAJA' AND IdRelacionConvenioLaboral=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + @"
                 and cast(IdConvenioLaboralTrabajadorCategoria as nvarchar(20))+'-'+cast(year(fechatermino) as nvarchar(4)) in( 
                 select cast(IdConvenioLaboralTrabajadorCategoria as nvarchar(20))+'-'+cast(year(fechasolicitud) as nvarchar(4)) from  Nomina_PartesProporcionales where IdNominaTrabajador is null)
                                    union all
                                    select IdConvenioLaboralTrabajadorCategoria from vwDatosAspirantesTrabajadores where 
                     EstatusTrabajador='BAJA' AND IdRelacionConvenioLaboral=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + @"
                 and cast(IdConvenioLaboralTrabajadorCategoria as nvarchar(20))+'-'+cast(year(fechatermino) as nvarchar(4)) in( 
                 select cast(IdConvenioLaboralTrabajadorCategoria as nvarchar(20))+'-'+cast(year(fechasolicitud) as nvarchar(4)) from  Nomina_PrestacionesAdicionales where IdNominaTrabajador is null)";



                        var dadosdebaja = (List<Int64>)dp.connection.Query<Int64>(consulta.ToString());

                        dp.Close();


                        if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PRESTACIONES ADICIONALES"))
                        {
                            var soloadicionales = TrabajadoresVigentes.Where(a => !PrestacionesAdicionales.Select(q => q.Idtrabajador).Contains(a.Convenios_stConvenioLaboralTrabajador.IdTrabajador)).ToList();

                            var trab = TrabajadoresVigentes.Select(q => q.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToArray();

                            foreach (var eledel in soloadicionales)
                            {
                                TrabajadoresVigentes.Remove(eledel);
                            }


                            var noestanporlasfechadesucomision = PrestacionesAdicionales.Where(a => !trab.Contains((int)a.Idtrabajador)).Select(q => q.Idtrabajador).ToArray();
                            //las nominas de prestaciones se pueden calcular mas alla de su fecha y si los trabajaodres
                            //tiene comision hay que agregarlos

                            if (noestanporlasfechadesucomision.Count() > 0)
                            {
                                using (var basenova = new bdNovaEntities())
                                {
                                    basenova.Database.Connection.Open();
                                    var TrabajadoresVigentesConComisionFuera = basenova.Convenios_stConvenioLaboralTrabajadorCategoria.AsNoTracking()
                      .Where(x =>
                  noestanporlasfechadesucomision.Contains(x.Convenios_stConvenioLaboralTrabajador.IdTrabajador) &&
                  !dadosdebaja.Contains(x.IdConvenioLaboralTrabajadorCategoria) &&
                  x.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdRelacionConvenioLaboral == this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral
                  && x.FechaTermino != null
                  ).Include(u => u.Convenios_stConvenioLaboralTrabajador).Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador)
                        .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales)
                              .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Kardex_stDatosFamiliares)
                        .Include(x => x.Plazas_stDistribucionPlazaCategoria)
                        .Include(x => x.Plazas_stDistribucionPlazaCategoria.Catalogos_ctEstructuraOrganica)
                        .OrderByDescending(z => z.FechaInicio).ToList();

                                    TrabajadoresVigentes.AddRange(TrabajadoresVigentesConComisionFuera);
                                    basenova.Database.Connection.Close();
                                }
                            }
                        }


                        using (var basenova = new bdNovaEntities())
                        {
                            basenova.Database.Connection.Open();
                            var listabajas = basenova.Convenios_stConvenioLaboralTrabajadorCategoria
                                .AsNoTracking()
                            .Where(a => dadosdebaja.Contains(a.IdConvenioLaboralTrabajadorCategoria))
                            .Include(q => q.Convenios_stConvenioLaboralTrabajador)
                            .Include(s => s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador)
                            .ToList();

                            TrabajadoresVigentes.AddRange(listabajas);
                            basenova.Database.Connection.Close();


                            foreach (var trab in listabajas)
                            {
                                VariablesNominaTrabajador vnt2 = new VariablesNominaTrabajador();

                                vnt2.IdConvenioLaboralTrabajadorCategoria = trab.IdConvenioLaboralTrabajadorCategoria;
                                vnt2.Concepto = "DIASLABORADOS";
                                vnt2.Importe = this.DiasNomina;
                                ListaVariablesNominaTrabajador.Add(vnt2);
                            }
                        }
                        ////TrabajadoresVigentes que solo tiene comision
                        //if (fuera.Count > 0 && !this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                        //{
                        //    var quenoexistanenvigentes = fuera.Where(a => !TrabajadoresVigentes.Select(q => q.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Contains(a.Convenios_stConvenioLaboralTrabajador.IdTrabajador)).ToList();
                        //    TrabajadoresVigentes.AddRange(quenoexistanenvigentes);
                        //}
                    }
                dp.Close();


                using (var dbContext = new bdNovaEntities())
                {
                    dbContext.Database.Connection.Open();

                    
                    var tv = TrabajadoresVigentes
.OrderBy(q => q.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex)
.Select(s => s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex)
.ToList();  // Convertir a lista directamente

                    TrabajadoresVigentesKardex_stDatosFamiliares = dbContext.Kardex_stDatosFamiliares
                        .AsNoTracking()
                        .Where(s => tv.Contains(s.IdKardex))
                        .Include(a => a.Kardex_ctParentesco)
                        .ToList();

                    TrabajadoresVigentesKardex_ctDatosPersonales = dbContext.Kardex_ctDatosPersonales
                        .AsNoTracking()
                        .ToList();

                    ConveniosTrabajadoresTodos = dbContext.Convenios_stConvenioLaboralTrabajadorCategoria
                        .AsNoTracking()
                        .Include(u => u.Catalogos_ctEstructuraOrganica)
                        .Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral)
                        .Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral)
        .Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral)
        .Include(u => u.Convenios_stConvenioLaboralTrabajador)
        .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador)
        .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales)
        .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Kardex_stDatosFamiliares)
        .Include(x => x.Plazas_stDistribucionPlazaCategoria)
                .Include(x => x.Plazas_stDistribucionPlazaCategoria.Catalogos_ctEstructuraOrganica)
        .Include(x => x.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria)
        .Include(x => x.Plazas_stDistribucionPlazaCategoria.Catalogos_ctEstructuraOrganica)

                        .ToList();

                    dbContext.Database.Connection.Close();
                }


            }


        }

        // Carga nóminas pagadas (bimestre anterior)

        private void setNominasBimestreAnteriorPagadas(int IdRelacionConvenioLaboral)
        {
            ListaNominasAnteriormentePagadasTrabajadores = this.getNominasAnteriormentePagadas(IdRelacionConvenioLaboral);
            if (ListaNominasAnteriormentePagadasTrabajadores == null)
                throw new ApplicationException("No hay datos de nóminas pagadas del bimestre inmediato anterior a la nómina actual");
        }

        // Nóminas pagadas por trabajador (bimestre anterior)

        //public void setBimestreAnteriorPagadasTrabajador(int IdConvenioLaboralTrabajadorCategoria)
        //{
        //    ListaNominasAnteriormentePagadasTrabajador = this.ListaNominasAnteriormentePagadasTrabajadores.Where(x => x.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();
        //    if (ListaNominasAnteriormentePagadasTrabajador == null)
        //        throw new ApplicationException("No hay datos de nóminas pagadas del bimestre inmediato anterior a la nómina actual para este trabajador");
        //}

        private List<Nomina_stNominaTrabajador> getNominasAnteriormentePagadas(int IdRelacionConvenioLaboral)
        {

            var Bimestre1 = new string[] { "01", "02", "03", "04" };
            var Bimestre2 = new string[] { "05", "06", "07", "08" };
            var Bimestre3 = new string[] { "09", "10", "11", "12" };
            var Bimestre4 = new string[] { "13", "14", "15", "16" };
            var Bimestre5 = new string[] { "17", "18", "19", "20" };
            var Bimestre6 = new string[] { "21", "22", "23", "24" };
            int año = Nomina_stNomina.Año;
            int QnaMes = Convert.ToInt16(Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes);
            if (ListaNominasAnteriormentePagadasTrabajadores.Count == 0)
            {
                using (var db = new bdNovaEntities())
                {
                    db.Database.Connection.Open();

                    switch (QnaMes)
                    {
                        case 1:
                        case 2:
                        case 3:
                        case 4:
                            año = año - 1;
                            ListaNominasAnteriormentePagadasTrabajadores = db.Nomina_stNominaTrabajador.AsNoTracking().Where(x =>
                            x.Nomina_stNominaTrabajadorEstatus.Nomina_stNominaTrabajadorEstatusGrupo.EstatusNominaGrupo == "PARA PAGO"
                            && x.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO" &&
                            Bimestre6.Contains(x.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes) && x.Nomina_stNomina.Año == año)
                                   .Include(q => q.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                                   .Include(q => q.Nomina_stNomina.Nomina_ctTipoCalculo)
                                   .ToList();
                            break;

                        case 5:
                        case 6:
                        case 7:
                        case 8:
                            ListaNominasAnteriormentePagadasTrabajadores = db.Nomina_stNominaTrabajador.AsNoTracking().Where(x =>
                            x.Nomina_stNominaTrabajadorEstatus.Nomina_stNominaTrabajadorEstatusGrupo.EstatusNominaGrupo == "PARA PAGO" &&
                            x.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO" &&
                            Bimestre1.Contains(x.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes) && x.Nomina_stNomina.Año == año)
                                    .Include(q => q.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                                    .Include(q => q.Nomina_stNomina.Nomina_ctTipoCalculo)
                                    .ToList();
                            break;

                        case 9:
                        case 10:
                        case 11:
                        case 12:
                            ListaNominasAnteriormentePagadasTrabajadores = db.Nomina_stNominaTrabajador.AsNoTracking().Where(x =>
                            x.Nomina_stNominaTrabajadorEstatus.Nomina_stNominaTrabajadorEstatusGrupo.EstatusNominaGrupo == "PARA PAGO" &&
                            x.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO" &&
                            Bimestre2.Contains(x.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes) && x.Nomina_stNomina.Año == año)
                                    .Include(q => q.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                                    .Include(q => q.Nomina_stNomina.Nomina_ctTipoCalculo)
                                    .ToList();
                            break;

                        case 13:
                        case 14:
                        case 15:
                        case 16:
                            ListaNominasAnteriormentePagadasTrabajadores = db.Nomina_stNominaTrabajador.AsNoTracking().Where(x =>
                            x.Nomina_stNominaTrabajadorEstatus.Nomina_stNominaTrabajadorEstatusGrupo.EstatusNominaGrupo == "PARA PAGO" &&
                            x.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO" &&
                            Bimestre3.Contains(x.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes) && x.Nomina_stNomina.Año == año)
                                    .Include(q => q.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                                    .Include(q => q.Nomina_stNomina.Nomina_ctTipoCalculo)
                                    .ToList();
                            break;

                        case 17:
                        case 18:
                        case 19:
                        case 20:
                            ListaNominasAnteriormentePagadasTrabajadores = db.Nomina_stNominaTrabajador.AsNoTracking().Where(x =>
                            x.Nomina_stNominaTrabajadorEstatus.Nomina_stNominaTrabajadorEstatusGrupo.EstatusNominaGrupo == "PARA PAGO" &&
                            x.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO" &&
                            Bimestre4.Contains(x.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes) && x.Nomina_stNomina.Año == año)
                                    .Include(q => q.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                                    .Include(q => q.Nomina_stNomina.Nomina_ctTipoCalculo)
                                    .ToList();
                            break;

                        case 21:
                        case 22:
                        case 23:
                        case 24:
                            ListaNominasAnteriormentePagadasTrabajadores = db.Nomina_stNominaTrabajador.AsNoTracking().Where(x =>
                            x.Nomina_stNominaTrabajadorEstatus.Nomina_stNominaTrabajadorEstatusGrupo.EstatusNominaGrupo == "PARA PAGO" &&
                            x.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO" &&
                            Bimestre5.Contains(x.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes) && x.Nomina_stNomina.Año == año)
                                    .Include(q => q.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                                    .Include(q => q.Nomina_stNomina.Nomina_ctTipoCalculo)
                                    .ToList();
                            break;
                    }

                    db.Database.Connection.Close();
                }

            }
            return ListaNominasAnteriormentePagadasTrabajadores;
        }

        public void setApoyosEstudios()
        {
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                ListaNominaApoyoEstudios = basenova.Nomina_ApoyoEstudios.Where(p => (p.FechaInicio <= this.Nomina_stNomina.FechaInicio && p.FechaTermino == null) || (p.FechaInicio <= this.Nomina_stNomina.FechaInicio && p.FechaTermino >= this.Nomina_stNomina.FechaTermino)).ToList();
                basenova.Database.Connection.Close();
            }

        }


        public void setLicenciasDescuentosDiasEconomicosYPuntualidad()
        {
            string query;

            DapperQuery dpa = new DapperQuery("bdNovaEntities");

            int añoproceso = 0;
            
                añoproceso = this.Nomina_stNomina.FechaTermino.Year-1;



            query = @"SELECT *
  FROM vwLicenciasTrabajadores
  where (tipoIncidenciaPermiso='PERMISO' and (incidencia not like '%CONFIANZA%'  AND incidencia not like '%CAMBIO DE NOMINA%') )
  AND (YEAR(FechaTerminoIncidencia)=" + añoproceso + "  or YEAR(FechaInicioIncidencia)=" + añoproceso + " ) order by idtrabajador, FechaInicioIncidencia ";


            this.LicenciasTrabajadoresDiasEconomicosPuntualidad = (List<vwLicenciasTrabajadores>)dpa.connection.Query<vwLicenciasTrabajadores>(query.ToString());

            dpa.Close();

        }
        public void setLicenciasPrimaVacaional(int año =0)
        {
            string query;

            DapperQuery dpa = new DapperQuery("bdNovaEntities");

            int añoproceso = 0;
            if (año > 0)
                añoproceso = año;
            else
            añoproceso = this.Nomina_stNomina.FechaTermino.Year;

            
               
            query = @"SELECT *
  FROM vwLicenciasTrabajadores
  where (tipoIncidenciaPermiso='PERMISO' and (incidencia not like '%CONFIANZA%'  AND incidencia not like '%CAMBIO DE NOMINA%') )
  AND YEAR(FechaTerminoIncidencia)=" +añoproceso + " order by idtrabajador, fechaterminoincidencia desc";


            this.LicenciasTrabajadoresPrimavacacional = (List<vwLicenciasTrabajadores>)dpa.connection.Query<vwLicenciasTrabajadores>(query.ToString());

            dpa.Close();

        }

        public void setLicenciasIncapacidadesVigentes()
        {
            string query;

            DapperQuery dpa = new DapperQuery("bdNovaEntities");

            query = @"SELECT *
  FROM vwLicenciasTrabajadores
  where (tipoIncidenciaPermiso='INCAPACIDAD')
  AND estatus='ACTIVA' order by idtrabajador, fechaterminoincidencia desc";

            this.LicenciasTrabajadoresIncapacidades = (List<vwLicenciasTrabajadores>)dpa.connection.Query<vwLicenciasTrabajadores>(query.ToString());

            dpa.Close();

        }
        public void setSolicitudesPartesProporcionales()
        {
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                Nomina_PartesProporcionales = basenova.Nomina_PartesProporcionales
                    .AsNoTracking().Where(p => (p.IdNominaTrabajador == null))
                    .Include(a => a.Convenios_stConvenioLaboralTrabajadorCategoria)
                    .ToList();
                basenova.Database.Connection.Close();
            }

            DapperQuery dpa = new DapperQuery("bdNovaEntities");

            //            string query = @"Select max(IdConvenioLaboralTrabajadorCategoria) as  IdConvenioLaboralTrabajadorCategoria, Año,a.IdTrabajador from vwDatosAspirantesTrabajadoresHistorial a inner join 
            //Nomina_PartesProporcionales b on a.IdTrabajador=b.IdTrabajador where IdNominaTrabajador is null
            //group by Año,a.IdTrabajador
            //order by a.IdTrabajador,año";
            string query = @"  Select max(a.IdConvenioLaboralTrabajadorCategoria) as  IdConvenioLaboralTrabajadorCategoria, Año,a.IdTrabajador from vwDatosAspirantesTrabajadoresHistorial a inner join 
Nomina_PartesProporcionales b on a.IdTrabajador=b.IdTrabajador where IdNominaTrabajador is null
and a.IdConvenioLaboralTrabajadorCategoria <= b.IdConvenioLaboralTrabajadorCategoria
group by Año,a.IdTrabajador
order by a.IdTrabajador,año";
            dpa.Close();

            PartesProporcionalesUltimoContrato = (List<PartesProporcionalesUltimoContrato>)dpa.connection.Query<PartesProporcionalesUltimoContrato>(query.ToString());

            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                Nomina_ctTipoPartesProporcionales = basenova.Nomina_ctTipoPartesProporcionales.AsNoTracking().ToList();
                basenova.Database.Connection.Close();
            }


        }

        private void setHorariosDocentesGenerales(DapperQuery dp, string condicion, bool soloHoras = false, bool HorasAgrupadas = false,string fechaIncicencia = null,int idkardex=0)
        {
            string query;


            //revisamos la pnatilla para saber si es una nomina de 
            //horas extraordinarias y se establcen lso tipos d ehora suqe se mostraran

            string condiciontipohorarios = " a.IdTipoHoras not in (39,40,41,42)  ";
            if (Nomina_stNomina!=null)
            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("HORAS EXTRAORDINARIAS"))
            {
                condiciontipohorarios = " a.IdTipoHoras  in (39,40,41,42)  ";
            }

            string queryselect = @"IdHorarioNominaDocente
      , a.IdKardex
      ,a.IdCicloEscolar
      ,a.IdDia
      ,a.IdTipoHoras
      ,HoraInicio
      ,HoraFinal
      ,Horas
      ,a.IdModalidadEstudio
      ,NoAutorizadas
      ,a.Vigente
      ,FechaMovimiento
      ,FechaInicioPago
      ,FechaFinalPago
      ,Aplicado
      ,MarcarEliminado
      ,InmediatoAnterior
      ,IdHorarioTabla
      ,x.Nombre as Dia
      ,IdHorario,b.Nombre as TipoHoras
      ,c.IdConvenioLaboralTrabajadorCategoria
      ,c.RFC
      ,c.CURP
      ,c.Nombre
      ,ApellidoPaterno
      ,ApellidoMaterno
      ,Sexo
      ,IdTrabajador
      ,FechaAsignacion
      ,ConvenioLaboral
      ,RelacionLaboral
      ,Categoria
      ,EstructuraOrganica
      ,EstructuraOrganicaPadrePlaza
      ,UbicacionFisica
      ,EstructuraOrganicaPadre
      ,EsComisionado
      ,FechaInicio
      ,FechaTermino
      ,IdConvenioLaboralTrabajador
      ,EstatusTrabajador
      ,Fotografia
      ,NSS
      ,CorreoElectronico
      ,IdCategoria
      ,IdEstructuraOrganica
      ,IdRelacionLaboral
      ,IdConvenioLaboral
      ,IdEstructuraOrganicaPadre
      ,CorreoInstitucional
      ,Telefono
      ,OrdenEstructuraOrganica
      ,IdEstructuraOrganicaFisica
      ,Antiguedad
      ,Años
      ,Meses
      ,Dias
      ,Direccion
      ,CorreoTrabajo
      ,TelefonoTrabajo
      ,ProcesoCompletado
      
      ,IdDistribucionPlazaCategoria
      ,IdRelacionConvenioLaboral
      ,IdeEmpleadoAnt
      ,EsHomologado
      ,CategoriaAnteriorNova
      ,RelacionConvenioLaboral
      ,Incidencia
      ,RestringirMenu";




            string queryorder = " order by a.idkardex,a.IdDia,HoraInicio";

            string queryselectgroup = @"sum(Horas) AS Horas  
     ,a.IdModalidadEstudio
     , b.Nombre as TipoHoras
      ,c.Nombre
      ,ApellidoPaterno
      ,ApellidoMaterno
      ,IdTrabajador
      ,ConvenioLaboral
      ,Categoria
      ,UbicacionFisica
      ,w.Nombre as CicloEscolar
      ";

            string querygroup = @" group by a.IdModalidadEstudio
     , b.Nombre
      ,c.Nombre
      ,ApellidoPaterno
      ,ApellidoMaterno
      ,IdTrabajador
      ,ConvenioLaboral
      ,Categoria
      ,UbicacionFisica
      ,w.Nombre ";


            string queryselectgroupHoras = @"sum(Horas) AS Horas
     ,a.IdModalidadEstudio
     ,'' as TipoHoras
      ,c.Nombre
      ,ApellidoPaterno
      ,ApellidoMaterno
      ,IdTrabajador
      ,ConvenioLaboral
      ,Categoria
      ,UbicacionFisica
      ,w.Nombre as CicloEscolar
      ";
            string queryselectgroupHorasClub = @" union all select sum(Horas) AS Horas
     ,a.IdModalidadEstudio
     ,'CLUB' as TipoHoras
      ,c.Nombre
      ,ApellidoPaterno
      ,ApellidoMaterno
      ,IdTrabajador
      ,ConvenioLaboral
      ,Categoria
      ,UbicacionFisica
      ,w.Nombre as CicloEscolar
      ";

            string querygroupHoras = @" group by a.IdModalidadEstudio
        ,c.Nombre
      ,ApellidoPaterno
      ,ApellidoMaterno
      ,IdTrabajador
      ,ConvenioLaboral
      ,Categoria
      ,UbicacionFisica
      ,w.Nombre";

            string condicionfechas = "";

            if (this.Nomina_stNomina != null)
            {
                condicionfechas = $@" and (( a.FechaInicioPago <= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND a.FechaFinalPago >= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' ) 
                   or (a.FechaInicioPago >= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND a.FechaFinalPago >= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}') or  (a.FechaInicioPago<='{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' and a.FechaFinalPago>='{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' ) ) ";
            }


            //           string sqlcuerpoGeneral = @" FROM stHorarioNominaDocente a
            // inner join ctTipoHoras b on a.IdTipoHoras=b.IdTipoHoras and a.IdModalidadEstudio=b.IdModalidadEstudio
            // inner join ctDia  x on x.IdDia=a.IdDia
            // inner join ctCicloescolar w on w.IdCicloEscolar=a.IdCicloEscolar
            // left join bdnova.dbo.vwDatosAspirantesTrabajadores c on c.IdKardex=a.IdKardex where 
            //a.Vigente=1  " + condicionfechas + " and ((c.Incidencia is null or c.Incidencia like '%INCAPACIDAD%' or c.Incidencia like '%LICENCIA%' ) and  c.EstatusTrabajador<>'PROXIMAMENTE')  and a.IdCicloEscolar=" + this.IdCicloEscolarVigentePlantel;

            //           string sqlcuerpoGeneraltodos = @" FROM stHorarioNominaDocente a
            // inner join ctTipoHoras b on a.IdTipoHoras=b.IdTipoHoras and a.IdModalidadEstudio=b.IdModalidadEstudio
            // inner join ctDia  x on x.IdDia=a.IdDia
            // inner join ctCicloescolar w on w.IdCicloEscolar=a.IdCicloEscolar
            // left join bdnova.dbo.vwDatosAspirantesTrabajadores c on c.IdKardex=a.IdKardex where 
            //a.Vigente=1  and ((c.Incidencia is null or c.Incidencia like '%INCAPACIDAD%' or c.Incidencia like '%LICENCIA%' ) and  c.EstatusTrabajador<>'PROXIMAMENTE')   ";

            DateTime fechafinlinInci;

            if (fechaIncicencia != null)
                fechafinlinInci = DateTime.Parse($"{fechaIncicencia.Substring(0,4)}-{fechaIncicencia.Substring(4,2)}-{fechaIncicencia.Substring(6, 2)}");
            else
                if (this.Nomina_stNomina!=null)
                fechafinlinInci =  this.Nomina_stNomina.FechaInicio;
            else
                fechafinlinInci = DateTime.Now;

            if (idkardex > 0)
                condicion = condicion + $" and c.idkardex={idkardex} ";

                     string dbnameNova = GetDatabaseName("bdNovaEntities");

            string sqlcuerpoGeneral = @" FROM stHorarioNominaDocente a
  inner join ctTipoHoras b on a.IdTipoHoras=b.IdTipoHoras and a.IdModalidadEstudio=b.IdModalidadEstudio
  inner join ctDia  x on x.IdDia=a.IdDia
  inner join ctCicloescolar w on w.IdCicloEscolar=a.IdCicloEscolar
  left join "+ dbnameNova + ".dbo.vwDatosAspirantesTrabajadores c on c.IdKardex=a.IdKardex where "+condiciontipohorarios+ @"  and c.relacionConvenioLaboral like '%DOCENTE%'  
  and  ( (c.RestringirMenu is not null and c.FechaInicioLicencia>'" + fechafinlinInci.ToString("yyyyMMdd")  + @"') 
or (c.RestringirMenu is not null and c.FechaTerminoLicencia<'" + fechafinlinInci.ToString("yyyyMMdd")  + @"')
or c.RestringirMenu is null or (c.RestringirMenu is not null and c.Incidencia  like '%INCAPACIDAD%')) and
 a.Vigente=1  " + condicionfechas + " and (MarcarEliminado is null or MarcarEliminado =0) and  ((c.Incidencia is null or c.Incidencia like '%INCAPACIDAD%' or c.Incidencia like '%LICENCIA%' ) )   and a.IdCicloEscolar=" + this.IdCicloEscolarVigentePlantel;

            string sqlcuerpoGeneraltodos = @" FROM stHorarioNominaDocente a
  inner join ctTipoHoras b on a.IdTipoHoras=b.IdTipoHoras and a.IdModalidadEstudio=b.IdModalidadEstudio
  inner join ctDia  x on x.IdDia=a.IdDia
  inner join ctCicloescolar w on w.IdCicloEscolar=a.IdCicloEscolar
  left join "+ dbnameNova + ".dbo.vwDatosAspirantesTrabajadores c on c.IdKardex=a.IdKardex where  "+condiciontipohorarios+ @" and c.relacionConvenioLaboral like '%DOCENTE%'  
  and  (  (c.RestringirMenu is not null and c.FechaInicioLicencia>'" + fechafinlinInci.ToString("yyyyMMdd")  + @"') 
or (c.RestringirMenu is not null and c.FechaTerminoLicencia<'" + fechafinlinInci.ToString("yyyyMMdd")  + @"')
or  c.RestringirMenu is null or (c.RestringirMenu is not null and c.Incidencia  like '%INCAPACIDAD%')) and
 a.Vigente=1 and (MarcarEliminado is null or MarcarEliminado =0) and    ((c.Incidencia is null or c.Incidencia like '%INCAPACIDAD%' or c.Incidencia like '%LICENCIA%' ) )  ";


            if (soloHoras)
            {
                if (HorasAgrupadas)
                {
                    condicion = " and b.Nombre not like '%HORAS CLUB%' ";
                    query = @" SELECT " + queryselectgroupHoras + sqlcuerpoGeneral
                        + condicion + " " + querygroupHoras;

                    string condicion2 = " and  b.Nombre like '%HORAS CLUB%' ";

                    query = query + queryselectgroupHorasClub + sqlcuerpoGeneral
                        + condicion2 + " " + querygroupHoras + "  order by idTrabajador";
                }
                else
                    query = @"SELECT " + queryselectgroup + sqlcuerpoGeneral
                        + condicion + " " + querygroup + "  order by idTrabajador";

                ListaHorasPorDocente = (List<HorasPorDocente>)dp.connection.Query<HorasPorDocente>(query.ToString());
            }
            else
            {
               
                string qdt = $" union  {@"SELECT " + queryselect + sqlcuerpoGeneraltodos + condicion + " and  a.Vigente=1   and a.Aplicado=0 "}";
                query = @"SELECT " + queryselect + sqlcuerpoGeneral + condicion + qdt + " " + queryorder;


                NominaHorariosDocentesDetalle = (List<NominaHorariosDocentesDetalle>)dp.connection.Query<NominaHorariosDocentesDetalle>(query.ToString());
                if (this.Nomina_stNomina != null)
                {
                    string condi2 = $@"  and (a.FechaFinalPago between '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND   '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' 
 or a.FechaInicioPago between '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND   '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'  or FechaFinalPago>='{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'  )";


                    QueryHorariosDocentesDetalle = query = @"SELECT " + queryselect + sqlcuerpoGeneraltodos;

                    string qd = $" union  {@"SELECT " + queryselect + sqlcuerpoGeneraltodos + " and  a.Vigente=1    "}";
                    query = @"SELECT " + queryselect + sqlcuerpoGeneraltodos + condi2 + qd + " order by a.IdCicloEscolar, a.idkardex,a.IdDia,HoraInicio ";


                    NominaHorariosDocentesDetallePorFecha = (List<NominaHorariosDocentesDetalle>)dp.connection.Query<NominaHorariosDocentesDetalle>(query.ToString());

//                    string dbnameAries = GetDatabaseName("bdAriesEntities");

//                    string sqlhorario = $@"SELECT b.*, CAST(a.IdNominaTrabajador AS BIGINT) as IdNominaTrabajador
//  FROM  [Nomina_stNominaHorariosDocentes] a
//  inner join {dbnameAries}.[dbo].[stHorarioNominaDocente] b on a.IdHorarioNominaDocente=b.IdHorarioNominaDocente
//and year(fechainiciopago)>{(this.Nomina_stNomina.FechaTermino.Year - 2)}";


//                    HorariosPagadoDocentes = (List<NominaHorariosDocentesDetalle>)dp.connection.Query<NominaHorariosDocentesDetalle>(sqlhorario.ToString());

                }
            }



        }

        public void sethorariosdocentesPorFechasAnteriores(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");
            string condi2 = "";
            if (cltc.FechaTermino != null)

                condi2 = $@"  and c.IdConvenioLaboralTrabajadorCategoria={cltc.IdConvenioLaboralTrabajadorCategoria} and (a.FechaFinalPago between '{cltc.FechaInicio.ToString("yyyyMMdd")}' AND   '{cltc.FechaTermino.Value.ToString("yyyyMMdd")}' 
 or a.FechaInicioPago between '{cltc.FechaInicio.ToString("yyyyMMdd")}' AND   '{cltc.FechaTermino.Value.ToString("yyyyMMdd")}'  or FechaFinalPago>='{cltc.FechaTermino.Value.ToString("yyyyMMdd")}'  )";
            else
                condi2 = $@" and c.IdConvenioLaboralTrabajadorCategoria={cltc.IdConvenioLaboralTrabajadorCategoria}  and (a.FechaFinalPago between '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND   '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' 
 or a.FechaInicioPago between '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND   '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'  or FechaFinalPago>='{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'  )";


            
                var qt = QueryHorariosDocentesDetalle.Replace("and c.EstatusTrabajador<>'PROXIMAMENTE'"," ");
                  qt = qt.Replace("and  c.EstatusTrabajador<>'PROXIMAMENTE'", " ");


            var QueryHorariosDocentesDetalletempo = qt + condi2 + " order by a.IdCicloEscolar, a.idkardex,a.IdDia,HoraInicio ";



            var tempo = (List<NominaHorariosDocentesDetalle>)dp.connection.Query<NominaHorariosDocentesDetalle>(QueryHorariosDocentesDetalletempo.ToString());
            NominaHorariosDocentesDetallePorFecha.AddRange(tempo);
            dp.Close();
        }

        //       private void setHorariosDocentesGenerales(DapperQuery dp, string condicion, bool soloHoras = false, bool HorasAgrupadas = false)
        //       {
        //           string query;


        //           query = @"SELECT  IdDocentesHorasPago 
        //     , IdConvenioLaboralTrabajadorCategoria 
        //     , TotalHorasPago 
        //     , ImparteClases 
        //       ,HorasClub
        // FROM  bdnova.dbo.Nomina_DocentesHorasPago ";

        //           DocentesHorasAPagar.Clear();

        //           ListaNomina_DocentesHorasPago = (List<Nomina_DocentesHorasPago>)dp.connection.Query<Nomina_DocentesHorasPago>(query.ToString());

        //           string queryselect = @"IdHorarioNominaDocente
        //     , a.IdKardex
        //     ,a.IdCicloEscolar
        //     ,a.IdDia
        //     ,a.IdTipoHoras
        //     ,HoraInicio
        //     ,HoraFinal
        //     ,Horas
        //     ,a.IdModalidadEstudio
        //     ,NoAutorizadas
        //     ,a.Vigente
        //     ,FechaMovimiento
        //     ,FechaInicioPago
        //     ,FechaFinalPago
        //     ,Aplicado
        //     ,MarcarEliminado
        //     ,InmediatoAnterior
        //     ,IdHorarioTabla
        //     ,x.Nombre as Dia
        //     ,IdHorario,b.Nombre as TipoHoras
        //     ,c.IdConvenioLaboralTrabajadorCategoria
        //     ,c.RFC
        //     ,c.CURP
        //     ,c.Nombre
        //     ,ApellidoPaterno
        //     ,ApellidoMaterno
        //     ,Sexo
        //     ,IdTrabajador
        //     ,FechaAsignacion
        //     ,ConvenioLaboral
        //     ,RelacionLaboral
        //     ,Categoria
        //     ,EstructuraOrganica
        //     ,EstructuraOrganicaPadrePlaza
        //     ,UbicacionFisica
        //     ,EstructuraOrganicaPadre
        //     ,EsComisionado
        //     ,FechaInicio
        //     ,FechaTermino
        //     ,IdConvenioLaboralTrabajador
        //     ,EstatusTrabajador
        //     ,Fotografia
        //     ,NSS
        //     ,CorreoElectronico
        //     ,IdCategoria
        //     ,IdEstructuraOrganica
        //     ,IdRelacionLaboral
        //     ,IdConvenioLaboral
        //     ,IdEstructuraOrganicaPadre
        //     ,CorreoInstitucional
        //     ,Telefono
        //     ,OrdenEstructuraOrganica
        //     ,IdEstructuraOrganicaFisica
        //     ,Antiguedad
        //     ,Años
        //     ,Meses
        //     ,Dias
        //     ,Direccion
        //     ,CorreoTrabajo
        //     ,TelefonoTrabajo
        //     ,ProcesoCompletado

        //     ,IdDistribucionPlazaCategoria
        //     ,IdRelacionConvenioLaboral
        //     ,IdeEmpleadoAnt
        //     ,EsHomologado
        //     ,CategoriaAnteriorNova
        //     ,RelacionConvenioLaboral
        //     ,Pk
        //     ,Incidencia
        //     ,RestringirMenu
        //     ,CASE WHEN RestringirMenu  IS not NULL  THEN CASE WHEN c.Incidencia  like '%INCAPACIDAD%' or c.Incidencia like '%NOMINA%' THEN 1  ELSE 0 END  ELSE 1 END  AS VALIDO";




        //           string queryorder = "  ) as q where VALIDO=1 order by  idkardex,IdDia,HoraInicio";

        //           string queryselectgroup = @"sum(Horas) AS Horas  
        //    ,a.IdModalidadEstudio
        //    , b.Nombre as TipoHoras
        //     ,c.Nombre
        //     ,ApellidoPaterno
        //     ,ApellidoMaterno
        //     ,IdTrabajador
        //     ,ConvenioLaboral
        //     ,Categoria
        //     ,UbicacionFisica
        //     ,w.Nombre as CicloEscolar
        //     ";

        //           string querygroup = @" group by a.IdModalidadEstudio
        //    , b.Nombre
        //     ,c.Nombre
        //     ,ApellidoPaterno
        //     ,ApellidoMaterno
        //     ,IdTrabajador
        //     ,ConvenioLaboral
        //     ,Categoria
        //     ,UbicacionFisica
        //     ,w.Nombre ";


        //           string queryselectgroupHoras = @"sum(Horas) AS Horas
        //    ,a.IdModalidadEstudio
        //    ,'' as TipoHoras
        //     ,c.Nombre
        //     ,ApellidoPaterno
        //     ,ApellidoMaterno
        //     ,IdTrabajador
        //     ,ConvenioLaboral
        //     ,Categoria
        //     ,UbicacionFisica
        //     ,w.Nombre as CicloEscolar
        //     ";
        //           string queryselectgroupHorasClub = @" union all select sum(Horas) AS Horas
        //    ,a.IdModalidadEstudio
        //    ,'CLUB' as TipoHoras
        //     ,c.Nombre
        //     ,ApellidoPaterno
        //     ,ApellidoMaterno
        //     ,IdTrabajador
        //     ,ConvenioLaboral
        //     ,Categoria
        //     ,UbicacionFisica
        //     ,w.Nombre as CicloEscolar
        //     ";

        //           string querygroupHoras = @" group by a.IdModalidadEstudio
        //       ,c.Nombre
        //     ,ApellidoPaterno
        //     ,ApellidoMaterno
        //     ,IdTrabajador
        //     ,ConvenioLaboral
        //     ,Categoria
        //     ,UbicacionFisica
        //     ,w.Nombre";

        //           string condicionfechas = "";

        //           if (this.Nomina_stNomina != null)
        //           {
        //               //condicionfechas = $@" and (( a.FechaInicioPago <= '{ this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd") }' AND a.FechaFinalPago >= '{ this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") }' ) 
        //               //   or (a.FechaInicioPago >= '{ this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd") }' AND a.FechaFinalPago >= '{ this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") }') or  (a.FechaInicioPago<='{ this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") }' and a.FechaFinalPago>='{ this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd") }' ) ) ";

        //               condicionfechas = $@"  and ((FechaInicioPago BETWEEN '{ this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd") }' AND '{ this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") }')
        //  OR (FechaFinalPago BETWEEN '{ this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd") }' AND '{ this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") }')
        //  OR (FechaInicioPago <= '{ this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd") }' AND FechaFinalPago >= '{ this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") }'))";
        //           }


        //           string sqlcuerpoGeneral = @" FROM stHorarioNominaDocente a
        // inner join ctTipoHoras b on a.IdTipoHoras=b.IdTipoHoras and a.IdModalidadEstudio=b.IdModalidadEstudio
        // inner join ctDia  x on x.IdDia=a.IdDia
        // inner join ctCicloescolar w on w.IdCicloEscolar=a.IdCicloEscolar
        // left join bdnova.dbo.vwDatosAspirantesTrabajadores c on c.IdKardex=a.IdKardex and c.restringirmenu is null where 
        //a.Vigente=1  " + condicionfechas + " ";
        ////a.Vigente=1  " + condicionfechas + " and ((c.Incidencia is null or c.Incidencia like '%INCAPACIDAD%' or c.Incidencia like '%NOMINA%' ) and  c.EstatusTrabajador<>'PROXIMAMENTE') ";
        ////" and a.IdCicloEscolar=" + this.IdCicloEscolarVigentePlantel;

        //           if (soloHoras)
        //           {
        //               if (HorasAgrupadas)
        //               {
        //                   condicion = " and b.Nombre not like '%HORAS CLUB%' ";
        //                   query = @" SELECT " + queryselectgroupHoras + sqlcuerpoGeneral
        //                       + condicion + " " + querygroupHoras;

        //                   string condicion2 = " and  b.Nombre like '%HORAS CLUB%' ";

        //                   query = query + queryselectgroupHorasClub + sqlcuerpoGeneral
        //                       + condicion2 + " " + querygroupHoras + "  order by idTrabajador";
        //               }
        //               else
        //                   query = @"SELECT " + queryselectgroup + sqlcuerpoGeneral
        //                       + condicion + " " + querygroup + "  order by idTrabajador";

        //               ListaHorasPorDocente = (List<HorasPorDocente>)dp.connection.Query<HorasPorDocente>(query.ToString());
        //           }
        //           else
        //           {
        //               query = @"select * from ( SELECT " + queryselect + sqlcuerpoGeneral + condicion + " " + queryorder;


        //               NominaHorariosDocentesDetalle = (List<NominaHorariosDocentesDetalle>)dp.connection.Query<NominaHorariosDocentesDetalle>(query.ToString());
        //           }



        //       }


        //        private void setpercepcionesparaBase()
        //        {
        //            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
        //            {

        //                DapperQuery dp = new DapperQuery("bdNovaEntities");
        //                string query2 = @"select pp.IdPlantillaNominaPercepcion,pp.Importe,x.EsImprimible as EsImprimibleRecibo 
        //,a.IdConvenioLaboralTrabajadorCategoria,a.IdNomina,'ODES' as Tipo,x.EsGravable,x.EsVariable,x.EsPrevisionSocial,x.IdPercepcion,x.Percepcion as Concepto
        //,w.IdTrabajador
        //from 
        //Percepciones_stNominaTrabajadorPercepciones pp  
        //inner join Percepciones_stPlantillaNominaPercepciones z on z.IdPlantillaNominaPercepcion=pp.IdPlantillaNominaPercepcion
        //inner join Percepciones_ctPercepcion x on x.IdPercepcion=z.IdPercepcion
        //inner join Nomina_stNominaTrabajador a on pp.IdNominaTrabajador=a.IdNominaTrabajador
        //  inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
        //inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
        //inner join Nomina_stNomina b on a.idnomina=b.idnomina
        //inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
        //inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
        //inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
        //inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
        //where    EstatusNominaGrupo ='PARA PAGO' and b.año=" + this.Nomina_stNomina.Año + " and b.IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + " " +
        //" and c.IdRelacionConvenioLaboral=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + " AND c.Plantilla like '%ODES%' ";
        //                ;
        //                List<PercepcionesNominaTrabajador> nominaodes = (List<PercepcionesNominaTrabajador>)dp.connection.Query<PercepcionesNominaTrabajador>(query2).ToList();

        //                this.ListaPercepcionesTrabajadoresODES.AddRange(nominaodes);


        //                query2 = @"select pp.IdPlantillaNominaPercepcion,pp.Importe,x.EsImprimible as EsImprimibleRecibo 
        //,a.IdConvenioLaboralTrabajadorCategoria,a.IdNomina,'CCT' as Tipo,x.EsGravable,x.EsVariable,x.EsPrevisionSocial,x.IdPercepcion,x.Percepcion as Concepto
        //,w.IdTrabajador
        //from 
        //Percepciones_stNominaTrabajadorPercepciones pp  
        //inner join Percepciones_stPlantillaNominaPercepciones z on z.IdPlantillaNominaPercepcion=pp.IdPlantillaNominaPercepcion
        //inner join Percepciones_ctPercepcion x on x.IdPercepcion=z.IdPercepcion
        //inner join Nomina_stNominaTrabajador a on pp.IdNominaTrabajador=a.IdNominaTrabajador
        //  inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
        //inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
        //inner join Nomina_stNomina b on a.idnomina=b.idnomina
        //inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
        //inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
        //inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
        //inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
        //where    EstatusNominaGrupo ='PARA PAGO' and b.año=" + this.Nomina_stNomina.Año + " and b.IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + " " +
        //" and c.IdRelacionConvenioLaboral=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + " AND c.Plantilla like '%CCT%'  group by c.plantilla, pp.IdPlantillaNominaPercepcion,pp.Importe,x.EsImprimible,a.IdConvenioLaboralTrabajadorCategoria,a.IdNomina,x.EsGravable,x.EsVariable,x.EsPrevisionSocial,x.IdPercepcion,x.Percepcion ,w.IdTrabajador ";
        //                ;
        //                List<PercepcionesNominaTrabajador> nominacct = (List<PercepcionesNominaTrabajador>)dp.connection.Query<PercepcionesNominaTrabajador>(query2).ToList();

        //                this.ListaPercepcionesTrabajadoresCCTIMSS.AddRange(nominacct);
        //                dp.Close();
        //            }
        //        }

        public void setHorariosDocentesAjustes()
        {

            if (this.Nomina_stNomina != null)
            {
                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.UsaHorariosDocentesParaCalculo
                    )
                {
                    
                        DapperQuery dp = new DapperQuery("bdNovaEntities");

                               
                        string dbnameAries = GetDatabaseName("bdAriesEntities");

                        string sqlhorario = $@"SELECT b.*, CAST(a.IdNominaTrabajador AS BIGINT) as IdNominaTrabajador
  FROM  [Nomina_stNominaHorariosDocentes] a
  inner join {dbnameAries}.[dbo].[stHorarioNominaDocente] b on a.IdHorarioNominaDocente=b.IdHorarioNominaDocente
and year(fechainiciopago)>{(this.Nomina_stNomina.FechaTermino.Year - 2)}";

                                    HorariosPagadoDocentes = (List<NominaHorariosDocentesDetalle>)dp.connection.Query<NominaHorariosDocentesDetalle>(sqlhorario.ToString());

                }
            }

            }
            public void setHorariosDocentes()
        {
            //bdNovaEntities baseq = new bdNovaEntities();
            var idrl = this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral;
            Convenios_stRelacionConvenioLaboral relacion;
            using (var dbContext = new bdNovaEntities())
            {
                dbContext.Database.Connection.Open();
                relacion = dbContext.Convenios_stRelacionConvenioLaboral.Include("Catalogos_ctRelacionLaboral").Where(s => s.IdRelacionConvenioLaboral == idrl).FirstOrDefault();
                dbContext.Database.Connection.Close();
            }

            //solo aplica para nominas docentes y pra efecto de performance
            if (relacion.Catalogos_ctRelacionLaboral.RelacionLaboral == "DOCENTE")
            {
                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
                {
                    DapperQuery dp = new DapperQuery("bdNovaEntities");
                    string query2 = @"select pp.IdPlantillaNominaPercepcion,pp.Importe,x.EsImprimible as EsImprimibleRecibo 
,a.IdConvenioLaboralTrabajadorCategoria,a.IdNomina,'ODES' as Tipo,x.EsGravable,x.EsVariable,x.EsPrevisionSocial,x.IdPercepcion,x.Percepcion as Concepto
,w.IdTrabajador
from 
Percepciones_stNominaTrabajadorPercepciones pp  
inner join Percepciones_stPlantillaNominaPercepciones z on z.IdPlantillaNominaPercepcion=pp.IdPlantillaNominaPercepcion
inner join Percepciones_ctPercepcion x on x.IdPercepcion=z.IdPercepcion
inner join Nomina_stNominaTrabajador a on pp.IdNominaTrabajador=a.IdNominaTrabajador
  inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
where    EstatusNominaGrupo ='PARA PAGO' and b.año=" + this.Nomina_stNomina.Año + " and b.IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + " " +
    " and c.IdRelacionConvenioLaboral=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + " AND c.Plantilla like '%ODES' ";
                    ;
                    List<PercepcionesNominaTrabajador> nominaodes = (List<PercepcionesNominaTrabajador>)dp.connection.Query<PercepcionesNominaTrabajador>(query2).ToList();

                    this.ListaPercepcionesTrabajadoresODES.AddRange(nominaodes);
                }
                else
                    if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("HORAS EXTRAORDINARIAS"))
                {

                    DapperQuery dp = new DapperQuery("bdNovaEntities");
                    string query2 = @"select pp.IdPlantillaNominaPercepcion,pp.Importe,x.EsImprimible as EsImprimibleRecibo 
,a.IdConvenioLaboralTrabajadorCategoria,a.IdNomina,'ODES' as Tipo,x.EsGravable,x.EsVariable,x.EsPrevisionSocial,x.IdPercepcion,x.Percepcion as Concepto
,w.IdTrabajador
from 
Percepciones_stNominaTrabajadorPercepciones pp  
inner join Percepciones_stPlantillaNominaPercepciones z on z.IdPlantillaNominaPercepcion=pp.IdPlantillaNominaPercepcion
inner join Percepciones_ctPercepcion x on x.IdPercepcion=z.IdPercepcion
inner join Nomina_stNominaTrabajador a on pp.IdNominaTrabajador=a.IdNominaTrabajador
  inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
where    EstatusNominaGrupo ='PARA PAGO' and b.año=" + this.Nomina_stNomina.Año + " and b.IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + " " +
    " and c.IdRelacionConvenioLaboral=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + " AND c.Plantilla like '%ODES HORAS EXTRAORDINARIAS%' ";
                    ;
                    List<PercepcionesNominaTrabajador> nominaodes = (List<PercepcionesNominaTrabajador>)dp.connection.Query<PercepcionesNominaTrabajador>(query2).ToList();

                    this.ListaPercepcionesTrabajadoresODES.AddRange(nominaodes);
                }

                int daysInMonth = System.DateTime.DaysInMonth(this.Nomina_stNomina.FechaTermino.Year, this.Nomina_stNomina.FechaTermino.Month);
                var fecha = DateTime.Parse(this.Nomina_stNomina.FechaTermino.Year.ToString() + "-" + this.Nomina_stNomina.FechaTermino.Month + "-" + daysInMonth.ToString());



                string query;

                DapperQuery dpa = new DapperQuery("bdAriesEntities");

                query = @"SELECT *
  FROM  stCicloescolar  
  where IdModalidadEstudio=1  and
   '" + fecha.ToString("yyyyMMdd") + "' between Inicio and Termino";

                var ctCicloescolar = (List<ctCicloescolar>)dpa.connection.Query<ctCicloescolar>(query.ToString());

                if (ctCicloescolar.Count > 0)
                {
                    this.IdCicloEscolarVigentePlantel = ctCicloescolar[0].IdCicloEscolar;
                    int idant = (int)dpa.connection.ExecuteScalar("SELECT dbo.fnObtenCicloEscolarAnteriorPorCiclo (1," + ctCicloescolar[0].IdCicloEscolar + ")", null, null, 0, System.Data.CommandType.Text);
                    if (idant > 0)
                        this.IdCicloEscolarAnteriorPlantel = (short)idant;
                }


                setHorariosDocentesGenerales(dpa, "");


                dpa.Close();
            }

        }
        public void setHorariosDocentes(string fecha_amd, bool soloHoras = false, bool HorasAgrupadas = false, bool ProcesollamadodeIncidencias = false,int idkardex=0)
        {




            string query;

            DapperQuery dpa = new DapperQuery("bdAriesEntities");

            query = @"SELECT *
  FROM  stCicloescolar  
  where IdModalidadEstudio=1  and
   '" + fecha_amd + "' between Inicio and Termino";

            var ctCicloescolar = (List<ctCicloescolar>)dpa.connection.Query<ctCicloescolar>(query.ToString());

            if (ctCicloescolar.Count > 0)
            {
                this.IdCicloEscolarVigentePlantel = ctCicloescolar[0].IdCicloEscolar;
                int idant = (int)dpa.connection.ExecuteScalar("SELECT dbo.fnObtenCicloEscolarAnteriorPorCiclo (1," + ctCicloescolar[0].IdCicloEscolar + ")", null, null, 0, System.Data.CommandType.Text);
                if (idant > 0)
                    this.IdCicloEscolarAnteriorPlantel = (short)idant;
            }

            if (!ProcesollamadodeIncidencias)
                setHorariosDocentesGenerales(dpa, "", soloHoras, HorasAgrupadas);
            else
            {

                setHorariosDocentesGenerales(dpa, "", soloHoras, HorasAgrupadas, fecha_amd,idkardex);
                    }


            dpa.Close();


        }


        public HorariosVigenteAnterior getHorarioActualDocente(int IdKardex, int diasemana = 0, string fecha = null, bool agregarHorarioAnterior = false, Convenios_stConvenioLaboralTrabajadorCategoria cltc = null)
        {
            HorariosVigenteAnterior regresa = new HorariosVigenteAnterior();
            //var horariodocentepordia = NominaTrabajador.ListastHorariosDetalleNomina.Where(d => d.IdDia == diasemana && d.IdNova == item.IdKardex).OrderBy(x => x.HoraInicio).ToList();
            List<NominaHorariosDocentesDetalle> horariodocentepordia = new List<NominaHorariosDocentesDetalle>();
            List<NominaHorariosDocentesDetalle> horariodocentepordiaNoAplicados = new List<NominaHorariosDocentesDetalle>();
            bool procesaporfechas = false;

            if (this.TrabajadoresConCalculoConFechaAnterior.Where(a => a.IdConvenioLaboralTrabajadorCategoria == cltc.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault() != null)
            {
                var tempohorariodocentepordia = this.NominaHorariosDocentesDetallePorFecha
      .Where(d => d.IdKardex == IdKardex &&
                  d.FechaInicioPago >= cltc.FechaInicio &&
                  d.FechaFinalPago <= cltc.FechaTermino || (d.IdKardex == IdKardex && d.Aplicado == false))
      .OrderBy(x => x.HoraInicio)
      .ToList();
                if (tempohorariodocentepordia.Count() == 0)
                    sethorariosdocentesPorFechasAnteriores(cltc);
            }

            if (cltc != null && NominaHorariosDocentesDetallePorFecha != null )
            {
                if (cltc.FechaTermino == null)  
                {
                    horariodocentepordiaNoAplicados = this.NominaHorariosDocentesDetallePorFecha
      .Where(d => d.IdKardex == IdKardex &&
                  d.FechaInicioPago >= cltc.FechaInicio && d.Aplicado == false
                   )
      .OrderBy(x => x.HoraInicio)
      .ToList();
          //         // if (cltc.EsPrimerCalculo)
          //          //{ //puede ser una homologacion habra que ver si tiene mas materias sin aplicar
          //              // en la misma fecha de las otras
          //              DateTime fechatempo = DateTime.Now;
          //              if (horariodocentepordia.Count > 0)
          //              {
          //                  fechatempo = (DateTime)horariodocentepordia.FirstOrDefault().FechaInicioPago;
          //              }

          //                  var horariodocentepordiatodos = this.NominaHorariosDocentesDetallePorFecha
          //.Where(d => d.IdKardex == IdKardex &&
          //            d.FechaInicioPago == fechatempo || (d.IdKardex == IdKardex )
          //             )
          //.OrderBy(x => x.HoraInicio)
          //.ToList();
          //              if (horariodocentepordiatodos.Count > horariodocentepordia.Count)
          //              {
          //                  horariodocentepordia = horariodocentepordiatodos;
          //              }

          //          //}

                    
                }
                else
                    horariodocentepordia = this.NominaHorariosDocentesDetallePorFecha
       .Where(d => d.IdKardex == IdKardex &&
                   d.FechaInicioPago >= cltc.FechaInicio &&
                   d.FechaFinalPago <= cltc.FechaTermino || (d.IdKardex == IdKardex && d.Aplicado == false))
       .OrderBy(x => x.HoraInicio)
       .ToList();

                if (horariodocentepordia.Count() > 0)
                {
                    procesaporfechas = true;
                    if (horariodocentepordia.Where(a=> a.Aplicado==false ).FirstOrDefault()!=null)
                        regresa.SinAplicar = true;
                }
            }
            //else

            bool horasextraordinarias = false;
            if (this.Nomina_stNomina!=null)
            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("HORAS EXTRAORDINARIAS"))
            {
                horasextraordinarias = true;
                regresa.EsHorarioHorasExtraordinarias = true;
            }

            if (horariodocentepordia.Count() == 0 && this.NominaHorariosDocentesDetalle!=null)
            {
                if (fecha == null)
                {
                    horariodocentepordia = this.NominaHorariosDocentesDetalle.Where(d => d.IdKardex == IdKardex && d.Aplicado == true).OrderBy(x => x.HoraInicio).ToList();
                    if (horariodocentepordia.Count == 0)
                    {
                        horariodocentepordia = this.NominaHorariosDocentesDetalle.Where(d => d.IdKardex == IdKardex && d.Aplicado == false).OrderBy(x => x.HoraInicio).ToList();
                        if (horariodocentepordia.Count() > 0)
                        {
                            regresa.SinAplicar = true;
                        }
                    }
                }
                else
                {
                    var fechahorario = DateTime.Parse(fecha);
                    horariodocentepordia = this.NominaHorariosDocentesDetalle.Where(d =>
                    fechahorario >= d.FechaInicioPago && d.Aplicado == true &&
                    d.IdKardex == IdKardex).OrderBy(x => x.HoraInicio).ToList();


                    if (horariodocentepordia.Count == 0)
                    {
                        horariodocentepordia = this.NominaHorariosDocentesDetalle.Where(d =>
                        fechahorario >= d.FechaInicioPago && d.IdKardex == IdKardex && d.Aplicado == false).OrderBy(x => x.HoraInicio).ToList();
                        if (horariodocentepordia.Count() > 0)
                        {
                            regresa.SinAplicar = true;
                        }
                    }
                }

                 
                if (horariodocentepordiaNoAplicados.Count()>0)
                {
                    procesaporfechas = true;

                    // Suponiendo que 'IdHorarioNominaDocente' es el identificador único
                    var idsExistentes = new HashSet<long>(horariodocentepordia.Select(h => h.IdHorarioNominaDocente));

                    var elementosParaAgregar = horariodocentepordiaNoAplicados
                        .Where(n => !idsExistentes.Contains(n.IdHorarioNominaDocente));

                    horariodocentepordia.AddRange(elementosParaAgregar);
                }

            }





            bool tieneHorario = true;
            if (horariodocentepordia.Count == 0)
            {
                TransactionOptions transactionoptions2 = new TransactionOptions();
                transactionoptions2.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope2 = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions2))
                {
                    this.getHorarioDocenteAnterior(IdKardex);
                }
                
                if (NominaHorariosDocentesDetalleAnterior!=null)
                horariodocentepordia = this.NominaHorariosDocentesDetalleAnterior.OrderBy(x => x.HoraInicio).ToList();

                if (horariodocentepordia.Count == 0)
                    tieneHorario = false;

            }
            else
            {
                regresa.HorarioVigente = true;

                if (agregarHorarioAnterior && horasextraordinarias==false)
                {
                    TransactionOptions transactionoptions2 = new TransactionOptions();
                    transactionoptions2.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;

                    using (TransactionScope scope2 = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions2))
                    {
                        var idcicloescolaranteriohorario = horariodocentepordia.FirstOrDefault().IdCicloEscolar;
                        regresa.NominaHorariosDocentesDetalleAnterior = this.ObtenHorarioDocenteAnterior(IdKardex, (int)idcicloescolaranteriohorario);
                    }

                }
            }

          

                if (fecha == null)
            {
                if ((!regresa.EsHorarioHorasExtraordinarias && horariodocentepordia.Count()>0) 
                    && procesaporfechas == false && NominaHorariosDocentesDetalle!=null)
                {
                    if (diasemana > 0)
                        horariodocentepordia = this.NominaHorariosDocentesDetalle.Where(d => d.IdDia == diasemana && d.IdKardex == IdKardex).OrderBy(x => x.HoraInicio).ToList();
                    else
                    {
                        if (regresa.HorarioVigente)
                            horariodocentepordia = this.NominaHorariosDocentesDetalle.Where(d => d.IdKardex == IdKardex).OrderBy(x => x.HoraInicio).ToList();
                        else
                            if (horasextraordinarias==false)
                            horariodocentepordia = this.NominaHorariosDocentesDetalleAnterior.Where(d => d.IdKardex == IdKardex).OrderBy(x => x.HoraInicio).ToList();

                    }
                }
            }
            else
            {
                var fechahorario = DateTime.Parse(fecha);

                CultureInfo culturaEspañol = new CultureInfo("es-MX");

                // Obtener el nombre del día de la semana usando la cultura especificada
                string nombreDia = fechahorario.ToString("dddd", culturaEspañol);

                if (diasemana > 0)
                    horariodocentepordia = horariodocentepordia.Where(d =>
                      fechahorario.Date >= d.FechaInicioPago.Value.Date
    && fechahorario.Date <= d.FechaFinalPago.Value.Date &&
                    d.IdDia == diasemana && d.IdKardex == IdKardex).OrderBy(x => x.HoraInicio).ToList();
                else
                {
                    var horariodocentepordiatempo = horariodocentepordia.Where(d =>
                        fechahorario.Date >= d.FechaInicioPago.Value.Date
    && fechahorario.Date <= d.FechaFinalPago.Value.Date &&
                    d.IdKardex == IdKardex).OrderBy(x => x.HoraInicio).ToList();
                    if (horariodocentepordiatempo.Count() == 0)
                    {
                        if (fecha == null)
                            horariodocentepordia = horariodocentepordia.Where(d =>
                        d.Dia.ToLower() == nombreDia.ToLower() &&
                          d.IdKardex == IdKardex).OrderBy(x => x.HoraInicio).ToList();
                        else
                            horariodocentepordia = horariodocentepordia.Where(d =>
                    d.Dia.ToLower() == nombreDia.ToLower()

                   && fechahorario.Date >= d.FechaInicioPago.Value.Date
    && fechahorario.Date <= d.FechaFinalPago.Value.Date &&
                      d.IdKardex == IdKardex).OrderBy(x => x.HoraInicio).ToList();

                    }
                    else
                        //horariodocentepordia = horariodocentepordiatempo;
                        horariodocentepordia =  horariodocentepordiatempo.Where(d =>
                    d.Dia.ToLower() == nombreDia.ToLower()).ToList();
                }

            }


            regresa.NominaHorariosDocentesDetalle = horariodocentepordia;
            regresa.TieneHorario = tieneHorario;
            return regresa;
        }

        public AjusteHorasFechaAplicacion ValidaAjusteHorasDocente(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria)
        {
            var horariocalculo = this.getHorarioActualDocente(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex, 0, null, false, ConvenioLaboralTrabajadorCategoria);

            AjusteHorasFechaAplicacion result = new AjusteHorasFechaAplicacion();
            bool existecambiodehoras = false;

            int horas = 0;
            double diasremanentes = 0;

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            int idqna = System.Convert.ToInt32(this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes) - 1;
            string qnames = "";
            int añoqna = this.Nomina_stNomina.Año;
            if (idqna == 0)
            {
                qnames = "24";
                añoqna = añoqna - 1;
            }
            else { qnames = idqna.ToString().PadLeft(2, '0'); }



//            string query = @"   select  a.* from Nomina_stNominaTrabajador a
//  inner join Nomina_stNomina b on a.IdNomina=b.IdNomina
//  inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
//  inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
//inner join Catalogos_ctQuincenaMes e on e.IdQuincenaMes=b.IdQuincenaMes
//  where   a.sueldobruto>0 and  e.QuincenaMes='" + qnames + "' and b.Año=" + añoqna + " and    a.IdConvenioLaboralTrabajadorCategoria=" + ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria + " and b.IdPlantillaNomina=" + this.Nomina_stNomina.IdPlantillaNomina + " order by b.FechaTermino desc  ";

            //List<Nomina_stNominaTrabajador> nominaaspagadas = (List<Nomina_stNominaTrabajador>)dp.connection.Query<Nomina_stNominaTrabajador>(query.ToString());
            var nominaaspagadas = this.NominasAnterioresPagadas.Where(a=> a.QuincenaMes==qnames
            && a.Año==añoqna  && a.IdConvenioLaboralTrabajadorCategoria== ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
            && a.Plantilla== Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla).ToList();

            var ultimonominapagada = nominaaspagadas.FirstOrDefault();

            if (ultimonominapagada == null)
            {
                //Verifica si tuvo un cambio de categoria
//                string query11 = @"   select  a.* from Nomina_stNominaTrabajador a
//  inner join Nomina_stNomina b on a.IdNomina=b.IdNomina
//  inner join Convenios_stConvenioLaboralTrabajadorCategoria c on c.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
//  inner join Convenios_stConvenioLaboralTrabajador d on d.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
//inner join Catalogos_ctQuincenaMes e on e.IdQuincenaMes=b.IdQuincenaMes
//  where a.sueldobruto>0 and  e.QuincenaMes='" + qnames + "' and b.Año=" + añoqna + " and  d.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + " and a.IdConvenioLaboralTrabajadorCategoria<>" + ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria + "  and b.IdPlantillaNomina=" + this.Nomina_stNomina.IdPlantillaNomina + " order by b.FechaTermino desc  ";

               // List<Nomina_stNominaTrabajador> nominaaspagadasComision = (List<Nomina_stNominaTrabajador>)dp.connection.Query<Nomina_stNominaTrabajador>(query11.ToString());
                var nominaaspagadasComision = this.NominasAnterioresPagadas.Where(a => a.QuincenaMes == qnames
            && a.Año == añoqna && a.IdConvenioLaboralTrabajadorCategoria != ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
            && a.Plantilla == Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla).ToList();

                var ultimonominapagadaComision = nominaaspagadasComision.FirstOrDefault();
                if (ultimonominapagadaComision != null)
                    ultimonominapagada = ultimonominapagadaComision;

            }

            Plazas_ctCostoHoraJornada costos = this.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.IdCategoria).FirstOrDefault();
            if (costos == null) throw new ApplicationException("No existe costo-hora-jornada para la categoría con id: " + ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria);


            dp.Close();

            if (ultimonominapagada != null)
            {


                if (horariocalculo.TieneHorario)
                {

                    var existevnt1 = this.ListaVariablesNominaTrabajador
                        .Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        && s.Concepto == "HorasSemanaMes").FirstOrDefault();

                 
                    int horastotales = 0;
                    //var horastotales = horariocalculo.NominaHorariosDocentesDetalle
                    //    .Where(a=> a.Aplicado==true &&
                    //    a.FechaInicioPago <= this.Nomina_stNomina.FechaInicio
                    //&& a.FechaFinalPago >= this.Nomina_stNomina.FechaTermino || (a.FechaFinalPago <= this.Nomina_stNomina.FechaTermino && a.FechaFinalPago >= this.Nomina_stNomina.FechaInicio)).Sum(d => d.Horas);

                    //var horastotales = horariocalculo.NominaHorariosDocentesDetalle.Sum(d => d.Horas);

                    //se agrego para el caso de la 2a de enero, ya se tiene la carga en al lcase sueldo de ahi se toma
                    if (existevnt1!=null)
                      horastotales = (int)existevnt1.Importe;
                    else
                        horastotales = (int)horariocalculo.NominaHorariosDocentesDetalle.Sum(d => d.Horas);


                    var horastotalJornada = 0;
                    var horastotalExcedentes = 0;
                    if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                    {
                        if (horastotales > costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo)
                        {
                            horastotalJornada = costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo;
                            horastotalExcedentes = (int)horastotales - horastotalJornada;

                            result.HorasJornadaNominaActual = horastotalJornada;
                            result.HorasExcedentesNominaActual = horastotalExcedentes;
                        }
                        else
                        {
                            horastotalJornada = (int)horastotales;
                            result.HorasJornadaNominaActual = (int)horastotales;
                        }


                    }
                    else
                    {
                        horastotalJornada = (int)horastotales;
                        result.HorasJornadaNominaActual = (int)horastotales;
                    }
                 

                    dp.Close();

                    Plazas_stDistribucionPlazaCategoria plaza = new Plazas_stDistribucionPlazaCategoria();

                    using (var dbContext = new bdNovaEntities())
                    {
                        dbContext.Database.Connection.Open();
                        plaza = dbContext.Plazas_stDistribucionPlazaCategoria.AsNoTracking().Where(e => e.IdDistribucionPlazaCategoria == ConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria)
                            .Include(a => a.Catalogos_ctEstructuraOrganica)
                            .FirstOrDefault();
                        dbContext.Database.Connection.Close();
                    }

                    NominaHorariosDocentesDetalle ultimafecha = new NominaHorariosDocentesDetalle();

                    ultimafecha = horariocalculo.NominaHorariosDocentesDetalle.Where(q => q.Aplicado == false || q.Aplicado == null && q.IdKardex == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex).OrderByDescending(s => s.FechaInicioPago).FirstOrDefault();

                    //if ((horastotales != ultimonominapagada.HorasSemanaMes + ultimonominapagada.HorasExcedentes) || ultimafecha!=null)
                    if (ultimafecha!=null || (horastotales != ultimonominapagada.HorasSemanaMes + ultimonominapagada.HorasExcedentes))
                    {
  //                      string dbnameAries = GetDatabaseName("bdAriesEntities");

                   
  //                      string sqlhorario = $@"SELECT b.*
  //FROM  [Nomina_stNominaHorariosDocentes] a
  //inner join {dbnameAries}.[dbo].[stHorarioNominaDocente] b on a.IdHorarioNominaDocente=b.IdHorarioNominaDocente
  //where idnominatrabajador ={ultimonominapagada.IdNominaTrabajador}";


  //                      List<Nomina_stNominaHorariosDocentes> horariopagado = (List<Nomina_stNominaHorariosDocentes>)dp.connection.Query<Nomina_stNominaHorariosDocentes>(sqlhorario.ToString());
                          var horariopagado = this.HorariosPagadoDocentes.Where(a=> a.IdNominaTrabajador== ultimonominapagada.IdNominaTrabajador).ToList();

                        var HORARIOFI = this.ListaVariablesNominaTrabajador
                .Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                && s.Concepto == "HORARIOPROCESADOFI").FirstOrDefault();
                        DateTime fi = DateTime.Parse(HORARIOFI.ConceptoExtra);


                        var HORARIOFT = this.ListaVariablesNominaTrabajador
                .Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                && s.Concepto == "HORARIOPROCESADOFT").FirstOrDefault();
                    
                        DateTime ft = DateTime.Parse(HORARIOFT.ConceptoExtra);

                        var horarioactual = horariocalculo.NominaHorariosDocentesDetalle.Where(q => 
                          q.FechaInicioPago==fi && q.FechaFinalPago==ft   && q.IdKardex == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex).ToList();
                        // Create dictionaries from the lists using IdHorarioNominaDocente as the key
                        //Dictionary<long, NominaHorariosDocentesDetalle> dict1 = horarioactual.ToDictionary(item => item.IdHorarioNominaDocente);
                        Dictionary<long, NominaHorariosDocentesDetalle> dict1 = horarioactual
    .GroupBy(x => x.IdHorarioNominaDocente)
    .ToDictionary(g => g.Key, g => g.First());
                        //Dictionary<long, NominaHorariosDocentesDetalle> dict2 = horariopagado.ToDictionary(item => item.IdHorarioNominaDocente);
                        Dictionary<long, NominaHorariosDocentesDetalle> dict2 = horariopagado.GroupBy(x => x.IdHorarioNominaDocente).ToDictionary(g => g.Key, g => g.First());

                        // Find items in lista1 that are not in lista2
                        var itemsInList1NotInList2 = dict1.Keys.Except(dict2.Keys)
                            .Select(key => dict1[key])
                            .ToList();

                        VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                        vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
                        vnt.Concepto = "CAMBIODEHORASDOCENTES";
                        int IdCicloEscolar = 0;
                        int IdCicloEscolarAnterior = 0;
                        if (horariocalculo.HorarioVigente)
                        {


                            if (plaza.Catalogos_ctEstructuraOrganica.IdModalidadEstudio == 1)
                            {
                                IdCicloEscolar = this.IdCicloEscolarVigentePlantel;
                                IdCicloEscolarAnterior = this.IdCicloEscolarAnteriorPlantel;
                            }
                            else
                            {
                                IdCicloEscolar = this.IdCicloEscolarVigenteEmsad;
                                IdCicloEscolarAnterior = this.IdCicloEscolarAnteriorEmsad;
                            }
                        }
                        else
                        {
                            if (plaza.Catalogos_ctEstructuraOrganica.IdModalidadEstudio == 1)
                            {
                                IdCicloEscolar = this.IdCicloEscolarVigentePlantel;
                                IdCicloEscolarAnterior = this.IdCicloEscolarAnteriorPlantel;
                            }
                            else
                            {
                                IdCicloEscolar = this.IdCicloEscolarVigenteEmsad;
                                IdCicloEscolarAnterior = this.IdCicloEscolarAnteriorEmsad;
                            }
                        }
                        vnt.IdTrabajador = IdCicloEscolar;
                        this.ListaVariablesNominaTrabajador.Add(vnt);




                        if (ultimafecha != null)
                        {
                            try
                            {
                                result.FechaAplicacion = (DateTime)ultimafecha.FechaInicioPago;
                            }
                            catch (Exception ww)
                            {

                                throw new ApplicationException("Existe un docente sin fecha de aplicación en su nueva carga horaria, ide :" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);
                            }

                            int horasultimasciclo = 0;
                            var horastotalJornadaCicloAnterior = 0;
                            var horastotalExcedentesAnterior = 0;

                            var diaslaborados = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault();

                            if (diaslaborados != null)

                            {
                                if (result.FechaAplicacion < this.Nomina_stNomina.FechaInicio)
                                {



                                    horas = (int)horastotales - (ultimonominapagada.HorasSemanaMes + ultimonominapagada.HorasExcedentes);
                                    if (horas == 0)
                                    {
                                        DapperQuery dpa = new DapperQuery("bdAriesEntities");
//                                        string consulta = @"SELECT SUM(horas) as Horas
//    FROM stHorarioNominaDocente a 
//    inner join ctTipoHoras b on a.IdTipoHoras=b.IdTipoHoras and a.IdModalidadEstudio=b.IdModalidadEstudio 
//    inner join ctDia x on x.IdDia=a.IdDia inner join ctCicloescolar w on w.IdCicloEscolar=a.IdCicloEscolar 
//    left join bdnova.dbo.vwDatosAspirantesTrabajadores c on c.RestringirMenu is null and  c.relacionConvenioLaboral like '%DOCENTE%'  
//  and c.IdKardex=a.IdKardex where a.Vigente=1 and 
//(c.RestringirMenu is null or c.EstatusTrabajador<>'PROXIMAMENTE') 
//and a.IdCicloEscolar=" + IdCicloEscolarAnterior + " and  b.Nombre<>'HORAS CLUB' and a.IdKardex=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;

                                        string consulta = @"SELECT SUM(horas) as Horas
    FROM stHorarioNominaDocente a 
    inner join ctTipoHoras b on a.IdTipoHoras=b.IdTipoHoras and a.IdModalidadEstudio=b.IdModalidadEstudio 
    inner join ctDia x on x.IdDia=a.IdDia inner join ctCicloescolar w on w.IdCicloEscolar=a.IdCicloEscolar 
    
and a.IdCicloEscolar=" + IdCicloEscolarAnterior + " and  b.Nombre<>'HORAS CLUB' and b.nombre<>'HORAS DE FORTALECIMIENTO' and a.IdKardex=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;

                                        var horariodocant = this.HorasDocentesPorCiclo.Where(a => a.IdCicloEscolar == IdCicloEscolarAnterior
                                        && a.IdKardex == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex).FirstOrDefault();

                                        if (horariodocant != null)
                                            horasultimasciclo =horariodocant.Horas;

                                        //horasultimasciclo = dpa.connection.ExecuteScalar<int>(consulta);

                                        dpa.Close();
                                        if (horasultimasciclo > 0)
                                        {
                                            horas = horasultimasciclo;


                                            if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                                            {
                                                if (horastotales > costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo)
                                                {
                                                    horastotalJornadaCicloAnterior = costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo;
                                                    horastotalExcedentesAnterior = (int)horasultimasciclo - horastotalJornadaCicloAnterior;

                                                    //horastotalJornadaCicloAnterior = horastotalJornada;
                                                    //horastotalExcedentesAnterior = horastotalExcedentes;
                                                }
                                                else
                                                {
                                                    horastotalJornadaCicloAnterior = (int)horastotales;

                                                }


                                            }
                                            else
                                            {
                                                horastotalJornadaCicloAnterior = (int)horastotales;

                                            }
                                        }
                                    }

                                    if (horastotales > horas)
                                        existecambiodehoras=true;

                                    result.Horas = horas;
                                    result.NominaHorariosDocentesDetalle = horarioactual;

                                    if (costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.JornadaLaboral == "HORAS CLASE")
                                    {
                                        result.HorasJornada = horas;
                                    }
                                    else
                                                 if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                                    {
                                        if (horasultimasciclo == 0)
                                        {
                                            result.HorasExcedentes = horastotalExcedentes - ultimonominapagada.HorasExcedentes;
                                            result.HorasJornada = horastotalJornada - ultimonominapagada.HorasSemanaMes;
                                        }
                                        else
                                        {
                                            result.HorasExcedentes = horastotalExcedentes - horastotalExcedentesAnterior;
                                            result.HorasJornada = horastotalJornada - horastotalJornadaCicloAnterior;
                                        }

                                    }



                                    var resta = (TimeSpan)((DateTime)Nomina.FechaInicio - result.FechaAplicacion);



                                    // se modifico caso de pepe caso:
                                    //IRVING BIZARRO SOLANA, qna 7 2021, le calcula 32 pro que ponia a febrero restandole un dia a la fecha de inicio de pago
                                    var mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(result.FechaAplicacion, Nomina.FechaInicio);
                                    var diasfeb = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(result.FechaAplicacion, Nomina.FechaInicio);

                                    double dias = resta.TotalDays;
                                    dias = ((int)dias - mesescon31dias) + diasfeb;

                                    var existenhoraspasadas = this.ListaVariablesNominaTrabajador.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                   && q.Concepto == "existecargapasada_totaldiasajuste").FirstOrDefault();

                                    if (existenhoraspasadas != null)
                                    {
                                        var existenhoraspasadastotal = this.ListaVariablesNominaTrabajador.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                   && q.Concepto == "existecargapasada_totalhorasajuste").FirstOrDefault();

                                        horas =(int) existenhoraspasadastotal.Importe;

                                        dias = (double)existenhoraspasadas.Importe;

                                        result.HorasJornada = horastotalJornada;


                                    }



                                    result.DiasAAjustar = (int)dias;




                                }
                            }
                        }
                    }
                }

            }
            //si son iguales no debe de haber ajuste
            if (existecambiodehoras==false)
                horas = 0;

            result.Horas = horas;

            return result;
        }


        public List<NominaHorariosDocentesDetalle> ObtenHorarioDocenteAnterior(int idkardex,int idcicloescolarhorario=0)
        {

            NominaHorariosDocentesDetalleAnterior = new List<NominaHorariosDocentesDetalle>();

            string query;


            string condicion = "";


            condicion = condicion + " and a.IdKardex=" + idkardex;

            int idciclo = this.IdCicloEscolarAnteriorPlantel;

            if (idcicloescolarhorario > 0)
                idciclo = idcicloescolarhorario-1;

            DapperQuery dp = new DapperQuery("bdAriesEntities");

            string dbnameNova = GetDatabaseName("bdNovaEntities");

            query = @"SELECT  IdHorarioNominaDocente
      ,a.IdKardex
      ,IdCicloEscolar
      ,a.IdDia
      ,a.IdTipoHoras
      ,HoraInicio
      ,HoraFinal
      ,Horas
      ,a.IdModalidadEstudio
      ,NoAutorizadas
      ,a.Vigente
      ,FechaMovimiento
      ,FechaInicioPago
      ,FechaFinalPago
      ,Aplicado
      ,MarcarEliminado
      ,InmediatoAnterior
      ,IdHorarioTabla
      ,x.Nombre as Dia
      ,IdHorario,b.Nombre as TipoHoras
      ,c.IdConvenioLaboralTrabajadorCategoria
      ,c.RFC
      ,c.CURP
      ,c.Nombre
      ,ApellidoPaterno
      ,ApellidoMaterno
      ,Sexo
      ,IdTrabajador
      ,FechaAsignacion
      ,ConvenioLaboral
      ,RelacionLaboral
      ,Categoria
      ,EstructuraOrganica
      ,EstructuraOrganicaPadrePlaza
      ,UbicacionFisica
      ,EstructuraOrganicaPadre
      ,EsComisionado
      ,FechaInicio
      ,FechaTermino
      ,IdConvenioLaboralTrabajador
      ,EstatusTrabajador
      ,Fotografia
      ,NSS
      ,CorreoElectronico
      ,IdCategoria
      ,IdEstructuraOrganica
      ,IdRelacionLaboral
      ,IdConvenioLaboral
      ,IdEstructuraOrganicaPadre
      ,CorreoInstitucional
      ,Telefono
      ,OrdenEstructuraOrganica
      ,IdEstructuraOrganicaFisica
      ,Antiguedad
      ,Años
      ,Meses
      ,Dias
      ,Direccion
      ,CorreoTrabajo
      ,TelefonoTrabajo
      ,ProcesoCompletado
      
      ,IdDistribucionPlazaCategoria
      ,IdRelacionConvenioLaboral
      ,IdeEmpleadoAnt
      ,EsHomologado
      ,CategoriaAnteriorNova
      ,RelacionConvenioLaboral
      ,Pk
      ,Incidencia
      ,RestringirMenu
  FROM stHorarioNominaDocente a
  inner join ctTipoHoras b on a.IdTipoHoras=b.IdTipoHoras and a.IdModalidadEstudio=b.IdModalidadEstudio
  inner join ctDia  x on x.IdDia=a.IdDia
  left join "+dbnameNova+ @".dbo.vwDatosAspirantesTrabajadores c on c.IdKardex=a.IdKardex where c.esplazabase=1

and (a.Marcareliminado=0 or Marcareliminado is null) and  EstatusTrabajador<>'PROXIMAMENTE' AND  a.IdCicloEscolar=" + idciclo + condicion + " order by a.idkardex,a.IdDia,HoraInicio ";

            NominaHorariosDocentesDetalleAnterior = (List<NominaHorariosDocentesDetalle>)dp.connection.Query<NominaHorariosDocentesDetalle>(query.ToString());


            dp.Close();


            return NominaHorariosDocentesDetalleAnterior;

        }
        public void getHorarioDocenteAnterior(int idkardex)
        {

            NominaHorariosDocentesDetalleAnterior = new List<NominaHorariosDocentesDetalle>();

            string query;


            string condicion = "";

            

            condicion = condicion + "  a.IdKardex=" + idkardex;

            if (this.Nomina_stNomina != null)
            {
                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("HORAS EXTRAORDINARIAS"))
                {
                    condicion = condicion+" and a.IdTipoHoras  in (39,40,41,42)  ";
                }
                else
                    condicion = condicion+ "  and a.IdTipoHoras  not in (39,40,41,42)  ";

                condicion = condicion+ $@"  and (a.IdCicloEscolar={ this.IdCicloEscolarAnteriorPlantel} or  (( a.FechaInicioPago <= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND a.FechaFinalPago >= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' ) 
                   or (a.FechaInicioPago >= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND a.FechaFinalPago >= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}') or  (a.FechaInicioPago<='{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' and a.FechaFinalPago>='{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' ) ) )";
            }

            DapperQuery dp = new DapperQuery("bdAriesEntities");

            string dbnameNova = GetDatabaseName("bdNovaEntities");

            query = @"SELECT  IdHorarioNominaDocente
      ,a.IdKardex
      ,IdCicloEscolar
      ,a.IdDia
      ,a.IdTipoHoras
      ,HoraInicio
      ,HoraFinal
      ,Horas
      ,a.IdModalidadEstudio
      ,NoAutorizadas
      ,a.Vigente
      ,FechaMovimiento
      ,FechaInicioPago
      ,FechaFinalPago
      ,Aplicado
      ,MarcarEliminado
      ,InmediatoAnterior
      ,IdHorarioTabla
      ,x.Nombre as Dia
      ,IdHorario,b.Nombre as TipoHoras
      ,c.IdConvenioLaboralTrabajadorCategoria
      ,c.RFC
      ,c.CURP
      ,c.Nombre
      ,ApellidoPaterno
      ,ApellidoMaterno
      ,Sexo
      ,IdTrabajador
      ,FechaAsignacion
      ,ConvenioLaboral
      ,RelacionLaboral
      ,Categoria
      ,EstructuraOrganica
      ,EstructuraOrganicaPadrePlaza
      ,UbicacionFisica
      ,EstructuraOrganicaPadre
      ,EsComisionado
      ,FechaInicio
      ,FechaTermino
      ,IdConvenioLaboralTrabajador
      ,EstatusTrabajador
      ,Fotografia
      ,NSS
      ,CorreoElectronico
      ,IdCategoria
      ,IdEstructuraOrganica
      ,IdRelacionLaboral
      ,IdConvenioLaboral
      ,IdEstructuraOrganicaPadre
      ,CorreoInstitucional
      ,Telefono
      ,OrdenEstructuraOrganica
      ,IdEstructuraOrganicaFisica
      ,Antiguedad
      ,Años
      ,Meses
      ,Dias
      ,Direccion
      ,CorreoTrabajo
      ,TelefonoTrabajo
      ,ProcesoCompletado
      
      ,IdDistribucionPlazaCategoria
      ,IdRelacionConvenioLaboral
      ,IdeEmpleadoAnt
      ,EsHomologado
      ,CategoriaAnteriorNova
      ,RelacionConvenioLaboral
      ,Pk
      ,Incidencia
      ,RestringirMenu
  FROM stHorarioNominaDocente a
  inner join ctTipoHoras b on a.IdTipoHoras=b.IdTipoHoras and a.IdModalidadEstudio=b.IdModalidadEstudio
  inner join ctDia  x on x.IdDia=a.IdDia
  left join "+ dbnameNova + @".dbo.vwDatosAspirantesTrabajadores c on c.EstatusTrabajador<>'PROXIMAMENTE' 
and c.Esplazabase=1 and c.IdKardex=a.IdKardex where (marcareliminado=0 or marcareliminado is null) and  a.Aplicado=1  and " + condicion + " order by a.idkardex,a.IdDia,HoraInicio ";

            NominaHorariosDocentesDetalleAnterior = (List<NominaHorariosDocentesDetalle>)dp.connection.Query<NominaHorariosDocentesDetalle>(query.ToString());



            dp.Close();


        }


        public List<Kardex_ctTrabajador> getCambiosdeContratos()
        {


            if (ListaCambiosdeContratos.Count == 0)

            {
                DapperQuery dp = new DapperQuery("bdNovaEntities");



                string query = @"     select wt.* from(
     select * from(
           select max(fechainicio)as fechainicio, IdTrabajador from(
           select b.IdConvenioLaboralTrabajadorCategoria, g.IdTrabajador, max(b.fechainicio)as fechainicio from
             Convenios_stConvenioLaboralTrabajadorCategoria b
            inner
                                                                                                           join Plazas_stDistribucionPlazaCategoria c on c.IdDistribucionPlazaCategoria = b.IdDistribucionPlazaCategoria
                                                                                           inner
                                                                                                           join Plazas_ctCategoria d on d.IdCategoria = c.IdCategoria
                                                                                           inner
                                                                                                           join Convenios_stConvenioLaboralTrabajador f on f.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
                                                                                           inner
                                                                                                           join Kardex_ctTrabajador g on g.IdTrabajador = f.IdTrabajador
            

          group by b.IdConvenioLaboralTrabajadorCategoria,g.IdTrabajador
 
 ) as g group by IdTrabajador having COUNT(IdTrabajador) > 1
 ) as w where year(w.fechainicio)>= YEAR(GETDATE()) - 1 
 ) as f
 inner join Kardex_ctTrabajador wt on wt.idtrabajador=f.IdTrabajador";

                List<Kardex_ctTrabajador> posibles = (List<Kardex_ctTrabajador>)dp.connection.Query<Kardex_ctTrabajador>(query.ToString());


                ListaCambiosdeContratos.AddRange(posibles);

                dp.Close();
            }

            return ListaCambiosdeContratos;

        }
        protected async void SyncBorrarNomina()
        {





            BorradoCompletado = await Task.Run(() => this.BorrarNomina());

        }


        private void setDeduccionesExcluidas()
        {

            using (var dbContext = new bdNovaEntities())
            {
                dbContext.Database.Connection.Open();
                this.DeduccionesExcluidas = dbContext.Deducciones_stPlantillaNominaDeducciones.Where(e => e.Deducciones_ctDeduccion.EsExlcuidaParaNeto == true).ToList();
                dbContext.Database.Connection.Close();
            }


        }

        public IEnumerable<short> getDeduccionesExcluidas()
        {

            return this.DeduccionesExcluidas.Select(w => w.IdPlantillaNominaDeduccion).ToArray(); ;

        }




        public void getAguinaldo()
        {



            DapperQuery dp = new DapperQuery("bdNovaEntities");

            ListaAguinaldoTrabajadores = new List<AguinaldoTrabajadores>();

            string query = @" select  g.RelacionConvenioLaboral,i.IdConvenioLaboralTrabajadorCategoria
,sum(b.SueldoBrutoQuinquenioDiario) as SueldoBrutoQuinquenioDiario
,sum(case when sdoc.EsHomologado=1 then sdoc.importe+qu.importeQuinquenio else sdoc.importe end ) as SueldoBrutoQuinquenioDiarioDocente
,SUM(
    CASE 
        WHEN m.TipoCalculo <> 'NORMAL' OR Plantilla like '%CCT%' THEN 0
        ELSE 
                b.DiasEfectivosLaborados+b.diasDeAjuste              
    END
) AS DiasEfectivosLaborados 
,SUM(
    CASE 
        WHEN m.TipoCalculo <> 'NORMAL' OR Plantilla like '%CCT%' THEN 0
        ELSE 
            CASE 
                WHEN DAY(a.FechaInicio) > 0
                THEN b.DiasEfectivosLaborados +b.diasDeAjuste+ (DAY(DATEADD(DD, -1, DATEADD(mm, DATEDIFF(mm, 0, a.FechaTermino) + 1, 0))) - 30) 
                ELSE b.DiasEfectivosLaborados  +b.diasDeAjuste              
            END 
    END
) AS DiasCalendarioLaborados 
,k.IdTrabajador
,MIN(a.FechaInicio) as FechaInicio
,MAX(a.FechaTermino) as FechaTermino
 ,sum(b.DiasFaltas) as DiasFaltas
 ,sum(b.HorasFaltas) as HorasFaltas
   FROM Nomina_stNomina a 
  inner join Nomina_stNominaTrabajador b on a.IdNomina=b.IdNomina
 inner join Nomina_ctPlantillaNomina t on t.IdPlantillaNomina=a.IdPlantillaNomina 
 inner join [Nomina_ctPlantillaGrupo] N on T.IdPlantillaGrupo=N.IdPlantillaGrupo
inner join Catalogos_ctQuincenaMes h on h.IdQuincenaMes=a.IdQuincenaMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria i on i.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador=i.IdConvenioLaboralTrabajador
  inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=xx.IdNominaTrabajadorEstatusGrupo
 INNER JOIN Convenios_stRelacionConvenioLaboral g ON g.IdRelacionConvenioLaboral=t.IdRelacionConvenioLaboral
    inner join Catalogos_ctConvenioLaboral v on v.IdConvenioLaboral=g.IdConvenioLaboral
 inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=a.IdTipoCalculo
left  join (
	select b.IdNominaTrabajador, b.IdConvenioLaboralTrabajadorCategoria,  sum(per.Importe) as importe,a.FechaInicio,a.FechaTermino,pc.EsHomologado
 FROM Nomina_stNomina a 
  inner join Nomina_stNominaTrabajador b on a.IdNomina=b.IdNomina
  inner join Percepciones_stNominaTrabajadorPercepciones per on per.IdNominaTrabajador=b.IdNominaTrabajador
  inner join Percepciones_stPlantillaNominaPercepciones pp on pp.IdPlantillaNominaPercepcion=per.IdPlantillaNominaPercepcion
  inner join Percepciones_ctPercepcion cp on cp.IdPercepcion=pp.IdPercepcion
 inner join Nomina_ctPlantillaNomina t on t.IdPlantillaNomina=a.IdPlantillaNomina 
 inner join [Nomina_ctPlantillaGrupo] N on T.IdPlantillaGrupo=N.IdPlantillaGrupo
inner join Catalogos_ctQuincenaMes h on h.IdQuincenaMes=a.IdQuincenaMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria i on i.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador=i.IdConvenioLaboralTrabajador
  inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=xx.IdNominaTrabajadorEstatusGrupo
 INNER JOIN Convenios_stRelacionConvenioLaboral g ON g.IdRelacionConvenioLaboral=t.IdRelacionConvenioLaboral
    inner join Catalogos_ctConvenioLaboral v on v.IdConvenioLaboral=g.IdConvenioLaboral
 inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=a.IdTipoCalculo
 inner join Plazas_stDistribucionPlazaCategoria pd on pd.IdDistribucionPlazaCategoria=i.IdDistribucionPlazaCategoria
 inner join Plazas_ctCategoria pc on pc.IdCategoria=pd.IdCategoria
  where  EstatusNominaGrupo ='PARA PAGO' AND N.PlantillaGrupo='SUELDO' AND    (cp.Percepcion like '%sueldo%' OR PER.Concepto like '%sueldo%')   and 
   a.Año=" + this.Nomina_stNomina.Año + @"
    group by  b.IdNominaTrabajador,b.IdConvenioLaboralTrabajadorCategoria,a.FechaInicio,a.FechaTermino,pc.EsHomologado
 ) as sdoc on sdoc.IdNominaTrabajador=b.IdNominaTrabajador
left  join (
	select b.IdNominaTrabajador, b.IdConvenioLaboralTrabajadorCategoria,  sum(per.Importe) as importeQuinquenio,a.FechaInicio,a.FechaTermino,pc.EsHomologado
 FROM Nomina_stNomina a 
  inner join Nomina_stNominaTrabajador b on a.IdNomina=b.IdNomina
  inner join Percepciones_stNominaTrabajadorPercepciones per on per.IdNominaTrabajador=b.IdNominaTrabajador
  inner join Percepciones_stPlantillaNominaPercepciones pp on pp.IdPlantillaNominaPercepcion=per.IdPlantillaNominaPercepcion
  inner join Percepciones_ctPercepcion cp on cp.IdPercepcion=pp.IdPercepcion
 inner join Nomina_ctPlantillaNomina t on t.IdPlantillaNomina=a.IdPlantillaNomina 
 inner join [Nomina_ctPlantillaGrupo] N on T.IdPlantillaGrupo=N.IdPlantillaGrupo
inner join Catalogos_ctQuincenaMes h on h.IdQuincenaMes=a.IdQuincenaMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria i on i.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador=i.IdConvenioLaboralTrabajador
  inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=xx.IdNominaTrabajadorEstatusGrupo
 INNER JOIN Convenios_stRelacionConvenioLaboral g ON g.IdRelacionConvenioLaboral=t.IdRelacionConvenioLaboral
    inner join Catalogos_ctConvenioLaboral v on v.IdConvenioLaboral=g.IdConvenioLaboral
 inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=a.IdTipoCalculo
 inner join Plazas_stDistribucionPlazaCategoria pd on pd.IdDistribucionPlazaCategoria=i.IdDistribucionPlazaCategoria
 inner join Plazas_ctCategoria pc on pc.IdCategoria=pd.IdCategoria
  where  EstatusNominaGrupo ='PARA PAGO' AND N.PlantillaGrupo='SUELDO' AND     (cp.Percepcion like '%QUINQUENIO%' OR PER.Concepto like '%QUINQUENIO%')  and 
   a.Año=" + this.Nomina_stNomina.Año + @"
    group by  b.IdNominaTrabajador,b.IdConvenioLaboralTrabajadorCategoria,a.FechaInicio,a.FechaTermino,pc.EsHomologado
 ) as qu  on qu.IdNominaTrabajador=b.IdNominaTrabajador
  where  EstatusNominaGrupo ='PARA PAGO' AND N.PlantillaGrupo='SUELDO'   and 
    a.Año=" + this.Nomina_stNomina.Año + " group by g.RelacionConvenioLaboral,i.IdConvenioLaboralTrabajadorCategoria, k.IdTrabajador";
            
            //ListaAguinaldoTrabajadores = (List<AguinaldoTrabajadores>)dp.connection.Query<AguinaldoTrabajadores>(query);



            string queryagui = $@"
 select 
x.IdTrabajador
,NombreTrabajador = y.Nombre+SPACE(1)+y.ApellidoPaterno+SPACE(1)+y.ApellidoMaterno
,d.SueldoDiario
,d.SalarioDiarioIntegrado
,d.DiasEfectivosLaborados
,TipoConcepto=1
,'PERCEPCIÓN' AS Tipo
, case when a.EsDevolucionFaltas=1 then c.Percepcion+ SPACE(1) + a.Concepto +SPACE(1)+'(Devolución)' else c.Percepcion+SPACE(1)+a.Concepto  end  as Concepto
,a.Importe
,y.RFC
,Adscripcion = qq.EstructuraOrganica
,UbicacionFisica = xw.EstructuraOrganica
,Codigo=xy.Clave
,Categoria= case when len(xy.SubCategoria)>0 then xy.Categoria+SPACE(1)+'('+xy.SubCategoria+')' else xy.Categoria end
,clt.ConvenioLaboralTipo
,zy.RelacionLaboral
,e.FechaInicio
,e.FechaTermino
,f.Plantilla
,pg.PlantillaGrupo
,e.Año
,g.QuincenaMes
,h.Mes
,d.SueldoNeto
,0 as EsAjuste
,d.HorasSemanaMes
,d.HorasExcedentes
,d.SueldoBruto
,d.TotalDeducciones
,xz.RelacionConvenioLaboral
into #percepcionesTrabajador
from Percepciones_stNominaTrabajadorPercepciones a
inner join Percepciones_stPlantillaNominaPercepciones b on a.IdPlantillaNominaPercepcion=b.IdPlantillaNominaPercepcion
inner join Percepciones_ctPercepcion c on c.IdPercepcion=b.IdPercepcion and c.EsVigente = 1
INNER JOIN Nomina_stNominaTrabajador d on d.IdNominaTrabajador = a.IdNominaTrabajador
inner join Nomina_stNomina e on e.IdNomina = d.IdNomina 
inner join Nomina_ctPlantillaNomina f on f.IdPlantillaNomina = e.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo pg on pg.IdPlantillaGrupo=f.IdPlantillaGrupo
inner join Nomina_ctTipoNomina xe on xe.IdTipoNomina = e.IdTipoNomina
inner join Catalogos_ctQuincenaMes g on g.IdQuincenaMes = e.IdQuincenaMes
inner join Catalogos_ctMes h on h.IdMes = g.IdMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria v on v.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador = v.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador x on x.IdTrabajador = w.IdTrabajador
inner join Kardex_ctDatosPersonales y on y.IdKardex = x.IdKardex
inner join Plazas_stDistribucionPlazaCategoria z on z.IdDistribucionPlazaCategoria=v.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria xy on xy.IdCategoria=z.IdCategoria
inner join Convenios_stRelacionConvenioLaboral xz on xz.IdRelacionConvenioLaboral=xy.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral zz on zz.IdConvenioLaboral=xz.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo clt on clt.IdConvenioLaboralTipo=zz.IdConvenioLaboralTipo
inner join Catalogos_ctRelacionLaboral zy on zy.IdRelacionLaboral = xz.IdRelacionLaboral
inner join Catalogos_ctEstructuraOrganica xw on xw.IdEstructuraOrganica = v.IdEstructuraOrganica
inner join Catalogos_ctEstructuraOrganica qq on qq.IdEstructuraOrganica = z.IdEstructuraOrganica
inner join Nomina_stNominaTrabajadorEstatus QB on QB.IdNominaTrabajadorEstatus=d.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=qb.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO'  
AND pg.PlantillaGrupo='SUELDO' 
and year(e.FechaTermino)={this.Nomina_stNomina.FechaTermino.Year}  


select
x.IdTrabajador
,NombreTrabajador = y.Nombre+SPACE(1)+y.ApellidoPaterno+SPACE(1)+y.ApellidoMaterno
 ,d.SueldoDiario
,d.SalarioDiarioIntegrado
,d.DiasEfectivosLaborados
,TipoConcepto=2
,'DEDUCCIÓN' AS Tipo
,c.Deduccion+SPACE(1)+a.Concepto as Concepto
,Importe =(a.Importe *-1)
,y.RFC
,Adscripcion = qq.EstructuraOrganica
,UbicacionFisica = xw.EstructuraOrganica
,Codigo=xy.Clave
,Categoria= case when len(xy.SubCategoria)>0 then xy.Categoria +SPACE(1)+'('+xy.SubCategoria+')' else xy.Categoria end
,clt.ConvenioLaboralTipo
,zy.RelacionLaboral
,e.FechaInicio
,e.FechaTermino
,f.Plantilla
,pg.PlantillaGrupo
,e.Año
,g.QuincenaMes
,h.Mes
,d.SueldoNeto
,0 as EsAjuste
,d.HorasSemanaMes
,d.HorasExcedentes
,d.SueldoBruto
,d.TotalDeducciones
,xz.RelacionConvenioLaboral
into #deduccionesTrabajador
from Deducciones_stNominaTrabajadorDeduccion a
inner join Deducciones_stPlantillaNominaDeducciones b on a.IdPlantillaNominaDeduccion=b.IdPlantillaNominaDeduccion
inner join Deducciones_ctDeduccion c on c.IdDeduccion=b.IdDeduccion
inner join Nomina_stNominaTrabajador d on d.IdNominaTrabajador = a.IdNominaTrabajador
inner join Nomina_stNomina e on e.IdNomina = d.IdNomina 
inner join Nomina_ctPlantillaNomina f on f.IdPlantillaNomina = e.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo pg on pg.IdPlantillaGrupo=f.IdPlantillaGrupo
inner join Nomina_ctTipoNomina xe on xe.IdTipoNomina = e.IdTipoNomina
inner join Catalogos_ctQuincenaMes g on g.IdQuincenaMes = e.IdQuincenaMes
inner join Catalogos_ctMes h on h.IdMes = g.IdMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria v on v.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador = v.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador x on x.IdTrabajador = w.IdTrabajador
inner join Kardex_ctDatosPersonales y on y.IdKardex = x.IdKardex
inner join Plazas_stDistribucionPlazaCategoria z on z.IdDistribucionPlazaCategoria=v.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria xy on xy.IdCategoria=z.IdCategoria
inner join Convenios_stRelacionConvenioLaboral xz on xz.IdRelacionConvenioLaboral=xy.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral zz on zz.IdConvenioLaboral=xz.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo clt on clt.IdConvenioLaboralTipo=zz.IdConvenioLaboralTipo
inner join Catalogos_ctRelacionLaboral zy on zy.IdRelacionLaboral = xz.IdRelacionLaboral
inner join Catalogos_ctEstructuraOrganica xw on xw.IdEstructuraOrganica = v.IdEstructuraOrganica
inner join Catalogos_ctEstructuraOrganica qq on qq.IdEstructuraOrganica = z.IdEstructuraOrganica
inner join Nomina_stNominaTrabajadorEstatus QB on QB.IdNominaTrabajadorEstatus=d.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=qb.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' 
AND pg.PlantillaGrupo='SUELDO' 
and year(e.FechaTermino)={this.Nomina_stNomina.FechaTermino.Year} 

 
 select * from (
select * from #percepcionesTrabajador
union all
select * from #deduccionesTrabajador
) as t where   (t.Concepto like '%sueldo%' OR t.Concepto like '%QUINQUENIO%' OR t.Concepto like '%INCAPACIDAD%')

drop table #percepcionesTrabajador

drop table  #deduccionesTrabajador ";

            TrabajadorNominaParaAguinaldo = (List<TrabajadorNominaParaAguinaldo>)dp.connection.Query<TrabajadorNominaParaAguinaldo>(queryagui);



              query = @" select  g.RelacionConvenioLaboral,i.IdConvenioLaboralTrabajadorCategoria
,sum(b.SueldoBrutoQuinquenioDiario) as SueldoBrutoQuinquenioDiario
,sum(case when sdoc.EsHomologado=1 then sdoc.importe+qu.importeQuinquenio else sdoc.importe end ) as SueldoBrutoQuinquenioDiarioDocente
,SUM(
    CASE 
        WHEN m.TipoCalculo <> 'NORMAL' OR Plantilla like '%CCT%' THEN 0
        ELSE 
                b.DiasEfectivosLaborados+b.diasDeAjuste              
    END
) AS DiasEfectivosLaborados 
,SUM(
    CASE 
        WHEN m.TipoCalculo <> 'NORMAL' OR Plantilla like '%CCT%' THEN 0
        ELSE 
            CASE 
                WHEN DAY(a.FechaInicio) > 0
                THEN b.DiasEfectivosLaborados +b.diasDeAjuste+ (DAY(DATEADD(DD, -1, DATEADD(mm, DATEDIFF(mm, 0, a.FechaTermino) + 1, 0))) - 30) 
                ELSE b.DiasEfectivosLaborados  +b.diasDeAjuste              
            END 
    END
) AS DiasCalendarioLaborados 
,k.IdTrabajador
,MIN(a.FechaInicio) as FechaInicio
,MAX(a.FechaTermino) as FechaTermino
 ,sum(b.DiasFaltas) as DiasFaltas
 ,sum(b.HorasFaltas) as HorasFaltas
   FROM Nomina_stNomina a 
  inner join Nomina_stNominaTrabajador b on a.IdNomina=b.IdNomina
 inner join Nomina_ctPlantillaNomina t on t.IdPlantillaNomina=a.IdPlantillaNomina 
 inner join [Nomina_ctPlantillaGrupo] N on T.IdPlantillaGrupo=N.IdPlantillaGrupo
inner join Catalogos_ctQuincenaMes h on h.IdQuincenaMes=a.IdQuincenaMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria i on i.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador=i.IdConvenioLaboralTrabajador
  inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=xx.IdNominaTrabajadorEstatusGrupo
 INNER JOIN Convenios_stRelacionConvenioLaboral g ON g.IdRelacionConvenioLaboral=t.IdRelacionConvenioLaboral
    inner join Catalogos_ctConvenioLaboral v on v.IdConvenioLaboral=g.IdConvenioLaboral
 inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=a.IdTipoCalculo
left  join (
	select b.IdNominaTrabajador, b.IdConvenioLaboralTrabajadorCategoria,  sum(per.Importe) as importe,a.FechaInicio,a.FechaTermino,pc.EsHomologado
 FROM Nomina_stNomina a 
  inner join Nomina_stNominaTrabajador b on a.IdNomina=b.IdNomina
  inner join Percepciones_stNominaTrabajadorPercepciones per on per.IdNominaTrabajador=b.IdNominaTrabajador
  inner join Percepciones_stPlantillaNominaPercepciones pp on pp.IdPlantillaNominaPercepcion=per.IdPlantillaNominaPercepcion
  inner join Percepciones_ctPercepcion cp on cp.IdPercepcion=pp.IdPercepcion
 inner join Nomina_ctPlantillaNomina t on t.IdPlantillaNomina=a.IdPlantillaNomina 
 inner join [Nomina_ctPlantillaGrupo] N on T.IdPlantillaGrupo=N.IdPlantillaGrupo
inner join Catalogos_ctQuincenaMes h on h.IdQuincenaMes=a.IdQuincenaMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria i on i.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador=i.IdConvenioLaboralTrabajador
  inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=xx.IdNominaTrabajadorEstatusGrupo
 INNER JOIN Convenios_stRelacionConvenioLaboral g ON g.IdRelacionConvenioLaboral=t.IdRelacionConvenioLaboral
    inner join Catalogos_ctConvenioLaboral v on v.IdConvenioLaboral=g.IdConvenioLaboral
 inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=a.IdTipoCalculo
 inner join Plazas_stDistribucionPlazaCategoria pd on pd.IdDistribucionPlazaCategoria=i.IdDistribucionPlazaCategoria
 inner join Plazas_ctCategoria pc on pc.IdCategoria=pd.IdCategoria
  where  EstatusNominaGrupo ='PARA PAGO' AND N.PlantillaGrupo='SUELDO' AND    (cp.Percepcion like '%sueldo%' OR PER.Concepto like '%sueldo%')   and 
   a.Año=" + this.Nomina_stNomina.Año + @"
    group by  b.IdNominaTrabajador,b.IdConvenioLaboralTrabajadorCategoria,a.FechaInicio,a.FechaTermino,pc.EsHomologado
 ) as sdoc on sdoc.IdNominaTrabajador=b.IdNominaTrabajador
left  join (
	select b.IdNominaTrabajador, b.IdConvenioLaboralTrabajadorCategoria,  sum(per.Importe) as importeQuinquenio,a.FechaInicio,a.FechaTermino,pc.EsHomologado
 FROM Nomina_stNomina a 
  inner join Nomina_stNominaTrabajador b on a.IdNomina=b.IdNomina
  inner join Percepciones_stNominaTrabajadorPercepciones per on per.IdNominaTrabajador=b.IdNominaTrabajador
  inner join Percepciones_stPlantillaNominaPercepciones pp on pp.IdPlantillaNominaPercepcion=per.IdPlantillaNominaPercepcion
  inner join Percepciones_ctPercepcion cp on cp.IdPercepcion=pp.IdPercepcion
 inner join Nomina_ctPlantillaNomina t on t.IdPlantillaNomina=a.IdPlantillaNomina 
 inner join [Nomina_ctPlantillaGrupo] N on T.IdPlantillaGrupo=N.IdPlantillaGrupo
inner join Catalogos_ctQuincenaMes h on h.IdQuincenaMes=a.IdQuincenaMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria i on i.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador k on k.IdConvenioLaboralTrabajador=i.IdConvenioLaboralTrabajador
  inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=xx.IdNominaTrabajadorEstatusGrupo
 INNER JOIN Convenios_stRelacionConvenioLaboral g ON g.IdRelacionConvenioLaboral=t.IdRelacionConvenioLaboral
    inner join Catalogos_ctConvenioLaboral v on v.IdConvenioLaboral=g.IdConvenioLaboral
 inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=a.IdTipoCalculo
 inner join Plazas_stDistribucionPlazaCategoria pd on pd.IdDistribucionPlazaCategoria=i.IdDistribucionPlazaCategoria
 inner join Plazas_ctCategoria pc on pc.IdCategoria=pd.IdCategoria
  where  EstatusNominaGrupo ='PARA PAGO' AND N.PlantillaGrupo='SUELDO' AND     (cp.Percepcion like '%QUINQUENIO%' OR PER.Concepto like '%QUINQUENIO%')  and 
   a.Año=" + this.Nomina_stNomina.Año + @"
    group by  b.IdNominaTrabajador,b.IdConvenioLaboralTrabajadorCategoria,a.FechaInicio,a.FechaTermino,pc.EsHomologado
 ) as qu  on qu.IdNominaTrabajador=b.IdNominaTrabajador
  where  EstatusNominaGrupo ='PARA PAGO' AND N.PlantillaGrupo='SUELDO'   and 
    a.Año=" + this.Nomina_stNomina.Año + " group by g.RelacionConvenioLaboral,i.IdConvenioLaboralTrabajadorCategoria, k.IdTrabajador";

            //ListaAguinaldoTrabajadores = (List<AguinaldoTrabajadores>)dp.connection.Query<AguinaldoTrabajadores>(query);



              queryagui = $@"
 select 
x.IdTrabajador
,NombreTrabajador = y.Nombre+SPACE(1)+y.ApellidoPaterno+SPACE(1)+y.ApellidoMaterno
,d.SueldoDiario
,d.SalarioDiarioIntegrado
,d.DiasEfectivosLaborados
,TipoConcepto=1
,'PERCEPCIÓN' AS Tipo
, case when a.EsDevolucionFaltas=1 then c.Percepcion+ SPACE(1) + a.Concepto +SPACE(1)+'(Devolución)' else c.Percepcion+SPACE(1)+a.Concepto  end  as Concepto
,a.Importe
,y.RFC
,Adscripcion = qq.EstructuraOrganica
,UbicacionFisica = xw.EstructuraOrganica
,Codigo=xy.Clave
,Categoria= case when len(xy.SubCategoria)>0 then xy.Categoria+SPACE(1)+'('+xy.SubCategoria+')' else xy.Categoria end
,clt.ConvenioLaboralTipo
,zy.RelacionLaboral
,e.FechaInicio
,e.FechaTermino
,f.Plantilla
,pg.PlantillaGrupo
,e.Año
,g.QuincenaMes
,h.Mes
,d.SueldoNeto
,0 as EsAjuste
,d.HorasSemanaMes
,d.HorasExcedentes
,d.SueldoBruto
,d.TotalDeducciones
,xz.RelacionConvenioLaboral
into #percepcionesTrabajador
from Percepciones_stNominaTrabajadorPercepciones a
inner join Percepciones_stPlantillaNominaPercepciones b on a.IdPlantillaNominaPercepcion=b.IdPlantillaNominaPercepcion
inner join Percepciones_ctPercepcion c on c.IdPercepcion=b.IdPercepcion and c.EsVigente = 1
INNER JOIN Nomina_stNominaTrabajador d on d.IdNominaTrabajador = a.IdNominaTrabajador
inner join Nomina_stNomina e on e.IdNomina = d.IdNomina 
inner join Nomina_ctPlantillaNomina f on f.IdPlantillaNomina = e.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo pg on pg.IdPlantillaGrupo=f.IdPlantillaGrupo
inner join Nomina_ctTipoNomina xe on xe.IdTipoNomina = e.IdTipoNomina
inner join Catalogos_ctQuincenaMes g on g.IdQuincenaMes = e.IdQuincenaMes
inner join Catalogos_ctMes h on h.IdMes = g.IdMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria v on v.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador = v.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador x on x.IdTrabajador = w.IdTrabajador
inner join Kardex_ctDatosPersonales y on y.IdKardex = x.IdKardex
inner join Plazas_stDistribucionPlazaCategoria z on z.IdDistribucionPlazaCategoria=v.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria xy on xy.IdCategoria=z.IdCategoria
inner join Convenios_stRelacionConvenioLaboral xz on xz.IdRelacionConvenioLaboral=xy.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral zz on zz.IdConvenioLaboral=xz.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo clt on clt.IdConvenioLaboralTipo=zz.IdConvenioLaboralTipo
inner join Catalogos_ctRelacionLaboral zy on zy.IdRelacionLaboral = xz.IdRelacionLaboral
inner join Catalogos_ctEstructuraOrganica xw on xw.IdEstructuraOrganica = v.IdEstructuraOrganica
inner join Catalogos_ctEstructuraOrganica qq on qq.IdEstructuraOrganica = z.IdEstructuraOrganica
inner join Nomina_stNominaTrabajadorEstatus QB on QB.IdNominaTrabajadorEstatus=d.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=qb.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO'  
AND pg.PlantillaGrupo='SUELDO' 
and year(e.FechaTermino)={this.Nomina_stNomina.FechaTermino.Year}  


select
x.IdTrabajador
,NombreTrabajador = y.Nombre+SPACE(1)+y.ApellidoPaterno+SPACE(1)+y.ApellidoMaterno
 ,d.SueldoDiario
,d.SalarioDiarioIntegrado
,d.DiasEfectivosLaborados
,TipoConcepto=2
,'DEDUCCIÓN' AS Tipo
,c.Deduccion+SPACE(1)+a.Concepto as Concepto
,Importe =(a.Importe *-1)
,y.RFC
,Adscripcion = qq.EstructuraOrganica
,UbicacionFisica = xw.EstructuraOrganica
,Codigo=xy.Clave
,Categoria= case when len(xy.SubCategoria)>0 then xy.Categoria +SPACE(1)+'('+xy.SubCategoria+')' else xy.Categoria end
,clt.ConvenioLaboralTipo
,zy.RelacionLaboral
,e.FechaInicio
,e.FechaTermino
,f.Plantilla
,pg.PlantillaGrupo
,e.Año
,g.QuincenaMes
,h.Mes
,d.SueldoNeto
,0 as EsAjuste
,d.HorasSemanaMes
,d.HorasExcedentes
,d.SueldoBruto
,d.TotalDeducciones
,xz.RelacionConvenioLaboral
into #deduccionesTrabajador
from Deducciones_stNominaTrabajadorDeduccion a
inner join Deducciones_stPlantillaNominaDeducciones b on a.IdPlantillaNominaDeduccion=b.IdPlantillaNominaDeduccion
inner join Deducciones_ctDeduccion c on c.IdDeduccion=b.IdDeduccion
inner join Nomina_stNominaTrabajador d on d.IdNominaTrabajador = a.IdNominaTrabajador
inner join Nomina_stNomina e on e.IdNomina = d.IdNomina 
inner join Nomina_ctPlantillaNomina f on f.IdPlantillaNomina = e.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo pg on pg.IdPlantillaGrupo=f.IdPlantillaGrupo
inner join Nomina_ctTipoNomina xe on xe.IdTipoNomina = e.IdTipoNomina
inner join Catalogos_ctQuincenaMes g on g.IdQuincenaMes = e.IdQuincenaMes
inner join Catalogos_ctMes h on h.IdMes = g.IdMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria v on v.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador = v.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador x on x.IdTrabajador = w.IdTrabajador
inner join Kardex_ctDatosPersonales y on y.IdKardex = x.IdKardex
inner join Plazas_stDistribucionPlazaCategoria z on z.IdDistribucionPlazaCategoria=v.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria xy on xy.IdCategoria=z.IdCategoria
inner join Convenios_stRelacionConvenioLaboral xz on xz.IdRelacionConvenioLaboral=xy.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral zz on zz.IdConvenioLaboral=xz.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo clt on clt.IdConvenioLaboralTipo=zz.IdConvenioLaboralTipo
inner join Catalogos_ctRelacionLaboral zy on zy.IdRelacionLaboral = xz.IdRelacionLaboral
inner join Catalogos_ctEstructuraOrganica xw on xw.IdEstructuraOrganica = v.IdEstructuraOrganica
inner join Catalogos_ctEstructuraOrganica qq on qq.IdEstructuraOrganica = z.IdEstructuraOrganica
inner join Nomina_stNominaTrabajadorEstatus QB on QB.IdNominaTrabajadorEstatus=d.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=qb.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' 
AND pg.PlantillaGrupo='SUELDO' 
and year(e.FechaTermino)={this.Nomina_stNomina.FechaTermino.Year} 

 
 select * from (
select * from #percepcionesTrabajador
union all
select * from #deduccionesTrabajador
) as t where   (t.Concepto like 'GASTO ADMINISTRATIVO%')

drop table #percepcionesTrabajador

drop table  #deduccionesTrabajador ";

            TrabajadorNominaParaAguinaldoGastoAdmivo = (List<TrabajadorNominaParaAguinaldo>)dp.connection.Query<TrabajadorNominaParaAguinaldo>(queryagui);

            dp.Close();


        }

        // Método para procesar la lista de nóminas
        public List<ResumenNominaQuincenal> ObtenerResumenQuincenal(List<TrabajadorNominaParaAguinaldo> nominas)
        {
            var resumenQuincenal = nominas
                .GroupBy(n => new
                {
                    n.IdTrabajador,
                    n.FechaInicio,
                    n.FechaTermino
                    //Quincena = n.FechaInicio.Day <= 15 ? 1 : 2 // Determina si es primera o segunda quincena
                })
                .Select(grupo => new ResumenNominaQuincenal
                {
                    IdTrabajador = grupo.Key.IdTrabajador,
                    NombreTrabajador = grupo.First().NombreTrabajador,
                    FechaInicio = grupo.Min(n => n.FechaInicio),
                    FechaTermino = grupo.Max(n => n.FechaTermino),
                    DiasTrabajados = (grupo.Max(n => n.FechaTermino) - grupo.Min(n => n.FechaInicio)).Days+1,
                    SueldoDiario = grupo.First().SueldoDiario,
                    RFC = grupo.First().RFC
                })
                .ToList();

            return resumenQuincenal;
        }

        public void getPercepcionesRetroactivo()
        {



            DapperQuery dp = new DapperQuery("bdNovaEntities");

            ListaPercepcionesRetroActivoTrabajador = new List<PercepcionesRetroActivoTrabajador>();
            string query = "";
            if (this.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
            {
                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("RETROACTIVO"))
                    query = @" select idtrabajador,SUM(importe) Importe,Percepcion
,max(ImporteRetroActivo)ImporteRetroActivo ,max(PorcentajeRetroActivo) PorcentajeRetroActivo 
,max(TotalQuincenas) as TotalQuincenas
  ,max(ImporteRetroActivo)ImporteRetroActivoC ,max(PorcentajeRetroActivo) PorcentajeRetroActivoC 
from (
SELECT  
ty.IdTrabajador ,sum(c.Importe) as Importe 
,f.Percepcion
,max(d.ImporteRetroActivo)ImporteRetroActivo ,max(d.PorcentajeRetroActivo) PorcentajeRetroActivo 
 ,count(c.IdPlantillaNominaPercepcion) as TotalQuincenas
  ,max(z.ImporteRetroActivo)ImporteRetroActivoC ,max(z.PorcentajeRetroActivo) PorcentajeRetroActivoC 
   FROM Nomina_stNomina a 
  inner join Nomina_stNominaTrabajador b on a.IdNomina=b.IdNomina
  inner join Percepciones_stNominaTrabajadorPercepciones c on b.IdNominaTrabajador=c.IdNominaTrabajador
  inner join Percepciones_stPlantillaNominaPercepciones d on c.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion
  inner join Percepciones_ctPercepcion f on d.IdPercepcion=f.IdPercepcion
inner join Catalogos_ctQuincenaMes h on h.IdQuincenaMes=a.IdQuincenaMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria i on i.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador ty on ty.IdConvenioLaboralTrabajador=i.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria j on j.IdDistribucionPlazaCategoria=i.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria k on k.IdCategoria=j.IdCategoria
left join Percepciones_stPlantillaNominaPercepcionesRetroCategoria z on z.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion
and k.IdCategoria=z.IdCategoria
  inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=xx.IdNominaTrabajadorEstatusGrupo
inner join Nomina_ctTipoCalculo nt on a.IdTipoCalculo=nt.IdTipoCalculo
  where f.percepcion not like '%DEVOLUCIÓN%' AND  EstatusNominaGrupo ='PARA PAGO' and nt.TipoCalculo='NORMAL' AND 
     ( a.FechaInicio>='" + this.Nomina_stNomina.FechaInicio.ToShortDateString() + "'  and a.FechaTermino<='" + this.Nomina_stNomina.FechaTermino.ToShortDateString() + @"')

   and f.Percepcion not in ('AJUSTE','DIFERENCIA')  and f.Percepcion in  (
  select Percepcion from Percepciones_stPlantillaNominaPercepciones  ss
   inner join Percepciones_ctPercepcion gg
    on ss.IdPercepcion=gg.IdPercepcion 
    where ss.IdPlantillaNomina=" + this.Nomina_stNomina.IdPlantillaNomina.ToString() + @"
  and (ss.ImporteRetroActivo>0 or ss.PorcentajeRetroActivo>0)
  ) group by ty.IdTrabajador,f.Percepcion,c.Concepto 
union all 
SELECT 
ty.IdTrabajador ,sum(c.Importe) as Importe 
,c.Concepto
,max(d.ImporteRetroActivo)ImporteRetroActivo ,max(d.PorcentajeRetroActivo) PorcentajeRetroActivo 
,count(c.IdPlantillaNominaPercepcion) as TotalQuincenas
  ,max(z.ImporteRetroActivo)ImporteRetroActivoC ,max(z.PorcentajeRetroActivo) PorcentajeRetroActivoC 
  FROM Nomina_stNomina a inner join Nomina_stNominaTrabajador
   b on a.IdNomina=b.IdNomina inner join Percepciones_stNominaTrabajadorPercepciones c 
   on b.IdNominaTrabajador=c.IdNominaTrabajador inner join Percepciones_stPlantillaNominaPercepciones d 
   on c.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion inner join Percepciones_ctPercepcion f
    on d.IdPercepcion=f.IdPercepcion inner join Catalogos_ctQuincenaMes h on h.IdQuincenaMes=a.IdQuincenaMes 
    inner join Convenios_stConvenioLaboralTrabajadorCategoria i 
    on i.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria inner join 
    Convenios_stConvenioLaboralTrabajador ty on ty.IdConvenioLaboralTrabajador=i.IdConvenioLaboralTrabajador 
    inner join Plazas_stDistribucionPlazaCategoria j on j.IdDistribucionPlazaCategoria=i.IdDistribucionPlazaCategoria 
    inner join Plazas_ctCategoria k on k.IdCategoria=j.IdCategoria left join Percepciones_stPlantillaNominaPercepcionesRetroCategoria z on z.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion and k.IdCategoria=z.IdCategoria inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=xx.IdNominaTrabajadorEstatusGrupo inner join Nomina_ctTipoCalculo nt on a.IdTipoCalculo=nt.IdTipoCalculo 
    where f.percepcion not like '%DEVOLUCIÓN%' AND EstatusNominaGrupo ='PARA PAGO' and nt.TipoCalculo='NORMAL' AND 
     ( a.FechaInicio>='" + this.Nomina_stNomina.FechaInicio.ToShortDateString() + "'  and a.FechaTermino<='" + this.Nomina_stNomina.FechaTermino.ToShortDateString() + @"')
         and c.Concepto in ( select Percepcion from Percepciones_stPlantillaNominaPercepciones  ss
   inner join Percepciones_ctPercepcion gg
    on ss.IdPercepcion=gg.IdPercepcion 
    where ss.IdPlantillaNomina=" + this.Nomina_stNomina.IdPlantillaNomina.ToString() + @"
  and (ss.ImporteRetroActivo>0 or ss.PorcentajeRetroActivo>0) ) 
group by ty.IdTrabajador,c.Concepto
)as hh
group by IdTrabajador,Percepcion
";
                else
                    query = @"
 select idtrabajador,SUM(importe) Importe,Percepcion
,max(ImporteRetroActivo)ImporteRetroActivo ,max(PorcentajeRetroActivo) PorcentajeRetroActivo 
,max(TotalQuincenas) as TotalQuincenas
  ,max(ImporteRetroActivo)ImporteRetroActivoC ,max(PorcentajeRetroActivo) PorcentajeRetroActivoC 
from (
SELECT  
ty.IdTrabajador ,sum(c.Importe) as Importe 
,f.Percepcion
,max(d.ImporteRetroActivo)ImporteRetroActivo ,max(d.PorcentajeRetroActivo) PorcentajeRetroActivo 
 ,count(c.IdPlantillaNominaPercepcion) as TotalQuincenas
  ,max(z.ImporteRetroActivo)ImporteRetroActivoC ,max(z.PorcentajeRetroActivo) PorcentajeRetroActivoC 
   FROM Nomina_stNomina a 
  inner join Nomina_stNominaTrabajador b on a.IdNomina=b.IdNomina
  inner join Percepciones_stNominaTrabajadorPercepciones c on b.IdNominaTrabajador=c.IdNominaTrabajador
  inner join Percepciones_stPlantillaNominaPercepciones d on c.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion
  inner join Percepciones_ctPercepcion f on d.IdPercepcion=f.IdPercepcion
inner join Catalogos_ctQuincenaMes h on h.IdQuincenaMes=a.IdQuincenaMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria i on i.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador ty on ty.IdConvenioLaboralTrabajador=i.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria j on j.IdDistribucionPlazaCategoria=i.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria k on k.IdCategoria=j.IdCategoria
left join Percepciones_stPlantillaNominaPercepcionesRetroCategoria z on z.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion
and k.IdCategoria=z.IdCategoria
  inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=xx.IdNominaTrabajadorEstatusGrupo
inner join Nomina_ctTipoCalculo nt on a.IdTipoCalculo=nt.IdTipoCalculo
  where f.percepcion not like '%DEVOLUCIÓN%' AND EstatusNominaGrupo ='PARA PAGO' and nt.TipoCalculo='NORMAL' AND 
     a.IdPlantillaNomina=" + this.Nomina_stNomina.IdPlantillaNomina.ToString() + @" and 
     ( a.FechaInicio>='" + this.Nomina_stNomina.FechaInicio.ToShortDateString() + "'  and a.FechaTermino<='" + this.Nomina_stNomina.FechaTermino.ToShortDateString() + @"')
   and f.Percepcion not in ('AJUSTE','DIFERENCIA')  and f.Percepcion in  (
  select Percepcion from Percepciones_stPlantillaNominaPercepciones  ss
   inner join Percepciones_ctPercepcion gg
    on ss.IdPercepcion=gg.IdPercepcion 
    where ss.IdPlantillaNomina=" + this.Nomina_stNomina.IdPlantillaNomina.ToString() + @"
  and (ss.ImporteRetroActivo>0 or ss.PorcentajeRetroActivo>0)
  ) group by ty.IdTrabajador,f.Percepcion,c.Concepto 
union all 
SELECT 
ty.IdTrabajador ,sum(c.Importe) as Importe 
,c.Concepto
,max(d.ImporteRetroActivo)ImporteRetroActivo ,max(d.PorcentajeRetroActivo) PorcentajeRetroActivo 
,count(c.IdPlantillaNominaPercepcion) as TotalQuincenas
  ,max(z.ImporteRetroActivo)ImporteRetroActivoC ,max(z.PorcentajeRetroActivo) PorcentajeRetroActivoC 
  FROM Nomina_stNomina a inner join Nomina_stNominaTrabajador
   b on a.IdNomina=b.IdNomina inner join Percepciones_stNominaTrabajadorPercepciones c 
   on b.IdNominaTrabajador=c.IdNominaTrabajador inner join Percepciones_stPlantillaNominaPercepciones d 
   on c.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion inner join Percepciones_ctPercepcion f
    on d.IdPercepcion=f.IdPercepcion inner join Catalogos_ctQuincenaMes h on h.IdQuincenaMes=a.IdQuincenaMes 
    inner join Convenios_stConvenioLaboralTrabajadorCategoria i 
    on i.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria inner join 
    Convenios_stConvenioLaboralTrabajador ty on ty.IdConvenioLaboralTrabajador=i.IdConvenioLaboralTrabajador 
    inner join Plazas_stDistribucionPlazaCategoria j on j.IdDistribucionPlazaCategoria=i.IdDistribucionPlazaCategoria 
    inner join Plazas_ctCategoria k on k.IdCategoria=j.IdCategoria left join Percepciones_stPlantillaNominaPercepcionesRetroCategoria z on z.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion and k.IdCategoria=z.IdCategoria inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=xx.IdNominaTrabajadorEstatusGrupo inner join Nomina_ctTipoCalculo nt on a.IdTipoCalculo=nt.IdTipoCalculo 
    where f.percepcion not like '%DEVOLUCIÓN%' AND EstatusNominaGrupo ='PARA PAGO' and nt.TipoCalculo='NORMAL' AND 
     a.IdPlantillaNomina=" + this.Nomina_stNomina.IdPlantillaNomina.ToString() + @" and 
     ( a.FechaInicio>='" + this.Nomina_stNomina.FechaInicio.ToShortDateString() + "'  and a.FechaTermino<='" + this.Nomina_stNomina.FechaTermino.ToShortDateString() + @"')
         and c.Concepto in ( select Percepcion from Percepciones_stPlantillaNominaPercepciones  ss
   inner join Percepciones_ctPercepcion gg
    on ss.IdPercepcion=gg.IdPercepcion 
    where ss.IdPlantillaNomina=" + this.Nomina_stNomina.IdPlantillaNomina.ToString() + @"
  and (ss.ImporteRetroActivo>0 or ss.PorcentajeRetroActivo>0) ) 
group by ty.IdTrabajador,c.Concepto
)as hh
group by IdTrabajador,Percepcion

SELECT  
ty.IdTrabajador
,sum(c.Importe) as Importe
,c.IdPlantillaNominaPercepcion
,sum(b.BaseGravable) as BaseGravable
,sum(b.SalarioDiarioIntegrado) SalarioDiarioIntegrado
,max(d.ImporteRetroActivo)ImporteRetroActivo
,max(d.PorcentajeRetroActivo) PorcentajeRetroActivo
,max(cast(f.EsGravable as smallint)) as EsGravable
,max(cast(f.EsVariable as smallint)) as EsVariable
,max(cast(f.EsPrevisionSocial as smallint)) EsPrevisionSocial
,count(c.IdPlantillaNominaPercepcion) as TotalQuincenas
,max(z.ImporteRetroActivo)ImporteRetroActivoC
,max(z.PorcentajeRetroActivo) PorcentajeRetroActivoC
   FROM Nomina_stNomina a 
  inner join Nomina_stNominaTrabajador b on a.IdNomina=b.IdNomina
  inner join Percepciones_stNominaTrabajadorPercepciones c on b.IdNominaTrabajador=c.IdNominaTrabajador
  inner join Percepciones_stPlantillaNominaPercepciones d on c.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion
  inner join Percepciones_ctPercepcion f on d.IdPercepcion=f.IdPercepcion
inner join Catalogos_ctQuincenaMes h on h.IdQuincenaMes=a.IdQuincenaMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria i on i.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador ty on ty.IdConvenioLaboralTrabajador=i.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria j on j.IdDistribucionPlazaCategoria=i.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria k on k.IdCategoria=j.IdCategoria
left join Percepciones_stPlantillaNominaPercepcionesRetroCategoria z on z.IdPlantillaNominaPercepcion=d.IdPlantillaNominaPercepcion
and k.IdCategoria=z.IdCategoria
  inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=xx.IdNominaTrabajadorEstatusGrupo
inner join Nomina_ctTipoCalculo nt on a.IdTipoCalculo=nt.IdTipoCalculo
  where f.percepcion not like '%DEVOLUCIÓN%' AND EstatusNominaGrupo ='PARA PAGO' and nt.TipoCalculo='NORMAL' AND 
     a.IdPlantillaNomina=" + this.Nomina_stNomina.IdPlantillaNomina.ToString() + " and ( a.FechaInicio>='" + this.Nomina_stNomina.FechaInicio.ToShortDateString() + "'  and a.FechaTermino<='" + this.Nomina_stNomina.FechaTermino.ToShortDateString() + @"')

  and f.IdPercepcion in (
  select IdPercepcion from Percepciones_stPlantillaNominaPercepciones where IdPlantillaNomina=" + this.Nomina_stNomina.IdPlantillaNomina.ToString() + @"
  and (ImporteRetroActivo>0 or PorcentajeRetroActivo>0)
  )  group by ty.IdTrabajador
  ,c.IdPlantillaNominaPercepcion ";
            }

            ListaPercepcionesRetroActivoTrabajador = (List<PercepcionesRetroActivoTrabajador>)dp.connection.Query<PercepcionesRetroActivoTrabajador>(query);

            string querydeduc = $@"SELECT count(distinct idquincenames) as TotalQuincenas,
ty.idtrabajador,max(dc.deduccion) as Deduccion,sum(de.importe) as Importe,gt.IdPlantillaNominaDeduccion,de.Concepto
FROM Nomina_stNomina a inner join Nomina_stNominaTrabajador
   b on a.IdNomina=b.IdNomina  
   inner join Convenios_stConvenioLaboralTrabajadorCategoria i on i.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador ty on ty.IdConvenioLaboralTrabajador=i.IdConvenioLaboralTrabajador
   inner join Deducciones_stNominaTrabajadorDeduccion de on de.IdNominaTrabajador=b.IdNominaTrabajador
   inner join Deducciones_stPlantillaNominaDeducciones gt on gt.IdPlantillaNominaDeduccion=de.IdPlantillaNominaDeduccion
   inner join Deducciones_ctDeduccion dc on dc.IdDeduccion=gt.IdDeduccion
   inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=xx.IdNominaTrabajadorEstatusGrupo inner join Nomina_ctTipoCalculo nt on a.IdTipoCalculo=nt.IdTipoCalculo 
   where (dc.Deduccion like '%falta%' or dc.Deduccion like '%DESCUENTO POR PAGO INDEBIDO%')
  AND EstatusNominaGrupo ='PARA PAGO' and nt.TipoCalculo='NORMAL' AND 
  (( a.FechaInicio>='{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}'  and a.FechaTermino<='{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' )
    or a.FechaTermino<='{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}')  group by ty.IdTrabajador,gt.IdPlantillaNominaDeduccion,de.Concepto";

            ListaDeduccionesRetroActivoTrabajador = new List<DeduccionesRetroActivoTrabajador>();
            ListaDeduccionesRetroActivoTrabajador = (List<DeduccionesRetroActivoTrabajador>)dp.connection.Query<DeduccionesRetroActivoTrabajador>(querydeduc);
            dp.Close();

            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                this.PercepcionesRetroActivoPorCategoria = basenova.Percepciones_stPlantillaNominaPercepcionesRetroCategoria.AsNoTracking()
                .Include(a => a.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion).ToList();

                basenova.Database.Connection.Close();
            }




        }


        public void setCiclosEscolares()
        {
            DapperQuery dp = new DapperQuery("bdAriesEntities");

            string ciclosbdaries = "select * from ctCicloescolar";

            ctCicloescolar = (List<ctCicloescolar>)dp.connection.Query<ctCicloescolar>(ciclosbdaries);


            short vigentecicloescolarplantel = dp.connection.ExecuteScalar<short>("SELECT dbo.[fnObtenCicloEscolarVigente] (1)");



            IdCicloEscolarVigentePlantel = vigentecicloescolarplantel;

            CicloEscolarVigentePlantel = dp.connection.ExecuteScalar<string>("SELECT Nombre FROM  ctCicloescolar where idcicloescolar=" + IdCicloEscolarVigentePlantel);


            short ultimocicloescolarplantel = dp.connection.ExecuteScalar<short>("SELECT  dbo.[fnObtenCicloEscolarAnteriorPorCiclo] (1," + vigentecicloescolarplantel + ")");
            IdCicloEscolarAnteriorPlantel = ultimocicloescolarplantel;

            CicloEscolarAnteriorPlantel = dp.connection.ExecuteScalar<string>("SELECT Nombre FROM  ctCicloescolar where idcicloescolar=" + IdCicloEscolarAnteriorPlantel);



            short vigentecicloescolaremsad = dp.connection.ExecuteScalar<short>("SELECT [dbo].[fnObtenCicloEscolarVigente] (2)");
            IdCicloEscolarVigenteEmsad = vigentecicloescolaremsad;



            short ultimocicloescolaremsad = dp.connection.ExecuteScalar<short>("SELECT [dbo].[fnObtenCicloEscolarAnteriorPorCiclo](2, " + vigentecicloescolaremsad + ")");
            IdCicloEscolarAnteriorEmsad = ultimocicloescolaremsad;
            dp.Close();
        }

        private void setSubsidioAlEmpleo()
        {

            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();

                Nomina_ConfiguracionSubsidioTrabajador = basenova.Nomina_ConfiguracionSubsidioTrabajador
 .AsNoTracking()
 .Where(c => DbFunctions.TruncateTime(c.Inicio) <= DbFunctions.TruncateTime(this.Nomina_stNomina.FechaTermino)
          && DbFunctions.TruncateTime(c.Termino) >= DbFunctions.TruncateTime(this.Nomina_stNomina.FechaInicio))
 .OrderByDescending(a => new { a.Inicio, a.Termino })
 .ToList();


                basenova.Database.Connection.Close();
            }




            if (Nomina_ConfiguracionSubsidioTrabajador.Count() == 0)
                throw new ApplicationException("No hay datos vigentes de Configuracion del subsidio para el empleo para las fechas de la nómina seleccionada");

        }

       

             private void setPagosDiasEconomicosyPuntualidadAñoAnterior()
        {

            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.EndsWith("ODES")
                || this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla=="BASE DEFINITIVO SUELDO"
                || this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla == "CONFIANZA SUELDO"
                || this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT")
                || this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla == "SPD DOCENTE SUELDO")
            {
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();

                    Nomina_PagosDiasEconomicosyPuntualidad = basenova.Nomina_PagosDiasEconomicosyPuntualidad
        .AsNoTracking()
        .Where(c => c.Año == this.Nomina_stNomina.Año-1)
        .Include(y => y.Catalogos_ctQuincenaMes)
        .Include(y => y.Catalogos_ctTipoPagoRegistro)
        .ToList();

                    

                    basenova.Database.Connection.Close();
                }

                setDiasEconomicosDisfrutadosAñoAnterior();
            }


        
        }

        private void setCostos()
        {

            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                //Plazas_ctCostoHoraJornadaVigentes = basenova.Plazas_ctCostoHoraJornada
                //    .AsNoTracking()
                //    .Where(c => c.FechaInicio <= this.Nomina_stNomina.FechaInicio && c.FechaTermino >= Nomina_stNomina.FechaTermino)
                //    .Include(y => y.Plazas_ctCategoria)
                //    .Include(y => y.Plazas_ctCategoria.Catalogos_ctJornadaLaboral)
                //    .OrderByDescending(a => new { a.FechaInicio, a.FechaTermino })
                //    .ToList();
                Plazas_ctCostoHoraJornadaVigentes = basenova.Plazas_ctCostoHoraJornada
    .AsNoTracking()
    .Where(c => c.FechaInicio <= this.Nomina_stNomina.FechaInicio && c.FechaTermino >= Nomina_stNomina.FechaTermino)
    .Include(y => y.Plazas_ctCategoria)
    .Include(y => y.Plazas_ctCategoria.Catalogos_ctJornadaLaboral)
    .OrderByDescending(a => new { a.FechaInicio, a.FechaTermino })
    .ToList();

                Plazas_ctCostoHoraJornadaTodos = basenova.Plazas_ctCostoHoraJornada
    .AsNoTracking()
    .Include(y => y.Plazas_ctCategoria)
    .Include(y => y.Plazas_ctCategoria.Catalogos_ctJornadaLaboral)
    .OrderByDescending(a => new { a.FechaInicio, a.FechaTermino })
    .ToList();

                basenova.Database.Connection.Close();
            }




            if (Plazas_ctCostoHoraJornadaVigentes == null)
                throw new ApplicationException("No hay datos vigentes de costos hora jornada para las fechas de la nómina seleccionada");

        }

        public Nomina_stNominaTrabajador(int IdNomina, int IdConveniolaboralTrabajadorCategoria = 0, bool esProyeccion = false, bool cerrarNomina = false, bool EsRecalculo = false, bool NoResetAntiguedad = false, short diasRecalculo = 0, int MotivoDevolucionId = 0)
        {

            this.EsRecalculoPorTrabajador = EsRecalculo;
            this.MotivoDevolucionId = MotivoDevolucionId;
            this.EsProyeccion = esProyeccion;
            this.IdNomina = IdNomina;
            this.IdConvenioLaboralTrabajadorCategoria = IdConveniolaboralTrabajadorCategoria;
            this.CerrarNomina = cerrarNomina;
            this.NoResetAntiguedad = NoResetAntiguedad;
            this.DiasPagados = diasRecalculo;


            IniciarVariables(IdNomina, IdConveniolaboralTrabajadorCategoria);




            if (this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "24" || this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("ANTICIPO AGUINALDO") || (this.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES")))
            {

                this.getAguinaldo();
            }


            //debe de borrar datos de isr una vez que borra los datos de una nomina para no contar
            //esta misma información
            setPremioAntiguedadPagados();
            setNominaTrabajadoresPercepcionesDelMes();
            setNominaTrabajadorDeduccionesdelMes();
            setIsrDelMes();

            Nomina_stNominaTrabajadorLista = new List<Nomina_stNominaTrabajador>();

        }

        public void ValidaCuentas()
        {

            var vigentes = this.CatalogoKardexTrabajadoresCuentas.Select(r => r.IdTrabajador).ToArray();


            List<Convenios_stConvenioLaboralTrabajadorCategoria> sincuentas = this.TrabajadoresVigentes.Where(w => !vigentes.Contains(w.Convenios_stConvenioLaboralTrabajador.IdTrabajador)).ToList(); ;

        }

        public static void rollbackReCalculoTrabajador(int IdNomina, int idconveniolaboraltrabajadorcategoria)
        {

            string wheresql = " c.IdNomina=" + IdNomina.ToString();

            if (idconveniolaboraltrabajadorcategoria > 0)
                wheresql = wheresql + " and c.IdConvenioLaboralTrabajadorCategoria=" + idconveniolaboraltrabajadorcategoria.ToString();


            wheresql = " IdNomina=" + IdNomina.ToString();

            wheresql = wheresql + " and IdConvenioLaboralTrabajadorCategoria=" + idconveniolaboraltrabajadorcategoria.ToString();

            bdNovaEntities basedt = new bdNovaEntities();
            var IdTrabajadorEstatus = basedt.Nomina_stNominaTrabajadorEstatus.Where(v => v.EstatusNomina == "NORMAL").FirstOrDefault();
            DapperQuery dp = new DapperQuery("bdNovaEntities");




            dp.connection.Execute(@"update Nomina_stNominaTrabajador  set IdNominaTrabajadorEstatus=" + IdTrabajadorEstatus.IdNominaTrabajadorEstatus + " where" + wheresql, null, null, 0, null);


            dp.Close();

        }


        public bool BorrarNominaDiasEconomicosyPuntualidad()
        {

            bool regresa = false;


            HoraInicioBorrar = DateTime.Now;

            int idn = this.IdNomina;
            int idconveniolaboraltrabajadorcategoria = this.IdConvenioLaboralTrabajadorCategoria;

            string wheresql = " c.IdNomina=" + IdNomina.ToString();
            string wheresqlDiasEcon = " IdNomina=" + IdNomina.ToString();
            string wheresqlinicidencias = "delete c from Nomina_stNominaIncidenciasTrabajadorAplicadas c  where c.IdNomina=" + IdNomina.ToString();

            if (idconveniolaboraltrabajadorcategoria > 0)
            {
                wheresql = wheresql + " and IdConvenioLaboralTrabajadorCategoria=" + idconveniolaboraltrabajadorcategoria.ToString();
                wheresqlDiasEcon = wheresqlDiasEcon + " and IdTrabajador in (SELECT IdTrabajador from Convenios_stConvenioLaboralTrabajadorCategoria v inner join Convenios_stConvenioLaboralTrabajador x on v.IdConvenioLaboralTrabajador=x.IdConvenioLaboralTrabajador where v.IdConvenioLaboralTrabajadorCategoria=" + idconveniolaboraltrabajadorcategoria.ToString()+")";
                wheresqlinicidencias = wheresqlinicidencias + $" and IdIncidenciaTrabajador in (select IdIncidenciaTrabajador from IncidenciaPermiso_stIncidenciaTrabajador where IdConvenioLaboralTrabajadorCategoria={idconveniolaboraltrabajadorcategoria.ToString()}) ";
             
            }


          

                DapperQuery dp = new DapperQuery("bdNovaEntities");



                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {


 

           

                dp.connection.Execute(@"delete from Nomina_PagosDiasEconomicosyPuntualidadAuxiliar  
where " + wheresqlDiasEcon, null, null, 0, null);

                

                    dp.Close();


                

                    scope.Complete();
                    regresa = true;
                }

           



            return regresa;


        }
        public bool BorrarNomina()
        {

            bool regresa = false;


            HoraInicioBorrar = DateTime.Now;

            int idn = this.IdNomina;
            int idconveniolaboraltrabajadorcategoria = this.IdConvenioLaboralTrabajadorCategoria;

            string wheresql = " c.IdNomina=" + IdNomina.ToString();
            string wheresqlDiasEcon = " IdNomina=" + IdNomina.ToString();
            string wheresqlinicidencias = "delete c from Nomina_stNominaIncidenciasTrabajadorAplicadas c  where c.IdNomina=" + IdNomina.ToString();

            if (idconveniolaboraltrabajadorcategoria > 0)
            {
                wheresql = wheresql + " and c.IdConvenioLaboralTrabajadorCategoria=" + idconveniolaboraltrabajadorcategoria.ToString();
                wheresqlinicidencias = wheresqlinicidencias + $" and IdIncidenciaTrabajador in (select IdIncidenciaTrabajador from IncidenciaPermiso_stIncidenciaTrabajador where IdConvenioLaboralTrabajadorCategoria={idconveniolaboraltrabajadorcategoria.ToString()}) ";
            }


            if (this.EsRecalculoPorTrabajador)
            {
                //wheresql = " IdNomina=" + IdNomina.ToString();

                //wheresql = wheresql + " and IdConvenioLaboralTrabajadorCategoria=" + idconveniolaboraltrabajadorcategoria.ToString();

                ////bdNovaEntities basedt = new bdNovaEntities();
                //Nomina_stNominaTrabajadorEstatus IdTrabajadorEstatus;
                //using (var dbContext = new bdNovaEntities())
                //{
                //    dbContext.Database.Connection.Open();
                //      IdTrabajadorEstatus = dbContext.Nomina_stNominaTrabajadorEstatus.Where(v => v.EstatusNomina == "CANCELADO").FirstOrDefault();
                //    dbContext.Database.Connection.Close();
                //}


                //DapperQuery dpC = new DapperQuery("bdNovaEntities");
                //TransactionOptions transactionoptions1 = new TransactionOptions();
                //transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;


                //using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                //{

                //    dpC.connection.Execute(@"update Nomina_stNominaTrabajador  set IdNominaTrabajadorEstatus=" + IdTrabajadorEstatus.IdNominaTrabajadorEstatus + " where" + wheresql, null, null, 0, null);

                //    dpC.connection.Execute(@"update Nomina_stNominaTrabajadorHistorial  set IdNominaTrabajadorEstatus=" + IdTrabajadorEstatus.IdNominaTrabajadorEstatus + ",EstatusNomina='" + IdTrabajadorEstatus.EstatusNomina+ "',IdNominaTrabajadorEstatusGrupo="+ IdTrabajadorEstatus.IdNominaTrabajadorEstatusGrupo + " where" + wheresql, null, null, 0, null);

                //    dpC.Close();


                //    BorradoCompletado = true;

                //    scope.Complete();
                //    regresa = true;


                //}

                regresa = true;
            }
            else
            if (this.EsProyeccion)
            {
                DapperQuery dp = new DapperQuery("bdNovaEntities");

                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {



                    dp.connection.Execute(@"delete a from Percepciones_Proyeccion a
inner join Nomina_stProyeccion b on a.IdProyeccion=b.IdProyeccion
inner join Nomina_stNomina c on c.IdNomina=b.IdNomina
where " + wheresql + " and b.Escerrada=0 ");


                    dp.connection.Execute(@"delete a from Deducciones_Proyeccion a
inner join Nomina_stProyeccion b on a.IdProyeccion=b.IdProyeccion
inner join Nomina_stNomina c on c.IdNomina=b.IdNomina
where " + wheresql + " and b.Escerrada=0 ");

                    dp.connection.Execute(@"delete a from Nomina_stProyeccion a
inner join Nomina_stNomina c on c.IdNomina=a.IdNomina
where " + wheresql + " and a.Escerrada=0 ");


//                    dp.connection.Execute(@"delete from Nomina_PagosDiasEconomicosyPuntualidad  
//where " + wheresqlDiasEcon, null, null, 0, null);


                    dp.Close();
                    scope.Complete();

                    BorradoCompletado = true;

                    regresa = true;
                }
            }
            else
            {


                DapperQuery dp = new DapperQuery("bdNovaEntities");



                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {





                    dp.connection.Execute(@"delete a from Deducciones_stNominaTrabajadorSubDeducciones a
inner join Deducciones_stNominaTrabajadorDeduccion b on a.IdNominaTrabajadorDeduccion=b.IdNominaTrabajadorDeduccion
inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=b.IdNominaTrabajador
--where c.IdNominaTrabajador in 
where" + wheresql, null, null, 0, null);


                    dp.connection.Execute(@"delete a from Deducciones_stNominaTrabajadorDeduccion  a
inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=a.IdNominaTrabajador
where" + wheresql, null, null, 0, null);

                   


                    dp.connection.Execute(@"update IncidenciaPermiso_stIncidenciaTrabajador set EsAplicada=0,IdNominaTrabajador=null
 where IdNominaTrabajador in 
(select IdNominaTrabajador from Nomina_stNominaTrabajador c where " + wheresql + "  ) ", null, null, 0, null);




                    dp.connection.Execute(@"delete a from Creditos_stNominaCreditoTrabajador a
inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=a.IdNominaTrabajador
where" + wheresql, null, null, 0, null);

                    dp.connection.Execute(@"delete a from Creditos_stNominaCreditoTrabajadorNoAplicados a
inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=a.IdNominaTrabajador
where" + wheresql, null, null, 0, null);


                    dp.connection.Execute(@"delete a from Percepciones_stNominaTrabajadorPercepcionesPersonalizadas   a
inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=a.IdNominaTrabajador
where" + wheresql, null, null, 0, null);

                    dp.connection.Execute(@"delete a from Percepciones_stNominaTrabajadorPercepciones   a
inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=a.IdNominaTrabajador
where" + wheresql, null, null, 0, null);

                    dp.connection.Execute(@"delete a from Percepciones_stNominaTrabajadorPercepcionesViaticos   a
inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=a.IdNominaTrabajador
where" + wheresql, null, null, 0, null);



                    dp.connection.Execute(@"delete a from Nomina_stNominaHorariosDocentes   a
inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=a.IdNominaTrabajador
where" + wheresql, null, null, 0, null);





                    dp.connection.Execute(@"delete a from Pensiones_stNominaPensionTrabajador    a
        inner join Nomina_stNominaTrabajador c on c.IdNominaTrabajador=a.IdNominaTrabajador
                        where" + wheresql, null, null, 0, null);

                    dp.connection.Execute(@"delete c from Nomina_stNominaTrabajadorHistorial c where" + wheresql, null, null, 0, null);

                    dp.connection.Execute(@"delete c from Nomina_stNominaTrabajador c where" + wheresql, null, null, 0, null);

                    dp.connection.Execute(wheresqlinicidencias, null, null, 0, null);


                    dp.connection.Execute(@"delete c  from Nomina_IncidenciasSaldosAuxiliar c
where" + wheresql, null, null, 0, null);



                  

                    dp.Close();


                    BorradoCompletado = true;

                    scope.Complete();
                    regresa = true;
                }

            }



            return regresa;


        }

        public void SetIdEstatusReCalculo()
        {
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                IdNominaTrabajadorEstatusRecalculo = basenova.Nomina_stNominaTrabajadorEstatus.AsNoTracking()
                    .Where(x => x.EstatusNomina == "RECALCULO").FirstOrDefault().IdNominaTrabajadorEstatus;
                basenova.Database.Connection.Close();
            }
        }

        private Boolean ExisteQuinquenioPremioEstimuloCalculoPorSolicitud()
        {
            Boolean existe = false;
            var percepcionesQ = this.PlantillaNominaPercepcionesRelacionLaboral.Where(c =>
                   c.IdPlantillaNomina == this.Nomina_stNomina.IdPlantillaNomina
                   && (
                   c.Percepciones_ctPercepcion.Percepcion.Contains("QUINQUENIO")
                   || c.Percepciones_ctPercepcion.Percepcion.Contains("ANTIG")
                   || c.Percepciones_ctPercepcion.Percepcion.Contains("PRIMA VACACIONAL")
                   || c.Percepciones_ctPercepcion.Percepcion.Contains("PUNTUALIDAD")
                   || c.Percepciones_ctPercepcion.Percepcion.Contains("AGUINALDO")
                   )
                   && c.Calcular == true
              ).FirstOrDefault();

            if (percepcionesQ != null)
                existe = true;
            else
            {

                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud)
                    existe = true;
            }

            return existe;
        }



        private async Task LoadAntiguedad()
        {
            //if (this.ExisteQuinquenioPremioEstimuloCalculoPorSolicitud())
            //{

            await Task.Run(() =>
            {
                LogProcesos.IniciarProceso("LoadAntiguedad");
                this.TrabajadorAntiguedad.CalcularFechaIngreso(this.Nomina.FechaInicio);
                this.QuinquenioTrabajadorAntiguedad.CalcularParaQuinquenio = true;
                this.QuinquenioTrabajadorAntiguedad.CalcularFechaIngreso(this.Nomina.FechaTermino);
                LogProcesos.FinalizarProceso("LoadAntiguedad");

            }
            ).ContinueWith((e1) =>
            {
                this.ProcesoAntiguedaCompletado = true;

            });

            //}
            //else
            //    this.ProcesoAntiguedaCompletado = true;

        }


        public void setInformacionGeneralAjustes(string listatrabajadores)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string sql = @"
 select b.*,c.IdCategoria,ff.RestringirMenu,f.Idtrabajador from
             Convenios_stConvenioLaboralTrabajadorCategoria b
            inner
          join Plazas_stDistribucionPlazaCategoria c on c.IdDistribucionPlazaCategoria = b.IdDistribucionPlazaCategoria
          inner
          join Plazas_ctCategoria d on d.IdCategoria = c.IdCategoria
          inner
          join Convenios_stConvenioLaboralTrabajador f on f.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
          inner
          join Kardex_ctTrabajador g on g.IdTrabajador = f.IdTrabajador
        left join vwDatosAspirantesTrabajadores ff on ff.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
          where f.IdTrabajador in(" + listatrabajadores + @") and b.IdConvenioLaboralTrabajadorCategoria not in (
select bb.IdConvenioLaboralTrabajadorCategoria  from Convenios_stConvenioLaboralTrabajadorCategoria bb 
  inner join Plazas_stDistribucionPlazaCategoria cc on cc.IdDistribucionPlazaCategoria = bb.IdDistribucionPlazaCategoria 
inner join Plazas_ctCategoria dd on dd.IdCategoria = cc.IdCategoria 
inner join Convenios_stConvenioLaboralTrabajador ff on ff.IdConvenioLaboralTrabajador = bb.IdConvenioLaboralTrabajador 
inner join Kardex_ctTrabajador gg on gg.IdTrabajador = ff.IdTrabajador 
left join vwDatosAspirantesTrabajadores fff on fff.IdConvenioLaboralTrabajadorCategoria=bb.IdConvenioLaboralTrabajadorCategoria 
  where 
    (bb.FechaInicio=bb.FechaTermino and bb.FechaTermino is not null)
)
          ORDER BY b.FechaInicio desc,b.FechaTermino asc";





            this.Convenios = (List<ConvenioLaboralTrabajadorCategoriaPlazas>)dp.connection.Query<ConvenioLaboralTrabajadorCategoriaPlazas>(sql.ToString());
            

            string dbnameAries = GetDatabaseName("bdAriesEntities");



            string consulta = $@"SELECT  a.IdCicloEscolar,a.IdKardex,SUM(horas) as Horas
    FROM {dbnameAries}.dbo.stHorarioNominaDocente a 
    inner join {dbnameAries}.dbo.ctTipoHoras b on a.IdTipoHoras=b.IdTipoHoras and a.IdModalidadEstudio=b.IdModalidadEstudio 
    inner join {dbnameAries}.dbo.ctDia x on x.IdDia=a.IdDia inner join {dbnameAries}.dbo.ctCicloescolar w on w.IdCicloEscolar=a.IdCicloEscolar 
where      b.Nombre<>'HORAS CLUB' and b.nombre<>'HORAS DE FORTALECIMIENTO' 
group by a.IdCicloEscolar,a.IdKardex";


            HorasDocentesPorCiclo = (List<HorasDocentesPorCiclo>)dp.connection.Query<HorasDocentesPorCiclo>(consulta.ToString());
            dp.Close();

 
        }
        public void setNominasAnteriores(string listatrabajadores)
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query = $@"select 
x.IdTrabajador
,NombreTrabajador = y.Nombre+SPACE(1)+y.ApellidoPaterno+SPACE(1)+y.ApellidoMaterno
,d.SueldoDiario
,d.SalarioDiarioIntegrado
,d.DiasEfectivosLaborados
,TipoConcepto=1
,a.Importe
,y.RFC
,Adscripcion = qq.EstructuraOrganica
,UbicacionFisica = xw.EstructuraOrganica
,Codigo=xy.Clave

,clt.ConvenioLaboralTipo
,zy.RelacionLaboral
,e.FechaInicio FechaInicioNomina
,e.FechaTermino as FechaTerminoNomina
,v.FechaInicio 
,v.FechaTermino 
,z.IdCategoria
,f.Plantilla
,pg.PlantillaGrupo
,e.Año
,g.QuincenaMes
,h.Mes
,d.SueldoNeto
,0 as EsAjuste
,d.HorasSemanaMes
,d.HorasExcedentes
 ,e.IdQuincenaMes
 ,a.IdPlantillaNominaPercepcion
,d.IdConvenioLaboralTrabajadorCategoria
,d.IdNominaTrabajador
from Percepciones_stNominaTrabajadorPercepciones a
inner join Percepciones_stPlantillaNominaPercepciones b on a.IdPlantillaNominaPercepcion=b.IdPlantillaNominaPercepcion
inner join Percepciones_ctPercepcion c on c.IdPercepcion=b.IdPercepcion and c.EsVigente = 1
INNER JOIN Nomina_stNominaTrabajador d on d.IdNominaTrabajador = a.IdNominaTrabajador
inner join Nomina_stNomina e on e.IdNomina = d.IdNomina 
inner join Nomina_ctPlantillaNomina f on f.IdPlantillaNomina = e.IdPlantillaNomina
inner join Nomina_ctPlantillaGrupo pg on pg.IdPlantillaGrupo=f.IdPlantillaGrupo
inner join Nomina_ctTipoNomina xe on xe.IdTipoNomina = e.IdTipoNomina
inner join Catalogos_ctQuincenaMes g on g.IdQuincenaMes = e.IdQuincenaMes
inner join Catalogos_ctMes h on h.IdMes = g.IdMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria v on v.IdConvenioLaboralTrabajadorCategoria = d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador = v.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador x on x.IdTrabajador = w.IdTrabajador
inner join Kardex_ctDatosPersonales y on y.IdKardex = x.IdKardex
inner join Plazas_stDistribucionPlazaCategoria z on z.IdDistribucionPlazaCategoria=v.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria xy on xy.IdCategoria=z.IdCategoria
inner join Convenios_stRelacionConvenioLaboral xz on xz.IdRelacionConvenioLaboral=xy.IdRelacionConvenioLaboral
inner join Catalogos_ctConvenioLaboral zz on zz.IdConvenioLaboral=xz.IdConvenioLaboral
inner join Catalogos_ctConvenioLaboralTipo clt on clt.IdConvenioLaboralTipo=zz.IdConvenioLaboralTipo
inner join Catalogos_ctRelacionLaboral zy on zy.IdRelacionLaboral = xz.IdRelacionLaboral
inner join Catalogos_ctEstructuraOrganica xw on xw.IdEstructuraOrganica = v.IdEstructuraOrganica
inner join Catalogos_ctEstructuraOrganica qq on qq.IdEstructuraOrganica = z.IdEstructuraOrganica
inner join Nomina_stNominaTrabajadorEstatus QB on QB.IdNominaTrabajadorEstatus=d.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=qb.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' and e.Escerrada=1
and Plantilla like '%sueldo%'
and  x.idtrabajador in ({listatrabajadores}) and 
    e.FechaTermino = (
        SELECT MAX(e1.FechaTermino)
        FROM Nomina_stNominaTrabajador d1
		inner join Convenios_stConvenioLaboralTrabajadorCategoria v1 on v1.IdConvenioLaboralTrabajadorCategoria = d1.IdConvenioLaboralTrabajadorCategoria
		inner join Convenios_stConvenioLaboralTrabajador w1 on w1.IdConvenioLaboralTrabajador = v1.IdConvenioLaboralTrabajador
        INNER JOIN Nomina_stNomina e1 ON e1.IdNomina = d1.IdNomina
		inner join Nomina_ctPlantillaNomina f1 on f1.IdPlantillaNomina = e1.IdPlantillaNomina
		inner join Nomina_stNominaTrabajadorEstatus QB1 on QB1.IdNominaTrabajadorEstatus=d1.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn1 on gn1.IdNominaTrabajadorEstatusGrupo=qb1.IdNominaTrabajadorEstatusGrupo
        WHERE w1.IdTrabajador = x.IdTrabajador and e1.Escerrada=1
		and EstatusNominaGrupo ='PARA PAGO' 
and Plantilla like '%sueldo%'
and  w1.idtrabajador in ({listatrabajadores}) 
    )
ORDER BY 
    x.IdTrabajador, e.FechaTermino DESC";


            NominasAnterioresPagadas = (List<NominasAnterioresPagadas>)dp.connection.Query<NominasAnterioresPagadas>(query);


            query = @"SELECT *
  FROM vwLicenciasTrabajadores
  where (tipoIncidenciaPermiso='PERMISO' and (incidencia not like '%CONFIANZA%'  AND incidencia not like '%CAMBIO DE NOMINA%') )
  AND (YEAR(FechaTerminoIncidencia)=" + this.Nomina_stNomina.Año + "  or YEAR(FechaInicioIncidencia)=" + this.Nomina_stNomina.Año + " ) order by idtrabajador, FechaInicioIncidencia ";


            this.LicenciasTrabajadores = (List<vwLicenciasTrabajadores>)dp.connection.Query<vwLicenciasTrabajadores>(query.ToString());





        }
        public void setDocentesVigentesParaNomina()
        {

            if (Nomina_stNomina != null)
            {
                var idsDeseados = TrabajadoresVigentes.Select(a => a.IdConvenioLaboralTrabajadorCategoria).ToList();
                var idstrabDeseados = TrabajadoresVigentes.Select(a => a.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToList();
                // Convertir la lista de IDs en una cadena separada por comas
                string idsSeparadosPorComas = string.Join(",", idstrabDeseados);
                if (Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla != null)
                {
                    if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("DOCENTE"))
                        if (Nomina_stNomina.Nomina_ctPlantillaNomina.UsaHorariosDocentesParaCalculo)
                        {





                            NominaHorariosDocentesDetallePorFecha = NominaHorariosDocentesDetallePorFecha.Where(x =>
  x.IdConvenioLaboralTrabajadorCategoria.HasValue &&
  idsDeseados.Contains(x.IdConvenioLaboralTrabajadorCategoria.Value))
  .ToList();

                            NominaHorariosDocentesDetalle = NominaHorariosDocentesDetalle.Where(x =>
x.IdConvenioLaboralTrabajadorCategoria.HasValue &&
idsDeseados.Contains(x.IdConvenioLaboralTrabajadorCategoria.Value))
.ToList();
                      



                        }
                }

                setNominasAnteriores(idsSeparadosPorComas);
                setInformacionGeneralAjustes(idsSeparadosPorComas);
            }
             
               
             

        }

        public void setSoloDocentesHorasExtrOrdinarias()
        {
            if (Nomina_stNomina != null)
                if (Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla!=null)
                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("HORAS EXTRAORDINARIAS"))
                        if (Nomina_stNomina.Nomina_ctPlantillaNomina.UsaHorariosDocentesParaCalculo)
                        {
                    var ids = NominaHorariosDocentesDetallePorFecha.Select(z => z.IdKardex).ToList();
                    var ids2 = NominaHorariosDocentesDetalle.Select(z => z.IdKardex).ToList();
                    ids.AddRange(ids2);

                    TrabajadoresVigentes = TrabajadoresVigentes.Where(a => ids.Contains(a.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex)).ToList();
                }
                
        }

        public void setTrabajadoresNominasExtrOrdinarias()
        {
            if (Nomina_stNomina != null)
                if (this.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina== "EXTRAORDINARIA")
                {
                    
                   
                    var ids = this.getPercepcionesPersonalizadas().Select(z => z.IdConvenioLaboralTrabajadorCategoria).ToList();
                    var ids2 = this.getDeduccionesPersonalizadas().Select(z => z.IdConvenioLaboralTrabajadorCategoria).ToList();
                    ids.AddRange(ids2);

                    TrabajadoresVigentes = TrabajadoresVigentes.Where(a => ids.Contains(a.IdConvenioLaboralTrabajadorCategoria)).ToList();
                }

        }

        private async Task LoadHorarios()
        {

            await Task.Run(() =>
            {
                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.UsaHorariosDocentesParaCalculo)
                    setHorariosDocentes();
                else
                    this.ProcesoHorariosCompletado = true;
            }
            ).ContinueWith((e1) =>
            {
                this.ProcesoHorariosCompletado = true;
            });


        }

        private async Task LoadHorariosAjustes()
        {

            await Task.Run(() =>
            {
                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.UsaHorariosDocentesParaCalculo)
                    setHorariosDocentesAjustes();
                else
                    this.ProcesoHorariosCompletadoAjustes = true;
            }
            ).ContinueWith((e1) =>
            {
                this.ProcesoHorariosCompletadoAjustes = true;
            });


        }

        private async Task LoadSetDiasNotrabajados()
        {

            await Task.Run(() =>
            {
                setDiasNoTrabajadosPorTrabajador();
            }
            ).ContinueWith((e1) =>
            {
                this.ProcesoDiasTrabajadosCompletado = true;
                OrdenaTrabajadoresPorDiaslaborados();
            });


        }

        private void OrdenaTrabajadoresPorDiaslaborados()
            {
                // Clase para almacenar IdConvenio y Días Trabajados


            // Crear un diccionario para acceso rápido a los días trabajados
            var diasTrabajadosDict = this.ListaVariablesNominaTrabajador
                .Where(a => a.Concepto == "DIASLABORADOS" && a.Importe > 0)
                .GroupBy(z => z.IdTrabajador) // Agrupar solo por IdTrabajador
                .ToDictionary(g => g.Key, g => new DiasTrabajadosInfo
                {
                    IdConvenioLaboralTrabajadorCategoria = g.First().IdConvenioLaboralTrabajadorCategoria, // O ajustar según necesidad
                    Importe = g.Sum(x => x.Importe) // Sumar los importes
                });

        // Ordenar la lista original de trabajadores
        this.TrabajadoresVigentes.Sort((a, b) =>
            {
                // Obtener el ID del trabajador
                var idTrabajadorA = a.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
        var idTrabajadorB = b.Convenios_stConvenioLaboralTrabajador.IdTrabajador;

        // Comparar los IdTrabajador
        int idComparison = idTrabajadorA.CompareTo(idTrabajadorB);
                if (idComparison != 0)
                {
                    return idComparison; // Si son diferentes, ordenar por IdTrabajador
                }

    // Obtener los días trabajados usando el diccionario
    var diasAInfo = diasTrabajadosDict.TryGetValue(idTrabajadorA, out var diasA) ? diasA : new DiasTrabajadosInfo { Importe = 0 };
    var diasBInfo = diasTrabajadosDict.TryGetValue(idTrabajadorB, out var diasB) ? diasB : new DiasTrabajadosInfo { Importe = 0 };

                // Comparar los días trabajados (de mayor a menor)
                return diasBInfo.Importe.CompareTo(diasAInfo.Importe);
            });


 

}

        private async Task AsyncBorrarNomina()
        {

            await Task.Run(() =>
            {
                BorrarNomina();
            }
            ).ContinueWith((e1) =>
            {
                this.BorradoCompletado = true;
            });


        }
        public void IniciarVariables(int IdNomina, int IdConveniolaboralTrabajadorCategoria = 0)
        {


            this.IdNomina = IdNomina;
           this.setNomina();
            setPagosDiasEconomicosyPuntualidadAñoAnterior();


            this.setPeriodoNomina();
            this.getJornadasLaborales();

            setCostos();
            setSubsidioAlEmpleo();
            getIncidenciasTrabajadores();
            setIncidenciaSaldos();
            this.setPercepciones(Nomina_stNomina.IdPlantillaNomina);
            this.setPercepcionesPorRelacionLaboral(Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.IdRelacionConvenioLaboral);
            this.setDeduccionesPorRelacionLaboral(Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.IdRelacionConvenioLaboral);

            this.setPercepcionesCalendarizadas(Nomina_stNomina.IdPlantillaNomina, Nomina.IdMesGeneracion, Nomina.FechaInicio.Day);

            setSolicitudesPartesProporcionales();
            
            Task[] tasks = new Task[5];

            

            var t = LoadAntiguedad();

          
            
         
            tasks.SetValue(t, 0);

            //setpercepcionesparaBase();

            setCiclosEscolares();


            setLicenciasPrimaVacaional();
            setLicenciasIncapacidadesVigentes();

   
            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral.Contains("DOCENTE"))
                setSalariosDiariosDocentes();
           
            SetIdEstatusReCalculo();
            setDeduccionesExcluidas();
            setTrabajadoresQuinquenioConfianza();
            setTrabajadoresConPrestacionesDeGastoAdministrativo();

          

            this.setParametrosConvenioLaboral(Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.IdRelacionConvenioLaboral);
            this.setPlantillaNominaDeducciones(Nomina_stNomina.IdPlantillaNomina);

            this.setCatalogoConvenioLaboral();

            this.setNominasBimestreAnteriorPagadas(Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.IdRelacionConvenioLaboral);

            getTrabajadoresRelacionConvenioLaboral(Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.IdRelacionConvenioLaboral);
            //
            if (IdConveniolaboralTrabajadorCategoria > 0)
            {
                EsCalculoUnSoloTrabajador = true;
                setTrabajador(IdConveniolaboralTrabajadorCategoria);

                int idkardex = TrabajadorSelccionado.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;

            }

            BorrarNominaDiasEconomicosyPuntualidad();


            var e = LoadHorarios();
            tasks.SetValue(e, 1); 
            
            var bbe = LoadHorariosAjustes();
            tasks.SetValue(bbe, 2);
          
            this.setPercepcionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, Nomina_stNomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
           // this.setDeduccionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, Nomina_stNomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
            this.getPercepcionesConcedidas();

            setTrabajadoresPrimerPago();

            var w = AsyncBorrarNomina();
            var z = LoadSetDiasNotrabajados();

            tasks.SetValue(z, 3);

           // setDiasNoTrabajadosPorTrabajador();
        
           //OrdenaTrabajadoresPorDiaslaborados();



            var ee = setTrabajadoresConErrorAsync();
            tasks.SetValue(ee, 4);

            this.setPeriodoSalarioDiarioIntegradoTrabajador(Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.IdConvenioLaboral);
            this.setSalarioMinimoDF();
            this.setUMA();
            this.setUMI();
            this.setCesantiaYVejez();
            this.setCatalogoTipoCreditos();
            this.setISR();
            this.setCuotasObreroPatronales();
            //this.setSubsidioEmpleo();
            this.setQuincenaMes();
            this.setCatalogoKardexTrabajadoresCuentas();

            setSoloPercepcionesPersonalizadas();
            this.setBajasEnQuincena();

            setApoyosEstudios();

            setTrabajadoresConPrimaDominical();
            setTrabajadoresConDiasDescanso();
            setPrestacionesAdicionales();
            setPuntaulidadYAsistencia();
            setDiasEconomicosDisfrtuados();
            setAnticipoAguinaldo();
            setUtilesEscolares();

            setSdiPercepcionesVariablesdelBimestre();

            

           while (this.BorradoCompletado == false || this.ProcesoDiasTrabajadosCompletado == false || this.ProcesoHorariosCompletado == false || this.ProcesoHorariosCompletadoAjustes == false  || this.ProcesoAntiguedaCompletado == false)
           //while (this.BorradoCompletado == false || this.ProcesoHorariosCompletado == false || this.ProcesoAntiguedaCompletado == false)
            {

                Thread.Sleep(100);
            }//e

            setDocentesVigentesParaNomina();
            setSoloDocentesHorasExtrOrdinarias();
            setTrabajadoresNominasExtrOrdinarias();
        }

        public List<VariablesNominaTrabajador> ListaVariablesNominaTrabajador = new List<VariablesNominaTrabajador>();
        public decimal diasaño = 0;
        public List<Nomina_stNominaTrabajador> ListaNominasTrabajadores = new List<Nomina_stNominaTrabajador>();



        public List<PercepcionesNominaTrabajador> ListaPercepcionesTrabajadores = new List<PercepcionesNominaTrabajador>();
        public List<PercepcionesNominaTrabajador> ListaPercepcionesTrabajadoresODES = new List<PercepcionesNominaTrabajador>();
        public List<PercepcionesNominaTrabajador> ListaPercepcionesTrabajadoresCCTIMSS = new List<PercepcionesNominaTrabajador>();
       // public List<PercepcionesNominaTrabajador> ListaPercepcionesTrabajadoresCCT = new List<PercepcionesNominaTrabajador>();
        public List<PercepcionesNominaTrabajador> ListaPercepcionesTrabajadoresViaticos = new List<PercepcionesNominaTrabajador>();
        public List<PercepcionesTrabajadorMes> ListaPercepcionesTrabajadoresViaticosDelMes = new List<PercepcionesTrabajadorMes>();


        public List<PercepcionesNominaTrabajador> ListaPercepcionesTrabajadoresRetroActivo = new List<PercepcionesNominaTrabajador>();

        public List<DeduccionesNominaTrabajador> ListaDeduccionesTrabajadores = new List<DeduccionesNominaTrabajador>();
        public List<DeduccionesNominaTrabajador> ListaDeduccionesTrabajadoresRetroActivo = new List<DeduccionesNominaTrabajador>();

        public List<CreditosTrabajador> ListaCreditosTrabajador = new List<CreditosTrabajador>();
        public List<CreditosTrabajador> ListaCreditosTrabajadorNoAplicados = new List<CreditosTrabajador>();

        public List<Nomina_IncidenciasSaldos> Nomina_IncidenciasSaldosBd;
        public List<Nomina_IncidenciasSaldos> ListaNomina_IncidenciasSaldos = new List<Nomina_IncidenciasSaldos>();
        public List<Nomina_IncidenciasSaldosAuxiliar> ListaNomina_IncidenciasSaldosAuxiliar = new List<Nomina_IncidenciasSaldosAuxiliar>();
        public List<Nomina_IncidenciasSaldos> ListaNomina_IncidenciasSaldosActualizar = new List<Nomina_IncidenciasSaldos>();

        public List<Creditos_stCreditoTrabajador> ListaCreditosTrabajadorPagosIndebidos = new List<Creditos_stCreditoTrabajador>();
        public List<PensionesTrabajador> ListaPensionesTrabajador = new List<PensionesTrabajador>();
        public List<PensionesTrabajador> ListaPensionesTrabajadorRetroActivo = new List<PensionesTrabajador>();


        public List<SubDeduccionesNominaTrabajador> ListaNominaSubDeduccionesTrabajadores = new List<SubDeduccionesNominaTrabajador>();



        public List<Creditos_stNominaCreditoTrabajador> ListaNominaCreditosTrabajadores = new List<Creditos_stNominaCreditoTrabajador>();

        public List<Percepciones_stNominaTrabajadorPercepciones> ListaNominaPercepcionesTrabajador = new List<Percepciones_stNominaTrabajadorPercepciones>();


        public List<FaltasTrabajador> ListaFaltasTrabajador = new List<FaltasTrabajador>();
        public List<Deducciones_stNominaTrabajadorDeduccion> ListaNominaDeduccionesTrabajador = new List<Deducciones_stNominaTrabajadorDeduccion>();
        public List<Deducciones_stNominaTrabajadorSubDeducciones> ListaNominaSubDeduccionesTrabajador = new List<Deducciones_stNominaTrabajadorSubDeducciones>();


        public List<Nomina_stNominaTrabajador> ListaNominasAnteriormentePagadasTrabajadores = new List<Nomina_stNominaTrabajador>();
        public List<Nomina_stNominaTrabajador> ListaNominasAnteriormentePagadasTrabajador = new List<Nomina_stNominaTrabajador>();


        public List<Percepciones_stNominaTrabajadorPercepcionesPersonalizadas> ListaPercepcionesPersonalizadasTrabajador = new List<Percepciones_stNominaTrabajadorPercepcionesPersonalizadas>();

        public List<IncidenciaPermiso_stIncidenciaTrabajador> ListaIncidenciaTrabajador = new List<IncidenciaPermiso_stIncidenciaTrabajador>();

        public List<Incidencias_stNominaTrabajadorIncidenciaDeduccion> ListaIncidenciaDeduccionTrabajador = new List<Incidencias_stNominaTrabajadorIncidenciaDeduccion>();

        public List<PercepcionesTrabajadorMes> stNominaTrabajadorPercepcionesdelMes = new List<PercepcionesTrabajadorMes>();
        public List<PercepcionesTrabajadorMes> stNominaTrabajadorPercepcionesdelMesCCT = new List<PercepcionesTrabajadorMes>();
        public List<BaseGravableTrabajadorMes> stNominaTrabajadorBasesGravabelesdelMes = new List<BaseGravableTrabajadorMes>();

        public List<PercepcionesTrabajadorMes> stNominaTrabajadorPercepcionesSubsidiodelMes = new List<PercepcionesTrabajadorMes>();

        public Boolean ExisteNominasCerradasEntodoElMes = false;

        public List<DeduccionesTrabajadorMes> stNominaTrabajadorDeduccionesdelMes = new List<DeduccionesTrabajadorMes>();
        public List<DeduccionesTrabajadorMes> stNominaTrabajadorISRdelMes = new List<DeduccionesTrabajadorMes>();

        public List<Creditos_stNominaCreditoTrabajador> ListaCreditosDescontadosOtrasNominas = new List<Creditos_stNominaCreditoTrabajador>();

        public short DiasNomina = 0;
        public short DiasNominaCalendario = 0;
        public short DiasPagados = 0;
        public short DiasRecalculos = 0;
        public int UniversoTrabajadores = 0;
        public int TrabajadoresError = 0;
        private DateTime FechaInicialBimestreNomina;
        private DateTime FechaFinalBimestreNomina;
        private TimeSpan Intervalo;



        public List<Catalogos_ctQuincenaMes> CatalogoQuincenaMes = null;

        public List<Deducciones_ctSubDeduccionValores> CuotasObreroPatronales = null;
        public List<Catalogos_ctCesantiaYVejez> Catalogos_ctCesantiaYVejez = null;

        public List<Kardex_stTrabajadorCuentas> CatalogoKardexTrabajadoresCuentas = null;
        public List<Kardex_stTrabajadorCuentas> CatalogoKardexTrabajadorCuentas;

        public List<Nomina_stNomina> Nominas = null;
        public List<Convenios_stConvenioLaboralTrabajadorCategoria> TrabajadoresVigentes = new List<Convenios_stConvenioLaboralTrabajadorCategoria>() ;
        public List<Kardex_stDatosFamiliares> TrabajadoresVigentesKardex_stDatosFamiliares = null;
        public List<Kardex_ctDatosPersonales> TrabajadoresVigentesKardex_ctDatosPersonales = null;
        


        public List<Convenios_stConvenioLaboralTrabajadorCategoria> ConveniosTrabajadoresTodos = null;
        public List<Convenios_stConvenioLaboralTrabajadorCategoria> TrabajadoresVigentesPorTerminoComision = new List<Convenios_stConvenioLaboralTrabajadorCategoria>();
        public List<Convenios_stConvenioLaboralTrabajadorCategoria> TrabajadoresVigentesPorBaja = new List<Convenios_stConvenioLaboralTrabajadorCategoria>();
        public List<Convenios_stConvenioLaboralTrabajadorCategoria> TrabajadoresVigentesConContinuidaComision = new List<Convenios_stConvenioLaboralTrabajadorCategoria>();
        public List<Percepciones_stPlantillaNominaPercepciones> PlantillasNominasPercepciones = null;
        public List<Deducciones_stPlantillaNominaDeducciones> PlantillasNominasDeducciones = null;

        public List<Deducciones_stPlantillaNominaDeducciones> PlantillaNominaDeducciones;
        public List<Deducciones_stPlantillaNominaDeducciones> _PlantillaNominaDeducciones;


        public List<Percepciones_stPercepcionesPersonalizadas> PercepcionesPersonalizadas = null;
        public List<Percepciones_stPercepcionesConcedidas> PercepcionesConcedidas = null;
        public List<Percepciones_stPercepcionesConcedidas> PercepcionConcedida;

        public List<Percepciones_stPercepcionesCalendarizadas> PercepcionesCalendarizadas = null;
        public List<Plazas_ctCostoHoraJornada> CostosHorasJornadas = null;
        public List<IncidenciaPermiso_stIncidenciaTrabajador> IncidenciasTrabajadores = null;
        public List<IncidenciaPermiso_stIncidenciaTrabajador> IncidenciasTrabajadoresCCT = null;

        public List<IncidenciaPermiso_stIncidenciaTrabajador> BajasPorRenunciasEnlaQuincena = null;

        public List<Catalogos_ctParametrosRelacionLaboral> ParametrosRelacionesLaborales = null;
        public List<Configuracion_ctISR> ISR = null;
        public List<Configuracion_ctSubsidioEmpleo> SubsidioEmpleo = null;

        public List<Catalogos_ctInstitucionFinanciera> InstitucionFinanciera = null;
        public List<Catalogos_ctJornadaLaboral> JornadasLaborales = null;
        public List<Catalogos_ctFormaDePago> FormaDePago = null;



        public List<Creditos_stCreditoTrabajador> ParametrosCreditosTrabajadores = null;
        public List<Pensiones_stPensionesTrabajador> PensionesTrabajadores = null;

        public List<Convenios_stConvenioLaboralTrabajador> ConvenioLaboralTrabajadores;
        public List<Convenios_stConvenioLaboralTrabajador> ConvenioLaboralTrabajador;

        public Nomina_stNomina Nomina;
        public List<Catalogos_ctPeriodoNomina> PeriodoNomina = null;

        public Catalogos_ctSalarioMinimo SalarioMinimoDF = null;
        public Catalogos_ctUnidadMedidaActualizacion ctUMA = null;
        public Catalogos_ctUnidadMixtaInfonavit ctUMI = null;
        public List<Configuracion_ctCesantiayVejez> Configuracion_ctCesantiayVejez = null;

        public List<Catalogos_ctUnidadMixtaInfonavit> ctUMIHistorial = null;

        public List<Catalogos_ctPeriodoSalarioDiarioIntegrado> PeriodoSalarioDiarioIntegrado = null;
        public Convenios_stConvenioLaboralTrabajadorCategoria TrabajadorSelccionado;



        public List<Percepciones_stPlantillaNominaPercepciones> PlantillaNominaPercepciones;
        public List<Percepciones_stPlantillaNominaPercepciones> PlantillaNominaPercepcionesRelacionLaboral;

        public List<Deducciones_stPlantillaNominaDeducciones> PlantillaNominaDeduccionesRelacionLaboral;


        public List<Percepciones_stPercepcionesPersonalizadas> PercepcionPersonalizada;
        private List<Deducciones_stDeduccionesPersonalizadas> DeduccionPersonalizada;
        public List<Deducciones_stDeduccionesPersonalizadas> DeduccionPersonalizadaTrabajadores;
        public List<Percepciones_stPercepcionesCalendarizadas> PercepcionCalendarizada;
        public Plazas_ctCostoHoraJornada CostoHoraJornada;


        public List<Nomina_PrestacionesAdicionales> PrestacionesAdicionales = new List<Nomina_PrestacionesAdicionales>();


        public List<IncidenciaPermiso_stIncidenciaTrabajador> IncidenciaTrabajador;
        public List<IncidenciaPermiso_stIncidenciaTrabajador> IncidenciaTrabajadorCCT;
        public List<IncidenciaPermiso_stIncidenciaTrabajador> DevolucionesFaltasTrabajador= new List<IncidenciaPermiso_stIncidenciaTrabajador>();
        public List<IncidenciaPermiso_stIncidenciaTrabajador> DevolucionesFaltasDocentesAplicadas= new List<IncidenciaPermiso_stIncidenciaTrabajador>();
        public List<Deducciones_stNominaTrabajadorDeduccion> DevolucionesFaltasDocentes;
        public List<IncidenciaPermiso_stIncidenciaTrabajador> DevolucionesFaltasTrabajadorTodos;





        public Catalogos_ctParametrosRelacionLaboral ParametrosRelacionLaboral;
        public Catalogos_ctJornadaLaboral JornadaLaboral;
        public List<Creditos_stCreditoTrabajador> CreditosTrabajador;
        public List<Convenios_stConvenioLaboralTrabajadorCategoria> NominaTrabajadoresConvenioLaboral = null;

        public List<Pensiones_stPensionesTrabajador> PensionesTrabajador;

        public List<Percepciones_stNominaTrabajadorPercepciones> NominaTrabajadorPercepciones;
        public List<Percepciones_stNominaTrabajadorPercepciones> NominaTrabajadoresPercepciones = null;

       // public bdNovaEntities db = new bdNovaEntities();

        public Catalogos_ctPeriodoSalarioDiarioIntegrado PeriodoSalarioDiarioIntegradoTrabajador;

        private static Nomina_stNominaTrabajador Instancia;

        public Nomina_stNominaTrabajador trabajadornomina;

        public List<Creditos_stNominaCreditoTrabajador> CreditosDelTrabajador = new List<Creditos_stNominaCreditoTrabajador>();
        public List<Creditos_stNominaCreditoTrabajadorNoAplicados> CreditosDelTrabajadorNoAplicados = new List<Creditos_stNominaCreditoTrabajadorNoAplicados>();
        public List<Creditos_stCreditoTrabajador> CreditosDelTrabajadorSaldos = new List<Creditos_stCreditoTrabajador>();
        public List<Percepciones_stNominaTrabajadorPercepciones> PercepcionesDelTrabajador = new List<Percepciones_stNominaTrabajadorPercepciones>();
        public List<Nomina_stNominaHorariosDocentes> HorariosDelTrabajador = new List<Nomina_stNominaHorariosDocentes>();
        public List<Percepciones_stNominaTrabajadorPercepciones> ViaticosDelTrabajador = new List<Percepciones_stNominaTrabajadorPercepciones>();
        public List<Deducciones_stNominaTrabajadorDeduccion> DeduccionesDelTrabajador = new List<Deducciones_stNominaTrabajadorDeduccion>();
        public List<Deducciones_stNominaTrabajadorSubDeducciones> SubDeduccionesDelTrabajador = new List<Deducciones_stNominaTrabajadorSubDeducciones>();
        public List<Pensiones_stNominaPensionTrabajador> PensionesDelTrabajador = new List<Pensiones_stNominaPensionTrabajador>();


        public bool ExisteNominaSueldoValidarIsr = false;

        public bool HorarioVigente = false;
        public bool HorarioAnterior = false;
        public bool HorarioComplemento = false;

        public List<Plazas_ctCostoHoraJornada> Plazas_ctCostoHoraJornadaTodos = new List<Plazas_ctCostoHoraJornada>();
        public List<Plazas_ctCostoHoraJornada> Plazas_ctCostoHoraJornadaVigentes = new List<Plazas_ctCostoHoraJornada>();
        public List<Nomina_ConfiguracionSubsidioTrabajador> Nomina_ConfiguracionSubsidioTrabajador = new List<Nomina_ConfiguracionSubsidioTrabajador>();

        public List<Deducciones_stPlantillaNominaDeducciones> DeduccionesExcluidas = new List<Deducciones_stPlantillaNominaDeducciones>();

        public List<PercepcionesRetroActivoTrabajador> ListaPercepcionesRetroActivoTrabajador = new List<PercepcionesRetroActivoTrabajador>();
        public List<DeduccionesRetroActivoTrabajador> ListaDeduccionesRetroActivoTrabajador = new List<DeduccionesRetroActivoTrabajador>();
        public List<Percepciones_stPlantillaNominaPercepcionesRetroCategoria> PercepcionesRetroActivoPorCategoria = new List<Percepciones_stPlantillaNominaPercepcionesRetroCategoria>();

        public List<AguinaldoTrabajadores> ListaAguinaldoTrabajadores = new List<AguinaldoTrabajadores>();
        public List<TrabajadorNominaParaAguinaldo> TrabajadorNominaParaAguinaldo = new List<TrabajadorNominaParaAguinaldo>();
        public List<TrabajadorNominaParaAguinaldo> TrabajadorNominaParaAguinaldoGastoAdmivo = new List<TrabajadorNominaParaAguinaldo>();

        public List<Nomina_stNominaTrabajador> ListaPremioAntiguedadPagados = new List<Nomina_stNominaTrabajador>();
        public List<Nomina_stNominaTrabajador> ListaEstimuloAntiguedadPagados = new List<Nomina_stNominaTrabajador>();

        public List<AntiguedadTrabajador> ListaPremioAntiguedadTrabajadores = new List<AntiguedadTrabajador>();

        public List<vwDatosAspirantesTrabajadoresHistorial> HistoriaPersonalContrato = new List<vwDatosAspirantesTrabajadoresHistorial>();
        public List<vwDatosAspirantesTrabajadoresHistorial> HistoriaPersonal = new List<vwDatosAspirantesTrabajadoresHistorial>();



      

        private void setNomina()
        {


            Nomina = this.getNominas().Where(n => n.IdNomina == this.IdNomina).SingleOrDefault();
            if (Nomina == null)
                throw new ApplicationException("No existen nóminas configuradas o la nómina está cerrada");
            if (Nomina.EsCerrada && EsRecalculoPorTrabajador == false)
                throw new ApplicationException("No existen nóminas configuradas o la nómina está cerrada");

            diasaño = 365M;

            Nomina_stNomina = Nomina;

            if (DateTime.IsLeapYear(this.Nomina_stNomina.Año))
            {
                diasaño = 366M;
            }

            this.DiasNomina = (short)((Nomina_stNomina.FechaTermino - Nomina_stNomina.FechaInicio).TotalDays + 1);
            DiasNominaCalendario = this.DiasNomina;

            if (DiasNomina == 30 || DiasNomina == 31 || DiasNomina == 29 || DiasNomina == 28)
                DiasNomina = 30;
            else
                DiasNomina = 15;


        }

        // Cargar todas las nóminas independientemente de la que se trate

        private List<Nomina_stNomina> getNominas()
        {


            if (Nominas == null)
            {
                using (var dbContext = new bdNovaEntities())
                {
                    dbContext.Database.Connection.Open();
                    Nominas = dbContext.Nomina_stNomina.AsNoTracking()
                        .Include(a => a.Nomina_ctPlantillaNomina)
                        .Include(a => a.Nomina_ctTipoNomina)
                        .Include(a => a.Nomina_ctPlantillaNomina.Percepciones_stPlantillaNominaPercepciones)
                    .Include(a => a.Nomina_ctPlantillaNomina.Nomina_ctPlantillaGrupo)
                    .Include(a => a.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones)
                    .Include(a => a.Catalogos_ctQuincenaMes)
                    .Include(a => a.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral)                    
                    .Include(a => a.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral)
                    .Include(a => a.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral)
                    .Include(a => a.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina)
                    .Include(a=> a.Nomina_ctTipoCalculo).ToList();
                    dbContext.Database.Connection.Close();
                }

            }

            return Nominas;
        }



        //Obtener el período nómina 

        private List<Catalogos_ctPeriodoNomina> setPeriodoNomina()
        {

            try
            {
                if (PeriodoNomina == null)
                    using (var basenova = new bdNovaEntities())
                    {
                        basenova.Database.Connection.Open();
                        PeriodoNomina = basenova.Catalogos_ctPeriodoNomina
                            .AsNoTracking()
                            .Where(p => p.IdPeriodoNomina == Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina)
                            .ToList();
                        basenova.Database.Connection.Close();
                    }
                return PeriodoNomina;
            }
            catch (Exception e)
            {
                Exception d = ExceptionExtensions.GetOriginalException(e);
                throw new HttpException((int)System.Net.HttpStatusCode.Forbidden, "No existen cuenta bancaria o forma de pago asignado al trabajador");

            }

        }


        /// Kardex Cuentas
        /// 

        
    private void setSoloPercepcionesPersonalizadas()
        {
            if (this.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina == "EXTRAORDINARIA")
            {
                var idespersonalizados = PercepcionesPersonalizadas.Select(z => z.IdConvenioLaboralTrabajadorCategoria).ToList();
                TrabajadoresVigentes = TrabajadoresVigentes.Where(a => idespersonalizados.Contains(a.IdConvenioLaboralTrabajadorCategoria)).ToList();
            }
        }

            private void setBajasEnQuincena()
        {

            // bajas por renuncias

            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                BajasPorRenunciasEnlaQuincena = basenova.IncidenciaPermiso_stIncidenciaTrabajador
                    .AsNoTracking().Where(z =>
              z.Catalogos_ctTipoIncidencia.Incidencia == "BAJA POR RENUNCIA"
              && z.FechaInicio >= this.Nomina_stNomina.FechaInicio && z.FechaInicio <= this.Nomina_stNomina.FechaTermino).ToList();
                basenova.Database.Connection.Close();
            }


              DapperQuery dp = new DapperQuery("bdNovaEntities");

                string querybajas = $@"SELECT b.*
                                  FROM[IncidenciaPermiso_stIncidenciaTrabajador] a
                                  inner join Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
                                  inner join Convenios_stConvenioLaboralTrabajador c on c.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
                                inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador = c.IdConvenioLaboralTrabajador
                                inner join Plazas_stDistribucionPlazaCategoria p on p.IdDistribucionPlazaCategoria = b.IdDistribucionPlazaCategoria
                                inner join Plazas_ctCategoria ct on ct.IdCategoria = p.IdCategoria
                                  inner join Kardex_ctTrabajador d on d.IdTrabajador = c.IdTrabajador
                                  inner join[Catalogos_ctTipoIncidencia] i on i.IdTipoIncidencia = a.IdTipoIncidencia
                                  where(a.FechaInicio <'{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' )
                                and b.EsPrimerCalculo=1
            and ct.IdRelacionConvenioLaboral={ this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral}
                and(i.Incidencia like '%renun%' or Incidencia like '%baja%') order by b.fechatermino desc";
                var bajasenlaqna = (List<Convenios_stConvenioLaboralTrabajadorCategoria>)dp.connection.Query<Convenios_stConvenioLaboralTrabajadorCategoria>(querybajas);

                string idsSeparadosPorComas = string.Join(",", bajasenlaqna
    .Select(x => x.IdConvenioLaboralTrabajadorCategoria.ToString())
    .Distinct());

            var idsBalasEnLaQna = bajasenlaqna.Select(a => a.IdConvenioLaboralTrabajadorCategoria).ToList();

            using (var dbContext = new bdNovaEntities())
                {
                    dbContext.Database.Connection.Open();



                List<Convenios_stConvenioLaboralTrabajadorCategoria> agregar = dbContext.Convenios_stConvenioLaboralTrabajadorCategoria
    .AsNoTracking()
    .Where(x => idsBalasEnLaQna.Contains(x.IdConvenioLaboralTrabajadorCategoria))
    .OrderByDescending(z => z.FechaInicio)
    .Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral)
    .Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral)
    .Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral)
    .Include(u => u.Convenios_stConvenioLaboralTrabajador)
    .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador)
    .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales)
    .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Kardex_stDatosFamiliares)
    .Include(x => x.Plazas_stDistribucionPlazaCategoria.Catalogos_ctEstructuraOrganica)
    .Include(x => x.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria)

    .Include(x => x.Plazas_stDistribucionPlazaCategoria.Catalogos_ctEstructuraOrganica)
    .ToList();

                    TrabajadoresVigentes.AddRange(agregar);
                    dbContext.Database.Connection.Close();
                }

            foreach (var item in bajasenlaqna)
            {
                var nuevo= new VariablesNominaTrabajador
                {
                    IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria,
                    Importe = (int)(item.FechaTermino.Value.AddDays(1) - item.FechaInicio).TotalDays,
                    Concepto = "DIASLABORADOS"
                    
                };
                this.ListaVariablesNominaTrabajador.Add(nuevo);
                var nuevo2 = new VariablesNominaTrabajador
                {
                    IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria,
                    Importe = (int)(item.FechaTermino.Value.AddDays(1) - item.FechaInicio).TotalDays,
                    Concepto = "ContratoSinPagoSoloAjuste"

                };
                this.ListaVariablesNominaTrabajador.Add(nuevo2);

                var nuevo3 = new VariablesNominaTrabajador
                {
                    IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria,
                    Importe = (int)(item.FechaTermino.Value.AddDays(1) - item.FechaInicio).TotalDays,
                    Concepto = "TerminoContratoDiasPagados"

                };
                this.ListaVariablesNominaTrabajador.Add(nuevo3);
            }

            

        }

        private void setCatalogoKardexTrabajadoresCuentas()
        {


            CatalogoKardexTrabajadoresCuentas = this.getCatalogoKardexTrabajadoresCuentas().Where(c => c.EsVigente == true).ToList();

        }
        private List<Kardex_stTrabajadorCuentas> getCatalogoKardexTrabajadoresCuentas()
        {
            if (CatalogoKardexTrabajadoresCuentas == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    CatalogoKardexTrabajadoresCuentas = basenova.Kardex_stTrabajadorCuentas.AsNoTracking().ToList();
                    basenova.Database.Connection.Close();
                }

            return CatalogoKardexTrabajadoresCuentas;
        }

        //Lista de convenios

        public List<Catalogos_ctConvenioLaboral> CatalogoConveniosLaborales = null;
        public Catalogos_ctConvenioLaboral CatalogoConvenioLaboral;


        private void setCatalogoConvenioLaboral()
        {
            CatalogoConvenioLaboral = this.getCatalogoConveniosLaborales().FirstOrDefault();

            if (CatalogoConvenioLaboral == null)
                throw new ApplicationException("No existen convenios laborales dados de alta");
        }
        private List<Catalogos_ctConvenioLaboral> getCatalogoConveniosLaborales()
        {
            if (CatalogoConveniosLaborales == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    CatalogoConveniosLaborales = basenova.Catalogos_ctConvenioLaboral.AsNoTracking().ToList();
                    basenova.Database.Connection.Close();
                }

            return CatalogoConveniosLaborales;
        }
        //ConveniosLaboralTrabajador

        private void setConvenioLaboralTrabajador(int IdTrabajador)
        {
            ConvenioLaboralTrabajador = this.getConvenioLaboralTrabajadores().Where(c => c.IdTrabajador == IdTrabajador).ToList();
            if (ConvenioLaboralTrabajador == null)
                throw new ApplicationException("No existen convenios laborales dados de alta para este trabajador");
        }


        private void setTrabajadoresPrimerPago()
        {

            DapperQuery dpc = new DapperQuery("bdNovaEntities");
            string sql = @"insert into Nomina_TrabajadoresPrimerPagoControl 
select w.IdConvenioLaboralTrabajadorCategoria ," + this.Nomina_stNomina.IdQuincenaMes + " as idqna," + this.Nomina_stNomina.Año + @" as año  from Convenios_stConvenioLaboralTrabajadorCategoria q 
inner join vwDatosAspirantesTrabajadores w  on w.IdConvenioLaboralTrabajadorCategoria=q.IdConvenioLaboralTrabajadorCategoria
where w.RestringirMenu is null and EsPrimerCalculo=1
 and w.EstatusTrabajador<>'PROXIMAMENTE' and w.IdRelacionConvenioLaboral=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + @"
and w.IdConvenioLaboralTrabajadorCategoria  not in ( select a.IdConvenioLaboralTrabajadorCategoria from Nomina_TrabajadoresPrimerPagoControl a
inner join vwDatosAspirantesTrabajadores f on f.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
where f.EstatusTrabajador<>'PROXIMAMENTE' and f.RestringirMenu is null and f.IdRelacionConvenioLaboral=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + ")";

            var trg = dpc.connection.Execute(sql);

            string sql2 = "select * from  Nomina_TrabajadoresPrimerPagoControl where IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + " and año=" + this.Nomina_stNomina.Año;
            ListaTrabajadoresPrimerPagoControl = (List<Nomina_TrabajadoresPrimerPagoControl>)dpc.connection.Query<Nomina_TrabajadoresPrimerPagoControl>(sql2);
            dpc.Close();

        }
        private void setPrestacionesAdicionales()
        {
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                PrestacionesAdicionales = basenova.Nomina_PrestacionesAdicionales.AsNoTracking()
                    .Where(c =>
                  c.IdNominaTrabajador == null)
                    .Include(z=> z.Percepciones_ctPercepcion)
                    .ToList();
                basenova.Database.Connection.Close();
            }

          

        }


        private List<Convenios_stConvenioLaboralTrabajador> getConvenioLaboralTrabajadores()
        {
            if (ConvenioLaboralTrabajadores == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    ConvenioLaboralTrabajadores = basenova.Convenios_stConvenioLaboralTrabajador.ToList();
                    basenova.Database.Connection.Close();
                }
            return ConvenioLaboralTrabajadores;
        }



        //Trabajadores

        private void setTrabajador(int IdConvenioLaboralTrabajadorCategoria)
        {
            if (EsRecalculoPorTrabajador)
            {
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    TrabajadorSelccionado = basenova.Convenios_stConvenioLaboralTrabajadorCategoria
                        .AsNoTracking()
                        .Where(s => s.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria)
                        .Include(a=> a.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador)
                        .Include(a=> a.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria)
                        .FirstOrDefault();
                    basenova.Database.Connection.Close();
                }

            }
            else
                TrabajadorSelccionado = this.TrabajadoresVigentes.Where(t => t.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).SingleOrDefault();

            if (TrabajadorSelccionado == null)
                throw new ApplicationException("No se encuentra el trabajador para el convenio laboral categoría seleccionado y para la nomina" + this.Nomina_stNomina.FechaInicio.ToShortDateString() + " al " + this.Nomina_stNomina.FechaInicio.ToShortDateString());

            this.TrabajadoresVigentes.Clear();
            this.TrabajadoresVigentes.Add(TrabajadorSelccionado);

        }


        public decimal ImporteQuinquenioTrabajadorHomologados(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria)
        {
            decimal Importe = 0;
            //var existe = NominaTrabajador.TrabajadoresQuinquenioConfianza.Where(g => g.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            //if (existe != null)
            //{
            int idtrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador;


            //    decimal SueldoQuincenal = NominaTrabajador.ListaPercepcionesTrabajadores.Where(lp => lp.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && lp.IdPlantillaNominaPercepcion == NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().IdPlantillaNominaPercepcion).SingleOrDefault().Importe
            //, Importe = 0;


            Plazas_ctCostoHoraJornada costos = this.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
            var Sueldodiario = this.Truncate(costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora, 2);
            decimal SueldoQuincenal = Sueldodiario * 15;


            //SingletonAntiguedad antiguedad = SingletonAntiguedad.Instance;

            //AntiguedadLaboralQuinquenioTrabajador quinquenio = antiguedad.getAntiguedad(idtrabajador);




            //var quinquenioNomina = DateTimeSpan.CompareDates(quinquenio.FechaInicioQuinquenio, NominaTrabajador.Nomina.FechaTermino.AddDays(1));

            var quinquenioNomina = this.QuinquenioTrabajadorAntiguedad.getAntiguedadPorTrabajador(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);


            if (quinquenioNomina.Years >= this.ParametrosRelacionLaboral.AñosQuinquenio)
            {
                if (quinquenioNomina.Years >= 21)
                    Importe = SueldoQuincenal * (0.025M * quinquenioNomina.Years);
                else
                    Importe = SueldoQuincenal * (Convert.ToDecimal(this.ParametrosRelacionLaboral.PorcentajeQuinquenio) * quinquenioNomina.Years);
            }

            // }

            return Importe;
        }

        private void getTrabajadoresRelacionConvenioLaboral(int idrcl)
        {


            var fi = this.Nomina_stNomina.FechaInicio;

            
            

            // cuando las nominas no son de 15 dias se debe de establecer la vigencia
            //de los trabajadores solo a 15 dias

            if (this.Nomina_stNomina.FechaInicio.Month != this.Nomina_stNomina.FechaTermino.Month)
            {

                if (this.Nomina_stNomina.FechaTermino.Day == 15)
                    fi = new DateTime(this.Nomina_stNomina.FechaTermino.Year, this.Nomina_stNomina.FechaTermino.Month, 1);
                else
                    fi = new DateTime(this.Nomina_stNomina.FechaTermino.Year, this.Nomina_stNomina.FechaTermino.Month, 16);
            }

            var ft = this.Nomina_stNomina.FechaTermino;

            DapperQuery dp = new DapperQuery("bdNovaEntities");

           string querycontratos = @"select * from vwDatosAspirantesTrabajadoresHistorial";

            HistoriaPersonal = (List<vwDatosAspirantesTrabajadoresHistorial>)dp.connection.Query<vwDatosAspirantesTrabajadoresHistorial>(querycontratos);


            //            string query = @"select *  from vwDatosAspirantesTrabajadores
            //                   where IdTrabajador is not null and EstatusTrabajador<>'ASPIRANTE' ";
            //            LicenciasVigentesYProximasTrabajadores = (List<vwDatosAspirantesTrabajadores>)dp.connection.Query<vwDatosAspirantesTrabajadores>(query.ToString());


            //            query = @"select IdConvenioLaboralTrabajadorCategoria from vwDatosAspirantesTrabajadores
            //where EstatusTrabajador<>'PROXIMAMENTE' and RestringirMenu is not null and (fechatermino>'" + ft.ToString("yyyyMMdd") + "' or fechatermino is null) ";
            //            var licenciasvigentes = (List<Convenios_stConvenioLaboralTrabajadorCategoria>)dp.connection.Query<Convenios_stConvenioLaboralTrabajadorCategoria>(query.ToString());


            //            string querylic = $@" SELECT *
            //FROM vwLicenciasTrabajadores
            //WHERE fechaterminoincidencia >= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND fechaterminoincidencia <= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'
            // and (TIPOINCIDENCIAPERMISO='PERMISO' OR TIPOINCIDENCIAPERMISO='COMISIÓN')";

            //            List<vwLicenciasTrabajadores> terminosdelicencias = (List<vwLicenciasTrabajadores>)dp.connection.Query<vwLicenciasTrabajadores>(querylic);

            //            string quitainciosdeqns = $@"select * from vwLicenciasTrabajadores
            //    where  fechainicioincidencia > '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' and   
            //    fechainicioincidencia<= '{ this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'  and Incidencia like  '%LICENCIA SIN GOCE DE SUELDO%' ";
            //            List<vwLicenciasTrabajadores> licenciasinicnaenestaqna = (List<vwLicenciasTrabajadores>)dp.connection.Query<vwLicenciasTrabajadores>(quitainciosdeqns);


            //            string queryliccontinuacion = $@"select * from vwLicenciasTrabajadores
            //     WHERE (TIPOINCIDENCIAPERMISO='PERMISO' OR TIPOINCIDENCIAPERMISO='COMISIÓN')
            //and (
            //(FechaInicioIncidencia < '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}' AND fechaterminoincidencia > '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}')
            //    OR (FechaInicioIncidencia <= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND fechaterminoincidencia > '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND fechaterminoincidencia > '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}')
            //    OR (FechaInicioIncidencia <= '{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' AND fechaterminoincidencia >= '{this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}')
            //	) and DATEDIFF(day,  cast('{this.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}' as date),FechaInicioIncidencia)  <=0 ";
            //            List<vwLicenciasTrabajadores> conntinuaciondelicencias = (List<vwLicenciasTrabajadores>)dp.connection.Query<vwLicenciasTrabajadores>(queryliccontinuacion);




            //            conntinuaciondelicencias = conntinuaciondelicencias.Where(a => !licenciasinicnaenestaqna.Select(q => q.IdConvenioLaboralTrabajadorCategoria).Contains(a.IdConvenioLaboralTrabajadorCategoria)).ToList();

            //            string querycontratos = @"select * from vwDatosAspirantesTrabajadoresHistorial
            //                    where RelacionConvenioLaboral = 'ADMINISTRATIVO-CONTRATO'
            //                    order by IdTrabajador,FechaTermino desc";

            //            this.HistoriaPersonalContrato = (List<vwDatosAspirantesTrabajadoresHistorial>)dp.connection.Query<vwDatosAspirantesTrabajadoresHistorial>(querycontratos);

            //              querycontratos = @"select * from vwDatosAspirantesTrabajadoresHistorial";

            //            HistoriaPersonal = (List<vwDatosAspirantesTrabajadoresHistorial>)dp.connection.Query<vwDatosAspirantesTrabajadoresHistorial>(querycontratos);

            //            var queryg = @"select IdConvenioLaboralTrabajadorCategoria from vwDatosAspirantesTrabajadores
            //where (EstatusTrabajador<>'PROXIMAMENTE' and RestringirMenu is not null and (fechatermino>'" + ft.ToString("yyyyMMdd") + "' or fechatermino is null) )" +
            //"or  (EstatusTrabajador='PROXIMAMENTE' and RestringirMenu is null and   FechaInicio>='"+ fi.ToString("yyyyMMdd") + "')";

            //            List<Int32> Lista = (List<Int32>)dp.connection.Query<Int32>(queryg);

            //            //no quita las licencias qeu terminan en la qna para aguinaldo , y deja solo el contrato activo
            //            //if (this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes != "24" && !(this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AGUINALDO")))
            //            if (!this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AGUINALDO") && !(this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("ANTICIPO")))
            //                foreach (var ele in Lista.ToList())
            //                {
            //                    bool continua = false;
            //                    if (conntinuaciondelicencias.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ele).FirstOrDefault() != null)
            //                        continua = true;

            //                    if (licenciasvigentes.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ele).FirstOrDefault() != null && continua == false)
            //                        Lista.Remove(ele);

            //                    var contratoproximo = LicenciasVigentesYProximasTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ele
            //                    && a.EstatusTrabajador == "PROXIMAMENTE" && a.FechaInicio >= this.Nomina_stNomina.FechaInicio
            //                    && a.FechaInicio <= this.Nomina_stNomina.FechaTermino ).FirstOrDefault();
            //                    if (contratoproximo!=null)
            //                        Lista.Remove(ele);

            //                }


            try
            {


                using (var dbContext = new bdNovaEntities())
                {
                    dbContext.Database.Connection.Open();

                    // Hacer operaciones específicas de bajo nivel con la conexión aquí

                    Plazas_stDistribucionPlazaCategoria = dbContext.Plazas_stDistribucionPlazaCategoria.AsNoTracking().Include(z => z.Plazas_ctCategoria).ToList();

                    this.Plazas_ctCategoria = dbContext.Plazas_ctCategoria.AsNoTracking().ToList();

                    TrabajadoresVigentes = dbContext.Convenios_stConvenioLaboralTrabajadorCategoria
    .AsNoTracking()
    .Where(x => 
                x.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdRelacionConvenioLaboral == idrcl &&
                (x.FechaTermino >= fi && x.FechaInicio <= ft ||
                (x.FechaInicio <= ft && x.FechaTermino == null) ||
                (x.FechaInicioPago >= fi && x.EsPrimerCalculo == true)))
    .OrderByDescending(z => z.FechaInicio)
    .Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral)
    .Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral)
    .Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral)
    .Include(u => u.Convenios_stConvenioLaboralTrabajador)
    .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador)
    .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales)
    .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Kardex_stDatosFamiliares)
    .Include(x => x.Plazas_stDistribucionPlazaCategoria.Catalogos_ctEstructuraOrganica)
    .Include(x => x.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria)

    .Include(x => x.Plazas_stDistribucionPlazaCategoria.Catalogos_ctEstructuraOrganica)
    .ToList();

//                    var tv = TrabajadoresVigentes
//.OrderBy(q => q.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex)
//.Select(s => s.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex)
//.ToList();  // Convertir a lista directamente

//                    TrabajadoresVigentesKardex_stDatosFamiliares = dbContext.Kardex_stDatosFamiliares
//                        .AsNoTracking()
//                        .Where(s => tv.Contains(s.IdKardex))
//                        .Include(a => a.Kardex_ctParentesco)
//                        .ToList();

//                    TrabajadoresVigentesKardex_ctDatosPersonales = dbContext.Kardex_ctDatosPersonales
//                        .AsNoTracking()
//                        .ToList();

//                    ConveniosTrabajadoresTodos = dbContext.Convenios_stConvenioLaboralTrabajadorCategoria
//                        .AsNoTracking()
//                        .Include(u => u.Catalogos_ctEstructuraOrganica)
//                        .Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral)
//                        .Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral)
//        .Include(u => u.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral)
//        .Include(u => u.Convenios_stConvenioLaboralTrabajador)
//        .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador)
//        .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales)
//        .Include(x => x.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Kardex_stDatosFamiliares)
//        .Include(x => x.Plazas_stDistribucionPlazaCategoria)
//                .Include(x => x.Plazas_stDistribucionPlazaCategoria.Catalogos_ctEstructuraOrganica)
//        .Include(x => x.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria)
//        .Include(x => x.Plazas_stDistribucionPlazaCategoria.Catalogos_ctEstructuraOrganica)

//                        .ToList();

                    dbContext.Database.Connection.Close();
                }

            }
            catch (Exception ex)
            {
                throw new ApplicationException(ex.Message);

            }



        }
        
        public async Task  setTrabajadoresConErrorAsync()
        {
            await Task.Run(() => this.setTrabajadoresConError());
        }
            protected void setTrabajadoresConError()
        {

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query = @"select a1.IdNominaTrabajador from 
Deducciones_stNominaTrabajadorDeduccion a1
inner join Deducciones_stPlantillaNominaDeducciones b1 on a1.IdPlantillaNominaDeduccion=b1.IdPlantillaNominaDeduccion
inner join Deducciones_ctDeduccion c1 on c1.IdDeduccion=b1.IdDeduccion
inner join Nomina_stNominaTrabajador d1 on d1.IdNominaTrabajador=a1.IdNominaTrabajador
where Deduccion in ('MATERNIDAD','RIESGO DE TRABAJO') and d1.IdNomina=" + Nomina.IdNomina;


            var idconlicencias = (List<long>)dp.connection.Query<long>(query);
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                TrabajadoresError = basenova.Nomina_stNominaTrabajador.AsNoTracking()
                    .Where(x => x.IdNomina == Nomina.IdNomina
                  && !idconlicencias.Contains(x.IdNominaTrabajador)
            ).Count(z => z.SueldoNeto <= 0);
                basenova.Database.Connection.Close();
            }

          

            query = @"select count(aa.IdConvenioLaboralTrabajadorCategoria) as total from Nomina_stNominaTrabajador aa 
inner join Convenios_stConvenioLaboralTrabajadorCategoria dd on aa.IdConvenioLaboralTrabajadorCategoria=dd.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador ee on dd.IdConvenioLaboralTrabajador=ee.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador ff on ee.IdTrabajador = ff.IdTrabajador

left join (
select IdTrabajador,AVG(SueldoNeto)*2 SueldoNetoMaximo from (
select a.IdNomina,f.IdTrabajador,MAX( a.SueldoNeto) SueldoNeto,ROW_NUMBER() OVER(PARTITION by f.IdTrabajador ORDER BY   a.IdNomina desc ) AS Nnomina
from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.IdNomina = b.IdNomina
inner join Nomina_ctPlantillaNomina tt on tt.IdPlantillaNomina=b.IdPlantillaNomina
inner join Nomina_ctTipoNomina c on b.IdTipoNomina=c.IdTipoNomina
inner join Catalogos_ctQuincenaMes h on b.IdQuincenaMes = h.IdQuincenaMes
inner join Catalogos_ctMes i on h.IdMes = i.IdMes
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on a.IdConvenioLaboralTrabajadorCategoria=d.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador e on d.IdConvenioLaboralTrabajador=e.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador f on e.IdTrabajador = f.IdTrabajador
inner join Kardex_ctDatosPersonales g on f.IdKardex = g.IdKardex
where  tt.Plantilla like '%SUELDO%'
and Año=" + (this.Nomina_stNomina.FechaInicio.Year) + @" group by f.IdTrabajador,a.IdNomina
) as q 
where q.Nnomina<6 
group by IdTrabajador) as tt
on tt.IdTrabajador=ff.IdTrabajador
where aa.IdNomina=" + Nomina.IdNomina + " and aa.SueldoNeto> tt.SueldoNetoMaximo";



            var sueldosaltos = dp.connection.ExecuteScalar<int>(query);
            TrabajadoresError = TrabajadoresError + sueldosaltos;




         

        }
        public void getuniversoTrabajadores()
        {
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                UniversoTrabajadores = basenova.Convenios_stConvenioLaboralTrabajadorCategoria
                    .AsNoTracking().Where(x => x.Catalogos_ctEstructuraOrganica.IdModalidadEstudio == 0 && x.FechaTermino >= Nomina.FechaInicio && x.FechaInicio <= Nomina.FechaTermino || (x.FechaInicio <= Nomina.FechaTermino && x.FechaTermino == null)).Count();
                basenova.Database.Connection.Close();

            }



            }

        //JornadaLaboral
        public void setJornadaLaboral(int IdJornadaLaboral)
        {
            JornadaLaboral = this.getJornadasLaborales().Where(x => x.IdJornadaLaboral == IdJornadaLaboral).SingleOrDefault();
            if (JornadaLaboral == null)
                throw new ApplicationException("No hay jornadas laborales dadas de alta");

        }
        private List<Catalogos_ctJornadaLaboral> getJornadasLaborales()
        {
            if (JornadasLaborales == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    JornadasLaborales = basenova.Catalogos_ctJornadaLaboral.AsNoTracking().ToList();
                    basenova.Database.Connection.Close();
                }
            return JornadasLaborales;
        }

        private void setTrabajadoresQuinquenioConfianza()
        {
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                TrabajadoresQuinquenioConfianza = basenova.Nomina_stQuinquenioConfianza.AsNoTracking().ToList();
                basenova.Database.Connection.Close();
            }

        }

        private void setTrabajadoresConPrestacionesDeGastoAdministrativo()
        {
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                TrabajadoresConPercepcionesCongasto = basenova.Percepciones_stPercepcionesConcedidas.AsNoTracking().Where(v => v.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").ToList();
                basenova.Database.Connection.Close();
            }

        }
        // Percepciones

        private void setPercepcionesPorRelacionLaboral(short IdRelacionConvenioLaboral)
        {
            if ((this.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES")))
                PlantillaNominaPercepcionesRelacionLaboral = this.getPlantillaNominaPercepciones().Where(p => p.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == IdRelacionConvenioLaboral).ToList();
            else
                PlantillaNominaPercepcionesRelacionLaboral = this.getPlantillaNominaPercepciones().Where(p => p.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == IdRelacionConvenioLaboral
                && !p.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES")
                ).ToList();

            if (PlantillaNominaPercepcionesRelacionLaboral.Count == 0)
                throw new ApplicationException("Error de proceso, posibles causas: No hay percepciones asignadas a la plantilla-por relación laboral vigente");

        }

        private void setDeduccionesPorRelacionLaboral(short IdRelacionConvenioLaboral)
        {
            PlantillaNominaDeduccionesRelacionLaboral = this.getPlantillaNominaDeducciones().Where(p => p.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == IdRelacionConvenioLaboral
            && !p.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES")
            ).ToList();
            if (PlantillaNominaDeduccionesRelacionLaboral.Count == 0)
                throw new ApplicationException("Error de proceso, posibles causas: No hay percepciones asignadas a la plantilla-por relación laboral vigente");

        }

        private void setPercepciones(short IdPlantillaNomina)
        {
            PlantillaNominaPercepciones = this.getPlantillaNominaPercepciones().Where(p => p.IdPlantillaNomina == IdPlantillaNomina).ToList();
            if (PlantillaNominaPercepciones.Count == 0)
                throw new ApplicationException("Error de proceso, posibles causas: No hay percepciones asignadas a la plantilla, la plantilla-nómina no está cerrada o la plantilla-nómina no es vigente");

        }

        private List<Percepciones_stPlantillaNominaPercepciones> getPlantillaNominaPercepciones()
        {
            if (PlantillasNominasPercepciones == null)
            {
                using (var dbContext = new bdNovaEntities())
                {
                    dbContext.Database.Connection.Open();
                    PlantillasNominasPercepciones = dbContext.Percepciones_stPlantillaNominaPercepciones.AsNoTracking().Include(a => a.Nomina_ctPlantillaNomina).Include(z => z.Percepciones_ctPercepcion)
                   .Include(z => z.Percepciones_ctPercepcion.Percepciones_ctPercepcionPeriodo)
                    .ToList();
                    dbContext.Database.Connection.Close();
                }
            }
            return PlantillasNominasPercepciones;
        }

        //Percepciones Personalizadas

        public void setPercepcionesPersonalizadas(int IdConvenioLaboralTrabajadorCategoria, int IdPeriodoNomina)
        {
            PercepcionPersonalizada = this.getPercepcionesPersonalizadas().Where(p => p.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();


        }


        private List<Percepciones_stPercepcionesPersonalizadas> getPercepcionesPersonalizadas()
        {
            DateTime FechaActual = this.Nomina_stNomina.FechaInicio;
            DateTime ft = this.Nomina_stNomina.FechaTermino;
            if (PercepcionesPersonalizadas == null)
            {
                using (var dbContext = new bdNovaEntities())
                {
                    dbContext.Database.Connection.Open();
                    PercepcionesPersonalizadas = dbContext.Percepciones_stPercepcionesPersonalizadas.AsNoTracking()
                        .Where(p => 
                        (p.FechaInicioPercepcion <= FechaActual && p.FechaTermino == null)
                               || (p.FechaInicioPercepcion <= FechaActual && p.FechaTermino >= this.Nomina_stNomina.FechaTermino)
                                  || (p.FechaInicioPercepcion >= FechaActual && p.FechaTermino >= ft))
                                  .Include(q => q.Percepciones_ctPercepcion)
                        .Include(a => a.Catalogos_ctPeriodoNomina)
                        .Include(a => a.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                               .ToList();

                    dbContext.Database.Connection.Close();
                }
            }
         
           
            return PercepcionesPersonalizadas;
        }


        //public void setDeduccionesPersonalizadas(int IdConvenioLaboralTrabajadorCategoria, int IdPeriodoNomina)
        //{

          
        //  return this.getDeduccionesPersonalizadas().Where(p => p.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList());


        //}

        public List<Deducciones_stDeduccionesPersonalizadas> getDeduccionesPersonalizadas()
        {
            DateTime FechaActual = this.Nomina_stNomina.FechaInicio;
            
            if (DeduccionPersonalizada== null)
            {
                using (var dbContext = new bdNovaEntities())
                {
                    dbContext.Database.Connection.Open();

                    DeduccionPersonalizada= dbContext.Deducciones_stDeduccionesPersonalizadas
                        .AsNoTracking()
                        .Where(p =>
                    (p.FechaInicioDeduccion >= FechaActual && p.FechaTermino == null)
                    || (p.FechaInicioDeduccion <= FechaActual && p.FechaTermino == null)
                    || (p.FechaInicioDeduccion >= FechaActual && p.FechaTermino >= this.Nomina_stNomina.FechaTermino)
                    || (p.FechaInicioDeduccion <= FechaActual && p.FechaTermino >= this.Nomina_stNomina.FechaTermino)
                    ).Include(s=> s.Deducciones_ctDeduccion)
                    .Include(s=> s.Catalogos_ctPeriodoNomina)
                        .ToList();
                    dbContext.Database.Connection.Close();
                }
                }

            return DeduccionPersonalizada;
        }


        private List<Percepciones_stPercepcionesConcedidas> getPercepcionesConcedidas()
        {
            DateTime FechaActual = this.Nomina_stNomina.FechaInicio;
            if (PercepcionesConcedidas==null)
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                PercepcionesConcedidas = basenova.Percepciones_stPercepcionesConcedidas.AsNoTracking()
                    .Where(p => (p.FechaInicio <= this.Nomina_stNomina.FechaInicio && p.FechaTermino == null) || (p.FechaInicio <= this.Nomina_stNomina.FechaInicio && p.FechaTermino >= this.Nomina_stNomina.FechaTermino))
                    .Include(q=> q.Percepciones_ctPercepcion)
                    .ToList();
                basenova.Database.Connection.Close();
            }
            return PercepcionesConcedidas;
        }

        //Percepciones Calendarizadas

        private void setPercepcionesCalendarizadas(int IdPlantillaNomina, int IdMes, int Dia)
        {
            PercepcionCalendarizada = this.getPercepcionesCalendarizadas().Where(pc => pc.IdPlantillaNomina == IdPlantillaNomina && pc.IdMes == IdMes && pc.Dia == Dia).ToList();

        }
        private List<Percepciones_stPercepcionesCalendarizadas> getPercepcionesCalendarizadas()
        {
            if (PercepcionesCalendarizadas == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    PercepcionesCalendarizadas = basenova.Percepciones_stPercepcionesCalendarizadas.AsNoTracking().ToList();
                    basenova.Database.Connection.Close();
                }
            return PercepcionesCalendarizadas;
        }

        //Deducciones

        private void setPlantillaNominaDeducciones(short IdPlantillaNomina)
        {

            PlantillaNominaDeducciones = this.getPlantillaNominaDeducciones().Where(p => p.IdPlantillaNomina == IdPlantillaNomina).ToList();



        }

        private List<Deducciones_stPlantillaNominaDeducciones> getPlantillaNominaDeducciones()
        {
            if (PlantillasNominasDeducciones == null)
                using (var dbContext = new bdNovaEntities())
                {
                    dbContext.Database.Connection.Open();

                    PlantillasNominasDeducciones = dbContext.Deducciones_stPlantillaNominaDeducciones.AsNoTracking()
                        .Include(q=> q.Nomina_ctPlantillaNomina)
                        .Include(q=> q.Deducciones_ctDeduccion)
                        .ToList();
                    dbContext.Database.Connection.Close();
                }
            return PlantillasNominasDeducciones;
        }

        //Costo Hora Jornada

        public void setCostoHoraJornada(short IdCategoria)
        {
            DateTime FechaActual = System.DateTime.Now;
            try
            {

                CostoHoraJornada = this.getCostoHoraJornada().Where(c => c.IdCategoria == IdCategoria && c.FechaInicio >= Nomina_stNomina.FechaInicio && Nomina_stNomina.FechaTermino <= c.FechaTermino).SingleOrDefault();
                if (CostoHoraJornada == null)
                    throw new Exception("xx");


            }
            catch (Exception)
            {

                throw new ApplicationException("No hay costos de hora jornada configradas en el sistema");
            }
        }



        private List<Plazas_ctCostoHoraJornada> getCostoHoraJornada()
        {
            if (CostosHorasJornadas == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    CostosHorasJornadas = basenova.Plazas_ctCostoHoraJornada.AsNoTracking().ToList();
                    basenova.Database.Connection.Close();
                }
            return CostosHorasJornadas;
        }

        //Incidencias

        public bool ExisteSaldoIncidencias(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, string Incidencia)
        {
            bool saldo = false;
            Nomina_IncidenciasSaldos saldoIncidencia;
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                  saldoIncidencia = basenova.Nomina_IncidenciasSaldos.AsNoTracking().Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                       && s.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia == Incidencia).OrderByDescending(s => s.Nomina_stNomina.FechaTermino).FirstOrDefault();
                basenova.Database.Connection.Close();
            }
            if (saldoIncidencia != null)
            {
                saldo = true;
            }

            return saldo;
        }
        public void setSaldosIncidencias(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, long IdIncidenciaTrabajador, string Incidencia, decimal diferencia)
        {
            Nomina_IncidenciasSaldos saldoIncidencia;
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                  saldoIncidencia = basenova.Nomina_IncidenciasSaldos.AsNoTracking().Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                       && s.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia == Incidencia).OrderByDescending(s => s.Nomina_stNomina.FechaTermino).FirstOrDefault();
                basenova.Database.Connection.Close();
            }
            if (saldoIncidencia != null)
            {

                saldoIncidencia.Saldo = saldoIncidencia.Saldo + diferencia;

                VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                vnt.Concepto = "INCIDENCIA_SALDO_UPDATE";
                vnt.IdIncidenciaTrabajador = IdIncidenciaTrabajador;
                vnt.Importe = saldoIncidencia.Saldo;
                this.ListaVariablesNominaTrabajador.Add(vnt);

            }
            else

            {


                VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                vnt.Concepto = "INCIDENCIA_SALDO_INSERT";
                vnt.IdIncidenciaTrabajador = IdIncidenciaTrabajador;
                vnt.Importe = diferencia;
                this.ListaVariablesNominaTrabajador.Add(vnt);

            }


        }
        public void setMaternidadTrabajador(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria)
        {
            if (this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "MATERNIDAD").FirstOrDefault() != null)
            {
                TrabajadorTerminaGuarderiaQuincenaActual = false;
                TrabajadorConIncapacipdadActiva = false;
                TrabajadorTotalPercepcionesGuarderiaOrdinarias = 0;

                var tieneMaternidad = this.IncidenciaTrabajador.Where
                     (i => i.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                         && i.EsAplicada == false
                         && i.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR MATERNIDAD"
                            ).OrderBy(j => j.FechaInicio).FirstOrDefault();
                long id = 0;

                bool tienesaldo = false;

                bool ActualizarSaldo = false;

                decimal saldo = 0;
                int diassaldo = 0;

                if (tieneMaternidad != null)
                {
                    id = tieneMaternidad.IdIncidenciaTrabajador;
                    Nomina_IncidenciasSaldos saldoMaternidad;
                    using (var basenova = new bdNovaEntities())
                    {
                        basenova.Database.Connection.Open();
                         saldoMaternidad = basenova.Nomina_IncidenciasSaldos.AsNoTracking()
                            .Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                     && s.IdIncidenciaTrabajador == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).OrderByDescending(s => s.Nomina_stNomina.FechaTermino).FirstOrDefault();
                        basenova.Database.Connection.Close();
                    }
                    if (saldoMaternidad != null)
                    {

                        if (saldoMaternidad.Saldo == 0)
                            tienesaldo = false;
                        else
                        {
                            saldo = saldoMaternidad.Saldo;
                            ActualizarSaldo = true;
                            tienesaldo = true;
                        }
                    }


                }

                bool terminaDepagarMaternidad = false;
                Decimal totalpercepciones = 0;




                if (tieneMaternidad == null)
                    totalpercepciones = this.Suma(this.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).ToList());

                else
                {


                    totalpercepciones = this.Suma(this.ListaPercepcionesTrabajadores.Where(v =>

                    v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList());

                    if (tienesaldo)
                    {

                        if (saldo < totalpercepciones)
                        {

                            terminaDepagarMaternidad = true;
                            DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                            isr.EsImprimibleRecibo = true;
                            isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            isr.IdNomina = this.Nomina_stNomina.IdNomina;
                            isr.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "MATERNIDAD").FirstOrDefault().IdPlantillaNominaDeduccion;
                            isr.Importe = saldo;

                            this.ListaDeduccionesTrabajadores.Add(isr);

                        }
                        else
                        {
                            DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                            isr.EsImprimibleRecibo = true;
                            isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            isr.IdNomina = this.Nomina_stNomina.IdNomina;
                            isr.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "MATERNIDAD").FirstOrDefault().IdPlantillaNominaDeduccion;
                            isr.Importe = totalpercepciones;

                            this.ListaDeduccionesTrabajadores.Add(isr);
                        }





                        Plazas_ctCostoHoraJornada costos = this.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                        VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                        vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt.Concepto = "INCIDENCIA_SALDO_UPDATE";
                        vnt.IdIncidenciaTrabajador = tieneMaternidad.IdIncidenciaTrabajador;
                        vnt.Importe = saldo;
                        this.ListaVariablesNominaTrabajador.Add(vnt);
                    }
                    else
                    {
                        DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                        isr.EsImprimibleRecibo = true;
                        isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        isr.IdNomina = this.Nomina_stNomina.IdNomina;
                        isr.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "MATERNIDAD").FirstOrDefault().IdPlantillaNominaDeduccion;
                        isr.Importe = totalpercepciones;

                        this.ListaDeduccionesTrabajadores.Add(isr);

                        VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                        vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt.Concepto = "INCIDENCIA_SALDO_INSERT";
                        vnt.IdIncidenciaTrabajador = tieneMaternidad.IdIncidenciaTrabajador;
                        vnt.Importe = totalpercepciones;
                        this.ListaVariablesNominaTrabajador.Add(vnt);
                    }

                }

                if (tieneMaternidad != null && terminaDepagarMaternidad)
                {

                    TrabajadorTerminaGuarderiaQuincenaActual = true;
                }

                if (tieneMaternidad != null && terminaDepagarMaternidad == false)
                {

                    TrabajadorConIncapacipdadActiva = true;



                }
            }
        }


        public void setValidaTerminoEnfermedadGeneral(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria)
        {

            Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();
            String qna = this.Nomina.Catalogos_ctQuincenaMes.QuincenaMes;
            string año = this.Nomina.FechaInicio.Year.ToString();
            //actualiza cálculo de INCAPACIDAD POR ENFERMEDAD GENERAL para la quincena calculada de todos los trabajadores
            short[] idapoyo = new short[1] { 0 };


            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "ADMINISTRATIVO"
               && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "BASE")
                idapoyo = this.PlantillaNominaPercepciones.Where(f => f.Percepciones_ctPercepcion.Percepcion == "APOYO PARA LA CULTURA Y EL DEPORTE").Select(h => h.IdPlantillaNominaPercepcion).ToArray();


            var totalpercepciones = this.Suma(this.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
            && (idapoyo.Contains(v.IdPlantillaNominaPercepcion)
            || v.EsGrabable == true)).ToList());

            var saldoEnfermedad = db.Nomina_IncidenciasSaldos.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
            && s.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR ENFERMEDAD GENERAL"
              && s.Saldo > 0).OrderByDescending(s => s.Nomina_stNomina.FechaTermino).FirstOrDefault();


            if (saldoEnfermedad != null)
            {

                if (saldoEnfermedad.Saldo > 0)

                {


                    if (saldoEnfermedad.Saldo < totalpercepciones)
                    {

                        VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                        vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt.Concepto = "ENFERMEDADGENERAL_TERMINO";
                        vnt.IdIncidenciaTrabajador = saldoEnfermedad.IdIncidenciaTrabajador;
                        vnt.Importe = saldoEnfermedad.Saldo;
                        this.ListaVariablesNominaTrabajador.Add(vnt);

                    }


                }




            }
        }
        public void setMaternidadRiesgoTrabajoTrabajador(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria)
        {


            if (this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "RIESGO DE TRABAJO").FirstOrDefault() != null
                || this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "MATERNIDAD").FirstOrDefault() != null)
            {

                TrabajadorConIncapacipdadActiva = false;


                var diaslaborados = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;

                Plazas_ctCostoHoraJornada costos = this.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();



                bool NuevaIncidencia = false;
                long IdNuevaIncidencia = 0;

                Decimal totalIncidencia = 0;
                int totalDias= 0;

                List<IncidenciaPermiso_stIncidenciaTrabajador> tieneRiesgoTrabajo = new List<IncidenciaPermiso_stIncidenciaTrabajador>();

                String TipoDeduccion = "RIESGO DE TRABAJO";
                TrabajadorConIncapacipdadActivaConcepto = "";


                tieneRiesgoTrabajo = this.IncidenciaTrabajador.Where
                     (i => i.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                         && i.EsAplicada == false && i.FechaAplicacionIncapacidad == this.Nomina_stNomina.FechaInicio
                         && i.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR RIESGO DE TRABAJO"
                            ).OrderBy(j => j.FechaInicio).ToList();

                if (tieneRiesgoTrabajo.Count == 0)
                {
                    tieneRiesgoTrabajo = this.IncidenciaTrabajador.Where
                       (i => i.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                           && i.EsAplicada == false && i.FechaAplicacionIncapacidad == this.Nomina_stNomina.FechaInicio
                           && i.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR MATERNIDAD"
                              ).OrderBy(j => j.FechaInicio).ToList();
                    TipoDeduccion = "MATERNIDAD";

                }


                bool tienesaldo = false;

                bool ActualizarSaldo = false;

                decimal saldo = 0;
                int diassaldo = 0;
                decimal saldoNUevaIncidencia = 0;
                Nomina_IncidenciasSaldos diassaldoRiesgoTrabajo = null;
                Nomina_IncidenciasSaldos saldoRiesgoTrabajo = null;
                Nomina_IncidenciasSaldos diassaldoMaternidad = null;
                Nomina_IncidenciasSaldos saldoMaternidad = null;

                //using (var dbContext1 = new bdNovaEntities())
                //{
                //   dbContext1.Database.Connection.Open();


                diassaldoRiesgoTrabajo = this.Nomina_IncidenciasSaldosBd.Where(s =>
          s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
        && s.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR RIESGO DE TRABAJO"
          && s.DiasSaldo > 0).OrderBy(s => s.IncidenciaPermiso_stIncidenciaTrabajador.FechaInicio).FirstOrDefault();


                saldoRiesgoTrabajo = this.Nomina_IncidenciasSaldosBd.Where(s =>
                s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
              && s.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR RIESGO DE TRABAJO"
                && s.Saldo > 0).OrderBy(s => s.IncidenciaPermiso_stIncidenciaTrabajador.FechaInicio).FirstOrDefault();


                diassaldoMaternidad = this.Nomina_IncidenciasSaldosBd.Where(s =>
                   s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
               && s.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR MATERNIDAD"
                 && s.DiasSaldo > 0).OrderBy(s => s.IncidenciaPermiso_stIncidenciaTrabajador.FechaInicio).FirstOrDefault();

                saldoMaternidad = this.Nomina_IncidenciasSaldosBd.Where(s =>
                    s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                && s.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR MATERNIDAD"
                  && s.Saldo > 0).OrderBy(s => s.IncidenciaPermiso_stIncidenciaTrabajador.FechaInicio).FirstOrDefault();

                 //   dbContext1.Database.Connection.Close();

                //}
                        long id = 0;
                Decimal totalpercepciones = 0;
                Decimal totalpercepcionesODES = 0;
                bool terminaDepagarRiesgoTrabajo = false;

                var saldoAcumulado = 0M;
                bool inicioyterminoimss = false;
                Nomina_IncidenciasSaldos saldoPendiente = null;
                if (diassaldoRiesgoTrabajo != null)
                {
                    diassaldo = (int)saldoRiesgoTrabajo.DiasSaldo;
                    if (diassaldo - (int)diaslaborados < 0)
                    {
                        
                            VariablesNominaTrabajador vnt14 = new VariablesNominaTrabajador();
                            vnt14.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            vnt14.Concepto = "INCIDENCIA_DIAS_IMSS";
                            vnt14.IdIncidenciaTrabajador = saldoRiesgoTrabajo.IdIncidenciaTrabajador;
                            vnt14.Importe = diassaldo;


                            this.ListaVariablesNominaTrabajador.Add(vnt14);
                        
                        inicioyterminoimss = true;

                        diassaldo = 0;
                    }
                    else
                        diassaldo = diassaldo - (int)diaslaborados;

                    VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
                    vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    vnt1.Concepto = "INCIDENCIA_DIAS_SALDO_UPDATE";
                    vnt1.IdIncidenciaTrabajador = saldoRiesgoTrabajo.IdIncidenciaTrabajador;
                    vnt1.Importe = diassaldo;


                    this.ListaVariablesNominaTrabajador.Add(vnt1);

                }


                    if (saldoRiesgoTrabajo != null)
                {
                    TrabajadorConIncapacipdadActivaConcepto = "INCAPACIDAD POR RIESGO DE TRABAJO";
                    TipoDeduccion = "RIESGO DE TRABAJO";
                    if (saldoRiesgoTrabajo.Saldo == 0)
                        tienesaldo = false;
                    else
                    {
                        saldo = saldoRiesgoTrabajo.Saldo;
                        

                        string sql = @" select case when importe IS  null then 0 else importe end Importe  from ( SELECT  sum(importe) as Importe
  FROM [Deducciones_stNominaTrabajadorDeduccion] a
  inner join  Nomina_stNominaTrabajador b on a.IdNominaTrabajador=b.IdNominaTrabajador
 inner join Convenios_stConvenioLaboralTrabajadorCategoria dd on dd.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador ss on ss.IdConvenioLaboralTrabajador=dd.IdConvenioLaboralTrabajador
  inner join Deducciones_stPlantillaNominaDeducciones c on c.IdPlantillaNominaDeduccion=a.IdPlantillaNominaDeduccion
  inner join Deducciones_ctDeduccion d on d.IdDeduccion=c.IdDeduccion
  inner join Nomina_stNomina f on f.IdNomina=b.IdNomina
  inner join Catalogos_ctQuincenaMes g on g.IdQuincenaMes=f.IdQuincenaMes
  where f.EsCerrada=0 and  ss.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + @" and Deduccion='RIESGO DE TRABAJO' and f.IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + " ) as q ";

                        DapperQuery dpa = new DapperQuery("bdNovaEntities");
                        decimal descuentos = 0;

                        try
                        {
                            descuentos = (decimal)dpa.connection.ExecuteScalar(sql);
                        }
                        catch (Exception ed)
                        {


                        }
                        dpa.Close();
                        saldo = saldo - descuentos;
                        if (saldo > 0)
                        {
                            saldoNUevaIncidencia = saldo;
                            ActualizarSaldo = true;
                            tienesaldo = true;
                            id = saldoRiesgoTrabajo.IdIncidenciaTrabajador;
                        }
                        //using (var dbContext = new bdNovaEntities())
                        //{
                        //    dbContext.Database.Connection.Open();
                            saldoPendiente = this.Nomina_IncidenciasSaldosBd.Where(s =>
                        s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
            && s.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR RIESGO DE TRABAJO" && s.IdIncidenciaTrabajador != id
              && s.Saldo > 0).OrderBy(s => s.IncidenciaPermiso_stIncidenciaTrabajador.FechaInicio).FirstOrDefault();
                            // busca en la s nominas nocerrdas de la misma qna si existen un descuento
                           // dbContext.Database.Connection.Close();
                        //}

                    }
                }


                if (diassaldoMaternidad != null)
                {
                    diassaldo = (int)saldoMaternidad.DiasSaldo;
                    if (diassaldo - (int)diaslaborados < 0)
                        diassaldo = 0;
                    else
                        diassaldo = diassaldo - (int)diaslaborados;

                    VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
                    vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    vnt1.Concepto = "INCIDENCIA_DIAS_SALDO_UPDATE";
                    vnt1.IdIncidenciaTrabajador = saldoMaternidad.IdIncidenciaTrabajador;
                    vnt1.Importe = diassaldo;


                    this.ListaVariablesNominaTrabajador.Add(vnt1);
                }

                    if (saldoMaternidad != null)
                {
                    TrabajadorConIncapacipdadActivaConcepto = "INCAPACIDAD POR MATERNIDAD";
                    TipoDeduccion = "MATERNIDAD";
                    if (saldoMaternidad.Saldo == 0)
                        tienesaldo = false;
                    else
                    {
                        saldo = saldoMaternidad.Saldo;
                        
                        //using (var dbContext = new bdNovaEntities())
                        //{
                        //    dbContext.Database.Connection.Open();
                        saldoPendiente = this.Nomina_IncidenciasSaldosBd.Where(s =>
                        s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
           && s.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR MATERNIDAD" && s.IdIncidenciaTrabajador != id
             && s.Saldo > 0).OrderBy(s => s.IncidenciaPermiso_stIncidenciaTrabajador.FechaInicio).FirstOrDefault();
                        //    dbContext.Database.Connection.Close();
                        //}
                        // busca en la s nominas nocerrdas de la misma qna si existen un descuento
                        string sql = @" select case when importe IS  null then 0 else importe end Importe  from ( SELECT  sum(importe) as Importe
  FROM [Deducciones_stNominaTrabajadorDeduccion] a
  inner join  Nomina_stNominaTrabajador b on a.IdNominaTrabajador=b.IdNominaTrabajador
inner join Convenios_stConvenioLaboralTrabajadorCategoria dd on dd.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador ss on ss.IdConvenioLaboralTrabajador=dd.IdConvenioLaboralTrabajador
  inner join Deducciones_stPlantillaNominaDeducciones c on c.IdPlantillaNominaDeduccion=a.IdPlantillaNominaDeduccion
  inner join Deducciones_ctDeduccion d on d.IdDeduccion=c.IdDeduccion
  inner join Nomina_stNomina f on f.IdNomina=b.IdNomina
  inner join Catalogos_ctQuincenaMes g on g.IdQuincenaMes=f.IdQuincenaMes
  where f.EsCerrada=0 and ss.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + @" and Deduccion='MATERNIDAD' and f.IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + " ) as q";

                        decimal descuentos = 0M;

                        DapperQuery dpa = new DapperQuery("bdNovaEntities");
                        try
                        {
                            descuentos = (decimal)dpa.connection.ExecuteScalar(sql);
                        }
                        catch (Exception ed)
                        {


                        }

                        dpa.Close();
                        saldo = saldo - descuentos;

                        if (saldo > 0)
                        {
                            saldoNUevaIncidencia = saldo;
                            ActualizarSaldo = true;
                            tienesaldo = true;
                            id = saldoMaternidad.IdIncidenciaTrabajador;
                        }


                    }
                }

                if (saldoPendiente != null && saldo == 0)
                {
                    saldoAcumulado = saldoPendiente.Saldo;

                }

                Nova.Models.Calculos.Percepciones.PercepcionPersonalizada percepcionpersonalizada = new Nova.Models.Calculos.Percepciones.PercepcionPersonalizada();
                percepcionpersonalizada.Calcular(ConvenioLaboralTrabajadorCategoria, this, "INCAPACIDADES", "GASTO ADMINISTRATIVO");
                percepcionpersonalizada.Calcular(ConvenioLaboralTrabajadorCategoria, this, "INCAPACIDADES", "APOYO ZONA MARGINAL");
                //// AYUDA PARA LA CULTURA Y DEPORTE
                ApoyoCulturaDeporte apoyoculturadeporte = new ApoyoCulturaDeporte();
                apoyoculturadeporte.Calcular(ConvenioLaboralTrabajadorCategoria, this, "INCAPACIDADES");

                //// AYUDA PARA TRANSPORTE
                AyudaTransporte ayudatransporte = new AyudaTransporte();
                ayudatransporte.Calcular(ConvenioLaboralTrabajadorCategoria, this, "INCAPACIDADES");

                //this.ListaPercepcionesTrabajadores.AddRange();

                var percepcionesQuitarlas = this.PlantillaNominaPercepcionesRelacionLaboral.Where(c =>
                  c.Percepciones_ctPercepcion.Percepcion.Contains("ONOMÁSTICO") ||
                  c.Percepciones_ctPercepcion.Percepcion.Contains("DIA DE DESCANSO") 
            
                  || (c.Percepciones_ctPercepcion.Percepcion.Contains("PRIMA VACACIONAL")
                  )
            ).Select(x => x.IdPercepcion).ToArray();


                if (TipoDeduccion != "MATERNIDAD")
                {


                    totalpercepciones = this.Suma(this.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                 && (v.EsGrabable == true ||   v.TratamientoEspecialIncapacidadesSueldoIsr == true) &&
                 !percepcionesQuitarlas.Contains(v.IdPercepcion) ).ToList());

                  

                 //   totalpercepciones = totalpercepciones+ this.Suma(this.ListaPercepcionesTrabajadoresCCTIMSS
                 //       .Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                 //       &&
                 //!percepcionesQuitarlas.Contains(v.IdPercepcion)
                 //).ToList());

                    totalpercepcionesODES = totalpercepciones;
                }
                else
                {
                    totalpercepciones = this.Suma(this.ListaPercepcionesTrabajadores.Where(v => (v.EsPrevisionSocial == false || v.TratamientoEspecialIncapacidadesSueldoIsr == true) &&

                              v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                               && !percepcionesQuitarlas.Contains(v.IdPercepcion) ).ToList());

                   

                //    totalpercepciones = totalpercepciones+this.Suma(this.ListaPercepcionesTrabajadoresCCTIMSS.Where(v => 
                //    v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                //    &&
                // !percepcionesQuitarlas.Contains(v.IdPercepcion)
                //).ToList());

                    totalpercepcionesODES = totalpercepciones;
                }

                if (!this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
                {
                    //no debe de considerar mas que las percepciones que traiga que puede ser vales o ayuda
                    totalpercepciones = this.Suma(this.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    &&  !percepcionesQuitarlas.Contains(v.IdPercepcion)).ToList());

                    totalpercepcionesODES = totalpercepciones;
                }

                if (tieneRiesgoTrabajo.Count > 0)
                {
                    NuevaIncidencia = true;
                    //IdNuevaIncidencia = tieneRiesgoTrabajo[0].IdIncidenciaTrabajador;

                    //int diasincidencia = 0;
                    //foreach (var item in tieneRiesgoTrabajo)
                    //{
                    //    diasincidencia = diasincidencia + (int)(item.FechaTermino.Value.AddDays(1) - item.FechaInicio).Days;

                    //}


                    Decimal ImporteADescontar = 0;

                    if (tieneRiesgoTrabajo.Count > 0)

                    {
                        var existedespensa = this.PlantillaNominaPercepcionesRelacionLaboral.Where(s => !s.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && s.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA" && s.Calcular == true).OrderByDescending(q => q.Percepciones_ctPercepcion).FirstOrDefault();





                        Decimal despensacosto = 0M;
                        if (existedespensa != null)
                            //despensacosto = (decimal)existedespensa.Importe;
                             despensacosto = (decimal)((costos.CostoValesDespensa * 7) * diaslaborados) * 2;



                        var existeayuda = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => !x.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA").FirstOrDefault();

                        Decimal ayudacosto = 0M;

                        if (existeayuda != null)
                            if (existeayuda.Calcular == true)
                            {
                                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONFIANZA"))
                                {
                                    if (AyudaDespensaExcepciones.Calcular(ConvenioLaboralTrabajadorCategoria))
                                       // ayudacosto = (decimal)existeayuda.Importe;
                                        ayudacosto = (decimal)(costos.CostoAyudaDespensa *9) * diaslaborados;
                                }
                                else
                                    //ayudacosto = (decimal)existeayuda.Importe;
                                    ayudacosto = (decimal)(costos.CostoAyudaDespensa * 7) * diaslaborados;
                            }





                        var fdespensa = despensacosto / 30;
                        var fayudacosto = ayudacosto / 15;
                        var tempfdespensafayudacosto = fayudacosto + fdespensa;
                        var tempopercep = (totalpercepciones) / 15;
                        tempopercep = tempopercep + tempfdespensafayudacosto;

                        var percepcionesAcumulado = totalpercepcionesODES;
                        var saldobd = saldo;
                        ImporteADescontar = saldobd;
                        Boolean DescuentoTotal = false;
                        foreach (var item in tieneRiesgoTrabajo)
                        {
                            int diasincidencia = 0;

                            diasincidencia = (int)(item.FechaTermino.Value.AddDays(1) - item.FechaInicio).Days;

                            IdNuevaIncidencia = item.IdIncidenciaTrabajador;

                            totalIncidencia = tempopercep * diasincidencia;
                            saldoNUevaIncidencia = totalIncidencia;
                            totalDias = diasincidencia;
                            ImporteADescontar = ImporteADescontar + saldoNUevaIncidencia;

                           
                            //SeActualizoSaldo = true;
                            if ((this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT")  
                                )
                               && this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "01"
                                && this.Nomina_stNomina.Año == 2024)
                            {
                                //List<int> lista_de_valores = new List<int> { 776, 127, 69, 2653, 320, 3023, 2588 };

                                //if (lista_de_valores.Contains(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria))
                                //{
                                    totalIncidencia = 0;
                                ImporteADescontar =0;
                                //}
                            }

                            if (tienesaldo)
                            {

                                //if (DescuentoTotal == false && ((saldo + totalIncidencia) < totalpercepciones))
                                if (DescuentoTotal == false && ((saldo + totalIncidencia) < totalpercepcionesODES))
                                {
                                    if (NuevaIncidencia)
                                    {
                                        saldoNUevaIncidencia = 0;
                                        percepcionesAcumulado = percepcionesAcumulado - (totalIncidencia + saldo);
                                    }
                                    saldo = 0;
                                    tienesaldo = false;

                                    // terminaDepagarRiesgoTrabajo = true;
                                    //DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                                    //isr.EsImprimibleRecibo = true;
                                    //isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    //isr.IdNomina = this.Nomina_stNomina.IdNomina;
                                    //isr.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == TipoDeduccion).FirstOrDefault().IdPlantillaNominaDeduccion;
                                    //isr.Importe = saldo;


                                    //if (isr.Importe > 0)
                                    //    this.ListaDeduccionesTrabajadores.Add(isr);

                                }
                                else
                                {
                                    if (NuevaIncidencia)
                                    {
                                        if (DescuentoTotal)
                                            saldo = totalIncidencia;
                                        else
                                        {
                                            if (saldo < totalpercepcionesODES)
                                            {
                                                saldoNUevaIncidencia = totalIncidencia - (totalpercepcionesODES - saldo);
                                                saldo = 0;
                                                percepcionesAcumulado = percepcionesAcumulado - totalIncidencia;
                                            }
                                            else
                                            {
                                                //percepcionesAcumulado = percepcionesAcumulado - (totalIncidencia + saldo);
                                                saldo = (saldo - totalpercepcionesODES);
                                                DescuentoTotal = true;
                                            }
                                        }
                                    }
                                    else
                                    {
                                        saldo = (saldo - totalpercepcionesODES);
                                    }
                                    //DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                                    //isr.EsImprimibleRecibo = true;
                                    //isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    //isr.IdNomina = this.Nomina_stNomina.IdNomina;
                                    //isr.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == TipoDeduccion).FirstOrDefault().IdPlantillaNominaDeduccion;
                                    //isr.Importe = totalpercepciones;

                                    //if (isr.Importe > 0)
                                    //    this.ListaDeduccionesTrabajadores.Add(isr);
                                }





                              //  Plazas_ctCostoHoraJornada costos = this.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                                var existeupdate = ListaVariablesNominaTrabajador.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                  && q.Concepto == "INCIDENCIA_SALDO_UPDATE" && q.IdIncidenciaTrabajador == id).FirstOrDefault();
                                if (existeupdate == null)
                                {

                                    VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                                    vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    vnt.Concepto = "INCIDENCIA_SALDO_UPDATE";
                                    vnt.IdIncidenciaTrabajador = id;
                                    vnt.Importe = saldo;


                                    this.ListaVariablesNominaTrabajador.Add(vnt);

                              
                                }

                                if (NuevaIncidencia)
                                {
                                    VariablesNominaTrabajador vnt44 = new VariablesNominaTrabajador();
                                    vnt44.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;


                                    vnt44.Concepto = "INCIDENCIA_SALDO_INSERT";

                                    vnt44.IdIncidenciaTrabajador = IdNuevaIncidencia;
                                    vnt44.Importe = totalIncidencia;

                                    if (vnt44.Importe > 0)
                                        this.ListaVariablesNominaTrabajador.Add(vnt44);

                                    VariablesNominaTrabajador vnt84 = new VariablesNominaTrabajador();
                                    vnt84.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;


                                    vnt84.Concepto = "INCIDENCIA_DIAS_SALDO_INSERT";

                                    vnt84.IdIncidenciaTrabajador = IdNuevaIncidencia;
                                    vnt84.Importe = totalDias;

                                    if (vnt84.Importe > 0)
                                        this.ListaVariablesNominaTrabajador.Add(vnt84);
                                    

                                    if (DescuentoTotal == false && ((saldobd + totalIncidencia) < totalpercepcionesODES))
                                    {
                                        VariablesNominaTrabajador vntW = new VariablesNominaTrabajador();
                                        vntW.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        vntW.Concepto = "INCIDENCIA_SALDO_UPDATE";

                                        vntW.IdIncidenciaTrabajador = IdNuevaIncidencia;
                                        vntW.Importe = 0;

                                        //PROBALMENTE EN LA MISMA QNA DE CALCULO TERMINA DE PAGAR 
                                        this.ListaVariablesNominaTrabajador.Add(vntW);
                                    }
                                    else
                                    //hubo un adiferencia con loqeu tetermino de pagar y la nueva incidencia debe de actulziar el saldo
                                        if (saldoNUevaIncidencia < totalIncidencia)
                                    {
                                        VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                                        vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        vnt.Concepto = "INCIDENCIA_SALDO_UPDATE";
                                        vnt.IdIncidenciaTrabajador = IdNuevaIncidencia;
                                        vnt.Importe = saldoNUevaIncidencia;


                                        this.ListaVariablesNominaTrabajador.Add(vnt);
                                    }
                                }
                            }
                            else
                            {
                                if (this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == TipoDeduccion).FirstOrDefault() != null)
                                {
                                    //DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                                    //isr.EsImprimibleRecibo = true;
                                    //isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    //isr.IdNomina = this.Nomina_stNomina.IdNomina;
                                    //isr.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == TipoDeduccion).FirstOrDefault().IdPlantillaNominaDeduccion;

                                    if (DescuentoTotal)
                                    { saldo = totalIncidencia; }
                                    else
                                    {
                                        if (totalIncidencia < percepcionesAcumulado)
                                        {
                                            //  isr.Importe = totalIncidencia;
                                            saldo = 0;
                                            saldoNUevaIncidencia = 0;
                                            percepcionesAcumulado = percepcionesAcumulado - totalIncidencia;

                                        }
                                        else
                                        {
                                            // isr.Importe = percepcionesAcumulado;
                                            saldo = totalIncidencia - percepcionesAcumulado;
                                            TrabajadorConIncapacipdadActiva = true;
                                        }


                                    }

                                    //if (isr.Importe > 0)
                                    //    this.ListaDeduccionesTrabajadores.Add(isr);

                                    VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                                    vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    vnt.Concepto = "INCIDENCIA_SALDO_INSERT";

                                    vnt.IdIncidenciaTrabajador = IdNuevaIncidencia;
                                    vnt.Importe = totalIncidencia;

                                    if (vnt.Importe > 0)
                                        this.ListaVariablesNominaTrabajador.Add(vnt);

                                    VariablesNominaTrabajador vnt84 = new VariablesNominaTrabajador();
                                    vnt84.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;


                                    vnt84.Concepto = "INCIDENCIA_DIAS_SALDO_INSERT";

                                    vnt84.IdIncidenciaTrabajador = IdNuevaIncidencia;
                                    vnt84.Importe = totalDias;

                                    if (vnt84.Importe > 0)
                                        this.ListaVariablesNominaTrabajador.Add(vnt84);

                                    VariablesNominaTrabajador vntW = new VariablesNominaTrabajador();
                                    vntW.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    vntW.Concepto = "INCIDENCIA_SALDO_UPDATE";

                                    vntW.IdIncidenciaTrabajador = IdNuevaIncidencia;
                                    vntW.Importe = saldo;

                                    //PROBALMENTE EN LA MISMA QNA DE CALCULO TERMINA DE PAGAR 
                                    this.ListaVariablesNominaTrabajador.Add(vntW);


                                    VariablesNominaTrabajador vntP = new VariablesNominaTrabajador();
                                    vntP.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    vntP.Concepto = "INCIDENCIA_DIAS_SALDO_UPDATE";

                                    vntP.IdIncidenciaTrabajador = IdNuevaIncidencia;

                                    if (totalDias - (int)diaslaborados < 0)
                                    {
                                        vntP.Importe = 0;

                        
                                        if (inicioyterminoimss == false)
                                        {
                                            

                                            VariablesNominaTrabajador vnt14 = new VariablesNominaTrabajador();
                                            vnt14.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                            vnt14.Concepto = "INCIDENCIA_DIAS_IMSS";
                                            vnt14.IdIncidenciaTrabajador = IdNuevaIncidencia;
                                            vnt14.Importe = totalDias;


                                            this.ListaVariablesNominaTrabajador.Add(vnt14);
                                        }
                                    }
                                    else
                                        vntP.Importe = totalDias - (int)diaslaborados;

                                   

                                    //PROBALMENTE EN LA MISMA QNA DE CALCULO TERMINA DE PAGAR 
                                    this.ListaVariablesNominaTrabajador.Add(vntP);

                                }
                            }

                        }// for

                        if (ImporteADescontar > totalpercepcionesODES)
                            ImporteADescontar = totalpercepcionesODES;
                        else
                            terminaDepagarRiesgoTrabajo = true;

                        DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                        isr.EsImprimibleRecibo = true;
                        isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        isr.IdNomina = this.Nomina_stNomina.IdNomina;
                        isr.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == TipoDeduccion).FirstOrDefault().IdPlantillaNominaDeduccion;
                        isr.Importe = ImporteADescontar;
                        this.ListaDeduccionesTrabajadores.Add(isr);

                    }




                }
                else
                {
                    if ((this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT")
                         )
                        && this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "01"
                         && this.Nomina_stNomina.Año == 2024)
                    {
                        //List<int> lista_de_valores = new List<int> { 776, 127, 69, 2653, 320, 3023, 2588 };

                        //if (lista_de_valores.Contains(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria))
                        //{
                        totalIncidencia = 0;
                        saldo = 0;
                        tienesaldo = false;
                        //}
                    }

                    if (tienesaldo)
                    {

                        if ((saldo + saldoAcumulado) < totalpercepcionesODES)

                        {

                            terminaDepagarRiesgoTrabajo = true;
                            DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                            isr.EsImprimibleRecibo = true;
                            isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            isr.IdNomina = this.Nomina_stNomina.IdNomina;
                            isr.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == TipoDeduccion).FirstOrDefault().IdPlantillaNominaDeduccion;
                            isr.Importe = saldo;
                            if (isr.Importe > 0)
                                this.ListaDeduccionesTrabajadores.Add(isr);

                        }
                        else
                        {
                            if (saldoAcumulado > 0)
                            {
                                if (saldo < totalpercepcionesODES)
                                {
                                    saldoAcumulado = saldoAcumulado - (totalpercepcionesODES - saldo);
                                    saldo = 0;
                                }
                                else
                                    saldo = (saldo - totalpercepcionesODES);
                            }
                            else
                            {
                                saldo = (saldo - totalpercepcionesODES);
                            }

                            DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                            isr.EsImprimibleRecibo = true;
                            isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            isr.IdNomina = this.Nomina_stNomina.IdNomina;
                            isr.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == TipoDeduccion).FirstOrDefault().IdPlantillaNominaDeduccion;
                            isr.Importe = totalpercepcionesODES;

                            if (isr.Importe > 0)
                                this.ListaDeduccionesTrabajadores.Add(isr);
                        }





                    //    Plazas_ctCostoHoraJornada costos = this.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                        if (terminaDepagarRiesgoTrabajo)
                        {
                            saldo = 0;


                            VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                            vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            vnt.Concepto = "INCIDENCIA_SALDO_UPDATE";
                            vnt.IdIncidenciaTrabajador = id;
                            vnt.Importe = saldo;
                            //si es 0 se agrega por qeu es cuando termina su incindencia
                            this.ListaVariablesNominaTrabajador.Add(vnt);
                        }
                        if (saldoAcumulado > 0 || saldo > 0)
                        {
                            if (terminaDepagarRiesgoTrabajo)
                            {
                                saldoAcumulado = 0;

                            }
                            else
                                if (saldoAcumulado > 0 && saldo == 0)
                                saldo = saldoAcumulado;
                          
                            VariablesNominaTrabajador vntq = new VariablesNominaTrabajador();
                            vntq.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            vntq.Concepto = "INCIDENCIA_SALDO_UPDATE";
                            if (saldoPendiente!=null)
                            vntq.IdIncidenciaTrabajador = saldoPendiente.IdIncidenciaTrabajador;
                            else
                                vntq.IdIncidenciaTrabajador = id;
                            
                            vntq.Importe = saldo;
                            if (vntq.Importe > 0)
                                this.ListaVariablesNominaTrabajador.Add(vntq);


                        }



                        if (NuevaIncidencia)
                        {
                            VariablesNominaTrabajador vnt44 = new VariablesNominaTrabajador();
                            vnt44.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            vnt44.Concepto = "INCIDENCIA_SALDO_INSERT";
                            vnt44.IdIncidenciaTrabajador = IdNuevaIncidencia;
                            vnt44.Importe = totalIncidencia;

                            if (vnt44.Importe > 0)
                                this.ListaVariablesNominaTrabajador.Add(vnt44);
                        }

                    }

                }


                if (terminaDepagarRiesgoTrabajo == false)
                    if (saldoMaternidad != null || saldoRiesgoTrabajo != null)
                    {

                        TrabajadorConIncapacipdadActiva = true;



                    }
            }
        }

        public void setHorarioPorTrabajador(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria)
        {
            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.UsaHorariosDocentesParaCalculo)
            {
                HorariosVigenteAnteriorTrabajador = null;

                
                    this.HorariosVigenteAnteriorTrabajador = this.getHorarioActualDocente(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex, 0,null,false, ConvenioLaboralTrabajadorCategoria);
                
                
                //this.HorariosVigenteAnteriorTrabajador = this.getHorarioActualDocente(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex, 0);

                if (this.HorariosVigenteAnteriorTrabajador.TieneHorario && this.HorariosVigenteAnteriorTrabajador.HorarioVigente == false)
                {
                   
                    VariablesNominaTrabajador horarioanterior = new VariablesNominaTrabajador();
                    horarioanterior.Concepto = "EsHorarioAnterior";
                    horarioanterior.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    horarioanterior.Importe = 1;
                    this.ListaVariablesNominaTrabajador.Add(horarioanterior);

                    VariablesNominaTrabajador ciclo = new VariablesNominaTrabajador();
                    ciclo.Concepto = this.CicloEscolarAnteriorPlantel;
                    ciclo.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;

                    this.ListaVariablesNominaTrabajador.Add(ciclo);

                    VariablesNominaTrabajador cicloanterior = new VariablesNominaTrabajador();
                    cicloanterior.Concepto = "CicloEscolar";
                    cicloanterior.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    cicloanterior.Importe = -1;
                    this.ListaVariablesNominaTrabajador.Add(cicloanterior);

                }
                else
                         if (this.HorariosVigenteAnteriorTrabajador.TieneHorario && this.HorariosVigenteAnteriorTrabajador.HorarioVigente)
                {
                    VariablesNominaTrabajador cicloanterior = new VariablesNominaTrabajador();
                    cicloanterior.Concepto = "CicloEscolar";
                    cicloanterior.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    cicloanterior.Importe = 1;
                    this.ListaVariablesNominaTrabajador.Add(cicloanterior);

                    VariablesNominaTrabajador ciclo = new VariablesNominaTrabajador();
                    ciclo.Concepto = this.CicloEscolarVigentePlantel;
                    ciclo.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;

                    this.ListaVariablesNominaTrabajador.Add(ciclo);
                }
                else
                {
                    //no tiene horarios y seguro esta fungiendo con funciones administrativas
                    VariablesNominaTrabajador cicloanterior = new VariablesNominaTrabajador();
                    cicloanterior.Concepto = "CicloEscolar";
                    cicloanterior.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    cicloanterior.Importe = 1;
                    this.ListaVariablesNominaTrabajador.Add(cicloanterior);

                    VariablesNominaTrabajador ciclo = new VariablesNominaTrabajador();
                    ciclo.Concepto = this.CicloEscolarVigentePlantel;
                    ciclo.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;

                    this.ListaVariablesNominaTrabajador.Add(ciclo);
                }

            }
        }
        
        public void setIncidenciaTrabajador(int idtrabajador)
        {
            this.TrabajadorConIncapacipdadActiva = false;

            DateTime FechaActual = System.DateTime.Now;

            IncidenciaTrabajador = this.getIncidenciasTrabajadores().Where(i =>
           ( i.IdIncidenciaJustificacion == 0  || (i.IdIncidenciaJustificacion > 0 && i.Autorizo==false)) 
           &&
             i.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idtrabajador
            && i.EsAplicada == false
            && i.EsCerrada == true
            && i.EsCancelada == false

            && i.Catalogos_ctTipoIncidencia.EsAfectacionCalculoNomina == true).ToList();

          

            DevolucionesFaltasTrabajador = getDevolucionesFaltasTrabajador(idtrabajador);

        }


        public bool ValidarEmpleadoRestriccionSincuota(int id, Kardex_ctTrabajador trabajador)
        {
            bool tienecuota = false;
            if (trabajador.EsCuotaSindical != null)
                tienecuota =(bool) trabajador.EsCuotaSindical;

            // Lista de IDs válidos
            List<int> listaIdsValidos = new List<int> { 3720, 3411, 3690, 3081, 3022 };
            if (!listaIdsValidos.Contains(id))
                {
                return true;
            }
            else
            // Verificar si el ID está en la lista y que no tenga cuota sindical
            if (!tienecuota)
            {
                return false;
            }
                else
                    return true;
        }


        public List<IncidenciaPermiso_stIncidenciaTrabajador> getDevolucionesFaltasTrabajador(int idtrabajador)
        {
            if (DevolucionesFaltasTrabajadorTodos == null)
            {
                
                    
                    //        DevolucionesFaltasTrabajador = db.IncidenciaPermiso_stIncidenciaTrabajador.Include("Convenios_stConvenioLaboralTrabajadorCategoria").Include("Catalogos_ctTipoIncidencia").Where(i =>
                    //  i.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idtrabajador
                    //&& i.EsAplicada == true
                    // && i.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA")
                    //&& i.EsCerrada == true
                    //&& i.EsCancelada == true
                    //&& i.IdNominaTrabajadorDevolucionFalta == null
                    //&& i.Catalogos_ctTipoIncidencia.EsAfectacionCalculoNomina == true).AsNoTracking().ToList();
                    using (var basenova = new bdNovaEntities())
                {
                    if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
                    {
                        basenova.Database.Connection.Open();
                        basenova.Configuration.LazyLoadingEnabled = false;

                        var nominasodes = basenova.Nomina_stNominaTrabajador.AsNoTracking().Where(q =>
                        q.Nomina_stNomina.Año == this.Nomina_stNomina.Año
                        && q.Nomina_stNomina.IdQuincenaMes == this.Nomina_stNomina.IdQuincenaMes
                        && q.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral
                        ).Select(z=> z.IdNominaTrabajador ).ToList();

                        DevolucionesFaltasTrabajadorTodos = basenova.IncidenciaPermiso_stIncidenciaTrabajador
        .AsNoTracking()

        .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
        .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria)
        .Include(i => i.Catalogos_ctTipoIncidencia)
        .Where(i =>

            i.EsAplicada == true &&
            i.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") &&
            i.EsCerrada == true &&
            i.EsCancelada == true && i.IdNominaTrabajador != null &&
            (nominasodes.Contains((int)i.IdNominaTrabajadorDevolucionFalta) ||
             (i.IdNominaTrabajadorDevolucionFalta == null || i.IdNominaTrabajadorDevolucionFalta == 0)) &&
            i.Catalogos_ctTipoIncidencia.EsAfectacionCalculoNomina == true)
        .ToList();

                        basenova.Database.Connection.Close();
                    }
                    else
                    {
                        basenova.Database.Connection.Open();

                        basenova.Configuration.LazyLoadingEnabled = false;
                        DevolucionesFaltasTrabajadorTodos = basenova.IncidenciaPermiso_stIncidenciaTrabajador
        .AsNoTracking()

        .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
        .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria)
        .Include(i => i.Catalogos_ctTipoIncidencia)
        .Where(i =>
            i.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdRelacionConvenioLaboral== this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral &&
            i.EsAplicada == true &&
            i.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") &&
            i.EsCerrada == true &&
            i.EsCancelada == true && i.IdNominaTrabajador != null &&
            (i.IdNominaTrabajadorDevolucionFalta == null || i.IdNominaTrabajadorDevolucionFalta==0) && 
            i.Catalogos_ctTipoIncidencia.EsAfectacionCalculoNomina == true)
        .ToList();

                        basenova.Database.Connection.Close();
                    }
                }

            }
         
                DevolucionesFaltasTrabajador= DevolucionesFaltasTrabajadorTodos.Where(a => a.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idtrabajador ).ToList();

            
            using (var basenova = new bdNovaEntities())
            {
                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("DOCENTE"))
                {
                    var ides = DevolucionesFaltasTrabajador.Select(a => a.IdNominaTrabajador).ToList();

                    basenova.Database.Connection.Open();

                    basenova.Configuration.LazyLoadingEnabled = false;

                    DevolucionesFaltasDocentes = basenova.Deducciones_stNominaTrabajadorDeduccion.AsNoTracking().
                        Where(z => ides.Contains(z.IdNominaTrabajador) &&
                        z.Deducciones_stPlantillaNominaDeducciones.Deducciones_ctDeduccion.Deduccion.Contains("FALTA"))
                        .Include(z => z.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                        .Include(z => z.Deducciones_stPlantillaNominaDeducciones.Deducciones_ctDeduccion)
                        .Include(z => z.Deducciones_stPlantillaNominaDeducciones.Nomina_ctPlantillaNomina)
                        .ToList();
                    basenova.Database.Connection.Close();
                }
            }

            return DevolucionesFaltasTrabajador;
        }

        public List<IncidenciaPermiso_stIncidenciaTrabajador> getIncidenciasTrabajadoresCCT()
        {
            if (IncidenciasTrabajadoresCCT == null)
            {

                //IncidenciasTrabajadores = db.IncidenciaPermiso_stIncidenciaTrabajador.Include("Convenios_stConvenioLaboralTrabajadorCategoria").Include("Catalogos_ctTipoIncidencia")
                // .Include(q=> q.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso)   .Where(z =>
                // z.EsAplicada == false
                //&& (z.Catalogos_ctTipoIncidencia.EsPermiso == true
                //||
                //z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA"))

                //).ToList();
                using (var dbContext = new bdNovaEntities())
                {
                    dbContext.Database.Connection.Open();

                    dbContext.Configuration.LazyLoadingEnabled = false;

                    //var nominasodescerradas = dbContext.Nomina_stNomina.AsNoTracking()
                    //    .Where(a => a.Nomina_ctPlantillaNomina.Plantilla.Contains("ODES")
                    //    && a.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral
                    //   && a.FechaInicio == this.Nomina_stNomina.FechaInicio
                    //   && a.FechaTermino == this.Nomina_stNomina.FechaTermino && a.EsCerrada).ToList();

                    var nominasodescerradas = dbContext.Nomina_stNomina.AsNoTracking()
               .Where(a => a.Nomina_ctPlantillaNomina.Plantilla.Contains("ODES")
               && a.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral
              && a.IdQuincenaMes== this.Nomina_stNomina.IdQuincenaMes
              && a.Año== this.Nomina_stNomina.Año && a.EsCerrada).ToList();

                    if (nominasodescerradas.Count() > 0)
                    {
                        IncidenciasTrabajadoresCCT = dbContext.IncidenciaPermiso_stIncidenciaTrabajador
        .AsNoTracking()
        .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria)
        .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria)
        .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
        .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria)
        .Include(i => i.Catalogos_ctTipoIncidencia)
            .Include(t =>
            t.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso)
        .Where(z => z.IdNominaTrabajador != null && z.AñoParaNomina == this.Nomina_stNomina.Año && z.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes &&

            (
            z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA")))
        .ToList();
                    }
                    else
                    {
                        
                        IncidenciasTrabajadoresCCT = dbContext.IncidenciaPermiso_stIncidenciaTrabajador
 .AsNoTracking()
 .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria)
 .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria)
 .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
 .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria)
 .Include(i => i.Catalogos_ctTipoIncidencia)
     .Include(t => t.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso)
 .Where(z => z.FechaInicio.Year > 2022 &&
     z.EsAplicada == false &&
     (z.Catalogos_ctTipoIncidencia.EsPermiso == true ||
     z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA"))
 && z.AñoParaNomina == this.Nomina_stNomina.Año && z.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes 
 && z.IdIncidenciaJustificacion == 0
            && z.EsAplicada == false
            && z.EsCerrada == true
            && z.EsCancelada == false

            && z.Catalogos_ctTipoIncidencia.EsAfectacionCalculoNomina == true)
 .ToList();
                       

                    }
                    dbContext.Database.Connection.Close();
                }

            }



            return IncidenciasTrabajadoresCCT;
        }

        public List<IncidenciaPermiso_stIncidenciaTrabajador> getIncidenciasTrabajadores()
        {
            if (IncidenciasTrabajadores == null)
            {

                //IncidenciasTrabajadores = db.IncidenciaPermiso_stIncidenciaTrabajador.Include("Convenios_stConvenioLaboralTrabajadorCategoria").Include("Catalogos_ctTipoIncidencia")
                // .Include(q=> q.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso)   .Where(z =>
                // z.EsAplicada == false
                //&& (z.Catalogos_ctTipoIncidencia.EsPermiso == true
                //||
                //z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA"))

                //).ToList();
                using (var dbContext = new bdNovaEntities())
                {
                    dbContext.Database.Connection.Open();
                    dbContext.Configuration.LazyLoadingEnabled = false;

                    IncidenciasTrabajadores = dbContext.IncidenciaPermiso_stIncidenciaTrabajador
    .AsNoTracking()
    .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria)
    .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria)
    .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
    .Include(i => i.Convenios_stConvenioLaboralTrabajadorCategoria)
    .Include(i => i.Catalogos_ctTipoIncidencia)
        .Include(t => t.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso)
    .Where(z => z.FechaInicio.Year > 2023 &&
        z.EsAplicada == false &&
        (z.Catalogos_ctTipoIncidencia.EsPermiso == true ||
        z.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA")))
    .ToList();
                    dbContext.Database.Connection.Close();
                }

            }

            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
            {
                IncidenciaTrabajadorCCT = getIncidenciasTrabajadoresCCT();
            }


            return IncidenciasTrabajadores;
        }


        //Parametros Relacion Laboral

        private void setParametrosConvenioLaboral(short IdRelacionConvenioLaboral)
        {

            ParametrosRelacionLaboral = this.getParametrosRelacionesLaborales().Where(p => p.IdRelacionConvenioLaboral == IdRelacionConvenioLaboral).SingleOrDefault();
            if (ParametrosRelacionLaboral == null)
                throw new ApplicationException("No hay parámetros para el convenio laboral configuradas en el sistema");
        }

        private List<Catalogos_ctParametrosRelacionLaboral> getParametrosRelacionesLaborales()
        {
            var fi = this.Nomina_stNomina.FechaInicio;
            var ft = this.Nomina_stNomina.FechaTermino;
            if (ParametrosRelacionesLaborales == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    ParametrosRelacionesLaborales = basenova.Catalogos_ctParametrosRelacionLaboral
                        .AsNoTracking()
                        .Include(a => a.Convenios_stRelacionConvenioLaboral)
                    .Include(s => s.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral)
                    .Where(d => d.FechaFinal >= fi && ft >= d.FechaInicio)
                    .ToList();
                    basenova.Database.Connection.Close();
                }

            return ParametrosRelacionesLaborales;
        }
        // ISR

        private void setISR()
        {
            ISR = this.getISR();
            if (ISR.Count == 0)
                throw new ApplicationException("No hay ISR configurado en el sistema para las fechas de la nómina");
        }
        private List<Configuracion_ctISR> getISR()
        {
            DateTime FechaActual = this.Nomina_stNomina.FechaInicio;

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query = @"select  s.IdConvenioLaboralTrabajadorCategoria from Deducciones_stNominaTrabajadorDeduccion x
            inner join Nomina_stNominaTrabajador s on s.IdNominaTrabajador=x.IdNominaTrabajador
             inner join Nomina_stNomina w on w.IdNomina=s.IdNomina
              inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=s.IdNominaTrabajadorEstatus
            inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
            inner join Deducciones_stPlantillaNominaDeducciones c on c.IdPlantillaNominaDeduccion=x.IdPlantillaNominaDeduccion
 inner join Nomina_ctPlantillaNomina k on k.IdPlantillaNomina=c.IdPlantillaNomina
 inner join Deducciones_ctDeduccion m on m.IdDeduccion=c.IdDeduccion
            where k.Plantilla like '%SUELDO%' AND IdRelacionConvenioLaboral=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + @" AND 
            year(w.FechaTermino)=" + this.Nomina_stNomina.Año + @" 
            and w.IdQuincenaMes=" + this.Nomina_stNomina.IdQuincenaMes + @"
                 and  EstatusNominaGrupo ='PARA PAGO' 
                   and  Deduccion = 'ISR'";


            ListaNominaSueldoValidarIsr = (List<long>)dp.connection.Query<long>(query);
            dp.Close();

            if (ListaNominaSueldoValidarIsr.Count > 0)
                ExisteNominaSueldoValidarIsr = true;

            DateTime FechaInicioNomina = this.Nomina_stNomina.FechaInicio;


            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();

                ISR = basenova.Configuracion_ctISR.AsNoTracking().Where(i =>
                 i.IdIsrGrupo == this.Nomina_stNomina.IdIsrGrupo).ToList();
                return ISR;
                basenova.Database.Connection.Close();
            }
            }

        //CUOTAS IMSS para deducciones

        private void setCuotasObreroPatronales()
        {
            CuotasObreroPatronales = this.getCuotasObreroPatronales();
            if (CuotasObreroPatronales.Count == 0)
                throw new ApplicationException("No hay cuotas obrero patronales configradas en el sistema");
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                Catalogos_ctCesantiaYVejez = basenova.Catalogos_ctCesantiaYVejez.AsNoTracking().ToList();
                basenova.Database.Connection.Close();
            }
            }
        private List<Deducciones_ctSubDeduccionValores> getCuotasObreroPatronales()
        {
           

            DateTime FechaActual = this.Nomina_stNomina.FechaTermino;
            DateTime FechaInicioNomina = this.Nomina_stNomina.FechaInicio;

           



            if (CuotasObreroPatronales == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();

                    CuotasObreroPatronales = basenova.Deducciones_ctSubDeduccionValores.AsNoTracking()
                        .Where(
                    s => s.FechaInicial <= FechaInicioNomina && s.FechaFinal>= FechaInicioNomina).Include(a => a.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion).ToList();
                    basenova.Database.Connection.Close();
                }
                    return CuotasObreroPatronales;

        }

        // Subsidio para el Empleo

        private void setSubsidioEmpleo()
        {
            SubsidioEmpleo = this.getSubsidioEmpleo();
            if (SubsidioEmpleo.Count == 0)
                throw new ApplicationException("No hay catálogo de subsidio para el empleo configrado en el sistema");
        }
        private List<Configuracion_ctSubsidioEmpleo> getSubsidioEmpleo()
        {
            DateTime FechaActual = this.Nomina_stNomina.FechaInicio;
            DateTime FechaInicioNomina = this.Nomina_stNomina.FechaInicio;

            if (SubsidioEmpleo == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    SubsidioEmpleo = basenova.Configuracion_ctSubsidioEmpleo.AsNoTracking().Where(i => FechaInicioNomina >= i.FechaInicio && i.FechaTermino >= FechaActual).ToList();
                    basenova.Database.Connection.Close();
                }
            return SubsidioEmpleo;

        }

        //Instituciones financieras
        private List<Catalogos_ctInstitucionFinanciera> getInstitucionFinanciera()
        {
            if (InstitucionFinanciera == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    InstitucionFinanciera = basenova.Catalogos_ctInstitucionFinanciera.AsNoTracking()
                        .ToList();
                    basenova.Database.Connection.Close();
                }
            return InstitucionFinanciera;
        }
        //Forma De Pago


        private List<Catalogos_ctFormaDePago> getFormaDePago()
        {
            if (FormaDePago == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    FormaDePago = basenova.Catalogos_ctFormaDePago.AsNoTracking().ToList();
                    basenova.Database.Connection.Close();
                }
            return FormaDePago;
        }

        private void setCesantiaYVejez()
        {
            DateTime ft = this.Nomina_stNomina.FechaTermino;
            DateTime FechaInicioNomina = this.Nomina_stNomina.FechaInicio;
            Configuracion_ctCesantiayVejez = this.getCensantiaYVejez();
            if (Configuracion_ctCesantiayVejez == null)
                
                    throw new ApplicationException("No hay catálogo de Cesantia y Vejez configurados en el sistema");
                
        }

        private void setUMI()
        {
            DateTime ft = this.Nomina_stNomina.FechaTermino;
            DateTime FechaInicioNomina = this.Nomina_stNomina.FechaInicio;
            ctUMI = this.getUMI();
            if (ctUMI == null)
                if (ctUMIHistorial == null)
                    throw new ApplicationException("No hay catálogo de UMI configurados en el sistema");
                else
                {
                    ctUMI = ctUMIHistorial.Where(a => FechaInicioNomina >= a.FechaInicio && ft >= a.FechaTermino
                      && ft.Year == a.FechaTermino.Year).FirstOrDefault();
                    if (ctUMIHistorial == null)
                        throw new ApplicationException("No hay catálogo de UMI configurados en el sistema");
                }
        }

        private void setCatalogoTipoCreditos()
        {
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                Catalogos_ctTipoCredito = basenova.Catalogos_ctTipoCredito.AsNoTracking().ToList();
                basenova.Database.Connection.Close();
            }
        }

        

            private void setIncidenciaSaldos()
        {


             
                //using (var basenova = new bdNovaEntities())
                //{
                //    basenova.Database.Connection.Open();
                //    Nomina_IncidenciasSaldosBd = basenova.Nomina_IncidenciasSaldos
                //        .AsNoTracking().Where(s => s.Saldo > 0)
                //        .Include(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                //       .Include(s => s.IncidenciaPermiso_stIncidenciaTrabajador.Catalogos_ctTipoIncidencia)

                //        .ToList();


                //    basenova.Database.Connection.Close();
                //}


            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = $@"SELECT
        s.*, 
        c1.*, 
        c2.*, 
        i.*, 
        t.*,
	n.*
    FROM
        Nomina_IncidenciasSaldos s
inner JOIN
        IncidenciaPermiso_stIncidenciaTrabajador i ON s.IdIncidenciaTrabajador = i.IdIncidenciaTrabajador
    inner JOIN
        Convenios_stConvenioLaboralTrabajadorCategoria c1 ON s.IdConvenioLaboralTrabajadorCategoria = c1.IdConvenioLaboralTrabajadorCategoria
    inner  JOIN
        Convenios_stConvenioLaboralTrabajador c2 ON c1.IdConvenioLaboralTrabajador = c2.IdConvenioLaboralTrabajador
    inner  JOIN
        Catalogos_ctTipoIncidencia t ON i.IdTipoIncidencia = t.IdTipoIncidencia
	inner join Nomina_stNomina n on n.IdNomina=s.Idnomina
    WHERE 
        s.Saldo > 0";

            Nomina_IncidenciasSaldosBd = dp.connection.Query<Nomina_IncidenciasSaldos, Convenios_stConvenioLaboralTrabajadorCategoria, Convenios_stConvenioLaboralTrabajador, IncidenciaPermiso_stIncidenciaTrabajador, Catalogos_ctTipoIncidencia, Nomina_stNomina, Nomina_IncidenciasSaldos>(
        query,
        (s, c1, c2, i, t,n) =>
        {
            s.Convenios_stConvenioLaboralTrabajadorCategoria = c1;
            c1.Convenios_stConvenioLaboralTrabajador = c2;
            s.IncidenciaPermiso_stIncidenciaTrabajador = i;
            i.Catalogos_ctTipoIncidencia = t;
            s.Nomina_stNomina = n;
            return s;
        },
        splitOn: "IdConvenioLaboralTrabajadorCategoria,IdConvenioLaboralTrabajador,IdIncidenciaTrabajador,IdTipoIncidencia,IdNomina"
    ).ToList();


        }
        private List<Configuracion_ctCesantiayVejez> getCensantiaYVejez()
        {
            //DateTime FechaActual = System.DateTime.Now;
            DateTime FechaActual = this.Nomina_stNomina.FechaTermino;
            DateTime FechaInicioNomina = this.Nomina_stNomina.FechaInicio;

            if (Configuracion_ctCesantiayVejez == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    Configuracion_ctCesantiayVejez = basenova.Configuracion_ctCesantiayVejez.Where(
                    s => s.FechaInicio <= FechaInicioNomina && s.FechaTermino >= FechaInicioNomina).ToList();
                    basenova.Database.Connection.Close();
                }

            return Configuracion_ctCesantiayVejez;


        }

        public  decimal ObtenerPorcentajeCesantiayVejez( decimal sdi)
        {
            sdi = Math.Round(sdi / this.ctUMA.Monto,2);
            var registro = Configuracion_ctCesantiayVejez.FirstOrDefault(r => sdi >= r.SdiUmaDesde && sdi <= r.SdiUmaHasta && this.Nomina_stNomina.FechaTermino >= r.FechaInicio && this.Nomina_stNomina.FechaTermino <= r.FechaTermino);
            if (registro != null)
            {
                return registro.Porcentaje/100;
            }
            else
            {
                throw new Exception("No se encontró un registro correspondiente.");
            }
        }
        private Catalogos_ctUnidadMixtaInfonavit getUMI()
        {
            //DateTime FechaActual = System.DateTime.Now;
            DateTime FechaActual = this.Nomina_stNomina.FechaTermino;
            DateTime FechaInicioNomina = this.Nomina_stNomina.FechaInicio;

            if (ctUMI == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    ctUMI = basenova.Catalogos_ctUnidadMixtaInfonavit.AsNoTracking().Where(
                    s => s.FechaInicio <= FechaInicioNomina && s.FechaTermino >= FechaInicioNomina).OrderByDescending(a => a.IdUnidadMixtaInfonavit).FirstOrDefault();

                    ctUMIHistorial = basenova.Catalogos_ctUnidadMixtaInfonavit.AsNoTracking().ToList();
                    basenova.Database.Connection.Close();
                   
                }
            return ctUMI;
        }

        private void setUMA()
        {
            ctUMA = this.getUMA();
            if (ctUMA == null)
                throw new ApplicationException("No hay catálogo de UMA configurados en el sistema");
        }

        private Catalogos_ctUnidadMedidaActualizacion getUMA()
        {
            //DateTime FechaActual = System.DateTime.Now;
            DateTime FechaActual = this.Nomina_stNomina.FechaTermino;

            DateTime FechaInicioNomina = this.Nomina_stNomina.FechaInicio;


            if (ctUMA == null)
                //    ctUMA = db.Catalogos_ctUnidadMedidaActualizacion.Where(s =>
                //   FechaInicioNomina >= s.FechaInicio && s.FechaTermino >= FechaActual).SingleOrDefault();
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    ctUMA = basenova.Catalogos_ctUnidadMedidaActualizacion.AsNoTracking().Where(s =>
                 s.FechaInicio <= FechaInicioNomina && s.FechaTermino >= FechaActual).OrderByDescending(a => a.IdUnidadMedidaActualizacion).FirstOrDefault();
                    basenova.Database.Connection.Close();
                }
            return ctUMA;
        }

        //Salario Mínimo

        private void setSalarioMinimoDF()
        {
            SalarioMinimoDF = this.getSalarioMinimoDF();
            if (SalarioMinimoDF == null)
                throw new ApplicationException("No hay catálogo de salarios mínimos configurados en el sistema");
        }
        private Catalogos_ctSalarioMinimo getSalarioMinimoDF()
        {
            //DateTime FechaActual = FechaInicio;
            DateTime FechaActual = this.Nomina_stNomina.FechaTermino;

            DateTime FechaInicioNomina = this.Nomina_stNomina.FechaInicio;


            if (SalarioMinimoDF == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    SalarioMinimoDF = basenova.Catalogos_ctSalarioMinimo.AsNoTracking().Where(s =>
                s.Catalogos_ctZonaSalarioMinimo.ZonaSalarioMinimo == "ÚNICA"
                && FechaInicioNomina >= s.FechaInicio && s.FechaTermino >= FechaActual).SingleOrDefault();

                    basenova.Database.Connection.Close();
                }
            return SalarioMinimoDF;
        }

        //Período Salario Diario Integrado


        private void setPeriodoSalarioDiarioIntegradoTrabajador(int IdConvenioLaboral)
        {
            PeriodoSalarioDiarioIntegradoTrabajador = this.getPeriodoSalarioDiarioIntegrado().Where(p => p.IdConvenioLaboral == IdConvenioLaboral).SingleOrDefault();
            if (PeriodoSalarioDiarioIntegradoTrabajador == null)
                throw new ApplicationException("No hay períodos de salario diario integrado configurados en el sistema");


        }

        private List<Catalogos_ctPeriodoSalarioDiarioIntegrado> getPeriodoSalarioDiarioIntegrado()
        {
            if (PeriodoSalarioDiarioIntegrado == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    PeriodoSalarioDiarioIntegrado = basenova.Catalogos_ctPeriodoSalarioDiarioIntegrado.AsNoTracking()
                        .Where(sdi => sdi.EsVigente == true).ToList();
                    basenova.Database.Connection.Close();
                }
            return PeriodoSalarioDiarioIntegrado;
        }

        DateTime FechaActual = System.DateTime.Now;
        //Creditos 

        public void setParametrosCreditosTrabajador(int IdTrabajador)
        {
            CreditosTrabajador = this.getParametrosCreditosTrabajadores().Where(c => c.IdTrabajador == IdTrabajador).ToList();


        }

        private List<Creditos_stCreditoTrabajador> getParametrosCreditosTrabajadores()
        {

            var fi = this.Nomina_stNomina.FechaInicio;
            var ft = this.Nomina_stNomina.FechaTermino;

          

            if (ParametrosCreditosTrabajadores == null)

            {
                DapperQuery dp = new DapperQuery("bdNovaEntities");
                string query = $@"
    SELECT
        a.IdCreditoTrabajador, a.IdTrabajador, a.IdTipoCredito, a.VecesSalarioMinimo, a.CuotaFija, a.Porcentaje, a.FechaInicioCredito, a.FechaInicioDescuento, a.FechaTermino, a.ImporteCredito, a.Parcialidades, a.Saldo,
        a.ParcialidadesPagadas, a.NumeroCredito, a.IdEmpleado, a.NoFonacot, a.IdCreditoTipoDescuento, a.EsAplicado, a.EsParaDevolucion, a.EsYaDevuelto, a.IdCreditoTrabajadorFactor, a.AjusteFactorAplicado,
        a.EsAjustetSaldoInsuficiente, a.SoloDescuentoEnAguinaldo,b.IdCreditoTipoDescuento AS Id, b.CreditoTipoDescuento, c.IdTipoCredito AS IdTc, c.TipoCredito, c.IdDeduccion, c.Orden, d.IdDeduccion AS idd, d.Deduccion
    FROM
        dbo.Creditos_stCreditoTrabajador AS a
    INNER JOIN
        dbo.Creditos_ctCreditoTipoDescuento AS b ON a.IdCreditoTipoDescuento = b.IdCreditoTipoDescuento
    INNER JOIN
        dbo.Catalogos_ctTipoCredito AS c ON a.IdTipoCredito = c.IdTipoCredito
    INNER JOIN
        dbo.Deducciones_ctDeduccion AS d ON c.IdDeduccion = d.IdDeduccion where
((a.FechaInicioDescuento <='{fi.ToString("yyyyMMdd")}' and a.FechaTermino>'{fi.ToString("yyyyMMdd")}' ) 
or (a.FechaInicioDescuento <='{fi.ToString("yyyyMMdd")}' and a.FechaTermino is null )
or (a.EsParaDevolucion=1 and a.EsYaDevuelto=0 and  a.FechaTermino is not null)) order by a.IdTrabajador,c.orden,a.FechaInicioCredito";

                var creditos = dp.connection.Query<Creditos_stCreditoTrabajador, Creditos_ctCreditoTipoDescuento, Catalogos_ctTipoCredito, Deducciones_ctDeduccion, Creditos_stCreditoTrabajador>(
                    query,
                    (credito, tipoDescuento, tipoCredito, deduccion) =>
                    {
                        credito.Creditos_ctCreditoTipoDescuento = tipoDescuento;
                        credito.Catalogos_ctTipoCredito = tipoCredito;
                        tipoCredito.Deducciones_ctDeduccion = deduccion;
                        return credito;
                    },
                    splitOn: "Id, IdTc, idd"
                );


                ParametrosCreditosTrabajadores = (List<Creditos_stCreditoTrabajador>)creditos;

                string querys = @"select * FROM Creditos_stCreditoTrabajador
  where Parcialidades>0 and Parcialidades is not null
  and (Parcialidades<=ParcialidadesPagadas)";


                var creditosterminadosporparcialidades = (List<Creditos_stCreditoTrabajador>)dp.connection.Query<Creditos_stCreditoTrabajador>(querys);
                dp.Close();



                foreach (var item in creditosterminadosporparcialidades)
                {
                    ParametrosCreditosTrabajadores.Remove(item);
                }

                using (var dbContext = new bdNovaEntities())
                {
                    dbContext.Database.Connection.Open();

                    ListaCreditosDescontadosOtrasNominas = dbContext.Creditos_stNominaCreditoTrabajador.AsNoTracking()
                    .Include(a => a.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                    .Include(a => a.Nomina_stNominaTrabajador.Nomina_stNomina)
                    .Include(a => a.Nomina_stNominaTrabajador)
                    .Include(a => a.Creditos_stCreditoTrabajador)
                    .Where(s => s.Nomina_stNominaTrabajador.Nomina_stNomina.FechaInicio == fi
                  && s.Nomina_stNominaTrabajador.Nomina_stNomina.FechaTermino == ft
                  && s.Nomina_stNominaTrabajador.Nomina_stNominaTrabajadorEstatus.Nomina_stNominaTrabajadorEstatusGrupo.EstatusNominaGrupo== "PARA PAGO"
                  ).ToList();

                    dbContext.Database.Connection.Close();
                }

            }
                return ParametrosCreditosTrabajadores;
        }

        //PENSIONES

        public void setPensionesTrabajador(int IdTrabajador)
        {
            PensionesTrabajador = this.getPensionesTrabajadores().Where(p => p.IdTrabajador == IdTrabajador).ToList();
        }

        private List<Pensiones_stPensionesTrabajador> getPensionesTrabajadores()
        {

            var fi = this.Nomina_stNomina.FechaInicio;
            var ft = this.Nomina_stNomina.FechaTermino;


            if (PensionesTrabajadores == null)
                using (var dbContext = new bdNovaEntities())
                {
                    dbContext.Database.Connection.Open();

                    PensionesTrabajadores = dbContext.Pensiones_stPensionesTrabajador.Where(ct =>
                        (ct.FechaInicio <= fi && ct.FechaTermino >= fi) || (ct.FechaInicio <= fi && ct.FechaTermino == null)).ToList();


                    dbContext.Database.Connection.Close();
                }

            return PensionesTrabajadores;
        }

        //Quincenas Mes

        private void setQuincenaMes()
        {
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                CatalogoQuincenaMes = basenova.Catalogos_ctQuincenaMes.Where(c => c.IdMes != 0).ToList();
                basenova.Database.Connection.Close();
            }
            if (CatalogoQuincenaMes.Count == 0)
                throw new ApplicationException("No hay catálogos de quincena mes configrados en el sistema");
        }



        private void setPremioAntiguedadPagados()
        {
            DapperQuery dp = new DapperQuery("bdNovaEntities");


            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                ListaPremioAntiguedadPagados = basenova.Percepciones_stNominaTrabajadorPercepciones.AsNoTracking().Where(v => v.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepcion == "PREMIO DE ANTIGUEDAD" && v.Nomina_stNominaTrabajador.Nomina_stNomina.Año == DateTime.Now.Year).Select(b => b.Nomina_stNominaTrabajador).ToList();

            }

            using (var basenova = new bdNovaEntities())
            {
                 ListaEstimuloAntiguedadPagados = basenova.Percepciones_stNominaTrabajadorPercepciones.AsNoTracking().Where(v => v.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepcion == "ESTÍMULO DE ANTIGUEDAD" && v.Nomina_stNominaTrabajador.Nomina_stNomina.Año == DateTime.Now.Year).Select(b => b.Nomina_stNominaTrabajador).ToList();
                basenova.Database.Connection.Close();
            }

            string datos = @" SELECT  
      IdConvenioLaboralTrabajadorCategoria,Años,Meses,Dias 
  FROM vwDatosAspirantesTrabajadores 
    where EstatusTrabajador<>'PROXIMAMENTE' and (Años=10 and meses =0 and Dias>15) or (Años=15 and meses =0 and Dias>15)
  or (Años=20 and meses =0 and Dias>15) and ConvenioLaboral='BASE'";

            ListaPremioAntiguedadTrabajadores = (List<AntiguedadTrabajador>)dp.connection.Query<AntiguedadTrabajador>(datos);
            dp.Close();
        }

        private List<Percepciones_stNominaTrabajadorPercepciones> setNominaTrabajadorPercepciones(int IdTrabajador)
        {
            //int Año = Nomina.Año;
            NominaTrabajadorPercepciones = getNominaTrabajadoresPercepciones().Where(x => x.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == IdTrabajador).ToList();

            return NominaTrabajadorPercepciones;
        }

        // Percepciones Gravadas en nóminas anteriores
        private List<Percepciones_stNominaTrabajadorPercepciones> getNominaTrabajadoresPercepciones()
        {
            int Año = Nomina.Año;
            if (NominaTrabajadoresPercepciones == null)
                using (var basenova = new bdNovaEntities())
                {
                    basenova.Database.Connection.Open();
                    NominaTrabajadoresPercepciones = basenova.Percepciones_stNominaTrabajadorPercepciones.AsNoTracking()
                        .Where(x => x.Nomina_stNominaTrabajador.Nomina_stNomina.EsCerrada == true && x.Nomina_stNominaTrabajador.Nomina_stNomina.Año >= (Año - 1)).ToList();
                    basenova.Database.Connection.Close();
                }
            return NominaTrabajadoresPercepciones;
        }


        //Para caluclo de ISR
        public void setNominaTrabajadoresPercepcionesDelMes()
        {
            int Año = (short)Nomina.FechaTermino.Year;
            short Mes = (short)Nomina.FechaTermino.Month;

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string condicion = $"   dd.Orden<{this.Nomina_stNomina.Nomina_ctPlantillaNomina.Orden} and ";
            string condicioncct = "";

            string condipago = " AND m.TipoCalculo='NORMAL'";
            string Id = this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes;

            if (Convert.ToInt16(Id) % 2 == 0)
            {
                condipago = "";
                condicion = "";
            }
            
                if (this.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO" ||
                this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla== "BASE PRIMA VACACIONAL GASTO ADMINISTRATIVO")
            {
                condicion = $"   dd.Orden<{this.Nomina_stNomina.Nomina_ctPlantillaNomina.OrdenCalculoRetroactivo} and ";

            }

            bool todaslasnominas = false;

            if (this.EsRecalculoPorTrabajador)
            {
                condicion = "  c.idnomina<>" + this.IdNomina + " and ";
                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT")
                    || ((this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("BASE")
                    || this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SPD")) &&
                     this.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO") )
                {
                    condicioncct = "  c.idnomina<>" + this.IdNomina + " and ";
                    todaslasnominas = true;
                }

            }
            else
                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT") 
               
                    || ((this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("BASE")
                    || this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SPD")) &&
                     this.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO"))
            {
                condicioncct = "  c.idnomina<>" + this.IdNomina + " and ";
                todaslasnominas = true;
            }


            string query = @" select b.IdConvenioLaboralTrabajadorCategoria,r.IdTrabajador,f.IdPercepcion,e.idPlantillaNominaPercepcion,a.Importe
,dd.Plantilla,ss.QuincenaMes,b.BaseGravable
from  Percepciones_stNominaTrabajadorPercepciones a
 inner join Nomina_stNominaTrabajador b on a.idNominatrabajador=b.idNominatrabajador
 inner join Convenios_stConvenioLaboralTrabajadorCategoria q on q.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador r on r.IdConvenioLaboralTrabajador =q.IdConvenioLaboralTrabajador
 inner join Nomina_stNomina c on c.idnomina=b.idnomina
 inner join Nomina_stNominaTrabajadorEstatus d on b.idnominatrabajadorEstatus=d.idnominatrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=d.IdNominaTrabajadorEstatusGrupo
 inner join Percepciones_stPlantillaNominaPercepciones e on e.idPlantillaNominaPercepcion=a.idPlantillaNominaPercepcion 
 inner join Percepciones_ctPercepcion f on f.idpercepcion=e.idpercepcion 
inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=c.IdTipoCalculo
 inner join Nomina_ctPlantillaNomina dd on dd.IdPlantillaNomina=e.IdPlantillaNomina
 inner join  Catalogos_ctQuincenaMes ss on ss.IdQuincenaMes=c.IdQuincenaMes
 where Plantilla not like '%AGUINALDO%' and 
EstatusNominaGrupo ='PARA PAGO' and f.esgravable=1 " + condipago +@" and  year(c.FechaTermino)=" + Año + " and MONTH(c.FechaTermino)=" + Mes + @"
and " + condicion + @" a.IdNominaTrabajadorPercepcion not in(
  select a.IdNominaTrabajadorPercepcion
from  Percepciones_stNominaTrabajadorPercepciones a
 inner join Nomina_stNominaTrabajador b on a.idNominatrabajador=b.idNominatrabajador
 inner join Convenios_stConvenioLaboralTrabajadorCategoria q on q.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador r on r.IdConvenioLaboralTrabajador =q.IdConvenioLaboralTrabajador
 inner join Nomina_stNomina c on c.idnomina=b.idnomina
 inner join Nomina_stNominaTrabajadorEstatus d on b.idnominatrabajadorEstatus=d.idnominatrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=d.IdNominaTrabajadorEstatusGrupo
 inner join Percepciones_stPlantillaNominaPercepciones e on e.idPlantillaNominaPercepcion=a.idPlantillaNominaPercepcion 
 inner join Percepciones_ctPercepcion f on f.idpercepcion=e.idpercepcion 
inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=c.IdTipoCalculo
 inner join Nomina_ctPlantillaNomina dd on dd.IdPlantillaNomina=e.IdPlantillaNomina
 inner join  Catalogos_ctQuincenaMes ss on ss.IdQuincenaMes=c.IdQuincenaMes
 where Plantilla not like '%AGUINALDO%' and EstatusNominaGrupo ='PARA PAGO' and f.esgravable=1 AND m.TipoCalculo='NORMAL' and 
  year(c.FechaTermino)=" + Año + " and MONTH(c.FechaTermino)=" + Mes + @"
    and ( F.Percepcion LIKE '%DEVOLU%'
   AND A.Concepto IN (select TipoCredito from Catalogos_ctTipoCredito) )
  )
and ((a.concepto  in(select percepcion  from Percepciones_ctPercepcion xx where 
  xx.EsGravable=1) 
  or a.Concepto='' 
  ) OR a.Concepto LIKE	 '%falta%' )";


            this.stNominaTrabajadorPercepcionesdelMes = (List<PercepcionesTrabajadorMes>)dp.connection.Query<PercepcionesTrabajadorMes>(query);


              query = @" select b.IdConvenioLaboralTrabajadorCategoria,r.IdTrabajador,f.IdPercepcion,e.idPlantillaNominaPercepcion,a.Importe
,dd.Plantilla,ss.QuincenaMes,b.BaseGravable
from  [Percepciones_stNominaTrabajadorPercepcionesViaticos] a
 inner join Nomina_stNominaTrabajador b on a.idNominatrabajador=b.idNominatrabajador
 inner join Convenios_stConvenioLaboralTrabajadorCategoria q on q.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador r on r.IdConvenioLaboralTrabajador =q.IdConvenioLaboralTrabajador
 inner join Nomina_stNomina c on c.idnomina=b.idnomina
 inner join Nomina_stNominaTrabajadorEstatus d on b.idnominatrabajadorEstatus=d.idnominatrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=d.IdNominaTrabajadorEstatusGrupo
 inner join Percepciones_stPlantillaNominaPercepciones e on e.idPlantillaNominaPercepcion=a.idPlantillaNominaPercepcion 
 inner join Percepciones_ctPercepcion f on f.idpercepcion=e.idpercepcion 
inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=c.IdTipoCalculo
 inner join Nomina_ctPlantillaNomina dd on dd.IdPlantillaNomina=e.IdPlantillaNomina
 inner join  Catalogos_ctQuincenaMes ss on ss.IdQuincenaMes=c.IdQuincenaMes
 where 
EstatusNominaGrupo ='PARA PAGO' and f.esgravable=1 " + condipago + @" and  year(c.FechaTermino)=" + Año + " and MONTH(c.FechaTermino)=" + Mes ;

            ListaPercepcionesTrabajadoresViaticosDelMes = (List<PercepcionesTrabajadorMes>)dp.connection.Query<PercepcionesTrabajadorMes>(query);

            //if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
            if ( todaslasnominas)
            {

                  query = @" select b.IdConvenioLaboralTrabajadorCategoria,r.IdTrabajador,f.IdPercepcion,e.idPlantillaNominaPercepcion,a.Importe
,dd.Plantilla,ss.QuincenaMes,b.BaseGravable,f.BasePrimaria
from  Percepciones_stNominaTrabajadorPercepciones a
 inner join Nomina_stNominaTrabajador b on a.idNominatrabajador=b.idNominatrabajador
 inner join Convenios_stConvenioLaboralTrabajadorCategoria q on q.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador r on r.IdConvenioLaboralTrabajador =q.IdConvenioLaboralTrabajador
 inner join Nomina_stNomina c on c.idnomina=b.idnomina
 inner join Nomina_stNominaTrabajadorEstatus d on b.idnominatrabajadorEstatus=d.idnominatrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=d.IdNominaTrabajadorEstatusGrupo
 inner join Percepciones_stPlantillaNominaPercepciones e on e.idPlantillaNominaPercepcion=a.idPlantillaNominaPercepcion 
 inner join Percepciones_ctPercepcion f on f.idpercepcion=e.idpercepcion 
inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=c.IdTipoCalculo
 inner join Nomina_ctPlantillaNomina dd on dd.IdPlantillaNomina=e.IdPlantillaNomina
 inner join  Catalogos_ctQuincenaMes ss on ss.IdQuincenaMes=c.IdQuincenaMes
 where 
EstatusNominaGrupo ='PARA PAGO' "+condipago+@"  and year(c.FechaTermino)=" + Año + " and MONTH(c.FechaTermino)=" + Mes + @"
and " + condicioncct + @" a.IdNominaTrabajadorPercepcion not in(
  select a.IdNominaTrabajadorPercepcion
from  Percepciones_stNominaTrabajadorPercepciones a
 inner join Nomina_stNominaTrabajador b on a.idNominatrabajador=b.idNominatrabajador
 inner join Convenios_stConvenioLaboralTrabajadorCategoria q on q.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador r on r.IdConvenioLaboralTrabajador =q.IdConvenioLaboralTrabajador
 inner join Nomina_stNomina c on c.idnomina=b.idnomina
 inner join Nomina_stNominaTrabajadorEstatus d on b.idnominatrabajadorEstatus=d.idnominatrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=d.IdNominaTrabajadorEstatusGrupo
 inner join Percepciones_stPlantillaNominaPercepciones e on e.idPlantillaNominaPercepcion=a.idPlantillaNominaPercepcion 
 inner join Percepciones_ctPercepcion f on f.idpercepcion=e.idpercepcion 
inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=c.IdTipoCalculo
 inner join Nomina_ctPlantillaNomina dd on dd.IdPlantillaNomina=e.IdPlantillaNomina
 inner join  Catalogos_ctQuincenaMes ss on ss.IdQuincenaMes=c.IdQuincenaMes
 where EstatusNominaGrupo ='PARA PAGO'  "+condipago+@"  and 
  year(c.FechaTermino)=" + Año + " and MONTH(c.FechaTermino)=" + Mes + @"
    and ( F.Percepcion LIKE '%DEVOLU%'
   AND A.Concepto IN (select TipoCredito from Catalogos_ctTipoCredito) )
  )";


                this.stNominaTrabajadorPercepcionesdelMesCCT = (List<PercepcionesTrabajadorMes>)dp.connection.Query<PercepcionesTrabajadorMes>(query);


            }
            query = @" select b.IdNominaTrabajador, b.IdConvenioLaboralTrabajadorCategoria,r.IdTrabajador,
dd.Plantilla,ss.QuincenaMes
,b.BaseGravable
from  Nomina_stNominaTrabajador b 
 inner join Convenios_stConvenioLaboralTrabajadorCategoria q on q.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador r on r.IdConvenioLaboralTrabajador =q.IdConvenioLaboralTrabajador
 inner join Nomina_stNomina c on c.idnomina=b.idnomina
 inner join Nomina_stNominaTrabajadorEstatus d on b.idnominatrabajadorEstatus=d.idnominatrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=d.IdNominaTrabajadorEstatusGrupo 
inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=c.IdTipoCalculo
 inner join Nomina_ctPlantillaNomina dd on dd.IdPlantillaNomina=c.IdPlantillaNomina
 inner join  Catalogos_ctQuincenaMes ss on ss.IdQuincenaMes=c.IdQuincenaMes
 where " + condicion  + @"
EstatusNominaGrupo ='PARA PAGO' "+condipago+@" and  year(c.FechaTermino)=" + Año + @"  and 
MONTH(c.FechaTermino)=" + Mes ;

            this.stNominaTrabajadorBasesGravabelesdelMes = (List<BaseGravableTrabajadorMes>)dp.connection.Query<BaseGravableTrabajadorMes>(query);


            query = @" select b.IdConvenioLaboralTrabajadorCategoria,r.IdTrabajador,f.IdPercepcion,e.idPlantillaNominaPercepcion,a.Importe*-1 as Importe
,dd.Plantilla,ss.QuincenaMes
from  Percepciones_stNominaTrabajadorPercepciones a
 inner join Nomina_stNominaTrabajador b on a.idNominatrabajador=b.idNominatrabajador
 inner join Convenios_stConvenioLaboralTrabajadorCategoria q on q.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador r on r.IdConvenioLaboralTrabajador =q.IdConvenioLaboralTrabajador
 inner join Nomina_stNomina c on c.idnomina=b.idnomina
 inner join Nomina_stNominaTrabajadorEstatus d on b.idnominatrabajadorEstatus=d.idnominatrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=d.IdNominaTrabajadorEstatusGrupo
 inner join Percepciones_stPlantillaNominaPercepciones e on e.idPlantillaNominaPercepcion=a.idPlantillaNominaPercepcion 
 inner join Percepciones_ctPercepcion f on f.idpercepcion=e.idpercepcion 
inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=c.IdTipoCalculo
 inner join Nomina_ctPlantillaNomina dd on dd.IdPlantillaNomina=e.IdPlantillaNomina
 inner join  Catalogos_ctQuincenaMes ss on ss.IdQuincenaMes=c.IdQuincenaMes
 where 
EstatusNominaGrupo ='PARA PAGO' and Percepcion='SUBSIDIO PARA EL EMPLEO ENTREGADO' AND m.TipoCalculo='NORMAL' and  year(c.FechaTermino)=" + Año + " and MONTH(c.FechaTermino)=" + Mes + @"
and " + condicion + @" a.IdNominaTrabajadorPercepcion not in(
  select a.IdNominaTrabajadorPercepcion
from  Percepciones_stNominaTrabajadorPercepciones a
 inner join Nomina_stNominaTrabajador b on a.idNominatrabajador=b.idNominatrabajador
 inner join Convenios_stConvenioLaboralTrabajadorCategoria q on q.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador r on r.IdConvenioLaboralTrabajador =q.IdConvenioLaboralTrabajador
 inner join Nomina_stNomina c on c.idnomina=b.idnomina
 inner join Nomina_stNominaTrabajadorEstatus d on b.idnominatrabajadorEstatus=d.idnominatrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=d.IdNominaTrabajadorEstatusGrupo
 inner join Percepciones_stPlantillaNominaPercepciones e on e.idPlantillaNominaPercepcion=a.idPlantillaNominaPercepcion 
 inner join Percepciones_ctPercepcion f on f.idpercepcion=e.idpercepcion 
inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo=c.IdTipoCalculo
 inner join Nomina_ctPlantillaNomina dd on dd.IdPlantillaNomina=e.IdPlantillaNomina
 inner join  Catalogos_ctQuincenaMes ss on ss.IdQuincenaMes=c.IdQuincenaMes
 where EstatusNominaGrupo ='PARA PAGO' and Percepcion='SUBSIDIO PARA EL EMPLEO ENTREGADO' AND m.TipoCalculo='NORMAL' and 
  year(c.FechaTermino)=" + Año + " and MONTH(c.FechaTermino)=" + Mes + @"
    and ( F.Percepcion LIKE '%DEVOLU%'
   AND A.Concepto IN (select TipoCredito from Catalogos_ctTipoCredito) )
  )";
            this.stNominaTrabajadorPercepcionesSubsidiodelMes = (List<PercepcionesTrabajadorMes>)dp.connection.Query<PercepcionesTrabajadorMes>(query);
            dp.Close();

            //para aaluclo de isr para nbominas anteriores se veriifca que existan nominas de sueldo cerrdas de las 2 quincenas


            string query2 = @"select c.FechaTermino from
Nomina_stNominaTrabajador b
 inner join Convenios_stConvenioLaboralTrabajadorCategoria q on q.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador r on r.IdConvenioLaboralTrabajador = q.IdConvenioLaboralTrabajador
 inner join Nomina_stNomina c on c.idnomina = b.idnomina
 inner join Nomina_stNominaTrabajadorEstatus d on b.idnominatrabajadorEstatus = d.idnominatrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=d.IdNominaTrabajadorEstatusGrupo
 --inner join Percepciones_stPlantillaNominaPercepciones e on e.idPlantillaNominaPercepcion = a.idPlantillaNominaPercepcion
 --inner join Percepciones_ctPercepcion f on f.idpercepcion = e.idpercepcion
inner join Nomina_ctTipoCalculo m on m.IdTipoCalculo = c.IdTipoCalculo
 inner join Nomina_ctPlantillaNomina dd on dd.IdPlantillaNomina = c.IdPlantillaNomina
 inner join  Catalogos_ctQuincenaMes ss on ss.IdQuincenaMes = c.IdQuincenaMes
 where EstatusNominaGrupo ='PARA PAGO' "+condipago+@" and Plantilla like'%SUELDO%'
 AND c.EsCerrada = 1 and
  year(c.FechaTermino)=" + Año + " and MONTH(c.FechaTermino)=" + Mes + @"
  group by c.FechaTermino";

            var nominasmes = (List<DateTime>)dp.connection.Query<DateTime>(query2);
            dp.Close();

            if (nominasmes.Count == 2)
                ExisteNominasCerradasEntodoElMes = true;
            else
                ExisteNominasCerradasEntodoElMes = false;

        }


        public void setNominaTrabajadorDeduccionesdelMes()
        {
            int Año = (short)Nomina.FechaTermino.Year;
            short Mes = (short)Nomina.FechaTermino.Month;

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string query = @" select b.IdConvenioLaboralTrabajadorCategoria,r.IdTrabajador,e.IdPlantillaNominaDeduccion,f.IdDeduccion,f.Deduccion,a.Importe, pd.Plantilla,c.EsCerrada
from  Deducciones_stNominaTrabajadorDeduccion a
 inner join Nomina_stNominaTrabajador b on a.idNominatrabajador=b.idNominatrabajador
 inner join Convenios_stConvenioLaboralTrabajadorCategoria q on q.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador r on r.IdConvenioLaboralTrabajador =q.IdConvenioLaboralTrabajador
 inner join Nomina_stNomina c on c.idnomina=b.idnomina
 inner join Nomina_stNominaTrabajadorEstatus d on b.idnominatrabajadorEstatus=d.idnominatrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=d.IdNominaTrabajadorEstatusGrupo
 inner join Deducciones_stPlantillaNominaDeducciones e on e.idPlantillaNominaDeduccion=a.idPlantillaNominaDeduccion 
 inner join Deducciones_ctDeduccion f on f.idDeduccion=e.idDeduccion 
inner join Nomina_ctPlantillaNomina pd on pd.IdPlantillaNomina=e.IdPlantillaNomina
 where EstatusNominaGrupo ='PARA PAGO' and year(c.FechaTermino)=" + Año + " and MONTH(c.FechaTermino)=" + Mes;

            this.stNominaTrabajadorDeduccionesdelMes = (List<DeduccionesTrabajadorMes>)dp.connection.Query<DeduccionesTrabajadorMes>(query);
            dp.Close();


        }

        public void setIsrDelMes()
        {
            int Año = Nomina.Año;
            short Mes = (short)Nomina.FechaTermino.Month;
            bdNovaEntities nova = new bdNovaEntities();


            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string condicion = "";
            if (this.EsRecalculoPorTrabajador)
                condicion = "  and w.idnomina <> " + this.IdNomina;
            if (Convert.ToInt16(this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes) % 2 == 0)
            {
                condicion = "";
            }
            else
                if (this.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo=="NORMAL")
                condicion = condicion + $"  and  k.Orden<{this.Nomina_stNomina.Nomina_ctPlantillaNomina.Orden} ";
            else
                condicion = condicion + $"  and  k.Orden<{this.Nomina_stNomina.Nomina_ctPlantillaNomina.OrdenCalculoRetroactivo} ";

            string query = @" select t.IdConvenioLaboralTrabajadorCategoria,r.IdTrabajador,m.IdDeduccion,m.Deduccion,Importe,w.EsCerrada,Plantilla from Deducciones_stNominaTrabajadorDeduccion x
            
            inner join Nomina_stNominaTrabajador s on s.IdNominaTrabajador=x.IdNominaTrabajador
             inner join Nomina_stNomina w on w.IdNomina=s.IdNomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria t on t.IdConvenioLaboralTrabajadorCategoria=s.IdConvenioLaboralTrabajadorCategoria
			inner join Convenios_stConvenioLaboralTrabajador r on r.IdConvenioLaboralTrabajador =t.IdConvenioLaboralTrabajador
              inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=s.IdNominaTrabajadorEstatus
    inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
            inner join Deducciones_stPlantillaNominaDeducciones c on c.IdPlantillaNominaDeduccion=x.IdPlantillaNominaDeduccion
 inner join Nomina_ctPlantillaNomina k on k.IdPlantillaNomina=c.IdPlantillaNomina
 inner join Deducciones_ctDeduccion m on m.IdDeduccion=c.IdDeduccion
            where  k.Plantilla not LIKE '%AGUINALDO%' and  year(w.FechaTermino)=" + Año + @"
            and month(w.FechaTermino)=" + Mes + @"
                 and  EstatusNominaGrupo ='PARA PAGO'
            and  Deduccion = 'ISR'" + condicion;
            stNominaTrabajadorISRdelMes = (List<DeduccionesTrabajadorMes>)dp.connection.Query<DeduccionesTrabajadorMes>(query);
            dp.Close();

        }


        public short ObtenDiasIncidenciasTrabajador()
        {
            short dias = 0;
            foreach (var incidencia in this.IncidenciaTrabajador.Where(x => x.EsAplicada == false))
            {
                if (incidencia.Catalogos_ctTipoIncidencia.EsAfectacionCalculoNomina)
                    dias++;
            }
            return dias;
        }

        public bool EsPagoOnomastico(DateTime FechaNacimiento, DateTime FechaInicioNomina, DateTime FechaFinalNomina)
        {
            bool bisiesto = false;

            int dia = 0;

            if (FechaNacimiento.Month == 2 && FechaNacimiento.Day == 29)
            {
                dia = 28;
            }
            else
                dia = FechaNacimiento.Day;


            DateTime Fecha = new DateTime(FechaInicioNomina.Year, FechaNacimiento.Month, dia);

            if ((Fecha >= FechaInicioNomina) && (Fecha <= FechaFinalNomina))
                return true;
            else
                return false;

        }



        public int DiasBimestre()
        {
            int qna =0 ;
           
                qna = System.Convert.ToInt32(Nomina.Catalogos_ctQuincenaMes.QuincenaMes);
            
          

            switch (qna)
            {
                case 1:
                case 2:
                case 3:
                case 4:
                    FechaInicialBimestreNomina = System.Convert.ToDateTime("01/11/" + (Nomina.Año - 1));
                    FechaFinalBimestreNomina = System.Convert.ToDateTime("31/12/" + (Nomina.Año - 1));
                    Intervalo = FechaFinalBimestreNomina.AddDays(1) - FechaInicialBimestreNomina;
                    return Intervalo.Days;

                case 5:
                case 6:
                case 7:
                case 8:
                    FechaInicialBimestreNomina = System.Convert.ToDateTime("01/01/" + Nomina.Año);

                    if (((Nomina.Año % 4 == 0 && Nomina.Año % 100 != 0) || Nomina.Año % 400 == 0))
                        FechaFinalBimestreNomina = System.Convert.ToDateTime("29/02/" + Nomina.Año);
                    else
                        FechaFinalBimestreNomina = System.Convert.ToDateTime("28/02/" + Nomina.Año);
                    Intervalo = FechaFinalBimestreNomina.AddDays(1) - FechaInicialBimestreNomina;
                    return Intervalo.Days;

                case 9:
                case 10:
                case 11:
                case 12:
                    FechaInicialBimestreNomina = System.Convert.ToDateTime("01/03/" + Nomina.Año);
                    FechaFinalBimestreNomina = System.Convert.ToDateTime("30/04/" + Nomina.Año);
                    Intervalo = FechaFinalBimestreNomina.AddDays(1) - FechaInicialBimestreNomina;
                    return Intervalo.Days;

                case 13:
                case 14:
                case 15:
                case 16:
                    FechaInicialBimestreNomina = System.Convert.ToDateTime("01/05/" + Nomina.Año);
                    FechaFinalBimestreNomina = System.Convert.ToDateTime("30/06/" + Nomina.Año);
                    Intervalo = FechaFinalBimestreNomina.AddDays(1) - FechaInicialBimestreNomina;
                    return Intervalo.Days;

                case 17:
                case 18:
                case 19:
                case 20:
                    FechaInicialBimestreNomina = System.Convert.ToDateTime("01/07/" + Nomina.Año);
                    FechaFinalBimestreNomina = System.Convert.ToDateTime("31/08/" + Nomina.Año);
                    Intervalo = FechaFinalBimestreNomina.AddDays(1) - FechaInicialBimestreNomina;
                    return Intervalo.Days;

                case 21:
                case 22:
                case 23:
                case 24:
                    FechaInicialBimestreNomina = System.Convert.ToDateTime("01/09/" + Nomina.Año);
                    FechaFinalBimestreNomina = System.Convert.ToDateTime("31/10/" + Nomina.Año);
                    Intervalo = FechaFinalBimestreNomina.AddDays(1) - FechaInicialBimestreNomina;
                    return Intervalo.Days;

                default:
                    return 0;

            }
        }


        public decimal Suma(List<VariablesNominaTrabajador> Lista)
        {
            decimal suma = 0M;
            foreach (var itempercep in Lista)
            {
                // Primero truncamos cada valor individual
                decimal truncated = Math.Truncate(itempercep.Importe * 100M) / 100M;
                suma += truncated;
            }
            // Aplicamos un truncado final al resultado
            return Math.Truncate(suma * 100M) / 100M;
        }

        public decimal Suma(List<DeduccionesTrabajadorMes> Lista)
        {
            decimal suma = 0M;
            foreach (var itempercep in Lista)
            {
                // Primero truncamos cada valor individual
                decimal truncated = Math.Truncate(itempercep.Importe * 100M) / 100M;
                suma += truncated;
            }
            // Aplicamos un truncado final al resultado
            return Math.Truncate(suma * 100M) / 100M;
        }

        public decimal Suma(List<Percepciones_stNominaTrabajadorPercepciones> Lista)
        {
            decimal suma = 0M;
            foreach (var itempercep in Lista)
            {
                // Primero truncamos cada valor individual
                decimal truncated = Math.Truncate(itempercep.Importe * 100M) / 100M;
                suma += truncated;
            }
            // Aplicamos un truncado final al resultado
            return Math.Truncate(suma * 100M) / 100M;
        }

        public decimal Suma(List<PensionesTrabajador> Lista)
        {
            decimal suma = 0M;
            foreach (var itempercep in Lista)
            {
                // Primero truncamos cada valor individual
                decimal truncated = Math.Truncate(itempercep.Importe * 100M) / 100M;
                suma += truncated;
            }
            // Aplicamos un truncado final al resultado
            return Math.Truncate(suma * 100M) / 100M;
        }
        public decimal Suma(List<CreditosTrabajador> Lista)
        {
            //decimal suma = 0M;
            //foreach (var itempercep in Lista)
            //{
            //    //suma = suma + Truncate(itempercep.Importe, 2);
            //    suma = suma + itempercep.Importe;
            //}

            //return suma;
            decimal suma = 0M;
            foreach (var itempercep in Lista)
            {
                // Primero truncamos cada valor individual
                decimal truncated = Math.Truncate(itempercep.Importe * 100M) / 100M;
                suma += truncated;
            }
            // Aplicamos un truncado final al resultado
            return Math.Truncate(suma * 100M) / 100M;
        }
        public decimal Suma(List<DeduccionesNominaTrabajador> Lista)
        {
            decimal suma = 0M;
            foreach (var itempercep in Lista)
            {
                // Primero truncamos cada valor individual
                decimal truncated = Math.Truncate(itempercep.Importe * 100M) / 100M;
                suma += truncated;
            }
            // Aplicamos un truncado final al resultado
            return Math.Truncate(suma * 100M) / 100M;
        }
        public decimal Suma(List<PercepcionesNominaTrabajador> Lista)
        {
            decimal suma = 0M;
            foreach (var itempercep in Lista)
            {
                // Primero truncamos cada valor individual
                decimal truncated = Math.Truncate(itempercep.Importe * 100M) / 100M;
                suma += truncated;
            }
            // Aplicamos un truncado final al resultado
            return Math.Truncate(suma * 100M) / 100M;
        }

        public decimal TruncateSDI(decimal valor, int decimales)
        {
            decimal multiplicador = (decimal)Math.Pow(10, decimales);
            return Math.Truncate(valor * multiplicador + 0.00000000001m) / multiplicador;
        }
        public decimal Truncate(decimal pImporte, int pNumDecimales)
        {
            return Math.Truncate(pImporte * 100M) / 100M;
            //decimal wRt = 0;
            //decimal wPot10 = 1;

            //for (int i = 1; i <= pNumDecimales; i++)
            //{
            //    wPot10 = wPot10 * 10;
            //}

            //wRt = pImporte * wPot10;
            //wRt = decimal.Truncate(wRt);
            //wRt = wRt / wPot10;

            //return wRt;
        }

        public int CalculaHoras(string HoraInicial, string HoraFinal)
        {
            int hours = 0;
            if (HoraInicial != null && HoraInicial != null)
            {
                if (HoraInicial.Trim() != "" && HoraFinal.Trim() != "")
                {
                    var pabaigosLaikoLaukelis = HoraFinal;
                    var pradziosLaikoLaukelis = HoraInicial;
                    var leftHours = (int)TimeSpan.Parse(pabaigosLaikoLaukelis).TotalHours;
                    var rightHours = (int)TimeSpan.Parse(pradziosLaikoLaukelis).TotalHours;

                    hours = leftHours - rightHours;
                }
                else
                {
                    hours = 0;
                }
            }
            return hours;
        }

        public void GrabarIncidenciasSaldosAuxiliares(Nomina_stNominaTrabajador trabajador)
        {



            foreach (var item in this.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_SALDO_INSERT" && v.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria))
            {
                Nomina_IncidenciasSaldosAuxiliar cr = new Nomina_IncidenciasSaldosAuxiliar();
                cr.IdConvenioLaboralTrabajadorCategoria = trabajador.IdConvenioLaboralTrabajadorCategoria;
                cr.IdNomina = this.Nomina_stNomina.IdNomina;
                cr.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                cr.Saldo = item.Importe;
                cr.Total = item.Importe;

                var DIASIncidencias = this.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_DIAS_SALDO_INSERT" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                && v.IdIncidenciaTrabajador == item.IdIncidenciaTrabajador).FirstOrDefault();

                if (DIASIncidencias != null)
                {
                    cr.DiasSaldo= (int)DIASIncidencias.Importe;
                    cr.DiasTotales = (int)DIASIncidencias.Importe;
                }


                this.ListaNomina_IncidenciasSaldosAuxiliar.Add(cr);


            }

            //foreach (var item in this.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_SALDO_UPDATE" && v.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria))
            //{
            //    Nomina_IncidenciasSaldosAuxiliar cr = new Nomina_IncidenciasSaldosAuxiliar();
            //    cr.IdConvenioLaboralTrabajadorCategoria = trabajador.IdConvenioLaboralTrabajadorCategoria;
            //    cr.IdNomina = this.Nomina_stNomina.IdNomina;
            //    cr.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
            //    cr.Saldo = item.Importe;




            //    this.ListaNomina_IncidenciasSaldosAuxiliar.Add(cr);


            //}

        }
        public void GrabarIncidenciasSaldos(Nomina_stNominaTrabajador trabajador)
        {



            foreach (var item in this.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_SALDO_INSERT" && v.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria))
            {
                Nomina_IncidenciasSaldos cr = new Nomina_IncidenciasSaldos();
                cr.IdConvenioLaboralTrabajadorCategoria = trabajador.IdConvenioLaboralTrabajadorCategoria;
                cr.IdNomina = this.Nomina_stNomina.IdNomina;
                cr.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                cr.Saldo = item.Importe;
                cr.Total = item.Importe;


                var DIASIncidencias = this.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_DIAS_SALDO_INSERT" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                && v.IdIncidenciaTrabajador == item.IdIncidenciaTrabajador).FirstOrDefault();

                if (DIASIncidencias != null)
                {
                    cr.DiasSaldo = (int)DIASIncidencias.Importe;
                    cr.DiasTotales = (int)DIASIncidencias.Importe;
                }

                this.ListaNomina_IncidenciasSaldos.Add(cr);


            }

            foreach (var item in this.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_SALDO_UPDATE" && v.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria))
            {
                Nomina_IncidenciasSaldos cr = new Nomina_IncidenciasSaldos();
                cr.IdConvenioLaboralTrabajadorCategoria = trabajador.IdConvenioLaboralTrabajadorCategoria;
                cr.IdNomina = this.Nomina_stNomina.IdNomina;
                cr.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                cr.Saldo = item.Importe;

                var DIASIncidencias = this.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_DIAS_SALDO_UPDATE" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
               && v.IdIncidenciaTrabajador == item.IdIncidenciaTrabajador).FirstOrDefault();

                if (DIASIncidencias != null)
                {
                    cr.DiasSaldo = (int)DIASIncidencias.Importe;
                  
                }


                this.ListaNomina_IncidenciasSaldosActualizar.Add(cr);


            }

        }
        public void GrabarCreditos(Nomina_stNominaTrabajador trabajador)
        {

            foreach (var item in this.ListaCreditosTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria))
            {
                Creditos_stNominaCreditoTrabajador cr = new Creditos_stNominaCreditoTrabajador();
                cr.IdCreditoTrabajador = item.IdCreditoTrabajador;
                cr.IdNominaTrabajador = trabajador.IdNominaTrabajador;
                cr.Importe = item.Importe;
                cr.EsAjuste = item.EsAjuste;




                if (item.Saldo > 0 || item.EsAjustetSaldoInsuficiente )
                {

                    Creditos_stCreditoTrabajador creditoInformacion = new Creditos_stCreditoTrabajador();
                    creditoInformacion.IdCreditoTrabajador = item.IdCreditoTrabajador;
                    creditoInformacion.Saldo = item.Saldo;
                    creditoInformacion.EsAplicado = true;
                    creditoInformacion.EsYaDevuelto = true;
                    this.CreditosDelTrabajadorSaldos.Add(creditoInformacion);
                }
                else
                    if (item.ParcialidadesPagadas > 0)
                {
                    Creditos_stCreditoTrabajador creditoInformacion = new Creditos_stCreditoTrabajador();
                    creditoInformacion.IdCreditoTrabajador = item.IdCreditoTrabajador;
                    creditoInformacion.ParcialidadesPagadas = item.ParcialidadesPagadas;
                    this.CreditosDelTrabajadorSaldos.Add(creditoInformacion);
                }


                this.CreditosDelTrabajador.Add(cr);


            }


          

        }

        public void GrabarCreditosNoAplicados(Nomina_stNominaTrabajador trabajador)
        {

            foreach (var item in this.ListaCreditosTrabajadorNoAplicados.Where(v => v.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria))
            {
                Creditos_stNominaCreditoTrabajadorNoAplicados cr = new Creditos_stNominaCreditoTrabajadorNoAplicados();
                cr.IdCreditoTrabajador = item.IdCreditoTrabajador;
                cr.IdNominaTrabajador = trabajador.IdNominaTrabajador;
                cr.Importe = item.Importe;
                cr.EsAjuste = item.EsAjuste;
                cr.Motivo = item.Motivo;




                this.CreditosDelTrabajadorNoAplicados.Add(cr);


            }

        }

        public void ActualizarPartesProporcionales(List<Nomina_stNominaTrabajador> trabajadores, DapperQuery dp)
        {

          
            var universoides = trabajadores.Where(s => Nomina_PartesProporcionales.Select(a => a.IdTrabajador).Contains(s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador)).ToList();
            foreach (var item in universoides)
            {

                dp.connection.Execute("update Nomina_PartesProporcionales  set IdNominaTrabajador= " + item.IdNominaTrabajador + " where IdNominaTrabajador is null  and idtrabajador=" + item.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + " ", null);
            }



            dp.Close();


        }

        public void ActualizarPrestacionesAdicionales(List<Nomina_stNominaTrabajador> trabajadores, DapperQuery dp)
        {


            var universoides = trabajadores.Where(s => PrestacionesAdicionales.Select(a => a.Idtrabajador).Contains(s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador)).ToList();
            foreach (var item in universoides)
            {

                dp.connection.Execute("update Nomina_PrestacionesAdicionales  set IdNominaTrabajador= " + item.IdNominaTrabajador + " where IdNominaTrabajador is null  and idtrabajador=" + item.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + " ", null);
            }



            dp.Close();


        }

        public void ActualizarIncapacidades(List<Nomina_stNominaTrabajador> trabajador, DapperQuery dp)
        {
            if (Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
            {
                var incapacidades = this.PlantillaNominaDeducciones.Where(q => q.Deducciones_ctDeduccion.Deduccion.Contains("INCAPACIDAD")).Select(q => q.IdPlantillaNominaDeduccion).ToList();
                var trabajdoresconvenios = this.ListaDeduccionesTrabajadores.Where(s => incapacidades.Contains(s.IdPlantillaNominaDeduccion)).ToList();
                //var universo = trabajador.Where(a => trabajdoresconvenios.Contains(a.IdConvenioLaboralTrabajadorCategoria)).ToList();

                foreach (var item in trabajdoresconvenios)
                {
                    var trab = trabajador.Where(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                    var inci = this.ListaVariablesNominaTrabajador.Where(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                    && a.Concepto.Contains("INCIDENCIA_SALDO") && a.IdIncidenciaTrabajador > 0).FirstOrDefault();
                    if (inci != null)
                    {
                        dp.connection.Execute("update IncidenciaPermiso_stIncidenciaTrabajador set EsAplicada=1, IdNominaTrabajador = " + trab.IdNominaTrabajador + "  where IdIncidenciaTrabajador=" + inci.IdIncidenciaTrabajador + " and idtipoincidencia in (4,5,6) ", null);
                    }

                }
            }
        }
            public void ActualizarFaltasPrimaDiasDescansoAplicadas(Nomina_stNominaTrabajador trabajador, DapperQuery dp)
        {
            var idt = trabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
            //agrega las incapacidades activas a la bitacora
            if (this.LicenciasTrabajadoresIncapacidades.Count > 0
             && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
            {
                foreach (var item in LicenciasTrabajadoresIncapacidades)
                {

                    dp.connection.Execute("insert into Nomina_stNominaIncidenciasTrabajadorAplicadas  (IdNomina,IdIncidenciaTrabajador) values(" + this.Nomina_stNomina.IdNomina + "," + item.IdIncidenciaTrabajador + ") ", null);
                }
            }
            if (this.IncidenciaTrabajador != null
          && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
            {

                

                var faltastrabajador = this.IncidenciaTrabajador.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador== idt
                       && s.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && s.EsAplicada == false
                       && s.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
            && s.AñoParaNomina == this.Nomina_stNomina.Año
                       ).ToList();


                foreach (var item in faltastrabajador)
                {
                    var upt=dp.connection.Execute("update IncidenciaPermiso_stIncidenciaTrabajador set EsAplicada=1, IdNominaTrabajador = " + trabajador.IdNominaTrabajador + "  where IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador + " and  QuincenaParaNomina= '"+item.QuincenaParaNomina+ "' and AñoParaNomina="+item.AñoParaNomina, null);
                    if (upt > 0)
                    {
                        dp.connection.Execute("insert into Nomina_stNominaIncidenciasTrabajadorAplicadas  (IdNomina,IdIncidenciaTrabajador) values(" + this.Nomina_stNomina.IdNomina + "," + item.IdIncidenciaTrabajador + ") ", null);
                    }
                }


                if (this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA DOMINICAL GRAVADA").FirstOrDefault() != null)
                {
                    var trabajadoresprima = this.TrabajadoresConPrimaDominical.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idt)
                      .ToList();


                    foreach (var item in trabajadoresprima)
                    {
                        var w = dp.connection.Execute("update IncidenciaPermiso_stIncidenciaTrabajador set EsAplicada=1, IdNominaTrabajador = " + trabajador.IdNominaTrabajador + "  where IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador + " and  QuincenaParaNomina= '" + item.QuincenaParaNomina + "' and AñoParaNomina=" + item.AñoParaNomina, null);
                        if (w > 0)
                        {
                            var q = dp.connection.Execute("insert into Nomina_stNominaIncidenciasTrabajadorAplicadas  (IdNomina,IdIncidenciaTrabajador) values(" + this.Nomina_stNomina.IdNomina + "," + item.IdIncidenciaTrabajador + ") ", null);
                        }
                    }
                }

                if (this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIA DE DESCANSO").FirstOrDefault() != null)
                {
                    var trabajadordescanso = this.TrabajadoresConDiasDescanso.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idt)
                      .ToList();


                    foreach (var item in trabajadordescanso)
                    {
                        var g = dp.connection.Execute("update IncidenciaPermiso_stIncidenciaTrabajador set EsAplicada=1, IdNominaTrabajador = " + trabajador.IdNominaTrabajador + "  where IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador + " and  QuincenaParaNomina= '" + item.QuincenaParaNomina + "' and AñoParaNomina=" + item.AñoParaNomina, null);
                        if (g > 0)
                        {
                            dp.connection.Execute("insert into Nomina_stNominaIncidenciasTrabajadorAplicadas  (IdNomina,IdIncidenciaTrabajador) values(" + this.Nomina_stNomina.IdNomina + "," + item.IdIncidenciaTrabajador + ") ", null);
                        }
                    }

                }




            }
            if (this.IncidenciaTrabajador != null
                && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
            {



                var faltastrabajador = this.IncidenciaTrabajador.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idt
                       && s.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && s.EsAplicada == false
                        && s.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
            && s.AñoParaNomina == this.Nomina_stNomina.Año
                       ).ToList();


                foreach (var item in faltastrabajador)
                {
                    var fd= dp.connection.Execute("update IncidenciaPermiso_stIncidenciaTrabajador set EsAplicada=1, IdNominaTrabajador = " + trabajador.IdNominaTrabajador + "  where IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador + " and  QuincenaParaNomina= '" + item.QuincenaParaNomina + "' and AñoParaNomina=" + item.AñoParaNomina, null);

                    if (fd > 0)
                    {
                        dp.connection.Execute("insert into Nomina_stNominaIncidenciasTrabajadorAplicadas  (IdNomina,IdIncidenciaTrabajador) values(" + this.Nomina_stNomina.IdNomina + "," + item.IdIncidenciaTrabajador + ") ", null);
                    }
                }

                if (this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "PRIMA DOMINICAL GRAVADA").FirstOrDefault() != null)
                {
                    var trabajadoresprima = this.TrabajadoresConPrimaDominical.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idt
                 && s.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
            && s.AñoParaNomina == this.Nomina_stNomina.Año)
                      .ToList();


                    foreach (var item in trabajadoresprima)
                    {
                        var p = dp.connection.Execute("update IncidenciaPermiso_stIncidenciaTrabajador set EsAplicada=1, IdNominaTrabajador = " + trabajador.IdNominaTrabajador + "  where IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador + " and  QuincenaParaNomina= '" + item.QuincenaParaNomina + "' and AñoParaNomina=" + item.AñoParaNomina, null);
                        if (p > 0)
                        {
                            dp.connection.Execute("insert into Nomina_stNominaIncidenciasTrabajadorAplicadas  (IdNomina,IdIncidenciaTrabajador) values(" + this.Nomina_stNomina.IdNomina + "," + item.IdIncidenciaTrabajador + ") ", null);
                        }
                    }
                }

                if (this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIA DE DESCANSO").FirstOrDefault() != null)
                {
                    var trabajadordescanso = this.TrabajadoresConDiasDescanso.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idt
                 && s.QuincenaParaNomina == this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
            && s.AñoParaNomina == this.Nomina_stNomina.Año)
                      .ToList();


                    foreach (var item in trabajadordescanso)
                    {
                        var s = dp.connection.Execute("update IncidenciaPermiso_stIncidenciaTrabajador set EsAplicada=1, IdNominaTrabajador = " + trabajador.IdNominaTrabajador + "  where IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador + " and  QuincenaParaNomina= '" + item.QuincenaParaNomina + "' and AñoParaNomina=" + item.AñoParaNomina, null);
                        if (s > 0)
                        {
                            dp.connection.Execute("insert into Nomina_stNominaIncidenciasTrabajadorAplicadas  (IdNomina,IdIncidenciaTrabajador) values(" + this.Nomina_stNomina.IdNomina + "," + item.IdIncidenciaTrabajador + ") ", null);
                        }
                    }

                }



            }

            if (this.DevolucionesFaltasTrabajador != null)
            {
                var faltastrabajador = this.DevolucionesFaltasTrabajador.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == idt).ToList();

                foreach (var item in faltastrabajador)
                {
                    dp.connection.Execute("  update IncidenciaPermiso_stIncidenciaTrabajador set IdNominaTrabajadorDevolucionFalta = " + trabajador.IdNominaTrabajador + "  where IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador + "  and IdNominaTrabajadorDevolucionFalta is null ", null);
                }


                dp.Close();

            }
        }

        public void CierreDeNomina()
        {

            DapperQuery dpc = new DapperQuery("bdNovaEntities");
            var trg = dpc.connection.Execute(" update Nomina_stNomina set EsCerrada=1 where IdNomina=" + this.IdNomina.ToString());

            dpc.Close();


        }
        public void GrabarPensiones(Nomina_stNominaTrabajador trabajador)
        {


            foreach (var item in this.ListaPensionesTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria))
            {
                Pensiones_stNominaPensionTrabajador pen = new Pensiones_stNominaPensionTrabajador();
                pen.IdNominaTrabajador = trabajador.IdNominaTrabajador;
                pen.IdPensionTrabajador = item.IdPensionTrabajador;
                pen.Importe = item.Importe;
                pen.Concepto = item.Concepto;
                this.PensionesDelTrabajador.Add(pen);

            }

      

        }




        public void GenerarAjustesSueldosCambioContrato(Convenios_stConvenioLaboralTrabajadorCategoria item)
        {
            // no se hacen ajustes de ayuda y valdes de despensa para base
            // ya qeu son  importes fijos, sin importar la categoria
            bool calcularnomina = true;
            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("DESPENSA")
                && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
            {
                calcularnomina = false;
            }

            
                var mismosueldo= this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "CATEGORIADIFERENTEMISMOSUELDO").FirstOrDefault();
            if (mismosueldo!=null)
                calcularnomina = false;

            decimal TerminoContratoDias = 0M;
            var TerminoContratoDiasSingle = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "ContratoSinPagoSoloAjuste").FirstOrDefault();
            if (TerminoContratoDiasSingle != null)
                TerminoContratoDias = TerminoContratoDiasSingle.Importe;


            if (TerminoContratoDias==0 && calcularnomina && !this.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud)
            {
                var datos = this.getCambiosdeContratos().Where(s => s.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                TimeSpan diasdediferenciaentrecontratos = new TimeSpan();

                if (datos != null)
                {
                    // buscar la ultima nomina con horario anterior al vigente
                    string sql = @"
 select b.*,c.IdCategoria,ff.RestringirMenu from
             Convenios_stConvenioLaboralTrabajadorCategoria b
            inner
          join Plazas_stDistribucionPlazaCategoria c on c.IdDistribucionPlazaCategoria = b.IdDistribucionPlazaCategoria
          inner
          join Plazas_ctCategoria d on d.IdCategoria = c.IdCategoria
          inner
          join Convenios_stConvenioLaboralTrabajador f on f.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
          inner
          join Kardex_ctTrabajador g on g.IdTrabajador = f.IdTrabajador
        left join vwDatosAspirantesTrabajadores ff on ff.IdConvenioLaboralTrabajadorCategoria = b.IdConvenioLaboralTrabajadorCategoria
          where f.IdTrabajador = " + item.Convenios_stConvenioLaboralTrabajador.IdTrabajador + @" and b.IdConvenioLaboralTrabajadorCategoria not in (
  select bb.IdConvenioLaboralTrabajadorCategoria from Convenios_stConvenioLaboralTrabajadorCategoria bb
  inner join Plazas_stDistribucionPlazaCategoria cc on cc.IdDistribucionPlazaCategoria = bb.IdDistribucionPlazaCategoria
inner join Plazas_ctCategoria dd on dd.IdCategoria = cc.IdCategoria
inner join Convenios_stConvenioLaboralTrabajador ff on ff.IdConvenioLaboralTrabajador = bb.IdConvenioLaboralTrabajador
inner join Kardex_ctTrabajador gg on gg.IdTrabajador = ff.IdTrabajador
left join vwDatosAspirantesTrabajadores fff on fff.IdConvenioLaboralTrabajadorCategoria = bb.IdConvenioLaboralTrabajadorCategoria
  where
    (bb.FechaInicio = bb.FechaTermino and bb.FechaTermino is not null)
)
          ORDER BY b.FechaInicio desc, b.FechaTermino DESC";

                    string query = @" select b.* from Nomina_stNomina a
inner join Nomina_stNominaTrabajador b on a.idnomina=b.IdNomina
where a.EsCerrada=1 and AjusteRealizado=1 and b.IdConvenioLaboralTrabajadorCategoria=";

                    DapperQuery dp = new DapperQuery("bdNovaEntities");

                    var plazatrabajador = this.Plazas_ctCategoria.Where(s => s.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria).FirstOrDefault();

                    string cadenasueldo = "sueldo";
                    //if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
                    //{ cadenasueldo = this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla; }

                    string sqlnomina = @"select f.* from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' and
  b.EsCerrada=1 and  c.Plantilla like '%" + cadenasueldo + "%' and w.IdTrabajador=" + item.Convenios_stConvenioLaboralTrabajador.IdTrabajador + " and  a.idconveniolaboraltrabajadorcategoria<>" + item.IdConvenioLaboralTrabajadorCategoria + " order by a.idnominatrabajador desc";

                    List<Plazas_stDistribucionPlazaCategoria> ultimanominapagada = (List<Plazas_stDistribucionPlazaCategoria>)dp.connection.Query<Plazas_stDistribucionPlazaCategoria>(sqlnomina);


                    string sqlnominados = @"select a.* from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' and
b.EsCerrada=1 and  c.Plantilla like '%" + cadenasueldo + "%' and w.IdTrabajador=" + item.Convenios_stConvenioLaboralTrabajador.IdTrabajador + " and  a.idconveniolaboraltrabajadorcategoria<>" + item.IdConvenioLaboralTrabajadorCategoria + " order by a.idnominatrabajador desc";

                    List<Nomina_stNominaTrabajador> ultimanominapagadaTrabajador = (List<Nomina_stNominaTrabajador>)dp.connection.Query<Nomina_stNominaTrabajador>(sqlnominados);





                    //List<Percepciones_stNominaTrabajadorPercepciones> nominastrabajador = db.Nomina_stNominaTrabajador
                    //    .Where(s => ultimanominapagadaTrabajador.Select(a=> a.IdNominaTrabajador)
                    //    .Contains(s.IdNominaTrabajador)).AsNoTracking().ToList();


                    string sqlnominafechas = @"select b.* from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' and
b.EsCerrada=1 and  c.Plantilla like '%" + cadenasueldo + "%' and w.IdTrabajador=" + item.Convenios_stConvenioLaboralTrabajador.IdTrabajador + " and  a.idconveniolaboraltrabajadorcategoria<>" + item.IdConvenioLaboralTrabajadorCategoria + " order by a.idnominatrabajador desc";

                    List<Nomina_stNomina> ultimanominapagadafechas = (List<Nomina_stNomina>)dp.connection.Query<Nomina_stNomina>(sqlnominafechas);

                    //hubo un pago y hay uqe que descontarlo
                    bool procesoIncluido = false;

                    if (item.EsPrimerCalculo)
                    {
                        string sqlnominaconvenio = @"select d.* from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.idnomina=b.idnomina
inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' and
b.EsCerrada=1 and  c.Plantilla like '%" + cadenasueldo + "%' and w.IdTrabajador=" + item.Convenios_stConvenioLaboralTrabajador.IdTrabajador + " and  a.idconveniolaboraltrabajadorcategoria<>" + item.IdConvenioLaboralTrabajadorCategoria + " order by a.idnominatrabajador desc";

                        List<Convenios_stConvenioLaboralTrabajadorCategoria> ultimanominapagadaconvenio = (List<Convenios_stConvenioLaboralTrabajadorCategoria>)dp.connection.Query<Convenios_stConvenioLaboralTrabajadorCategoria>(sqlnominaconvenio);

                        var finipago = ultimanominapagadaconvenio.FirstOrDefault();
                        if (finipago != null)
                        {
                            if (finipago.FechaInicioPago != null)
                            {
                                if (finipago.FechaInicioPago.Value != null)
                                {
                                    procesoIncluido = ultimanominapagadafechas.Any(nomina =>
                   nomina.FechaInicio <= finipago.FechaInicioPago);
                                }
                            }
                            else
                            {
                                if (finipago.FechaTermino!=null)
                                if (finipago.FechaTermino.Value.AddDays(1) == item.FechaInicio)
                                {
                                    diasdediferenciaentrecontratos = finipago.FechaTermino.Value - item.FechaInicio;
                                    var categoriaanterior = ultimanominapagada.FirstOrDefault();
                                    if (categoriaanterior.IdCategoria != item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                    {
                                        procesoIncluido = true;
                                    }
                                }
                            }
                        }
                        //else {
                        //    var conveniosregistrados = this.ConveniosTrabajadoresTodos.Where(a =>
                        //    a.IdConvenioLaboralTrabajadorCategoria != item.IdConvenioLaboralTrabajadorCategoria &&
                        //    a.Convenios_stConvenioLaboralTrabajador.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador).OrderByDescending(a => a.FechaTermino).ToList();

                        //    if (conveniosregistrados.Count>0)
                        //     if (conveniosregistrados[0].FechaTermino.Value.AddDays(1) == item.FechaInicio)
                        //    {
                        //        diasdediferenciaentrecontratos = conveniosregistrados[0].FechaTermino.Value - item.FechaInicio;
                        //        var categoriaanterior = ultimanominapagada.FirstOrDefault();
                        //        if (categoriaanterior.IdCategoria != conveniosregistrados.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                        //        {
                        //            procesoIncluido = true;
                        //        }
                        //    }

                        //}
                    }

               

                    List<ConvenioLaboralTrabajadorCategoriaPlazas> convenios = (List<ConvenioLaboralTrabajadorCategoriaPlazas>)dp.connection.Query<ConvenioLaboralTrabajadorCategoriaPlazas>(sql.ToString());
                    bool existecontratoscancelados = false;
                    bool existeajustdepercepciones = false;
                    if (convenios.Count > 1 || procesoIncluido)
                        //solo si es el primer calculo de esta plaza se realiza el ajuste
                        //caso yadira, al inicio del 2021 se genera un calculo por eso se agrego esta linea
                        if (convenios[0].EsPrimerCalculo)
                        {
                               try
                            {


                                if (convenios[0].FechaInicio == convenios[0].FechaTermino
                                    || convenios[1].FechaTermino == convenios[1].FechaInicio)
                                    existecontratoscancelados = true;

                                if (this.Nomina_stNomina.FechaInicio > item.FechaInicio)
                                {
                                    //diasdediferenciaentrecontratos = this.Nomina_stNomina.FechaInicio - item.FechaInicio;

                                    if (this.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "ajustepercepcionesPositiva"
                                    && a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault() != null)
                                            existeajustdepercepciones = true;
                                    
                                }
                                else
                                if (convenios[1].RestringirMenu == false)
                                    diasdediferenciaentrecontratos = (System.DateTime)convenios[0].FechaInicio - (System.DateTime)convenios[1].FechaTermino;

                            }
                            catch (Exception e)
                            {

                                var t = e;
                            }
                            bool hayinterrupcioncontratos = false;



                            TimeSpan diasdediferencia;
                            DateTime fechaUsada;
                            DateTime fechaUsadatermino;

                            if (convenios[0].EsPrimerCalculo && !existeajustdepercepciones)
                                if (diasdediferenciaentrecontratos.Days < 2 && existecontratoscancelados == false)
                                    if (this.Nomina_stNomina.FechaInicio >= convenios[0].FechaInicio)
                                    {
                                        bool categoriadiferente = false;
                                        if (ultimanominapagada.Count > 1)
                                        {
                                            if (ultimanominapagada[0].IdCategoria != item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                                categoriadiferente = true;

                                            
                                                var diasinterrup = item.FechaInicio - ultimanominapagadafechas[0].FechaTermino;
                                            if (diasinterrup.TotalDays > 1)
                                                hayinterrupcioncontratos = true;
                                        }

                                        //no se hacen ajustes sobre la misma categoria
                                        //if (ultimanominapagadafechas.Count > 0 && convenios[0].IdCategoria != convenios[1].IdCategoria || categoriadiferente)
                                       
                                        
                                        if (!hayinterrupcioncontratos && ultimanominapagadafechas.Count > 0 && convenios[0].IdCategoria != convenios[1].IdCategoria || categoriadiferente)                                        {

                                            List<Convenios_stConvenioLaboralTrabajadorCategoria> existeajuste = (List<Convenios_stConvenioLaboralTrabajadorCategoria>)dp.connection.Query<Convenios_stConvenioLaboralTrabajadorCategoria>(query + convenios[0].IdConvenioLaboralTrabajadorCategoria);
                                            //si no hay nominas cerradas ya con ajuste se procede a validar los dias
                                            if (existeajuste.Count == 0)
                                            {


                                                try
                                                {


                                                    if ( convenios[0].FechaInicioPago != null ||
                                                        ultimanominapagadafechas[0].FechaTermino > convenios[0].FechaInicio)
                                                    {
                                        
                                                        if (ultimanominapagadafechas[0].FechaTermino > convenios[0].FechaInicio)
                                                        {
                                                            diasdediferencia = (System.DateTime)ultimanominapagadafechas[0].FechaTermino.AddDays(1) - (System.DateTime)convenios[0].FechaInicio;
                                                            fechaUsada = (System.DateTime)convenios[0].FechaInicio;
                                                            fechaUsadatermino = (System.DateTime)ultimanominapagadafechas[0].FechaTermino.AddDays(1);
                                                        }
                                                        else
                                                        if (convenios[1].FechaTermino == null)
                                                        {

                                                            if (convenios[0].FechaInicio > convenios[0].FechaInicioPago)
                                                            {
                                                                diasdediferencia = (System.DateTime)convenios[0].FechaInicio - (System.DateTime)convenios[0].FechaInicioPago;
                                                                fechaUsada = convenios[0].FechaInicioPago.Value;
                                                                fechaUsadatermino = (System.DateTime)convenios[0].FechaInicio;
                                                            }
                                                            else
                                                            {
                                                                diasdediferencia = (System.DateTime)convenios[0].FechaInicioPago.Value - (System.DateTime)convenios[0].FechaInicio;
                                                                fechaUsada = convenios[0].FechaInicio;
                                                                fechaUsadatermino = (System.DateTime)convenios[0].FechaInicioPago.Value;
                                                            }

                                                        }
                                                        else
                                                        {
                                                            if (convenios[1].FechaTermino.Value >= convenios[0].FechaInicioPago)
                                                            {
                                                                diasdediferencia = (System.DateTime)convenios[1].FechaTermino.Value - (System.DateTime)convenios[0].FechaInicioPago;
                                                                fechaUsada = (DateTime)convenios[0].FechaInicioPago.Value;
                                                                fechaUsadatermino = (System.DateTime)convenios[1].FechaTermino.Value;
                                                            }
                                                            else

                                                                if (diasdediferenciaentrecontratos.Days == 1)
                                                            {
                                                                fechaUsada = convenios[1].FechaTermino.Value.AddDays(+1);
                                                                diasdediferencia = (convenios[0].FechaInicioPago.Value - fechaUsada);
                                                                fechaUsadatermino = convenios[0].FechaInicioPago.Value;
                                                            }
                                                            else
                                                            {
                                                                diasdediferencia = (convenios[0].FechaInicioPago.Value.AddDays(-1) - convenios[1].FechaTermino.Value.AddDays(-1));

                                                                fechaUsada = convenios[1].FechaTermino.Value.AddDays(-1);
                                                                fechaUsadatermino = convenios[0].FechaInicioPago.Value.AddDays(-1);
                                                            }
                                                        }


                                                        if (diasdediferencia.Days > 0)
                                                        {
                                                            int mesescon31dias = 0;
                                                            int diasfeb = 0;

                                                            var diasDeAjuste = diasdediferencia.Days;
                                                            var diasentrenominaspagados = 0;
                                                            if (plazatrabajador.CalcularNominaDiasCalendario == false)
                                                            {
                                                                mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(fechaUsada, fechaUsadatermino);
                                                                diasfeb = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(fechaUsada, fechaUsadatermino);
                                                            }

                                                            diasDeAjuste = (diasDeAjuste - mesescon31dias) + diasfeb;

                                                            if (ultimanominapagadaTrabajador.Count > 0)
                                                            {
                                                                if (ultimanominapagadafechas[0].FechaTermino > convenios[0].FechaInicio)
                                                                {
                                                                    diasDeAjuste = (int)diasdediferencia.TotalDays;
                                                                    if (plazatrabajador.CalcularNominaDiasCalendario == false)
                                                                    {
                                                                        mesescon31dias = 0;
                                                                        diasfeb = 0;
                                                                        mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(fechaUsada, fechaUsadatermino);
                                                                        diasfeb = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(fechaUsada, fechaUsadatermino);
                                                                        diasDeAjuste = (diasDeAjuste - mesescon31dias) + diasfeb;
                                                                    }

                                                                }
                                                                else
                                                                if (item.FechaInicio >= ultimanominapagadafechas[0].FechaInicio)
                                                                {
                                                                    var diasarestar = ultimanominapagadafechas[0].FechaTermino.Subtract(item.FechaInicio.AddDays(-1));
                                                                    diasentrenominaspagados = (int)diasarestar.TotalDays;
                                                                    if (plazatrabajador.CalcularNominaDiasCalendario == false)
                                                                    {
                                                                        diasentrenominaspagados = (diasentrenominaspagados - mesescon31dias) + diasfeb;
                                                                    }
                                                                }

                                                                decimal importeRDL00 = 0M;


                                                                List<Percepciones_stNominaTrabajadorPercepciones> percepcionescalculadas = new List<Percepciones_stNominaTrabajadorPercepciones>();

                                                                int idcltc = ultimanominapagadaTrabajador[0].IdConvenioLaboralTrabajadorCategoria;
                                                                long idnt = ultimanominapagadaTrabajador[0].IdNominaTrabajador;

                                                                Deducciones_stNominaTrabajadorDeduccion deduccionImssCalculadaUltimaNomina;

                                                                using (var basenova = new bdNovaEntities())
                                                                {
                                                                    basenova.Database.Connection.Open();
                                                                    percepcionescalculadas = basenova.Percepciones_stNominaTrabajadorPercepciones.AsNoTracking().Where(s => s.Nomina_stNominaTrabajador.IdConvenioLaboralTrabajadorCategoria == idcltc
                                                    && s.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.AjustarCambioCategoria == true &&
                                                    s.IdNominaTrabajador == idnt && s.Nomina_stNominaTrabajador.Nomina_stNomina.IdPlantillaNomina == this.Nomina_stNomina.IdPlantillaNomina).Include(z => z.Nomina_stNominaTrabajador)
                                                    .Include(q => q.Percepciones_stPlantillaNominaPercepciones.Nomina_ctPlantillaNomina.Nomina_ctPlantillaGrupo)
                                                    .Include(q => q.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepciones_ctPercepcionPeriodo)
                                                    .ToList();

                                                                    deduccionImssCalculadaUltimaNomina = basenova.Deducciones_stNominaTrabajadorDeduccion.AsNoTracking().Where(s => s.Nomina_stNominaTrabajador.IdConvenioLaboralTrabajadorCategoria == idcltc
                                                            && s.IdNominaTrabajador == idnt && s.Nomina_stNominaTrabajador.Nomina_stNomina.IdPlantillaNomina == this.Nomina_stNomina.IdPlantillaNomina).Include(z => z.Nomina_stNominaTrabajador).Include(z => z.Deducciones_stPlantillaNominaDeducciones).Include(z => z.Deducciones_stPlantillaNominaDeducciones.Deducciones_ctDeduccion).Where(a => a.Deducciones_stPlantillaNominaDeducciones.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault();
                                                                    basenova.Database.Connection.Close();
                                                                }
                                                                //alamcena el valo del imss de la umtima qna calculada
                                                                if (deduccionImssCalculadaUltimaNomina != null)
                                                                {
                                                                    VariablesNominaTrabajador vntA = new VariablesNominaTrabajador();
                                                                    vntA.Concepto = "IMSSCAMBIOCONTRATO";
                                                                    vntA.Importe = deduccionImssCalculadaUltimaNomina.Importe;
                                                                    vntA.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;

                                                                    this.ListaVariablesNominaTrabajador.Add(vntA);
                                                                }

                                                                if (categoriadiferente && percepcionescalculadas.Count == 0)
                                                                {
                                                                    // si entra aqui es por que venia de una licencia y hubo un pago de una qna con otra categoria
                                                                    //por eso se busca la ultima, para poder hacer correctamente el ajuste

                                                                    if (ultimanominapagadaTrabajador.Count > 0)
                                                                    {


                                                                        idcltc = ultimanominapagadaTrabajador[0].IdConvenioLaboralTrabajadorCategoria;
                                                                        idnt = ultimanominapagadaTrabajador[0].IdNominaTrabajador;

                                                                        using (var basenova = new bdNovaEntities())
                                                                        {
                                                                            basenova.Database.Connection.Open();
                                                                            percepcionescalculadas = basenova.Percepciones_stNominaTrabajadorPercepciones.AsNoTracking()
                                                                                .Where(s => s.Nomina_stNominaTrabajador.IdConvenioLaboralTrabajadorCategoria == idcltc
                                                   && s.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.AjustarCambioCategoria == true
                                                                    && s.IdNominaTrabajador == idnt && s.Nomina_stNominaTrabajador.Nomina_stNomina.IdPlantillaNomina == this.Nomina_stNomina.IdPlantillaNomina).Include(z => z.Nomina_stNominaTrabajador)
                                                                    .Include(q => q.Percepciones_stPlantillaNominaPercepciones.Nomina_ctPlantillaNomina.Nomina_ctPlantillaGrupo)
                                                                    .Include(q => q.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepciones_ctPercepcionPeriodo)
                                                                    .ToList();
                                                                            basenova.Database.Connection.Close();
                                                                        }
                                                                    }
                                                                }




                                                                Decimal Sueldodiario = 0;


                                                                decimal importeactualajusteRDL = 0;
                                                                decimal importeAjuste = 0;

                                                                decimal sueldobrutoIinicial = 0M;

                                                                diasDeAjuste = diasDeAjuste - diasentrenominaspagados;

                                                                foreach (var ele in percepcionescalculadas)
                                                                {





                                                                    if (ele.Percepciones_stPlantillaNominaPercepciones.Nomina_ctPlantillaNomina.Nomina_ctPlantillaGrupo.PlantillaGrupo != "RDL")
                                                                    {
                                                                        if (ele.Percepciones_stPlantillaNominaPercepciones.Nomina_ctPlantillaNomina.Nomina_ctPlantillaGrupo.PlantillaGrupo == "SUELDO")
                                                                        {
                                                                            var x = 0;

                                                                        }
                                                                        else
                                                                            importeRDL00 = 0;

                                                                        //if (contratosconpagosentrefechas)
                                                                        //{

                                                                        //}
                                                                        //else
                                                                        //{
                                                                        if (ele.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepciones_ctPercepcionPeriodo.PercepcionPeriodo == "Mensual")
                                                                            Sueldodiario = ele.Importe / 30;
                                                                        else
                                                                            Sueldodiario = ele.Importe / ele.Nomina_stNominaTrabajador.DiasEfectivosLaborados;
                                                                        // }

                                                                        importeAjuste = (decimal)diasDeAjuste * Sueldodiario;

                                                                        importeAjuste = importeAjuste + importeRDL00;

                                                                        var totaldiferencia = 0M;
                                                                        var totaldiferenciaRound = 0M;

                                                                        if (importeAjuste > 0)
                                                                        {


                                                                            var ajustesrealizados = ListaPercepcionesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == convenios[0].IdConvenioLaboralTrabajadorCategoria
                                                                              && a.Concepto == ele.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepcion
                                                                            ).Sum(s => s.Importe);

                                                                            ajustesrealizados = ajustesrealizados + importeactualajusteRDL;
                                                                            if (ajustesrealizados > 0)
                                                                            {
                                                                                totaldiferencia = Math.Round(ajustesrealizados - importeAjuste, 2);
                                                                                totaldiferenciaRound = Math.Round(ajustesrealizados - importeAjuste, 1);

                                                                                var ajusteanterior = ListaPercepcionesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == convenios[0].IdConvenioLaboralTrabajadorCategoria
                                                                         && a.Concepto == ele.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepcion).FirstOrDefault();

                                                                                ListaPercepcionesTrabajadores.Remove(ajusteanterior);
                                                                            }

                                                                            var percpecionactual = ListaPercepcionesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == convenios[0].IdConvenioLaboralTrabajadorCategoria
                                                                              && a.IdPlantillaNominaPercepcion == ele.IdPlantillaNominaPercepcion
                                                                            ).FirstOrDefault();

                                                                            bool espercepcion = true;
                                                                            if (percpecionactual != null)
                                                                            {
                                                                                var sueldodiarionuevo = 0M;

                                                                                if (ele.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepciones_ctPercepcionPeriodo.PercepcionPeriodo == "Mensual")
                                                                                    sueldodiarionuevo = percpecionactual.Importe / 30;
                                                                                else
                                                                                    sueldodiarionuevo = percpecionactual.Importe / ele.Nomina_stNominaTrabajador.DiasEfectivosLaborados;

                                                                                if (sueldodiarionuevo > Sueldodiario)
                                                                                {
                                                                                    //percepcion
                                                                                    var difer = sueldodiarionuevo - Sueldodiario;
                                                                                    importeAjuste = (decimal)diasDeAjuste * difer;
                                                                                }
                                                                                else
                                                                                {
                                                                                    espercepcion = false;
                                                                                    var difer = Sueldodiario - sueldodiarionuevo;
                                                                                    importeAjuste = (decimal)diasDeAjuste * difer;


                                                                                }

                                                                                totaldiferencia = Math.Round(importeAjuste, 2);
                                                                                totaldiferenciaRound = Math.Round(importeAjuste, 1);
                                                                            }
                                                                            else
                                                                            {
                                                                                //es una percepcion que ya no tiene y tien eue devolverlas


                                                                                importeAjuste = (decimal)diasDeAjuste * Sueldodiario;

                                                                                var idDeducDiferencia = this.PlantillaNominaDeducciones
                                                                                .FirstOrDefault(x => x.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO");

                                                                                if (idDeducDiferencia != null)
                                                                                {


                                                                                    AgregarOActualizarAjuste(item, importeAjuste, ele.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepcion, idDeducDiferencia.IdPlantillaNominaDeduccion);
                                                                                }
                                                                            }
                                                                            // SI ES POSITIVO SE LE AGREGA COMO PERCEPCION
                                                                            if (espercepcion && totaldiferenciaRound > 0)
                                                                            {

                                                                                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                                                                                percepcion.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                                                                percepcion.IdNomina = this.IdNomina;
                                                                                percepcion.IdPlantillaNominaPercepcion = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().IdPlantillaNominaPercepcion;
                                                                                percepcion.Importe = totaldiferencia;

                                                                                percepcion.Tipo = "NORMAL";
                                                                                percepcion.EsGrabable = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                                                                percepcion.Concepto = ele.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepcion;
                                                                                percepcion.EsVariable = (bool)this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                                                                percepcion.EsPrevisionSocial = (bool)this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                                                                this.ListaPercepcionesTrabajadores.Add(percepcion);
                                                                            }
                                                                            else
                                                                             if (totaldiferenciaRound > 0)
                                                                            {
                                                                                // se valida que el quede dinero
                                                                                // al menos un 30% de su sueldo y lo demas
                                                                                // se le descuenta en N quincenas
                                                                                var percepaincluir = this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion != "DIFERENCIA").Select(b => b.IdPlantillaNominaPercepcion).ToArray();

                                                                                //   var deducincluir = this.PlantillasNominasDeducciones.Select(b => b.IdPlantillaNominaDeduccion).ToArray();

                                                                                var sueldobruto = ListaPercepcionesTrabajadores.Where(a => a.Concepto == "" && a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                                                                            && percepaincluir.Contains(a.IdPlantillaNominaPercepcion)
                                                                          ).Sum(s => s.Importe);

                                                                                // var totasldeducciones = ListaDeduccionesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == convenios[0].IdConvenioLaboralTrabajadorCategoria
                                                                                //&& deducincluir.Contains(a.IdPlantillaNominaDeduccion)
                                                                                //  ).Sum(s => s.Importe);
                                                                                //sueldobruto = sueldobruto - totasldeducciones;
                                                                                if (sueldobrutoIinicial == 0)
                                                                                    sueldobrutoIinicial = sueldobruto;

                                                                                var porcentaje70 = sueldobrutoIinicial * .70M;
                                                                                //var montocredito = totaldiferencia * -1;
                                                                                var montocredito = totaldiferencia;


                                                                                if (totaldiferencia > porcentaje70)
                                                                                {
                                                                                    // se le genera un credito nuevo para los descuentos posteriores
                                                                                    Creditos_stCreditoTrabajador credito = new Creditos_stCreditoTrabajador();
                                                                                    credito.IdCreditoTrabajador = 1;
                                                                                    credito.IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                                                                                    credito.IdTipoCredito = this.Catalogos_ctTipoCredito.Where(s => s.TipoCredito == "DESCUENTO POR PAGO INDEBIDO").FirstOrDefault().IdTipoCredito;
                                                                                    credito.VecesSalarioMinimo = null;
                                                                                    credito.CuotaFija = porcentaje70;
                                                                                    credito.Porcentaje = null;
                                                                                    credito.FechaInicioCredito = this.Nomina_stNomina.FechaTermino.AddDays(1);
                                                                                    credito.FechaInicioDescuento = this.Nomina_stNomina.FechaTermino.AddDays(1);
                                                                                    credito.FechaTermino = null;
                                                                                    credito.ImporteCredito = montocredito * -1;
                                                                                    credito.Parcialidades = 0;
                                                                                    credito.Saldo = credito.ImporteCredito - porcentaje70;
                                                                                    credito.ParcialidadesPagadas = 0;

                                                                                    credito.NumeroCredito = "1";
                                                                                    credito.IdEmpleado = null;
                                                                                    credito.NoFonacot = null;
                                                                                    credito.IdCreditoTipoDescuento = 1;


                                                                                    credito.EsAplicado = false;
                                                                                    credito.EsParaDevolucion = false;
                                                                                    credito.EsYaDevuelto = false;
                                                                                    credito.IdCreditoTrabajadorFactor = null;
                                                                                    credito.AjusteFactorAplicado = false;


                                                                                    ListaCreditosTrabajadorPagosIndebidos.Add(credito);

                                                                                    sueldobrutoIinicial = sueldobrutoIinicial - porcentaje70;

                                                                                }
                                                                                else
                                                                                {
                                                                                    porcentaje70 = montocredito;
                                                                                    sueldobrutoIinicial = sueldobrutoIinicial - porcentaje70;
                                                                                }


                                                                                string conceptoDevolucion = ele.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepcion;
                                                                                var existepercepcionenRelacionActual = this.PlantillaNominaPercepcionesRelacionLaboral.Where(a => a.IdPlantillaNominaPercepcion == ele.IdPlantillaNominaPercepcion).FirstOrDefault();
                                                                                if (existepercepcionenRelacionActual == null)
                                                                                {
                                                                                    var devo = this.PlantillaNominaPercepcionesRelacionLaboral.Where(a => a.Percepciones_ctPercepcion.Percepcion.Contains("SUELDO")).FirstOrDefault();
                                                                                    conceptoDevolucion = devo.Percepciones_ctPercepcion.Percepcion;
                                                                                    var existeyaDeduccion = this.ListaDeduccionesTrabajadores.Where(a => a.Concepto == conceptoDevolucion && a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                                                                                    if (existeyaDeduccion != null)
                                                                                    {
                                                                                        porcentaje70 = porcentaje70 + (decimal)existeyaDeduccion.Importe;
                                                                                        this.ListaDeduccionesTrabajadores.Remove(existeyaDeduccion);
                                                                                    }
                                                                                }

                                                                                DeduccionesNominaTrabajador deduccioncuotafija = new DeduccionesNominaTrabajador();
                                                                                deduccioncuotafija.EsImprimibleRecibo = true;
                                                                                deduccioncuotafija.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                                                                deduccioncuotafija.IdNomina = this.Nomina_stNomina.IdNomina;
                                                                                deduccioncuotafija.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO").SingleOrDefault().IdPlantillaNominaDeduccion;
                                                                                deduccioncuotafija.Importe = porcentaje70;
                                                                                deduccioncuotafija.Concepto = conceptoDevolucion;

                                                                                this.ListaDeduccionesTrabajadores.Add(deduccioncuotafija);

                                                                            }


                                                                            VariablesNominaTrabajador vnt9 = new VariablesNominaTrabajador();
                                                                            vnt9.Concepto = "ajustecambiocategoria";
                                                                            vnt9.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;

                                                                            this.ListaVariablesNominaTrabajador.Add(vnt9);
                                                                        }
                                                                    }


                                                                }


                                                                var nuevaspercepciones = percepcionescalculadas.Select(q => q.IdPlantillaNominaPercepcion).ToList();

                                                                var idpercepslista = this.PlantillaNominaPercepciones.Where(s =>
                                                                s.Percepciones_ctPercepcion.AjustarCambioCategoria == true)
                                                                  .Select(a => a.IdPlantillaNominaPercepcion)
                                                                      .Except(nuevaspercepciones).ToList();

                                                                var diaslaborados = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;

                                                                //debe de quitar aquellas percepciones qeu no estan para el ajuste
                                                                // si es que los dias no son menores a los dias de la nomina
                                                                if (this.Nomina_stNomina.DiasNomina > diaslaborados)
                                                                {
                                                                    var conveniostrabajador = this.ConveniosTrabajadoresTodos
                                                                        .Where(a => a.Convenios_stConvenioLaboralTrabajador.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                                                                        && a.IdConvenioLaboralTrabajadorCategoria!=item.IdConvenioLaboralTrabajadorCategoria).Select(a=> a.IdConvenioLaboralTrabajadorCategoria ).ToList();

                                                                    var percepcionesactualesquitar = ListaPercepcionesTrabajadores
                                                                    .Where(a => conveniostrabajador.Contains(a.IdConvenioLaboralTrabajadorCategoria)
                                                                    && !idpercepslista.Contains(a.IdPlantillaNominaPercepcion))
                                                                    .ToList();

                                                                    foreach (var dat in percepcionesactualesquitar)
                                                                    {
                                                                        ListaPercepcionesTrabajadores.Remove(dat);
                                                                    }
                                                                    


                                                                }


                                                                var percepcionesactuales = ListaPercepcionesTrabajadores
                                                                .Where(a => a.IdConvenioLaboralTrabajadorCategoria == convenios[0].IdConvenioLaboralTrabajadorCategoria
                                                                && idpercepslista.Contains(a.IdPlantillaNominaPercepcion))
                                                                .ToList();
                                                              
                                                                string sqlplaza = $@"SELECT b.*
  FROM  [Plazas_stDistribucionPlazaCategoria] a
  inner join  plazas_ctCategoria b on a.IdCategoria=b.IdCategoria where a.IdDistribucionPlazaCategoria={ultimanominapagada.FirstOrDefault().IdDistribucionPlazaCategoria} ";
                                                                List<Plazas_ctCategoria> ultimarelacion = (List<Plazas_ctCategoria>)dp.connection.Query<Plazas_ctCategoria>(sqlplaza);

                                                                 
                                                                string ultimaspercepcionessql = @"
SELECT np.*, pp.*, cp.*
FROM Percepciones_stNominaTrabajadorPercepciones np
INNER JOIN Nomina_stNominaTrabajador a ON np.IdNominaTrabajador = a.IdNominaTrabajador
INNER JOIN Nomina_stNomina b ON a.idnomina = b.idnomina
INNER JOIN [Nomina_ctPlantillaNomina] c ON b.idplantillanomina = c.idplantillanomina
INNER JOIN Convenios_stConvenioLaboralTrabajadorCategoria d ON d.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
INNER JOIN Convenios_stConvenioLaboralTrabajador w ON w.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
INNER JOIN Plazas_stDistribucionPlazaCategoria f ON f.IdDistribucionPlazaCategoria = d.IdDistribucionPlazaCategoria
INNER JOIN Nomina_stNominaTrabajadorEstatus q ON q.IdNominaTrabajadorEstatus = a.IdNominaTrabajadorEstatus
INNER JOIN Nomina_stNominaTrabajadorEstatusGrupo gn ON gn.IdNominaTrabajadorEstatusGrupo = q.IdNominaTrabajadorEstatusGrupo
INNER JOIN Percepciones_stPlantillaNominaPercepciones pp ON pp.IdPlantillaNominaPercepcion = np.IdPlantillaNominaPercepcion
INNER JOIN Percepciones_ctPercepcion cp ON cp.IdPercepcion = pp.IdPercepcion
WHERE gn.EstatusNominaGrupo = 'PARA PAGO'
  AND b.EsCerrada = 1
  AND c.Plantilla LIKE @cadenasueldo
  AND w.IdTrabajador = @IdTrabajador
  AND a.IdConvenioLaboralTrabajadorCategoria <> @IdConvenioLaboralTrabajadorCategoria
ORDER BY a.idnominatrabajador DESC";

                                                                var parametros = new
                                                                {
                                                                    cadenasueldo = $"%{cadenasueldo}%",
                                                                    IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador,
                                                                    IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria
                                                                };

                                                                var lookup = new Dictionary<long, Percepciones_stNominaTrabajadorPercepciones>();

                                                                var ultimaspercepciones = dp.connection.Query<Percepciones_stNominaTrabajadorPercepciones, Percepciones_stPlantillaNominaPercepciones, Percepciones_ctPercepcion, Percepciones_stNominaTrabajadorPercepciones>(
                                                                    ultimaspercepcionessql,
                                                                    (np, pp, cp) =>
                                                                    {
                                                                        if (!lookup.TryGetValue(np.IdNominaTrabajadorPercepcion, out var nominaTrabajadorPercepcion))
                                                                        {
                                                                            lookup.Add(np.IdNominaTrabajadorPercepcion, nominaTrabajadorPercepcion = np);
                                                                        }

                                                                        if (nominaTrabajadorPercepcion.Percepciones_stPlantillaNominaPercepciones == null)
                                                                        {
                                                                            nominaTrabajadorPercepcion.Percepciones_stPlantillaNominaPercepciones = pp;
                                                                        }

                                                                        if (nominaTrabajadorPercepcion.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion == null)
                                                                        {
                                                                            nominaTrabajadorPercepcion.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion = cp;
                                                                        }

                                                                        return nominaTrabajadorPercepcion;
                                                                    },
                                                                    parametros,
                                                                    splitOn: "IdPlantillaNominaPercepcion,IdPercepcion"
                                                                ).Distinct().ToList();
                                                            


                                                                if (ultimarelacion.FirstOrDefault().IdRelacionConvenioLaboral
                                                                    == plazatrabajador.IdRelacionConvenioLaboral)
                                                                {
                                                                    foreach (var ele in percepcionesactuales)
                                                                    {






                                                                        importeRDL00 = 0;


                                                                        Sueldodiario = ele.Importe / diaslaborados;

                                                                        importeAjuste = (decimal)diasDeAjuste * Sueldodiario;

                                                                        importeAjuste = importeAjuste + importeRDL00;

                                                                        var totaldiferencia = 0M;
                                                                        var totaldiferenciaRound = 0M;
                                                                        bool hizoajustepercepcionanterior = false;
                                                                        //verifica el ultimos sueldos
                                                                        if (ultimanominapagada.Count() > 0)
                                                                        {


                                                                            var ultimanominatrabajador = ultimanominapagadaTrabajador.FirstOrDefault();


                                                                            var percepcionultima = ultimaspercepciones.Where(a =>
                                                                            
                                                                            a.IdPlantillaNominaPercepcion == ele.IdPlantillaNominaPercepcion).FirstOrDefault();

                                                                            bool espercepcion = true;

                                                                            Sueldodiario = percepcionultima.Importe / 15;

                                                                            decimal importeAjustePagado = 0M;

                                                                            if (percepcionultima != null)
                                                                            {
                                                                                var sueldodiarioultimo = 0M;


                                                                                sueldodiarioultimo = percepcionultima.Importe / ultimanominatrabajador.DiasEfectivosLaborados;


                                                                                //percepcion
                                                                                importeAjustePagado = sueldodiarioultimo * diasDeAjuste;
                                                                                     
                                                                                 
                                                                                importeAjuste= importeAjuste- importeAjustePagado;
                                                                                hizoajustepercepcionanterior = true;
                                                                            }
                                                                        }
                                                                                //// fin ultimo sueldo

                                                                                if (importeAjuste > 0)
                                                                        {




                                                                            totaldiferencia = Math.Round(importeAjuste, 2);
                                                                            totaldiferenciaRound = Math.Round(importeAjuste, 1);

                                                                            // SI ES POSITIVO SE LE AGREGA COMO PERCEPCION
                                                                            if (totaldiferenciaRound > 0)
                                                                            {

                                                                                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                                                                                percepcion.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                                                                percepcion.IdNomina = this.IdNomina;
                                                                                percepcion.IdPlantillaNominaPercepcion = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().IdPlantillaNominaPercepcion;
                                                                                percepcion.Importe = totaldiferencia;

                                                                                percepcion.Tipo = "NORMAL";
                                                                                percepcion.EsGrabable = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                                                                percepcion.Concepto = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.IdPlantillaNominaPercepcion == ele.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;
                                                                                percepcion.EsVariable = (bool)this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                                                                percepcion.EsPrevisionSocial = (bool)this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                                                                this.ListaPercepcionesTrabajadores.Add(percepcion);

                                                                                if (percepcion.Concepto.Contains("SUELDO")
                                          && item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
                                                                                {
                                                                                    DeduccionesNominaTrabajador deduccionCUOTA = new DeduccionesNominaTrabajador();
                                                                                    deduccionCUOTA.EsImprimibleRecibo = true;
                                                                                    deduccionCUOTA.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                                                                    deduccionCUOTA.IdNomina = this.Nomina_stNomina.IdNomina;
                                                                                    deduccionCUOTA.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "DIFERENCIA").FirstOrDefault().IdPlantillaNominaDeduccion;
                                                                                    deduccionCUOTA.Concepto = " CUOTA SINDICAL";

                                                                                    deduccionCUOTA.Importe = Math.Round(percepcion.Importe * 0.01M, 2);


                                                                                    this.ListaDeduccionesTrabajadores.Add(deduccionCUOTA);
                                                                                }
                                                                            }
                                                                            else {
                                                                                if (hizoajustepercepcionanterior == false)
                                                                                {
                                                                                    DeduccionesNominaTrabajador deduccioncuotafija = new DeduccionesNominaTrabajador();
                                                                                    deduccioncuotafija.EsImprimibleRecibo = true;
                                                                                    deduccioncuotafija.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                                                                    deduccioncuotafija.IdNomina = this.Nomina_stNomina.IdNomina;
                                                                                    deduccioncuotafija.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO").SingleOrDefault().IdPlantillaNominaDeduccion;
                                                                                    deduccioncuotafija.Importe = totaldiferencia;
                                                                                    deduccioncuotafija.Concepto = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.IdPlantillaNominaPercepcion == ele.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion; ;
                                                                                 
                                                                                        this.ListaDeduccionesTrabajadores.Add(deduccioncuotafija);
                                                                                }
                                                                            }

                                                                        }



                                                                    }
                                                                }
                                                                else
                                                                    {
                                                                    // cambio de relacion
//                                                                    string ultimaspercepcionessql = @"
//SELECT np.*, pp.*, cp.*
//FROM Percepciones_stNominaTrabajadorPercepciones np
//INNER JOIN Nomina_stNominaTrabajador a ON np.IdNominaTrabajador = a.IdNominaTrabajador
//INNER JOIN Nomina_stNomina b ON a.idnomina = b.idnomina
//INNER JOIN [Nomina_ctPlantillaNomina] c ON b.idplantillanomina = c.idplantillanomina
//INNER JOIN Convenios_stConvenioLaboralTrabajadorCategoria d ON d.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
//INNER JOIN Convenios_stConvenioLaboralTrabajador w ON w.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
//INNER JOIN Plazas_stDistribucionPlazaCategoria f ON f.IdDistribucionPlazaCategoria = d.IdDistribucionPlazaCategoria
//INNER JOIN Nomina_stNominaTrabajadorEstatus q ON q.IdNominaTrabajadorEstatus = a.IdNominaTrabajadorEstatus
//INNER JOIN Nomina_stNominaTrabajadorEstatusGrupo gn ON gn.IdNominaTrabajadorEstatusGrupo = q.IdNominaTrabajadorEstatusGrupo
//INNER JOIN Percepciones_stPlantillaNominaPercepciones pp ON pp.IdPlantillaNominaPercepcion = np.IdPlantillaNominaPercepcion
//INNER JOIN Percepciones_ctPercepcion cp ON cp.IdPercepcion = pp.IdPercepcion
//WHERE gn.EstatusNominaGrupo = 'PARA PAGO'
//  AND b.EsCerrada = 1
//  AND c.Plantilla LIKE @cadenasueldo
//  AND w.IdTrabajador = @IdTrabajador
//  AND a.IdConvenioLaboralTrabajadorCategoria <> @IdConvenioLaboralTrabajadorCategoria
//ORDER BY a.idnominatrabajador DESC";

//                                                                    var parametros = new
//                                                                    {
//                                                                        cadenasueldo = $"%{cadenasueldo}%",
//                                                                        IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador,
//                                                                        IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria
//                                                                    };

//                                                                    var lookup = new Dictionary<long, Percepciones_stNominaTrabajadorPercepciones>();

//                                                                    var ultimaspercepciones = dp.connection.Query<Percepciones_stNominaTrabajadorPercepciones, Percepciones_stPlantillaNominaPercepciones, Percepciones_ctPercepcion, Percepciones_stNominaTrabajadorPercepciones>(
//                                                                        ultimaspercepcionessql,
//                                                                        (np, pp, cp) =>
//                                                                        {
//                                                                            if (!lookup.TryGetValue(np.IdNominaTrabajadorPercepcion, out var nominaTrabajadorPercepcion))
//                                                                            {
//                                                                                lookup.Add(np.IdNominaTrabajadorPercepcion, nominaTrabajadorPercepcion = np);
//                                                                            }

//                                                                            if (nominaTrabajadorPercepcion.Percepciones_stPlantillaNominaPercepciones == null)
//                                                                            {
//                                                                                nominaTrabajadorPercepcion.Percepciones_stPlantillaNominaPercepciones = pp;
//                                                                            }

//                                                                            if (nominaTrabajadorPercepcion.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion == null)
//                                                                            {
//                                                                                nominaTrabajadorPercepcion.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion = cp;
//                                                                            }

//                                                                            return nominaTrabajadorPercepcion;
//                                                                        },
//                                                                        parametros,
//                                                                        splitOn: "IdPlantillaNominaPercepcion,IdPercepcion"
//                                                                    ).Distinct().ToList();

                                                                    var ultimanominatrabajador = ultimanominapagadaTrabajador.FirstOrDefault();
                                                                    foreach (var ele in percepcionesactuales)
                                                                    {


                                                                        var percepcionultima = ultimaspercepciones.Where(a =>
                                                                        a.IdNominaTrabajador== ultimanominatrabajador.IdNominaTrabajador &&
                                                                        a.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.IdPercepcion == ele.IdPercepcion).FirstOrDefault();
                                                                         
                                                                        bool espercepcion = true;

                                                                        Sueldodiario = ele.Importe / diaslaborados;

                                                                        if (percepcionultima != null)
                                                                        {
                                                                            var sueldodiarioultimo = 0M;


                                                                            sueldodiarioultimo = percepcionultima.Importe / ultimanominatrabajador.DiasEfectivosLaborados;

                                                                            if (sueldodiarioultimo < Sueldodiario)
                                                                            {
                                                                                //percepcion
                                                                                var difer = sueldodiarioultimo - Sueldodiario;
                                                                                importeAjuste = (decimal)diasDeAjuste * difer;
                                                                            }
                                                                            else
                                                                            {
                                                                                espercepcion = false;
                                                                                var difer = sueldodiarioultimo-Sueldodiario  ;
                                                                                importeAjuste = (decimal)diasDeAjuste * difer;


                                                                            }

                                                                            var totaldiferencia = 0M;
                                                                            var totaldiferenciaRound = 0M;

                                                                            totaldiferencia = Math.Round(importeAjuste, 2);
                                                                            totaldiferenciaRound = Math.Round(importeAjuste, 1);

                                                                         
                                                                            if (importeAjuste > 0)
                                                                            {




                                                                                totaldiferencia = Math.Round(importeAjuste, 2);
                                                                                totaldiferenciaRound = Math.Round(importeAjuste, 1);

                                                                                // SI ES POSITIVO SE LE AGREGA COMO PERCEPCION
                                                                                if (espercepcion)
                                                                                {

                                                                                    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                                                                                    percepcion.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                                                                    percepcion.IdNomina = this.IdNomina;
                                                                                    percepcion.IdPlantillaNominaPercepcion = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().IdPlantillaNominaPercepcion;
                                                                                    percepcion.Importe = totaldiferencia;

                                                                                    percepcion.Tipo = "NORMAL";
                                                                                    percepcion.EsGrabable = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                                                                    percepcion.Concepto = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.IdPlantillaNominaPercepcion == ele.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion;
                                                                                    percepcion.EsVariable = (bool)this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                                                                    percepcion.EsPrevisionSocial = (bool)this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                                                                    this.ListaPercepcionesTrabajadores.Add(percepcion);

                                                                                    if (percepcion.Concepto.Contains("SUELDO")
                                           && item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
                                                                                    {
                                                                                        DeduccionesNominaTrabajador deduccionCUOTA = new DeduccionesNominaTrabajador();
                                                                                        deduccionCUOTA.EsImprimibleRecibo = true;
                                                                                        deduccionCUOTA.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                                                                        deduccionCUOTA.IdNomina = this.Nomina_stNomina.IdNomina;
                                                                                        deduccionCUOTA.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "DIFERENCIA").FirstOrDefault().IdPlantillaNominaDeduccion;
                                                                                        deduccionCUOTA.Concepto = " CUOTA SINDICAL";

                                                                                        deduccionCUOTA.Importe = Math.Round(percepcion.Importe * 0.01M, 2);


                                                                                        this.ListaDeduccionesTrabajadores.Add(deduccionCUOTA);
                                                                                    }
                                                                                }
                                                                                else {

                                                                                    DeduccionesNominaTrabajador deduccioncuotafija = new DeduccionesNominaTrabajador();
                                                                                    deduccioncuotafija.EsImprimibleRecibo = true;
                                                                                    deduccioncuotafija.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                                                                    deduccioncuotafija.IdNomina = this.Nomina_stNomina.IdNomina;
                                                                                    deduccioncuotafija.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO").SingleOrDefault().IdPlantillaNominaDeduccion;
                                                                                    deduccioncuotafija.Importe = totaldiferencia;
                                                                                    deduccioncuotafija.Concepto = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.IdPlantillaNominaPercepcion == ele.IdPlantillaNominaPercepcion).FirstOrDefault().Percepciones_ctPercepcion.Percepcion; ;

                                                                                    this.ListaDeduccionesTrabajadores.Add(deduccioncuotafija);
                                                                                }
                                                                            }
                                                                        }
                                                                    }

                                                                }
                                                                //AJUSTE DE INFONAVIT

                                                               // CalcularAjusteDeduccionInfonavit(item, diasDeAjuste);

                                                                /////antes for each nuevas
                                                            }
                                                        }





                                                    }
                                                }
                                                catch (Exception ex)
                                                {

                                                    string s = "";
                                                }
                                            }
                                        }
                                    }
                        }


                    dp.Close();

                }
            }

        }

        private void generarPercepcionesPorTipodeHoras(string tipoHoras, Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, AjusteHorasFechaAplicacion totalhorasAjuste,int horasenforeach=0)
        {
            Plazas_ctCostoHoraJornada costos = this.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.IdCategoria).FirstOrDefault();

            List<Percepciones_stPlantillaNominaPercepciones> uni = new List<Percepciones_stPlantillaNominaPercepciones>();
            if (tipoHoras != "")
            {
                if (tipoHoras=="HORAS CLUB")
                    uni = this.PlantillaNominaPercepcionesRelacionLaboral.Where(s =>
             (s.Percepciones_ctPercepcion.Percepcion.Contains("SUELDO HORAS CLUB") 
             || s.Percepciones_ctPercepcion.Percepcion.Contains("AYUDA PARA MATERIAL DIDÁCTICO HORAS CLUB"))
              &&
             s.IdPlantillaNomina == this.Nomina_stNomina.IdPlantillaNomina && s.Percepciones_ctPercepcion.EsSDI == true).ToList();
               else
                    uni = this.PlantillaNominaPercepcionesRelacionLaboral.Where(s =>
             (s.Percepciones_ctPercepcion.Percepcion.Contains(tipoHoras)
             || s.Percepciones_ctPercepcion.IncluirParaAjusteDeHorasExcedentes == true) &&
             s.IdPlantillaNomina == this.Nomina_stNomina.IdPlantillaNomina && s.Percepciones_ctPercepcion.EsSDI == true).ToList();
            }
            else
                uni = this.PlantillaNominaPercepcionesRelacionLaboral.Where(s =>
             s.IdPlantillaNomina == this.Nomina_stNomina.IdPlantillaNomina && s.Percepciones_ctPercepcion.EsSDI == true).ToList();


            foreach (var dato in uni)
            {

                if (dato.Calcular)
                {

                    var sueldopercep = this.PlantillaNominaPercepcionesRelacionLaboral.Where(s => s.Percepciones_ctPercepcion.Percepcion == dato.Percepciones_ctPercepcion.Percepcion).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
                    Decimal Sueldodiario = 0;
                    var diaslaborados = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;



                    if (tipoHoras.Contains("EXCEDENTE"))
                    {
                        //if (dato.Percepciones_ctPercepcion.Percepcion == "COMPENSACION POR ACTUACION Y PRODUCTIVIDAD")
                        //{
                        //    if (totalhorasAjuste.HorasExcedentesNominaActual > 0)
                        //    {
                        //        Sueldodiario = (decimal)this.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / (totalhorasAjuste.HorasExcedentesNominaActual + totalhorasAjuste.HorasJornadaNominaActual);
                        //    }
                        //}
                        //else
                        if (totalhorasAjuste.HorasExcedentesNominaActual > 0)
                        {
                            if (dato.Percepciones_ctPercepcion.Percepcion == "COMPENSACION POR ACTUACION Y PRODUCTIVIDAD"
                                || dato.Percepciones_ctPercepcion.Percepcion == "GUARDERIA")
                                Sueldodiario = (decimal)this.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / (totalhorasAjuste.HorasExcedentesNominaActual + totalhorasAjuste.HorasJornadaNominaActual);
                            else
                                Sueldodiario = (decimal)this.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / totalhorasAjuste.HorasExcedentesNominaActual;
                        }
                    }
                    else
                    {
                        var ultimanomina=this.NominasAnterioresPagadas.Where(z => sueldopercep.Contains(z.IdPlantillaNominaPercepcion) && 
                        z.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(z=> z.Importe );

                        var tmpsueldo = (decimal)this.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe);

                        var difdiaria = (tmpsueldo - ultimanomina) / diaslaborados;
                        
                        // se agrego esta condicion caso CRISTINA MONTALVO QUE TENIA 10 HORAS Y DESPÚES REGRESO A 30
                        if ((totalhorasAjuste.HorasJornadaNominaActual - totalhorasAjuste.Horas) > costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo)
                        {


                            if (tipoHoras.Contains("HORAS CLUB"))
                            {
                                Sueldodiario = tmpsueldo;
                            }
                            else
                            {
                                var tmphorasjornada = this.ListaVariablesNominaTrabajador.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                            && q.Concepto == "HorasSemanaMes").FirstOrDefault();
                                if (tmphorasjornada != null)
                                    if (tmphorasjornada.Importe > 0)
                                        Sueldodiario = tmpsueldo / tmphorasjornada.Importe;
                            }
                        }
                        else
                        {

                            Sueldodiario = difdiaria ;
                        }

                    }

                    //devoluciones



                    decimal importeAjuste = 0M;
                    int horasDeajuste = totalhorasAjuste.Horas;
                    if (horasenforeach > 0)
                        horasDeajuste = horasenforeach;
                   
                        if (horasDeajuste != 0)
                        {
                        if ((totalhorasAjuste.HorasJornadaNominaActual - totalhorasAjuste.Horas) > costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo)
                        {


                            if (tipoHoras != "")
                            {
                                if (horasDeajuste < 0)
                                {
                                    if (dato.Percepciones_ctPercepcion.Percepcion == "COMPENSACION POR ACTUACION Y PRODUCTIVIDAD"
                                        || dato.Percepciones_ctPercepcion.Percepcion == "GUARDERIA")
                                        Sueldodiario = ((totalhorasAjuste.HorasExcedentes) * Sueldodiario) / diaslaborados;
                                    else
                                        Sueldodiario = ((totalhorasAjuste.HorasExcedentes * -1) * Sueldodiario) / 15;

                                    importeAjuste = (decimal)totalhorasAjuste.DiasAAjustar * Sueldodiario;
                                }
                                else
                                {
                                    if (tipoHoras == "HORAS CLUB")
                                    {
                                        Sueldodiario = Sueldodiario / 15;
                                    }
                                    else
                                        if (dato.Percepciones_ctPercepcion.Percepcion == "COMPENSACION POR ACTUACION Y PRODUCTIVIDAD"
                                        || dato.Percepciones_ctPercepcion.Percepcion == "GUARDERIA")
                                        Sueldodiario = ((totalhorasAjuste.HorasExcedentes) * Sueldodiario) / diaslaborados;
                                    else
                                        Sueldodiario = ((totalhorasAjuste.HorasExcedentes) * Sueldodiario) / 15;

                                    importeAjuste = (decimal)totalhorasAjuste.DiasAAjustar * Sueldodiario;
                                }
                            }
                            else
                            {
                                if (horasDeajuste < 0)
                                {
                                    Sueldodiario = ((totalhorasAjuste.HorasJornada * -1) * Sueldodiario) / 15;
                                    importeAjuste = (decimal)totalhorasAjuste.DiasAAjustar * Sueldodiario;
                                }
                                else
                                {
                                    Sueldodiario = ((totalhorasAjuste.HorasJornada) * Sueldodiario) / 15;
                                    importeAjuste = (decimal)totalhorasAjuste.DiasAAjustar * Sueldodiario;
                                }
                            }
                        }
                        else
                        {
                            importeAjuste = (decimal)totalhorasAjuste.DiasAAjustar * Sueldodiario;
                        }

                            if (horasDeajuste > 0)
                            {
                                if (importeAjuste > 0)
                                {
                                    PercepcionesNominaTrabajador percepcionAjuste = new PercepcionesNominaTrabajador();

                                    percepcionAjuste.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    percepcionAjuste.IdNomina = this.IdNomina;
                                    if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
                                    {
                                        percepcionAjuste.IdPlantillaNominaPercepcion = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().IdPlantillaNominaPercepcion;
                                        percepcionAjuste.Tipo = "NORMAL";
                                        percepcionAjuste.EsGrabable = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                        percepcionAjuste.Concepto = dato.Percepciones_ctPercepcion.Percepcion;
                                        percepcionAjuste.EsVariable = (bool)this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                        percepcionAjuste.EsPrevisionSocial = (bool)this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                    }
                                    else
                                    {
                                        percepcionAjuste.IdPlantillaNominaPercepcion = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().IdPlantillaNominaPercepcion;


                                        percepcionAjuste.Tipo = "NORMAL";
                                        percepcionAjuste.EsGrabable = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                        percepcionAjuste.Concepto = dato.Percepciones_ctPercepcion.Percepcion;
                                        percepcionAjuste.EsVariable = (bool)this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                        percepcionAjuste.EsPrevisionSocial = (bool)this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                    }
                                    percepcionAjuste.Importe = importeAjuste;
                                    this.ListaPercepcionesTrabajadores.Add(percepcionAjuste);

                                }
                            }
                            else
                            if (horasDeajuste < 0)
                                if (importeAjuste > 0)
                                {

                                    DeduccionesNominaTrabajador deduccioncuotafija = new DeduccionesNominaTrabajador();
                                    deduccioncuotafija.EsImprimibleRecibo = true;
                                    deduccioncuotafija.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    deduccioncuotafija.IdNomina = this.Nomina_stNomina.IdNomina;
                                    deduccioncuotafija.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO").SingleOrDefault().IdPlantillaNominaDeduccion;
                                    deduccioncuotafija.Importe = importeAjuste;
                                    deduccioncuotafija.Concepto = dato.Percepciones_ctPercepcion.Percepcion; ;

                                    this.ListaDeduccionesTrabajadores.Add(deduccioncuotafija);
                                }
                        }
                    
                    
                }
            }//
        }
        public void GenerarAjustesPerpcecionesCambiodeHoras(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria)
        {
            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.UsaHorariosDocentesParaCalculo == true)
            {
                var totalhorasAjuste = this.ValidaAjusteHorasDocente(ConvenioLaboralTrabajadorCategoria);

                if (totalhorasAjuste.Horas != 0)
                {
                    if (totalhorasAjuste.HorasExcedentes != 0)
                    {
                        var agrupadosPorTipoHoras = totalhorasAjuste.NominaHorariosDocentesDetalle
                        .GroupBy(item => item.TipoHoras)
                        .Select(grupo => new
                        {
                            TipoHoras = grupo.Key,
                            Cantidad = grupo.Count()
                        })
                        .ToList();
                        foreach (var item in agrupadosPorTipoHoras)
                        {
                            generarPercepcionesPorTipodeHoras(item.TipoHoras, ConvenioLaboralTrabajadorCategoria, totalhorasAjuste, item.Cantidad);
                        }
                        
                    }
                    if (totalhorasAjuste.HorasJornada != 0)
                        generarPercepcionesPorTipodeHoras("", ConvenioLaboralTrabajadorCategoria, totalhorasAjuste);
                }
            }

        }

        public void CalcularAjusteDeduccionesLicenciasUHorasEntreHorarios(Convenios_stConvenioLaboralTrabajadorCategoria item)
        {
            var existeAjusteLicencia = this.AjustesLicenciasSinGoceSueldoSegunNominas
                .FirstOrDefault(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria);
            
            
            var existeajustecargahoraia=this.ListaVariablesNominaTrabajador.Where(a=> a.IdConvenioLaboralTrabajadorCategoria==item.IdConvenioLaboralTrabajadorCategoria
            && a.Concepto== "existecargapasada_totaldiasajuste").FirstOrDefault();

            if (existeAjusteLicencia != null)
            {
                var sinAjuste = this.ListaVariablesNominaTrabajador
                    .FirstOrDefault(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "SinAjuste");

                if (sinAjuste == null)
                {
                    DateTime fechaInicio = existeAjusteLicencia.FechaAjusteLicencia.Value;
                    DateTime fechaFin = this.Nomina_stNomina.FechaInicio;

                    int diasRemanentes = CalcularDiasAjustados(fechaInicio, fechaFin);

                    // Cálculo de ajuste para la deducción del IMSS
                    CalcularAjusteDeduccionIMSS(item, diasRemanentes);

                    // Cálculo de ajuste para la deducción de Cuota Sindical
                    CalcularAjusteDeduccionCuotaSindical(item, diasRemanentes);
                }
            }
            else
                if (existeajustecargahoraia != null)
            {
                CalcularAjusteDeduccionIMSS(item, (int)existeajustecargahoraia.Importe);
            }
        }

        public void CalcularAjusteDeduccionInfonavit   (Convenios_stConvenioLaboralTrabajadorCategoria item)
        {

            
                var diasdeajustepercepciones = this.ListaVariablesNominaTrabajador
                .FirstOrDefault(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && a.Concepto == "diasdeajustepercepciones");

            var diasIMSS = this.ListaVariablesNominaTrabajador
                .FirstOrDefault(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && a.Concepto == "DIASLABORADOS");

            var miscreditoslista = this.CreditosTrabajador.Where(s => 
 s.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador
&& s.Catalogos_ctTipoCredito.TipoCredito=="INFONAVIT").FirstOrDefault();

            if (miscreditoslista != null)
            {
                var infonavit = ListaCreditosTrabajador.Where(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                && a.IdCreditoTrabajador == miscreditoslista.IdCreditoTrabajador).FirstOrDefault();

                //var existeIMSS = this.PlantillaNominaDeducciones.FirstOrDefault(x => x.Deducciones_ctDeduccion.Deduccion == "");

                //var ajusteExistenteIMSS = this.ListaDeduccionesTrabajadores
                //    .FirstOrDefault(x => x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria &&
                //                         x.IdPlantillaNominaDeduccion == existeIMSS.IdPlantillaNominaDeduccion);

                var idDeducDiferencia = this.PlantillaNominaDeducciones
                    .FirstOrDefault(x => x.Deducciones_ctDeduccion.Deduccion == "DIFERENCIA");

                if (diasdeajustepercepciones != null && miscreditoslista != null && infonavit != null && idDeducDiferencia != null)
                {
                    decimal imssDeduccionDiaria = infonavit.Importe / diasIMSS.Importe;
                    decimal importeAjusteIMSS = imssDeduccionDiaria * diasdeajustepercepciones.Importe;

                    AgregarOActualizarAjuste(item, importeAjusteIMSS, "INFONAVIT", idDeducDiferencia.IdPlantillaNominaDeduccion);
                }
            }
        }

        private void CalcularAjusteDeduccionIMSS(Convenios_stConvenioLaboralTrabajadorCategoria item, int diasRemanentes)
        {
            var diasIMSS = this.ListaVariablesNominaTrabajador
                .FirstOrDefault(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && a.Concepto == "DiasQuincenaIMSS");

            var existeIMSS = this.PlantillaNominaDeducciones.FirstOrDefault(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS");

            var ajusteExistenteIMSS = this.ListaDeduccionesTrabajadores
                .FirstOrDefault(x => x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria &&
                                     x.IdPlantillaNominaDeduccion == existeIMSS.IdPlantillaNominaDeduccion);

            var idDeducDiferencia = this.PlantillaNominaDeducciones
                .FirstOrDefault(x => x.Deducciones_ctDeduccion.Deduccion == "DIFERENCIA");

            if (diasIMSS != null && ajusteExistenteIMSS != null && idDeducDiferencia != null)
            {
                decimal imssDeduccionDiaria = ajusteExistenteIMSS.Importe / diasIMSS.Importe;
                decimal importeAjusteIMSS = imssDeduccionDiaria * diasRemanentes;

                AgregarOActualizarAjuste(item, importeAjusteIMSS, "IMSS", idDeducDiferencia.IdPlantillaNominaDeduccion);
            }
        }

        private void CalcularAjusteDeduccionCuotaSindical(Convenios_stConvenioLaboralTrabajadorCategoria item, int diasRemanentes)
        {
            var existeCuotaSindical = this.PlantillaNominaDeducciones.FirstOrDefault(x => x.Deducciones_ctDeduccion.Deduccion == "CUOTA SINDICAL");

            var ajusteExistenteCuotaSindical = this.ListaDeduccionesTrabajadores
                .FirstOrDefault(x => x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria &&
                                     x.IdPlantillaNominaDeduccion == existeCuotaSindical.IdPlantillaNominaDeduccion);

            var idDeducDiferencia = this.PlantillaNominaDeducciones
                .FirstOrDefault(x => x.Deducciones_ctDeduccion.Deduccion == "DIFERENCIA");

            if (ajusteExistenteCuotaSindical != null && idDeducDiferencia != null)
            {
                decimal importeAjusteCuotaSindical = ajusteExistenteCuotaSindical.Importe / 15 * diasRemanentes;

                AgregarOActualizarAjuste(item, importeAjusteCuotaSindical, "CUOTA SINDICAL", idDeducDiferencia.IdPlantillaNominaDeduccion);
            }
        }

        private void AgregarOActualizarAjuste(Convenios_stConvenioLaboralTrabajadorCategoria item, decimal importeAjuste, string conceptoDiferencia, int idPlantillaNominaDeduccion)
        {
            if (importeAjuste > 0)
            {
                var ajusteDiferenciaExistente = this.ListaDeduccionesTrabajadores
                    .FirstOrDefault(x => x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria &&
                                         x.Concepto == conceptoDiferencia);

                if (ajusteDiferenciaExistente != null)
                {
                    ajusteDiferenciaExistente.Importe += importeAjuste;
                }
                else
                {
                    DeduccionesNominaTrabajador nuevoAjuste = new DeduccionesNominaTrabajador
                    {
                        IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria,
                        IdNomina = this.IdNomina,
                        IdPlantillaNominaDeduccion = (short)idPlantillaNominaDeduccion,
                        Importe = importeAjuste,
                        Concepto = conceptoDiferencia,
                        EsImprimibleRecibo = true
                    };

                    this.ListaDeduccionesTrabajadores.Add(nuevoAjuste);
                }
            }
        }
        public void CalcularAjustePercepcionesLicencias(Convenios_stConvenioLaboralTrabajadorCategoria item)
        {
            var existeAjusteLicencia = this.AjustesLicenciasSinGoceSueldoSegunNominas
                .FirstOrDefault(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria);

            if (existeAjusteLicencia != null)
            {
                var sinAjuste = this.ListaVariablesNominaTrabajador
                    .FirstOrDefault(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "SinAjuste");

                if (sinAjuste == null)
                {
                    DateTime fechaInicio = existeAjusteLicencia.FechaAjusteLicencia.Value;
                    DateTime fechaFin = this.Nomina_stNomina.FechaInicio.AddDays(1);

                    int diasRemanentes = CalcularDiasAjustados(fechaInicio, fechaFin);

                    foreach (var percepcion in this.PlantillaNominaPercepcionesRelacionLaboral.Where(p => p.Calcular==true && p.Percepciones_ctPercepcion.EsSDI==true))
                    {
                        var percepcionesExistentes = this.ListaPercepcionesTrabajadores
                            .Where(x => x.IdPlantillaNominaPercepcion == percepcion.IdPlantillaNominaPercepcion &&
                                        x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria)
                            .ToList();

                        if (percepcionesExistentes.Any())
                        {
                            decimal sueldoDiario = percepcionesExistentes.Sum(p => p.Importe) / this.DiasNomina;
                            decimal importeAjuste = sueldoDiario * diasRemanentes;

                            if (importeAjuste > 0)
                            {
                                var ajusteExistente = this.ListaPercepcionesTrabajadores
                                    .FirstOrDefault(x => x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria &&
                                                         x.Concepto == percepcion.Percepciones_ctPercepcion.Percepcion);

                                if (ajusteExistente != null)
                                {
                                    ajusteExistente.Importe += importeAjuste;
                                }
                                else
                                {
                                    PercepcionesNominaTrabajador nuevoAjuste = new PercepcionesNominaTrabajador
                                    {
                                        IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria,
                                        IdNomina = this.IdNomina,
                                        IdPlantillaNominaPercepcion = this.PlantillaNominaPercepciones
                                            .FirstOrDefault(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").IdPlantillaNominaPercepcion,
                                        Importe = importeAjuste,
                                        Tipo = "NORMAL",
                                        EsGrabable = percepcion.Percepciones_ctPercepcion.EsGravable,
                                        Concepto =  percepcion.Percepciones_ctPercepcion.Percepcion,
                                        EsVariable = (bool)percepcion.Percepciones_ctPercepcion.EsVariable ,
                                        EsPrevisionSocial = percepcion.Percepciones_ctPercepcion.EsPrevisionSocial
                                    };

                                    this.ListaPercepcionesTrabajadores.Add(nuevoAjuste);
                                }
                            }
                        }
                    }

 

                        VariablesNominaTrabajador vnt = new VariablesNominaTrabajador
                    {
                        Concepto = "AjustePercepciones",
                        IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria
                    };
                    this.ListaVariablesNominaTrabajador.Add(vnt);
                }
            }
        }

        private int CalcularDiasAjustados(DateTime fechaInicio, DateTime fechaFin)
        {
            int diasTotales = 0;
            DateTime fechaActual = fechaInicio;

            while (fechaActual < fechaFin)
            {
                int diasEnMes;
                if (fechaActual.Month == 2) // Febrero
                {
                    diasEnMes = 15; // Ajustamos a 15 días para febrero
                }
                else if (fechaActual.Day <= 15)
                {
                    diasEnMes = 15;
                }
                else
                {
                    diasEnMes = DateTime.DaysInMonth(fechaActual.Year, fechaActual.Month) - 15;
                }

                DateTime finQuincena = new DateTime(fechaActual.Year, fechaActual.Month,
                    fechaActual.Day <= 15 ? 15 : DateTime.DaysInMonth(fechaActual.Year, fechaActual.Month));

                if (finQuincena > fechaFin)
                {
                    finQuincena = fechaFin;
                }

                int diasEnEstaParte = (finQuincena - fechaActual).Days + 1;
                diasTotales += Math.Min(diasEnEstaParte, diasEnMes);

                fechaActual = finQuincena.AddDays(1);
            }

            return diasTotales;
        }

        public void GenerarAjustesPerpcecionesHorasExtraOrdinarias(Convenios_stConvenioLaboralTrabajadorCategoria item, bool calcularIMSS = false)
        {
            bool calcularnomina = true;
            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("DESPENSA")
                && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
            {
                calcularnomina = false;
            }

            bool horasextraordinarias = false;
            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("HORAS EXTRAORDINARIAS") 
                && this.Nomina_stNomina.Nomina_ctPlantillaNomina.UsaHorariosDocentesParaCalculo)
                horasextraordinarias = true;
            if (horasextraordinarias)
            {
                bool calculaajuste = false;
                var horario = this.HorariosVigenteAnteriorTrabajador;
                if (horario.NominaHorariosDocentesDetalle.Where(a => a.Aplicado == false).FirstOrDefault() != null)
                    calculaajuste = true;

                var fechainicialpago = horario.NominaHorariosDocentesDetalle.Select(a => a.FechaInicioPago).FirstOrDefault();

                int diasdediferenciaentrecontratos = (int)(this.Nomina_stNomina.FechaInicio - fechainicialpago.Value).TotalDays;

                var mesescon31dias1 = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(fechainicialpago.Value, this.Nomina_stNomina.FechaInicio);
                var diasFebrero1 = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(fechainicialpago.Value, this.Nomina_stNomina.FechaInicio);
                diasdediferenciaentrecontratos = (diasdediferenciaentrecontratos - mesescon31dias1) + diasFebrero1;


                if (calculaajuste && horario.HorarioVigente && horario.EsHorarioHorasExtraordinarias && horario.SinAplicar)
                {

                    var HorasJornada = this.ListaVariablesNominaTrabajador.Where(q => q.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                    && q.Concepto == "HorasSemanaMes").FirstOrDefault().Importe;

                    //var idp = this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO DOCENTE").FirstOrDefault().IdPlantillaNominaPercepcion;

                    //var sueldonomina = this.ListaPercepcionesTrabajadores.Where(s => s.IdPlantillaNominaPercepcion == idp
                    //&& s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                    int diaslaborados = (int)this.ListaVariablesNominaTrabajador.Where(s => s.Concepto == "DIASLABORADOS" && s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe;

                    Plazas_ctCostoHoraJornada costos = this.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                    //              var sueldodiario sueldonomina.Importe/
                    //                horasjornada

                    var sueldo = 0M;

                    //if (item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                    //{


                    //    if (HorasJornada < costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo)
                    //    {
                    //        decimal totalsueldo = 0;
                    //        if (HorasJornada <= 19)
                    //        {

                    //            //totalsueldo = Decimal.Round(costos.CostoPorHoraExcedente * HorasJornada * 2, 4);
                    //            totalsueldo = Decimal.Round((costos.CostoPorHoraExcedente * (HorasJornada * 2) / 15) * diasdediferenciaentrecontratos, 4);
                    //        }
                    //        else
                    //        {
                    //            decimal t = (decimal)(costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo * costos.CostoPorHora) * 2;
                    //            decimal hm = (decimal)costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo;
                    //            //totalsueldo = Decimal.Round(((t * HorasJornada)/hm), 4);

                    //            totalsueldo = Decimal.Round(((t * ((HorasJornada) / 15M) * diasdediferenciaentrecontratos) / hm), 4);
                    //        }
                    //        sueldo = totalsueldo;

                    //    }
                    //    else
                    //    {


                    //        sueldo = Decimal.Round(((costos.CostoPorHora * HorasJornada * 2) / 15) * diasdediferenciaentrecontratos, 4);
                    //    }
                    //}
                    var plazatrabajador = this.Plazas_ctCategoria.Where(s => s.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria).FirstOrDefault();

                    double diasremanentes = diasdediferenciaentrecontratos;
                    var contador = 0;
                    foreach (var per in PlantillaNominaPercepcionesRelacionLaboral.Where(s => s.Percepciones_ctPercepcion.AjustarCambioCategoria == true &&
                    s.IdPlantillaNomina == this.Nomina_stNomina.IdPlantillaNomina))
                    {
                        contador++;
                        var SinAjuste = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "SinAjuste").FirstOrDefault();

                        Boolean CalcularExcepcion = true;
                        if (per.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA")
                            if (!AyudaDespensaExcepciones.Calcular(item))
                                CalcularExcepcion = false;

                        if (CalcularExcepcion)
                        {



                            var sueldopercep = this.PlantillaNominaPercepcionesRelacionLaboral.Where(s => s.Percepciones_ctPercepcion.Percepcion == per.Percepciones_ctPercepcion.Percepcion).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
                            Decimal Sueldodiario = 0;

                            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("DESPENSA")
                                && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONFIANZA"))
                            {
                                if (per.Percepciones_ctPercepcion.Percepciones_ctPercepcionPeriodo.PercepcionPeriodo == "Mensual")
                                    Sueldodiario = (decimal)this.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / 30;
                                else
                                    Sueldodiario = ((decimal)this.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / this.DiasNomina);

                            }
                            else
                            {
                                if (per.Percepciones_ctPercepcion.Percepciones_ctPercepcionPeriodo.PercepcionPeriodo == "Mensual")
                                    Sueldodiario = (decimal)this.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / 30;
                                else
                                    Sueldodiario = ((decimal)this.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / diaslaborados);
                            }


                            //devoluciones
                            int mesescon31dias = 0;

                            double diasremanentesIMSS = 0;

                            int diasFebrero = 0;





                            //if (item.FechaTermino < this.Nomina_stNomina.FechaInicio)
                            //{


                            //    var diasTotalesContrato = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "TerminoContratoDiasPagados").FirstOrDefault().Importe;
                            //    diasremanentes = (double)diasTotalesContrato;

                            //    diasremanentesIMSS = diasremanentes;
                            //    if (plazatrabajador.CalcularNominaDiasCalendario == false || (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AYUDA PARA DESPENSA")))
                            //    {
                            //        mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(item.FechaInicio, (DateTime)item.FechaTermino);
                            //        diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(item.FechaInicio, (DateTime)item.FechaTermino);
                            //    }
                            //}
                            //else
                            //if (item.FechaInicioPago != null)
                            //{

                            //    TimeSpan Diff_dates = item.FechaInicioPago.Value.Subtract(item.FechaInicio);
                            //    diasremanentes = Diff_dates.Days;
                            //    diasremanentesIMSS = diasremanentes;

                            //    if (plazatrabajador.CalcularNominaDiasCalendario == false || (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AYUDA PARA DESPENSA")))
                            //    {
                            //        mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(item.FechaInicio, (DateTime)item.FechaInicioPago);
                            //        diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(item.FechaInicio, (DateTime)item.FechaInicioPago);
                            //    }
                            //}
                            //else
                            //{

                            //    TimeSpan Diff_dates = this.Nomina_stNomina.FechaInicio.AddDays(-1).Subtract(item.FechaInicio.AddDays(-1));
                            //    diasremanentes = Diff_dates.Days;
                            //    diasremanentesIMSS = diasremanentes;

                            //    if (plazatrabajador.CalcularNominaDiasCalendario == false || (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AYUDA PARA DESPENSA")))
                            //    {
                            //        mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(item.FechaInicio, (DateTime)this.Nomina_stNomina.FechaInicio);
                            //        diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(item.FechaInicio, (DateTime)this.Nomina_stNomina.FechaInicio);
                            //    }
                            //}

                            //se quitan los dias de los meses con 31 en dado caso de que hay mas de 30 dias de dif

                            diasremanentes = (diasremanentes - mesescon31dias) + diasFebrero;



                            decimal importeAjuste = 0M;
                            if (diasremanentes > 0 && Sueldodiario > 0)
                            {


                                importeAjuste = (decimal)diasremanentes * Sueldodiario;

                                if (importeAjuste > 0 && calcularIMSS == false)
                                {
                                    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                                    percepcion.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                    percepcion.IdNomina = this.IdNomina;
                                    percepcion.IdPlantillaNominaPercepcion = this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().IdPlantillaNominaPercepcion;
                                    percepcion.Importe = importeAjuste;

                                    percepcion.Tipo = "NORMAL";
                                    percepcion.EsGrabable = this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                    percepcion.Concepto = per.Percepciones_ctPercepcion.Percepcion;
                                    percepcion.EsVariable = (bool)this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                    percepcion.EsPrevisionSocial = (bool)this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                    this.ListaPercepcionesTrabajadores.Add(percepcion);

                                    VariablesNominaTrabajador vnt9 = new VariablesNominaTrabajador();
                                    vnt9.Concepto = "ajustepercepciones";
                                    vnt9.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;

                                    this.ListaVariablesNominaTrabajador.Add(vnt9);

                                    VariablesNominaTrabajador vnt91 = new VariablesNominaTrabajador();
                                    vnt91.Concepto = "ajustepercepcionesPositiva";
                                    vnt91.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;

                                    this.ListaVariablesNominaTrabajador.Add(vnt91);
                                }
                            }
                        }
                    }



                }
            }
        }

        public void GenerarAjustesPerpceciones(Convenios_stConvenioLaboralTrabajadorCategoria item, bool calcularIMSS = false)
        {
            bool calcularnomina = true;
            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("DESPENSA")
                && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
                {
                calcularnomina = false;
            }

            bool horasextraordinarias = false;
            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("HORAS EXTRAORDINARIAS"))
                horasextraordinarias = true;


            if (!horasextraordinarias && calcularnomina && !this.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud)

                if (this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault() != null)
                {

                    var plazatrabajador = this.Plazas_ctCategoria.Where(s => s.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria).FirstOrDefault();

                    var existeajustelicencia = this.AjustesLicenciasSinGoceSueldoSegunNominas.Where(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                        var diaslaborados = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;
                    bool regresadeLicencia = false;
                    decimal TerminoContratoDias = 0M;
                     var TerminoContratoDiasSingle = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "ContratoSinPagoSoloAjuste").FirstOrDefault();
                    if (TerminoContratoDiasSingle != null)
                        TerminoContratoDias = TerminoContratoDiasSingle.Importe;

                        bool CambioMismaCategoria = false;
                        bool existecontratoscancelados = false;

                        var datos = this.getCambiosdeContratos().Where(s => s.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                        Boolean primercalculo = false;
                    bool ExistencontinudadNominas= false;
                    bool haycontinuidad = true;

                    if (datos != null)
                        {
                        //                            string sql = @"
                        // select b.*,c.IdCategoria,ff.RestringirMenu from
                        //             Convenios_stConvenioLaboralTrabajadorCategoria b
                        //            inner
                        //          join Plazas_stDistribucionPlazaCategoria c on c.IdDistribucionPlazaCategoria = b.IdDistribucionPlazaCategoria
                        //          inner
                        //          join Plazas_ctCategoria d on d.IdCategoria = c.IdCategoria
                        //          inner
                        //          join Convenios_stConvenioLaboralTrabajador f on f.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
                        //          inner
                        //          join Kardex_ctTrabajador g on g.IdTrabajador = f.IdTrabajador
                        //        left join vwDatosAspirantesTrabajadores ff on ff.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                        //          where f.IdTrabajador=" + item.Convenios_stConvenioLaboralTrabajador.IdTrabajador + @" and b.IdConvenioLaboralTrabajadorCategoria not in (
                        //select bb.IdConvenioLaboralTrabajadorCategoria  from Convenios_stConvenioLaboralTrabajadorCategoria bb 
                        //  inner join Plazas_stDistribucionPlazaCategoria cc on cc.IdDistribucionPlazaCategoria = bb.IdDistribucionPlazaCategoria 
                        //inner join Plazas_ctCategoria dd on dd.IdCategoria = cc.IdCategoria 
                        //inner join Convenios_stConvenioLaboralTrabajador ff on ff.IdConvenioLaboralTrabajador = bb.IdConvenioLaboralTrabajador 
                        //inner join Kardex_ctTrabajador gg on gg.IdTrabajador = ff.IdTrabajador 
                        //left join vwDatosAspirantesTrabajadores fff on fff.IdConvenioLaboralTrabajadorCategoria=bb.IdConvenioLaboralTrabajadorCategoria 
                        //  where 
                        //    (bb.FechaInicio=bb.FechaTermino and bb.FechaTermino is not null)
                        //)
                        //          ORDER BY b.FechaInicio desc,b.FechaTermino asc";



                                                    DapperQuery dp = new DapperQuery("bdNovaEntities");

                        //List<ConvenioLaboralTrabajadorCategoriaPlazas> convenios = (List<ConvenioLaboralTrabajadorCategoriaPlazas>)dp.connection.Query<ConvenioLaboralTrabajadorCategoriaPlazas>(sql.ToString());

                        var convenios = this.Convenios.Where(a => a.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToList();

//                            string sqlnominados = @"select d.*,f.IdCategoria,b.fechainicio as FechaInicioNomina,b.FechaTermino as FechaTerminoNomina
//from Nomina_stNominaTrabajador a
//inner join Nomina_stNomina b on a.idnomina=b.idnomina
//inner join [Nomina_ctPlantillaNomina] c on b.idplantillanomina=c.idplantillanomina
//inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria=a.IdConvenioLaboralTrabajadorCategoria
//inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador=d.IdConvenioLaboralTrabajador
//inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria=d.IdDistribucionPlazaCategoria
//inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
//inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
//where EstatusNominaGrupo ='PARA PAGO' and
//b.EsCerrada=1 and  c.Plantilla like '%sueldo%' and w.IdTrabajador=" + item.Convenios_stConvenioLaboralTrabajador.IdTrabajador + " and  a.idconveniolaboraltrabajadorcategoria<>" + item.IdConvenioLaboralTrabajadorCategoria + " order by a.idnominatrabajador desc";

                            //List<ConvenioLaboralTrabajadorCategoriaPlazas> ultimanominapagadaTrabajador = (List<ConvenioLaboralTrabajadorCategoriaPlazas>)dp.connection.Query<ConvenioLaboralTrabajadorCategoriaPlazas>(sqlnominados);
                            var ultimanominapagadaTrabajador = NominasAnterioresPagadas.Where(a=> a.IdTrabajador==item.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                            && a.IdConvenioLaboralTrabajadorCategoria!=item.IdConvenioLaboralTrabajadorCategoria ).ToList();

                      
                        if (ultimanominapagadaTrabajador.Count() > 0)
                        {
                            DateTime TerminoUltimaNomina = ultimanominapagadaTrabajador.FirstOrDefault().FechaTerminoNomina;
                            DateTime InicioNuevaNomina = this.Nomina_stNomina.FechaInicio;

                            if (InicioNuevaNomina == TerminoUltimaNomina.AddDays(1))
                            {
                                // Hay una interrupción
                                //  TimeSpan diferencia = InicioNuevaNomina - TerminoUltimaNomina;
                                ExistencontinudadNominas = true;


                            }
                            //if (item.EsPrimerCalculo && item.FechaInicio < this.Nomina_stNomina.FechaInicio &&
                            //    ExistencontinudadNominas )
                            //{
                            //    // se le deben dias
                            //    ExistencontinudadNominas = false;
                            //}
                            

                        }


                        var regresalic=this.LicenciasTrabajadores.Where(s => s.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                        dp.Close();

                        


                            bool ExistenominaPagadaconOtraCategoria = false;

                        if (regresalic != null)
                        {
                            if (regresalic.FechaTerminoIncidencia <= this.Nomina_stNomina.FechaTermino)
                            {
                                regresadeLicencia = true;
                            }
                        }
                        if (convenios.Count > 1)
                            if (convenios[0].EsPrimerCalculo)//solo si es el primer calculo de esta plaza se realiza el ajuste

                            //caso yadira, al inicio del 2021 se genera un calculo por eso se agrego esta linea
                            {
                                primercalculo = true;
                                TimeSpan diasdediferenciaentrecontratos = new TimeSpan();
                                try
                                {


                                    if (convenios[0].FechaInicio == convenios[0].FechaTermino
                                        || convenios[1].FechaTermino == convenios[1].FechaInicio)
                                        existecontratoscancelados = true;

                                    if (convenios[1].RestringirMenu == false)
                                        diasdediferenciaentrecontratos = (System.DateTime)convenios[0].FechaInicio - (System.DateTime)convenios[1].FechaTermino;


                                    if (diasdediferenciaentrecontratos.Days > 1)
                                    {
                                        haycontinuidad = false;
                                        if (item.FechaInicio < this.Nomina_stNomina.FechaInicio
                                            && (item.FechaInicioPago == null || item.FechaInicioPago == this.Nomina_stNomina.FechaInicio))
                                        {
                                            diasdediferenciaentrecontratos = this.Nomina_stNomina.FechaInicio - item.FechaInicio;
                                            //if (plazatrabajador.CalcularNominaDiasCalendario == false || (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AYUDA PARA DESPENSA")))
                                            //{
                                            //    var mesescon31dias1 = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(item.FechaInicio, (DateTime)item.FechaTermino);
                                            //    var diasFebrero1 = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(item.FechaInicio, (DateTime)item.FechaTermino);
                                            //    diasdediferenciaentrecontratos = (diasdediferenciaentrecontratos - mesescon31dias1) + diasFebrero1;
                                            //}

                                        }
                                    }
                                    //if (ultimanominapagadaTrabajador.Count() > 0)
                                    //{
                                    //    if (ultimanominapagadaTrabajador[0].IdConvenioLaboralTrabajadorCategoria != item.IdConvenioLaboralTrabajadorCategoria)
                                    //    {
                                    //        ExistenominaPagadaconOtraCategoria = true;
                                    //        CambioMismaCategoria = false;
                                    //    }
                                    //    else
                                    //        if (convenios[0].IdCategoria == convenios[1].IdCategoria)
                                    //        CambioMismaCategoria = true;
                                    //}
                                    //else

                                    if (convenios[0].IdCategoria == convenios[1].IdCategoria)
                                    {
                                        if (ultimanominapagadaTrabajador.Count() > 0)
                                        {
                                            if (ultimanominapagadaTrabajador[0].IdConvenioLaboralTrabajadorCategoria != item.IdConvenioLaboralTrabajadorCategoria
                                                && ultimanominapagadaTrabajador[0].IdCategoria != item.Plazas_stDistribucionPlazaCategoria.IdCategoria)
                                            {
                                                // se verifica que los costos de est acategoria no sean iguales
                                                var costoscategoria1 = this.Plazas_ctCostoHoraJornadaTodos
             .Where(c => c.IdCategoria == convenios[0].IdCategoria
             && c.FechaInicio <= this.Nomina_stNomina.FechaInicio && c.FechaTermino >= this.Nomina_stNomina.FechaTermino).FirstOrDefault();

                                                var costoscategoria2 = this.Plazas_ctCostoHoraJornadaTodos
             .Where(c => c.IdCategoria == convenios[1].IdCategoria
             && c.FechaInicio <= this.Nomina_stNomina.FechaInicio && c.FechaTermino >= this.Nomina_stNomina.FechaTermino).FirstOrDefault();
                                                if (costoscategoria2.CostoPorHora != costoscategoria1.CostoPorHora)
                                                {
                                                    ExistenominaPagadaconOtraCategoria = true;
                                                    CambioMismaCategoria = false;
                                                }
                                                else
                                                {
                                                    ExistenominaPagadaconOtraCategoria = true;
                                                    CambioMismaCategoria = true;
                                                    VariablesNominaTrabajador vnt91 = new VariablesNominaTrabajador();
                                                    vnt91.Concepto = "CATEGORIADIFERENTEMISMOSUELDO";
                                                    vnt91.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;

                                                    this.ListaVariablesNominaTrabajador.Add(vnt91);
                                                }
                                            }
                                            else
                                            {
                                                // CASO SERGIO SERNA , ES INTERINO NO TIENE INTERRUPCION Y DEBE DE GENERARSELE AJUSTE
                                                // NO COBRO ALGUNAS QUINCENAS, NO CAMBIA DE CATEGORIA, SI DE CONTRATO
                                                if (!this.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE")
                                                   && (item.EsPrimerCalculo)
                                                   && ultimanominapagadaTrabajador[0].IdCategoria == item.Plazas_stDistribucionPlazaCategoria.IdCategoria
                                                   && diasdediferenciaentrecontratos.Days <= 1
                                                   )
                                                {
                                                    CambioMismaCategoria = false;
                                                    ExistenominaPagadaconOtraCategoria = true;
                                                }
                                                else
                                                    CambioMismaCategoria = true;
                                            }

                                        }
                                        else
                                        if (haycontinuidad)
                                            CambioMismaCategoria = true;
                                    }

                                }
                                catch (Exception e)
                                {

                                    var t = e;
                                }

                                if (haycontinuidad == false && existecontratoscancelados == false && ExistenominaPagadaconOtraCategoria == false)
                                {
                                    var verificarsisonnopagados = convenios.Where(z => z.EsPrimerCalculo).ToList();
                                    if (verificarsisonnopagados.Count() == convenios.Count() &&
                                        CambioMismaCategoria == false)
                                    {
                                        CambioMismaCategoria = false;
                                    }
                                    else
                                        if (this.Nomina_stNomina.FechaInicio >= convenios[0].FechaInicio)
                                    {
                                        //no se hacen ajustes sobre la misma categoria
                                        if (convenios[0].IdCategoria == convenios[1].IdCategoria)
                                            if (!item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONTRATO"))
                                            {

                                                var convenio1 = this.ConveniosTrabajadoresTodos.Where(a => a.IdConvenioLaboralTrabajadorCategoria == convenios[0].IdConvenioLaboralTrabajadorCategoria
                                                ).FirstOrDefault();

                                                var convenio2 = this.ConveniosTrabajadoresTodos.Where(a => a.IdConvenioLaboralTrabajadorCategoria == convenios[1].IdConvenioLaboralTrabajadorCategoria
                                                ).FirstOrDefault();
                                                // caso 
                                                //MIGUEL ANGEL    ALDERETE SALINAS H           DIRECTOR DE PLANTEL "B" PLANTEL NÚM. 38 SANTA MARÍA HUATULCO DIRECCIÓN ACADÉMICA 2022 - 02 - 14 00:00:00.000
                                                //if (convenios[0].FechaInicioPago == this.Nomina_stNomina.FechaInicio)
                                                // se quito el if de igualda para que no alcule por que hay diferencia de 1 dia
                                                if (CambioMismaCategoria && item.FechaInicioPago > item.FechaInicio && item.FechaInicioPago == this.Nomina_stNomina.FechaInicio
                                                    && (item.EsPrimerCalculo) && convenio1.IdEstructuraOrganica != convenio2.IdEstructuraOrganica)
                                                {
                                                    //se agrego este if caso OSVALDO SANDOVAL BAUTISTA, se le genero un contrato con la misma categoria
                                                    // en una adscripcion diferente y no hace el calculo de los dias de pago
                                                    CambioMismaCategoria = false;
                                                }
                                                else
                                            if (CambioMismaCategoria && convenios[0].FechaInicioPago == this.Nomina_stNomina.FechaInicio && !ExistencontinudadNominas)
                                                    CambioMismaCategoria = false;
                                                else
                                            if (CambioMismaCategoria && convenios[0].FechaInicioPago == this.Nomina_stNomina.FechaInicio)
                                                    CambioMismaCategoria = true;
                                                else
                                            if (convenios[0].FechaInicioPago < this.Nomina_stNomina.FechaInicio)
                                                    CambioMismaCategoria = false;
                                                else
                                                    CambioMismaCategoria = true;
                                            }
                                            else
                                                CambioMismaCategoria = false;
                                    }
                                }
                                else
                                    if (CambioMismaCategoria == true)
                                    CambioMismaCategoria = false;
                            }
                            else
                        if (regresadeLicencia)
                            {
                                var diasdediferenciaentrecontratos = (System.DateTime)convenios[0].FechaInicio - (System.DateTime)regresalic.FechaTerminoIncidencia;
                                primercalculo = true;
                            }
                        ///
                    }
                        else
                        {
                            if (item.EsPrimerCalculo )
                            {
                                primercalculo = true;
                            }
                        }

                        bool tieneimmsplantilla = false;

                        bool calcular = false;

                        if (calcularIMSS && primercalculo && !ExistencontinudadNominas)
                        {
                            if (this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault() != null)
                                tieneimmsplantilla = true;
                            calcular = true;
                        }
                        else
                            if (item.EsPrimerCalculo || regresadeLicencia)
                            calcular = true;

                         double diasremanentes = 0;

                        int contador = 0;
                    
                        if (TerminoContratoDias==0 && !ExistencontinudadNominas && (item.EsPrimerCalculo == true || regresadeLicencia)  && calcular && CambioMismaCategoria == false)
                        {

                          


                            foreach (var per in PlantillaNominaPercepcionesRelacionLaboral.Where(s =>
                            s.IdPlantillaNomina == this.Nomina_stNomina.IdPlantillaNomina && s.Percepciones_ctPercepcion.EsSDI == true))
                            {
                                contador++;
                                var SinAjuste = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "SinAjuste").FirstOrDefault();

                                Boolean CalcularExcepcion = false;
                                if (per.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" && per.Calcular == false)
                                    if (AyudaDespensaExcepciones.Calcular(item))
                                        CalcularExcepcion = true;

                                if (per.Calcular && SinAjuste == null || (CalcularExcepcion && SinAjuste == null))
                                {



                                    var sueldopercep = this.PlantillaNominaPercepcionesRelacionLaboral.Where(s => s.Percepciones_ctPercepcion.Percepcion == per.Percepciones_ctPercepcion.Percepcion).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
                                    Decimal Sueldodiario = 0;

                                    if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("DESPENSA")
                                        && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONFIANZA"))
                                    {
                                        if (per.Percepciones_ctPercepcion.Percepciones_ctPercepcionPeriodo.PercepcionPeriodo == "Mensual")
                                            Sueldodiario = (decimal)this.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / 30;
                                        else
                                            Sueldodiario = ((decimal)this.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / this.DiasNomina);

                                    }
                                    else
                                    {
                                        if (per.Percepciones_ctPercepcion.Percepciones_ctPercepcionPeriodo.PercepcionPeriodo == "Mensual")
                                            Sueldodiario = (decimal)this.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / 30;
                                        else
                                            Sueldodiario = ((decimal)this.ListaPercepcionesTrabajadores.Where(x => sueldopercep.Contains(x.IdPlantillaNominaPercepcion) && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(a => a.Importe) / diaslaborados);
                                    }


                                    //devoluciones
                                    int mesescon31dias = 0;
                                   
                                    double diasremanentesIMSS = 0;

                                    int diasFebrero = 0;





                                    if (item.FechaTermino < this.Nomina_stNomina.FechaInicio)
                                    {

                                    var existediasTotalesContrato = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "TerminoContratoDiasPagados").FirstOrDefault();
                                            if (existediasTotalesContrato != null)
                                            {
                                                var diasTotalesContrato = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "TerminoContratoDiasPagados").FirstOrDefault().Importe;
                                                diasremanentes = (double)diasTotalesContrato;

                                                diasremanentesIMSS = diasremanentes;
                                                if (plazatrabajador.CalcularNominaDiasCalendario == false || (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AYUDA PARA DESPENSA")))
                                                {
                                                    mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(item.FechaInicio, (DateTime)item.FechaTermino);
                                                    diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(item.FechaInicio, (DateTime)item.FechaTermino);
                                                }
                                            }
                                    }
                                    else
                                    if (item.FechaInicioPago != null)
                                    {

                                        TimeSpan Diff_dates = item.FechaInicioPago.Value.Subtract(item.FechaInicio);
                                        diasremanentes = Diff_dates.Days;
                                        diasremanentesIMSS = diasremanentes;

                                        if (plazatrabajador.CalcularNominaDiasCalendario == false || (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AYUDA PARA DESPENSA")))
                                        {
                                            mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(item.FechaInicio, (DateTime)item.FechaInicioPago);
                                            diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(item.FechaInicio, (DateTime)item.FechaInicioPago);
                                        }
                                    }
                                    else
                                    {

                                        TimeSpan Diff_dates = this.Nomina_stNomina.FechaInicio.AddDays(-1).Subtract(item.FechaInicio.AddDays(-1));
                                        diasremanentes = Diff_dates.Days;
                                        diasremanentesIMSS = diasremanentes;

                                        if (plazatrabajador.CalcularNominaDiasCalendario == false || (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AYUDA PARA DESPENSA")))
                                        {
                                            mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(item.FechaInicio, (DateTime)this.Nomina_stNomina.FechaInicio);
                                            diasFebrero = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(item.FechaInicio, (DateTime)this.Nomina_stNomina.FechaInicio);
                                        }
                                    }

                                    //se quitan los dias de los meses con 31 en dado caso de que hay mas de 30 dias de dif

                                    diasremanentes = (diasremanentes - mesescon31dias) + diasFebrero;



                                    decimal importeAjuste = 0M;
                                    if (diasremanentes > 0)
                                    {
                                        if (contador == 1 && calcularIMSS && tieneimmsplantilla)
                                        {
                                            string consultaI = "";

                                            var fint = this.Nomina_stNomina.FechaInicio.ToString("yyyy-MM-dd");

                                            if (item.FechaInicioPago != null)
                                                consultaI = @"select ff.* from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.idnomina = b.idnomina
inner join[Nomina_ctPlantillaNomina] c on b.idplantillanomina = c.idplantillanomina
inner join Deducciones_stNominaTrabajadorDeduccion ff on ff.IdNominaTrabajador=a.IdNominaTrabajador
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria = d.IdDistribucionPlazaCategoria
inner join Nomina_stNominaTrabajadorEstatus  q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' and b.EsCerrada = 1 and c.Plantilla like '%sueldo%'
and b.FechaInicio between '" + item.FechaInicio.ToString("yyyy-MM-dd") + @"' and '" + item.FechaInicioPago.Value.ToString("yyyy-MM-dd") + @" '
and w.IdTrabajador = '" + item.Convenios_stConvenioLaboralTrabajador.IdTrabajador + @"'  and a.idconveniolaboraltrabajadorcategoria<>" + item.IdConvenioLaboralTrabajadorCategoria + " order by a.idnominatrabajador desc";
                                            else
                                                consultaI = @"select ff.* from Nomina_stNominaTrabajador a
inner join Nomina_stNomina b on a.idnomina = b.idnomina
inner join[Nomina_ctPlantillaNomina] c on b.idplantillanomina = c.idplantillanomina
inner join Deducciones_stNominaTrabajadorDeduccion ff on ff.IdNominaTrabajador=a.IdNominaTrabajador
inner join Convenios_stConvenioLaboralTrabajadorCategoria d on d.IdConvenioLaboralTrabajadorCategoria = a.IdConvenioLaboralTrabajadorCategoria
inner join Convenios_stConvenioLaboralTrabajador w on w.IdConvenioLaboralTrabajador = d.IdConvenioLaboralTrabajador
inner join Plazas_stDistribucionPlazaCategoria f on f.IdDistribucionPlazaCategoria = d.IdDistribucionPlazaCategoria
inner join Nomina_stNominaTrabajadorEstatus  q on q.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
where EstatusNominaGrupo ='PARA PAGO' and b.EsCerrada = 1 and c.Plantilla like '%sueldo%'
and b.FechaInicio between '" + item.FechaInicio.ToString("yyyy-MM-dd") + @"' and '" + fint + @" '
and w.IdTrabajador = '" + item.Convenios_stConvenioLaboralTrabajador.IdTrabajador + @"'  and a.idconveniolaboraltrabajadorcategoria<>" + item.IdConvenioLaboralTrabajadorCategoria + " order by a.idnominatrabajador desc";

                                            DapperQuery dp2 = new DapperQuery("bdNovaEntities");
                                            List<Deducciones_stNominaTrabajadorDeduccion> imsspagadosincorrectamente = (List<Deducciones_stNominaTrabajadorDeduccion>)dp2.connection.Query<Deducciones_stNominaTrabajadorDeduccion>(consultaI);
                                            dp2.Close();


                                            //dif IMSS

                                            decimal importeAjusteImss = 0;
                                            var idplantillaimss = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault().IdPlantillaNominaDeduccion;
                                            if (idplantillaimss > 0)
                                            {
                                                var importeImssMalPagado = imsspagadosincorrectamente.Where(a => a.IdPlantillaNominaDeduccion == idplantillaimss).Sum(z => z.Importe);

                                                var deduccionIMSS = this.ListaDeduccionesTrabajadores.Where(a => a.IdPlantillaNominaDeduccion == idplantillaimss
                                                  && a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                                                if (deduccionIMSS != null)
                                                {

                                                    var imsscambiocontato = this.ListaVariablesNominaTrabajador.Where(z => z.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                                                      && z.Concepto == "IMSSCAMBIOCONTRATO").FirstOrDefault();

                                                    decimal tieneimsscontato = 0;

                                                    if (imsscambiocontato != null)
                                                    {
                                                        var importediarioimss2 = ((imsscambiocontato.Importe / diaslaborados));
                                                        tieneimsscontato = (decimal)diasremanentesIMSS * importediarioimss2;

                                                    }

                                                    var importediarioimss = ((deduccionIMSS.Importe / diaslaborados));
                                                    importeAjusteImss = (decimal)diasremanentesIMSS * importediarioimss;

                                                    importeAjusteImss = importeAjusteImss - tieneimsscontato;

                                                    importeAjusteImss = importeAjusteImss - importeImssMalPagado;

                                                    //  var Remanente = this.ListaVariablesNominaTrabajador.Where(c => c.Concepto == "SUELDO REMANENTE PENSION" && c.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();





                                                    var existepercepcionpositiva = this.ListaVariablesNominaTrabajador.Where(a => a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
                                                && a.Concepto == "ajustepercepcionesPositiva").FirstOrDefault();

                                                 

                                                    if (importeAjusteImss > 0 && existepercepcionpositiva != null)
                                                    {
                                                        DeduccionesNominaTrabajador deduccionimss = new DeduccionesNominaTrabajador();
                                                        deduccionimss.EsImprimibleRecibo = true;
                                                        deduccionimss.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                                        deduccionimss.IdNomina = this.Nomina_stNomina.IdNomina;
                                                        deduccionimss.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "DIFERENCIA").FirstOrDefault().IdPlantillaNominaDeduccion;
                                                        deduccionimss.Concepto = "IMSS";
                                                        deduccionimss.Importe = importeAjusteImss;

                                                        this.ListaDeduccionesTrabajadores.Add(deduccionimss);
                                                    }
                                                }
                                            }
                                        }



                                        importeAjuste = (decimal)diasremanentes * Sueldodiario;

                                        if (importeAjuste > 0 && calcularIMSS == false)
                                        {
                                            PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();
                                        if (
    item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
                                        {
                                            percepcion.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                            percepcion.IdNomina = this.IdNomina;
                                            percepcion.IdPlantillaNominaPercepcion = this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().IdPlantillaNominaPercepcion;
                                            percepcion.Importe = importeAjuste;

                                            percepcion.Tipo = "NORMAL";
                                            percepcion.EsGrabable = this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                            percepcion.Concepto = per.Percepciones_ctPercepcion.Percepcion;
                                        }
                                        else
                                        {

                                            percepcion.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                            percepcion.IdNomina = this.IdNomina;
                                            percepcion.IdPlantillaNominaPercepcion = this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().IdPlantillaNominaPercepcion;
                                            percepcion.Importe = importeAjuste;

                                            percepcion.Tipo = "NORMAL";
                                            percepcion.EsGrabable = this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                            percepcion.Concepto = per.Percepciones_ctPercepcion.Percepcion;
                                        }
                                        if (percepcion.Concepto.Contains("SUELDO")
                                            && item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE"))
                                        {
                                            DeduccionesNominaTrabajador deduccionCUOTA = new DeduccionesNominaTrabajador();
                                            deduccionCUOTA.EsImprimibleRecibo = true;
                                            deduccionCUOTA.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                                            deduccionCUOTA.IdNomina = this.Nomina_stNomina.IdNomina;
                                            //deduccionCUOTA.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "CUOTA SINDICAL").FirstOrDefault().IdPlantillaNominaDeduccion;
                                            deduccionCUOTA.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "DIFERENCIA").FirstOrDefault().IdPlantillaNominaDeduccion;
                                            deduccionCUOTA.Concepto = " CUOTA SINDICAL";
                                            deduccionCUOTA.Importe = Math.Round(percepcion.Importe * 0.01M, 2);
                                            


                                            this.ListaDeduccionesTrabajadores.Add(deduccionCUOTA);
                                        }

                                            percepcion.EsVariable = (bool)this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                            percepcion.EsPrevisionSocial = (bool)this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                            this.ListaPercepcionesTrabajadores.Add(percepcion);

                                            VariablesNominaTrabajador vnt9 = new VariablesNominaTrabajador();
                                            vnt9.Concepto = "ajustepercepciones";
                                            vnt9.Importe = (decimal)diasremanentes;
                                            vnt9.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;

                                            this.ListaVariablesNominaTrabajador.Add(vnt9);

                                            VariablesNominaTrabajador vnt91 = new VariablesNominaTrabajador();
                                            vnt91.Concepto = "ajustepercepcionesPositiva";
                                            vnt91.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;

                                            this.ListaVariablesNominaTrabajador.Add(vnt91);
                                        }
                                    }
                                }
                            }

                        VariablesNominaTrabajador vnt99 = new VariablesNominaTrabajador();
                        vnt99.Concepto = "diasdeajustepercepciones";
                        vnt99.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                        vnt99.Importe = (int)diasremanentes;
                        this.ListaVariablesNominaTrabajador.Add(vnt99);

                        
                        }
                    }
                
        }

        public void AjustesPorBajasSinPago(Convenios_stConvenioLaboralTrabajadorCategoria item)
        {
            decimal TerminoContratoDias = 0M;
            var TerminoContratoDiasSingle = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "ContratoSinPagoSoloAjuste").FirstOrDefault();

            if (TerminoContratoDiasSingle!=null)
            if (TerminoContratoDiasSingle.Importe > 0)
            {// aqui se dan bajas qeu nunca se les pago , poe quew las nominas van adelantadas
             //por lo general no superan los 15 dias y renunciaron
                var fuera = this.ListaPercepcionesTrabajadores.Where(a=>
                 a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList();

                foreach (var dato in fuera)
                {
                   
                    var percep=this.PlantillaNominaPercepciones.Where(x => x.IdPlantillaNominaPercepcion==dato.IdPlantillaNominaPercepcion).FirstOrDefault();
                    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                    percepcion.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                    percepcion.IdNomina = this.IdNomina;
                    percepcion.IdPlantillaNominaPercepcion = this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().IdPlantillaNominaPercepcion;
                    percepcion.Importe = dato.Importe;

                    percepcion.Tipo = "NORMAL";
                    percepcion.EsGrabable = this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                    percepcion.Concepto = percep.Percepciones_ctPercepcion.Percepcion;
                    percepcion.EsVariable = (bool)this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                    percepcion.EsPrevisionSocial = (bool)this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AJUSTE").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;

                    this.ListaPercepcionesTrabajadores.Remove(dato);
                    this.ListaPercepcionesTrabajadores.Add(percepcion);
                }
            }
        }

        public void GrabarViaticos(Nomina_stNominaTrabajador trabajador)
        {


            foreach (var item in this.ListaPercepcionesTrabajadoresViaticos.Where(v => v.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria))
            {
                Percepciones_stNominaTrabajadorPercepciones per = new Percepciones_stNominaTrabajadorPercepciones();

                per.IdNominaTrabajador = trabajador.IdNominaTrabajador;

                per.IdPlantillaNominaPercepcion = item.IdPlantillaNominaPercepcion;
                per.Importe = item.Importe;
                per.EsAjusteHorasExcedentes = item.EsAjusteHorasExcedentes;
                per.EsAjusteHorasInterinas = item.EsAjusteHorasInterinas;
                per.EsDevolucionFaltas = item.EsDevolucionFaltas;

                per.Concepto = item.Concepto;

                this.ViaticosDelTrabajador.Add(per);


            }




        }

        public void GrabaHorarios(Nomina_stNominaTrabajador trabajador)
        {


            foreach (var item in this.HorariosUtilizadosParaNomina.Where(v =>  v.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria))
            {
                Nomina_stNominaHorariosDocentes per = new Nomina_stNominaHorariosDocentes();

                per.IdNominaTrabajador = trabajador.IdNominaTrabajador;
                per.IdHorarioNominaDocente = item.IdHorarioNominaDocente;

                

                this.HorariosDelTrabajador.Add(per);


            }




        }
        public void GrabarPercepciones(Nomina_stNominaTrabajador trabajador)
        {


            foreach (var item in this.ListaPercepcionesTrabajadores.Where(v => v.Tipo!="ODES" && v.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria))
            {
                Percepciones_stNominaTrabajadorPercepciones per = new Percepciones_stNominaTrabajadorPercepciones();

                per.IdNominaTrabajador = trabajador.IdNominaTrabajador;

                per.IdPlantillaNominaPercepcion = item.IdPlantillaNominaPercepcion;
                per.Importe = item.Importe;
                per.EsAjusteHorasExcedentes = item.EsAjusteHorasExcedentes;
                per.EsAjusteHorasInterinas = item.EsAjusteHorasInterinas;
                per.EsDevolucionFaltas = item.EsDevolucionFaltas;

                per.Concepto = item.Concepto;

                this.PercepcionesDelTrabajador.Add(per);


            }




        }

        public void GrabarDeducciones(Nomina_stNominaTrabajador trabajador)
        {

            int r = 0;

            foreach (var item in this.ListaDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria))
            {
                Deducciones_stNominaTrabajadorDeduccion dec = new Deducciones_stNominaTrabajadorDeduccion();
                dec.IdNominaTrabajador = trabajador.IdNominaTrabajador;
                dec.IdPlantillaNominaDeduccion = item.IdPlantillaNominaDeduccion;
                dec.EsImprimibleRecibo = item.EsImprimibleRecibo;

                dec.Importe = item.Importe;
                dec.Concepto = item.Concepto;
                this.DeduccionesDelTrabajador.Add(dec);


                r++;




            }



        }


        private void GrabaSubdeduccionesProyeccion()
        {

            foreach (var ele in this.ListaNominaSubDeduccionesTrabajadores)
            {

                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(f => f.IdPlantillaNominaDeduccion == ele.IdPlantillaNominaDeduccion && f.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault() != null)
                {
                    Deducciones_stNominaTrabajadorSubDeducciones sub = new Deducciones_stNominaTrabajadorSubDeducciones();
                    sub.IdNominaTrabajadorDeduccion = ele.IdNominaTrabajadorDeduccion;
                    sub.IdSubDeduccion = ele.IdSubDeduccion;
                    sub.Importe = ele.Importe;
                    this.SubDeduccionesDelTrabajador.Add(sub);
                }


            }
        }


        public void GrabaSubdeducciones(Nomina_stNominaTrabajador trabajador, List<Deducciones_stNominaTrabajadorDeduccion> deducciones)
        {

            foreach (var ele in this.ListaNominaSubDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria))
            {
                Deducciones_stNominaTrabajadorDeduccion deduccion = deducciones.Where(q => q.Nomina_stNominaTrabajador.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria && q.IdPlantillaNominaDeduccion == ele.IdPlantillaNominaDeduccion).FirstOrDefault();

                if (trabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(f => f.IdPlantillaNominaDeduccion == ele.IdPlantillaNominaDeduccion && f.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault() != null)
                {
                    Deducciones_stNominaTrabajadorSubDeducciones sub = new Deducciones_stNominaTrabajadorSubDeducciones();
                    sub.IdNominaTrabajadorDeduccion = deduccion.IdNominaTrabajadorDeduccion;
                    sub.IdSubDeduccion = ele.IdSubDeduccion;

                    sub.Importe = ele.Importe;
                    this.SubDeduccionesDelTrabajador.Add(sub);
                }
            }




        }

        public void GrabrarProyeccionBaseDatos(short año, short idqna, int idusario)
        {
            //borra si la proyeccion existe
            this.BorrarNomina();

            Nomina_stProyeccion proyeccion = new Nomina_stProyeccion();
            proyeccion.IdNomina = this.IdNomina;

            proyeccion.Año = año;

            proyeccion.EsCerrada = false;
            proyeccion.IdConvenioLaboralTrabajadorCategoria = idusario;

            var x = this.ListaPercepcionesTrabajadores.Where(g => g.Importe < 0).ToList();
            List<Percepciones_Proyeccion> percepciones = new List<Percepciones_Proyeccion>();


            foreach (var item in this.PercepcionesPlantillaRetroActivo)
            {
                decimal subtotal = 0M;
                if (item.Porcentaje > 0)
                {
                    Decimal incrementoPorcentaje = (decimal)item.Porcentaje / 100;
                    var tempo = this.ListaPercepcionesTrabajadores.Where(e => e.IdPlantillaNominaPercepcion == item.IdPlantillaNominaPercepcion).Sum(e => e.Importe) * incrementoPorcentaje;
                    subtotal = Math.Round(this.ListaPercepcionesTrabajadores.Where(c => c.IdPlantillaNominaPercepcion == item.IdPlantillaNominaPercepcion).Sum(e => e.Importe)
                        + tempo, 2);
                    proyeccion.TotalPercepciones = proyeccion.TotalPercepciones + subtotal;
                }
                else
                    if (item.Importe > 0)
                {
                    var tempo = (decimal)item.Importe * this.TrabajadoresVigentes.Count();
                    subtotal = this.ListaPercepcionesTrabajadores.Where(c => c.IdPlantillaNominaPercepcion == item.IdPlantillaNominaPercepcion).Sum(e => e.Importe)
                        + tempo;
                    proyeccion.TotalPercepciones = proyeccion.TotalPercepciones + subtotal;
                }
                else
                {
                    subtotal = this.ListaPercepcionesTrabajadores.Where(c => c.IdPlantillaNominaPercepcion == item.IdPlantillaNominaPercepcion).Sum(e => e.Importe);
                    proyeccion.TotalPercepciones = proyeccion.TotalPercepciones + subtotal;
                }


                var datos = this.ListaPercepcionesTrabajadores.Where(e => e.IdPlantillaNominaPercepcion == item.IdPlantillaNominaPercepcion).Select(w => new Percepciones_Proyeccion { IdProyeccion = 0, IdPlantillaNominaPercepcion = w.IdPlantillaNominaPercepcion, Importe = subtotal }).FirstOrDefault();
                if (datos != null)
                    percepciones.Add(datos);

            }




            proyeccion.IdNomina = this.IdNomina;
            proyeccion.FechaUltimoMovimiento = DateTime.Now;
            proyeccion.PorcentajeIncremento = 0;



            bdNovaEntities bd = new bdNovaEntities();

            bd.Entry(proyeccion).State = System.Data.Entity.EntityState.Added;

            bd.SaveChanges();


            foreach (var item in percepciones)
            {
                item.IdProyeccion = proyeccion.IdProyeccion;
            }

            List<Deducciones_Proyeccion> deducciones = this.ListaDeduccionesTrabajadores.GroupBy(e => e.IdPlantillaNominaDeduccion).Select(w => new Deducciones_Proyeccion { IdProyeccion = proyeccion.IdProyeccion, IdPlantillaNominaDeduccion = w.Key, Importe = w.Sum(d => d.Importe) + Math.Round((w.Sum(d => d.Importe)), 2) }).ToList();



            var connString = ConfigurationManager.ConnectionStrings["bdNovaEntities"].ConnectionString;
            EntityConnection ec = new EntityConnection(connString);
            string storeConnect = ec.StoreConnection.ConnectionString;

            SqlConnection conn = new SqlConnection(storeConnect);
            conn.Open();

            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;




            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {


                var bcp = new SqlBulkCopy(conn);



                var reader2 = ObjectReader.Create(percepciones
             ,
            "IdPercepcionProyeccion"
  , "IdPlantillaNominaPercepcion"
  , "Importe"
  , "IdProyeccion"
                 );
                {
                    bcp.DestinationTableName = "Percepciones_Proyeccion";
                    bcp.BatchSize = 10000;
                    bcp.WriteToServer(reader2);
                }

                var reader3 = ObjectReader.Create(deducciones
            , "IdDeduccionProyeccion"
  , "IdPlantillaNominaDeduccion"
  , "Importe"
  , "IdProyeccion"
                );
                {
                    bcp.DestinationTableName = "Deducciones_Proyeccion";
                    bcp.BatchSize = 10000;
                    bcp.WriteToServer(reader3);
                }


            }



        }

        public void SumarPercepcionesDeduccionRetroactivo()
        {



            foreach (var item in ListaPercepcionesTrabajadores)
            {
                PercepcionesNominaTrabajador pn = new PercepcionesNominaTrabajador();
                pn.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                pn.IdNomina = item.IdNomina;
                pn.Importe = item.Importe;
                pn.IdPlantillaNominaPercepcion = item.IdPlantillaNominaPercepcion;
                pn.EsVariable = item.EsVariable;
                pn.EsGrabable = item.EsGrabable;
                pn.EsImprimibleRecibo = item.EsImprimibleRecibo;
                pn.EsPrevisionSocial = item.EsPrevisionSocial;
                ListaPercepcionesTrabajadoresRetroActivo.Add(pn);
            }


            var tempo1 = ListaPercepcionesTrabajadoresRetroActivo.GroupBy(e => new { e.IdConvenioLaboralTrabajadorCategoria, e.IdPlantillaNominaPercepcion, e.IdNomina }).Select(q => new { q.Key.IdConvenioLaboralTrabajadorCategoria, q.Key.IdPlantillaNominaPercepcion, EsImprimibleRecibo = true, EsGrabable = q.Max(g => g.EsGrabable), EsPrevisionSocial = q.Max(g => g.EsPrevisionSocial), EsVariable = q.Max(g => g.EsVariable), Importe = q.Sum(g => g.Importe), q.Key.IdNomina });

            ListaPercepcionesTrabajadores.RemoveAll(q => q.IdConvenioLaboralTrabajadorCategoria > 0);

            foreach (var item in tempo1)
            {
                PercepcionesNominaTrabajador pn = new PercepcionesNominaTrabajador();
                pn.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                pn.IdNomina = item.IdNomina;
                pn.Importe = item.Importe;
                pn.IdPlantillaNominaPercepcion = item.IdPlantillaNominaPercepcion;
                pn.EsVariable = item.EsVariable;
                pn.EsGrabable = item.EsGrabable;
                pn.EsImprimibleRecibo = item.EsImprimibleRecibo;
                pn.EsPrevisionSocial = item.EsPrevisionSocial;
                ListaPercepcionesTrabajadores.Add(pn);
            }




            foreach (var item in ListaDeduccionesTrabajadores)
            {
                DeduccionesNominaTrabajador pn = new DeduccionesNominaTrabajador();
                pn.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;

                pn.IdNomina = item.IdNomina;
                pn.Importe = item.Importe;

                pn.EsImprimibleRecibo = item.EsImprimibleRecibo;
                ListaDeduccionesTrabajadoresRetroActivo.Add(pn);
            }
            var tempo2 = ListaDeduccionesTrabajadoresRetroActivo.GroupBy(e => new { e.IdConvenioLaboralTrabajadorCategoria, e.IdPlantillaNominaDeduccion, e.IdNomina }).Select(q => new DeduccionesNominaTrabajador { IdConvenioLaboralTrabajadorCategoria = q.Key.IdConvenioLaboralTrabajadorCategoria, IdPlantillaNominaDeduccion = q.Key.IdPlantillaNominaDeduccion, EsImprimibleRecibo = true, Importe = q.Sum(g => g.Importe) });
            ListaDeduccionesTrabajadores.RemoveAll(q => q.IdConvenioLaboralTrabajadorCategoria > 0);

            foreach (var item in tempo2)
            {
                DeduccionesNominaTrabajador pn = new DeduccionesNominaTrabajador();
                pn.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;

                pn.IdNomina = item.IdNomina;
                pn.Importe = item.Importe;

                pn.EsImprimibleRecibo = item.EsImprimibleRecibo;
                ListaDeduccionesTrabajadores.Add(pn);
            }




            foreach (var item in ListaPensionesTrabajador)
            {
                PensionesTrabajador pn = new PensionesTrabajador();
                pn.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;


                pn.Importe = item.Importe;

                pn.IdPensionTrabajador = item.IdPensionTrabajador;
                ListaPensionesTrabajadorRetroActivo.Add(pn);
            }
            var tempo3 = ListaPensionesTrabajadorRetroActivo.GroupBy(e => new { e.IdConvenioLaboralTrabajadorCategoria, e.IdPensionTrabajador }).Select(q => new { q.Key.IdConvenioLaboralTrabajadorCategoria, q.Key.IdPensionTrabajador, Importe = q.Sum(g => g.Importe) });
            ListaPensionesTrabajador.RemoveAll(q => q.IdConvenioLaboralTrabajadorCategoria > 0);

            foreach (var item in tempo3)
            {
                PensionesTrabajador pn = new PensionesTrabajador();
                pn.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;


                pn.Importe = item.Importe;

                pn.IdPensionTrabajador = item.IdPensionTrabajador;
                ListaPensionesTrabajador.Add(pn);
            }


        }

        public void GenerarRetroactivo(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {


            var percepsueldo = this.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("SUELDO")).Select(s => s.IdPlantillaNominaPercepcion).ToArray();
            var deduccuota = this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "CUOTA SINDICAL").SingleOrDefault();
            short inpnd = 0;
            if (deduccuota != null)
                inpnd = deduccuota.IdPlantillaNominaDeduccion;

            List<DeduccionesRetroActivoTrabajador> DeduccionesFaltas = new List<DeduccionesRetroActivoTrabajador>(ListaDeduccionesRetroActivoTrabajador);

            foreach (var item in ListaDeduccionesRetroActivoTrabajador.Where(a=>a.IdTrabajador== cltc.Convenios_stConvenioLaboralTrabajador.IdTrabajador 
            && a.Deduccion== "DESCUENTO POR PAGO INDEBIDO" && 
            (a.Concepto.Contains("ESTÍMULO POR PUNTUALIDAD Y ASISTENCIA") ||
            a.Concepto.Contains("DÍAS ECONOMICOS NO DISFRUTADOS")) ))
            {
                //busca si hay alguna categoria configurada si la hay toma el valro de ahi
                // en lugar de la generalidad
                var existereotrporcategoria = this.PercepcionesRetroActivoPorCategoria
                    .Where(a => a.IdCategoria == cltc.Plazas_stDistribucionPlazaCategoria.IdCategoria
                    && a.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepcion == item.Concepto ).FirstOrDefault();

                var percepciondeduc = PlantillaNominaPercepciones.Where(q => q.Percepciones_ctPercepcion.Percepcion == item.Concepto).FirstOrDefault();
                if (percepciondeduc != null)
                {

                    DeduccionesNominaTrabajador deduccionper = new DeduccionesNominaTrabajador();
                    deduccionper.EsImprimibleRecibo = true;
                    deduccionper.IdConvenioLaboralTrabajadorCategoria = cltc.IdConvenioLaboralTrabajadorCategoria;
                    deduccionper.IdNomina = this.Nomina.IdNomina;
                    deduccionper.IdPlantillaNominaDeduccion = (short)item.IdPlantillaNominaDeduccion;
                    deduccionper.Importe = item.Importe ;
                    deduccionper.Concepto = item.Concepto;

                    decimal? ImporteRetroActivoC_PD = 0;
                    decimal? PorcentajeRetroActivoC_PD = 0;

                    if (existereotrporcategoria != null)
                    {
                        if (existereotrporcategoria.ImporteRetroActivo != 0)
                            ImporteRetroActivoC_PD = existereotrporcategoria.ImporteRetroActivo;

                        if (existereotrporcategoria.PorcentajeRetroActivo != 0)
                            PorcentajeRetroActivoC_PD = existereotrporcategoria.PorcentajeRetroActivo;


                        if (ImporteRetroActivoC_PD > 0)
                            deduccionper.Importe = (decimal)ImporteRetroActivoC_PD * item.TotalQuincenas;
                        else
                            if (PorcentajeRetroActivoC_PD > 0)
                            deduccionper.Importe = (decimal)(item.Importe * existereotrporcategoria.PorcentajeRetroActivo);
                        else
                                if (existereotrporcategoria.ImporteRetroActivo > 0)
                            deduccionper.Importe = (decimal)(existereotrporcategoria.ImporteRetroActivo * item.TotalQuincenas);
                        else
                            deduccionper.Importe = (decimal)(item.Importe * existereotrporcategoria.PorcentajeRetroActivo);
                    }
                    else
                    {
                        if (percepciondeduc.ImporteRetroActivo != 0)
                            ImporteRetroActivoC_PD = percepciondeduc.ImporteRetroActivo;

                        if (percepciondeduc.PorcentajeRetroActivo != 0)
                            PorcentajeRetroActivoC_PD = percepciondeduc.PorcentajeRetroActivo;


                        if (ImporteRetroActivoC_PD > 0)
                            deduccionper.Importe = (decimal)ImporteRetroActivoC_PD * item.TotalQuincenas;
                        else
                            if (PorcentajeRetroActivoC_PD > 0)
                            deduccionper.Importe = (decimal)(item.Importe * percepciondeduc.PorcentajeRetroActivo);
                        else
                                if (percepciondeduc.ImporteRetroActivo > 0)
                            deduccionper.Importe = (decimal)(percepciondeduc.ImporteRetroActivo * item.TotalQuincenas);
                        else
                            deduccionper.Importe = (decimal)(item.Importe * percepciondeduc.PorcentajeRetroActivo);
                    }
                 
                    this.ListaDeduccionesTrabajadores.Add(deduccionper);
                }
            }

            foreach (var item in DeduccionesFaltas)
            {
                item.Deduccion = item.Deduccion.Replace("FALTA ", "");
            }

            foreach (var item in this.ListaPercepcionesRetroActivoTrabajador.Where(w => w.IdTrabajador == cltc.Convenios_stConvenioLaboralTrabajador.IdTrabajador))
            {

                var percepcionretro = PlantillaNominaPercepcionesRelacionLaboral.Where(s => s.Percepciones_ctPercepcion.Percepcion == item.Percepcion).FirstOrDefault();
                if (percepcionretro != null)
                {

                    //busca si hay alguna categoria configurada si la hay toma el valro de ahi
                    // en lugar de la generalidad
                    var existeRetroporcategoria = this.PercepcionesRetroActivoPorCategoria
                        .Where(a => a.IdCategoria == cltc.Plazas_stDistribucionPlazaCategoria.IdCategoria
                        && a.Percepciones_stPlantillaNominaPercepciones.Percepciones_ctPercepcion.Percepcion == item.Percepcion).FirstOrDefault();


                    Nova.Models.Nomina.PercepcionesNominaTrabajador percepcion = new Nova.Models.Nomina.PercepcionesNominaTrabajador();

                    percepcion.IdConvenioLaboralTrabajadorCategoria = cltc.IdConvenioLaboralTrabajadorCategoria;
                    percepcion.IdNomina = this.IdNomina;
                    percepcion.IdPlantillaNominaPercepcion = percepcionretro.IdPlantillaNominaPercepcion;

                    decimal ImporteRetroActivoC = 0;
                    decimal PorcentajeRetroActivoC = 0;
                    if (existeRetroporcategoria!=null)
                    {
                        if (existeRetroporcategoria.ImporteRetroActivo != 0)
                            ImporteRetroActivoC = existeRetroporcategoria.ImporteRetroActivo;

                        if (existeRetroporcategoria.PorcentajeRetroActivo != 0)
                            PorcentajeRetroActivoC = existeRetroporcategoria.PorcentajeRetroActivo;


                        if (ImporteRetroActivoC > 0)
                            percepcion.Importe = ImporteRetroActivoC * item.TotalQuincenas;
                        else
                            if (PorcentajeRetroActivoC > 0)
                            percepcion.Importe = item.Importe * PorcentajeRetroActivoC;
                        else
                                if (item.ImporteRetroActivo > 0)
                            percepcion.Importe = ImporteRetroActivoC * item.TotalQuincenas;
                        else
                            percepcion.Importe = item.Importe * PorcentajeRetroActivoC;
                    }
                    else
                    {
                        if (item.ImporteRetroActivoC != 0)
                            ImporteRetroActivoC = item.ImporteRetroActivoC;

                        if (item.PorcentajeRetroActivoC != 0)
                            PorcentajeRetroActivoC = item.PorcentajeRetroActivoC;


                        if (ImporteRetroActivoC > 0)
                            percepcion.Importe = ImporteRetroActivoC * item.TotalQuincenas;
                        else
                            if (PorcentajeRetroActivoC > 0)
                            percepcion.Importe = item.Importe * item.PorcentajeRetroActivoC;
                        else
                                if (item.ImporteRetroActivo > 0)
                            percepcion.Importe = item.ImporteRetroActivo * item.TotalQuincenas;
                        else
                            percepcion.Importe = item.Importe * item.PorcentajeRetroActivo;
                    }

                    percepcion.Tipo = "NORMAL";
                    percepcion.EsGrabable = percepcionretro.Percepciones_ctPercepcion.EsGravable;

                    percepcion.EsVariable = (bool)percepcionretro.Percepciones_ctPercepcion.EsVariable;
                    percepcion.EsPrevisionSocial = percepcionretro.Percepciones_ctPercepcion.EsPrevisionSocial; ;

                    if (percepcion.Importe > 0)
                    {
                        // BUSCALASFALTAS
                        var existefalta = DeduccionesFaltas.Where(a => a.IdTrabajador == item.IdTrabajador
                         && a.Deduccion == item.Percepcion).FirstOrDefault();
                        if (existefalta != null)
                        {
                            if (existeRetroporcategoria != null)
                            {
                                if (existeRetroporcategoria.ImporteRetroActivo != 0)
                                    ImporteRetroActivoC = existeRetroporcategoria.ImporteRetroActivo;

                                if (existeRetroporcategoria.PorcentajeRetroActivo != 0)
                                    ImporteRetroActivoC = existeRetroporcategoria.PorcentajeRetroActivo;


                                if (ImporteRetroActivoC > 0)
                                    percepcion.Importe = percepcion.Importe - ((ImporteRetroActivoC - existefalta.Importe) * item.TotalQuincenas);
                                else
                                    if (PorcentajeRetroActivoC > 0)
                                    percepcion.Importe = percepcion.Importe - (existefalta.Importe * ImporteRetroActivoC);
                                else
                                        if (existeRetroporcategoria.ImporteRetroActivo > 0)
                                    percepcion.Importe = percepcion.Importe - ((existeRetroporcategoria.ImporteRetroActivo - existefalta.Importe) * item.TotalQuincenas);
                                else
                                    percepcion.Importe = percepcion.Importe - (existefalta.Importe * existeRetroporcategoria.PorcentajeRetroActivo);
                            }
                            else
                            {
                                if (item.ImporteRetroActivoC != 0)
                                    ImporteRetroActivoC = item.ImporteRetroActivoC;

                                if (item.PorcentajeRetroActivoC != 0)
                                    PorcentajeRetroActivoC = item.PorcentajeRetroActivoC;


                                if (ImporteRetroActivoC > 0)
                                    percepcion.Importe = percepcion.Importe - ((ImporteRetroActivoC - existefalta.Importe) * item.TotalQuincenas);
                                else
                                    if (PorcentajeRetroActivoC > 0)
                                    percepcion.Importe = percepcion.Importe - (existefalta.Importe * item.PorcentajeRetroActivoC);
                                else
                                        if (item.ImporteRetroActivo > 0)
                                    percepcion.Importe = percepcion.Importe - ((item.ImporteRetroActivo - existefalta.Importe) * item.TotalQuincenas);
                                else
                                    percepcion.Importe = percepcion.Importe - (existefalta.Importe * item.PorcentajeRetroActivo);
                            }
                        }

                        this.ListaPercepcionesTrabajadores.Add(percepcion);

                        if (cltc.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.EsCuotaSindical == true)
                        {
                            if (percepsueldo.Contains(percepcionretro.IdPlantillaNominaPercepcion))
                            {
                                VariablesNominaTrabajador vnt3 = new VariablesNominaTrabajador();
                                vnt3.Concepto = "CUOTA SINDICAL";
                                vnt3.IdConvenioLaboralTrabajadorCategoria = cltc.IdConvenioLaboralTrabajadorCategoria;
                                vnt3.Importe = percepcion.Importe * 0.01M; ;
                                
                                this.ListaVariablesNominaTrabajador.Add(vnt3);

                               
                            }

                        }
                    }
                }
            }

            var cuotasindical = this.ListaVariablesNominaTrabajador.Where(a =>
            a.IdConvenioLaboralTrabajadorCategoria == cltc.IdConvenioLaboralTrabajadorCategoria
            && a.Concepto == "CUOTA SINDICAL").Sum(x => x.Importe);
            if (cuotasindical > 0)
            {
                DeduccionesNominaTrabajador deduccioncuotafija = new DeduccionesNominaTrabajador();
                deduccioncuotafija.EsImprimibleRecibo = true;
                deduccioncuotafija.IdConvenioLaboralTrabajadorCategoria = cltc.IdConvenioLaboralTrabajadorCategoria;
                deduccioncuotafija.IdNomina = this.Nomina.IdNomina;
                deduccioncuotafija.IdPlantillaNominaDeduccion = inpnd;
                deduccioncuotafija.Importe = cuotasindical;
                this.ListaDeduccionesTrabajadores.Add(deduccioncuotafija);
            }


        }

        public static string GetDatabaseName(string connectionStringName = "DefaultConnection")
        {
            var connectionString = ConfigurationManager.ConnectionStrings[connectionStringName].ConnectionString;
            var entityBuilder = new EntityConnectionStringBuilder(connectionString);
            var sqlBuilder = new SqlConnectionStringBuilder(entityBuilder.ProviderConnectionString);
            return sqlBuilder.InitialCatalog;
        }

        public void GrabarNominaBaseDatosHistorial(DapperQuery dp)
        {
          
           // DapperQuery dp = new DapperQuery("bdNovaEntities");
            string query = "";
            string condicion = "";
            bool hayregistrotrabajador = true;
            string wheresqlAjusteIN = "";
            string wheresqlAjuste = "";
            if (this.EsRecalculoPorTrabajador || EsCalculoUnSoloTrabajador)
            {
                if (EsCalculoUnSoloTrabajador)
                {
                    if (this.trabajadornomina == null)
                    {
                        hayregistrotrabajador = false;
                    }
                }

                if (hayregistrotrabajador)
                    condicion = $" and a.IdConvenioLaboralTrabajadorCategoria={this.trabajadornomina.IdConvenioLaboralTrabajadorCategoria}";
            }

            if (hayregistrotrabajador)
            {

                if (this.EsRecalculoPorTrabajador)
                {

                      wheresqlAjuste = " IdNomina=" + IdNomina.ToString() + "  and IdNominaTrabajador=" + IdNominaTrabajadorRecalculo;
                      wheresqlAjusteIN = " IdNomina=" + IdNomina.ToString() + "  and IdConvenioLaboralTrabajadorCategoria = " + this.trabajadornomina.IdConvenioLaboralTrabajadorCategoria.ToString();
                    string wheresql = " IdNomina=" + IdNomina.ToString() + "  and IdNominaTrabajador!=" + IdNominaTrabajadorRecalculo;

                    wheresql = wheresql + " and IdConvenioLaboralTrabajadorCategoria=" + this.trabajadornomina.IdConvenioLaboralTrabajadorCategoria.ToString();

                    //bdNovaEntities basedt = new bdNovaEntities();
                    Nomina_stNominaTrabajadorEstatus IdTrabajadorEstatus;
                    

                    string query1  = @"select 
  *
  from Nomina_stNominaTrabajadorEstatus 
   
  where    EstatusNomina='CANCELADO' ";


                    var  estatus = (List<Nomina_stNominaTrabajadorEstatus>)dp.connection.Query<Nomina_stNominaTrabajadorEstatus>(query1);



                  var u1  =dp.connection.Execute(@"update Nomina_stNominaTrabajador  set IdNominaTrabajadorEstatus=" + estatus.FirstOrDefault().IdNominaTrabajadorEstatus + " where" + wheresql, null, null, 0, null);

                    var u2=dp.connection.Execute(@"update Nomina_stNominaTrabajadorHistorial  set IdNominaTrabajadorEstatus=" + estatus.FirstOrDefault().IdNominaTrabajadorEstatus + ",EstatusNomina='" + estatus.FirstOrDefault().EstatusNomina + "',IdNominaTrabajadorEstatusGrupo=" + estatus.FirstOrDefault().IdNominaTrabajadorEstatusGrupo + " where EstatusNomina='NORMAL' and " + wheresql, null, null, 0, null);

                    
                }


                ReCalculosNomina rc = new ReCalculosNomina();
                query =rc.createSqlHistorial(condicion,this.Nomina_stNomina.IdNomina, this.Nomina_stNomina.FechaInicio, this.Nomina_stNomina.FechaTermino,this.MotivoDevolucionId);
                var tr =dp.connection.Execute(query);

                if (this.EsRecalculoPorTrabajador && tr>0)
                    {

                    string qeuryrecalculo = $@"delete from  Nomina_stNominaTrabajadorHistorialDevoluciones  where IdNomina={this.Nomina_stNomina.IdNomina} and IdConvenioLaboralTrabajadorCategoria={this.trabajadornomina.IdConvenioLaboralTrabajadorCategoria}";
                  var ec=   dp.connection.Execute(qeuryrecalculo);

                    qeuryrecalculo = $@"WITH CanceladosTemp AS (
   SELECT * FROM [Nomina_stNominaTrabajadorHistorial]
   WHERE IdNomina={this.Nomina_stNomina.IdNomina} 
   AND IdConvenioLaboralTrabajadorCategoria={this.trabajadornomina.IdConvenioLaboralTrabajadorCategoria}
   AND EstatusNomina='CANCELADO'
),
RecalculoTemp AS (
   SELECT * FROM [Nomina_stNominaTrabajadorHistorial]
   WHERE IdNomina={this.Nomina_stNomina.IdNomina} 
   AND IdConvenioLaboralTrabajadorCategoria={this.trabajadornomina.IdConvenioLaboralTrabajadorCategoria}
   AND EstatusNomina='RECALCULO'
)
INSERT INTO Nomina_stNominaTrabajadorHistorialDevoluciones (
   [IdNominaTrabajadorHistorial],
   [RelacionLaboral],
   [RelacionConvenioLaboral],
   [ConvenioLaboral],
   [ConvenioLaboralTipo],
   [Categoria],
   [ClaveCategoria],
   [ClaveCentroTrabajo],
   [NombreCompleto],
   [ApellidoPaterno],
   [ApellidoMaterno],
   [Nombre],
   [Sexo],
   [RFC],
   [CURP],
   [CodigoPostal],
   [CorreoElectronico],
   [NSS],
   [Domicilio],
   [Percepcion],
   [Concepto],
   [Importe],
   [ImporteOperacion],
   [Plantilla],
   [PlantillaGrupo],
   [ConceptoPartida],
   [Partida],
   [Adscripcion],
   [UbicacionFisica],
   [Proyecto],
   [TipoNomina],
   [TiponominaAbreviatura],
   [MesNomina],
   [Abreviatura],
   [OrdenMesGeneracion],
   [Año],
   [QuincenaMes],
   [FechaInicio],
   [FechaTermino],
   [IdNomina],
   [IdConvenioLaboralTrabajadorCategoria],
   [SueldoBruto],
   [SueldoDiario],
   [SueldoNeto],
   [SueldoTransferencia],
   [SueldoMonedero],
   [IdTrabajadorCuentasTransferencia],
   [IdTrabajadorCuentasMonedero],
   [HorasSemanaMes],
   [HorasSemanaMesTrabajadas],
   [HorasExcedentes],
   [HorasTrabajadasExcedentes],
   [HorasInterinas],
   [HorasTrabajadasInterinas],
   [DiasEfectivosLaborados],
   [CostoPorHora],
   [CostoPorHoraExcedente],
   [CostoPorHorasInterinas],
   [SalarioDiarioIntegrado],
   [QuinquenioDiario],
   [MaterialDidacticoDiario],
   [SueldoBrutoQuinquenioDiario],
   [SumaPercepcionesVariables],
   [BaseGravable],
   [HorasEfectivasDeTrabajo],
   [EsHorarioSinCambios],
   [SalarioBrutoGravable],
   [SubsidioEmpleoMensual],
   [Isr],
   [IsrRdl],
   [Rdl],
   [CantidadSubsidioEmpleoMensual],
   [EsHorarioAnterior],
   [EsHorarioAjustado],
   [CostoEficienciaExcedente],
   [CostoMaterialDidactico],
   [CostoEficienciaJornada],
   [CostoMaterialDidacticoExcedente],
   [IdNominaTrabajadorEstatus],
   [DiasFaltas],
   [HorasFaltas],
   [EsMedioRecibo],
   [CicloEscolar],
   [AjusteRealizado],
   [MotivoAjuste],
   [TotalDeducciones],
   [IdMotivoDevolucion],
   [SueldoTabular],
   [PercepcionesAdicionales],
   [IdTrabajador],
   [IdPercepcion],
   [IdPlantillaNomina],
   [IdRelacionConvenioLaboral],
   [IdTipoNomina],
   [IdMesGeneracion],
   [IdModalidadEstudio],
   [IdQuincenaMes],
   [TipoConcepto],
   [SubTipoConcepto],
   [IdNominaTrabajadorEstatusGrupo],
   [EstatusNomina],
   [IdTipoCalculo],
   [TipoCalculo],
   [IdNominaTrabajador],
   [EsCerrada],
   [IdPercepcionDeducionCreditoPension],
   [IdClasificacionLaboral],
   [ClasificacionLaboral]
)
SELECT 
   R.[IdNominaTrabajadorHistorial],
   R.[RelacionLaboral],
   R.[RelacionConvenioLaboral],
   R.[ConvenioLaboral],
   R.[ConvenioLaboralTipo],
   R.[Categoria],
   R.[ClaveCategoria],
   R.[ClaveCentroTrabajo],
   R.[NombreCompleto],
   R.[ApellidoPaterno],
   R.[ApellidoMaterno],
   R.[Nombre],
   R.[Sexo],
   R.[RFC],
   R.[CURP],
   R.[CodigoPostal],
   R.[CorreoElectronico],
   R.[NSS],
   R.[Domicilio],
   R.[Percepcion],
   R.[Concepto],
   C.Importe - R.Importe,
   (C.Importe - R.Importe) * -1,
   R.[Plantilla],
   R.[PlantillaGrupo],
   R.[ConceptoPartida],
   R.[Partida],
   R.[Adscripcion],
   R.[UbicacionFisica],
   R.[Proyecto],
   R.[TipoNomina],
   R.[TiponominaAbreviatura],
   R.[MesNomina],
   R.[Abreviatura],
   R.[OrdenMesGeneracion],
   R.[Año],
   R.[QuincenaMes],
   R.[FechaInicio],
   R.[FechaTermino],
   R.[IdNomina],
   R.[IdConvenioLaboralTrabajadorCategoria],
   R.[SueldoBruto],
   R.[SueldoDiario],
   R.[SueldoNeto],
   R.[SueldoTransferencia],
   R.[SueldoMonedero],
   R.[IdTrabajadorCuentasTransferencia],
   R.[IdTrabajadorCuentasMonedero],
   R.[HorasSemanaMes],
   R.[HorasSemanaMesTrabajadas],
   R.[HorasExcedentes],
   R.[HorasTrabajadasExcedentes],
   R.[HorasInterinas],
   R.[HorasTrabajadasInterinas],
   R.[DiasEfectivosLaborados],
   R.[CostoPorHora],
   R.[CostoPorHoraExcedente],
   R.[CostoPorHorasInterinas],
   R.[SalarioDiarioIntegrado],
   R.[QuinquenioDiario],
   R.[MaterialDidacticoDiario],
   R.[SueldoBrutoQuinquenioDiario],
   R.[SumaPercepcionesVariables],
   R.[BaseGravable],
   R.[HorasEfectivasDeTrabajo],
   R.[EsHorarioSinCambios],
   R.[SalarioBrutoGravable],
   R.[SubsidioEmpleoMensual],
   R.[Isr],
   R.[IsrRdl],
   R.[Rdl],
   R.[CantidadSubsidioEmpleoMensual],
   R.[EsHorarioAnterior],
   R.[EsHorarioAjustado],
   R.[CostoEficienciaExcedente],
   R.[CostoMaterialDidactico],
   R.[CostoEficienciaJornada],
   R.[CostoMaterialDidacticoExcedente],
   R.[IdNominaTrabajadorEstatus],
   R.[DiasFaltas],
   R.[HorasFaltas],
   R.[EsMedioRecibo],
   R.[CicloEscolar],
   R.[AjusteRealizado],
   R.[MotivoAjuste],
   R.[TotalDeducciones],
   R.[IdMotivoDevolucion],
   R.[SueldoTabular],
   R.[PercepcionesAdicionales],
   R.[IdTrabajador],
   R.[IdPercepcion],
   R.[IdPlantillaNomina],
   R.[IdRelacionConvenioLaboral],
   R.[IdTipoNomina],
   R.[IdMesGeneracion],
   R.[IdModalidadEstudio],
   R.[IdQuincenaMes],
   R.[TipoConcepto],
   R.[SubTipoConcepto],
   R.[IdNominaTrabajadorEstatusGrupo],
   R.[EstatusNomina],
   R.[IdTipoCalculo],
   R.[TipoCalculo],
   R.[IdNominaTrabajador],
   R.[EsCerrada],
   R.[IdPercepcionDeducionCreditoPension],
   R.[IdClasificacionLaboral],
   R.[ClasificacionLaboral]
FROM CanceladosTemp C
INNER JOIN RecalculoTemp R ON 
   C.IdNomina = R.IdNomina 
   AND C.IdConvenioLaboralTrabajadorCategoria = R.IdConvenioLaboralTrabajadorCategoria
   AND C.Percepcion = R.Percepcion 
   AND C.Concepto = R.Concepto";
                    //                    qeuryrecalculo = $@"
                    //insert into Nomina_stNominaTrabajadorHistorialDevoluciones
                    //SELECT 
                    // F.[IdNominaTrabajadorHistorial]
                    //      ,F.[RelacionLaboral]
                    //      ,F.[RelacionConvenioLaboral]
                    //      ,F.[ConvenioLaboral]
                    //      ,F.[ConvenioLaboralTipo]
                    //      ,F.[Categoria]
                    //      ,F.[ClaveCategoria]
                    //      ,F.[ClaveCentroTrabajo]
                    //      ,F.[NombreCompleto]
                    //      ,F.[ApellidoPaterno]
                    //      ,F.[ApellidoMaterno]
                    //      ,F.[Nombre]
                    //      ,F.[Sexo]
                    //      ,F.[RFC]
                    //      ,F.[CURP]
                    //      ,F.[CodigoPostal]
                    //      ,F.[CorreoElectronico]
                    //      ,F.[NSS]
                    //      ,F.[Domicilio]
                    //      ,F.[Percepcion]
                    //      ,F.[Concepto]
                    //     ,q.Importe-F.Importe AS Importe
                    //      ,(q.Importe-F.Importe)*-1 AS [ImporteOperacion]
                    //      ,F.[Plantilla]
                    //      ,F.[PlantillaGrupo]
                    //      ,F.[ConceptoPartida]
                    //      ,F.[Partida]
                    //      ,F.[Adscripcion]
                    //      ,F.[UbicacionFisica]
                    //      ,F.[Proyecto]
                    //      ,F.[TipoNomina]
                    //      ,F.[TiponominaAbreviatura]
                    //      ,F.[MesNomina]
                    //      ,F.[Abreviatura]
                    //      ,F.[OrdenMesGeneracion]
                    //      ,F.[Año]
                    //      ,F.[QuincenaMes]
                    //      ,F.[FechaInicio]
                    //      ,F.[FechaTermino]
                    //      ,F.[IdNomina]
                    //      ,F.[IdConvenioLaboralTrabajadorCategoria]
                    //      ,F.[SueldoBruto]
                    //      ,F.[SueldoDiario]
                    //      ,F.[SueldoNeto]
                    //      ,F.[SueldoTransferencia]
                    //      ,F.[SueldoMonedero]
                    //      ,F.[IdTrabajadorCuentasTransferencia]
                    //      ,F.[IdTrabajadorCuentasMonedero]
                    //      ,F.[HorasSemanaMes]
                    //      ,F.[HorasSemanaMesTrabajadas]
                    //      ,F.[HorasExcedentes]
                    //      ,F.[HorasTrabajadasExcedentes]
                    //      ,F.[HorasInterinas]
                    //      ,F.[HorasTrabajadasInterinas]
                    //      ,F.[DiasEfectivosLaborados]
                    //      ,F.[CostoPorHora]
                    //      ,F.[CostoPorHoraExcedente]
                    //      ,F.[CostoPorHorasInterinas]
                    //      ,F.[SalarioDiarioIntegrado]
                    //      ,F.[QuinquenioDiario]
                    //      ,F.[MaterialDidacticoDiario]
                    //      ,F.[SueldoBrutoQuinquenioDiario]
                    //      ,F.[SumaPercepcionesVariables]
                    //      ,F.[BaseGravable]
                    //      ,F.[HorasEfectivasDeTrabajo]
                    //      ,F.[EsHorarioSinCambios]
                    //      ,F.[SalarioBrutoGravable]
                    //      ,F.[SubsidioEmpleoMensual]
                    //      ,F.[Isr]
                    //      ,F.[IsrRdl]
                    //      ,F.[Rdl]
                    //      ,F.[CantidadSubsidioEmpleoMensual]
                    //      ,F.[EsHorarioAnterior]
                    //      ,F.[EsHorarioAjustado]
                    //      ,F.[CostoEficienciaExcedente]
                    //      ,F.[CostoMaterialDidactico]
                    //      ,F.[CostoEficienciaJornada]
                    //      ,F.[CostoMaterialDidacticoExcedente]
                    //      ,F.[IdNominaTrabajadorEstatus]
                    //      ,F.[DiasFaltas]
                    //      ,F.[HorasFaltas]
                    //      ,F.[EsMedioRecibo]
                    //      ,F.[CicloEscolar]
                    //      ,F.[AjusteRealizado]
                    //      ,F.[MotivoAjuste]
                    //      ,F.[TotalDeducciones]
                    //      ,F.[IdMotivoDevolucion]
                    //      ,F.[SueldoTabular]
                    //      ,F.[PercepcionesAdicionales]
                    //      ,F.[IdTrabajador]
                    //      ,F.[IdPercepcion]
                    //      ,F.[IdPlantillaNomina]
                    //      ,F.[IdRelacionConvenioLaboral]
                    //      ,F.[IdTipoNomina]
                    //      ,F.[IdMesGeneracion]
                    //      ,F.[IdModalidadEstudio]
                    //      ,F.[IdQuincenaMes]
                    //      ,F.[TipoConcepto]
                    //      ,F.[SubTipoConcepto]
                    //      ,F.[IdNominaTrabajadorEstatusGrupo]
                    //      ,F.[EstatusNomina]
                    //      ,F.[IdTipoCalculo]
                    //      ,F.[TipoCalculo]
                    //      ,F.[IdNominaTrabajador]
                    //      ,F.[EsCerrada]
                    //      ,F.[IdPercepcionDeducionCreditoPension]
                    //      ,F.[IdClasificacionLaboral]
                    //      ,F.[ClasificacionLaboral]
                    // FROM 
                    //(SELECT *
                    //  FROM  [Nomina_stNominaTrabajadorHistorial] A
                    //    where IdNomina={this.Nomina_stNomina.IdNomina} and IdConvenioLaboralTrabajadorCategoria={this.trabajadornomina.IdConvenioLaboralTrabajadorCategoria}
                    //	and EstatusNomina='CANCELADO') AS Q
                    //	LEFT JOIN 
                    //	(SELECT *
                    //  FROM  [Nomina_stNominaTrabajadorHistorial] A
                    //    where IdNomina={this.Nomina_stNomina.IdNomina} and IdConvenioLaboralTrabajadorCategoria={this.trabajadornomina.IdConvenioLaboralTrabajadorCategoria}
                    //	and EstatusNomina='RECALCULO') AS F ON Q.IdNomina=F.IdNomina
                    //	AND Q.IdConvenioLaboralTrabajadorCategoria=F.IdConvenioLaboralTrabajadorCategoria
                    //	AND Q.Percepcion=F.Percepcion AND Q.Concepto=F.Concepto";

                    var i=dp.connection.Execute(qeuryrecalculo);


                    if (hayregistrotrabajador)
                    {

                        if (this.EsRecalculoPorTrabajador)
                        {
                            var uU = dp.connection.Execute(@"update Nomina_stNominaTrabajadorHistorial  set IdAjustePresupuestal= (SELECT TOP 1  IdAjustePresupuestal FROM Nomina_stNominaTrabajadorHistorial WHERE EstatusNomina='CANCELADO' and " + wheresqlAjusteIN + " )  where EstatusNomina='RECALCULO' and " + wheresqlAjuste, null, null, 0, null);

                            var ux = dp.connection.Execute(@"update Nomina_stNominaTrabajador set IdNominaAjustePresupuestal= (SELECT TOP 1  IdAjustePresupuestal FROM Nomina_stNominaTrabajadorHistorial WHERE EstatusNomina='CANCELADO' and " + wheresqlAjusteIN + " )  where IdNominaTrabajadorEstatus=2 and " + wheresqlAjuste, null, null, 0, null);
                        }
                    }

                        }

   
            }
          //  dp.Close();

        }

 
public string GetDatabaseNovaName()
    {
        // Obtener la cadena de conexión del archivo Web.config
        string entityConnectionString = ConfigurationManager.ConnectionStrings["bdNovaEntities"].ConnectionString;

        // Crear una instancia de EntityConnectionStringBuilder para analizar la cadena de conexión
        var entityBuilder = new EntityConnectionStringBuilder(entityConnectionString);

        // Obtener la cadena de conexión del proveedor
        string providerConnectionString = entityBuilder.ProviderConnectionString;

        // Crear una instancia de SqlConnectionStringBuilder para analizar la cadena de conexión del proveedor
        var sqlBuilder = new SqlConnectionStringBuilder(providerConnectionString);

        // Obtener el nombre de la base de datos
        string databaseName = sqlBuilder.InitialCatalog;

        return databaseName;
    }

    public void GrabarNominaBaseDatos()
        {




            if (BorradoCompletado == false)
            {

                while (BorradoCompletado == false)
                {
                    int milliseconds = 2000;
                    Thread.Sleep(milliseconds);
                }

            }







            //bdNovaEntities bd = new bdNovaEntities();
            var connString = ConfigurationManager.ConnectionStrings["bdNovaEntities"].ConnectionString;
            EntityConnection ec = new EntityConnection(connString);
            string storeConnect = ec.StoreConnection.ConnectionString;

            SqlConnection conn = new SqlConnection(storeConnect);
            conn.Open();

            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                

            //bdNovaEntities bda = new bdNovaEntities();
            var connStringa = ConfigurationManager.ConnectionStrings["bdAriesEntities"].ConnectionString;
            EntityConnection eca = new EntityConnection(connString);
            string storeConnecta = ec.StoreConnection.ConnectionString;

            SqlConnection conna = new SqlConnection(storeConnect);
            conna.Open();

            TransactionOptions transactionoptions2 = new TransactionOptions();
            transactionoptions2.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;




            if (this.EsProyeccion == false)
            {

                

                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {
                    if (this.EsRecalculoPorTrabajador)
                    {
                        Nomina_stNominaTrabajadorEstatus idstatusrecalculo = null;

                             using (var basenova = new bdNovaEntities())
                        {
                            basenova.Database.Connection.Open();
                            idstatusrecalculo = basenova.Nomina_stNominaTrabajadorEstatus.AsNoTracking().Where(z=> z.EstatusNomina== "RECALCULO").FirstOrDefault();
                            basenova.Database.Connection.Close();
                        }

                        foreach (var item in Nomina_stNominaTrabajadorLista)
                        {
                            item.IdMotivoDevolucion =(short) this.MotivoDevolucionId;
                            item.IdNominaTrabajadorEstatus = (short) idstatusrecalculo.IdNominaTrabajadorEstatus;
                        }
                        


                    }

                    Nomina_stNominaTrabajadorLista = Nomina_stNominaTrabajadorLista.Where(a => a.SueldoBruto > 0).ToList();

                    var diascalendario = (this.Nomina_stNomina.FechaTermino - this.Nomina_stNomina.FechaInicio).Days + 1;
                    Nomina_stNominaTrabajadorLista.ForEach(u => u.DiasCalendario = (short?)diascalendario);
                  

                    var bcp = new SqlBulkCopy(conn);
                    var reader = ObjectReader.Create(Nomina_stNominaTrabajadorLista
                        ,
                    "IdNominaTrabajador",
                    "IdNomina",
                    "IdConvenioLaboralTrabajadorCategoria",
                    "SueldoBruto",
                    "SueldoDiario",
                    "SueldoNeto",
                    "SueldoTransferencia",
                    "SueldoMonedero",
                   "IdTrabajadorCuentasTransferencia",
                   "IdTrabajadorCuentasMonedero",
                   "HorasSemanaMes",
                   "HorasSemanaMesTrabajadas",
                   "HorasExcedentes",
                   "HorasTrabajadasExcedentes",
                   "HorasInterinas",
                   "HorasTrabajadasInterinas",
                   "DiasEfectivosLaborados",
                    "CostoPorHora",
                    "CostoPorHoraExcedente",
                    "CostoPorHorasInterinas",
                    "SalarioDiarioIntegrado",
                    "QuinquenioDiario",
                    "MaterialDidacticoDiario",
                    "SueldoBrutoQuinquenioDiario",
                    "SumaPercepcionesVariables",
                    "BaseGravable",
                   "HorasEfectivasDeTrabajo",
                    "EsHorarioSinCambios",
                    "SalarioBrutoGravable",
                    "SubsidioEmpleoMensual",
                    "Isr",
                    "IsrRdl",
                    "Rdl",
                    "CantidadSubsidioEmpleoMensual",
                    "EsHorarioAnterior",
                    "EsHorarioAjustado",
                    "CostoEficienciaExcedente",
                    "CostoMaterialDidactico",
                    "CostoEficienciaJornada",
                    "CostoMaterialDidacticoExcedente",
                    "IdNominaTrabajadorEstatus",
                     "DiasFaltas",
                     "HorasFaltas",
                     "EsMedioRecibo",
                     "CicloEscolar",
                       "AjusteRealizado",
                       "MotivoAjuste",
                       "TotalDeducciones",
                       "IdMotivoDevolucion",
                        "SueldoTabular",
                        "PercepcionesAdicionales",
                       "FechaIngreso",
                        "EsAlta",
                        "DiasIncapacidadImss",
                    "DiasRetencion",
                      "Obrero_RCV",
                      "Obrero_IMSS",
                     "IdNominaAjustePresupuestal",
                      "DiasDeAjuste",
                      "DiasCalendario"
                    );
                    {
                        bcp.DestinationTableName = "Nomina_stNominaTrabajador";
                        bcp.BatchSize = 10000;
                        bcp.WriteToServer(reader);
                    }







                    List<Nomina_stNominaTrabajador> ListaTrabajadoresConId = new List<Nomina_stNominaTrabajador>();
                    if (this.IdConvenioLaboralTrabajadorCategoria > 0)
                    {
                        if (EsRecalculoPorTrabajador)
                        {
                            using (var basenova = new bdNovaEntities())
                            {
                                


                                basenova.Database.Connection.Open();
                                // Desactiva Lazy Loading para evitar errores de acceso
                                basenova.Configuration.LazyLoadingEnabled = false;

                                ListaTrabajadoresConId = basenova.Nomina_stNominaTrabajador.AsNoTracking().Where(x => x.IdNomina == this.IdNomina
                                && x.IdConvenioLaboralTrabajadorCategoria == this.IdConvenioLaboralTrabajadorCategoria
                                && x.Nomina_stNominaTrabajadorEstatus.EstatusNomina == "RECALCULO"
                                )
                                    .Include(q => q.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                                    .Include(q => q.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones)
                                    .Include(q => q.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones
                      .Select(d => d.Deducciones_ctDeduccion)) 
                                    .Include(q => q.Nomina_stNomina.Nomina_ctPlantillaNomina)
                                    .Include(q => q.Nomina_stNomina)
                                    .ToList();
                                basenova.Database.Connection.Close();
                            }


                        }
                        else
                        {
                            using (var basenova = new bdNovaEntities())
                            {
                                


                                basenova.Database.Connection.Open();

                                // Desactiva Lazy Loading para evitar errores de acceso
                                basenova.Configuration.LazyLoadingEnabled = false;

                                ListaTrabajadoresConId = basenova.Nomina_stNominaTrabajador.AsNoTracking().Where(x => x.IdNomina == this.IdNomina
                 && x.IdConvenioLaboralTrabajadorCategoria == this.IdConvenioLaboralTrabajadorCategoria

                 )
                     
                     .Include(q => q.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                                    .Include(q => q.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones)
                                                  .Include(q => q.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones
                      .Select(d => d.Deducciones_ctDeduccion))
                                    .Include(q => q.Nomina_stNomina.Nomina_ctPlantillaNomina)   
                                    .Include(q => q.Nomina_stNomina)
                     .ToList();

                                basenova.Database.Connection.Close();
                            }
                        }


                     
                    }
                    else
                    {
                        

                        using (var basenova = new bdNovaEntities())
                        {
                            

                            basenova.Database.Connection.Open();

                            // Desactiva Lazy Loading para evitar errores de acceso
                            basenova.Configuration.LazyLoadingEnabled = false;

                            ListaTrabajadoresConId = basenova.Nomina_stNominaTrabajador.AsNoTracking().Where(x => x.IdNomina == this.IdNomina)
                                .Include(q => q.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                                .Include(q => q.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador)
                                    .Include(q => q.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones)
                                                  .Include(q => q.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones
                      .Select(d => d.Deducciones_ctDeduccion))
                                    .Include(q => q.Nomina_stNomina.Nomina_ctPlantillaNomina)
                                    .Include(q => q.Nomina_stNomina)
                                .ToList();

                            basenova.Database.Connection.Close();
                        }
                    }

                    foreach (var trabajador in ListaTrabajadoresConId)
                    {
                        if (EsRecalculoPorTrabajador)
                        {
                            IdNominaTrabajadorRecalculo = trabajador.IdNominaTrabajador;
                            IdAjustePresupuestalRecalculo = trabajador.IdNominaAjustePresupuestal;
                        }
                        GrabarPercepciones(trabajador);
                        GrabaHorarios(trabajador);
                        GrabarViaticos(trabajador);
                        GrabarDeducciones(trabajador);
                        GrabarCreditos(trabajador);
                        GrabarCreditosNoAplicados(trabajador);
                        GrabarPensiones(trabajador);
                        GrabarIncidenciasSaldos(trabajador);
                        GrabarIncidenciasSaldosAuxiliares(trabajador);





                    }




                    var reader2 = ObjectReader.Create(this.PercepcionesDelTrabajador
                    ,
                    "IdNominaTrabajadorPercepcion",
                    "IdPlantillaNominaPercepcion",
                    "IdNominaTrabajador",
                    "Importe",
                     "EsAjusteHorasInterinas",
                    "EsAjusteHorasExcedentes",
                     "EsDevolucionFaltas",
                     "Concepto"
                        );
                    {
                        bcp.DestinationTableName = "Percepciones_stNominaTrabajadorPercepciones";
                        bcp.BatchSize = 10000;
                        bcp.WriteToServer(reader2);
                    }



                    var readerh = ObjectReader.Create(this.HorariosDelTrabajador
                 ,
                 "IdNominaHorario",
                 "IdNominaTrabajador",
                 "IdHorarioNominaDocente"
                 
                     );
                    {
                        bcp.DestinationTableName = "Nomina_stNominaHorariosDocentes";
                        bcp.BatchSize = 10000;
                        bcp.WriteToServer(readerh);
                    }


                    var reader2v = ObjectReader.Create(this.ViaticosDelTrabajador
                   ,
                   "IdNominaTrabajadorPercepcion",
                   "IdPlantillaNominaPercepcion",
                   "IdNominaTrabajador",
                   "Importe",
                    "EsAjusteHorasInterinas",
                   "EsAjusteHorasExcedentes",
                    "EsDevolucionFaltas",
                    "Concepto"
                       );
                    {
                        bcp.DestinationTableName = "Percepciones_stNominaTrabajadorPercepcionesViaticos";
                        bcp.BatchSize = 10000;
                        bcp.WriteToServer(reader2v);
                    }




                    var reader3 = ObjectReader.Create(this.DeduccionesDelTrabajador
                  ,
                  "IdNominaTrabajadorDeduccion",
                  "IdPlantillaNominaDeduccion",
                  "Importe",
                  "EsImprimibleRecibo",
                  "IdNominaTrabajador",
                  "EsAjuste",
                    "Concepto"
                      );
                    {
                        bcp.DestinationTableName = "Deducciones_stNominaTrabajadorDeduccion";
                        bcp.BatchSize = 10000;
                        bcp.WriteToServer(reader3);
                    }

                    if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
                    {
                        List<Deducciones_stNominaTrabajadorDeduccion> deducciones = new List<Deducciones_stNominaTrabajadorDeduccion>();
                        using (var basenova = new bdNovaEntities())
                        {
                            basenova.Database.Connection.Open();

                              deducciones = basenova
                                .Deducciones_stNominaTrabajadorDeduccion.AsNoTracking().Where(q => q.Deducciones_stPlantillaNominaDeducciones.Deducciones_ctDeduccion.Deduccion == "IMSS"
                        && q.Nomina_stNominaTrabajador.IdNomina == this.IdNomina)
                                .Include(z=> z.Nomina_stNominaTrabajador)
                                .Include(z=> z.Nomina_stNominaTrabajador.Nomina_stNomina)
                                .ToList();
                            basenova.Database.Connection.Close();
                        }
                        
                        foreach (var trabajador in ListaTrabajadoresConId)
                        {
                            GrabaSubdeducciones(trabajador, deducciones);
                        }





                        var reader4 = ObjectReader.Create(this.SubDeduccionesDelTrabajador
                            ,
                        "IdNominaTrabajadorSubDeduccion",
                        "IdNominaTrabajadorDeduccion",
                        "IdSubDeduccion",
                        "Importe"
                            );
                        {
                            bcp.DestinationTableName = "Deducciones_stNominaTrabajadorSubDeducciones";
                            bcp.BatchSize = 10000;
                            bcp.WriteToServer(reader4);
                        }
                    }

                    var reader5 = ObjectReader.Create(this.CreditosDelTrabajador
                    ,
                    "IdNominaCreditoTrabajador",
                    "IdCreditoTrabajador",
                    "IdNominaTrabajador",
                    "Importe",
                    "EsAjuste"
                        );


                    {
                        bcp.DestinationTableName = "Creditos_stNominaCreditoTrabajador";
                        bcp.BatchSize = 10000;
                        bcp.WriteToServer(reader5);
                    }

                    var reader50 = ObjectReader.Create(this.CreditosDelTrabajadorNoAplicados
                   ,
                   "IdNominaCreditoTrabajadorNoAplicados",
                   "IdCreditoTrabajador",
                   "IdNominaTrabajador",
                   "Importe",
                   "EsAjuste",
                   "Motivo"
                       );


                    {
                        bcp.DestinationTableName = "Creditos_stNominaCreditoTrabajadorNoAplicados";
                        bcp.BatchSize = 10000;
                        bcp.WriteToServer(reader50);
                    }

                    var todas = string.Join(",", PensionesDelTrabajador.Select(a => a.IdNominaTrabajador));

                    var duplicados = PensionesDelTrabajador
            .GroupBy(a => new { a.IdPensionTrabajador, a.IdNominaTrabajador, a.Concepto })
            .Where(g => g.Count() > 1)
            .Select(g => g.Key)
            .ToList();


                    var reader6 = ObjectReader.Create(this.PensionesDelTrabajador
                    ,
                    "IdNominaPensionTrabajador",
                    "IdPensionTrabajador",
                    "IdNominaTrabajador",
                    "Importe",
                    "Concepto"
                        );
                    {
                        bcp.DestinationTableName = "Pensiones_stNominaPensionTrabajador";
                        bcp.BatchSize = 10000;
                        bcp.WriteToServer(reader6);
                    }


 

                    var reader88 = ObjectReader.Create(this.ListaNomina_IncidenciasSaldosAuxiliar
         ,
         "IdIncidenciasSaldos"
         , "IdIncidenciaTrabajador"
              , "IdNomina"
              , "IdConvenioLaboralTrabajadorCategoria"
              , "Saldo"
               , "Total"
               ,"DiasTotales"
      ,"DiasSaldo"
             );


                    {
                        bcp.DestinationTableName = "Nomina_IncidenciasSaldosAuxiliar";
                        bcp.BatchSize = 10000;
                        bcp.WriteToServer(reader88);
                    }


                    var readerT = ObjectReader.Create(this.Lista_PagosDiasEconomicosyPuntualidad
                    ,
                     "IdPagosDiasEconomicosyPuntualidad",
                     "IdTrabajador",
    "TotalDias",
    "IdQuincenaMes",
    "Año",
    "IdTipoPagoRegistro",
    "IdNomina"
                        );
                    {
                        bcp.DestinationTableName = "Nomina_PagosDiasEconomicosyPuntualidadAuxiliar";
                        bcp.BatchSize = 10000;
                        bcp.WriteToServer(readerT);
                    }


                    DapperQuery dp = new DapperQuery("bdNovaEntities");

                    foreach (var item in ListaNomina_IncidenciasSaldosActualizar)
                    {
                        string query2 = "";
                        if (item.DiasSaldo!=null)
                        query2 = @"update Nomina_IncidenciasSaldosAuxiliar set saldo=" + item.Saldo + ",diassaldo=" + item.DiasSaldo + " where IdConvenioLaboralTrabajadorCategoria=" + item.IdConvenioLaboralTrabajadorCategoria + " and IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador;
                        else
                            query2 = @"update Nomina_IncidenciasSaldosAuxiliar set saldo=" + item.Saldo + " where IdConvenioLaboralTrabajadorCategoria=" + item.IdConvenioLaboralTrabajadorCategoria + " and IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador;
                        var ss = dp.connection.Execute(query2);
                    }


                    if (this.CerrarNomina || this.EsRecalculoPorTrabajador)
                    {

                        var existencreditos = ListaVariablesNominaTrabajador.Where(a => a.Concepto == "CREDITOSAPLICADOSPORCREDITOSGENERADOSPORSISTEMA").ToList();


                        foreach (var item in existencreditos)
                        {
                            string query2 = "";

                            query2 = $@"update Creditos_stCreditoTrabajador set EsAplicado=1 where idtrabajador={item.IdTrabajador}
                        and IdCreditotrabajador={item.Importe}";
                            var tce = dp.connection.Execute(query2);
                        }

                        var cerrarajustesdiaseconpuntulidad = false;
                        if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
                        {
                            cerrarajustesdiaseconpuntulidad = true;

                            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "ADMINISTRATIVO"
                                && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("BASE"))
                            {
                                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
                                    cerrarajustesdiaseconpuntulidad = true;
                                else
                                    cerrarajustesdiaseconpuntulidad = false;
                            }
                        }

                        if (cerrarajustesdiaseconpuntulidad )
                        {

                            var readerTa = ObjectReader.Create(this.Lista_PagosDiasEconomicosyPuntualidad
                            ,
                             "IdPagosDiasEconomicosyPuntualidad",
                             "IdTrabajador",
            "TotalDias",
            "IdQuincenaMes",
            "Año",
            "IdTipoPagoRegistro",
            "IdNomina"
                                );
                            {
                                bcp.DestinationTableName = "Nomina_PagosDiasEconomicosyPuntualidad";
                                bcp.BatchSize = 10000;
                                bcp.WriteToServer(readerTa);
                            }
                        }

                        //DapperQuery dpa = new DapperQuery("bdAriesEntities");
                        string dbnameAries = GetDatabaseName("bdAriesEntities");

                        string query;

                        foreach (var itemlicencia in this.AjustesLicenciasSinGoceSueldoSegunNominas)
                        {
                            //string valor = itemlicencia.Saldo.ToString();
                             
                            
                                query = $@"update IncidenciaPermiso_stIncidenciaTrabajador set EsDevolucionPorLicenciaAplicada=1 where IdIncidenciaTrabajador= {itemlicencia.IdIncidenciaTrabajador}";

                            var t = dp.connection.Execute(query);
                        }

                        if (this.EsRecalculoPorTrabajador == false)
                        {
                            dp.connection.Execute(" update Nomina_stNomina set EsCerrada=1 where IdNomina=" + this.IdNomina.ToString());

                            ActualizarIncapacidades(ListaTrabajadoresConId,dp);

                            foreach (var trabajador in ListaTrabajadoresConId)
                            {
                                var trabid = this.TrabajadoresVigentes.Where(s => s.IdConvenioLaboralTrabajadorCategoria == trabajador.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                                setIncidenciaTrabajador(trabid.Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                                ActualizarFaltasPrimaDiasDescansoAplicadas(trabajador, dp);


                            }

                            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud)
                                { 
                                //&& 
                                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                                  ActualizarPartesProporcionales(ListaTrabajadoresConId, dp);
                                else
                                    if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PRESTACIONES ADICIONALES"))
                                    ActualizarPrestacionesAdicionales(ListaTrabajadoresConId, dp);

                            }

                            foreach (var itemCredito in this.CreditosDelTrabajadorSaldos)
                            {
                                string valor = itemCredito.Saldo.ToString();
                                valor = valor.Replace(",", ".");
                                if ((bool)itemCredito.EsParaDevolucion && itemCredito.EsYaDevuelto == false)
                                    query = @"update Creditos_stCreditoTrabajador set Saldo=" + valor + ",EsAplicado=1,EsYaDevuelto=1 where IdCreditoTrabajador=" + itemCredito.IdCreditoTrabajador;
                                else
                                    if (itemCredito.ParcialidadesPagadas > 0)
                                    query = @"update Creditos_stCreditoTrabajador set ParcialidadesPagadas=" + itemCredito.ParcialidadesPagadas + ",EsAplicado=1 where IdCreditoTrabajador=" + itemCredito.IdCreditoTrabajador;
                                else
                                    query = @"update Creditos_stCreditoTrabajador set Saldo=" + valor + ",EsAplicado=1 where IdCreditoTrabajador=" + itemCredito.IdCreditoTrabajador;

                                var t = dp.connection.Execute(query);
                            }

                            //actualiza las devoluciones de creditos 
                            var creditosdevueltos = this.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "CREDITOSDEVUELTOS").ToList();
                            if (creditosdevueltos.Count > 0)
                            {
                                string creditosDevueltosaActualizar = string.Join(",", creditosdevueltos
                                        .Select(p => p.Importe.ToString()));

                                query = @"update Creditos_stCreditoTrabajador set EsAplicado=1,EsYaDevuelto=1 where IdCreditoTrabajador 
                                in (" + creditosDevueltosaActualizar + ")";
                                var qwe = dp.connection.Execute(query);
                            }

                            var idcltcTRabVigentes = string.Join(",", TrabajadoresVigentes
                                        .Select(p => p.IdConvenioLaboralTrabajadorCategoria.ToString())); ;

                            var idTrabajadorVigentes = string.Join(",", TrabajadoresVigentes
                                       .Select(p => p.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString())); ;


                            //AJUSTES DE PRIMERA VEZ HASTA UEQ SE COMPLETEN LAS NOMINAS DE LA QNA A AL FECHA DE TERMINO

  //                          string queryNominascerradas = @"select 
  //count(*) as TotalCerradas ,count (*) as TotalNominas 
  //from nomina_stNomina a 
  //inner join [Nomina_ctPlantillaNomina] b on a.IdPlantillaNomina=b.IdPlantillaNomina
  //inner join [Nomina_ctTipoCalculo] c on c.IdTipoCalculo=a.IdTipoCalculo
  //where    escerrada=1 and TipoCalculo='NORMAL' and fechatermino='" + this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") + @"' and b.[IdRelacionConvenioLaboral]=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + " and calculoporsolicitud=0";

                            string queryNominascerradas = $@"select 
  a.* 
  from nomina_stNomina a 
  inner join [Nomina_ctPlantillaNomina] b on a.IdPlantillaNomina=b.IdPlantillaNomina
  inner join [Nomina_ctTipoCalculo] c on c.IdTipoCalculo=a.IdTipoCalculo
  inner join Nomina_ctTipoNomina t on t.IdTipoNomina=a.idtiponomina
  where  year(a.fechatermino)={this.Nomina_stNomina.FechaTermino.Year} and escerrada=1 and TipoCalculo='NORMAL' and  t.TipoNomina<>'EXTRAORDINARIA'  and a.IdQuincenaMes  =" + this.Nomina_stNomina.IdQuincenaMes + @" and b.[IdRelacionConvenioLaboral]=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + " and calculoporsolicitud=0";



                            var totalesCerradas = (List<Nomina_stNomina>)dp.connection.Query<Nomina_stNomina>(queryNominascerradas);


  //                          string queryNominas = @"select 
  //count(*) as TotalCerradas ,count (*) as TotalNominas 
  //from nomina_stNomina a 
  //inner join [Nomina_ctPlantillaNomina] b on a.IdPlantillaNomina=b.IdPlantillaNomina
  //inner join [Nomina_ctTipoCalculo] c on c.IdTipoCalculo=a.IdTipoCalculo
  //where     TipoCalculo='NORMAL' and fechatermino='" + this.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd") + @"' and b.[IdRelacionConvenioLaboral]=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + " and calculoporsolicitud=0";


                            string queryNominas = $@"select 
  a.* 
  from nomina_stNomina a 
  inner join [Nomina_ctPlantillaNomina] b on a.IdPlantillaNomina=b.IdPlantillaNomina
  inner join [Nomina_ctTipoCalculo] c on c.IdTipoCalculo=a.IdTipoCalculo
inner join Nomina_ctTipoNomina t on t.IdTipoNomina=a.idtiponomina
  where   year(a.fechatermino)={this.Nomina_stNomina.FechaTermino.Year}  and   TipoCalculo='NORMAL' and  t.TipoNomina<>'EXTRAORDINARIA'  and   a.IdQuincenaMes  =" + this.Nomina_stNomina.IdQuincenaMes + @" and b.[IdRelacionConvenioLaboral]=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + " and calculoporsolicitud=0";

                            var totalesNominas = (List<Nomina_stNomina>)dp.connection.Query<Nomina_stNomina>(queryNominas);



                            // solo actualiza  los ajuste realizados hasta que se cierren todas las nominas
                            // a excepcion de las pensiones
                            if ((totalesNominas.Count()) == totalesCerradas.Count() 
                                && this.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
                            {

                                // actualiza la bandera de las altas 
                                if (this.Nomina_stNominaTrabajadorLista.Count > 0)
                                {
                                    string conveniosActualizar = string.Join(",", this.Nomina_stNominaTrabajadorLista
                                             .Select(p => p.IdConvenioLaboralTrabajadorCategoria.ToString()));


                                //    query = @"update Convenios_stConvenioLaboralTrabajadorCategoria set EsPrimerCalculo=0 where EsPrimerCalculo=1 and IdConvenioLaboralTrabajadorCategoria 
                                //in (" + conveniosActualizar + ")";

                                    query = $@"update Convenios_stConvenioLaboralTrabajadorCategoria set EsPrimerCalculo=0 where EsPrimerCalculo=1 and IdConvenioLaboralTrabajadorCategoria 
                                in (SELECT b.IdConvenioLaboralTrabajadorCategoria
  FROM Nomina_stNomina as a
  inner join Nomina_stNominaTrabajador b on a.IdNomina=b.IdNomina
  inner join Nomina_ctPlantillaNomina c on c.IdPlantillaNomina=a.IdPlantillaNomina
  where a.IdQuincenaMes={this.Nomina_stNomina.IdQuincenaMes} and a.Año={this.Nomina_stNomina.Año} and a.EsCerrada=1
 and c.IdRelacionConvenioLaboral={this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral}
  and c.Plantilla like '%SUELDO%')";

                                    var ww = dp.connection.Execute(query);

                                    if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("DOCENTE")
                                        && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO")
                                        )
                                    {
                                        //string consulta = @"select IdKardex from vwDatosAspirantesTrabajadores where 
                                        //IdConvenioLaboralTrabajadorCategoria in (" + conveniosActualizar + ")";

                                        string consulta = $@"select IdKardex from vwDatosAspirantesTrabajadores where 
                                        IdConvenioLaboralTrabajadorCategoria in (SELECT b.IdConvenioLaboralTrabajadorCategoria
  FROM Nomina_stNomina as a
  inner join Nomina_stNominaTrabajador b on a.IdNomina=b.IdNomina
  inner join Nomina_ctPlantillaNomina c on c.IdPlantillaNomina=a.IdPlantillaNomina
  where a.IdQuincenaMes={this.Nomina_stNomina.IdQuincenaMes} and a.Año={this.Nomina_stNomina.Año} and a.EsCerrada=1
 and c.IdRelacionConvenioLaboral={this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral}
  and c.Plantilla like '%SUELDO%')";

                                        var kardexs = (List<Int64>)dp.connection.Query<Int64>(consulta.ToString());

                                        string idkardexActualizar = string.Join(",", kardexs
                                             .Select(p => p.ToString()));


                                        // actualiza los horarios nuevo en caso de qeu exista algun cambio de horas


                                        using (TransactionScope scopea = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions2))
                                        {

                                            string tipohoras = " IdTipoHoras not in (39,40,41,42) ";

                                            if (Nomina_stNomina != null)
                                                if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("HORAS EXTRAORDINARIAS"))
                                                {
                                                    tipohoras = " IdTipoHoras in (39,40,41,42) ";
                                                }


                                            query = $@"update {dbnameAries}.dbo.stHorarioNominaDocente set Aplicado=1 where {tipohoras} and (Aplicado=0 or Aplicado is null) and idkardex 
                                            in (" + idkardexActualizar + ")";
                                            //var horarios = dpa.connection.Execute(query);
                                            var horarios = dp.connection.Execute(query);

                                            
                                            var EXISTENCAMBIOSDECILCOS =this.ListaVariablesNominaTrabajador.Where(a=> a.Concepto== "UPDATEHORARIONOPAGADO").ToList();
                                            foreach (var item in EXISTENCAMBIOSDECILCOS)
                                            {
                                                query = $@"update {dbnameAries}.dbo.stHorarioNominaDocente set Aplicado=0 where FechaInicioPago='{item.Concepto}' and Aplicado=1  and idkardex={item.Importe} ";
                                                //var horarios = dpa.connection.Execute(query);
                                                var upd = dp.connection.Execute(query);
                                            }

                                            ////  dpa.Close();
                                            scopea.Complete();
                                        }

                                    }
                                }//lista count >0

                            }

                            if (this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
                            {

                                // ajuste de infonavit


                                var ajustesinfonavitfactor = string.Join(",", this.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "AjusteFactorAplicado")
                                    .Select(p => p.IdIncidenciaTrabajador.ToString()));
                                if (ajustesinfonavitfactor.Length > 0)
                                {
                                    var credajus = @"update Creditos_stCreditoTrabajador set AjusteFactorAplicado=1 where IdCreditoTrabajador in(" + ajustesinfonavitfactor + ")";
                                    var caj = dp.connection.Execute(credajus);
                                }


                                // marca a las incidencias de enfermedad general como aplicadas
                                var spq = @"update  Nomina_IncidenciaPermisoCalculo  set EsAplicada=1
                    from Nomina_IncidenciaPermisoCalculo a
                    inner join IncidenciaPermiso_stIncidenciaTrabajador b on a.IdIncidenciaTrabajador=b.IdIncidenciaTrabajador 
inner join Convenios_stConvenioLaboralTrabajadorCategoria dd on dd.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador ss on ss.IdConvenioLaboralTrabajador=dd.IdConvenioLaboralTrabajador
                        where a.año=" + this.Nomina_stNomina.FechaInicio.Year + " and a.quincenames='" + this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes + "' and ss.IdTrabajador in(" + idTrabajadorVigentes + ")";
                                var ntc = dp.connection.Execute(spq);

                                var qc = @"update IncidenciaPermiso_stIncidenciaTrabajador  set EsAplicada=1 
                        where idincidenciatrabajador in (
                        select a.idincidenciatrabajador from Nomina_IncidenciaPermisoCalculo a
inner join IncidenciaPermiso_stIncidenciaTrabajador b on a.IdIncidenciaTrabajador=b.IdIncidenciaTrabajador 
inner join Convenios_stConvenioLaboralTrabajadorCategoria dd on dd.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
  inner join Convenios_stConvenioLaboralTrabajador ss on ss.IdConvenioLaboralTrabajador=dd.IdConvenioLaboralTrabajador
                        where a.EsAplicada=1 and año=" + this.Nomina_stNomina.FechaInicio.Year + " and a.quincenames='" + this.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes + "' and ss.IdTrabajador in(" + idTrabajadorVigentes + "))";
                                dp.connection.Execute(qc);


                                var reader886 = ObjectReader.Create(this.ListaNomina_IncidenciasSaldos
                     ,
                     "IdIncidenciasSaldos"
                     , "IdIncidenciaTrabajador"
                          , "IdNomina"
                          , "IdConvenioLaboralTrabajadorCategoria"
                          , "Saldo"
                           , "Total"
                                  , "DiasTotales"
                         , "DiasSaldo"
                         );


                                {
                                    bcp.DestinationTableName = "Nomina_IncidenciasSaldos";
                                    bcp.BatchSize = 10000;
                                    bcp.WriteToServer(reader886);
                                }





                                if (this.ListaNomina_IncidenciasSaldos.Count > 0)
                                {
                                    string maternidadriesgotrabajolista = string.Join(",", this.ListaNomina_IncidenciasSaldos
                                                .Select(p => p.IdIncidenciaTrabajador.ToString()));

                                    var querymaternidad = @"update IncidenciaPermiso_stIncidenciaTrabajador set EsAplicada=1 
from IncidenciaPermiso_stIncidenciaTrabajador a 
inner join Catalogos_ctTipoIncidencia b on a.IdTipoIncidencia=b.IdTipoIncidencia
where a.EsAplicada=0 and b.Incidencia in ('INCAPACIDAD POR RIESGO DE TRABAJO','INCAPACIDAD POR MATERNIDAD','INCAPACIDAD POR ENFERMEDAD GENERAL')
and IdIncidenciaTrabajador in (" + maternidadriesgotrabajolista + @")  ";


                                    var wtt = dp.connection.Execute(querymaternidad);
                                }


                                //ACTUALIZA pensiones que se procesaron por primera vez
                                if (this.ListaPensionesTrabajador.Count() > 0)
                                {
                                    string pensionesActualizar = string.Join(",", this.ListaPensionesTrabajador
                                            .Select(p => p.IdConvenioLaboralTrabajadorCategoria.ToString()));

                                    query = @"update Pensiones_stPensionesTrabajador  set EsAplicado=1 where IdTrabajador 
                                in ( SELECT  b.IdTrabajador
  FROM  Convenios_stConvenioLaboralTrabajadorCategoria a
  inner join Convenios_stConvenioLaboralTrabajador b
  on a.IdConvenioLaboralTrabajador=b.IdConvenioLaboralTrabajador
  where a.IdConvenioLaboralTrabajadorCategoria in (" + pensionesActualizar + ") )";
                                    var rpa = dp.connection.Execute(query);
                                }



                              //ajuste a aguarderias
                                string guarderiasActualizarajuste= string.Join(",", this.ListaVariablesNominaTrabajador.Where(s =>
                                s.Concepto == "ajusteguarderia" )
                                     .Select(p => p.Importe.ToString()));

                                if (guarderiasActualizarajuste != "")
                                {
                                    query = @"update Kardex_stDatosFamiliares set AjusteRealizado=1 where IdKardexFamiliares 
                                in (" + guarderiasActualizarajuste + ")";
                                    var categorias = dp.connection.Execute(query);

                                }

  //actuliza los ajsutes por cambio de categoria

                                string conveniosActualizarcambiocategorias = string.Join(",", this.ListaVariablesNominaTrabajador.Where(s =>
                                s.Concepto == "ajustecambiocategoria" || s.Concepto == "ajustepercepciones")
                                     .Select(p => p.IdConvenioLaboralTrabajadorCategoria.ToString()));

                                if (conveniosActualizarcambiocategorias != "")
                                {
                                    query = @"update Nomina_stNominaTrabajador set AjusteRealizado=1 where IdConvenioLaboralTrabajadorCategoria 
                                in (" + conveniosActualizarcambiocategorias + ") and IdNomina=" + this.Nomina_stNomina.IdNomina;
                                    var categorias = dp.connection.Execute(query);

                                }

                                conveniosActualizarcambiocategorias = "";

                                 conveniosActualizarcambiocategorias = string.Join(",", this.ListaVariablesNominaTrabajador.Where(s =>
                              s.Concepto == "ajustecambiocategoria" || s.Concepto == "ajustepercepciones")
                                   .Select(p => p.IdConvenioLaboralTrabajadorCategoria.ToString()));

                                if (conveniosActualizarcambiocategorias != "")
                                {
                                    query = @"update Nomina_stNominaTrabajador set AjusteRealizado=1 where IdConvenioLaboralTrabajadorCategoria 
                                in (" + conveniosActualizarcambiocategorias + ") and IdNomina=" + this.Nomina_stNomina.IdNomina;
                                    var categorias = dp.connection.Execute(query);

                                }

                            }//SUELDO



                            //////////////////


                            //foreach (var item in ListaNomina_IncidenciasSaldosActualizar)
                            //{
                            //    if (item.DiasSaldo != null)
                            //        query = @"update Nomina_IncidenciasSaldos set saldo=" + item.Saldo + ",diassaldo=" + item.DiasSaldo + " where IdConvenioLaboralTrabajadorCategoria=" + item.IdConvenioLaboralTrabajadorCategoria + " and IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador;
                            //    else
                            //        query = @"update Nomina_IncidenciasSaldos set saldo=" + item.Saldo + " where IdConvenioLaboralTrabajadorCategoria=" + item.IdConvenioLaboralTrabajadorCategoria + " and IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador;
                            //    var ss = dp.connection.Execute(query);
                            //}

                            // si tiene saldo en 0 quiere decir qeu acabo en este nomina y tiene que actualizar
                            // //el dia de los saldos
                            bool actulizodias = false;
                            foreach (var item in ListaNomina_IncidenciasSaldosActualizar)
                            {
                                if (item.Saldo == 0)
                                {
                                    if (item.DiasSaldo >0)
                                    {
                                        query = @"update Nomina_IncidenciasSaldos set saldo=" + item.Saldo + ",diassaldo=" + item.DiasSaldo + " where IdConvenioLaboralTrabajadorCategoria=" + item.IdConvenioLaboralTrabajadorCategoria + " and IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador;
                                        actulizodias = true;
                                    }
                                    else
                                        query = @"update Nomina_IncidenciasSaldos set saldo=" + item.Saldo + " where IdConvenioLaboralTrabajadorCategoria=" + item.IdConvenioLaboralTrabajadorCategoria + " and IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador;
                                }
                                else
                                    query = @"update Nomina_IncidenciasSaldos set saldo=" + item.Saldo + " where IdConvenioLaboralTrabajadorCategoria=" + item.IdConvenioLaboralTrabajadorCategoria + " and IdIncidenciaTrabajador=" + item.IdIncidenciaTrabajador;

                                var ss = dp.connection.Execute(query);
                            }

                            if (actulizodias == false)
                            {


                                //Debe de contar solo 4 nominas
                                //ODES, CTT, VALES Y AYUDA


                                queryNominas = $@"select 
  a.* 
  from nomina_stNomina a 
  inner join [Nomina_ctPlantillaNomina] b on a.IdPlantillaNomina=b.IdPlantillaNomina
  inner join [Nomina_ctTipoCalculo] c on c.IdTipoCalculo=a.IdTipoCalculo
  where (b.Plantilla like '%ODES%' or b.Plantilla like '%CCT%'
or b.Plantilla like '%VALES DE DESPENSA%' or b.Plantilla  like '%AYUDA PARA DESPENSA%' ) and
year(a.fechatermino)={this.Nomina_stNomina.FechaTermino.Year} 
    and   TipoCalculo='NORMAL' and   a.IdQuincenaMes  =" + this.Nomina_stNomina.IdQuincenaMes + @" and b.[IdRelacionConvenioLaboral]=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + " and calculoporsolicitud=0";

                                var totalesNominasINCAPACIDADES = (List<Nomina_stNomina>)dp.connection.Query<Nomina_stNomina>(queryNominas);

                                queryNominascerradas = $@"select 
  a.* 
  from nomina_stNomina a 
  inner join [Nomina_ctPlantillaNomina] b on a.IdPlantillaNomina=b.IdPlantillaNomina
  inner join [Nomina_ctTipoCalculo] c on c.IdTipoCalculo=a.IdTipoCalculo
  where(b.Plantilla like '%ODES%' or b.Plantilla like '%CCT%'
or b.Plantilla like '%VALES DE DESPENSA%' or b.Plantilla  like '%AYUDA PARA DESPENSA%' ) and  year(a.fechatermino)={this.Nomina_stNomina.FechaTermino.Year} and escerrada=1 and TipoCalculo='NORMAL' and a.IdQuincenaMes  =" + this.Nomina_stNomina.IdQuincenaMes + @" and b.[IdRelacionConvenioLaboral]=" + this.Nomina_stNomina.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral + " and calculoporsolicitud=0";
                                var totalesCerradasINCAPACIDADES = (List<Nomina_stNomina>)dp.connection.Query<Nomina_stNomina>(queryNominascerradas);

                                if ((totalesNominasINCAPACIDADES.Count()) == totalesCerradasINCAPACIDADES.Count())
                                {
                                    foreach (var itemtrab in ListaNomina_IncidenciasSaldosActualizar)
                                    {
                                        queryNominascerradas = $@"select * from Nomina_IncidenciasSaldos where DiasSaldo>0 and  IdConvenioLaboralTrabajadorCategoria={itemtrab.IdConvenioLaboralTrabajadorCategoria} order by IdIncidenciasSaldos";
                                        var diaslaborados = this.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == itemtrab.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;
                                        if (diaslaborados > 15)
                                            diaslaborados = 15;

                                        var existesaldo = (List<Nomina_IncidenciasSaldos>)dp.connection.Query<Nomina_IncidenciasSaldos>(queryNominascerradas);
                                        if (existesaldo.Count() > 0)
                                        {
                                            var registro = existesaldo.FirstOrDefault();

                                            query = $@"update Nomina_IncidenciasSaldos set DiasSaldo=DiasSaldo-{diaslaborados} where IdIncidenciasSaldos={registro.IdIncidenciasSaldos} and IdConvenioLaboralTrabajadorCategoria={itemtrab.IdConvenioLaboralTrabajadorCategoria}";

                                            var ss = dp.connection.Execute(query);
                                        }
                                    }
                                }
                            }

                            //terminar los creditos por ajustes de cambios de categoria
                            foreach (var i in ListaCreditosTrabajador.Where(w => w.Terminar == true))
                            {
                                query = @"update Creditos_stCreditoTrabajador set FechaTermino='" + i.FechaTermino.Date.ToString("yyyyMMdd") + "' where IdCreditoTrabajador=" + i.IdCreditoTrabajador;

                                var creditosfin = dp.connection.Execute(query);
                            }

                          

                            if (ListaCreditosTrabajador.Count > 0)
                            {
                                string listacreditos = string.Join(",", this.ListaCreditosTrabajador
                                .Select(p => p.IdCreditoTrabajador.ToString()));
                                listacreditos = listacreditos.Substring(0, listacreditos.Length - 1);
                                query = @"update Creditos_stCreditoTrabajador set EsAplicado=1 where IdCreditoTrabajador 
                                in (" + listacreditos + ")";
                                var creditosupdate = dp.connection.Execute(query);

                                query = @"update Creditos_stCreditoTrabajador set ParcialidadesPagadas=ParcialidadesPagadas+1 where 
                                Parcialidades>0 and Parcialidades is not null and IdCreditoTrabajador 
                                in (" + listacreditos + ")";
                                var creditosupdateparcialidades = dp.connection.Execute(query);

                            }



                        }

                        var readercred = ObjectReader.Create(this.ListaCreditosTrabajadorPagosIndebidos
                                     , "IdCreditoTrabajador"
                                      , "IdTrabajador"
                                      , "IdTipoCredito"
                                      , "VecesSalarioMinimo"
                                      , "CuotaFija"
                                      , "Porcentaje"
                                      , "FechaInicioCredito"
                                      , "FechaInicioDescuento"
                                      , "FechaTermino"
                                      , "ImporteCredito"
                                      , "Parcialidades"
                                      , "Saldo"
                                      , "ParcialidadesPagadas"
                                      , "NumeroCredito"
                                      , "IdEmpleado"
                                      , "NoFonacot"
                                      , "IdCreditoTipoDescuento"
                                      , "EsAplicado"
                                      , "EsParaDevolucion"
                                      , "EsYaDevuelto"
                                      , "IdCreditoTrabajadorFactor"
                                      , "AjusteFactorAplicado"
                                      , "EsAjustetSaldoInsuficiente"
                           );
                        {
                            bcp.DestinationTableName = "Creditos_stCreditoTrabajador";
                            bcp.BatchSize = 10000;
                            bcp.WriteToServer(readercred);
                        }


                        bcp.Close();

                     



                        if (this.NominaHorariosDocentesDetalle != null && this.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
                            if (this.NominaHorariosDocentesDetalle.Count > 0)
                            {
                                var datosdocentescambios = this.ListaVariablesNominaTrabajador.Where(s => s.Concepto == "CAMBIODEHORASDOCENTES").ToList();
                                if (datosdocentescambios.Count > 0)
                                {
                                    //actualiza los horarios nuevo en caso de qeu exista algun cambio de horas
                                    using (TransactionScope scopea = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions2))
                                    {


                                        //DapperQuery dpa = new DapperQuery("bdAriesEntities");
                                        //se almacena el idkardex en el campo de IdConvenioLaboralTrabajadorCategoria y el idcicloescolar en idtrabajador
                                        foreach (var docenteitem in datosdocentescambios)
                                        {
                                            query = @"update "+dbnameAries+".dbo.stHorarioNominaDocente set Aplicado=1 where IdKardex=" + docenteitem.IdConvenioLaboralTrabajadorCategoria + " and idcicloescolar=" + docenteitem.IdTrabajador;
                                          //  var horarios = dpa.connection.Execute(query);
                                            var horarios = dp.connection.Execute(query);
                                        }


                                        // dpa.Close();
                                        scopea.Complete();

                                    }
                                }
                            }


                    }

                   
                    // else
                    GrabarNominaBaseDatosHistorial(dp);
                    dp.Close();
                    scope.Complete();

                    conn.Close();
                }

            }
            else
            {

                int c = 0;
                foreach (var item in Nomina_stNominaTrabajadorLista)
                {
                    c++;
                    item.IdNominaTrabajador = c;
                }


                foreach (var trabajador in Nomina_stNominaTrabajadorLista)
                {
                    GrabarPercepciones(trabajador);
                    GrabarDeducciones(trabajador);
                    GrabarCreditos(trabajador);
                    GrabarPensiones(trabajador);

                }


                GrabaSubdeduccionesProyeccion();







            }

            conn.Close();
            conna.Close();
            //bd.Dispose();
            //bda.Dispose();
        }





        public decimal PrestacionesIncapacidadesSueldoIsr(int IdConvenioLaboralTrabajadorCategoria)
        {
            decimal valor = 0;


            var especiales = this.PlantillaNominaPercepciones.Where(s => s.Percepciones_ctPercepcion.TratamientoEspecialIncapacidadesSueldoIsr == true).Select(z => z.IdPlantillaNominaPercepcion).ToArray();

            var percepciones1 = this.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria
            && especiales.Contains(v.IdPlantillaNominaPercepcion)
            ).ToList();

            foreach (var item in percepciones1)
            {
                valor = valor + item.Importe;
            }

            var percepciones2 = this.stNominaTrabajadorPercepcionesdelMes.Where(v => especiales.Contains(v.IdPlantillaNominaPercepcion)
            && v.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();

            foreach (var item in percepciones2)
            {
                valor = valor + item.Importe;
            }


            return valor;
        }
        public void CalculadoraSueldoTrabajador(int IdConvenioLaboralTrabajadorCategoria)
        {
            DateTime hoy = DateTime.Now;
            DateTime qnaini = DateTime.Now;
            DateTime qnafin = DateTime.Now;

            //generar el rango de una nomina ne base al dia actual
            if (hoy.Day > 15)
            {
                qnaini = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-16");
                qnafin = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-30");
            }
            else
            {
                qnaini = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-01");
                qnafin = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-15");
            }
            vwDatosAspirantesTrabajadores trabajador;
            Nomina_stNomina nomina = new Nomina_stNomina();
            using (var basenova = new bdNovaEntities())
            {
                basenova.Database.Connection.Open();
                // se busca los datos generales del trabajador para generar la nomina
                  trabajador = basenova.vwDatosAspirantesTrabajadores.AsNoTracking().Where(s => s.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
          
          

            nomina = basenova.Nomina_stNomina.AsNoTracking().Where(x => x.FechaInicio == qnaini && x.FechaTermino == qnafin && x.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral
            && x.Nomina_ctPlantillaNomina.Nomina_ctPlantillaGrupo.PlantillaGrupo == "SUELDO").FirstOrDefault();
            
            if (nomina == null)
            {
                nomina = basenova.Nomina_stNomina.Where(x => x.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral
            && x.Nomina_ctPlantillaNomina.Nomina_ctPlantillaGrupo.PlantillaGrupo == "SUELDO").OrderByDescending(s => s.FechaTermino).FirstOrDefault();
            }
                basenova.Database.Connection.Close();
            }

        }

        public void AgregarSubsidio(int IdConvenioLaboralTrabajadorCategoria)
        {
            //PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


            //percepcion.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
            //percepcion.IdNomina = this.Nomina.IdNomina;
            //percepcion.IdPlantillaNominaPercepcion = this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO").FirstOrDefault().IdPlantillaNominaPercepcion;
            //percepcion.EsGrabable = this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

            //percepcion.Importe = (decimal)this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO").FirstOrDefault().Importe;
            //percepcion.Tipo = "NORMAL";
            //percepcion.EsPrevisionSocial = this.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
            //ListaPercepcionesTrabajadores.Add(percepcion);

            //DeduccionesNominaTrabajador deduccioncuotafija = new DeduccionesNominaTrabajador();
            //deduccioncuotafija.EsImprimibleRecibo = true;
            //deduccioncuotafija.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
            //deduccioncuotafija.IdNomina = this.Nomina.IdNomina;
            //deduccioncuotafija.IdPlantillaNominaDeduccion = this.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "AJUSTE SUBSIDIO CAUSADO").SingleOrDefault().IdPlantillaNominaDeduccion;
            //deduccioncuotafija.Importe = (decimal)this.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "AJUSTE SUBSIDIO CAUSADO").FirstOrDefault().Deducciones_ctDeduccion.CuotaFija;
            //this.ListaDeduccionesTrabajadores.Add(deduccioncuotafija);

        }

    }
}