﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Models.Calculos.Percepciones;
using Nova.Models.Calculos.Deducciones;
using System.Transactions;
using EntityFramework.BulkInsert.Extensions;


namespace Nova.Models.Calculos
{
    public class NominaConfianza : Nomina
    {
        private Nomina_stNominaTrabajador NominaTrabajador;

        private bdNovaEntities bd = new bdNovaEntities();
        //{
        public NominaConfianza(Nomina_stNominaTrabajador Nt)
        {
            NominaTrabajador = Nt;
        }

        public override void GenerarPercepciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            //SUELDO 
            Nova.Models.Calculos.Percepciones.Sueldo sueldo = new Nova.Models.Calculos.Percepciones.Sueldo();
            sueldo.Calcular(cltc, this.NominaTrabajador, null);

            //DEVOLUCIONES DE FALTAS
            Nova.Models.Calculos.Percepciones.DevolucionFaltas devfaltas = new Nova.Models.Calculos.Percepciones.DevolucionFaltas();
            devfaltas.Calcular(cltc, this.NominaTrabajador);

            //QUINQUENIO
            QuinquenioConfianza quinquenio = new QuinquenioConfianza();
            quinquenio.Calcular(cltc, this.NominaTrabajador, null);

            //Prima vacacional
            PrimaVacacional primavacacional = new PrimaVacacional();
            primavacacional.Calcular(cltc, this.NominaTrabajador, null);

           
            //EFICIENCIA EN EL TRABAJO

            EficienciaTrabajConfianza eficienciaTrabajo = new EficienciaTrabajConfianza();
            eficienciaTrabajo.Calcular(cltc, this.NominaTrabajador, null);

           

            // AYUDA PARA DESPENSA
            Nova.Models.Calculos.Percepciones.AyudaDespensa ayudadespensa = new Nova.Models.Calculos.Percepciones.AyudaDespensa();
            ayudadespensa.Calcular(cltc, this.NominaTrabajador, null);

            //VALES DE DESPENSA
            Nova.Models.Calculos.Percepciones.ValesDespensa valesdespensa = new Nova.Models.Calculos.Percepciones.ValesDespensa();
            valesdespensa.Calcular(cltc, this.NominaTrabajador, null);

            //PERCEPCIONES PERSONALIZADAS (GASTO ADMINISTRATIVO || NÓMINA RDL)
            Nova.Models.Calculos.Percepciones.PercepcionPersonalizada percepcionpersonalizada = new Nova.Models.Calculos.Percepciones.PercepcionPersonalizada();
            percepcionpersonalizada.Calcular(cltc, this.NominaTrabajador, null,null);
            // Aguinaldo
            Nova.Models.Calculos.Percepciones.Aguinaldo aguinaldo = new Nova.Models.Calculos.Percepciones.Aguinaldo();
            aguinaldo.Calcular(cltc, this.NominaTrabajador, null);

            

         

            PrestacionesAdicionales adicionales = new PrestacionesAdicionales();
            adicionales.Calcular(cltc, this.NominaTrabajador, null);

            //Nova.Models.Calculos.Percepciones.PartesProporcionales PartesProporcionales = new Nova.Models.Calculos.Percepciones.PartesProporcionales();
            //PartesProporcionales.Calcular(cltc, this.NominaTrabajador);

            Nova.Models.Calculos.Percepciones.PuntualidadyAsistencia PuntualidadyAsistencia = new Nova.Models.Calculos.Percepciones.PuntualidadyAsistencia();
            PuntualidadyAsistencia.Calcular(cltc, this.NominaTrabajador, null);


            DiasDescansoConfianza diasdescanso = new DiasDescansoConfianza();
            diasdescanso.Calcular(cltc, this.NominaTrabajador, null);



            DiasEconomicos DiasEconomicos = new DiasEconomicos();
            DiasEconomicos.Calcular(cltc, this.NominaTrabajador, null);

            Nova.Models.Calculos.Percepciones.AjusteDiasCalendario AjusteDiasCalendario = new Nova.Models.Calculos.Percepciones.AjusteDiasCalendario();
            AjusteDiasCalendario.Calcular(cltc, this.NominaTrabajador, null);

            Nova.Models.Calculos.Percepciones.aguinaldoPartesProporcionales aguinaldopp = new Nova.Models.Calculos.Percepciones.aguinaldoPartesProporcionales();
            aguinaldopp.Calcular(cltc, this.NominaTrabajador, null);

            Nova.Models.Calculos.Percepciones.PrimaAntiguedad primaantiguedad = new Nova.Models.Calculos.Percepciones.PrimaAntiguedad();
            primaantiguedad.Calcular(cltc, this.NominaTrabajador, null);

            Nova.Models.Calculos.Percepciones.VacacionesPartesProporcionales vacaciones = new Nova.Models.Calculos.Percepciones.VacacionesPartesProporcionales();
            vacaciones.Calcular(cltc, this.NominaTrabajador, null);

            Nova.Models.Calculos.Percepciones.SueldoPartesProporcionales sueldopp = new Nova.Models.Calculos.Percepciones.SueldoPartesProporcionales();
            sueldopp.Calcular(cltc, this.NominaTrabajador, null);

            

        }
        public override void GenerarIncapacidades(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.EnfermedadGeneralConfianza enfermedadgeneral = new Nova.Models.Calculos.Deducciones.EnfermedadGeneralConfianza();
            enfermedadgeneral.Calcular(cltc, this.NominaTrabajador);
            
        }

        public override void GenerarDeduccionesRetroactivo(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

            Nova.Models.Calculos.Deducciones.SDI sdi = new Nova.Models.Calculos.Deducciones.SDI();
            sdi.Calcular(cltc, this.NominaTrabajador);


            Nova.Models.Calculos.Deducciones.ISR isr = new Nova.Models.Calculos.Deducciones.ISR();
            isr.Calcular(cltc, this.NominaTrabajador);





        }
        public override void GenerarDeducciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

            Nova.Models.Calculos.Deducciones.FaltasConfianza faltas = new Nova.Models.Calculos.Deducciones.FaltasConfianza();
            faltas.Calcular(cltc, this.NominaTrabajador);

            Nova.Models.Calculos.Deducciones.DeduccionesPersonalizadas deducionpersonalizada = new Nova.Models.Calculos.Deducciones.DeduccionesPersonalizadas();
            deducionpersonalizada.Calcular(cltc, this.NominaTrabajador);

            Nova.Models.Calculos.Deducciones.SDI sdi = new Nova.Models.Calculos.Deducciones.SDI();
            sdi.Calcular(cltc, this.NominaTrabajador);
            Nova.Models.Calculos.Deducciones.IMSS imss = new Nova.Models.Calculos.Deducciones.IMSS();
            imss.Calcular(cltc, this.NominaTrabajador);
            

            Nova.Models.Calculos.Deducciones.ISR isr = new Nova.Models.Calculos.Deducciones.ISR();
            isr.Calcular(cltc, this.NominaTrabajador);

           

           
          

        }
        public override void GenerarCreditos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.Credito cre = new Nova.Models.Calculos.Deducciones.Credito();
            cre.Calcular(cltc, this.NominaTrabajador);


        }
        public override void GenerarPensiones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
            Nova.Models.Calculos.Deducciones.Pension cre = new Nova.Models.Calculos.Deducciones.Pension();
            cre.Calcular(cltc, this.NominaTrabajador);


        }


        public override void CalcularNomina()
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
            {

                this.NominaTrabajador.getPercepcionesRetroactivo();
            }

            foreach (var Trabajador in this.NominaTrabajador.TrabajadoresVigentes)
            {
                //try
                //{

                bool CalcularNomina = false;
                if (Trabajador.FechaInicioPago != null && Trabajador.EsPrimerCalculo)
                {
                    if (Trabajador.FechaInicioPago >= this.NominaTrabajador.Nomina_stNomina.FechaInicio
                       && Trabajador.FechaInicioPago <= this.NominaTrabajador.Nomina_stNomina.FechaTermino)
                        CalcularNomina = true;
                    else
                        if (Trabajador.FechaInicioPago <= this.NominaTrabajador.Nomina_stNomina.FechaInicio
                       && Trabajador.EsPrimerCalculo == true)
                        CalcularNomina = true;



                    this.NominaTrabajador.TrabajadoresConCalculoConFechaAnterior.Add(Trabajador);
                }
                else
                    CalcularNomina = true;


                if (CalcularNomina)
                {
                    if (this.NominaTrabajador.EsRecalculoPorTrabajador == false)
                        NominaTrabajador.DiasPagados = NominaTrabajador.DiasNomina;


                    

                    int IdConvenioLaboralTrabajadorCategoria = Trabajador.IdConvenioLaboralTrabajadorCategoria;
                    int IdTrabajador = Trabajador.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                    // jc HttpContext.Current.Session["IdTrabajador"] = IdTrabajador;

                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == Trabajador.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                    //short IdJornadaLaboral = costos.IdJornadaLaboral;
                    //short IdCostoHoraJornada = costos.IdCostoHoraJornada;



                    /////////////////////////////////////////////////

                    //this.setConvenioLaboralTrabajador(IdTrabajador);
                    //  this.NominaTrabajador.setCostoHoraJornada(IdCostoHoraJornada);
                    this.NominaTrabajador.setIncidenciaTrabajador(IdTrabajador);

                    //   this.NominaTrabajador.DiasEfectivosLaborados = this.NominaTrabajador.ObtenDiasIncidenciasTrabajador();

                    // this.NominaTrabajador.setJornadaLaboral(IdJornadaLaboral);

                    //this.setNominaTrabajadorPercepciones(IdTrabajador);
                    this.NominaTrabajador.setParametrosCreditosTrabajador(IdTrabajador);
                    this.NominaTrabajador.setPensionesTrabajador(IdTrabajador);
                    this.NominaTrabajador.setPercepcionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                    //this.NominaTrabajador.setDeduccionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                    //this.setCatalogoKardexTrabajadorCuentas(IdTrabajador);
                    //this.setTrabajador(IdConvenioLaboralTrabajadorCategoria);
                    //this.NominaTrabajador.setBimestreAnteriorPagadasTrabajador(IdConvenioLaboralTrabajadorCategoria);
                    
                    //}
                    //catch (Exception e)
                    //{
                    //    throw new InvalidProgramException(e.Message);

                    //}

                    // this.GenerarIncidenciasPermisos(Trabajador);

                    if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                    {

                        NominaTrabajador.GenerarRetroactivo(Trabajador);
                        this.GenerarDeduccionesRetroactivo(Trabajador);
                        this.GenerarPensiones(Trabajador);


                    }
                    else
                    {
                        GenerarPermisos(Trabajador);
                        this.GenerarPercepciones(Trabajador);
                        this.NominaTrabajador.GenerarAjustesPerpceciones(Trabajador);
                        this.NominaTrabajador.GenerarAjustesSueldosCambioContrato(Trabajador);
                        this.NominaTrabajador.AjustesPorBajasSinPago(Trabajador);

                        //esta linea debe de ser procesada despues de haber calculado percepciones
                        this.NominaTrabajador.setMaternidadRiesgoTrabajoTrabajador(Trabajador);
                        this.GenerarIncapacidades(Trabajador);
                        if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                        {
                            this.GenerarDeducciones(Trabajador);

                            //ccalcula IMSS diferecnias
                            this.NominaTrabajador.GenerarAjustesPerpceciones(Trabajador, true);
                            this.GenerarPensiones(Trabajador);
                            this.GenerarCreditos(Trabajador);
                            this.NominaTrabajador.CalcularAjusteDeduccionInfonavit(Trabajador);
                        }
                    }
                    //  Console.WriteLine("--- fin --- " + DateTime.Now + " ** ");
                }
            }

            GrabarStNominaTrabajador();
        }

      

        public override void GenerarPermisos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

            Nova.Models.Calculos.Deducciones.RiesgoTrabajo incapacidad = new Nova.Models.Calculos.Deducciones.RiesgoTrabajo();
            incapacidad.Calcular(cltc, this.NominaTrabajador);

           

        }
        //public override void GenerarIncidenciasPermisos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        //{
        //    FaltasConfianza falta = new FaltasConfianza();
        //    falta.Calcular(cltc, this.NominaTrabajador);
        //}

        public override void GrabarStNominaTrabajador()
        {
            NominaTrabajador.CreditosDelTrabajador = new List<Creditos_stNominaCreditoTrabajador>();
            NominaTrabajador.CreditosDelTrabajadorNoAplicados = new List<Creditos_stNominaCreditoTrabajadorNoAplicados>();
            NominaTrabajador.PercepcionesDelTrabajador = new List<Percepciones_stNominaTrabajadorPercepciones>();
            NominaTrabajador.DeduccionesDelTrabajador = new List<Deducciones_stNominaTrabajadorDeduccion>();
            NominaTrabajador.SubDeduccionesDelTrabajador = new List<Deducciones_stNominaTrabajadorSubDeducciones>();
            NominaTrabajador.PensionesDelTrabajador = new List<Pensiones_stNominaPensionTrabajador>();

            int y = 0;

            foreach (var item in NominaTrabajador.TrabajadoresVigentes)
            {
                //if (NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => 
                //v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && v.Importe>0).ToList().Count>0)
                //    NominaTrabajador.AgregarSubsidio(item.IdConvenioLaboralTrabajadorCategoria);

                y++;

                NominaTrabajador.trabajadornomina = null;
                NominaTrabajador.trabajadornomina = new Nomina_stNominaTrabajador();
                NominaTrabajador.trabajadornomina.IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                NominaTrabajador.trabajadornomina.IdNomina = NominaTrabajador.IdNomina;
                
                NominaTrabajador.trabajadornomina.SueldoBruto = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());
                NominaTrabajador.trabajadornomina.SueldoTabular = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.Concepto.Contains("SUELDO") && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());
                NominaTrabajador.trabajadornomina.PercepcionesAdicionales = (NominaTrabajador.trabajadornomina.SueldoBruto - NominaTrabajador.trabajadornomina.SueldoTabular.Value);


                NominaTrabajador.trabajadornomina.SueldoDiario = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SUELDO DIARIO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                NominaTrabajador.trabajadornomina.TotalDeducciones = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());
                NominaTrabajador.trabajadornomina.SueldoNeto = NominaTrabajador.trabajadornomina.SueldoBruto

                        - NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(i => i.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList())
                        - NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaCreditosTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList())
                        - NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPensionesTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).ToList());

                //if (percepciones == 0)
                //    throw new ApplicationException("Esta nomina ha generado valores en 0, revise su información puede ser que la nomina para esta quincena no sea aplicable");


                //if (NominaTrabajador.trabajadornomina.SueldoNeto<0 )
                //    NominaTrabajador.trabajadornomina.SueldoNeto = percepciones - deducciones -  pensiones;

                //if (NominaTrabajador.trabajadornomina.SueldoNeto < 0 && NominaTrabajador.trabajadornomina.DiasPagados > 0)
                //    throw   new ApplicationException ("El siguiente trabajador tiene fondos insuficientes "+item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre+" "+item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno+" " +item.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno);

                
                NominaTrabajador.trabajadornomina.SueldoNeto = decimal.Round(NominaTrabajador.Truncate(NominaTrabajador.trabajadornomina.SueldoNeto, 4), 2);

                //if (NominaTrabajador.trabajadornomina.SueldoNeto < 0)
                //{
                //    NominaTrabajador.trabajadornomina.SueldoNeto = 0;
                //    NominaTrabajador.trabajadornomina.SueldoDiario = 0;
                //}

                NominaTrabajador.trabajadornomina.TotalDeducciones = NominaTrabajador.ListaDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);
                NominaTrabajador.trabajadornomina.SueldoTransferencia = 0;
                NominaTrabajador.trabajadornomina.SueldoMonedero = 0;
          //      List<Kardex_stTrabajadorCuentas> cta = NominaTrabajador.CatalogoKardexTrabajadoresCuentas.Where(w => w.IdTrabajador == item.Convenios_stConvenioLaboralTrabajador.IdTrabajador && w.EsVigente && (w.Catalogos_ctFormaDePago.FormaDePago == "TRANSFERENCIA ELECTRÓNICA" || w.Catalogos_ctFormaDePago.FormaDePago == "EFECTIVO")).ToList();
               
                NominaTrabajador.trabajadornomina.HorasSemanaMes = 0;
                NominaTrabajador.trabajadornomina.HorasSemanaMesTrabajadas = 0;
                NominaTrabajador.trabajadornomina.HorasTrabajadasExcedentes = 0;
                NominaTrabajador.trabajadornomina.HorasTrabajadasInterinas = 0;

                NominaTrabajador.DiasPagados = (short)NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "DIASLABORADOS" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                decimal faltas = NominaTrabajador.ListaVariablesNominaTrabajador.Where(F => F.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && F.Concepto == "FALTAS").Sum(e => e.Importe);
                NominaTrabajador.DiasFaltas = (short)faltas;

                NominaTrabajador.trabajadornomina.DiasPagados = NominaTrabajador.DiasPagados;
                NominaTrabajador.trabajadornomina.DiasEfectivosLaborados = NominaTrabajador.DiasPagados;

                //decimal diasefectivos=NominaTrabajador.ListaVariablesNominaTrabajador.Where(F=> F.IdConvenioLaboralTrabajadorCategoria==item.IdConvenioLaboralTrabajadorCategoria && F.Concepto=="FALTAS").Sum(e=> e.Importe);
                //if (diasefectivos==0)
                //    NominaTrabajador.trabajadornomina.DiasEfectivosLaborados = NominaTrabajador.DiasNomina ;
                //else
                //{
                    
                //    NominaTrabajador.trabajadornomina.DiasEfectivosLaborados = (short)(NominaTrabajador.DiasNomina - diasefectivos);
                //}
                


                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                if (costos != null)
                {
                    NominaTrabajador.trabajadornomina.CostoPorHora = costos.CostoPorHora;
                    
                    NominaTrabajador.trabajadornomina.HorasEfectivasDeTrabajo = (short)(NominaTrabajador.trabajadornomina.DiasEfectivosLaborados * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo);
                }
                NominaTrabajador.trabajadornomina.CostoPorHoraExcedente = 0;
                NominaTrabajador.trabajadornomina.CostoPorHorasInterinas = 0;


                



                NominaTrabajador.trabajadornomina.SalarioDiarioIntegrado = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "SALARIO DIARIO INTEGRADO" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();
                short[] quinquenios ;
                decimal QuinquenioDiario = 0;
                try
                {

                
                 quinquenios = NominaTrabajador.PlantillaNominaPercepciones.Where(s => s.Percepciones_ctPercepcion.Percepcion.Contains("QUINQUENIO")).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
                 QuinquenioDiario = Math.Round((NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && quinquenios.Contains(v.IdPlantillaNominaPercepcion)).Sum(f => f.Importe) / NominaTrabajador.DiasPagados), 2);
                }
                catch (Exception es )
                {

                    throw new Exception( es.Message);
                }
                var material = NominaTrabajador.PlantillaNominaPercepciones.Where(s => s.Percepciones_ctPercepcion.Percepcion.Contains("MATERIAL")).Select(x => x.IdPlantillaNominaPercepcion).ToArray();
                var materialDiario = Math.Round((NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && material.Contains(v.IdPlantillaNominaPercepcion)).Sum(f => f.Importe) / NominaTrabajador.DiasPagados), 2);

                NominaTrabajador.trabajadornomina.QuinquenioDiario = QuinquenioDiario;
                NominaTrabajador.trabajadornomina.MaterialDidacticoDiario = materialDiario;

                var idquinqueniopercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault();
                var idpercesueldo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains("SUELDO")).Select(z => z.IdPlantillaNominaPercepcion).ToArray();

               decimal sueldobrutosueldo=  NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && idpercesueldo.Contains(v.IdPlantillaNominaPercepcion)).ToList());

                if (idquinqueniopercepcion != null)
                    NominaTrabajador.trabajadornomina.SueldoBrutoQuinquenioDiario = sueldobrutosueldo + NominaTrabajador.ListaPercepcionesTrabajadores.Where(g => g.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && idquinqueniopercepcion.IdPlantillaNominaPercepcion == g.IdPlantillaNominaPercepcion).Sum(r => r.Importe);
                else
                    NominaTrabajador.trabajadornomina.SueldoBrutoQuinquenioDiario = sueldobrutosueldo;



                if (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                {
                    NominaTrabajador.trabajadornomina.SumaPercepcionesVariables = NominaTrabajador.trabajadornomina.SueldoBruto;
                }
                else
                {
                    NominaTrabajador.trabajadornomina.SumaPercepcionesVariables = NominaTrabajador.trabajadornomina.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria && v.EsVariable == true).ToList());
                }

                NominaTrabajador.trabajadornomina.BaseGravable = NominaTrabajador.ListaVariablesNominaTrabajador.Where(x => x.Concepto == "BASE GRAVABLE" && x.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).Select(s => s.Importe).FirstOrDefault();

                //NominaTrabajador.trabajadornomina.EsDevolucion = false;
                NominaTrabajador.trabajadornomina.SalarioBrutoGravable = NominaTrabajador.trabajadornomina.SumaPercepcionesVariables;

                if (NominaTrabajador.EsRecalculoPorTrabajador)
                {
                    NominaTrabajador.trabajadornomina.EsMedioRecibo = true;
                    NominaTrabajador.trabajadornomina.IdNominaTrabajadorEstatus = this.NominaTrabajador.IdNominaTrabajadorEstatusRecalculo;
                }

                var trabajadorFechaingreso = NominaTrabajador.QuinquenioTrabajadorAntiguedad.getAntiguedadPorTrabajador(item.Convenios_stConvenioLaboralTrabajador.IdTrabajador);

                NominaTrabajador.trabajadornomina.FechaIngreso = trabajadorFechaingreso.FechaIngreso;
                NominaTrabajador.trabajadornomina.EsAlta = item.EsPrimerCalculo;

                NominaTrabajador.Nomina_stNominaTrabajadorLista.Add(NominaTrabajador.trabajadornomina);


                ///IMSS/////
                var diasqnaimss = NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "DiasQuincenaIMSS"
                 && a.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                if (diasqnaimss != null)
                {

                    NominaTrabajador.trabajadornomina.DiasRetencion = (short)diasqnaimss.Importe;
                }


                var totalDIASIncidencias = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_DIAS_IMSS" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
         ).Sum(a => a.Importe);

                NominaTrabajador.trabajadornomina.DiasIncapacidadImss = (short)totalDIASIncidencias;


                var CesantiaVejezTrabajador = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "CesantiaVejezTrabajador" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
           ).Sum(a => a.Importe);

                NominaTrabajador.trabajadornomina.Obrero_RCV = CesantiaVejezTrabajador;

                var imss = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "deduccionimss" && v.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria
           ).Sum(a => a.Importe);

                NominaTrabajador.trabajadornomina.Obrero_IMSS = imss;
                ///IMSS/////
                ///

            }

            NominaTrabajador.GrabarNominaBaseDatos();

        }


        public override void CalcularSueldo()
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
            {

                this.NominaTrabajador.getPercepcionesRetroactivo();
            }



            foreach (var item in this.NominaTrabajador.TrabajadoresVigentes)
            {



                int IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                int IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;

                this.NominaTrabajador.setIncidenciaTrabajador(IdTrabajador);

                this.NominaTrabajador.setParametrosCreditosTrabajador(IdTrabajador);
                this.NominaTrabajador.setPensionesTrabajador(IdTrabajador);
                this.NominaTrabajador.setPercepcionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                //this.NominaTrabajador.setCostoHoraJornada(item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Plazas_ctCostoHoraJornada.IdCostoHoraJornada);
                //this.NominaTrabajador.setBimestreAnteriorPagadasTrabajador(IdConvenioLaboralTrabajadorCategoria);



                Nova.Models.Calculos.Percepciones.Sueldo sueldo = new Nova.Models.Calculos.Percepciones.Sueldo();
                sueldo.Calcular(item, this.NominaTrabajador, null);

            }



        }


        public override void CalcularAyudaDespensa()
        {
            if (this.NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
            {

                this.NominaTrabajador.getPercepcionesRetroactivo();
            }



            foreach (var item in this.NominaTrabajador.TrabajadoresVigentes)
            {



                int IdConvenioLaboralTrabajadorCategoria = item.IdConvenioLaboralTrabajadorCategoria;
                int IdTrabajador = item.Convenios_stConvenioLaboralTrabajador.IdTrabajador;

                this.NominaTrabajador.setIncidenciaTrabajador(IdConvenioLaboralTrabajadorCategoria);

                this.NominaTrabajador.setParametrosCreditosTrabajador(IdTrabajador);
                this.NominaTrabajador.setPensionesTrabajador(IdTrabajador);
                this.NominaTrabajador.setPercepcionesPersonalizadas(IdConvenioLaboralTrabajadorCategoria, this.NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.IdPeriodoNomina);
                //this.NominaTrabajador.setCostoHoraJornada(item.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Plazas_ctCostoHoraJornada.IdCostoHoraJornada);
                //this.NominaTrabajador.setBimestreAnteriorPagadasTrabajador(IdConvenioLaboralTrabajadorCategoria);



                Nova.Models.Calculos.Percepciones.AyudaDespensa Ayuda = new Nova.Models.Calculos.Percepciones.AyudaDespensa();
                Ayuda.Calcular(item, this.NominaTrabajador, null);

            }



        }
    }
}
