﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Nomina;
using Nova.Models.Calculos.Percepciones;
using System.Linq.Expressions;
using Nova.Libraries;
using System.Threading.Tasks;
using OfficeOpenXml.Style;
using OfficeOpenXml;
using System.Drawing;
using DevExpress.Web.ASPxHtmlEditor.Internal;
 

namespace Nova.Models.Calculos
{
    public interface IPercepcionBehavior
    {
        //void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador,);
        void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null);
        void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, string Percepcion = null,string concepto=null);
        void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste= false);
        
      //  void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, bool Ajuste = false);
        // void Grabar(Nomina_stNominaTrabajador NominaTrabajador);


    }
    public interface IDeduccionBehavior
    {
        void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador);
    }

    //public class SueldoDocente : IPercepcionBehavior
    //{
    //    public decimal Calcular()
    //    {
    //        Console.WriteLine("Sueldo Docente"); //Sueldo Docente
    //        Console.ReadLine();
    //        return 200;
    //    }
    //}

    //public class AyudaDespensa : IPercepcionBehavior
    //{

    //    public decimal Calcular()
    //    {
    //        Console.WriteLine("AyudaDespensa");//AyudaDespensa
    //        Console.ReadLine();
    //        return 200;
    //    }
    //}


    //public class AyudaTransporte : IPercepcionBehavior
    //{

    //    public decimal Calcular()
    //    {
    //        Console.WriteLine("Ayuda transporte solo base");//AyudaDespensa
    //        Console.ReadLine();
    //        return 200;
    //    }
    //}

    public class CargasHorariasPeriodoTiempo
    {
        public DateTime? FechaInicioPago { get; set; }
        public DateTime? FechaFinalPago { get; set; }
        public int Dias { get; set; }
        public int Horas { get; set; }
        public int HorasClub { get; set; }
        public bool Aplicado { get; set; }
        public bool empiezadespuesdelinicioqna { get; set; } = false;
        public bool terminaantesdelterminoqna { get; set; } = false;
    }

    public abstract class Nomina:NominaLogger
    {
        private IPercepcionBehavior _sueldo;
        public IPercepcionBehavior Sueldo
        {
            get { return _sueldo; }
            set { _sueldo = value; }
        }

        private IDeduccionBehavior _credito;
        public IDeduccionBehavior Credito
        {
            get { return _credito; }
            set { _credito = value; }
        }




        private IPercepcionBehavior _ayudatransporte;
        public IPercepcionBehavior AyudaTransporte
        {
            get { return _ayudatransporte; }
            set { _ayudatransporte = value; }
        }

        public virtual void GenerarPermisos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {
 

        }

        [TiempoEjecucion]
        public virtual void GenerarPercepciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

        }
        [TiempoEjecucion]
        public virtual void GenerarIncapacidades(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

        }
        [TiempoEjecucion]
        public virtual void GenerarDeducciones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

        }
        public virtual void GenerarDeduccionesRetroactivo(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

        }
        [TiempoEjecucion]
        public virtual void GenerarCreditos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

        }

        [TiempoEjecucion]
        public virtual void GenerarPensiones(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        {

        }


        //public virtual void CalcularSueldo()
        //{

        //}

        //public virtual void GenerarIncidenciasPermisos(Convenios_stConvenioLaboralTrabajadorCategoria cltc)
        //{

        //}
        public virtual void CalcularNomina()
        {

        }
        public virtual async Task CalcularNominaAsync()
        {

        }
        [TiempoEjecucion]
        public virtual void GrabarNomina()
        {

        }
        [TiempoEjecucion]
        public virtual void GrabarStNominaTrabajador()
        {

        }
        public virtual void GrabarPercepciones()
        {

        }

        public virtual void GrabarDeducciones()
        {

        }
        public virtual void GrabarPensiones()
        {

        }
        public virtual void GrabarCreditos()
        {

        }


        //public virtual void GrabarPensiones(Nomina_stNominaTrabajador trabajador)
        //{

        //}
        //public virtual void GrabarPercepciones(Nomina_stNominaTrabajador trabajador)
        //{

        //}
        //public virtual void GrabaSubdeducciones(Nomina_stNominaTrabajador trabajador, List<Deducciones_stNominaTrabajadorDeduccion> deducciones)
        //{

        //}

        //public virtual void GrabarDeducciones(Nomina_stNominaTrabajador trabajador)
        //{

        //}

        //public virtual void GrabarCreditos(Nomina_stNominaTrabajador trabajador)
        //{

        //}
        public virtual void BorrarNomina(int idn, int idconveniolaboraltrabajadorcategoria = 0)
        {

        }


        public virtual void CalcularSueldo()
        {

        }

        public virtual void CalcularEficiencia()
        {

        }

        public virtual void CalcularAyudaDespensa()
        {

        }
    }

    public class ViaticosModel
    {
        public decimal Importe { get; set; }
        public int IdTrabajador { get; set; }
        public DateTime FechaInicioPercepcion { get; set; }
        public DateTime FechaTermino { get; set; }
        public string Nombre  { get; set; }
        public string ApellidoPaterno { get; set; }
        public string ApellidoMaterno { get; set; }
        public string UbicacionFisica { get; set; }
        public string Categoria { get; set; }
        public string RelacionConvenioLaboral { get; set; }

      
        public static async Task<byte[]> ExportarViaticosPorNomina(IEnumerable<ViaticosModel> data)
        {
            // Configurar EPPlus para uso no comercial
            ExcelPackage.LicenseContext = OfficeOpenXml.LicenseContext.NonCommercial;

            using (var package = new ExcelPackage())
            {
                var worksheet = package.Workbook.Worksheets.Add("Reporte de Nómina");

                var headers = new[]
{
       "Importe"
      ,"IdTrabajador"
      ,"FechaInicioPercepcion"
      ,"FechaTermino"
      ,"Nombre"
      ,"ApellidoPaterno"
      ,"ApellidoMaterno"
      ,"UbicacionFisica"
      ,"Categoria"
      ,"RelacionConvenioLaboral"



};

                // Aplicar encabezados
                for (int i = 0; i < headers.Length; i++)
                {
                    worksheet.Cells[1, i + 1].Value = headers[i];
                }

                // Estilo para encabezados
                using (var range = worksheet.Cells[1, 1, 1, headers.Length])
                {
                    range.Style.Font.Bold = true;
                    range.Style.Fill.PatternType = ExcelFillStyle.Solid;
                    range.Style.Fill.BackgroundColor.SetColor(Color.LightGray);
                    range.Style.Font.Color.SetColor(Color.Black);
                }

                // Llenar datos
                var row = 2;
                foreach (var item in data)
                {
                    int col = 1;
                    worksheet.Cells[row, col++].Value = item.Importe;
                    worksheet.Cells[row, col++].Value = item.IdTrabajador;
                    worksheet.Cells[row, col++].Value = item.FechaInicioPercepcion;
                    worksheet.Cells[row, col++].Value = item.FechaTermino;
                    worksheet.Cells[row, col++].Value = item.Nombre;
                    worksheet.Cells[row, col++].Value = item.ApellidoPaterno;
                    worksheet.Cells[row, col++].Value = item.ApellidoMaterno;
                    worksheet.Cells[row, col++].Value = item.UbicacionFisica;
                    worksheet.Cells[row, col++].Value = item.Categoria;
                    worksheet.Cells[row, col++].Value = item.RelacionConvenioLaboral;
                    





                    row++;
                }



                // Formato para fechas
                var dateFormat = "dd/MM/yyyy";
                worksheet.Column(3).Style.Numberformat.Format = dateFormat; // Fecha Inicio
                worksheet.Column(4).Style.Numberformat.Format = dateFormat; // Fecha Término

                // Autoajustar columnas
                worksheet.Cells.AutoFitColumns();

                return await package.GetAsByteArrayAsync();
            }
        }


    }

    public class ReporteDiasEconomicosyPuntualidad : Nomina_PagosDiasEconomicosyPuntualidad
    {
        public string Tipo { get; set; }
        public string NombreCompleto { get; set; }
        public string UbicacionFisica { get; set; }
        public string Categoria { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public string Lugar { get; set; }
        public string EstructuraOrganica { get; set; }
        public string QuincenaMes { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public int AñoNomina { get; set; }
        public string TipoPagoRegistro { get; set; }

        
 

        public static async Task<byte[]> ExportarDiasEconomicosPuntualidadAExcel(IEnumerable<ReporteDiasEconomicosyPuntualidad> data)
        {
            // Configurar EPPlus para uso no comercial
            ExcelPackage.LicenseContext = OfficeOpenXml.LicenseContext.NonCommercial;

            using (var package = new ExcelPackage())
            {
                var worksheet = package.Workbook.Worksheets.Add("Reporte de Nómina");

                var headers = new[]
{
       "TipoPagoRegistro"
      ,"IdPagosDiasEconomicosyPuntualidad"
      ,"IdTrabajador"
      ,"TotalDias"
      ,"NombreCompleto"
      ,"Año"
             ,"AñoNomina"
      ,"UbicacionFisica"
      ,"Categoria"
      ,"RelacionConvenioLaboral"
      ,"EstructuraOrganica"
      ,"QuincenaMes"
      ,"FechaInicio"
      ,"FechaTermino"

  

};

                // Aplicar encabezados
                for (int i = 0; i < headers.Length; i++)
                {
                    worksheet.Cells[1, i + 1].Value = headers[i];
                }

                // Estilo para encabezados
                using (var range = worksheet.Cells[1, 1, 1, headers.Length])
                {
                    range.Style.Font.Bold = true;
                    range.Style.Fill.PatternType = ExcelFillStyle.Solid;
                    range.Style.Fill.BackgroundColor.SetColor(Color.LightGray);
                    range.Style.Font.Color.SetColor(Color.Black);
                }

                // Llenar datos
                var row = 2;
                foreach (var item in data)
                {
                    int col = 1;
                    worksheet.Cells[row, col++].Value = item.TipoPagoRegistro;
                    worksheet.Cells[row, col++].Value = item.IdPagosDiasEconomicosyPuntualidad;
                    worksheet.Cells[row, col++].Value = item.IdTrabajador;
                    worksheet.Cells[row, col++].Value = Math.Abs(item.TotalDias);
                    worksheet.Cells[row, col++].Value = item.NombreCompleto;
                
     
                    worksheet.Cells[row, col++].Value = item.Año;
                    worksheet.Cells[row, col++].Value = item.AñoNomina;
                    worksheet.Cells[row, col++].Value = item.UbicacionFisica;
                    worksheet.Cells[row, col++].Value = item.Categoria;
                    worksheet.Cells[row, col++].Value = item.RelacionConvenioLaboral;
                    worksheet.Cells[row, col++].Value = item.EstructuraOrganica;
                    worksheet.Cells[row, col++].Value = item.QuincenaMes;
                    worksheet.Cells[row, col].Style.Numberformat.Format = "dd/mm/yyyy";
                    worksheet.Cells[row, col++].Value = item.FechaInicio;
                    worksheet.Cells[row, col].Style.Numberformat.Format = "dd/mm/yyyy";
                    worksheet.Cells[row, col++].Value = item.FechaTermino;
                    
 
 


                    row++;
                }

             

                // Formato para fechas
                var dateFormat = "dd/MM/yyyy";
                worksheet.Column(13).Style.Numberformat.Format = dateFormat; // Fecha Inicio
                worksheet.Column(14).Style.Numberformat.Format = dateFormat; // Fecha Término

                // Autoajustar columnas
                worksheet.Cells.AutoFitColumns();

                return await package.GetAsByteArrayAsync();
            }
        }

    }



    public class CalculosNomina
    {
        //private Nomina _tiponomina;
        public CalculosNomina(Nomina_stNominaTrabajador ntr)
        {

            switch (ntr.Nomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral)
            {
                case "ADMINISTRATIVO-CONFIANZA":
                    {

                        //if (ntr.Nomina.Nomina_ctTipoNomina.TipoNomina == "RETROACTIVO")
                        //{
                        //    var nomina = new NominaConfianzaRetroactivo(ntr);
                        //    nomina.CalcularNomina();
                        //}
                        //else
                        //{
                            //Console.WriteLine("SINGLETON" + DateTime.Now + " ** ");
                            var nomina = new NominaConfianza(ntr);
                            //Console.WriteLine("FIN SINGELTON" + DateTime.Now + " ** ");
                            nomina.CalcularNomina();
                        //}

                        break;
                    }
                case "ADMINISTRATIVO-BASE":
                    {
                        //if (ntr.Nomina.Nomina_ctTipoNomina.TipoNomina == "RETROACTIVO")
                        //{
                        //    var nomina = new NominaBaseRetroactivo(ntr);
                        //    nomina.CalcularNomina();
                        //}
                        //else
                        //{
                            //Console.WriteLine("SINGLETON" + DateTime.Now + " ** ");
                            var nomina = new NominaBase(ntr);
                            //Console.WriteLine("FIN SINGELTON" + DateTime.Now + " ** ");


                            //nomina.CalcularNominaAsync();
                            nomina.CalcularNomina();

                        //}
                        break;
                    }
                case "ADMINISTRATIVO DEFINITIVO-BASE":
                    {
                        //if (ntr.Nomina.Nomina_ctTipoNomina.TipoNomina == "RETROACTIVO")
                        //{
                        //    var nomina = new NominaBaseRetroactivo(ntr);
                        //    nomina.CalcularNomina();
                        //}
                        //else
                        //{
                        //Console.WriteLine("SINGLETON" + DateTime.Now + " ** ");
                        var nomina = new NominaBaseDefinitivo(ntr);
                        //Console.WriteLine("FIN SINGELTON" + DateTime.Now + " ** ");


                        nomina.CalcularNomina();

                        //}
                        break;
                    }
                case "DOCENTE-CONTRATO":
                    {

                        //if (ntr.Nomina.Nomina_ctTipoNomina.TipoNomina == "RETROACTIVO")
                        //{
                        //    var nomina = new NominaDocenteInterinoRetroactivo(ntr);
                        //    nomina.CalcularNomina();
                        //}
                        //else
                        //{
                            var nomina = new NominaDocenteInterino(ntr);
                            nomina.CalcularNomina();
                        //}

                        break;
                    }
                case "DOCENTE-BASE":
                    {

                        //if (ntr.Nomina.Nomina_ctTipoNomina.TipoNomina == "RETROACTIVO")
                        //{
                        //    var nomina = new NominaDocenteBaseRetroactivo(ntr);
                        //    nomina.CalcularNomina();
                        //}
                        //else
                        //{
                            var nomina = new NominaDocenteBase(ntr);
                            nomina.CalcularNomina();
                        //}

                        break;
                    }

                   
                        case "DOCENTE-DEFINITIVO SPD":
                    {

                         
                        var nomina = new NominaDocenteDefinitivo(ntr);
                        nomina.CalcularNomina();
                        

                        break;
                    }

                case "MANDO MEDIO-SUPERIOR":
                    {


                        var nomina = new NominaMandosMedios(ntr);
                        nomina.CalcularNomina();


                        break;
                    }
                case "ADMINISTRATIVO-CONTRATO":
                    {


                        var nomina = new NominaInterinoAdministrativa(ntr);
                        nomina.CalcularNomina();


                        break;
                    }
                default:
                    break;
            }
        }

        

    }
    public class PersonalNomina
    {
        public long IdNominaTrabajador { get; set; }
    }
    public class SubDeduccionesNominaTrabajador
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public int IdNomina { get; set; }
        public long IdNominaTrabajadorDeduccion { get; set; }
        public short IdSubDeduccion { get; set; }
        public int IdPlantillaNominaDeduccion { get; set; }
        public decimal Importe { get; set; }

    }



    public class TrabajadorNominaParaAguinaldo
    {
        public int IdTrabajador { get; set; }
        public string NombreTrabajador { get; set; }
        public decimal SueldoDiario { get; set; }
        public decimal SalarioDiarioIntegrado { get; set; }
        public int DiasEfectivosLaborados { get; set; }
        public int TipoConcepto { get; set; }
        public string Tipo { get; set; }
        public string Concepto { get; set; }
        public decimal Importe { get; set; }
        public string RFC { get; set; }
        public string Adscripcion { get; set; }
        public string UbicacionFisica { get; set; }
        public string Codigo { get; set; }
        public string Categoria { get; set; }
        public string ConvenioLaboralTipo { get; set; }
        public string RelacionLaboral { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public string Plantilla { get; set; }
        public string PlantillaGrupo { get; set; }
        public int Año { get; set; }
        public string QuincenaMes { get; set; }
        public string Mes { get; set; }
        public decimal SueldoNeto { get; set; }
        public bool EsAjuste { get; set; }
        public int HorasSemanaMes { get; set; }
        public int HorasExcedentes { get; set; }
        public decimal SueldoBruto { get; set; }
        public decimal TotalDeducciones { get; set; }
        public string RelacionConvenioLaboral { get; set; }

    }

    public class ResumenNominaQuincenal
    {
        public int IdTrabajador { get; set; }
        public string NombreTrabajador { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public int DiasTrabajados { get; set; }
        public decimal SueldoDiario { get; set; }
        public string RFC { get; set; }
    }

    public class AguinaldoTrabajadores
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public decimal SueldoBrutoQuinquenioDiario { get; set; }
        public decimal SueldoBrutoQuinquenioDiarioDocente { get; set; }
        
        public short DiasEfectivosLaborados { get; set; }
        public short DiasCalendarioLaborados { get; set; }
        public int IdTrabajador { get; set; }
        public int IdPlantillaNominaDeduccion { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public short DiasFaltas { get; set; }
        public short HorasFaltas { get; set; }
        
    }

    public class DeduccionesRetroActivoTrabajador
    {
         
        public int TotalQuincenas { get; set; }
        public int IdTrabajador { get; set; }
        public string Deduccion { get; set; }
        public decimal Importe { get; set; }
        public int IdPlantillaNominaDeduccion { get; set; }
        public string Concepto { get; set; }
        public short IdQuincenaMes { get; set; }
    }
        public class PercepcionesRetroActivoTrabajador
    {

        public int IdTrabajador { get; set; }
        
  public decimal Importe { get; set; }
 public string Percepcion { get; set; }
  public decimal BaseGravable { get; set; }
  public decimal SalarioDiarioIntegrado { get; set; }
 public short IdQuincenaMes { get; set; }
 public short DiasEfectivosLaborados { get; set; }
   public decimal ImporteRetroActivo { get; set; }
   public decimal PorcentajeRetroActivo { get; set; }
        public bool EsGravable { get; set; }
        public bool EsVariable { get; set; }
        public bool EsPrevisionSocial { get; set; }
         public short  IdMes { get; set; }
         public string QuincenaMes { get; set; }

         public short TotalQuincenas  { get; set; }
         public decimal ImporteRetroActivoC { get; set; }
         public decimal PorcentajeRetroActivoC { get; set; }
    }

    public class AntiguedadTrabajador
    {
        
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public string Años { get; set; }
        public string Meses{ get; set; }
        public string Dias{ get; set; }
         

    }

    public class PartesProporcionalesTrabajador
    {

        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public decimal SueldoSalario { get; set; }
        public int DiasEfectivosLaborados { get; set; }
        public int IdRelacionConvenioLaboral { get; set; }

        public int DiasAguinaldo { get; set; }
        public int DiasPrimaVacacional { get; set; }

        public decimal Aguinaldo { get; set; }
        public decimal PrimaVacacional { get; set; }


    }
    public class SdiImportesVariables
    {
        public int IdTrabajador { get; set; }
        public decimal Importe { get; set; }
        public string Percepcion { get; set; }

    }

    public class HorasDocentesPorCiclo
    {
        
            public int IdCicloEscolar { get; set; }
            public int IdKardex { get; set; }
            public int Horas { get; set; }
    }
   
    public class NominasAnterioresPagadas
    {
        public int IdTrabajador { get; set; }
        public long IdNominaTrabajador { get; set; }
        public long IdConvenioLaboralTrabajadorCategoria { get; set; }
        public string NombreTrabajador { get; set; }
        public decimal SueldoDiario { get; set; }
        public decimal SalarioDiarioIntegrado { get; set; }
        public short DiasEfectivosLaborados { get; set; }
        public int TipoConcepto { get; set; }
        public decimal Importe { get; set; }
        public string RFC { get; set; }
        public string Adscripcion { get; set; }
        public string UbicacionFisica { get; set; }
        public string Codigo { get; set; }
        public string ConvenioLaboralTipo { get; set; }
        public string RelacionLaboral { get; set; }
        public DateTime FechaInicioNomina { get; set; }
        public DateTime FechaTerminoNomina { get; set; } 
        public DateTime FechaInicio { get; set; }
        public DateTime? FechaTermino { get; set; }
        public int IdCategoria { get; set; }
        public string Plantilla { get; set; }
        public string PlantillaGrupo { get; set; }
        public short Año { get; set; }
        public string QuincenaMes { get; set; }
        public string Mes { get; set; }
        public decimal SueldoNeto { get; set; }
        public int EsAjuste { get; set; }
        public short HorasSemanaMes { get; set; }
        public short HorasExcedentes { get; set; }
        public short IdQuincenaMes { get; set; }
        public short IdPlantillaNominaPercepcion { get; set; }
    }
    public class Percepciones_stNominaTrabajadorPercepcionesRDLBimestre : Percepciones_stNominaTrabajadorPercepciones
    {
        public int IdTrabajador { get; set; }
    }

    public class CreditosAjustesFactor
    {
        
        public decimal Importe { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }

        public Decimal? CuotaFija { get; set; }
        public Decimal? VecesSalarioMinimo { get; set; }
        public Decimal? Porcentaje { get; set; }
       

    }
    public class SalariosDiarioDocentesParaPrima
    {
        public int IdTrabajador { get; set; }
        public decimal Importe { get; set; }
        public decimal ImporteSinMatQuin { get; set; }
        public decimal ImporteSueldoTotal { get; set; }
    }

    public class AjustesSueldoTrabajador
    {

        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public int  HorasExcedentes { get; set; }
        public decimal  ImporteHorasExcedentes { get; set; }
        public int HorasInterinas  { get; set; }
        public decimal ImporteHorasInterinas { get; set; }
        public int DiasApagarExcedentes { get; set; }
        public int DiasApagarInterinas { get; set; }


    }

    public class AjustesDiasCalendarioTrabajador
    {

        public int IdTrabajador { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }

        public Decimal SueldoDiario { get; set; }


    }

        public class ComisionesTrabajadores
        {
            public int IdTrabajador { get; set; }
            public int IdConvenioLaboralTrabajadorCategoria { get; set; }
            public string Incidencia { get; set; }
       
            public Nullable<DateTime> FechaInicio { get; set; }
            public Nullable<DateTime> FechaTerminoIncidencia { get; set; }
            public decimal ImporteHorasInterinas { get; set; }
            public string RelacionLaboral { get; set; }
            public string ConvenioLaboral { get; set; }


        }

    public class EnfermedadControl
    {
        public long IdIncidenciaTrabajadorCalculo  { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public long IdIncidenciaTrabajador { get; set; }
        public string QuincenaMes { get; set; }
        public int DiasPagados40 { get; set; }
        
    }

    public class ComparativoHoras
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        
        public int HorasSemanaMesAntes { get; set; }
        public int HorasSemanaMes  { get; set; }
        public int HorasExcedentesAntes { get; set; }
        public int HorasExcedentes { get; set; }
    }

    public class DiasTrabajadosInfo
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public decimal Importe { get; set; }
    }

    
        public class IncidenciaComision : IncidenciaPermiso_stIncidenciaTrabajador
    {
        public int IdTrabajador { get; set; }
        public int IdCategoria { get; set; }
        public int IdRelacionConvenioLaboral { get; set; }
    }

        public class ContratoSegunNomina:Convenios_stConvenioLaboralTrabajadorCategoria
    {
 
        public int IdTrabajador { get; set; }
        public int IdCategoria { get; set; }
        public int IdRelacionConvenioLaboral { get; set; }
        public string RelacionConvenioLaboral { get; set; }
        public string Categoria { get; set; }
        public int DiasPagados { get; set; }
 
        public DateTime? FechaRenuncia { get; set; }

         
    }

    public class Licencia
    {
        public int IdTrabajador { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaFin { get; set; }
    }

    public class ResultadoMetodoDiasDePago
    {
        public int IdTrabajador { get; set; }
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
        public bool SePaga { get; set; }
        public int DiasPagados { get; set; }
        public int IdRelacionConvenioLaboral { get; set; }
        public string Categoria { get; set; }
    }
}

