﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Deducciones
{

    public class Pension : IDeduccionBehavior
    {
        public bool ValidarDuplicado(List<PensionesTrabajador> listaPensiones, int idPensionTrabajador, string concepto)
        {
            return listaPensiones.Any(p => p.IdPensionTrabajador == idPensionTrabajador && p.Concepto == concepto);
        }

        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.AplicaCalculoPension)
                {
                    int Idcltc = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;

                    var diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;


                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();


                    var t = NominaTrabajador.PensionesTrabajadores.Where(f => f.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                    bool EsnominaSueldo = false;
                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO"))
                        EsnominaSueldo = true;


                    decimal importepension = 0;
                    short iddeduccionisr = 0;

                    var deduccionisr = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault();
                    if (deduccionisr != null)
                        iddeduccionisr = deduccionisr.IdPlantillaNominaDeduccion;

                    // var iddeduccionsubsidio = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().IdPlantillaNominaDeduccion;

                    decimal valesquincenal = 0;
                    decimal ayudaqnal = 0;
                    decimal Remanentevalesayuda = 0;
                    decimal RemanentevalesayudaOriginal = 0;
                    Percepciones_stPlantillaNominaPercepciones ayudaper = new Percepciones_stPlantillaNominaPercepciones();
                    Percepciones_stPlantillaNominaPercepciones valesper = new Percepciones_stPlantillaNominaPercepciones();

                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO")
                        && !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
                    {
                        EsnominaSueldo = true;
                        if (NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA" && x.Calcular == true).FirstOrDefault() != null)
                        {
                            valesper = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x =>
                        x.Nomina_ctPlantillaNomina.Plantilla.Contains("VALES DE DESPENSA") && x.Percepciones_ctPercepcion.Percepcion == "VALES DE DESPENSA" && x.Calcular == true).FirstOrDefault();

                            valesquincenal = (decimal)((costos.CostoValesDespensa * 7) * diaslaborados);
                        }


                        var existeayudabd = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => !x.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA").FirstOrDefault();

                        Boolean esnominaayudaconacceso = false;

                        //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AYUDA PARA DESPENSA"))
                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("CONFIANZA"))
                        {
                            if (AyudaDespensaExcepciones.Calcular(ConvenioLaboralTrabajadorCategoria))
                                esnominaayudaconacceso = true;
                        }
                        else
                        {
                            if (NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" && x.Calcular == true).FirstOrDefault() != null)
                                esnominaayudaconacceso = true;
                        }

                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
                        if (existeayudabd != null)
                            if (esnominaayudaconacceso)
                            {
                                ayudaper = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Nomina_ctPlantillaNomina.Plantilla.Contains("AYUDA PARA DESPENSA")
                                && x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA DESPENSA" && x.Calcular == true).FirstOrDefault();
                                ayudaqnal = (decimal)((costos.CostoAyudaDespensa * 7) * diaslaborados);
                            }

                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                        {
                            //if (ayudaper.PorcentajeRetroActivo == null)
                            //{
                            //    new Exception($"Debe de establecer un valor para el retroactivo para la percepcion AYUDA PARA DESPENSA, en su defecto ponerlo en 0");
                            //}
                            //else
                            // if (valesper.PorcentajeRetroActivo == null)
                            //{
                            //    new Exception($"Debe de establecer un valor para el retroactivo para la percepcion VALES DE DESPENSA, en su defecto ponerlo en 0");
                            //}
                            //else
                            //{
                            //    valesquincenal = (decimal)(valesquincenal * ayudaper.PorcentajeRetroActivo);
                            //    ayudaqnal = (decimal)(ayudaqnal * valesper.PorcentajeRetroActivo);
                            //}
                            if (ayudaper != null)
                            {
                                if (ayudaper.PorcentajeRetroActivo != null)
                                    ayudaqnal = (decimal)(ayudaqnal * ayudaper.PorcentajeRetroActivo);
                            }

                            if (valesper != null)
                            {
                                if (valesper.PorcentajeRetroActivo != null)
                                    valesquincenal = (decimal)(valesquincenal * valesper.PorcentajeRetroActivo);
                            }
                        }

                        Remanentevalesayuda = (valesquincenal + ayudaqnal);
                        RemanentevalesayudaOriginal = Remanentevalesayuda;
                    }

                    DeduccionesNominaTrabajador ISR = NominaTrabajador.ListaDeduccionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == Idcltc && z.IdPlantillaNominaDeduccion == iddeduccionisr).FirstOrDefault();

                    short iddeduccionsubsidio = 0;
                    var deduccionsubsidio = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault();

                    if (deduccionsubsidio != null)
                        iddeduccionsubsidio = deduccionsubsidio.IdPlantillaNominaPercepcion;
                    //  DeduccionesNominaTrabajador ISR = NominaTrabajador.ListaDeduccionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && z.IdPlantillaNominaDeduccion == iddeduccionisr).FirstOrDefault();

                    if (ISR == null)
                    //    ISR = NominaTrabajador.ListaDeduccionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && z.IdPlantillaNominaDeduccion == iddeduccionsubsidio).FirstOrDefault();
                    {
                        var subsidio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && z.IdPlantillaNominaPercepcion == iddeduccionsubsidio).FirstOrDefault();
                        DeduccionesNominaTrabajador isrtempo = new DeduccionesNominaTrabajador();
                        if (subsidio != null)
                        {
                            isrtempo.Importe = subsidio.Importe;
                            ISR = isrtempo;
                        }
                    }

                    //if (ISR == null)
                    //    ISR = NominaTrabajador.ListaDeduccionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == Idcltc && z.IdPlantillaNominaDeduccion == iddeduccionsubsidio).FirstOrDefault();

                    DeduccionesNominaTrabajador IMSS = null;
                    if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault() != null)
                        IMSS = NominaTrabajador.ListaDeduccionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == Idcltc && z.IdPlantillaNominaDeduccion == NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault().IdPlantillaNominaDeduccion).FirstOrDefault();

                    var difregistro = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "DIFERENCIA").FirstOrDefault();
                    int iddif = 0;
                    if (difregistro != null)
                        iddif = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "DIFERENCIA").FirstOrDefault().IdPlantillaNominaDeduccion;

                    decimal diferenciasImss = NominaTrabajador.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(z =>
                    z.IdPlantillaNominaDeduccion == iddif && z.Concepto == "IMSS" &&
                    z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList());


                    Decimal canasta = 0;
                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PRIMA VACACIONAL")
                        && NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes == "24")
                    {
                        var existecanasta= NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Nomina_ctPlantillaNomina.Plantilla.Contains("CANASTA NAVIDEÑA")
                            ).FirstOrDefault();
                        if (existecanasta != null)
                        {
                            canasta = (Decimal)existecanasta.Importe;
                        }

                        
                        
                    }

                    var deducaDescontar = NominaTrabajador.PlantillaNominaDeduccionesRelacionLaboral.Where(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS"
                          || x.Deducciones_ctDeduccion.Deduccion == "ISR" || x.Deducciones_ctDeduccion.Deduccion == "RIESGO DE TRABAJO"
                          || x.Deducciones_ctDeduccion.Deduccion == "MATERNIDAD"
                           || x.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO"
                          || x.Deducciones_ctDeduccion.Deduccion == "ENFERMEDAD GENERAL"
                          || x.Deducciones_ctDeduccion.Deduccion.Contains("FALTA") ).Select(q => q.IdPlantillaNominaDeduccion).ToArray();

                    decimal remanente = 0;

                    var deducciones = NominaTrabajador.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(z =>
                    z.IdConvenioLaboralTrabajadorCategoria == Idcltc
                    && deducaDescontar.Contains(z.IdPlantillaNominaDeduccion)).ToList());

                    decimal descuentinfonavit = 0M;
                    // aeste id no se le descuenta el infonavit para su pension
                    if (ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == 1142)
                    {
                        var idcreditoinfonavit = NominaTrabajador.CreditosTrabajador.Where(a => a.Catalogos_ctTipoCredito.TipoCredito == "INFONAVIT").Select(a => a.IdCreditoTrabajador).ToArray();

                        if (idcreditoinfonavit.Count() > 0)
                            descuentinfonavit = NominaTrabajador.Suma(NominaTrabajador.ListaCreditosTrabajador.Where(s => idcreditoinfonavit.Contains(s.IdCreditoTrabajador)).ToList());

                    }

                    remanente =( canasta +NominaTrabajador.Suma(NominaTrabajador.ListaPercepcionesTrabajadores
                        .Where(z => z.IdConvenioLaboralTrabajadorCategoria == Idcltc).ToList())) - (deducciones + descuentinfonavit + diferenciasImss);

                    //busca si hay algun remanetne de pension qeu se haya creado
                    //por una sancion sindical, como deduccion personalizada
                    var existeremanente = NominaTrabajador.ListaVariablesNominaTrabajador.Where(q =>
                                    q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                    && q.Concepto == "SUELDO REMANENTE PENSION"
                                   ).FirstOrDefault();
                    if (existeremanente != null)
                    {
                        remanente = existeremanente.Importe;
                    }

                    var remanenteOriginal = remanente;



                    var enfermedad = NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.IdConvenioLaboralTrabajadorCategoria == Idcltc &&
                    a.Concepto == "ENFERMEDADGENERAL_TERMINO").FirstOrDefault();

                    if (enfermedad != null)
                        remanente = remanente - enfermedad.Importe;
                    //    if (ISR != null)
                    //{
                    //        if (IMSS != null)
                    //        {


                    //                remanente = NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == Idcltc).Sum(x => x.Importe) - deducciones;
                    //            //remanente = NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == Idcltc).Sum(x => x.Importe) - ISR.Importe - IMSS.Importe;
                    //        }
                    //        else
                    //        {
                    //            remanente = NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == Idcltc).Sum(x => x.Importe) - deducciones;
                    //            //remanente = NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == Idcltc).Sum(x => x.Importe) - ISR.Importe;
                    //        }
                    //}


                    decimal pensionValesAyuda = 0;

                    //caso cct si no hay percepciones no se calcula
                    if (t != null)
                    {

                        ////
                        int numeropension = 0;
                        decimal pensionsueldo = 0;
                        foreach (var item in NominaTrabajador.PensionesTrabajador.Where(s =>
                        s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).OrderByDescending(o => o.CalcularPercepcionesal100).ThenBy(o => o.FechaInicio))
                        {
                            importepension = 0;
                            bool calcular = true;
                            var pensionactual = NominaTrabajador.PensionesTrabajadores.Where(f =>
                            f.IdPensionTrabajador == item.IdPensionTrabajador
                            && f.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                            if (pensionactual.AplicaSoloSueldo)
                                if (EsnominaSueldo == false)
                                    calcular = false;

                            if (calcular)
                            {

                                numeropension++;
                                PensionesTrabajador pt = new PensionesTrabajador();
                                pt.IdPensionTrabajador = item.IdPensionTrabajador;


                                //if (item.FechaTermino <= NominaTrabajador.Nomina_stNomina.FechaTermino || item.FechaTermino== null)
                                //{
                                decimal cuotafija = 0;

                                if (item.CuotaFija != null)
                                    if (item.CuotaFija > 0)
                                    {
                                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                                        {
                                            cuotafija = 0;
                                        }
                                        else
                                            cuotafija = (decimal)item.CuotaFija;
                                    }


                                if (cuotafija > 0
                                && (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO") &&
                                !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT")))
                                {
                                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                                    {
                                        importepension = 0;
                                    }
                                    else
                                    {
                                        importepension = (decimal)(item.CuotaFija);
                                    }
                                    //NominaTrabajador.trabajadornomina.SueldoNeto = NominaTrabajador.trabajadornomina.SueldoNeto - totalpensiones;


                                }
                                else
                                    if (item.Porcentaje != null)
                                {
                                    if (ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == 807
                                        || item.CalcularPercepcionesal100)
                                        pensionsueldo = (decimal)(remanenteOriginal * item.Porcentaje);
                                    else
                                        pensionsueldo = (decimal)(remanente * item.Porcentaje);

                                    decimal valesayuda = 0;

                                    if (ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == 807 || item.CalcularPercepcionesal100)
                                        valesayuda = (decimal)(RemanentevalesayudaOriginal * item.Porcentaje);
                                    else
                                        valesayuda = (decimal)(Remanentevalesayuda * item.Porcentaje);

                                    pensionValesAyuda = pensionValesAyuda + valesayuda;

                                    importepension = pensionsueldo + (decimal)valesayuda;

                                    Remanentevalesayuda = Remanentevalesayuda - valesayuda;

                                    //totalpensiones = totalpensiones + (decimal)item.Porcentaje * NominaTrabajador.ListaPercepcionesTrabajadores.Where(z=>z.IdPlantillaNominaPercepcion == NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().IdPlantillaNominaPercepcion).FirstOrDefault().Importe; //actualizar sueldo neto
                                    //totalpensiones = (decimal)item.Porcentaje;
                                    //NominaTrabajador.trabajadornomina.SueldoNeto = NominaTrabajador.trabajadornomina.SueldoNeto - totalpensiones;
                                }
                                //}NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().IdPlantillaNominaPercepcion).FirstOrDefault().Importe
                                decimal diasremanentes = 0;
                                decimal PensionDiferencia = 0;
                                if (item.EsAplicado == false)
                                {
                                    diasremanentes = (decimal)(NominaTrabajador.Nomina.FechaInicio - (DateTime)item.FechaInicio).TotalDays;
                                    PensionDiferencia = ((importepension / NominaTrabajador.DiasNomina) * diasremanentes);
                                    if (PensionDiferencia > 0)
                                    {
                                        PensionesTrabajador pensionDiferencia = new PensionesTrabajador();
                                        pensionDiferencia.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        pensionDiferencia.IdPensionTrabajador = item.IdPensionTrabajador;
                                        pensionDiferencia.Importe = PensionDiferencia;
                                        pensionDiferencia.Concepto = "AJUSTE";
                                        NominaTrabajador.ListaPensionesTrabajador.Add(pensionDiferencia);
                                    }

                                    remanente = remanente - PensionDiferencia;
                                }

                                pt.Importe = importepension;
                                pt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                if (importepension > 0)
                                {
                                    if (!ValidarDuplicado(NominaTrabajador.ListaPensionesTrabajador, pt.IdPensionTrabajador, pt.Concepto))
                                    {
                                        NominaTrabajador.ListaPensionesTrabajador.Add(pt);
                                    }
                    
                                }

                                remanente = remanente - pensionsueldo;

                            }
                        }



                    }

                    var cuota = NominaTrabajador.PlantillaNominaDeduccionesRelacionLaboral.Where(x =>
                   x.Deducciones_ctDeduccion.Deduccion == "CUOTA SINDICAL"
                     ).Select(q => q.IdPlantillaNominaDeduccion).ToArray();

                    var deduccionescuota = NominaTrabajador.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(z =>
                       z.IdConvenioLaboralTrabajadorCategoria == Idcltc
                       && cuota.Contains(z.IdPlantillaNominaDeduccion)).ToList());

                    remanente = remanente - deduccionescuota;
                    remanente = remanente - pensionValesAyuda;

                    if (existeremanente == null)
                    {
                        VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();
                        vnt4.Concepto = "SUELDO REMANENTE PENSION";
                        vnt4.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt4.Importe = remanente;
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt4);
                    }
                    else
                    {

                        NominaTrabajador.ListaVariablesNominaTrabajador.Remove(existeremanente);
                        VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();
                        vnt4.Concepto = "SUELDO REMANENTE PENSION";
                        vnt4.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt4.Importe = remanente;
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt4);
                    }

                }




        }
    }
    //}
}