﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Libraries;
using Dapper;

namespace Nova.Models.Calculos.Deducciones
{

    public class ISRIndemnizaciones : IDeduccionBehavior
    {
        private Deducciones_stNominaTrabajadorDeduccion getBaseGravableQuincenaAnterior(int IdConvenioLaboralTrabajadorCategoria, int QuincenaMes, int Año)
        {
            Deducciones_stNominaTrabajadorDeduccion result = new Deducciones_stNominaTrabajadorDeduccion();

            DapperQuery dapp = new DapperQuery("bdNovaEntities");





            string query = @"select a.IdNominaTrabajadorDeduccion,a.IdPlantillaNominaDeduccion,a.Importe,a.EsImprimibleRecibo,a.IdNominaTrabajador
                                 from Deducciones_stNominaTrabajadorDeduccion a
                                inner join Nomina_stNominaTrabajador z on a.IdNominaTrabajador=z.IdNominaTrabajador
                                inner join Nomina_stNomina m on m.IdNomina=z.IdNomina
                                inner join Deducciones_stPlantillaNominaDeducciones b on a.IdPlantillaNominaDeduccion=b.IdPlantillaNominaDeduccion
                                inner join Deducciones_ctDeduccion c on c.IdDeduccion=b.IdDeduccion
                                inner join Catalogos_ctQuincenaMes e on e.IdQuincenaMes=m.IdQuincenaMes
                                 inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=z.IdNominaTrabajadorEstatus
									where xx.EstatusNomina<>'CANCELADO' AND z.IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + @" and c.Deduccion='ISR' 
                               and m.Año=" + Año.ToString() + " and e.QuincenaMes=" + QuincenaMes + " order by a.IdNominaTrabajadorDeduccion desc";

            result = (Deducciones_stNominaTrabajadorDeduccion)dapp.connection.Query<Deducciones_stNominaTrabajadorDeduccion>(query, null, null, true, 0, null).FirstOrDefault();

            dapp.Close();


            return result;
        }

        private decimal getUltimoSueldoDiario(Convenios_stConvenioLaboralTrabajadorCategoria ctl)
        {
            decimal sueldoDiario = 0M;
            string sql = @"select top 1 b.* from Nomina_stNomina a inner
                                                              join Nomina_stNominaTrabajador b on a.idnomina = b.IdNomina
                                                                inner join Nomina_ctPlantillaNomina c on c.IdPlantillaNomina=a.IdPlantillaNomina
                                                                inner join Nomina_ctPlantillaGrupo d on c.IdPlantillaGrupo=d.IdPlantillaGrupo
                                                                where   b.IdConvenioLaboralTrabajadorCategoria = 6171
                                                                and d.PlantillaGrupo like '%SUELDO%'
                                                                
                                                                ORDER BY FechaInicio DESC";
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            List<Nomina_stNominaTrabajador> sueldo = (List<Nomina_stNominaTrabajador>)dp.connection.Query<Nomina_stNominaTrabajador>(sql.ToString());

            dp.Close();

            if (sueldo.Count > 0)
                sueldoDiario = sueldo[0].SueldoDiario;

            return sueldoDiario;

        }

        private void calcularIndemnizacion(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {

            if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault() != null)
                {
                    //

                    Decimal totalpercepciones = 0;



                    totalpercepciones = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);

                    var totalViaticos = NominaTrabajador.ListaPercepcionesTrabajadoresViaticos.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);

                    totalpercepciones = totalpercepciones + totalViaticos;




                    if (totalpercepciones > 0)
                    {
                        decimal BaseGravable = 0;
                        decimal BaseGravableQnaAnterior = 0;
                        List<Configuracion_ctISR> Limites;
                        List<Configuracion_ctSubsidioEmpleo> SubsidioEmpleo;
                        decimal enfermedadgeneraldias = 0, incidencias = 0;

                        decimal LimiteInferior, CantidadSubsidioEmpleoMensual, ExcedenteLimiteInferior, ImpuestoMarginal, ImpuestoCausado;
                        decimal CuotaFija, PorcentajeAplicarseExcedenteLimiteInferior, ImpuestoNeto;
                        string Id = NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes;



                        decimal SalarioBruto = 0M;
                        var percepcionesmensuales = NominaTrabajador.PercepcionPersonalizada.Where(f => f.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL").Select(G => G.IdPercepcion).ToArray();

                        //INDEMINZACIONES
                        decimal indemnizacionextenta = 0M;
                        decimal basegravableultimosueldo = 0M;
                        decimal sueldomensual = 0m;

                        var uma90 = NominaTrabajador.ctUMA.Monto * 90;
                        SingletonAntiguedad antiguedad = SingletonAntiguedad.Instance;

                        AntiguedadLaboralQuinquenioTrabajador añoslaborados = antiguedad.getAntiguedad(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);
                        indemnizacionextenta = uma90 * añoslaborados.AñosQuinquenio;

                        var ultimosueldodiario = getUltimoSueldoDiario(ConvenioLaboralTrabajadorCategoria);
                        basegravableultimosueldo = ultimosueldodiario - indemnizacionextenta;

                        sueldomensual = (ultimosueldodiario * 2);
                        //if (Isrtotal > 0)
                        //    if (Isrtotal > indemnizacionextenta)
                        //        Isrtotal = Isrtotal - indemnizacionextenta;



                        if (Convert.ToInt16(Id) % 2 != 0)
                        {


                            SalarioBruto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => !percepcionesmensuales.Contains(v.IdPercepcion) && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);

                            var SalarioBruto2 = NominaTrabajador.stNominaTrabajadorPercepcionesdelMes.Where(v => !percepcionesmensuales.Contains(v.IdPercepcion) && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);

                            SalarioBruto = SalarioBruto + SalarioBruto2;

                        }
                        else
                        {

                            SalarioBruto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);


                            var SalarioBruto2 = NominaTrabajador.stNominaTrabajadorPercepcionesdelMes.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);
                            SalarioBruto = SalarioBruto + SalarioBruto2;
                        }

                        //disminucion de base gravable



                        var percepcionesDisminucion = NominaTrabajador.PlantillaNominaDeduccionesRelacionLaboral.Where(c =>
                       c.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO"
                       || c.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO"
                       || c.Deducciones_ctDeduccion.Deduccion == "FALTA MATERIAL DIDACTICO"
                       || c.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO"

                   ).Select(x => x.IdPlantillaNominaDeduccion).ToArray();

                        var Totaldisminucion = NominaTrabajador.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(v =>
                         percepcionesDisminucion.Contains(v.IdPlantillaNominaDeduccion)
                          &&
                        v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList());

                        SalarioBruto = (SalarioBruto - Totaldisminucion) - indemnizacionextenta;

                        SalarioBruto = SalarioBruto - NominaTrabajador.TrabajadorTotalPercepcionesGuarderiaOrdinarias;

                        SalarioBruto = SalarioBruto + totalViaticos;


                        //                    incidencias = NominaTrabajador.ListaVariablesNominaTrabajador.Where(j => j.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        //&& j.Concepto == "INCIDENCIAS").Sum(h => h.Importe);

                        enfermedadgeneraldias = NominaTrabajador.ListaVariablesNominaTrabajador.Where(j => j.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                           && j.Concepto == "ENFERMEDAD GENERAL").Sum(x => x.Importe);

                        decimal totalenfermedadgeneral = 0;
                        if (NominaTrabajador.DiasPagados > 0)
                        {
                            totalenfermedadgeneral = (((SalarioBruto / NominaTrabajador.DiasPagados) * enfermedadgeneraldias) * 0.60M);

                        }


                        SalarioBruto = SalarioBruto - totalenfermedadgeneral;
                        //}0

                        decimal ImporteIsrAnterior = 0;

                        //                        if (Convert.ToInt16(Id) % 2 != 0)
                        //                        {
                        //                            BaseGravable = (SalarioBruto * 2); // para el cálculo del isr se multiplica por 2
                        //                        }
                        //                        else
                        //                        {
                        //                            DapperQuery dp = new DapperQuery("bdNovaEntities");
                        //                            int idqna = System.Convert.ToInt32(NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes) - 1;

                        //                            var tmpIsrAnterior = getBaseGravableQuincenaAnterior(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, idqna, NominaTrabajador.Nomina.Año);

                        //                            if (tmpIsrAnterior != null)
                        //                            {

                        //                                ImporteIsrAnterior = tmpIsrAnterior.Importe;
                        //                            }

                        //                            try
                        //                            {


                        //                                string query = @"select a.IdNominaTrabajador,a.IdNomina,a.IdConvenioLaboralTrabajadorCategoria,a.SueldoBruto,a.SueldoDiario
                        //,a.SueldoNeto,a.SueldoTransferencia,a.SueldoMonedero,a.IdTrabajadorCuentasTransferencia,a.IdTrabajadorCuentasMonedero,a.HorasSemanaMes
                        //,a.HorasSemanaMesTrabajadas,a.HorasExcedentes,a.HorasTrabajadasExcedentes,a.HorasInterinas,a.HorasTrabajadasInterinas,a.DiasEfectivosLaborados,a.CostoPorHora
                        //,a.CostoPorHoraExcedente
                        // ,a.CostoPorHorasInterinas
                        // ,a.SalarioDiarioIntegrado
                        // ,a.QuinquenioDiario
                        // ,a.MaterialDidacticoDiario
                        // ,a.SueldoBrutoQuinquenioDiario
                        //  ,a.SumaPercepcionesVariables
                        // ,a.BaseGravable
                        // ,a.HorasEfectivasDeTrabajo
                        // ,a.EsHorarioSinCambios
                        // ,a.SalarioBrutoGravable
                        // ,a.SubsidioEmpleoMensual
                        // ,a.Isr
                        // ,a.IsrRdl
                        // ,a.Rdl
                        // ,a.CantidadSubsidioEmpleoMensual
                        // ,a.EsHorarioAnterior
                        // ,a.EsHorarioAjustado from Nomina_stNominaTrabajador a 
                        //  inner join  Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                        //  inner join Convenios_stConvenioLaboralTrabajador c on b.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
                        //  inner join Nomina_stNomina d on d.IdNomina=a.IdNomina 
                        //  inner join Catalogos_ctQuincenaMes e on e.IdQuincenaMes=d.IdQuincenaMes
                        //   inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
                        //  where xx.EstatusNomina<>'CANCELADO' AND c.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString() + " and d.Año=" + NominaTrabajador.Nomina_stNomina.Año.ToString() + " and e.QuincenaMes=" + idqna;
                        //                                List<Nomina_stNominaTrabajador> datos = (List<Nomina_stNominaTrabajador>)dp.connection.Query<Nomina_stNominaTrabajador>(query);
                        //                                if (datos.Count > 0)

                        //                                    BaseGravableQnaAnterior = datos.Sum(r => r.BaseGravable) / 2;

                        //                            }
                        //                            catch (Exception ww)
                        //                            {

                        //                                var ttt = ww;
                        //                            }




                        //                            //  BaseGravable = SalarioBruto + (BaseGravableQnaAnterior);
                        //                            BaseGravable = SalarioBruto;

                        //                            dp.Close();
                        //                        }
                        Limites = NominaTrabajador.ISR.Where(i => i.LimiteSuperior >= BaseGravable && i.LimiteInferior <= BaseGravable).ToList();

                        LimiteInferior = Limites.Select(y => y.LimiteInferior).SingleOrDefault();
                        ExcedenteLimiteInferior = BaseGravable - LimiteInferior;
                        PorcentajeAplicarseExcedenteLimiteInferior = Limites.Select(y => y.PorcentajeAplicarseExcedenteLimiteInferior).SingleOrDefault() / 100;
                        ImpuestoMarginal = ExcedenteLimiteInferior * PorcentajeAplicarseExcedenteLimiteInferior;
                        CuotaFija = Limites.Select(y => y.CuotaFija).SingleOrDefault();
                        ImpuestoNeto = ImpuestoMarginal + CuotaFija;

                        SubsidioEmpleo = NominaTrabajador.SubsidioEmpleo.Where(s => s.IngresosHasta >= BaseGravable && s.IngresosDesde <= BaseGravable).ToList();

                        CantidadSubsidioEmpleoMensual = SubsidioEmpleo.Select(c => c.Subsidio).SingleOrDefault(); // Guardar en tabla
                        ImpuestoCausado = ImpuestoNeto - CantidadSubsidioEmpleoMensual;




                        VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
                        vnt1.Concepto = "BASE GRAVABLE";
                        vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt1.Importe = BaseGravable;
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt1);

                        decimal Isrtotal = 0;

                        //if (Convert.ToInt16(Id) % 2 != 0)
                        //{
                        //    Isrtotal = ImpuestoCausado / 2;
                        //}


                        //if (Isrtotal == 0)
                        //{
                        Isrtotal = ImpuestoCausado;
                        // }

                        var tasaEfectiva = sueldomensual / Isrtotal;
                         Isrtotal = BaseGravable * tasaEfectiva;

                        //

                        if (Isrtotal < 0)
                        {



                            PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


                            percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            percepcion.IdNomina = NominaTrabajador.IdNomina;
                            percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().IdPlantillaNominaPercepcion;
                            percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                            percepcion.Importe = Isrtotal * -1;


                            percepcion.Tipo = "NORMAL";
                            percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                            percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                            NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);


                            //VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();
                            //vnt4.Concepto = "CantidadSubsidioEmpleoMensual";
                            //vnt4.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            //vnt4.Importe = percepcion.Importe;
                            //NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt4);
                        }
                        else
                        {

                            var isrtotalpagadoMes = NominaTrabajador.stNominaTrabajadorISRdelMes.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(r => r.Importe);

                            if (isrtotalpagadoMes >= Isrtotal)
                                Isrtotal = isrtotalpagadoMes - Isrtotal;
                            else
                                Isrtotal = Isrtotal - isrtotalpagadoMes;

                            if (Isrtotal > 0)
                            {
                                DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                                isr.EsImprimibleRecibo = true;
                                isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                isr.IdNomina = NominaTrabajador.Nomina.IdNomina;
                                isr.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault().IdPlantillaNominaDeduccion;
                                isr.Importe = Isrtotal;




                                NominaTrabajador.ListaDeduccionesTrabajadores.Add(isr);

                                VariablesNominaTrabajador vnt3 = new VariablesNominaTrabajador();
                                vnt3.Concepto = "Isr";
                                vnt3.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                vnt3.Importe = isr.Importe;
                                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt3);

                                var tienerdl = NominaTrabajador.PercepcionPersonalizada.Where(f => f.Percepciones_ctPercepcion.Percepcion == "REMUNERACIÓN AL DESEMPEÑO LABORAL").FirstOrDefault();

                                if ((tienerdl) != null)
                                {

                                    if (tienerdl.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL" && Convert.ToInt16(Id) % 2 == 0)
                                    {


                                        VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();
                                        vnt4.Concepto = "Rdl";
                                        vnt4.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        vnt4.Importe = tienerdl.Importe;
                                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt4);


                                    }



                                }



                                var idtitulacionPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.IdPlantillaNomina == NominaTrabajador.Nomina.IdPlantillaNomina && x.Percepciones_ctPercepcion.Percepcion == "TITULACIÓN").FirstOrDefault();
                                if (idtitulacionPercepcion != null)
                                {
                                    var existetitulacion = NominaTrabajador.ListaPercepcionesTrabajadores.Where(x => x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                     && x.IdPercepcion == idtitulacionPercepcion.IdPercepcion).FirstOrDefault();
                                    if (existetitulacion != null)
                                    {


                                        PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


                                        percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        percepcion.IdNomina = NominaTrabajador.IdNomina;
                                        percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().IdPlantillaNominaPercepcion;
                                        percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                                        percepcion.Importe = isr.Importe;


                                        percepcion.Tipo = "NORMAL";
                                        percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                        percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);


                                    }
                                }

                            }

                        }



                    }



                }

        }

        private void calcularNormal(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        { }
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault() != null)
                {
                    //

                    Decimal totalpercepciones = 0;


                  
                    totalpercepciones = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);

                    var totalViaticos = NominaTrabajador.ListaPercepcionesTrabajadoresViaticos.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);

                    totalpercepciones = totalpercepciones + totalViaticos;
                    



                    if (totalpercepciones > 0)
                    {
                        decimal BaseGravable = 0;
                        decimal BaseGravableQnaAnterior = 0;
                        List<Configuracion_ctISR> Limites;
                        List<Configuracion_ctSubsidioEmpleo> SubsidioEmpleo;
                        decimal enfermedadgeneraldias = 0, incidencias = 0;

                        decimal LimiteInferior, CantidadSubsidioEmpleoMensual, ExcedenteLimiteInferior, ImpuestoMarginal, ImpuestoCausado;
                        decimal CuotaFija, PorcentajeAplicarseExcedenteLimiteInferior, ImpuestoNeto;
                        string Id = NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes;

                   

                        decimal SalarioBruto = 0M;
                        var percepcionesmensuales = NominaTrabajador.PercepcionPersonalizada.Where(f => f.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL").Select(G => G.IdPercepcion).ToArray();

                        //INDEMINZACIONES
                        decimal indemnizacionextenta = 0M;
                        decimal basegravableultimosueldo = 0M;
                        decimal sueldomensual = 0m;
                        
                            var uma90 = NominaTrabajador.ctUMA.Monto * 90;
                            SingletonAntiguedad antiguedad = SingletonAntiguedad.Instance;

                            AntiguedadLaboralQuinquenioTrabajador añoslaborados = antiguedad.getAntiguedad(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);
                            indemnizacionextenta = uma90 * añoslaborados.AñosQuinquenio;

                            var ultimosueldodiario = getUltimoSueldoDiario(ConvenioLaboralTrabajadorCategoria);
                            basegravableultimosueldo = ultimosueldodiario - indemnizacionextenta;

                            sueldomensual = (ultimosueldodiario * 2);
                            //if (Isrtotal > 0)
                            //    if (Isrtotal > indemnizacionextenta)
                            //        Isrtotal = Isrtotal - indemnizacionextenta;

                       

                        if (Convert.ToInt16(Id) % 2 != 0)
                        {

                            
                            SalarioBruto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => !percepcionesmensuales.Contains(v.IdPercepcion) && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);

                            var SalarioBruto2 = NominaTrabajador.stNominaTrabajadorPercepcionesdelMes.Where(v => !percepcionesmensuales.Contains(v.IdPercepcion) && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);

                            SalarioBruto = SalarioBruto + SalarioBruto2;

                        }
                        else
                        {
                            
                            SalarioBruto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);


                            var SalarioBruto2 = NominaTrabajador.stNominaTrabajadorPercepcionesdelMes.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);
                            SalarioBruto = SalarioBruto + SalarioBruto2;
                        }

                        //disminucion de base gravable



                        var percepcionesDisminucion = NominaTrabajador.PlantillaNominaDeduccionesRelacionLaboral.Where(c =>
                       c.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO"
                       || c.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO"
                       || c.Deducciones_ctDeduccion.Deduccion == "FALTA MATERIAL DIDACTICO"
                       || c.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO"

                   ).Select(x => x.IdPlantillaNominaDeduccion).ToArray();

                        var Totaldisminucion = NominaTrabajador.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(v =>
                         percepcionesDisminucion.Contains(v.IdPlantillaNominaDeduccion)
                          &&
                        v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList());

                        SalarioBruto = (SalarioBruto - Totaldisminucion) - indemnizacionextenta;

                        SalarioBruto = SalarioBruto - NominaTrabajador.TrabajadorTotalPercepcionesGuarderiaOrdinarias;

                        SalarioBruto = SalarioBruto + totalViaticos;


                        //                    incidencias = NominaTrabajador.ListaVariablesNominaTrabajador.Where(j => j.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        //&& j.Concepto == "INCIDENCIAS").Sum(h => h.Importe);

                        enfermedadgeneraldias = NominaTrabajador.ListaVariablesNominaTrabajador.Where(j => j.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                           && j.Concepto == "ENFERMEDAD GENERAL").Sum(x => x.Importe);

                        decimal totalenfermedadgeneral = 0;
                        if (NominaTrabajador.DiasPagados > 0)
                        {
                            totalenfermedadgeneral = (((SalarioBruto / NominaTrabajador.DiasPagados) * enfermedadgeneraldias) * 0.60M);

                        }


                        SalarioBruto = SalarioBruto - totalenfermedadgeneral;
                        //}0

                        decimal ImporteIsrAnterior = 0;

//                        if (Convert.ToInt16(Id) % 2 != 0)
//                        {
//                            BaseGravable = (SalarioBruto * 2); // para el cálculo del isr se multiplica por 2
//                        }
//                        else
//                        {
//                            DapperQuery dp = new DapperQuery("bdNovaEntities");
//                            int idqna = System.Convert.ToInt32(NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes) - 1;

//                            var tmpIsrAnterior = getBaseGravableQuincenaAnterior(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, idqna, NominaTrabajador.Nomina.Año);

//                            if (tmpIsrAnterior != null)
//                            {

//                                ImporteIsrAnterior = tmpIsrAnterior.Importe;
//                            }

//                            try
//                            {


//                                string query = @"select a.IdNominaTrabajador,a.IdNomina,a.IdConvenioLaboralTrabajadorCategoria,a.SueldoBruto,a.SueldoDiario
//,a.SueldoNeto,a.SueldoTransferencia,a.SueldoMonedero,a.IdTrabajadorCuentasTransferencia,a.IdTrabajadorCuentasMonedero,a.HorasSemanaMes
//,a.HorasSemanaMesTrabajadas,a.HorasExcedentes,a.HorasTrabajadasExcedentes,a.HorasInterinas,a.HorasTrabajadasInterinas,a.DiasEfectivosLaborados,a.CostoPorHora
//,a.CostoPorHoraExcedente
// ,a.CostoPorHorasInterinas
// ,a.SalarioDiarioIntegrado
// ,a.QuinquenioDiario
// ,a.MaterialDidacticoDiario
// ,a.SueldoBrutoQuinquenioDiario
//  ,a.SumaPercepcionesVariables
// ,a.BaseGravable
// ,a.HorasEfectivasDeTrabajo
// ,a.EsHorarioSinCambios
// ,a.SalarioBrutoGravable
// ,a.SubsidioEmpleoMensual
// ,a.Isr
// ,a.IsrRdl
// ,a.Rdl
// ,a.CantidadSubsidioEmpleoMensual
// ,a.EsHorarioAnterior
// ,a.EsHorarioAjustado from Nomina_stNominaTrabajador a 
//  inner join  Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
//  inner join Convenios_stConvenioLaboralTrabajador c on b.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
//  inner join Nomina_stNomina d on d.IdNomina=a.IdNomina 
//  inner join Catalogos_ctQuincenaMes e on e.IdQuincenaMes=d.IdQuincenaMes
//   inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
//  where xx.EstatusNomina<>'CANCELADO' AND c.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString() + " and d.Año=" + NominaTrabajador.Nomina_stNomina.Año.ToString() + " and e.QuincenaMes=" + idqna;
//                                List<Nomina_stNominaTrabajador> datos = (List<Nomina_stNominaTrabajador>)dp.connection.Query<Nomina_stNominaTrabajador>(query);
//                                if (datos.Count > 0)

//                                    BaseGravableQnaAnterior = datos.Sum(r => r.BaseGravable) / 2;

//                            }
//                            catch (Exception ww)
//                            {

//                                var ttt = ww;
//                            }




//                            //  BaseGravable = SalarioBruto + (BaseGravableQnaAnterior);
//                            BaseGravable = SalarioBruto;

//                            dp.Close();
//                        }
                        Limites = NominaTrabajador.ISR.Where(i => i.LimiteSuperior >= BaseGravable && i.LimiteInferior <= BaseGravable).ToList();

                        LimiteInferior = Limites.Select(y => y.LimiteInferior).SingleOrDefault();
                        ExcedenteLimiteInferior = BaseGravable - LimiteInferior;
                        PorcentajeAplicarseExcedenteLimiteInferior = Limites.Select(y => y.PorcentajeAplicarseExcedenteLimiteInferior).SingleOrDefault() / 100;
                        ImpuestoMarginal = ExcedenteLimiteInferior * PorcentajeAplicarseExcedenteLimiteInferior;
                        CuotaFija = Limites.Select(y => y.CuotaFija).SingleOrDefault();
                        ImpuestoNeto = ImpuestoMarginal + CuotaFija;

                        SubsidioEmpleo = NominaTrabajador.SubsidioEmpleo.Where(s => s.IngresosHasta >= BaseGravable && s.IngresosDesde <= BaseGravable).ToList();

                        CantidadSubsidioEmpleoMensual = SubsidioEmpleo.Select(c => c.Subsidio).SingleOrDefault(); // Guardar en tabla
                        ImpuestoCausado = ImpuestoNeto - CantidadSubsidioEmpleoMensual;




                        VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
                        vnt1.Concepto = "BASE GRAVABLE";
                        vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt1.Importe = BaseGravable;
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt1);

                        decimal Isrtotal = 0;

                        //if (Convert.ToInt16(Id) % 2 != 0)
                        //{
                        //    Isrtotal = ImpuestoCausado / 2;
                        //}


                        //if (Isrtotal == 0)
                        //{
                            Isrtotal = ImpuestoCausado;
                        // }

                        var tasaEfectiva = sueldomensual / Isrtotal;
                         Isrtotal = BaseGravable * tasaEfectiva;

                        //

                        if (Isrtotal < 0)
                        {



                            PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


                            percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            percepcion.IdNomina = NominaTrabajador.IdNomina;
                            percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().IdPlantillaNominaPercepcion;
                            percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                            percepcion.Importe = Isrtotal * -1;


                            percepcion.Tipo = "NORMAL";
                            percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                            percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                            NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);


                            //VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();
                            //vnt4.Concepto = "CantidadSubsidioEmpleoMensual";
                            //vnt4.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            //vnt4.Importe = percepcion.Importe;
                            //NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt4);
                        }
                        else
                        {

                            var isrtotalpagadoMes = NominaTrabajador.stNominaTrabajadorISRdelMes.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(r => r.Importe);

                            if (isrtotalpagadoMes >= Isrtotal)
                                Isrtotal = isrtotalpagadoMes - Isrtotal;
                            else
                                Isrtotal = Isrtotal - isrtotalpagadoMes;

                            if (Isrtotal > 0)
                            {
                                DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                                isr.EsImprimibleRecibo = true;
                                isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                isr.IdNomina = NominaTrabajador.Nomina.IdNomina;
                                isr.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault().IdPlantillaNominaDeduccion;
                                isr.Importe = Isrtotal;




                                NominaTrabajador.ListaDeduccionesTrabajadores.Add(isr);

                                VariablesNominaTrabajador vnt3 = new VariablesNominaTrabajador();
                                vnt3.Concepto = "Isr";
                                vnt3.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                vnt3.Importe = isr.Importe;
                                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt3);

                                var tienerdl = NominaTrabajador.PercepcionPersonalizada.Where(f => f.Percepciones_ctPercepcion.Percepcion == "REMUNERACIÓN AL DESEMPEÑO LABORAL").FirstOrDefault();

                                if ((tienerdl) != null)
                                {

                                    if (tienerdl.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL" && Convert.ToInt16(Id) % 2 == 0)
                                    {


                                        VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();
                                        vnt4.Concepto = "Rdl";
                                        vnt4.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        vnt4.Importe = tienerdl.Importe;
                                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt4);


                                    }



                                }



                                var idtitulacionPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.IdPlantillaNomina == NominaTrabajador.Nomina.IdPlantillaNomina && x.Percepciones_ctPercepcion.Percepcion == "TITULACIÓN").FirstOrDefault();
                                if (idtitulacionPercepcion != null)
                                {
                                    var existetitulacion = NominaTrabajador.ListaPercepcionesTrabajadores.Where(x => x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                     && x.IdPercepcion == idtitulacionPercepcion.IdPercepcion).FirstOrDefault();
                                    if (existetitulacion != null)
                                    {


                                        PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


                                        percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        percepcion.IdNomina = NominaTrabajador.IdNomina;
                                        percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().IdPlantillaNominaPercepcion;
                                        percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                                        percepcion.Importe = isr.Importe;


                                        percepcion.Tipo = "NORMAL";
                                        percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                        percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);


                                    }
                                }

                            }

                        }



                    }



                }




        }





    }
}