﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Nova.Libraries;
using Dapper;
using D3D;
using DevExpress.Utils.Extensions;
using DevExpress.Web.ASPxHtmlEditor.Internal;
 

namespace Nova.Models.Calculos.Deducciones
{
     

    public class ISR : IDeduccionBehavior
    {
        private Deducciones_stNominaTrabajadorDeduccion getBaseGravableQuincenaAnterior(int IdConvenioLaboralTrabajadorCategoria,string QuincenaMes, int Año )
        {
            Deducciones_stNominaTrabajadorDeduccion result = new Deducciones_stNominaTrabajadorDeduccion();

            DapperQuery dapp = new DapperQuery("bdNovaEntities");


          
 

            string query = @"select a.IdNominaTrabajadorDeduccion,a.IdPlantillaNominaDeduccion,a.Importe,a.EsImprimibleRecibo,a.IdNominaTrabajador
                                 from Deducciones_stNominaTrabajadorDeduccion a
                                inner join Nomina_stNominaTrabajador z on a.IdNominaTrabajador=z.IdNominaTrabajador
                                inner join Nomina_stNomina m on m.IdNomina=z.IdNomina
                                inner join Deducciones_stPlantillaNominaDeducciones b on a.IdPlantillaNominaDeduccion=b.IdPlantillaNominaDeduccion
                                inner join Deducciones_ctDeduccion c on c.IdDeduccion=b.IdDeduccion
                                inner join Catalogos_ctQuincenaMes e on e.IdQuincenaMes=m.IdQuincenaMes
                                 inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=z.IdNominaTrabajadorEstatus
									where xx.EstatusNomina<>'CANCELADO' AND z.IdConvenioLaboralTrabajadorCategoria=" + IdConvenioLaboralTrabajadorCategoria.ToString() + @" and c.Deduccion='ISR' 
                               and m.Año=" + Año.ToString() + " and e.QuincenaMes='" + QuincenaMes + "' order by a.IdNominaTrabajadorDeduccion desc";

             result =(Deducciones_stNominaTrabajadorDeduccion)dapp.connection.Query<Deducciones_stNominaTrabajadorDeduccion>(query, null, null, true, 0, null).FirstOrDefault();

            dapp.Close();
            

            return result;
        }

        private decimal getUltimoSueldoDiario(Convenios_stConvenioLaboralTrabajadorCategoria ctl)
        {
            decimal sueldoDiario = 0M;
            string sql = @"select top 1 b.* from Nomina_stNomina a inner
                                                              join Nomina_stNominaTrabajador b on a.idnomina = b.IdNomina
                                                                inner join Nomina_ctPlantillaNomina c on c.IdPlantillaNomina=a.IdPlantillaNomina
                                                                inner join Nomina_ctPlantillaGrupo d on c.IdPlantillaGrupo=d.IdPlantillaGrupo
                                                                where   b.IdConvenioLaboralTrabajadorCategoria ="+ ctl.IdConvenioLaboralTrabajadorCategoria +@"
                                                                and d.PlantillaGrupo like '%SUELDO%'                                                                
                                                                ORDER BY FechaInicio DESC";
            DapperQuery dp = new DapperQuery("bdNovaEntities");

            List<Nomina_stNominaTrabajador> sueldo = (List<Nomina_stNominaTrabajador>)dp.connection.Query<Nomina_stNominaTrabajador>(sql.ToString());

            dp.Close();

            if (sueldo.Count > 0)
                sueldoDiario = sueldo[0].SueldoDiario;

            return sueldoDiario;

        }

        private void calcularIndemnizacion(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {

            if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault() != null)
                {
                    //

                    Decimal totalpercepciones = 0;



                    totalpercepciones = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);

                    var totalViaticos = NominaTrabajador.ListaPercepcionesTrabajadoresViaticos.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);

                    totalpercepciones = totalpercepciones + totalViaticos;




                    if (totalpercepciones > 0)
                    {
                        decimal BaseGravable = 0;
                        decimal BaseGravableQnaAnterior = 0;
                        List<Configuracion_ctISR> Limites;
                        List<Configuracion_ctSubsidioEmpleo> SubsidioEmpleo;
                        decimal enfermedadgeneraldias = 0, incidencias = 0;

                        decimal LimiteInferior, CantidadSubsidioEmpleoMensual, ExcedenteLimiteInferior, ImpuestoMarginal, ImpuestoCausado;
                        decimal CuotaFija, PorcentajeAplicarseExcedenteLimiteInferior, ImpuestoNeto;
                        string Id = NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes;



                        decimal SalarioBruto = 0M;
                        var percepcionesmensuales = NominaTrabajador.PercepcionPersonalizada.Where(f => f.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL").Select(G => G.IdPercepcion).ToArray();

                        //INDEMINZACIONES
                        decimal indemnizacionextenta = 0M;
                        decimal basegravableultimosueldo = 0M;
                        decimal sueldomensual = 0m;

                        var uma90 = NominaTrabajador.ctUMA.Monto * 90;
                        //SingletonAntiguedad antiguedad = SingletonAntiguedad.Instance;

                        //AntiguedadLaboralQuinquenioTrabajador añoslaborados = antiguedad.getAntiguedad(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);
                        //indemnizacionextenta = uma90 * añoslaborados.AñosQuinquenio;
                        var añoslaborados = NominaTrabajador.TrabajadorAntiguedad.getAntiguedadPorTrabajador(ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador);
                        indemnizacionextenta = uma90 * añoslaborados.Years;

                        var ultimosueldodiario = getUltimoSueldoDiario(ConvenioLaboralTrabajadorCategoria)*30;
                        basegravableultimosueldo = ultimosueldodiario - indemnizacionextenta;

                        sueldomensual = (ultimosueldodiario * 2);
                        //if (Isrtotal > 0)
                        //    if (Isrtotal > indemnizacionextenta)
                        //        Isrtotal = Isrtotal - indemnizacionextenta;



                        if (Convert.ToInt16(Id) % 2 != 0)
                        {


                            SalarioBruto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => !percepcionesmensuales.Contains(v.IdPercepcion) && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);

                            var SalarioBruto2 = NominaTrabajador.stNominaTrabajadorPercepcionesdelMes.Where(v => !percepcionesmensuales.Contains(v.IdPercepcion) && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);


                            SalarioBruto = SalarioBruto + SalarioBruto2;

                        }
                        else
                        {

                            SalarioBruto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);


                            var SalarioBruto2 = NominaTrabajador.stNominaTrabajadorPercepcionesdelMes.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);
                            SalarioBruto = SalarioBruto + SalarioBruto2;
                        }

                        //disminucion de base gravable



                        var percepcionesDisminucion = NominaTrabajador.PlantillaNominaDeduccionesRelacionLaboral.Where(c =>
                       c.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO"
                       || c.Deducciones_ctDeduccion.Deduccion.Contains("FALTA")

                   ).Select(x => x.IdPlantillaNominaDeduccion).ToArray();

                        var Totaldisminucion = NominaTrabajador.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(v =>
                         percepcionesDisminucion.Contains(v.IdPlantillaNominaDeduccion)
                          &&
                        v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList());

                        SalarioBruto = (SalarioBruto - Totaldisminucion) - indemnizacionextenta;

                        SalarioBruto = SalarioBruto - NominaTrabajador.TrabajadorTotalPercepcionesGuarderiaOrdinarias;

                        SalarioBruto = SalarioBruto + totalViaticos;


                        //                    incidencias = NominaTrabajador.ListaVariablesNominaTrabajador.Where(j => j.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        //&& j.Concepto == "INCIDENCIAS").Sum(h => h.Importe);

                        enfermedadgeneraldias = NominaTrabajador.ListaVariablesNominaTrabajador.Where(j => j.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                           && j.Concepto == "ENFERMEDAD GENERAL").Sum(x => x.Importe);

                        decimal totalenfermedadgeneral = 0;
                        if (NominaTrabajador.DiasPagados > 0)
                        {
                            totalenfermedadgeneral = (((SalarioBruto / NominaTrabajador.DiasPagados) * enfermedadgeneraldias) * 0.60M);

                        }


                        SalarioBruto = SalarioBruto - totalenfermedadgeneral;
                        //}0

                        decimal ImporteIsrAnterior = 0;

                        //                        if (Convert.ToInt16(Id) % 2 != 0)
                        //                        {
                        //                            BaseGravable = (SalarioBruto * 2); // para el cálculo del isr se multiplica por 2
                        //                        }
                        //                        else
                        //                        {
                        //                            DapperQuery dp = new DapperQuery("bdNovaEntities");
                        //                            int idqna = System.Convert.ToInt32(NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes) - 1;

                        //                            var tmpIsrAnterior = getBaseGravableQuincenaAnterior(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, idqna, NominaTrabajador.Nomina.Año);

                        //                            if (tmpIsrAnterior != null)
                        //                            {

                        //                                ImporteIsrAnterior = tmpIsrAnterior.Importe;
                        //                            }

                        //                            try
                        //                            {


                        //                                string query = @"select a.IdNominaTrabajador,a.IdNomina,a.IdConvenioLaboralTrabajadorCategoria,a.SueldoBruto,a.SueldoDiario
                        //,a.SueldoNeto,a.SueldoTransferencia,a.SueldoMonedero,a.IdTrabajadorCuentasTransferencia,a.IdTrabajadorCuentasMonedero,a.HorasSemanaMes
                        //,a.HorasSemanaMesTrabajadas,a.HorasExcedentes,a.HorasTrabajadasExcedentes,a.HorasInterinas,a.HorasTrabajadasInterinas,a.DiasEfectivosLaborados,a.CostoPorHora
                        //,a.CostoPorHoraExcedente
                        // ,a.CostoPorHorasInterinas
                        // ,a.SalarioDiarioIntegrado
                        // ,a.QuinquenioDiario
                        // ,a.MaterialDidacticoDiario
                        // ,a.SueldoBrutoQuinquenioDiario
                        //  ,a.SumaPercepcionesVariables
                        // ,a.BaseGravable
                        // ,a.HorasEfectivasDeTrabajo
                        // ,a.EsHorarioSinCambios
                        // ,a.SalarioBrutoGravable
                        // ,a.SubsidioEmpleoMensual
                        // ,a.Isr
                        // ,a.IsrRdl
                        // ,a.Rdl
                        // ,a.CantidadSubsidioEmpleoMensual
                        // ,a.EsHorarioAnterior
                        // ,a.EsHorarioAjustado from Nomina_stNominaTrabajador a 
                        //  inner join  Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                        //  inner join Convenios_stConvenioLaboralTrabajador c on b.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
                        //  inner join Nomina_stNomina d on d.IdNomina=a.IdNomina 
                        //  inner join Catalogos_ctQuincenaMes e on e.IdQuincenaMes=d.IdQuincenaMes
                        //   inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
                        //  where xx.EstatusNomina<>'CANCELADO' AND c.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString() + " and d.Año=" + NominaTrabajador.Nomina_stNomina.Año.ToString() + " and e.QuincenaMes=" + idqna;
                        //                                List<Nomina_stNominaTrabajador> datos = (List<Nomina_stNominaTrabajador>)dp.connection.Query<Nomina_stNominaTrabajador>(query);
                        //                                if (datos.Count > 0)

                        //                                    BaseGravableQnaAnterior = datos.Sum(r => r.BaseGravable) / 2;

                        //                            }
                        //                            catch (Exception ww)
                        //                            {

                        //                                var ttt = ww;
                        //                            }




                        //                            //  BaseGravable = SalarioBruto + (BaseGravableQnaAnterior);
                        //                            BaseGravable = SalarioBruto;

                        //                            dp.Close();
                        //                        }
                        Limites = NominaTrabajador.ISR.Where(i => i.LimiteSuperior >= BaseGravable && i.LimiteInferior <= BaseGravable).ToList();

                        LimiteInferior = Limites.Select(y => y.LimiteInferior).SingleOrDefault();
                        ExcedenteLimiteInferior = BaseGravable - LimiteInferior;
                        PorcentajeAplicarseExcedenteLimiteInferior = Limites.Select(y => y.PorcentajeAplicarseExcedenteLimiteInferior).SingleOrDefault() / 100;
                        ImpuestoMarginal = ExcedenteLimiteInferior * PorcentajeAplicarseExcedenteLimiteInferior;
                        CuotaFija = Limites.Select(y => y.CuotaFija).SingleOrDefault();
                        ImpuestoNeto = ImpuestoMarginal + CuotaFija;

                        SubsidioEmpleo = NominaTrabajador.SubsidioEmpleo.Where(s => s.IngresosHasta >= BaseGravable && s.IngresosDesde <= BaseGravable).ToList();

                        CantidadSubsidioEmpleoMensual = SubsidioEmpleo.Select(c => c.Subsidio).SingleOrDefault(); // Guardar en tabla
                        ImpuestoCausado = ImpuestoNeto - CantidadSubsidioEmpleoMensual;




                        VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
                        vnt1.Concepto = "BASE GRAVABLE";
                        vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt1.Importe = BaseGravable;
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt1);

                        decimal Isrtotal = 0;

                        //if (Convert.ToInt16(Id) % 2 != 0)
                        //{
                        //    Isrtotal = ImpuestoCausado / 2;
                        //}


                        //if (Isrtotal == 0)
                        //{
                        Isrtotal = ImpuestoCausado;
                        // }

                        var tasaEfectiva = sueldomensual / Isrtotal;
                        Isrtotal = BaseGravable * tasaEfectiva;

                        //

                        if (Isrtotal < 0)
                        {



                            PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


                            percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            percepcion.IdNomina = NominaTrabajador.IdNomina;
                            percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().IdPlantillaNominaPercepcion;
                            percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                            percepcion.Importe = Isrtotal * -1;


                            percepcion.Tipo = "NORMAL";
                            percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                            percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                            NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);


                            //VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();
                            //vnt4.Concepto = "CantidadSubsidioEmpleoMensual";
                            //vnt4.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            //vnt4.Importe = percepcion.Importe;
                            //NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt4);
                        }
                        else
                        {
                            decimal isrtotalpagadoMes = 0;
                           // var isrtotalpagadoMes = NominaTrabajador.stNominaTrabajadorISRdelMes.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(r => r.Importe);

                            if (isrtotalpagadoMes >= Isrtotal)
                                Isrtotal = isrtotalpagadoMes - Isrtotal;
                            else
                                Isrtotal = Isrtotal - isrtotalpagadoMes;

                            if (Isrtotal > 0)
                            {
                                DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                                isr.EsImprimibleRecibo = true;
                                isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                isr.IdNomina = NominaTrabajador.Nomina.IdNomina;
                                isr.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault().IdPlantillaNominaDeduccion;
                                isr.Importe = Isrtotal;




                                NominaTrabajador.ListaDeduccionesTrabajadores.Add(isr);

                                VariablesNominaTrabajador vnt3 = new VariablesNominaTrabajador();
                                vnt3.Concepto = "Isr";
                                vnt3.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                vnt3.Importe = isr.Importe;
                                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt3);

                                var tienerdl = NominaTrabajador.PercepcionPersonalizada.Where(f => f.Percepciones_ctPercepcion.Percepcion == "REMUNERACIÓN AL DESEMPEÑO LABORAL").FirstOrDefault();

                                if ((tienerdl) != null)
                                {

                                    if (tienerdl.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL" && Convert.ToInt16(Id) % 2 == 0)
                                    {


                                        VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();
                                        vnt4.Concepto = "Rdl";
                                        vnt4.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        vnt4.Importe = tienerdl.Importe;
                                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt4);

                                        

                                    }



                                }



                                var idtitulacionPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.IdPlantillaNomina == NominaTrabajador.Nomina.IdPlantillaNomina && x.Percepciones_ctPercepcion.Percepcion == "TITULACIÓN").FirstOrDefault();
                                if (idtitulacionPercepcion != null)
                                {
                                    var existetitulacion = NominaTrabajador.ListaPercepcionesTrabajadores.Where(x => x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                     && x.IdPercepcion == idtitulacionPercepcion.IdPercepcion).FirstOrDefault();
                                    if (existetitulacion != null)
                                    {


                                        PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


                                        percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        percepcion.IdNomina = NominaTrabajador.IdNomina;
                                        percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().IdPlantillaNominaPercepcion;
                                        percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                                        percepcion.Importe = isr.Importe;


                                        percepcion.Tipo = "NORMAL";
                                        percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                        percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);


                                    }
                                }

                            }

                        }



                    }



                }

        }

        private void calcularNormal(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            bool calcular = true;
            if (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina == "EXTRAORDINARIA"
                && NominaTrabajador.Nomina_stNomina.NoCalcularISR)
            { calcular = false; }

            if (!NominaTrabajador.TrabajadorConIncapacipdadActiva && calcular)
                if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault() != null)
                {
                   
                        //

                        Decimal totalpercepciones = 0;
                    decimal basegravablemismanomina = 0;
                    NominaTrabajador.ExisteNominaSueldoValidarIsr = false;
                    //var percepcionesValidas = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(c => c.Percepciones_ctPercepcion.EsOrdinaria == true).Select(x => x.IdPlantillaNominaPercepcion).ToArray();


                    //if (!NominaTrabajador.TrabajadorConGuarderiaActiva)

                    var filtroPerepciones1aqna= NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(v => 
                    (v.Percepciones_ctPercepcion.Percepcion=="AJUSTE" || v.Percepciones_ctPercepcion.Percepcion == "DIFERENCIA")
                    || v.Percepciones_ctPercepcion.Percepcion == "PREMIO DE ANTIGUEDAD"
                    ).Select(s=> s.IdPlantillaNominaPercepcion).ToArray();

                    totalpercepciones = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);

                    var idotracategoria = NominaTrabajador.TrabajadoresVigentes.Where(a => a.IdConvenioLaboralTrabajadorCategoria !=
                    ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    && a.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                    decimal totalpercepcionesOtroCalculoMismaNomina = 0;

                    if (idotracategoria != null)
                    {
                          totalpercepcionesOtroCalculoMismaNomina = NominaTrabajador.ListaPercepcionesTrabajadores
                        .Where(v => v.IdConvenioLaboralTrabajadorCategoria == idotracategoria.IdConvenioLaboralTrabajadorCategoria

                        && v.EsGrabable == true).Sum(f => f.Importe);

                    }

                    totalpercepciones = totalpercepciones + totalpercepcionesOtroCalculoMismaNomina;

                var totalpercepcionesExcluir1aQna = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v =>
                    filtroPerepciones1aqna.Contains( v.IdPlantillaNominaPercepcion) &&
                    v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);
                    

                    var totalViaticos = NominaTrabajador.ListaPercepcionesTrabajadoresViaticos.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);


                    var viaticosmes = NominaTrabajador.ListaPercepcionesTrabajadoresViaticosDelMes.Where(v => 
                       v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                       ).Sum(f => f.Importe);

                    totalViaticos = totalViaticos + viaticosmes;
                   // totalpercepciones = totalpercepciones + totalViaticos;
                    //else
                    //{

                    //    totalpercepciones = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v =>
                    //    percepcionesValidas.Contains(v.IdPlantillaNominaPercepcion) &&
                    //    v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);

                    bool calcularUltimocontratoPartesProporcionales = true;
                    //}
                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                    {
                        var solicitud = NominaTrabajador.Nomina_PartesProporcionales.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                        //aqui solo valida que sea un contrato par aun calculo nada mas por año
                        var ultimocontrato = NominaTrabajador.PartesProporcionalesUltimoContrato.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                         && s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                        if (solicitud != null)
                            if (ultimocontrato == null)
                                calcularUltimocontratoPartesProporcionales = false;
                    }

                        if (totalpercepciones > 0 && calcularUltimocontratoPartesProporcionales)
                    {
                        var existeiSRMISMAQNAAÑO = NominaTrabajador.ListaNominaSueldoValidarIsr.Where(s => s == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                        if (existeiSRMISMAQNAAÑO >0)
                            NominaTrabajador.ExisteNominaSueldoValidarIsr = true;
                        else
                            NominaTrabajador.ExisteNominaSueldoValidarIsr = false;


                        decimal BaseGravable = 0;
                        decimal BaseGravableQuincena = 0;
                        decimal BaseGravableQnaAnterior = 0;
                        List<Configuracion_ctISR> Limites;
                        List<Configuracion_ctSubsidioEmpleo> SubsidioEmpleo;
                        decimal enfermedadgeneraldias = 0, incidencias = 0;

                        decimal LimiteInferior, CantidadSubsidioEmpleoMensual, ExcedenteLimiteInferior, ImpuestoMarginal, ImpuestoCausado;
                        decimal CuotaFija, PorcentajeAplicarseExcedenteLimiteInferior, ImpuestoNeto;
                        string Id = NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes;

                        decimal BaseAguinaldo = 0;
                        decimal BaseAguinaldoConstante = 0;

                        decimal BaseGravableMes = 0;

                        decimal AguinaldoNeto = 0;

                        decimal AguinaldoDiario = 0;

                        decimal AguinaldoMensual = 0;
                        decimal EnfermedadOMaternidadDescuento = 0;

                        bool EsCalulodeAguinaldo= false;

                        bool EsCaluloTitulacion = false;

                        int DiasLaboradosAguinaldo = 0;

                        bool primavacacional = false;

                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PRIMA VACACIONAL"))
                            primavacacional =true;

                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PRESTACIONES ADICIONALES"))
                            {
                            var filtrotit = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(v =>
                   v.Percepciones_ctPercepcion.Percepcion == "TITULACIÓN" 
                  ).Select(s => s.IdPlantillaNominaPercepcion).ToArray();

                            var totalpercepcionestit = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v =>
                            filtrotit.Contains(v.IdPlantillaNominaPercepcion) &&
                            v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria 
                            && v.EsGrabable == true).Sum(f => f.Importe);

                            
                            if (totalpercepcionestit>0)
                                EsCaluloTitulacion=true;
                             }

                        var diastrabajados = NominaTrabajador.ListaAguinaldoTrabajadores.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();


                        if (NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes == "24" && (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AGUINALDO")))
                        {
                            var plantillanominaaguinaldo = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO").FirstOrDefault();

                            var plantillanominaaguinaldoExento = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO EXENTO").FirstOrDefault();
                            if (plantillanominaaguinaldo != null)
                            {
                                var esnominaaguinaldo = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => 
                                v.IdPlantillaNominaPercepcion==plantillanominaaguinaldo.IdPlantillaNominaPercepcion 
                                && v.IdConvenioLaboralTrabajadorCategoria==ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                                var esnominaaguinaldoExento = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v =>
                                v.IdPlantillaNominaPercepcion == plantillanominaaguinaldoExento.IdPlantillaNominaPercepcion
                                && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                                if (esnominaaguinaldo != null)
                                {
                                    VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();
                                    vnt4.Concepto = "DIAS AGUINALDO TRABAJADOS";
                                    vnt4.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    
                                    var diasagui =NominaTrabajador.ListaVariablesNominaTrabajador.Where(
                                        a=> a.Concepto== "DIAS AGUINALDO TRABAJADOS" 
                                        && a.IdConvenioLaboralTrabajadorCategoria== ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                                    ///  AguinaldoNeto = esnominaaguinaldo.Importe + (30 * NominaTrabajador.ctUMA.Monto);

                                    AguinaldoNeto = esnominaaguinaldo.Importe ;


                                    BaseAguinaldo = esnominaaguinaldo.Importe;
                                   
                                    //AguinaldoDiario = BaseAguinaldo / diastrabajados.DiasEfectivosLaborados;
                                    AguinaldoDiario = BaseAguinaldo / diasagui.Importe;

                                    //DiasLaboradosAguinaldo = diastrabajados.DiasEfectivosLaborados;
                                    DiasLaboradosAguinaldo = (int)diasagui.Importe;

                                    AguinaldoMensual = AguinaldoDiario * 30.4M;

                                    EsCalulodeAguinaldo = true;

                                    //valida que exista calculada la 2a qna de sueldo

                                 //var exite2aqnasueldo=   NominaTrabajador.stNominaTrabajadorPercepcionesdelMes.Where(v => v.Plantilla.Contains("SUELDO")
                                 //&& v.QuincenaMes=="24" &&
                                 //v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                                 //   if (exite2aqnasueldo==null)
                                 //       throw new ApplicationException("No existe CÁLCULO DE LA 2A QUINCENA DE SUELDO " + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador + " -- ");
                                }
                            }
                        }

                            //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("K1")
                            //    && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "DOCENTE"
                            //    )
                            //{
                            //    int idpar = Libraries.ConvertToInt.ConvertToInt32(Id)+1;
                            //    if (idpar < 10)
                            //        Id= "0" + idpar.ToString();
                            //    else
                            //        Id = idpar.ToString();
                            //}


                            decimal Salario1aQnaAExcluir = 0m;
                        decimal SalarioBruto = 0M;

                        decimal SalarioBrutoPrimario = 0M;
                        short[] percepcionesmensuales = new short[1000];

                        var idpercepcionesmens = NominaTrabajador.PercepcionPersonalizada.Where(f => f.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL").ToList();
                      
                        if (idpercepcionesmens.Count>0)
                          percepcionesmensuales = idpercepcionesmens.Select(G => G.IdPercepcion).ToArray();

                        percepcionesmensuales = percepcionesmensuales.Where(val => val != 0).ToArray();


                        var quitarDeolucionesPorCreditos = NominaTrabajador.Catalogos_ctTipoCredito.Select(s => s.TipoCredito).ToArray();

                        var iddevolucionpercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(s => !s.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") && (s.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN")).Select(d => d.IdPlantillaNominaPercepcion).ToArray();


                        var plantillasconisr = NominaTrabajador.PlantillaNominaDeduccionesRelacionLaboral.Where(a => a.Deducciones_ctDeduccion.Deduccion == "ISR").Select(s=> s.IdPlantillaNominaDeduccion).ToList();

                        var percepcionespordevoluciondecreditos = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v =>
                         (quitarDeolucionesPorCreditos.Contains(v.Concepto) || v.Concepto.Contains("CRÉDITO"))  && iddevolucionpercepcion.Contains(v.IdPlantillaNominaPercepcion)).Select(s => s.IdPlantillaNominaPercepcion).ToArray();

                        //var enfermedadMes = NominaTrabajador.stNominaTrabajadorDeduccionesdelMes.Where(v => v.Deduccion== "ENFERMEDAD GENERAL"
                        //&& v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                        //&&   plantillasconisr.Contains(v.IdPlantillaNominaDeduccion) ).Sum(f => f.Importe);

                        var enfermedadMes = NominaTrabajador.stNominaTrabajadorDeduccionesdelMes.Where(v => v.Deduccion == "ENFERMEDAD GENERAL"
                        && v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                        && v.Plantilla.Contains("SUELDO") && v.EsCerrada==true).Sum(f => f.Importe);


                        if (Convert.ToInt16(Id) % 2 != 0)
                        {
                            decimal SalarioBruto2 = 0M;
                            if (NominaTrabajador.ExisteNominaSueldoValidarIsr)
                            {
                                  SalarioBruto2 = NominaTrabajador.stNominaTrabajadorPercepcionesdelMes.Where(v =>
                                v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(f => f.Importe);

                            }

                            SalarioBruto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => !percepcionesmensuales.Contains(v.IdPercepcion) 
                            && !percepcionespordevoluciondecreditos.Contains(v.IdPlantillaNominaPercepcion) && 
                            v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);

                            SalarioBruto = SalarioBruto - totalpercepcionesExcluir1aQna;

                            var basicas = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(a => a.IdPlantillaNomina == NominaTrabajador.Nomina_stNomina.IdPlantillaNomina
                            && a.Percepciones_ctPercepcion.BasePrimaria == true).ToList();

                            //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
                            if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT")
                    || ((NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("BASE")
                    || NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SPD")) &&
                     NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO"))
                            {
                                SalarioBrutoPrimario = NominaTrabajador.stNominaTrabajadorPercepcionesdelMesCCT.Where(v =>
                                v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                                && v.BasePrimaria==true 
                                ).Sum(f => f.Importe);
                            }
                            else
                            {
                                SalarioBrutoPrimario = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v =>
                                v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                 && !percepcionespordevoluciondecreditos.Contains(v.IdPlantillaNominaPercepcion)
                                && basicas.Select(x => x.IdPlantillaNominaPercepcion).Contains(v.IdPlantillaNominaPercepcion)).Sum(f => f.Importe);

                                if (totalpercepcionesOtroCalculoMismaNomina > 0)
                                    SalarioBrutoPrimario = SalarioBrutoPrimario + totalpercepcionesOtroCalculoMismaNomina;
                            }

                            Salario1aQnaAExcluir = totalpercepcionesExcluir1aQna;


                            if ((NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO" &&
                                NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("BASE") ||
                              ( (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina == "EXTRAORDINARIA"
                              || NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("RDL"))
                              || NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
                              
                               &&
                                NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("BASE"))

                                && !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("DEFINITIVO")
                                && !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SPD") 
                                 )
                            {
                                var baseodes = NominaTrabajador.stNominaTrabajadorBasesGravabelesdelMes.Where(v =>
                             v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                             && v.Plantilla.Contains("ODES")).Sum(f => f.BaseGravable);

                                var baseCCT = NominaTrabajador.stNominaTrabajadorBasesGravabelesdelMes.Where(v =>
                          v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                          && v.Plantilla.Contains("CCT")).Sum(f => f.BaseGravable);
                                if (baseCCT > 0)
                                    SalarioBruto2 = baseodes + (baseCCT - baseodes);
                                else
                                    SalarioBruto2 = baseodes;
                            }
                            else {
                                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("HORAS EXTRAORD")
                                    && Convert.ToInt16(Id) % 2 != 0)
                                    {
                                    SalarioBruto2 = NominaTrabajador.stNominaTrabajadorBasesGravabelesdelMes.Where(v =>
                                  v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(f => f.BaseGravable);
                                }
                                else
                                if (Convert.ToInt16(Id) % 2 == 0)
                                {
                                    SalarioBruto2 = NominaTrabajador.stNominaTrabajadorBasesGravabelesdelMes.Where(v =>
                                  v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(f => f.BaseGravable);
                                }

                            }

                            BaseGravableMes = SalarioBruto2;
                            //se quito caso magaña que le sumaba 130 de ayuda para transporte
                            //quiencena 01 ene 2024
                            //var SalarioBruto2 = NominaTrabajador.stNominaTrabajadorPercepcionesdelMes.Where(v => !percepcionesmensuales.Contains(v.IdPercepcion)
                            //&& v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(f => f.Importe);

                            basegravablemismanomina = NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "BASEGRAVABLEMISMANOMINA" && a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(a=> a.Importe);

                            SalarioBruto = SalarioBruto+  basegravablemismanomina;


                            //si es una nomina que se calcula cuado ya esta cerrado todo el mes se verifica si es le primer qna
                            // y no se toma todas las percepciones del mes
                             


                            if (enfermedadMes > 0 && NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo=="NORMAL"
                                && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Orden == 1)
                            {
                                var percepcionesespeciales = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.TratamientoEspecialIncapacidadesSueldoIsr== true).Sum(f => f.Importe);
                                
                                enfermedadMes = enfermedadMes - percepcionesespeciales;
                                SalarioBruto2 = SalarioBruto2 - enfermedadMes;

                               // var valoresEspeciales = NominaTrabajador.PrestacionesIncapacidadesSueldoIsr(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria);
                               // SalarioBruto2 = SalarioBruto2 - valoresEspeciales;
                            }

                            
                            //if (NominaTrabajador.EsRecalculoPorTrabajador==false && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Nomina_ctTipoNomina.TipoNomina == "EXTRAORDINARIA")
                            //{
                            //    SalarioBruto = SalarioBruto2;
                            //}
                               
                            else
                                if (NominaTrabajador.EsRecalculoPorTrabajador == false)
                                SalarioBruto = SalarioBruto + SalarioBruto2;

                        }
                        else
                        {
                           
                            SalarioBruto = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => 
                            v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                             && !percepcionespordevoluciondecreditos.Contains(v.IdPlantillaNominaPercepcion) 
                            && v.EsGrabable == true).Sum(f => f.Importe);


                            decimal SalarioBruto2 = 0;
                            if (EsCalulodeAguinaldo)
                            {
                                var idperaguinaldo = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(s => 
                                (s.Percepciones_ctPercepcion.Percepcion.Contains("SUELDO") 
                                || s.Percepciones_ctPercepcion.Percepcion.Contains("QUINQUENIO")
                                || s.Percepciones_ctPercepcion.Percepcion.Contains("EFICIENCIA EN EL TRABAJO")
                                || s.Percepciones_ctPercepcion.Percepcion.Contains("AYUDA PARA TRANSPORTE")
                                || s.Percepciones_ctPercepcion.Percepcion.Contains("MATERIAL DIDACTICO")
                                || s.Percepciones_ctPercepcion.Percepcion.Contains("GASTO ADMINISTRATIVO")
                  
                                || s.Percepciones_ctPercepcion.Percepcion.Contains("APOYO ZONA MARGINAL")
                                || s.Percepciones_ctPercepcion.Percepcion.Contains("PRIMA DOMINICAL GRAVADA")
                                || s.Percepciones_ctPercepcion.Percepcion.Contains("DIA DE DESCANSO")
                                )).Select(d => d.IdPlantillaNominaPercepcion).ToArray();

                                SalarioBruto2 = NominaTrabajador.stNominaTrabajadorPercepcionesdelMes.Where(v =>
                                 idperaguinaldo.Contains(v.IdPlantillaNominaPercepcion) && v.Plantilla.Contains("SUELDO") &&
                              v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(f => f.Importe);

                                //SalarioBruto2 = SalarioBruto2 +NominaTrabajador.stNominaTrabajadorPercepcionesdelMesCCT.Where(v =>
                                // v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(f => f.Importe);
                            }
                            else

                                SalarioBruto2 = NominaTrabajador.stNominaTrabajadorPercepcionesdelMes.Where(v =>
                                  v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(f => f.Importe);

                            //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                            //    SalarioBruto2 = 0;

                                basegravablemismanomina = NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.Concepto == "BASEGRAVABLEMISMANOMINA" && a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(a => a.Importe);

                            SalarioBruto = SalarioBruto + basegravablemismanomina;

                            if (enfermedadMes > 0 &&  NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "NORMAL" 
                                )
                                
                            {
                               // var percepcionesespeciales = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.TratamientoEspecialIncapacidadesSueldoIsr == true).Sum(f => f.Importe);
                       
                                //enfermedadMes= enfermedadMes- percepcionesespeciales;
                                //caso saolo se quito la lina de arriba

                                SalarioBruto2 = SalarioBruto2 - enfermedadMes;

                                
                            }
                            //para nominas exraordinarias y qeu no existan u calculo de sueldo
                            // se genera una formula alterna

                            // caso ide 1784 beatriz 28 sep 2022 nomina de prestaciones adicionales
                            // la base gravable se le suma a sus prestaciones , selemina la ultima condicion
                            //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Nomina_ctTipoNomina.TipoNomina == "EXTRAORDINARIA"
                            //    && NominaTrabajador.ExisteNominaSueldoValidarIsr == false && EsCalulodeAguinaldo == false
                            //    && !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))

                                if ((NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina == "EXTRAORDINARIA"  
                                || NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("RDL"))
                                && NominaTrabajador.ExisteNominaSueldoValidarIsr==false && EsCalulodeAguinaldo==false
                                && !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES")
                                && !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PRESTACIONES ADICIONALES")
                                )
                            {
                                 
                                SalarioBruto = SalarioBruto2;
                                
                            }
                            else
                            {
                                if (EsCalulodeAguinaldo)
                                {
                                    SalarioBruto = AguinaldoMensual;
                                    BaseAguinaldoConstante = SalarioBruto2;
                                }

                                    SalarioBruto = SalarioBruto + SalarioBruto2;
                            }
                        }

                        //disminucion de base gravable



                        var percepcionesDisminucion = NominaTrabajador.PlantillaNominaDeduccionesRelacionLaboral.Where(c =>
                       c.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO"
                       || c.Deducciones_ctDeduccion.Deduccion.Contains("FALTA")
                       

                   ).Select(x => x.IdPlantillaNominaDeduccion).ToArray();

                        decimal Totaldisminucion = 0;
                        if (Convert.ToInt16(Id) % 2 == 0)
                        {
                             Totaldisminucion = NominaTrabajador.Suma(NominaTrabajador.stNominaTrabajadorDeduccionesdelMes.Where(v =>
                         percepcionesDisminucion.Contains(v.IdPlantillaNominaDeduccion)
                          &&
                        v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList());

                            var TotaldisminucionQna = NominaTrabajador.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(v =>
                        percepcionesDisminucion.Contains(v.IdPlantillaNominaDeduccion)
                         &&
                       v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList());

                            Totaldisminucion = Totaldisminucion + TotaldisminucionQna;
                        }
                        else
                        {
                             Totaldisminucion = NominaTrabajador.Suma(NominaTrabajador.ListaDeduccionesTrabajadores.Where(v =>
                         percepcionesDisminucion.Contains(v.IdPlantillaNominaDeduccion)
                          &&
                        v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList());
                        }

                        SalarioBruto = SalarioBruto - Totaldisminucion;

                        SalarioBruto = SalarioBruto - NominaTrabajador.TrabajadorTotalPercepcionesGuarderiaOrdinarias;

                        // SalarioBruto = SalarioBruto + totalViaticos;




                        var idenfgral = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ENFERMEDAD GENERAL").FirstOrDefault();
                        
                        var enfermedadgeneralTermino = NominaTrabajador.ListaVariablesNominaTrabajador.Where(j => j.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                           && j.Concepto == "ENFERMEDADGENERAL_TERMINO").FirstOrDefault();

                        if (idenfgral != null && NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "NORMAL" 
                            && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Orden == 1)
                        {
                         var existeenfgfraltermino=  NominaTrabajador.ListaDeduccionesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                            && a.IdPlantillaNominaDeduccion == idenfgral.IdPlantillaNominaDeduccion).FirstOrDefault();
                            if (existeenfgfraltermino != null)
                            {
                                SalarioBruto = SalarioBruto - existeenfgfraltermino.Importe;
                                EnfermedadOMaternidadDescuento = existeenfgfraltermino.Importe;
                            }
                        }

                        //si tiene un updatesaldo en 0 espro qeu acabo
                        var enfermedadgeneralMaternidadTermino = NominaTrabajador.ListaVariablesNominaTrabajador.Where(j => j.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                           && j.Concepto == "INCIDENCIA_SALDO_UPDATE" && j.Importe==0).FirstOrDefault();

                        var iddeducincapac = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "RIESGO DE TRABAJO"
                         || x.Deducciones_ctDeduccion.Deduccion == "MATERNIDAD").Select(s=> s.IdPlantillaNominaDeduccion).ToArray();


                        var maternidadMes = NominaTrabajador.stNominaTrabajadorDeduccionesdelMes.Where(v => v.Deduccion == "MATERNIDAD"
                        && v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                        && v.Plantilla.Contains("SUELDO") && v.EsCerrada == true).Sum(f => f.Importe);

                        if (maternidadMes > 0)
                        {
                            SalarioBruto = SalarioBruto - maternidadMes;
                            EnfermedadOMaternidadDescuento = maternidadMes;
                        }

                        var RiesgoMes = NominaTrabajador.stNominaTrabajadorDeduccionesdelMes.Where(v => v.Deduccion == "RIESGO DE TRABAJO"
                        && v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                        && v.Plantilla.Contains("SUELDO") && v.EsCerrada == true).Sum(f => f.Importe);

                        if (RiesgoMes > 0)
                        {
                            SalarioBruto = SalarioBruto - RiesgoMes;
                            
                            EnfermedadOMaternidadDescuento = RiesgoMes;
                        }

                        if (enfermedadgeneralMaternidadTermino != null)
                        {//busca el importe que termino de la incapacidad de riesgo o maternidad


                            var datosincap = NominaTrabajador.ListaDeduccionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria &&
                              iddeducincapac.Contains(q.IdPlantillaNominaDeduccion)).FirstOrDefault();

                            if (datosincap != null && NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "NORMAL"
                                && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Orden == 1)
                            {
                                SalarioBruto = SalarioBruto - datosincap.Importe;
                                EnfermedadOMaternidadDescuento = datosincap.Importe;
                            }
                        }



                        if (enfermedadgeneralTermino!=null && NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "NORMAL" 
                            && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Orden == 1)
                            SalarioBruto = SalarioBruto - enfermedadgeneralTermino.Importe;
                        //}0

                        if (SalarioBruto < 0)
                            SalarioBruto = 0;

                        decimal ImporteIsrAnterior = 0;

                        bool esbajaContrato = false;

                        //aplica solo para contratos
                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "CONTRATO")
                        {
                            if (ConvenioLaboralTrabajadorCategoria.FechaTermino != null)
                                if (ConvenioLaboralTrabajadorCategoria.FechaTermino >= NominaTrabajador.Nomina_stNomina.FechaInicio &&
                                    ConvenioLaboralTrabajadorCategoria.FechaTermino <= NominaTrabajador.Nomina_stNomina.FechaTermino)
                                {
                                    var existecontinuidad = NominaTrabajador.ConveniosTrabajadoresTodos.Where(z => z.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                                    && z.FechaInicio == ConvenioLaboralTrabajadorCategoria.FechaTermino.Value.AddDays(1)
                                    ).ToList();
                                    if (existecontinuidad.Count==0)
                                        esbajaContrato = true;
                                }
                                else
                                    if (ConvenioLaboralTrabajadorCategoria.FechaTermino <= NominaTrabajador.Nomina_stNomina.FechaInicio)
                                    esbajaContrato = true;

                        }
                        else {
                            if (Convert.ToInt16(Id) % 2 != 0)
                            {
                                var existerenuncia = NominaTrabajador.BajasPorRenunciasEnlaQuincena.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                                if (existerenuncia!=null)
                                esbajaContrato = true;

                            }                        }


                        decimal ImporteRDL = 0;
                        decimal ImporteRDLIsr = 0;
                        var tienerdl = NominaTrabajador.PercepcionPersonalizada.Where(f => f.Percepciones_ctPercepcion.Percepcion == "REMUNERACIÓN AL DESEMPEÑO LABORAL").FirstOrDefault();
                        var ISRrdl = NominaTrabajador.getDeduccionesPersonalizadas().Where(f => f.IdConvenioLaboralTrabajadorCategoria==ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        && f.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault();


                        if (Convert.ToInt16(Id) % 2 == 0 || EsCalulodeAguinaldo)
                        {
                            
                            if (tienerdl != null)
                                ImporteRDL = tienerdl.Importe;

                            if (ISRrdl != null)
                                ImporteRDLIsr = ISRrdl.Importe;

                        }

                        if (Convert.ToInt16(Id) % 2 != 0)
                        {
                            if ((NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina == "EXTRAORDINARIA"
                                || NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("RDL"))
                                || NominaTrabajador.EsRecalculoPorTrabajador
                               )
                            //   BaseGravable = (SalarioBruto) + totalpercepciones+ ImporteRDL; // para el cálculo del isr se multiplica por 2
                            {
                                //BaseGravableQuincena = SalarioBruto + totalpercepciones + ImporteRDL + Salario1aQnaAExcluir;
                                //05 feb 2021 se quita el drl por que nu cuadar en mandos medios el isr
                                //BaseGravableQuincena = SalarioBruto + totalpercepciones +Salario1aQnaAExcluir;
                                if (NominaTrabajador.ExisteNominasCerradasEntodoElMes && !NominaTrabajador.EsRecalculoPorTrabajador)
                                    BaseGravable = BaseGravableQuincena;
                                else
                                {
                                    //BaseGravable = (SalarioBruto * 2) + totalpercepciones + ImporteRDL + Salario1aQnaAExcluir; // para el cálculo del isr se multiplica por 2
                                    BaseGravable = SalarioBrutoPrimario + SalarioBruto +  ImporteRDL + Salario1aQnaAExcluir;
                                    if (NominaTrabajador.EsRecalculoPorTrabajador)
                                    {
                                        BaseGravableQuincena = SalarioBruto;
                                    }
                                }
                            }
                            else
                            {
                                if (esbajaContrato)
                                {
                                    BaseGravableQuincena = SalarioBruto + totalViaticos;
                                    BaseGravable = SalarioBruto + totalViaticos;
                                }
                                else
                                {
                                    //05 feb 2021 se quita el drl por que nu cuadar en mandos medios el isr
                                    //BaseGravableQuincena = SalarioBruto  + totalViaticos + ImporteRDL + Salario1aQnaAExcluir;


                                      //BaseGravableQuincena = SalarioBruto + totalViaticos + Salario1aQnaAExcluir;
                                      BaseGravableQuincena = SalarioBruto +  Salario1aQnaAExcluir;
                                    //BaseGravable = (SalarioBruto * 2) + totalViaticos + ImporteRDL + Salario1aQnaAExcluir; // para el cálculo del isr se multiplica por 2
                                   // if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("ODES"))
                                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("SUELDO")
                                        && NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo!="RETROACTIVO"
                                        && !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
                                        BaseGravable = SalarioBrutoPrimario + SalarioBruto + totalViaticos+ ImporteRDL + Salario1aQnaAExcluir;
                                    else
                                    //    BaseGravable = SalarioBruto + totalViaticos + ImporteRDL + Salario1aQnaAExcluir;
                                        BaseGravable = SalarioBruto +  ImporteRDL + Salario1aQnaAExcluir;
                                    
                                }
                            }
                        }
                        else
                        {
                            if ((NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina == "EXTRAORDINARIA"
                                || NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("RDL"))
                               && NominaTrabajador.ExisteNominaSueldoValidarIsr == false && EsCalulodeAguinaldo== false 
                               && !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES")
                               && !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PRESTACIONES ADICIONALES"))
                            {
                                BaseGravableQuincena = SalarioBruto  + totalpercepciones;
                                //BaseGravable = (SalarioBruto * 2) + totalpercepciones; // para el cálculo del isr se multiplica por 2
                                if (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina == "EXTRAORDINARIA")
                                    BaseGravable = totalpercepciones + SalarioBruto;
                                else
                                    BaseGravable = SalarioBrutoPrimario + SalarioBruto ;
                            }
                            else 
                            { 
                                DapperQuery dp = new DapperQuery("bdNovaEntities");
                                int idqna = System.Convert.ToInt32(NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes) - 1;
                                int añoqna = NominaTrabajador.Nomina_stNomina.Año;
                                string qnames = "";
                                if (idqna == 0)
                                {
                                    qnames = "24";
                                    añoqna = añoqna - 1;
                                }
                                else { qnames = idqna.ToString().PadLeft(2, '0'); }

                                //                            var tmpIsrAnterior = getBaseGravableQuincenaAnterior(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, qnames, añoqna);

                                //                            if (tmpIsrAnterior != null)
                                //                            {

                                //                                ImporteIsrAnterior = tmpIsrAnterior.Importe;
                                //                            }

                                //                            try
                                //                            {


                                //                                string query = @"select a.IdNominaTrabajador,a.IdNomina,a.IdConvenioLaboralTrabajadorCategoria,a.SueldoBruto,a.SueldoDiario
                                //,a.SueldoNeto,a.SueldoTransferencia,a.SueldoMonedero,a.IdTrabajadorCuentasTransferencia,a.IdTrabajadorCuentasMonedero,a.HorasSemanaMes
                                //,a.HorasSemanaMesTrabajadas,a.HorasExcedentes,a.HorasTrabajadasExcedentes,a.HorasInterinas,a.HorasTrabajadasInterinas,a.DiasEfectivosLaborados,a.CostoPorHora
                                //,a.CostoPorHoraExcedente
                                // ,a.CostoPorHorasInterinas
                                // ,a.SalarioDiarioIntegrado
                                // ,a.QuinquenioDiario
                                // ,a.MaterialDidacticoDiario
                                // ,a.SueldoBrutoQuinquenioDiario
                                //  ,a.SumaPercepcionesVariables
                                // ,a.BaseGravable
                                // ,a.HorasEfectivasDeTrabajo
                                // ,a.EsHorarioSinCambios
                                // ,a.SalarioBrutoGravable
                                // ,a.SubsidioEmpleoMensual
                                // ,a.Isr
                                // ,a.IsrRdl
                                // ,a.Rdl
                                // ,a.CantidadSubsidioEmpleoMensual
                                // ,a.EsHorarioAnterior
                                // ,a.EsHorarioAjustado from Nomina_stNominaTrabajador a 
                                //  inner join  Convenios_stConvenioLaboralTrabajadorCategoria b on a.IdConvenioLaboralTrabajadorCategoria=b.IdConvenioLaboralTrabajadorCategoria
                                //  inner join Convenios_stConvenioLaboralTrabajador c on b.IdConvenioLaboralTrabajador=c.IdConvenioLaboralTrabajador
                                //  inner join Nomina_stNomina d on d.IdNomina=a.IdNomina 
                                //  inner join Catalogos_ctQuincenaMes e on e.IdQuincenaMes=d.IdQuincenaMes
                                //   inner join Nomina_stNominaTrabajadorEstatus xx on xx.IdNominaTrabajadorEstatus=a.IdNominaTrabajadorEstatus
                                //  where xx.EstatusNomina<>'CANCELADO' AND c.IdTrabajador=" + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador.ToString() + " and d.Año=" + NominaTrabajador.Nomina_stNomina.Año.ToString() + " and e.QuincenaMes=" + idqna;
                                //                                List<Nomina_stNominaTrabajador> datos = (List<Nomina_stNominaTrabajador>)dp.connection.Query<Nomina_stNominaTrabajador>(query);
                                //                                if (datos.Count > 0)

                                //                                    BaseGravableQnaAnterior = datos.Sum(r => r.BaseGravable) / 2;

                                //                            }
                                //                            catch (Exception ww)
                                //                            {

                                //                                var ttt = ww;
                                //                            }


                                //if (EsCalulodeAguinaldo)
                                //{
                                //    BaseGravableQuincena = SalarioBruto+ImporteRDL;
                                //    BaseGravable = SalarioBruto + ImporteRDL;
                                //}
                                //else
                                //{
                                //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PRESTACIONES ADICIONALES"))
                                //    SalarioBruto = SalarioBruto + totalpercepciones;

                                    BaseGravableQuincena = SalarioBruto + totalViaticos;
                                    BaseGravable = SalarioBruto + totalViaticos;
                               // }

                                dp.Close();
                         }
                        }



                        //Limites = NominaTrabajador.ISR.Where(i => i.LimiteSuperior >= BaseGravable && i.LimiteInferior <= BaseGravable).ToList();

                        //LimiteInferior = Limites.Select(y => y.LimiteInferior).SingleOrDefault();
                        //ExcedenteLimiteInferior = BaseGravable - LimiteInferior;
                        //PorcentajeAplicarseExcedenteLimiteInferior = Limites.Select(y => y.PorcentajeAplicarseExcedenteLimiteInferior).SingleOrDefault() / 100;
                        //ImpuestoMarginal = ExcedenteLimiteInferior * PorcentajeAplicarseExcedenteLimiteInferior;
                        //CuotaFija = Limites.Select(y => y.CuotaFija).SingleOrDefault();
                        //ImpuestoNeto = ImpuestoMarginal + CuotaFija;

                        //SubsidioEmpleo = NominaTrabajador.SubsidioEmpleo.Where(s => s.IngresosHasta >= BaseGravable && s.IngresosDesde <= BaseGravable).ToList();

                        //CantidadSubsidioEmpleoMensual = SubsidioEmpleo.Select(c => c.Subsidio).SingleOrDefault(); // Guardar en tabla
                        //ImpuestoCausado = ImpuestoNeto - CantidadSubsidioEmpleoMensual;
                        ImpuestoCausado = 0;
                         
                            //if (BaseGravable > NominaTrabajador.Nomina_ConfiguracionSubsidioTrabajador.FirstOrDefault().Limite)
                            //{
                                ImpuestoCausado = generarImpuestoCausado(BaseGravable, NominaTrabajador, ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria);

                        if (idotracategoria!=null)
                            {

                            
                            var IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault().IdPlantillaNominaDeduccion;





                            var isryacobrado=NominaTrabajador.ListaDeduccionesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == idotracategoria.IdConvenioLaboralTrabajadorCategoria
                            && a.IdPlantillaNominaDeduccion == IdPlantillaNominaDeduccion).FirstOrDefault();
                            if (isryacobrado != null)
                            {
                                ImpuestoCausado = ImpuestoCausado - isryacobrado.Importe;
                            }

                        }
                        //}
                        //else
                        //{
                        //    if (Convert.ToInt16(Id) % 2 != 0)
                        //        ImpuestoCausado = 0;
                        //}

                        //ImpuestoCausado = generarImpuestoCausado(BaseGravable, NominaTrabajador, ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria);


                        VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
                        vnt1.Concepto = "BASE GRAVABLE";
                        vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt1.Importe = BaseGravable;
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt1);

                        decimal Isrtotal = 0;


                        //var idsubsidiopercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(s => !s.Nomina_ctPlantillaNomina.Plantilla.Contains("PROPORCIONALES") 
                        //&& (s.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO")).Select(d => d.IdPlantillaNominaPercepcion).FirstOrDefault();



                        decimal isrtotalpagadoMes = 0;
                        if (enfermedadMes > 0 || EnfermedadOMaternidadDescuento > 0)
                        {
                            if (EsCalulodeAguinaldo)
                                isrtotalpagadoMes = NominaTrabajador.stNominaTrabajadorISRdelMes.Where(v => 
                                v.Plantilla.Contains("SUELDO") &&
                         v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                         && v.EsCerrada == true).Sum(r => r.Importe);
                            else
                            isrtotalpagadoMes = NominaTrabajador.stNominaTrabajadorISRdelMes.Where(v =>
                         v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                         && v.EsCerrada == true).Sum(r => r.Importe);
                        }
                        else
                        {
                            if (EsCalulodeAguinaldo)
                                isrtotalpagadoMes = NominaTrabajador.stNominaTrabajadorISRdelMes
                                    .Where(v => v.Plantilla.Contains("SUELDO") &&  
                                    v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(r => r.Importe);
                            else
                                isrtotalpagadoMes = NominaTrabajador.stNominaTrabajadorISRdelMes.Where(v => v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(r => r.Importe);
                        }

                        if (NominaTrabajador.EsRecalculoPorTrabajador)
                        {
                            DapperQuery dp = new DapperQuery("bdNovaEntities");

                           
                            string query = $@" select t.IdConvenioLaboralTrabajadorCategoria,r.IdTrabajador,m.IdDeduccion,m.Deduccion,Importe,w.EsCerrada,Plantilla from Deducciones_stNominaTrabajadorDeduccion x
            
            inner join Nomina_stNominaTrabajador s on s.IdNominaTrabajador=x.IdNominaTrabajador
             inner join Nomina_stNomina w on w.IdNomina=s.IdNomina
inner join Convenios_stConvenioLaboralTrabajadorCategoria t on t.IdConvenioLaboralTrabajadorCategoria=s.IdConvenioLaboralTrabajadorCategoria
			inner join Convenios_stConvenioLaboralTrabajador r on r.IdConvenioLaboralTrabajador =t.IdConvenioLaboralTrabajador
              inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=s.IdNominaTrabajadorEstatus
    inner join Nomina_stNominaTrabajadorEstatusGrupo gn on gn.IdNominaTrabajadorEstatusGrupo=q.IdNominaTrabajadorEstatusGrupo
            inner join Deducciones_stPlantillaNominaDeducciones c on c.IdPlantillaNominaDeduccion=x.IdPlantillaNominaDeduccion
 inner join Nomina_ctPlantillaNomina k on k.IdPlantillaNomina=c.IdPlantillaNomina
 inner join Deducciones_ctDeduccion m on m.IdDeduccion=c.IdDeduccion
            where  k.Plantilla not LIKE '%AGUINALDO%' and  year(w.FechaTermino)={NominaTrabajador.Nomina_stNomina.Año} 
            and w.FechaTermino='{NominaTrabajador.Nomina_stNomina.FechaTermino.ToString("yyyyMMdd")}'
            and w.FechaInicio='{NominaTrabajador.Nomina_stNomina.FechaInicio.ToString("yyyyMMdd")}'
and w.IdPlantillaNomina={NominaTrabajador.Nomina_stNomina.IdPlantillaNomina}
                 and  EstatusNominaGrupo ='PARA PAGO'
            and  Deduccion = 'ISR' and t.IdConvenioLaboralTrabajadorCategoria={ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria} " ;

                            var isrcancelado = (List<DeduccionesTrabajadorMes>)dp.connection.Query<DeduccionesTrabajadorMes>(query);
                            if (isrcancelado.Count() > 0)
                            {
                                if (NominaTrabajador.Nomina_stNomina.Año == 2025
                                    && NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "02")
                                {
                                    isrtotalpagadoMes = 0;
                                    ImpuestoCausado = isrcancelado[0].Importe;
                                }
                                else
                                    isrtotalpagadoMes = isrtotalpagadoMes - isrcancelado[0].Importe;
                            }
                                dp.Close();

                        }
                        var isrmismanomina = NominaTrabajador.ListaVariablesNominaTrabajador.Where(a =>
                         a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador &&
                         a.Concepto == "Isr" &&
                         a.IdConvenioLaboralTrabajadorCategoria != ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(s => s.Importe);
                        isrtotalpagadoMes = isrtotalpagadoMes + isrmismanomina;

                        bool isrcalculado = false;
                        if (Convert.ToInt16(Id) % 2 != 0)
                        {
                            //se comento esta a para la 2a qna de febrero 2021 ejemplo el chava
                            //if (ImporteRDL > 0)
                            //{
                            //ImpuestoCausado = ImpuestoCausado - ImporteRDLIsr;
                            //}
                          


                            try
                            {



                                //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA" || primavacacional)
                                    if (Convert.ToInt16(Id) % 2 != 0 || primavacacional)
                                    //{ Isrtotal = ImpuestoCausado / 2;}
                                    {
                                     
                                    if (primavacacional)
                                    {
                                        var Isregla3r = ImpuestoCausado / BaseGravable;
                                        Isrtotal = Isregla3r * (totalpercepciones);
                                        //Isrtotal = ImpuestoCausado - (isrtotalpagadoMes * 2);

                                    }
                                    else
                                    {
                                        //if (!NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("ODES") 
                                        //    && !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("MANDO MEDIO SUELDO")
                                        //    || ( NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO"))
                                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Orden>1 
                                            || NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO")
                                        {
                                            var ImpuestoMes = generarImpuestoCausado(BaseGravableMes, NominaTrabajador, ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria);

                                            bool entroasubsidio = false;
                                            
                                            if (BaseGravableMes<=NominaTrabajador.Nomina_ConfiguracionSubsidioTrabajador.FirstOrDefault().Limite)
                                            {
                                                var subsidio = Math.Round((NominaTrabajador.ctUMA.Monto * 30.4M) * (NominaTrabajador.Nomina_ConfiguracionSubsidioTrabajador.FirstOrDefault().PorcentajeUma/100), 2);

                                                var diferenciasubsidio = ImpuestoMes - subsidio;

                                                if (diferenciasubsidio > 0)
                                                {
                                                    ImpuestoMes = diferenciasubsidio;
                                                    entroasubsidio = true;
                                                }
                                            }


                                            bool divide = true;
                                            //Isrtotal = ImpuestoCausado - (isrtotalpagadoMes );
                                            if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("BASE")
                                                ||  NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("SPD"))                                               
                                                {
                                                
                                                    divide = false;
                                            }

                                            if (entroasubsidio)
                                                ImpuestoCausado = ImpuestoMes;
                                            else
                                                Isrtotal = (ImpuestoCausado - (ImpuestoMes));


                                            if ((NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo == "RETROACTIVO"
                                                && 
                                                divide) || (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("HORAS EXTRAORDINARIAS"))
                                                )
                                            { 
                                                Isrtotal = Isrtotal / 2; 
                                            }
                                        }
                                        else
                                        {
                                            if (BaseGravable <= NominaTrabajador.Nomina_ConfiguracionSubsidioTrabajador.FirstOrDefault().Limite)
                                            {
                                                var subsidio = Math.Round((NominaTrabajador.ctUMA.Monto * 30.4M) * (NominaTrabajador.Nomina_ConfiguracionSubsidioTrabajador.FirstOrDefault().PorcentajeUma / 100), 2);

                                                var diferenciasubsidio = ImpuestoCausado - subsidio;

                                                if (diferenciasubsidio > 0)
                                                    ImpuestoCausado = diferenciasubsidio;
                                                else
                                                    ImpuestoCausado = 0;
                                            }
                                            var Isregla3r = ImpuestoCausado / BaseGravable;
                                            Isrtotal = Isregla3r * (BaseGravableQuincena);
                                            //Isrtotal = Isregla3r * (BaseGravableQuincena - totalViaticos);
                                        }
                                    }

                                    isrcalculado = true;

                                }
                            }
                            catch (Exception es)
                            {

                                var d = 0;
                            }
                        }
                        else
                        {
                            //var subsidiopagadoMes = NominaTrabajador.stNominaTrabajadorPercepcionesSubsidiodelMes.Where(v => v.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(r => r.Importe);
                            //isrtotalpagadoMes = isrtotalpagadoMes + subsidiopagadoMes;
                            if (BaseGravable <= NominaTrabajador.Nomina_ConfiguracionSubsidioTrabajador.FirstOrDefault().Limite)
                            {
                                var subsidio = Math.Round((NominaTrabajador.ctUMA.Monto * 30.4M) * (NominaTrabajador.Nomina_ConfiguracionSubsidioTrabajador.FirstOrDefault().PorcentajeUma / 100), 2);

                                var diferenciasubsidio = ImpuestoCausado - subsidio;

                                if (diferenciasubsidio > 0)

                                    ImpuestoCausado = diferenciasubsidio;

                                else
                                {
                                    ImpuestoCausado = 0;

                                    //PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


                                    //percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    //percepcion.IdNomina = NominaTrabajador.IdNomina;
                                    //percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().IdPlantillaNominaPercepcion;
                                    //percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;


                                    //percepcion.Importe = subsidio;


                                    //percepcion.Tipo = "NORMAL";
                                    //percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                    //percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                    //NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);
                                }
                            }
                        }



                        if (Isrtotal == 0)
                            {
                                Isrtotal = ImpuestoCausado;
                            Isrtotal = Isrtotal - isrtotalpagadoMes;
                            isrcalculado = true;
                            }

                        //if (esbajaContrato)
                        //{
                        //    Isrtotal = Isrtotal - isrtotalpagadoMes;
                        //    isrcalculado = true;
                        //}

                        //
                        // se guarda la base gravable por si hay mas de 2 pagos en la misma nomina
                        VariablesNominaTrabajador vnt44 = new VariablesNominaTrabajador();
                        vnt44.Concepto = "BASEGRAVABLEMISMANOMINA";
                        vnt44.IdTrabajador= ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                        vnt44.Importe = totalpercepciones;
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt44);

                        if (Isrtotal < 0 && 
                            (NominaTrabajador.Nomina_stNomina.FechaTermino.Year<2025 &&
                            NominaTrabajador.Nomina_stNomina.FechaTermino.Month <5) )
                        {
                            bool seagrega = true;
                            //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Nomina_ctTipoNomina.TipoNomina == "EXTRAORDINARIA")
                                if (Convert.ToInt16(Id) % 2 != 0 )
                                if (!NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                                    seagrega = false;

                            if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))
                                seagrega = true;

                            if (seagrega)
                                    {

                                    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


                                    percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    percepcion.IdNomina = NominaTrabajador.IdNomina;
                                    percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().IdPlantillaNominaPercepcion;
                                    percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                                    if (NominaTrabajador.Nomina_stNomina.Año == 2020 && NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "11")
                                        percepcion.Importe = 0;
                                    else percepcion.Importe = Isrtotal * -1;


                                    percepcion.Tipo = "NORMAL";
                                    percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                    percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);


                                }
                        }
                        else
                        {

                            //var isrtotalpagadoMes = NominaTrabajador.stNominaTrabajadorISRdelMes.Where(v => v.IdTrabajador== ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Sum(r => r.Importe);
                            //var isrmismanomina= NominaTrabajador.ListaVariablesNominaTrabajador.Where(a=>
                            //a.IdTrabajador== ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador &&
                            //a.Concepto=="Isr" &&
                            //a.IdConvenioLaboralTrabajadorCategoria!= ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(s=> s.Importe);
                            //isrtotalpagadoMes = isrtotalpagadoMes + isrmismanomina;

                             
                            if (( (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina == "EXTRAORDINARIA"
                                || NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("RDL"))
                        && (NominaTrabajador.ExisteNominaSueldoValidarIsr == false
                        || NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.Catalogos_ctRelacionLaboral.RelacionLaboral == "DOCENTE" 
                        && Convert.ToInt16(Id) % 2 != 0)
                        && EsCalulodeAguinaldo == false
                        || (Convert.ToInt16(Id) % 2 != 0 && primavacacional))

                        )
                            {
                                if (NominaTrabajador.ExisteNominasCerradasEntodoElMes==false)
                                    isrtotalpagadoMes = isrtotalpagadoMes * 2;
                            }


                            if (primavacacional == false && !isrcalculado ) 
                            {
                                // si esmayo el isr al total de percepciones se hac euna regla de 3 solo para nominas E
                                if ( (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina == "EXTRAORDINARIA"
                                    || NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("RDL"))
                                    && Isrtotal > totalpercepciones && ImporteRDLIsr == 0 && NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes == "09"
                                    )
                                {

                                    var divide = Isrtotal / BaseGravable;
                                    Isrtotal = divide * totalpercepciones;

                                }
                                else
                                {
                                    if (esbajaContrato == false)
                                    {
                                        //if (isrtotalpagadoMes >= Isrtotal && primavacacional == false)
                                        //    //es una devolucion de isr , se pone 0
                                        //    //Isrtotal = isrtotalpagadoMes - Isrtotal;
                                        //    Isrtotal = 0;
                                        //else
                                        
                                        Isrtotal = Isrtotal - isrtotalpagadoMes;
                                    }
                                }
                            }
                            else
                            {
                                // se agregaron estas lineas para el caso de cuando se agrea una percepcion personalizada
                                // de prima vacacional y se debe de preguntar siu esta fuera del perido configurado y que no sea por partes proporcioanles
                                // de ser asi resta el impuesto qeu lleva del mes
                                var QuincenaMes = Nova.Libraries.ConvertToInt.ConvertToInt16(NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes);
                                var fueradeperiodo=(QuincenaMes == NominaTrabajador.ParametrosRelacionLaboral.Prima1 || QuincenaMes == NominaTrabajador.ParametrosRelacionLaboral.Prima3 || QuincenaMes == NominaTrabajador.ParametrosRelacionLaboral.Prima2);
                                    
                                    
                                if (isrcalculado == false)
                                    if ( primavacacional ==false || (fueradeperiodo==false && !(NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.CalculoPorSolicitud && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("PARTES PROPORCIONALES"))))
                                        Isrtotal = Isrtotal - isrtotalpagadoMes;
                            }

                            decimal AguinaldoProcentaje = 0M;
                            if (EsCalulodeAguinaldo)

                            {
                                decimal isranteriotemporal = 0M;
                                decimal isrgenerado = 0M;
                                decimal isrresultado= 0M;
                                long nvez = 0;

                                isrgenerado = generaBaseGravableAguinaldo(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, NominaTrabajador, isrtotalpagadoMes, BaseAguinaldoConstante, BaseAguinaldo, AguinaldoMensual, ref Isrtotal, ref isranteriotemporal,ref nvez,DiasLaboradosAguinaldo,ref  isrresultado);
                                Isrtotal = isrresultado;
                                PercepcionesNominaTrabajador percepcionAguinaldo = new PercepcionesNominaTrabajador();


                                percepcionAguinaldo.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                percepcionAguinaldo.IdNomina = NominaTrabajador.IdNomina;
                                percepcionAguinaldo.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO DE ISR PARA AGUINALDO").FirstOrDefault().IdPlantillaNominaPercepcion;
                                percepcionAguinaldo.EsGrabable = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO DE ISR PARA AGUINALDO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                                //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("BASE"))
                                //{ 
                                
                                //var aguinaldodias = NominaTrabajador.ParametrosRelacionesLaborales.Where(a => a.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral== NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral).FirstOrDefault();
                                //    int diasaguinaldo = 0;
                                //    int diasaguinaldoisr = 0;
                                //    if (aguinaldodias != null)
                                //        diasaguinaldo = aguinaldodias.DiasAguinaldo;


                                    //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("ESTATAL"))
                                    //{
                                    //    diasaguinaldo = 50;
                                    //    diasaguinaldoisr = 0;
                                    //}
                                    //else
                                    //{
                                    //    diasaguinaldo = 40;
                                    //    diasaguinaldoisr = 90;
                                    //}

                                    //Isrtotal = (diasaguinaldoisr * Isrtotal) / aguinaldodias.DiasAguinaldo;

                                    
                                    //var idperagui= NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO").FirstOrDefault().IdPlantillaNominaPercepcion;
                                    //var agui = NominaTrabajador.ListaPercepcionesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                    //&& a.IdPlantillaNominaPercepcion == idperagui).FirstOrDefault();
                                    //agui.Importe= (diasaguinaldo * agui.Importe) / aguinaldodias.DiasAguinaldo;

                                    //var idperaguiexento = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AGUINALDO EXENTO").FirstOrDefault().IdPlantillaNominaPercepcion;
                                    //var aguiextento= NominaTrabajador.ListaPercepcionesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                    //&& a.IdPlantillaNominaPercepcion == idperaguiexento).FirstOrDefault();

                                    //if (aguiextento!=null)
                                    //    aguiextento.Importe = (diasaguinaldo * aguiextento.Importe) / aguinaldodias.DiasAguinaldo;


                                    

                               // }
                                percepcionAguinaldo.Importe = Isrtotal;


                                percepcionAguinaldo.Tipo = "NORMAL";
                                percepcionAguinaldo.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO DE ISR PARA AGUINALDO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                percepcionAguinaldo.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO DE ISR PARA AGUINALDO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; 
                                if (percepcionAguinaldo.Importe>0)
                                    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcionAguinaldo);


                            }
                            else
                            if (EsCaluloTitulacion)

                            {
                                decimal isranteriotemporal = 0M;
                                decimal isrgenerado = 0M;
                                long nvez = 0;

                                decimal Isrtotaliter= Isrtotal;
                                isrgenerado = generaBaseGravablePrestacionAdicional(ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria, NominaTrabajador, BaseGravable,ref Isrtotal, totalpercepciones, isrtotalpagadoMes,ref Isrtotaliter, ref nvez);
                                Isrtotal = isrgenerado;
                                //PercepcionesNominaTrabajador percepcionAguinaldo = new PercepcionesNominaTrabajador();


                                //percepcionAguinaldo.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                //percepcionAguinaldo.IdNomina = NominaTrabajador.IdNomina;
                                //percepcionAguinaldo.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO DE ISR PARA AGUINALDO").FirstOrDefault().IdPlantillaNominaPercepcion;
                                //percepcionAguinaldo.EsGrabable = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO DE ISR PARA AGUINALDO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                                //percepcionAguinaldo.Importe = Isrtotal;


                                //percepcionAguinaldo.Tipo = "NORMAL";
                                //percepcionAguinaldo.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO DE ISR PARA AGUINALDO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                //percepcionAguinaldo.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO DE ISR PARA AGUINALDO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial;
                                //NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcionAguinaldo);


                            }


                            if (tienerdl != null && EsCalulodeAguinaldo==false)
                            {

                                if (tienerdl.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL" && Convert.ToInt16(Id) % 2 == 0 && NominaTrabajador.Nomina_stNomina.Nomina_ctTipoCalculo.TipoCalculo!= "RETROACTIVO")
                                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("RDL"))
                                    {
                                    
                                    
                                    if (ISRrdl == null)
                                        throw new ApplicationException("No existe Deducción personalizada de ISR para RDL de : " + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno);
                                    else
                                    {
                                        Isrtotal = ISRrdl.Importe;
                                    }
                                }
                        
                            }


                            if (Isrtotal > 0)
                            {
                                DeduccionesNominaTrabajador isr = new DeduccionesNominaTrabajador();
                                isr.EsImprimibleRecibo = true;
                                isr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                isr.IdNomina = NominaTrabajador.Nomina.IdNomina;
                                isr.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault().IdPlantillaNominaDeduccion;
                                isr.Importe = Isrtotal;




                                NominaTrabajador.ListaDeduccionesTrabajadores.Add(isr);

                                VariablesNominaTrabajador vnt3 = new VariablesNominaTrabajador();
                                vnt3.Concepto = "Isr";
                                vnt3.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                vnt3.Importe = isr.Importe;
                                vnt3.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt3);

                                //var tienerdl = NominaTrabajador.PercepcionPersonalizada.Where(f => f.Percepciones_ctPercepcion.Percepcion == "REMUNERACIÓN AL DESEMPEÑO LABORAL").FirstOrDefault();

                                if ((tienerdl) != null)
                                {

                                    if (tienerdl.Catalogos_ctPeriodoNomina.PeriodoNomina == "MENSUAL" && Convert.ToInt16(Id) % 2 == 0)
                                    {


                                        VariablesNominaTrabajador vnt4 = new VariablesNominaTrabajador();
                                        vnt4.Concepto = "Rdl";
                                        vnt4.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        vnt4.Importe = tienerdl.Importe;
                                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt4);


                                    }



                                }



                                var idtitulacionPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.IdPlantillaNomina == NominaTrabajador.Nomina.IdPlantillaNomina && x.Percepciones_ctPercepcion.Percepcion == "TITULACIÓN").FirstOrDefault();
                                if (idtitulacionPercepcion != null)
                                {
                                    var existetitulacion = NominaTrabajador.ListaPercepcionesTrabajadores.Where(x => x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                     && x.IdPercepcion == idtitulacionPercepcion.IdPercepcion).FirstOrDefault();
                                    if (existetitulacion != null)
                                    {


                                        PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


                                        percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        percepcion.IdNomina = NominaTrabajador.IdNomina;
                                        percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().IdPlantillaNominaPercepcion;
                                        percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                                        percepcion.Importe = isr.Importe;


                                        percepcion.Tipo = "NORMAL";
                                        percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                        percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA I.S.S.S.").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);


                                    }
                                }

                            }
                            //else
                            //{
                            //    PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();


                            //    percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            //    percepcion.IdNomina = NominaTrabajador.IdNomina;
                            //    percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().IdPlantillaNominaPercepcion;
                            //    percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;

                                
                              
                            //        percepcion.Importe = Isrtotal * -1;


                            //    percepcion.Tipo = "NORMAL";
                            //    percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                            //    percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                            //    NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);


                            //}

                        }



                    }



                }

        }

        private decimal generaBaseGravablePrestacionAdicional(int IdConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador, decimal BaseGravable, ref decimal Isrtotal, decimal totalpercep,  decimal isrtotalpagadoMes,ref decimal isrAnterior, ref long iterador)
        {
            decimal Impuesto = 0M;
            
            iterador = iterador + 1;
            decimal nuevabaseg = BaseGravable;
            if (iterador > 1)
            {
                nuevabaseg = (isrAnterior + BaseGravable);
                //    //decimal AguinaldoProcentaje = Isrtotal / (AguinaldoMensual + IsrtotalAnterior);
                //    nuevabaseg = (Isrtotal - isrtotalpagadoMes) + BaseGravable;
            }
            
            // decimal aguinaldopercepciones = Math.Round( BaseGravable + Isrtotal,4);
            try
            {
                Impuesto = generarImpuestoCausado(nuevabaseg, NominaTrabajador, IdConvenioLaboralTrabajadorCategoria);
                //if (iterador > 1)
                  //  isrAnterior = Impuesto;
            }
            catch (Exception df)
            {

                new SystemException("error" + df.InnerException);
            }
            decimal vartempo = Impuesto - isrtotalpagadoMes;
            decimal tempoisrdif = 0;
            if (iterador == 1)
                isrAnterior = 0;

                tempoisrdif = (totalpercep + isrAnterior) - (vartempo);
                
           
            if (tempoisrdif != totalpercep)
                generaBaseGravablePrestacionAdicional(IdConvenioLaboralTrabajadorCategoria, NominaTrabajador, BaseGravable, ref Impuesto, totalpercep, isrtotalpagadoMes,ref  vartempo, ref iterador);

            isrAnterior = vartempo;
            return isrAnterior;

            //var AguinaldoProcentaje2 = Math.Round(tempoisrdif / (AguinaldoMensual + Isrtotal), 4);
            //var temporalgauinaldo2 = BaseAguinaldo * AguinaldoProcentaje2;
            //var aguinaldopercepciones2 = BaseGravable + tempoisrdif;
            //var ImpuestoCausado2 = generarImpuestoCausado(aguinaldopercepciones, NominaTrabajador);
            //var tempoisrdif2 = ImpuestoCausado2 - isrtotalpagadoMes;
        }

        private decimal generaBaseGravableAguinaldo(int IdConvenioLaboralTrabajadorCategoria,Nomina_stNominaTrabajador NominaTrabajador, decimal isrtotalpagadoMes, decimal BaseGravable, decimal BaseAguinaldo, decimal AguinaldoMensual, ref decimal Isrtotal, ref decimal IsrtotalAnterior,ref long iterador,int DiasLaboradosAguinaldo,ref decimal resultadototal)
        {
            decimal Impuesto = 0M;
            if (iterador>=100)
                return 0;

            iterador = iterador + 1;
            decimal AguinaldoProcentaje = Isrtotal / (AguinaldoMensual+IsrtotalAnterior);
            var baseA_conporc = BaseAguinaldo * AguinaldoProcentaje;
            //decimal nuevabaseg = Isrtotal + BaseGravable;
            decimal nuevabaseg = Isrtotal + AguinaldoMensual+ BaseGravable;
           
            try
            {
                Impuesto = generarImpuestoCausado(nuevabaseg, NominaTrabajador, IdConvenioLaboralTrabajadorCategoria);
            }
            catch (Exception df)
            {

                new SystemException ("error"+df.InnerException);
            }
            
            
            decimal tempoisrdif = Impuesto - isrtotalpagadoMes;
            decimal porcentaje = (tempoisrdif / (AguinaldoMensual + Isrtotal));
            decimal ayudaparaisr = Math.Round(((Isrtotal / 30.4M) * DiasLaboradosAguinaldo),2);
            decimal temporalgauinaldo = BaseGravable + tempoisrdif;
            //decimal aplicandoporcentaje = Math.Round(temporalgauinaldo * AguinaldoProcentaje,0);
            decimal suma = ayudaparaisr + BaseAguinaldo;
            decimal aplicandoporcentaje = Math.Round(suma * AguinaldoProcentaje, 2);
            decimal operacion =   ayudaparaisr- aplicandoporcentaje;
            IsrtotalAnterior = Isrtotal;
            Isrtotal = tempoisrdif;
        
            if (operacion != 0)
                generaBaseGravableAguinaldo(IdConvenioLaboralTrabajadorCategoria,NominaTrabajador, isrtotalpagadoMes, BaseGravable, BaseAguinaldo, AguinaldoMensual, ref Isrtotal, ref IsrtotalAnterior, ref iterador, DiasLaboradosAguinaldo, ref resultadototal);

            if (resultadototal==0)
                resultadototal = aplicandoporcentaje;

            return aplicandoporcentaje;

            //var AguinaldoProcentaje2 = Math.Round(tempoisrdif / (AguinaldoMensual + Isrtotal), 4);
            //var temporalgauinaldo2 = BaseAguinaldo * AguinaldoProcentaje2;
            //var aguinaldopercepciones2 = BaseGravable + tempoisrdif;
            //var ImpuestoCausado2 = generarImpuestoCausado(aguinaldopercepciones, NominaTrabajador);
            //var tempoisrdif2 = ImpuestoCausado2 - isrtotalpagadoMes;
        }
        private decimal generarImpuestoCausado(decimal BaseGravable,Nomina_stNominaTrabajador NominaTrabajador,int ConvenioLaboralTrabajadorCategoria)
        {
            if (BaseGravable==0)
                return 0;

            List<Configuracion_ctSubsidioEmpleo> SubsidioEmpleo;
            decimal LimiteInferior, CantidadSubsidioEmpleoMensual, ExcedenteLimiteInferior, ImpuestoMarginal, ImpuestoCausado;
            decimal CuotaFija, PorcentajeAplicarseExcedenteLimiteInferior, ImpuestoNeto;
            List<Configuracion_ctISR> Limites;
            
            Limites = NominaTrabajador.ISR.Where(i => i.IdIsrGrupo==NominaTrabajador.Nomina_stNomina.IdIsrGrupo &&
            i.LimiteSuperior >= BaseGravable && i.LimiteInferior <= BaseGravable).ToList();

            decimal maxLimiteSuperior = NominaTrabajador.ISR.Max(l => l.LimiteSuperior);

            if (!Limites.Any())
            {
                if (BaseGravable > maxLimiteSuperior)
                {
                    Limites = NominaTrabajador.ISR.Where(i => i.LimiteSuperior == maxLimiteSuperior).ToList();
                }
                else
                    throw new InvalidOperationException("No se encontró un límite adecuado para el valor de BaseGravable.");
            }

            LimiteInferior = Limites.Select(y => y.LimiteInferior).SingleOrDefault();
            ExcedenteLimiteInferior = BaseGravable - LimiteInferior;
            PorcentajeAplicarseExcedenteLimiteInferior = Limites.Select(y => y.PorcentajeAplicarseExcedenteLimiteInferior).SingleOrDefault() / 100;
            ImpuestoMarginal = ExcedenteLimiteInferior * PorcentajeAplicarseExcedenteLimiteInferior;
            CuotaFija = Limites.Select(y => y.CuotaFija).SingleOrDefault();
            ImpuestoNeto = ImpuestoMarginal + CuotaFija;
         //   try
         //   {
         //       SubsidioEmpleo = NominaTrabajador.SubsidioEmpleo.Where(s => s.FechaInicio.Year <= NominaTrabajador.Nomina_stNomina.FechaInicio.Year && s.FechaTermino.Year >= NominaTrabajador.Nomina_stNomina.FechaInicio.Year
         //&& s.FechaInicio <= NominaTrabajador.Nomina_stNomina.FechaTermino && s.FechaTermino >= NominaTrabajador.Nomina_stNomina.FechaInicio
         //&& s.IngresosHasta >= BaseGravable && s.IngresosDesde <= BaseGravable).ToList();


         //   }
         //   catch (Exception ex)
         //   {

         //       throw new Exception(ex.Message);
         //   }
         

            //CantidadSubsidioEmpleoMensual = SubsidioEmpleo.Select(c => c.Subsidio).SingleOrDefault(); // Guardar en tabla
            //ImpuestoCausado = ImpuestoNeto - CantidadSubsidioEmpleoMensual;

            ImpuestoCausado = ImpuestoNeto;
            return ImpuestoCausado;
        }
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("INDEMNIZA"))
                calcularIndemnizacion(ConvenioLaboralTrabajadorCategoria, NominaTrabajador);
            else
                calcularNormal(ConvenioLaboralTrabajadorCategoria, NominaTrabajador);




        }

    }
}