﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
 

namespace Nova.Models.Calculos.Deducciones
{

    public class IMSS : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            bool calcular = true;
            if (NominaTrabajador.Nomina_stNomina.Nomina_ctTipoNomina.TipoNomina != "EXTRAORDINARIA")
            {
                if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                    //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(y => y.IdPlantillaNomina == NominaTrabajador.Nomina_stNomina.IdPlantillaNomina && y.Deducciones_ctDeduccion.Deduccion == "IMSS").SingleOrDefault() != null)

                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla == "CONTRATO DOCENTE SUELDO HORAS EXTRAORDINARIAS")
                    {

                        if (ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador != 4968)
                            calcular = false;
                    }

                if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault() != null
                && calcular)
                {
                    var totalpercepciones = NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && v.EsGrabable == true).Sum(f => f.Importe);


                    bool EsBisiesto = DateTime.IsLeapYear(NominaTrabajador.Nomina_stNomina.Año);
                    int DiasQuincenaIMSS = 0;
                    int DiasMes = 0;
                    DiasMes = DateTime.DaysInMonth(NominaTrabajador.Nomina_stNomina.Año, NominaTrabajador.Nomina_stNomina.FechaInicio.Month);




                    switch (DiasMes)
                    {
                        case 28:
                            if (NominaTrabajador.Nomina_stNomina.FechaInicio.Day == 1)
                                DiasQuincenaIMSS = 15;
                            else
                                DiasQuincenaIMSS = 13;
                            break;
                        case 29:

                            if (NominaTrabajador.Nomina_stNomina.FechaInicio.Day == 1)
                                DiasQuincenaIMSS = 15;
                            else
                                DiasQuincenaIMSS = 14;
                            break;
                        case 30:
                            DiasQuincenaIMSS = 15;
                            break;
                        case 31:
                            if (NominaTrabajador.Nomina_stNomina.FechaInicio.Day == 1)
                                DiasQuincenaIMSS = 15;
                            else
                                DiasQuincenaIMSS = 16;

                            break;

                        default:
                            break;
                    }

                    var diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;

                    bool sinsaldoenimss = true;

                    var totaldiasimsssaldo = NominaTrabajador.ListaVariablesNominaTrabajador.Where(z => z.Concepto == "INCIDENCIA_DIAS_SALDO_UPDATE"
                    && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();


                    var tuvoincidencia = NominaTrabajador.ListaVariablesNominaTrabajador.Where(z => z.Concepto == "INCIDENCIA_DIAS_SALDO_INSERT"
                   && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();


                    var totaldiasimssQuincena = NominaTrabajador.ListaVariablesNominaTrabajador.Where(z => z.Concepto == "INCIDENCIA_DIAS_IMSS"
                        && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                    bool terminoimssmismaqna = false;
                    if (totaldiasimssQuincena != null)
                    {
                        //quiero decir que termino en la misma quincena y no de d calcular imss
                        if (totaldiasimssQuincena.Importe == DiasQuincenaIMSS)
                        {
                            terminoimssmismaqna = true;
                        }
                    }

                    var existeterminocontotaldiastrabajados = false;
                    if (totaldiasimssQuincena != null)
                        if (totaldiasimssQuincena.Importe == diaslaborados)
                            existeterminocontotaldiastrabajados = true;


                    if (totaldiasimsssaldo != null)
                        if (totaldiasimsssaldo.Importe > 0 || existeterminocontotaldiastrabajados)
                            sinsaldoenimss = false;

                    if (totalpercepciones > 0 && sinsaldoenimss && terminoimssmismaqna == false)
                    {
                        //if (NominaTrabajador.DiasPagados > 0)
                        //{
                        decimal sdi = NominaTrabajador.ListaVariablesNominaTrabajador.Where(z => z.Concepto == "SALARIO DIARIO INTEGRADO" && ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == z.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe;

                        //Patronales




                        Decimal totalDIASIncidencias = 0;
                        //               totalDIASIncidencias = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_DIAS_SALDO_INSERT" && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        //).Sum(a => a.Importe);
                        //              if (totalDIASIncidencias > 0)
                        //              {
                        //                  if (totalDIASIncidencias < diaslaborados)
                        //                  {
                        //                      DiasQuincenaIMSS = (int)DiasQuincenaIMSS - (int)totalDIASIncidencias;
                        //                  }

                        //                  //else
                        //                  //{
                        //                  //    DiasQuincenaIMSS = (int)DiasQuincenaIMSS;

                        //                  //}
                        //              }
                        //              else
                        //              {
                        totalDIASIncidencias = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_DIAS_IMSS" && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
    ).Sum(a => a.Importe);

                        if (totalDIASIncidencias < DiasQuincenaIMSS)
                        {
                            DiasQuincenaIMSS = (int)DiasQuincenaIMSS - (int)totalDIASIncidencias;
                        }

                        //}

                        VariablesNominaTrabajador li = new VariablesNominaTrabajador();
                        li.Concepto = "DiasQuincenaIMSS";
                        li.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        li.Importe = DiasQuincenaIMSS;
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(li);




                        decimal? _CuotaFijaPatron;
                        decimal CuotaFijaPatron;
                        short IdCuotaFijaPatron;

                        try
                        {
                            _CuotaFijaPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "CUOTA FIJA").SingleOrDefault().Porcentaje / 100m;
                            IdCuotaFijaPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "CUOTA FIJA").SingleOrDefault().IdSubDeduccion;

                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[CUOTA FIJA PATRÓN],nulo | Error original:" + e.Message);
                        }

                        if (_CuotaFijaPatron > 0)
                            CuotaFijaPatron = Convert.ToDecimal(_CuotaFijaPatron);
                        else
                            throw new Exception("Parámetro:[CUOTA FIJA PATRÓN], nulo");

                        decimal TresVecesSalarioMinimoDF = 3 * NominaTrabajador.ctUMA.Monto;
                        //decimal TresVecesSalarioMinimoDF =  NominaTrabajador.ctUMA.Monto* (decimal)_CuotaFijaPatron* DiasQuincenaIMSS;
                        decimal DiasSMDF = DiasQuincenaIMSS * NominaTrabajador.SalarioMinimoDF.Monto;
                        if (NominaTrabajador.Nomina_stNomina.Año == 2020 && NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes == "13")
                        {
                            TresVecesSalarioMinimoDF = 3 * 84.49M;

                            DiasSMDF = DiasQuincenaIMSS * 84.49M;

                        }

                        decimal? _ExcedenteTresVecesSalarioMinimoDFPatron;
                        decimal ExcedenteTresVecesSalarioMinimoDFPatron;
                        short IdExcedenteTresVecesSalarioMinimoDFPatron;

                        try
                        {
                            _ExcedenteTresVecesSalarioMinimoDFPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "EXCEDENTE 3 VECES EL SALARIO MÍNIMO DEL DISTRITO FEDERAL").SingleOrDefault().Porcentaje / 100m;
                            IdExcedenteTresVecesSalarioMinimoDFPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "EXCEDENTE 3 VECES EL SALARIO MÍNIMO DEL DISTRITO FEDERAL").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[EXCEDENTE 3 VECES EL SALARIO MINIMO DEL DISTRITO FEDERAL PATRÓN],nulo| Error original:" + e.Message);
                        }

                        if (_ExcedenteTresVecesSalarioMinimoDFPatron > 0)
                            ExcedenteTresVecesSalarioMinimoDFPatron = Convert.ToDecimal(_ExcedenteTresVecesSalarioMinimoDFPatron);
                        else
                            throw new Exception("Parámetro:[EXCEDENTE 3 VECES EL SALARIO MINIMO DEL DISTRITO FEDERAL PATRÓN],nulo");



                        decimal? _PrestacionesEnDineroPatron;
                        decimal PrestacionesEnDineroPatron;
                        short IdPrestacionesEnDineroPatron;

                        try
                        {
                            _PrestacionesEnDineroPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "PRESTACIONES EN DINERO").SingleOrDefault().Porcentaje / 100m;
                            IdPrestacionesEnDineroPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "PRESTACIONES EN DINERO").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[PRESTACIONES EN DINERO PATRÓN],nulo | Error original: " + e.Message);
                        }
                        if (_PrestacionesEnDineroPatron > 0)
                            PrestacionesEnDineroPatron = Convert.ToDecimal(_PrestacionesEnDineroPatron);
                        else
                            throw new Exception("Parámetro:[PRESTACIONES EN DINERO PATRÓN],nulo");



                        decimal? _GastosMedicosPatron;
                        decimal GastosMedicosPatron;
                        short IdGastosMedicosPatron;
                        try
                        {
                            _GastosMedicosPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "GASTOS MÉDICOS").SingleOrDefault().Porcentaje / 100m;
                            IdGastosMedicosPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "GASTOS MÉDICOS").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[GASTOS MEDICOS PATRÓN],nulo| Error original: " + e.Message);
                        }

                        if (_GastosMedicosPatron > 0)
                            GastosMedicosPatron = Convert.ToDecimal(_GastosMedicosPatron);
                        else
                            throw new Exception("Parámetro:[GASTOS MEDICOS PATRÓN],nulo");



                        decimal? _RiesgoTrabajoPatron;
                        decimal RiesgoTrabajoPatron;
                        short IdRiesgoTrabajoPatron;

                        try
                        {
                            _RiesgoTrabajoPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "RIESGO DE TRABAJO").SingleOrDefault().Porcentaje / 100m;
                            IdRiesgoTrabajoPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "RIESGO DE TRABAJO").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[RIESGO DE TRABAJO PATRÓN],nulo| Error original: " + e.Message);
                        }

                        if (_RiesgoTrabajoPatron > 0)
                            RiesgoTrabajoPatron = Convert.ToDecimal(_RiesgoTrabajoPatron);
                        else
                            throw new Exception("Parámetro:[RIESGO DE TRABAJO PATRÓN],nulo");



                        decimal? _InvalidezVidaPatron;
                        decimal InvalidezVidaPatron;
                        short IdInvalidezVidaPatron;

                        try
                        {
                            _InvalidezVidaPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "INVALIDEZ Y VIDA").SingleOrDefault().Porcentaje / 100m;
                            IdInvalidezVidaPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "INVALIDEZ Y VIDA").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[INVALIDEZ Y VIDA PATRÓN],nulo | Error original: " + e.Message);
                        }

                        if (_InvalidezVidaPatron > 0)
                            InvalidezVidaPatron = Convert.ToDecimal(_InvalidezVidaPatron);
                        else
                            throw new Exception("Parámetro:[INVALIDEZ Y VIDA PATRÓN],nulo");


                        decimal? _GuarderiaPrevisionSocialPatron;
                        decimal GuarderiaPrevisionSocialPatron;
                        short IdGuarderiaPrevisionSocialPatron;

                        try
                        {
                            _GuarderiaPrevisionSocialPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "GUARDERÍA Y PREVISIÓN SOCIAL").SingleOrDefault().Porcentaje / 100m;
                            IdGuarderiaPrevisionSocialPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "GUARDERÍA Y PREVISIÓN SOCIAL").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[GUARDERIA Y PREVISIÓN SOCIAL PATRÓN],nulo | Error original: " + e.Message);
                        }

                        if (_GuarderiaPrevisionSocialPatron > 0)
                            GuarderiaPrevisionSocialPatron = Convert.ToDecimal(_GuarderiaPrevisionSocialPatron);
                        else
                            throw new Exception("Parámetro:[GUARDERIA Y PREVISIÓN SOCIAL PATRÓN],nulo");

                        decimal? _RetiroPatron;
                        decimal RetiroPatron;
                        short IdRetiroPatron;

                        try
                        {
                            _RetiroPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "RETIRO").SingleOrDefault().Porcentaje / 100m;
                            IdRetiroPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "RETIRO").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[RETIRO PATRÓN],nulo | Error original: " + e.Message);
                        }

                        if (_RetiroPatron > 0)
                            RetiroPatron = Convert.ToDecimal(_RetiroPatron);
                        else
                            throw new Exception("Parámetro:[RETIRO PATRÓN],nulo");

                        decimal _CesantiaVejezPatron = 0;
                        decimal CesantiaVejezPatron;
                        short IdCesantiaVejezPatron;

                        try
                        {
                            //decimal porcentajecesantia = 0;
                            //_CesantiaVejezPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "CESANTÍA EN EDAD AVANZADA Y VEJEZ").SingleOrDefault().Porcentaje / 100m;

                            //List<Catalogos_ctCesantiaYVejez> Limites;

                            //Limites = NominaTrabajador.Catalogos_ctCesantiaYVejez.Where(i => 
                            //i.LimiteSuperior >= sdi && i.LimiteInferior <= sdi).ToList();

                            //if (Limites.Count > 0)
                            //{
                            //    _CesantiaVejezPatron = Limites.Select(y => y.Porcentaje).FirstOrDefault();
                            //}

                            _CesantiaVejezPatron = NominaTrabajador.ObtenerPorcentajeCesantiayVejez(sdi);

                            IdCesantiaVejezPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "CESANTÍA EN EDAD AVANZADA Y VEJEZ").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[CESANTÍA EN EDAD AVANZADA Y VEJEZ PATRÓN],nulo | Error original: " + e.Message);
                        }

                        //if (_CesantiaVejezPatron > 0)
                        //    CesantiaVejezPatron = Convert.ToDecimal(_CesantiaVejezPatron);
                        //else
                        //    throw new Exception("Parámetro:[CESANTÍA EN EDAD AVANZADA Y VEJEZ PATRÓN],nulo");

                        decimal? _InfonavitPatron;
                        decimal InfonavitPatron;
                        short IdInfonavitPatron;

                        try
                        {
                            _InfonavitPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "INFONAVIT").SingleOrDefault().Porcentaje / 100m;
                            IdInfonavitPatron = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "PATRÓN" && c.Deducciones_ctSubDeduccion.Concepto == "INFONAVIT").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[INFONAVIT PATRÓN],nulo | Error original: " + e.Message);
                        }
                        if (_InfonavitPatron > 0)
                            InfonavitPatron = Convert.ToDecimal(_InfonavitPatron);
                        else
                            throw new Exception("Parámetro:[INFONAVIT PATRÓN],nulo");

                        //Obreras

                        decimal? _ExcedenteTresVecesSalarioMinimoDFTrabajador;
                        decimal ExcedenteTresVecesSalarioMinimoDFTrabajador;
                        short IdExcedenteTresVecesSalarioMinimoDFTrabajador;
                        try
                        {
                            _ExcedenteTresVecesSalarioMinimoDFTrabajador = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "OBRERO" && c.Deducciones_ctSubDeduccion.Concepto == "EXCEDENTE 3 VECES EL SALARIO MÍNIMO DEL DISTRITO FEDERAL").SingleOrDefault().Porcentaje / 100m;
                            IdExcedenteTresVecesSalarioMinimoDFTrabajador = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "OBRERO" && c.Deducciones_ctSubDeduccion.Concepto == "EXCEDENTE 3 VECES EL SALARIO MÍNIMO DEL DISTRITO FEDERAL").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[EXCEDENTE 3 VECES EL SALARIO MINIMO DEL DISTRITO FEDERAL OBRERO],nulo | Error original: " + e.Message);
                        }

                        if (_ExcedenteTresVecesSalarioMinimoDFTrabajador > 0)
                            ExcedenteTresVecesSalarioMinimoDFTrabajador = Convert.ToDecimal(_ExcedenteTresVecesSalarioMinimoDFTrabajador);
                        else
                            throw new Exception("Parámetro:[EXCEDENTE 3 VECES EL SALARIO MINIMO DEL DISTRITO FEDERAL OBRERO],nulo");


                        decimal? _PrestacionesEnDineroTrabajador = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "OBRERO" && c.Deducciones_ctSubDeduccion.Concepto == "PRESTACIONES EN DINERO").SingleOrDefault().Porcentaje / 100m; ;
                        decimal PrestacionesEnDineroTrabajador;
                        short IdPrestacionesEnDineroTrabajador;

                        try
                        {
                            _PrestacionesEnDineroTrabajador = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "OBRERO" && c.Deducciones_ctSubDeduccion.Concepto == "PRESTACIONES EN DINERO").SingleOrDefault().Porcentaje / 100m; ;
                            IdPrestacionesEnDineroTrabajador = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "OBRERO" && c.Deducciones_ctSubDeduccion.Concepto == "PRESTACIONES EN DINERO").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[PRESTACIONES EN DINERO OBRERO],nulo");
                        }
                        if (_PrestacionesEnDineroTrabajador > 0)
                            PrestacionesEnDineroTrabajador = Convert.ToDecimal(_PrestacionesEnDineroTrabajador);
                        else
                            throw new Exception("Parámetro:[PRESTACIONES EN DINERO OBRERO],nulo");

                        decimal? _GastosMedicosTrabajador;
                        decimal GastosMedicosTrabajador;
                        short IdGastosMedicosTrabajador;

                        try
                        {
                            _GastosMedicosTrabajador = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "OBRERO" && c.Deducciones_ctSubDeduccion.Concepto == "GASTOS MÉDICOS").SingleOrDefault().Porcentaje / 100m;
                            IdGastosMedicosTrabajador = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "OBRERO" && c.Deducciones_ctSubDeduccion.Concepto == "GASTOS MÉDICOS").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception)
                        {

                            throw new Exception("Parámetro:[GASTOS MÉDICOS OBRERO],nulo");
                        }

                        if (_GastosMedicosTrabajador > 0)
                            GastosMedicosTrabajador = Convert.ToDecimal(_GastosMedicosTrabajador);
                        else
                            throw new Exception("Parámetro:[GASTOS MÉDICOS OBRERO],nulo");


                        decimal? _InvalidezVidaTrabajador;
                        decimal InvalidezVidaTrabajador;
                        short IdInvalidezVidaTrabajador;

                        try
                        {
                            _InvalidezVidaTrabajador = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "OBRERO" && c.Deducciones_ctSubDeduccion.Concepto == "INVALIDEZ Y VIDA").SingleOrDefault().Porcentaje / 100m;
                            IdInvalidezVidaTrabajador = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "OBRERO" && c.Deducciones_ctSubDeduccion.Concepto == "INVALIDEZ Y VIDA").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[INVALIDEZ Y VIDA OBRERO],nulo | Error original: " + e.Message);
                        }

                        if (_InvalidezVidaTrabajador > 0)
                            InvalidezVidaTrabajador = Convert.ToDecimal(_InvalidezVidaTrabajador);
                        else
                            throw new Exception("Parámetro:[INVALIDEZ Y VIDA OBRERO],nulo");

                        decimal? _CesantiaVejezTrabajador;
                        decimal CesantiaVejezTrabajador;
                        short IdCesantiaVejezTrabajador;

                        try
                        {
                            _CesantiaVejezTrabajador = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "OBRERO" && c.Deducciones_ctSubDeduccion.Concepto == "CESANTÍA EN EDAD AVANZADA Y VEJEZ").SingleOrDefault().Porcentaje / 100m;
                            IdCesantiaVejezTrabajador = NominaTrabajador.CuotasObreroPatronales.Where(c => c.Deducciones_ctSubDeduccion.Deducciones_TipoSubDeduccion.TipoSubDeduccion == "OBRERO" && c.Deducciones_ctSubDeduccion.Concepto == "CESANTÍA EN EDAD AVANZADA Y VEJEZ").SingleOrDefault().IdSubDeduccion;
                        }
                        catch (Exception e)
                        {

                            throw new Exception("Parámetro:[CESANTÍA EN EDAD AVANZADA Y VEJEZ],nulo | Error original: " + e.Message);
                        }

                        if (_CesantiaVejezTrabajador > 0)
                            CesantiaVejezTrabajador = Convert.ToDecimal(_CesantiaVejezTrabajador);
                        else
                            throw new Exception("Parámetro:[CESANTÍA EN EDAD AVANZADA Y VEJEZ],nulo");

                        // Inicio de cálculos

                        if (sdi > TresVecesSalarioMinimoDF)
                        {
                            ExcedenteTresVecesSalarioMinimoDFPatron = (sdi - TresVecesSalarioMinimoDF) * ExcedenteTresVecesSalarioMinimoDFPatron * DiasQuincenaIMSS;
                            ExcedenteTresVecesSalarioMinimoDFTrabajador = (sdi - TresVecesSalarioMinimoDF) * ExcedenteTresVecesSalarioMinimoDFTrabajador * DiasQuincenaIMSS;
                        }




                        //Cuota Patronal

                        CuotaFijaPatron = NominaTrabajador.ctUMA.Monto * (decimal)_CuotaFijaPatron * DiasQuincenaIMSS;
                        PrestacionesEnDineroPatron = (sdi * PrestacionesEnDineroPatron) * DiasQuincenaIMSS;
                        GastosMedicosPatron = (sdi * GastosMedicosPatron) * DiasQuincenaIMSS;
                        RiesgoTrabajoPatron = (sdi * RiesgoTrabajoPatron) * DiasQuincenaIMSS;
                        InvalidezVidaPatron = (sdi * InvalidezVidaPatron) * DiasQuincenaIMSS;
                        GuarderiaPrevisionSocialPatron = sdi * DiasQuincenaIMSS * 0.01m;
                        RetiroPatron = sdi * DiasQuincenaIMSS * 0.02m;
                        CesantiaVejezPatron = sdi * DiasQuincenaIMSS * _CesantiaVejezPatron;
                        InfonavitPatron = sdi * DiasQuincenaIMSS * 0.05m;

                        //Cuota Obrero

                        PrestacionesEnDineroTrabajador = (sdi * PrestacionesEnDineroTrabajador) * DiasQuincenaIMSS;
                        GastosMedicosTrabajador = (sdi * GastosMedicosTrabajador) * DiasQuincenaIMSS;
                        InvalidezVidaTrabajador = (sdi * InvalidezVidaTrabajador) * DiasQuincenaIMSS;
                        var cesatempo = (sdi * CesantiaVejezTrabajador) * DiasQuincenaIMSS;
                        CesantiaVejezTrabajador = Math.Truncate(cesatempo * 100M) / 100M;


                        ////////////////////////////////////////////////////////////////////////////////

                        //Instancia nueva para guardar calculos por trabajador




                        int IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        int IdNomina = NominaTrabajador.Nomina_stNomina.IdNomina;
                        //int IdPlantillaNominaDeduccion = Convert.ToInt32(NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(y => y.IdPlantillaNomina == NominaTrabajador.Nomina_stNomina.IdPlantillaNomina && y.Deducciones_ctDeduccion.Deduccion == "IMSS").SingleOrDefault().IdPlantillaNominaDeduccion);
                        int IdPlantillaNominaDeduccion = Convert.ToInt32(NominaTrabajador.PlantillaNominaDeducciones.Where(y => y.IdPlantillaNomina == NominaTrabajador.Nomina_stNomina.IdPlantillaNomina && y.Deducciones_ctDeduccion.Deduccion == "IMSS").SingleOrDefault().IdPlantillaNominaDeduccion);

                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual = new SubDeduccionesNominaTrabajador();


                        NominaSubDeduccionesTrabajadorActual.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual.IdSubDeduccion = IdCuotaFijaPatron;

                        NominaSubDeduccionesTrabajadorActual.Importe = 0;

                        if (diaslaborados > 0)
                            //if (NominaTrabajador.DiasPagados > 0)
                            NominaSubDeduccionesTrabajadorActual.Importe = CuotaFijaPatron;

                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual);


                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual2 = new SubDeduccionesNominaTrabajador();
                        NominaSubDeduccionesTrabajadorActual2.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual2.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual2.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual2.IdSubDeduccion = IdExcedenteTresVecesSalarioMinimoDFPatron;

                        NominaSubDeduccionesTrabajadorActual2.Importe = 0;
                        //if (NominaTrabajador.DiasPagados > 0)
                        if (diaslaborados > 0)
                            NominaSubDeduccionesTrabajadorActual2.Importe = ExcedenteTresVecesSalarioMinimoDFPatron;

                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual2);

                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual3 = new SubDeduccionesNominaTrabajador();

                        NominaSubDeduccionesTrabajadorActual3.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual3.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual3.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual3.IdSubDeduccion = IdPrestacionesEnDineroPatron;

                        NominaSubDeduccionesTrabajadorActual3.Importe = 0;
                        if (NominaTrabajador.DiasPagados > 0)
                            NominaSubDeduccionesTrabajadorActual3.Importe = PrestacionesEnDineroPatron;


                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual3);

                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual4 = new SubDeduccionesNominaTrabajador();

                        NominaSubDeduccionesTrabajadorActual4.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual4.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual4.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual4.IdSubDeduccion = IdGastosMedicosPatron;
                        NominaSubDeduccionesTrabajadorActual4.Importe = 0;
                        if (diaslaborados > 0)
                            //if (NominaTrabajador.DiasPagados > 0)
                            NominaSubDeduccionesTrabajadorActual4.Importe = GastosMedicosPatron;

                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual4);

                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual5 = new SubDeduccionesNominaTrabajador();

                        NominaSubDeduccionesTrabajadorActual5.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual5.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual5.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual5.IdSubDeduccion = IdRiesgoTrabajoPatron;
                        NominaSubDeduccionesTrabajadorActual5.Importe = 0;
                        if (diaslaborados > 0)
                            //if (NominaTrabajador.DiasPagados > 0)
                            NominaSubDeduccionesTrabajadorActual5.Importe = RiesgoTrabajoPatron;

                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual5);

                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual6 = new SubDeduccionesNominaTrabajador();

                        NominaSubDeduccionesTrabajadorActual6.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual6.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual6.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual6.IdSubDeduccion = IdInvalidezVidaPatron;

                        NominaSubDeduccionesTrabajadorActual6.Importe = 0;
                        if (diaslaborados > 0)
                            //if (NominaTrabajador.DiasPagados > 0)
                            NominaSubDeduccionesTrabajadorActual6.Importe = InvalidezVidaPatron;

                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual6);

                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual7 = new SubDeduccionesNominaTrabajador();

                        NominaSubDeduccionesTrabajadorActual7.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual7.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual7.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual7.IdSubDeduccion = IdGuarderiaPrevisionSocialPatron;

                        NominaSubDeduccionesTrabajadorActual7.Importe = 0;
                        if (diaslaborados > 0)
                            // if (NominaTrabajador.DiasPagados > 0)
                            NominaSubDeduccionesTrabajadorActual7.Importe = GuarderiaPrevisionSocialPatron;

                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual7);


                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual8 = new SubDeduccionesNominaTrabajador();

                        NominaSubDeduccionesTrabajadorActual8.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual8.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual8.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual8.IdSubDeduccion = IdRetiroPatron;

                        NominaSubDeduccionesTrabajadorActual8.Importe = 0;
                        if (diaslaborados > 0)
                            //if (NominaTrabajador.DiasPagados > 0)
                            NominaSubDeduccionesTrabajadorActual8.Importe = RetiroPatron;

                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual8);

                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual9 = new SubDeduccionesNominaTrabajador();

                        NominaSubDeduccionesTrabajadorActual9.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual9.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual9.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual9.IdSubDeduccion = IdCesantiaVejezPatron;

                        NominaSubDeduccionesTrabajadorActual9.Importe = 0;
                        if (diaslaborados > 0)
                            //if (NominaTrabajador.DiasPagados > 0)
                            NominaSubDeduccionesTrabajadorActual9.Importe = CesantiaVejezPatron;

                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual9);

                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual10 = new SubDeduccionesNominaTrabajador();

                        NominaSubDeduccionesTrabajadorActual10.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual10.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual10.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual10.IdSubDeduccion = IdInfonavitPatron;

                        NominaSubDeduccionesTrabajadorActual10.Importe = 0;
                        if (diaslaborados > 0)
                            //if (NominaTrabajador.DiasPagados > 0)
                            NominaSubDeduccionesTrabajadorActual10.Importe = InfonavitPatron;

                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual10);


                        ////////////////////////////////////////////////////////////////////////////////

                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual11 = new SubDeduccionesNominaTrabajador();

                        NominaSubDeduccionesTrabajadorActual11.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual11.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual11.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual11.IdSubDeduccion = IdPrestacionesEnDineroTrabajador;

                        NominaSubDeduccionesTrabajadorActual11.Importe = 0;

                        if (diaslaborados > 0)
                            //if (NominaTrabajador.DiasPagados > 0)
                            NominaSubDeduccionesTrabajadorActual11.Importe = PrestacionesEnDineroTrabajador;

                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual11);

                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual12 = new SubDeduccionesNominaTrabajador();

                        NominaSubDeduccionesTrabajadorActual12.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual12.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual12.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual12.IdSubDeduccion = IdExcedenteTresVecesSalarioMinimoDFTrabajador;

                        NominaSubDeduccionesTrabajadorActual12.Importe = 0;
                        //if (NominaTrabajador.DiasPagados > 0)
                        if (diaslaborados > 0)
                            NominaSubDeduccionesTrabajadorActual12.Importe = ExcedenteTresVecesSalarioMinimoDFTrabajador;

                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual12);

                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual13 = new SubDeduccionesNominaTrabajador();
                        NominaSubDeduccionesTrabajadorActual13.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual13.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual13.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual13.IdSubDeduccion = IdGastosMedicosTrabajador;

                        NominaSubDeduccionesTrabajadorActual13.Importe = 0;

                        if (diaslaborados > 0)
                            //if (NominaTrabajador.DiasPagados > 0)
                            NominaSubDeduccionesTrabajadorActual13.Importe = GastosMedicosTrabajador;

                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual13);

                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual14 = new SubDeduccionesNominaTrabajador();

                        NominaSubDeduccionesTrabajadorActual14.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual14.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual14.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual14.IdSubDeduccion = IdInvalidezVidaTrabajador;

                        NominaSubDeduccionesTrabajadorActual14.Importe = 0;
                        if (diaslaborados > 0)
                            //if (NominaTrabajador.DiasPagados > 0)
                            NominaSubDeduccionesTrabajadorActual14.Importe = InvalidezVidaTrabajador;

                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual14);

                        SubDeduccionesNominaTrabajador NominaSubDeduccionesTrabajadorActual15 = new SubDeduccionesNominaTrabajador();
                        NominaSubDeduccionesTrabajadorActual15.IdConvenioLaboralTrabajadorCategoria = IdConvenioLaboralTrabajadorCategoria;
                        NominaSubDeduccionesTrabajadorActual15.IdNomina = IdNomina;
                        NominaSubDeduccionesTrabajadorActual15.IdPlantillaNominaDeduccion = IdPlantillaNominaDeduccion;
                        NominaSubDeduccionesTrabajadorActual15.IdSubDeduccion = IdCesantiaVejezTrabajador;

                        NominaSubDeduccionesTrabajadorActual15.Importe = 0;
                        if (diaslaborados > 0)
                            //if (NominaTrabajador.DiasPagados > 0)
                            NominaSubDeduccionesTrabajadorActual15.Importe = CesantiaVejezTrabajador;
                        NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Add(NominaSubDeduccionesTrabajadorActual15);

                        VariablesNominaTrabajador lr = new VariablesNominaTrabajador();
                        lr.Concepto = "CesantiaVejezTrabajador";
                        lr.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        lr.Importe = CesantiaVejezTrabajador;
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(lr);

                        //////////////////////////////////////////////////////////////////////////////////

                        DeduccionesNominaTrabajador deduccionimss = new DeduccionesNominaTrabajador();
                        deduccionimss.EsImprimibleRecibo = true;
                        deduccionimss.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        deduccionimss.IdNomina = NominaTrabajador.Nomina_stNomina.IdNomina;
                        deduccionimss.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault().IdPlantillaNominaDeduccion;

                        if (diaslaborados == 0)
                        {
                            deduccionimss.Importe = 0M;
                        }
                        else
                        {
                            deduccionimss.Importe = NominaTrabajador.Truncate(NominaTrabajador.Truncate(ExcedenteTresVecesSalarioMinimoDFTrabajador, 4) + NominaTrabajador.Truncate(PrestacionesEnDineroTrabajador, 4) + NominaTrabajador.Truncate(GastosMedicosTrabajador, 4)
                                + NominaTrabajador.Truncate(InvalidezVidaTrabajador, 4) + NominaTrabajador.Truncate(CesantiaVejezTrabajador, 4), 4);

                            var importediasnomina = (deduccionimss.Importe / DiasQuincenaIMSS);

                            deduccionimss.Importe = NominaTrabajador.Truncate(importediasnomina * DiasQuincenaIMSS, 4);

                            if (diaslaborados < NominaTrabajador.DiasNomina)
                            {
                                //deduccionimss.Importe = NominaTrabajador.Truncate(importediasnomina * diaslaborados, 4);

                                var importetepo = (ExcedenteTresVecesSalarioMinimoDFTrabajador / DiasQuincenaIMSS);

                                ExcedenteTresVecesSalarioMinimoDFTrabajador = NominaTrabajador.Truncate(importetepo * diaslaborados, 4);

                                NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdExcedenteTresVecesSalarioMinimoDFTrabajador

    && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = ExcedenteTresVecesSalarioMinimoDFTrabajador;


                                importetepo = (PrestacionesEnDineroTrabajador / DiasQuincenaIMSS);
                                PrestacionesEnDineroTrabajador = NominaTrabajador.Truncate(importetepo * diaslaborados, 4);

                                NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdPrestacionesEnDineroTrabajador
    && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = PrestacionesEnDineroTrabajador;


                                importetepo = (GastosMedicosTrabajador / DiasQuincenaIMSS);
                                GastosMedicosTrabajador = NominaTrabajador.Truncate(importetepo * diaslaborados, 4);

                                NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdGastosMedicosTrabajador
                               && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = GastosMedicosTrabajador;


                                importetepo = (InvalidezVidaTrabajador / DiasQuincenaIMSS);
                                InvalidezVidaTrabajador = NominaTrabajador.Truncate(importetepo * diaslaborados, 4);

                                NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdInvalidezVidaTrabajador

                               && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = InvalidezVidaTrabajador;


                                importetepo = (CesantiaVejezTrabajador / DiasQuincenaIMSS);
                                CesantiaVejezTrabajador = NominaTrabajador.Truncate(importetepo * diaslaborados, 4);

                                NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdCesantiaVejezTrabajador


                                && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = CesantiaVejezTrabajador;

                                NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                && a.Concepto == "CesantiaVejezTrabajador").FirstOrDefault().Importe = CesantiaVejezTrabajador;

                                deduccionimss.Importe = NominaTrabajador.Truncate(NominaTrabajador.Truncate(ExcedenteTresVecesSalarioMinimoDFTrabajador, 4) + NominaTrabajador.Truncate(PrestacionesEnDineroTrabajador, 4) + NominaTrabajador.Truncate(GastosMedicosTrabajador, 4)
                                + NominaTrabajador.Truncate(InvalidezVidaTrabajador, 4) + NominaTrabajador.Truncate(CesantiaVejezTrabajador, 4), 4);

                            }
                            else

                            {
                                var existerenuncia = NominaTrabajador.BajasPorRenunciasEnlaQuincena.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                                if (existerenuncia != null || ConvenioLaboralTrabajadorCategoria.FechaTermino < NominaTrabajador.Nomina_stNomina.FechaTermino || NominaTrabajador.Nomina_stNomina.FechaInicio.AddDays(1) == ConvenioLaboralTrabajadorCategoria.FechaInicio)
                                {
                                    //deduccionimss.Importe = NominaTrabajador.Truncate(importediasnomina * diaslaborados, 4);

                                    var importetepo = (ExcedenteTresVecesSalarioMinimoDFTrabajador / DiasQuincenaIMSS);

                                    ExcedenteTresVecesSalarioMinimoDFTrabajador = NominaTrabajador.Truncate(importetepo * diaslaborados, 4);

                                    NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdExcedenteTresVecesSalarioMinimoDFTrabajador

        && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = ExcedenteTresVecesSalarioMinimoDFTrabajador;


                                    importetepo = (PrestacionesEnDineroTrabajador / DiasQuincenaIMSS);
                                    PrestacionesEnDineroTrabajador = NominaTrabajador.Truncate(importetepo * diaslaborados, 4);

                                    NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdPrestacionesEnDineroTrabajador
        && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = PrestacionesEnDineroTrabajador;


                                    importetepo = (GastosMedicosTrabajador / DiasQuincenaIMSS);
                                    GastosMedicosTrabajador = NominaTrabajador.Truncate(importetepo * diaslaborados, 4);

                                    NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdGastosMedicosTrabajador
                                   && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = GastosMedicosTrabajador;


                                    importetepo = (InvalidezVidaTrabajador / DiasQuincenaIMSS);
                                    InvalidezVidaTrabajador = NominaTrabajador.Truncate(importetepo * diaslaborados, 4);

                                    NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdInvalidezVidaTrabajador

                                   && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = InvalidezVidaTrabajador;


                                    importetepo = (CesantiaVejezTrabajador / DiasQuincenaIMSS);
                                    CesantiaVejezTrabajador = NominaTrabajador.Truncate(importetepo * diaslaborados, 4);

                                    NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdCesantiaVejezTrabajador


                                    && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = CesantiaVejezTrabajador;

                                    NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                    && a.Concepto == "CesantiaVejezTrabajador").FirstOrDefault().Importe = CesantiaVejezTrabajador;

                                    deduccionimss.Importe = NominaTrabajador.Truncate(NominaTrabajador.Truncate(ExcedenteTresVecesSalarioMinimoDFTrabajador, 4) + NominaTrabajador.Truncate(PrestacionesEnDineroTrabajador, 4) + NominaTrabajador.Truncate(GastosMedicosTrabajador, 4)
                                + NominaTrabajador.Truncate(InvalidezVidaTrabajador, 4) + NominaTrabajador.Truncate(CesantiaVejezTrabajador, 4), 4);

                                }
                                else
                                {
                                    //deduccionimss.Importe = NominaTrabajador.Truncate(importediasnomina * DiasQuincenaIMSS, 4);


                                    var importetepo = (ExcedenteTresVecesSalarioMinimoDFTrabajador / DiasQuincenaIMSS);
                                    ExcedenteTresVecesSalarioMinimoDFTrabajador = NominaTrabajador.Truncate(importetepo * DiasQuincenaIMSS, 4);

                                    NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdExcedenteTresVecesSalarioMinimoDFTrabajador

        && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = ExcedenteTresVecesSalarioMinimoDFTrabajador;


                                    importetepo = (PrestacionesEnDineroTrabajador / DiasQuincenaIMSS);
                                    PrestacionesEnDineroTrabajador = NominaTrabajador.Truncate(importetepo * DiasQuincenaIMSS, 4);

                                    NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdPrestacionesEnDineroTrabajador
        && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = PrestacionesEnDineroTrabajador;


                                    importetepo = (GastosMedicosTrabajador / DiasQuincenaIMSS);
                                    GastosMedicosTrabajador = NominaTrabajador.Truncate(importetepo * DiasQuincenaIMSS, 4);

                                    NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdGastosMedicosTrabajador
                                   && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = GastosMedicosTrabajador;


                                    importetepo = (InvalidezVidaTrabajador / DiasQuincenaIMSS);
                                    InvalidezVidaTrabajador = NominaTrabajador.Truncate(importetepo * DiasQuincenaIMSS, 4);

                                    NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdInvalidezVidaTrabajador

                                   && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = InvalidezVidaTrabajador;


                                    importetepo = (CesantiaVejezTrabajador / DiasQuincenaIMSS);
                                    CesantiaVejezTrabajador = NominaTrabajador.Truncate(importetepo * DiasQuincenaIMSS, 4);

                                    NominaTrabajador.ListaNominaSubDeduccionesTrabajadores.Where(z => z.IdSubDeduccion == IdCesantiaVejezTrabajador

                                    && z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe = CesantiaVejezTrabajador;

                                    NominaTrabajador.ListaVariablesNominaTrabajador.Where(a => a.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                    && a.Concepto == "CesantiaVejezTrabajador").FirstOrDefault().Importe = CesantiaVejezTrabajador;

                                    deduccionimss.Importe = NominaTrabajador.Truncate(NominaTrabajador.Truncate(ExcedenteTresVecesSalarioMinimoDFTrabajador, 4) + NominaTrabajador.Truncate(PrestacionesEnDineroTrabajador, 4) + NominaTrabajador.Truncate(GastosMedicosTrabajador, 4)
                                + NominaTrabajador.Truncate(InvalidezVidaTrabajador, 4) + NominaTrabajador.Truncate(CesantiaVejezTrabajador, 4), 4);

                                }
                            }


                        }

                        VariablesNominaTrabajador lim = new VariablesNominaTrabajador();
                        lim.Concepto = "deduccionimss";
                        lim.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        lim.Importe = NominaTrabajador.Truncate(deduccionimss.Importe - CesantiaVejezTrabajador, 4);
                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(lim);

                        NominaTrabajador.ListaDeduccionesTrabajadores.Add(deduccionimss);




                        // }

                    }

                }

            }
        }




    }

}