﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Deducciones
{

    public class FaltasDocenteContrato: IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault() != null)
            {
                TimeSpan intervalo;
                int diasfaltas = 0;
                int totaldiasfaltas = 0;
                double horasdias = 0;
                bool existeenAries = false;



                int HorasJornada = 0;
                int HorasAsesoria = 0;
                int HorasComplementarias = 0;
                int contador = 0;

                int HorasExcedentes = 0;
                int HorasRezago = 0;

                int totaleshoras = 0;
                int totaleshorasinterinas = 0;

                int horassemanames = 0;


                if (NominaTrabajador.IncidenciaTrabajador.Count > 0)
                {
                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                    var hsmt = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                         && v.Concepto == "HorasSemanaMesTrabajadas").FirstOrDefault();

                    var hsmte = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        && v.Concepto == "HorasTrabajadasExcedentes").FirstOrDefault();

                    var hsmti = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        && v.Concepto == "HorasTrabajadasInterinas").FirstOrDefault();

                    //var hayhorasexcedendetesplantilla = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO HORAS EXCEDENTE").FirstOrDefault();

                    //// linea de codigo para hjacer null a la variable sueldohorasexcedentes
                    //var sueldohorasexcedentes = NominaTrabajador.ListaPercepcionesTrabajadores.Where(w => w.IdConvenioLaboralTrabajadorCategoria == 0).FirstOrDefault();
                    //if (hayhorasexcedendetesplantilla != null)
                    //{
                    //    sueldohorasexcedentes = NominaTrabajador.ListaPercepcionesTrabajadores.Where(w => w.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    //       && w.IdPlantillaNominaPercepcion == hayhorasexcedendetesplantilla.IdPlantillaNominaPercepcion).FirstOrDefault();
                    //}


                    //var sueldohorasexcedentes = NominaTrabajador.ListaPercepcionesTrabajadores.Where(w => w.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    //     && w.IdPlantillaNominaPercepcion == NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO HORAS EXCEDENTE").FirstOrDefault().IdPlantillaNominaPercepcion).FirstOrDefault();

                    var sueldohorasjornada = NominaTrabajador.ListaPercepcionesTrabajadores.Where(w => w.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        && w.IdPlantillaNominaPercepcion == NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO DOCENTE").FirstOrDefault().IdPlantillaNominaPercepcion).FirstOrDefault();


                   // var sueldohorasinterinas = NominaTrabajador.ListaPercepcionesTrabajadores.Where(w => w.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                   //&& w.IdPlantillaNominaPercepcion == NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO HORAS INTERINAS").FirstOrDefault().IdPlantillaNominaPercepcion).FirstOrDefault();

                    decimal sueldopromedio = 0;
                    decimal sueldopromediointerinas = 0;
                    decimal sueldohorasjornadapromedio = 0;
                    if (sueldohorasjornada != null)
                    {
                        sueldohorasjornadapromedio = sueldohorasjornada.Importe;
                    }
                    
                    decimal factorsueldo = 0;

                    if (hsmt.Importe > 0)
                    {
                        //if (sueldohorasexcedentes != null)
                        //{
                        //    sueldopromedio = (sueldohorasexcedentes.Importe + sueldohorasjornadapromedio) / (hsmt.Importe + hsmte.Importe);
                        //}
                        //else
                            sueldopromedio = sueldopromedio / hsmt.Importe;
                    }

                    //if (sueldohorasinterinas != null)
                    //{
                    //    sueldopromediointerinas = (costos.CostoPorHoraInterina / 2);

                    //    factorsueldo = (sueldopromediointerinas + sueldopromedio) / 2;
                    //}
                    //else
                    //    factorsueldo = sueldopromedio;


                    //horassemanames = (int)(hsmt.Importe + hsmte.Importe + hsmti.Importe);


                    var faltastrabajador = NominaTrabajador.IncidenciaTrabajador.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        && s.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA")
                        && s.QuincenaParaNomina == NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
            && s.AñoParaNomina == NominaTrabajador.Nomina_stNomina.Año
                        //&& (s.FechaInicio >= NominaTrabajador.Nomina.FechaInicio && s.FechaTermino <= NominaTrabajador.Nomina.FechaTermino

                        ).OrderBy(g => g.FechaInicio).ToList();


                    foreach (var item in faltastrabajador)
                    {


                        FaltasTrabajador ft = new FaltasTrabajador();
                        FaltasTrabajador faltaAyuda = new FaltasTrabajador();
                        FaltasTrabajador faltaEficiencia = new FaltasTrabajador();

                        intervalo = item.FechaTermino.Value - item.FechaInicio;
                        diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
                        totaldiasfaltas = totaldiasfaltas + diasfaltas;

                        //falta sueldo

                        ft.Importe = factorsueldo * diasfaltas;
                        ft.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                        ft.IdDeduccion = NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault().IdDeduccion;
                        ft.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        NominaTrabajador.ListaFaltasTrabajador.Add(ft);

                        // falta material
                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Percepciones_stPlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "MATERIAL DIDACTICO DE JORNADA").FirstOrDefault() != null)
                        {
                            faltaAyuda.Importe = (decimal)(NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Percepciones_stPlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "MATERIAL DIDACTICO DE JORNADA").FirstOrDefault().Importe / 15) * diasfaltas;
                            faltaAyuda.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                            faltaAyuda.IdDeduccion = NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA MATERIAL DIDACTICO").FirstOrDefault().IdDeduccion;
                            faltaAyuda.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            NominaTrabajador.ListaFaltasTrabajador.Add(faltaAyuda);
                        }


                        //falta eficiencia
                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Percepciones_stPlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO DE JORNADA").FirstOrDefault() != null)
                        {
                            faltaEficiencia.Importe = (decimal)(NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Percepciones_stPlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO DE JORNADA").FirstOrDefault().Importe / 15) * diasfaltas;
                            faltaEficiencia.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                            faltaEficiencia.IdDeduccion = NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdDeduccion;
                            faltaEficiencia.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            NominaTrabajador.ListaFaltasTrabajador.Add(faltaEficiencia);
                        }

                    }

                    if (diasfaltas > 0)
                    {
                        DeduccionesNominaTrabajador falta = new DeduccionesNominaTrabajador();

                        falta.EsImprimibleRecibo = true;
                        falta.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        falta.IdNomina = NominaTrabajador.Nomina.IdNomina;
                        falta.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault().IdPlantillaNominaDeduccion;
                        falta.Importe = totaldiasfaltas * factorsueldo;
                            if (falta.Importe > 0)
                                NominaTrabajador.ListaDeduccionesTrabajadores.Add(falta);

                        //if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA MATERIAL DIDACTICO").FirstOrDefault() != null)
                        //{
                        //    DeduccionesNominaTrabajador faltaayuda = new DeduccionesNominaTrabajador();

                        //    faltaayuda.EsImprimibleRecibo = true;
                        //    faltaayuda.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        //    faltaayuda.IdNomina = NominaTrabajador.Nomina.IdNomina;
                        //    faltaayuda.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA MATERIAL DIDACTICO").FirstOrDefault().IdPlantillaNominaDeduccion;



                        //    faltaayuda.Importe = (decimal)((costos.CostoMaterialDidactico + costos.CostoMaterialDidacticoExcedente) / 2) * totaldiasfaltas * 2;

                        //    NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaayuda);
                        //}

                        //if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault() != null)
                        //{
                        //    DeduccionesNominaTrabajador faltaeficiencia = new DeduccionesNominaTrabajador();

                        //    faltaeficiencia.EsImprimibleRecibo = true;
                        //    faltaeficiencia.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        //    faltaeficiencia.IdNomina = NominaTrabajador.Nomina.IdNomina;
                        //    faltaeficiencia.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdPlantillaNominaDeduccion;


                        //    faltaeficiencia.Importe = (decimal)((costos.CostoEficienciaJornada + costos.CostoEficienciaExcedente) / 2) * totaldiasfaltas * 2;
                        //    NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaeficiencia);
                        //}

                        //NominaTrabajador.DiasPagados = (short)(NominaTrabajador.DiasPagados - totaldiasfaltas);

                        VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();

                        vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt.Concepto = "INCIDENCIAS";
                        vnt.Importe = falta.Importe;

                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);

                            var variableExistente = NominaTrabajador.ListaVariablesNominaTrabajador
    .FirstOrDefault(x => x.Concepto == "TOTAL_FALTAS_QNA"
                     && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria);

                            if (variableExistente != null)
                            {
                                // Si existe, actualizar el importe
                                variableExistente.Importe += diasfaltas;
                            }
                            else
                            {
                                // Si no existe, crear nueva variable y agregarla
                                VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
                                vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                vnt1.Concepto = "TOTAL_FALTAS_QNA";
                                vnt1.Importe = diasfaltas;
                                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt1);
                            }
                        }

                }

            }
        }

    }



}