﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Deducciones
{

    public class FaltasBaseDefinitivo : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("ODES"))
                //if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion.Contains("FALTA")).FirstOrDefault() != null)
                if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion.Contains("FALTA")).FirstOrDefault() != null)
                {

                TimeSpan intervalo;
                int diasfaltas = 0;
                int totaldiasfaltas = 0;
                if (NominaTrabajador.IncidenciaTrabajador != null)
                {
                    var faltastrabajador = NominaTrabajador.IncidenciaTrabajador.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        && s.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && s.EsAplicada == false
                        && s.QuincenaParaNomina == NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
            && s.AñoParaNomina == NominaTrabajador.Nomina_stNomina.Año
                        //&& (s.FechaInicio >= NominaTrabajador.Nomina.FechaInicio && s.FechaTermino <= NominaTrabajador.Nomina.FechaTermino

                        ).OrderBy(g => g.FechaInicio).ToList();

                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                    foreach (var item in faltastrabajador)
                    {
                        FaltasTrabajador ft = new FaltasTrabajador();
                        FaltasTrabajador fq = new FaltasTrabajador();
                        FaltasTrabajador faltaAyuda = new FaltasTrabajador();
                        FaltasTrabajador faltaEficiencia = new FaltasTrabajador();

                        intervalo = item.FechaTermino.Value - item.FechaInicio;
                        diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
                        totaldiasfaltas = totaldiasfaltas + diasfaltas;

                        //falta sueldo
                        var fs = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault();

                        if (fs != null)
                        {
                            ft.Importe = costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora * diasfaltas;
                            ft.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                            ft.IdDeduccion =fs.IdDeduccion;
                            ft.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            NominaTrabajador.ListaFaltasTrabajador.Add(ft);
                        }
                        //falta QUINQUENIO
                        var fQ = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA QUINQUENIO").FirstOrDefault();

                        if (fQ   != null)
                        {
                           
                            var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault().IdPlantillaNominaPercepcion;
                            
                           var importequinquenio= NominaTrabajador.ListaPercepcionesTrabajadores.Where(q=> q.IdConvenioLaboralTrabajadorCategoria==ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                           && q.IdPlantillaNominaPercepcion==IdPlantillaNominaPercepcion ).FirstOrDefault();

                            if (importequinquenio != null)
                            {
                                fq.Importe = (importequinquenio.Importe /15) * diasfaltas;
                                fq.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                                fq.IdDeduccion = fQ.IdDeduccion;
                                fq.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                NominaTrabajador.ListaFaltasTrabajador.Add(fq);
                            }
                        }
                      

                        //falta eficiencia
                        if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault() != null)
                        {


                            faltaEficiencia.Importe = (((costos.CostoEficienciaJornada * NominaTrabajador.DiasNomina * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo)  ) / NominaTrabajador.DiasNomina) * diasfaltas;
                            faltaEficiencia.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                            faltaEficiencia.IdDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdDeduccion;
                            faltaEficiencia.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            NominaTrabajador.ListaFaltasTrabajador.Add(faltaEficiencia);
                        }

                    }

                    if (diasfaltas > 0)
                    {
                        DeduccionesNominaTrabajador falta = new DeduccionesNominaTrabajador();
                        var fs = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault();
                        if (fs != null)
                        {
                            falta.EsImprimibleRecibo = true;
                            falta.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            falta.IdNomina = NominaTrabajador.Nomina.IdNomina;
                            falta.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault().IdPlantillaNominaDeduccion;
                            falta.Importe = totaldiasfaltas * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora;
                            if (falta.Importe > 0)
                                NominaTrabajador.ListaDeduccionesTrabajadores.Add(falta);
                        }

                        //falta QUINQUENIO
                        var fQ = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA QUINQUENIO").FirstOrDefault();

                        if (fQ != null)
                        {
                            DeduccionesNominaTrabajador faltaq = new DeduccionesNominaTrabajador();

                            var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault().IdPlantillaNominaPercepcion;

                            var importequinquenio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                             && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                            if (importequinquenio != null)
                            {
                                faltaq.EsImprimibleRecibo = true;
                                faltaq.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                faltaq.IdNomina = NominaTrabajador.Nomina.IdNomina;
                                faltaq.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA QUINQUENIO").FirstOrDefault().IdPlantillaNominaDeduccion;
                                faltaq.Importe = (importequinquenio.Importe / 15) * totaldiasfaltas ;
                                if (faltaq.Importe > 0)
                                    NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaq);
                            }
                        }

                        

                        if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault() != null)
                        {
                            DeduccionesNominaTrabajador faltaeficiencia = new DeduccionesNominaTrabajador();

                            faltaeficiencia.EsImprimibleRecibo = true;
                            faltaeficiencia.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            faltaeficiencia.IdNomina = NominaTrabajador.Nomina.IdNomina;
                            faltaeficiencia.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdPlantillaNominaDeduccion;
                            //                            faltaeficiencia.Importe = (decimal)(NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().Importe / 15) * totaldiasfaltas;
                            faltaeficiencia.Importe = (((costos.CostoEficienciaJornada * NominaTrabajador.DiasNomina * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo) ) / NominaTrabajador.DiasNomina) * diasfaltas;
                            if (faltaeficiencia.Importe > 0)
                                NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaeficiencia);
                        }

                        NominaTrabajador.DiasPagados = (short)(NominaTrabajador.DiasPagados - totaldiasfaltas);

                        VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();

                        vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        vnt.Concepto = "INCIDENCIAS";
                        vnt.Importe = falta.Importe;

                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);


                        var variableExistente = NominaTrabajador.ListaVariablesNominaTrabajador
            .FirstOrDefault(x => x.Concepto == "TOTAL_FALTAS_QNA"
                             && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria);

                        if (variableExistente != null)
                        {
                            // Si existe, actualizar el importe
                            variableExistente.Importe += diasfaltas;
                        }
                        else
                        {
                            // Si no existe, crear nueva variable y agregarla
                            VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
                            vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            vnt1.Concepto = "TOTAL_FALTAS_QNA";
                            vnt1.Importe = diasfaltas;
                            NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt1);
                        }


                    }

                }

            }
        }

    }



}