﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Deducciones
{

    public class FaltasBase : IDeduccionBehavior
    {
        private void creaFalta (Nomina_stNominaTrabajador NominaTrabajador , Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, List<IncidenciaPermiso_stIncidenciaTrabajador> faltastrabajador, int diaslaborados)
        {
            Plazas_ctCostoHoraJornada costos = new Plazas_ctCostoHoraJornada();
            var totaldiasfaltas = 0;
            var diasfaltas = 0;
            foreach (var item in faltastrabajador)
            {
                 costos = NominaTrabajador.Plazas_ctCostoHoraJornadaTodos
             .Where(c => c.IdCategoria==item.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.IdCategoria
             &&  c.FechaInicio <= NominaTrabajador.Nomina_stNomina.FechaInicio && c.FechaTermino >= NominaTrabajador.Nomina_stNomina.FechaTermino).FirstOrDefault();


                FaltasTrabajador ft = new FaltasTrabajador();
                FaltasTrabajador fq = new FaltasTrabajador();
                FaltasTrabajador fga = new FaltasTrabajador();
                FaltasTrabajador zm = new FaltasTrabajador();
                FaltasTrabajador faltaAyuda = new FaltasTrabajador();
                FaltasTrabajador faltaEficiencia = new FaltasTrabajador();

                var intervalo = item.FechaTermino.Value - item.FechaInicio;
                 diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
                 totaldiasfaltas = totaldiasfaltas + diasfaltas;

            

                //falta sueldo
                var fs = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault();

                if (fs != null)
                {
                    ft.Importe = costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora * diasfaltas;
                    ft.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                    ft.IdDeduccion = fs.IdDeduccion;
                    ft.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    ft.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                    NominaTrabajador.ListaFaltasTrabajador.Add(ft);
                }

                //var falta  APOYO ZONA MARGINAL
                var PZM = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA APOYO ZONA MARGINAL").FirstOrDefault();
                var regprezm = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO ZONA MARGINAL").FirstOrDefault();
                bool tienezonmarginal = false;
                if (regprezm != null)
                {
                    var percepPZM = NominaTrabajador.ListaPercepcionesTrabajadores.Where(x => x.IdPlantillaNominaPercepcion== regprezm.IdPlantillaNominaPercepcion
                    && x.IdConvenioLaboralTrabajadorCategoria==ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                    if (percepPZM != null)
                        tienezonmarginal = true;
                }

                short IdPlantillaNominaPercepcion = 0;
                if (PZM != null && tienezonmarginal)
                {

                    var PlantillaNominaPercepcionReg = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO ZONA MARGINAL").FirstOrDefault();

                    if (PlantillaNominaPercepcionReg!=null)
                        IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO ZONA MARGINAL").FirstOrDefault().IdPlantillaNominaPercepcion;

                    var importequinquenio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                    if (importequinquenio != null)
                    {
                        zm.Importe = (importequinquenio.Importe / diaslaborados) * diasfaltas;
                        zm.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                        zm.IdDeduccion = PZM.IdDeduccion;
                        zm.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        zm.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                        NominaTrabajador.ListaFaltasTrabajador.Add(zm);
                    }
                }

                //var falta gasto administrativo
                var GA = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA GASTO ADMINISTRATIVO").FirstOrDefault();

                if (GA != null)
                {

                     var PlantillaNominaPercepciongto = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault();

                    IdPlantillaNominaPercepcion = 0;
                    if (PlantillaNominaPercepciongto!=null)
                     IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaPercepcion;

                    var importequinquenio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                    if (importequinquenio != null)
                    {
                        fga.Importe = (importequinquenio.Importe / diaslaborados) * diasfaltas;
                        fga.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                        fga.IdDeduccion = GA.IdDeduccion;
                        fga.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        fga.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                        NominaTrabajador.ListaFaltasTrabajador.Add(fga);
                    }
                }

                //falta QUINQUENIO
                var fQ = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA QUINQUENIO").FirstOrDefault();

                if (fQ != null)
                {
                    IdPlantillaNominaPercepcion = 0;
                     var PlantillaNominaPercepcionQuin = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault();
                   
                    if(PlantillaNominaPercepcionQuin!=null)
                     IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault().IdPlantillaNominaPercepcion;

                    var importequinquenio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                    if (importequinquenio != null)
                    {
                        fq.Importe = (importequinquenio.Importe / diaslaborados) * diasfaltas;
                        fq.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                        fq.IdDeduccion = fQ.IdDeduccion;
                        fq.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        fq.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                        NominaTrabajador.ListaFaltasTrabajador.Add(fq);
                    }
                }
                // falta ayuda
                if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault() != null)
                {
                    faltaAyuda.Importe = (decimal)(NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault().Importe / 15) * diasfaltas;
                    faltaAyuda.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                    faltaAyuda.IdDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA AYUDA PARA TRANSPORTE").FirstOrDefault().IdDeduccion;
                    faltaAyuda.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    faltaAyuda.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                    NominaTrabajador.ListaFaltasTrabajador.Add(faltaAyuda);
                }


                //falta eficiencia
                if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault() != null)
                {
                    //faltaEficiencia.Importe = (decimal)(NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().Importe / 15) * diasfaltas;
                    faltaEficiencia.Importe = (((costos.CostoEficienciaJornada * NominaTrabajador.DiasNomina * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo)) / NominaTrabajador.DiasNomina) * diasfaltas;

                    faltaEficiencia.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                    faltaEficiencia.IdDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdDeduccion;
                    faltaEficiencia.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    faltaEficiencia.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                    NominaTrabajador.ListaFaltasTrabajador.Add(faltaEficiencia);
                }

            }

            if (diasfaltas > 0)
            {
                DeduccionesNominaTrabajador falta = new DeduccionesNominaTrabajador();
                var fs = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault();
                if (fs != null)
                {
                   var importefs= NominaTrabajador.ListaFaltasTrabajador.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                    && a.IdDeduccion == fs.IdDeduccion).Sum(a=> a.Importe);

                    falta.EsImprimibleRecibo = true;
                    falta.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    falta.IdNomina = NominaTrabajador.Nomina.IdNomina;
                    falta.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault().IdPlantillaNominaDeduccion;
                    //falta.Importe = totaldiasfaltas * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora;
                    falta.Importe = importefs;
                    if (falta.Importe > 0)
                        NominaTrabajador.ListaDeduccionesTrabajadores.Add(falta);
                }

                //falta QUINQUENIO
                var fQ = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA QUINQUENIO").FirstOrDefault();

                if (fQ != null)
                {
                    DeduccionesNominaTrabajador faltaq = new DeduccionesNominaTrabajador();

                     var PlantillaNominaPercepcionquin = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault();

                   var  IdPlantillaNominaPercepcion = 0;
                    if (PlantillaNominaPercepcionquin!=null)
                     IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault().IdPlantillaNominaPercepcion;

                    var importequinquenio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                     && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                    if (importequinquenio != null)
                    {
                        

                        var quinquenio_li = NominaTrabajador.ListaFaltasTrabajador.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                   && a.IdDeduccion == fQ.IdDeduccion).Sum(a => a.Importe);


                        faltaq.EsImprimibleRecibo = true;
                        faltaq.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        faltaq.IdNomina = NominaTrabajador.Nomina.IdNomina;
                        faltaq.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA QUINQUENIO").FirstOrDefault().IdPlantillaNominaDeduccion;
                        faltaq.Importe = quinquenio_li;
                        //  faltaq.Importe = (importequinquenio.Importe / diaslaborados) * totaldiasfaltas;
                        if (faltaq.Importe > 0)
                            NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaq);
                    }
                }

                //falta GASTO
                var ga = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA GASTO ADMINISTRATIVO").FirstOrDefault();

                if (ga != null)
                {
                    DeduccionesNominaTrabajador faltaGA = new DeduccionesNominaTrabajador();

                    var PlantillaNominaPercepcionGA= NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault();

                   short IdPlantillaNominaPercepcion = 0;
                    if (PlantillaNominaPercepcionGA!=null)
                     IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaPercepcion;

                    var importequinquenio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                     && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                    if (importequinquenio != null)
                    {
                        var quinqueniogto_li = NominaTrabajador.ListaFaltasTrabajador.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                   && a.IdDeduccion == ga.IdDeduccion).Sum(a => a.Importe);

                        faltaGA.EsImprimibleRecibo = true;
                        faltaGA.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        faltaGA.IdNomina = NominaTrabajador.Nomina.IdNomina;
                        faltaGA.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaDeduccion;
                        //faltaGA.Importe = (importequinquenio.Importe / diaslaborados) * totaldiasfaltas;
                        faltaGA.Importe =quinqueniogto_li;
                        if (faltaGA.Importe > 0)
                            NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaGA);
                    }
                }

                var fayudagto = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA AYUDA PARA TRANSPORTE").FirstOrDefault();

                if (fayudagto != null)
                {
                    DeduccionesNominaTrabajador faltaayuda = new DeduccionesNominaTrabajador();

                    var PlantillaNominaPercepcionAT = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault();

                    if (PlantillaNominaPercepcionAT != null)
                    {
                        var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault().IdPlantillaNominaPercepcion;

                        var ayudagto_li = NominaTrabajador.ListaFaltasTrabajador.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                    && a.IdDeduccion == fayudagto.IdDeduccion).Sum(a => a.Importe);


                        //var importef = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        // && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                        faltaayuda.EsImprimibleRecibo = true;
                        faltaayuda.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        faltaayuda.IdNomina = NominaTrabajador.Nomina.IdNomina;
                        faltaayuda.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA AYUDA PARA TRANSPORTE").FirstOrDefault().IdPlantillaNominaDeduccion;
                        //faltaayuda.Importe = (importef.Importe / diaslaborados) * totaldiasfaltas;
                        faltaayuda.Importe = ayudagto_li;
                        if (faltaayuda.Importe > 0)
                            NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaayuda);
                    }
                }

                var faltaefic = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault();
                if (faltaefic != null)
                {
                    DeduccionesNominaTrabajador faltaeficiencia = new DeduccionesNominaTrabajador();
                    var PlantillaNominaPercepcionET = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault();
                    if (PlantillaNominaPercepcionET != null)
                    {
                        var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdPlantillaNominaPercepcion;

                        var faltaefic_li = NominaTrabajador.ListaFaltasTrabajador.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                   && a.IdDeduccion == faltaefic.IdDeduccion).Sum(a => a.Importe);

                        //var importef = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        // && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                        faltaeficiencia.EsImprimibleRecibo = true;
                        faltaeficiencia.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        faltaeficiencia.IdNomina = NominaTrabajador.Nomina.IdNomina;
                        faltaeficiencia.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdPlantillaNominaDeduccion;
                        faltaeficiencia.Importe = faltaefic_li;
                        //faltaeficiencia.Importe = (importef.Importe / diaslaborados) * totaldiasfaltas;
                        if (faltaeficiencia.Importe > 0)
                            NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaeficiencia);
                    }
                }

                var zonmar = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA APOYO ZONA MARGINAL").FirstOrDefault();
                if (zonmar != null)
                {
                    DeduccionesNominaTrabajador faltamarginal = new DeduccionesNominaTrabajador();

                    var PlantillaNominaPercepcionZM = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO ZONA MARGINAL").FirstOrDefault();
                    if (PlantillaNominaPercepcionZM != null)
                    {

                        var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO ZONA MARGINAL").FirstOrDefault().IdPlantillaNominaPercepcion;

                        //var importef = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                        // && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();
                        var zonmar_li = NominaTrabajador.ListaFaltasTrabajador.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                 && a.IdDeduccion == zonmar.IdDeduccion).Sum(a => a.Importe);

                        if (zonmar_li != null)
                        {
                            faltamarginal.EsImprimibleRecibo = true;
                            faltamarginal.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            faltamarginal.IdNomina = NominaTrabajador.Nomina.IdNomina;
                            faltamarginal.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA APOYO ZONA MARGINAL").FirstOrDefault().IdPlantillaNominaDeduccion;
                            //faltamarginal.Importe = (importef.Importe / diaslaborados) * totaldiasfaltas;
                            faltamarginal.Importe = zonmar_li;
                            if (faltamarginal.Importe > 0)
                                NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltamarginal);
                        }
                    }
                }
                NominaTrabajador.DiasPagados = (short)(NominaTrabajador.DiasPagados - totaldiasfaltas);

                VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();

                vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                vnt.Concepto = "INCIDENCIAS";
                vnt.Importe = falta.Importe;

                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);


                var variableExistente = NominaTrabajador.ListaVariablesNominaTrabajador
    .FirstOrDefault(x => x.Concepto == "TOTAL_FALTAS_QNA"
                     && x.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria);

                if (variableExistente != null)
                {
                    // Si existe, actualizar el importe
                    variableExistente.Importe += diasfaltas;
                }
                else
                {
                    // Si no existe, crear nueva variable y agregarla
                    VariablesNominaTrabajador vnt1 = new VariablesNominaTrabajador();
                    vnt1.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    vnt1.Concepto = "TOTAL_FALTAS_QNA";
                    vnt1.Importe = diasfaltas;
                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt1);
                }


            }
        }
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            //if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("ODES"))
            // if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion.Contains("FALTA")).FirstOrDefault() != null)
            if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion.Contains("FALTA")).FirstOrDefault() != null)
            {
                int diaslaborados = (int)NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.Concepto == "DIASLABORADOS" && s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe;

                List<IncidenciaPermiso_stIncidenciaTrabajador> faltastrabajador;

                TimeSpan intervalo;
                int diasfaltas = 0;
                int totaldiasfaltas = 0;
                if (NominaTrabajador.IncidenciaTrabajador != null)
                {
            //        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
            //        {
            //            faltastrabajador = NominaTrabajador.IncidenciaTrabajadorCCT.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
            //                && s.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA")
            //                && s.QuincenaParaNomina == NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
            //    && s.AñoParaNomina == NominaTrabajador.Nomina_stNomina.Año

            //                ).OrderBy(g => g.FechaInicio).ToList();
            //        }
            //        else
            //        { faltastrabajador = NominaTrabajador.IncidenciaTrabajador.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
            //            && s.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && s.EsAplicada == false
            //            && s.QuincenaParaNomina == NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
            //&& s.AñoParaNomina == NominaTrabajador.Nomina_stNomina.Año
                             

            //            ).OrderBy(g => g.FechaInicio).ToList();
            //        }

                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
                    {
                        faltastrabajador = NominaTrabajador.IncidenciaTrabajadorCCT.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador== ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                            && s.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA")
                            && s.QuincenaParaNomina == NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
                && s.AñoParaNomina == NominaTrabajador.Nomina_stNomina.Año

                            ).OrderBy(g => g.FechaInicio).ToList();
                    }
                    else
                    {
                        faltastrabajador = NominaTrabajador.IncidenciaTrabajador.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                        && s.Catalogos_ctTipoIncidencia.Incidencia.Contains("FALTA") && s.EsAplicada == false
                        && s.QuincenaParaNomina == NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes
            && s.AñoParaNomina == NominaTrabajador.Nomina_stNomina.Año


                        ).OrderBy(g => g.FechaInicio).ToList();
                    }

                    var conveniostrabajador = faltastrabajador.GroupBy(a => a.IdConvenioLaboralTrabajadorCategoria).Select(a => a.Key);

                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();

                    foreach (var item in conveniostrabajador)
                    {
                        var faltas = faltastrabajador.Where(q => q.IdConvenioLaboralTrabajadorCategoria == item).ToList();
                         
                        creaFalta(NominaTrabajador, ConvenioLaboralTrabajadorCategoria, faltastrabajador,  diaslaborados);
                    }

                    
                    
                    //foreach (var item in faltastrabajador)
                    //{
                    //    FaltasTrabajador ft = new FaltasTrabajador();
                    //    FaltasTrabajador fq = new FaltasTrabajador();
                    //    FaltasTrabajador fga = new FaltasTrabajador();
                    //    FaltasTrabajador zm = new FaltasTrabajador();
                    //    FaltasTrabajador faltaAyuda = new FaltasTrabajador();
                    //    FaltasTrabajador faltaEficiencia = new FaltasTrabajador();

                    //    intervalo = item.FechaTermino.Value - item.FechaInicio;
                    //    diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
                    //    totaldiasfaltas = totaldiasfaltas + diasfaltas;

                    //    //falta sueldo
                    //    var fs = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault();

                    //    if (fs != null)
                    //    {
                    //        ft.Importe = costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora * diasfaltas;
                    //        ft.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                    //        ft.IdDeduccion =fs.IdDeduccion;
                    //        ft.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //        NominaTrabajador.ListaFaltasTrabajador.Add(ft);
                    //    }

                    //    //var falta  APOYO ZONA MARGINAL
                    //    var PZM = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA APOYO ZONA MARGINAL").FirstOrDefault();

                    //    if (PZM != null)
                    //    {

                    //        var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO ZONA MARGINAL").FirstOrDefault().IdPlantillaNominaPercepcion;

                    //        var importequinquenio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    //        && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                    //        if (importequinquenio != null)
                    //        {
                    //            zm.Importe = (importequinquenio.Importe / diaslaborados) * diasfaltas;
                    //            zm.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                    //            zm.IdDeduccion = PZM.IdDeduccion;
                    //            zm.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //            NominaTrabajador.ListaFaltasTrabajador.Add(zm);
                    //        }
                    //    }

                    //    //var falta gasto administrativo
                    //    var GA = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA GASTO ADMINISTRATIVO").FirstOrDefault();

                    //        if (GA != null)
                    //        {

                    //        var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaPercepcion;

                    //        var importequinquenio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    //        && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                    //        if (importequinquenio != null)
                    //        {
                    //            fga.Importe = (importequinquenio.Importe / diaslaborados) * diasfaltas;
                    //            fga.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                    //            fga.IdDeduccion = GA.IdDeduccion;
                    //            fga.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //            NominaTrabajador.ListaFaltasTrabajador.Add(fga);
                    //        }
                    //    }

                    //    //falta QUINQUENIO
                    //    var fQ = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA QUINQUENIO").FirstOrDefault();

                    //    if (fQ   != null)
                    //    {
                           
                    //        var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault().IdPlantillaNominaPercepcion;
                            
                    //       var importequinquenio= NominaTrabajador.ListaPercepcionesTrabajadores.Where(q=> q.IdConvenioLaboralTrabajadorCategoria==ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    //       && q.IdPlantillaNominaPercepcion==IdPlantillaNominaPercepcion ).FirstOrDefault();

                    //        if (importequinquenio != null)
                    //        {
                    //            fq.Importe = (importequinquenio.Importe / diaslaborados) * diasfaltas;
                    //            fq.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                    //            fq.IdDeduccion = fQ.IdDeduccion;
                    //            fq.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //            NominaTrabajador.ListaFaltasTrabajador.Add(fq);
                    //        }
                    //    }
                    //    // falta ayuda
                    //    if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault() != null)
                    //    {
                    //        faltaAyuda.Importe = (decimal)(NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault().Importe / 15) * diasfaltas;
                    //        faltaAyuda.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                    //        faltaAyuda.IdDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA AYUDA PARA TRANSPORTE").FirstOrDefault().IdDeduccion;
                    //        faltaAyuda.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //        NominaTrabajador.ListaFaltasTrabajador.Add(faltaAyuda);
                    //    }


                    //    //falta eficiencia
                    //    if (NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault() != null)
                    //    {
                    //        //faltaEficiencia.Importe = (decimal)(NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().Importe / 15) * diasfaltas;
                    //        faltaEficiencia.Importe = (((costos.CostoEficienciaJornada * NominaTrabajador.DiasNomina * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo) ) / NominaTrabajador.DiasNomina) * diasfaltas;

                    //        faltaEficiencia.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                    //        faltaEficiencia.IdDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdDeduccion;
                    //        faltaEficiencia.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //        NominaTrabajador.ListaFaltasTrabajador.Add(faltaEficiencia);
                    //    }

                    //}

                    //if (diasfaltas > 0)
                    //{
                    //    DeduccionesNominaTrabajador falta = new DeduccionesNominaTrabajador();
                    //    var fs = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault();
                    //    if (fs != null)
                    //    {
                    //        falta.EsImprimibleRecibo = true;
                    //        falta.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //        falta.IdNomina = NominaTrabajador.Nomina.IdNomina;
                    //        falta.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault().IdPlantillaNominaDeduccion;
                    //        falta.Importe = totaldiasfaltas * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora;

                    //        NominaTrabajador.ListaDeduccionesTrabajadores.Add(falta);
                    //    }

                    //    //falta QUINQUENIO
                    //    var fQ = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA QUINQUENIO").FirstOrDefault();

                    //    if (fQ != null)
                    //    {
                    //        DeduccionesNominaTrabajador faltaq = new DeduccionesNominaTrabajador();

                    //        var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "QUINQUENIO").FirstOrDefault().IdPlantillaNominaPercepcion;

                    //        var importequinquenio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    //         && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                    //        if (importequinquenio != null)
                    //        {
                    //            faltaq.EsImprimibleRecibo = true;
                    //            faltaq.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //            faltaq.IdNomina = NominaTrabajador.Nomina.IdNomina;
                    //            faltaq.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA QUINQUENIO").FirstOrDefault().IdPlantillaNominaDeduccion;
                    //            faltaq.Importe = (importequinquenio.Importe / diaslaborados) * totaldiasfaltas ;

                    //            NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaq);
                    //        }
                    //    }

                    //    //falta GASTO
                    //    var ga = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA GASTO ADMINISTRATIVO").FirstOrDefault();

                    //    if (ga != null)
                    //    {
                    //        DeduccionesNominaTrabajador faltaGA = new DeduccionesNominaTrabajador();

                    //        var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaPercepcion;

                    //        var importequinquenio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    //         && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                    //        if (importequinquenio != null)
                    //        {
                    //            faltaGA.EsImprimibleRecibo = true;
                    //            faltaGA.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //            faltaGA.IdNomina = NominaTrabajador.Nomina.IdNomina;
                    //            faltaGA.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA GASTO ADMINISTRATIVO").FirstOrDefault().IdPlantillaNominaDeduccion;
                    //            faltaGA.Importe = (importequinquenio.Importe / diaslaborados) * totaldiasfaltas;

                    //            NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaGA);
                    //        }
                    //    }

                    //    if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA AYUDA PARA TRANSPORTE").FirstOrDefault() != null)
                    //    {
                    //        DeduccionesNominaTrabajador faltaayuda = new DeduccionesNominaTrabajador();

                    //        var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault().IdPlantillaNominaPercepcion;

                    //        var importef = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    //         && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                    //        faltaayuda.EsImprimibleRecibo = true;
                    //        faltaayuda.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //        faltaayuda.IdNomina = NominaTrabajador.Nomina.IdNomina;
                    //        faltaayuda.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA AYUDA PARA TRANSPORTE").FirstOrDefault().IdPlantillaNominaDeduccion;
                    //        faltaayuda.Importe = (importef.Importe  / diaslaborados) * totaldiasfaltas;

                    //        NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaayuda);
                    //    }

                    //    if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault() != null)
                    //    {
                    //        DeduccionesNominaTrabajador faltaeficiencia = new DeduccionesNominaTrabajador();
                    //        var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdPlantillaNominaPercepcion;

                    //        var importef = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    //         && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();

                    //        faltaeficiencia.EsImprimibleRecibo = true;
                    //        faltaeficiencia.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //        faltaeficiencia.IdNomina = NominaTrabajador.Nomina.IdNomina;
                    //        faltaeficiencia.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdPlantillaNominaDeduccion;
                    //        faltaeficiencia.Importe = (importef.Importe / diaslaborados) * totaldiasfaltas;
                    //        NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaeficiencia);
                    //    }

                    //    if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA APOYO ZONA MARGINAL").FirstOrDefault() != null)
                    //    {
                    //        DeduccionesNominaTrabajador faltamarginal= new DeduccionesNominaTrabajador();

                    //        var IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "APOYO ZONA MARGINAL").FirstOrDefault().IdPlantillaNominaPercepcion;

                    //        var importef = NominaTrabajador.ListaPercepcionesTrabajadores.Where(q => q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    //         && q.IdPlantillaNominaPercepcion == IdPlantillaNominaPercepcion).FirstOrDefault();
                    //        if (importef != null)
                    //        {
                    //            faltamarginal.EsImprimibleRecibo = true;
                    //            faltamarginal.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //            faltamarginal.IdNomina = NominaTrabajador.Nomina.IdNomina;
                    //            faltamarginal.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA APOYO ZONA MARGINAL").FirstOrDefault().IdPlantillaNominaDeduccion;
                    //            faltamarginal.Importe = (importef.Importe / diaslaborados) * totaldiasfaltas;
                    //            NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltamarginal);
                    //        }
                    //    }
                    //    NominaTrabajador.DiasPagados = (short)(NominaTrabajador.DiasPagados - totaldiasfaltas);

                    //    VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();

                    //    vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    //    vnt.Concepto = "INCIDENCIAS";
                    //    vnt.Importe = falta.Importe;

                    //    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);



                    //}

                }

            }
        }

    }



}