﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Deducciones
{

    public class Faltas : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            TimeSpan intervalo;
            int diasfaltas = 0;
            int totaldiasfaltas = 0;
            if (NominaTrabajador.IncidenciaTrabajador != null)
            {
                var faltastrabajador = NominaTrabajador.IncidenciaTrabajador.Where(s => s.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                    && s.Catalogos_ctTipoIncidencia.Incidencia == "FALTA POR DÍA"
                    //&& (s.FechaInicio >= NominaTrabajador.Nomina.FechaInicio && s.FechaTermino <= NominaTrabajador.Nomina.FechaTermino

                    ).OrderBy(g=> g.FechaInicio ).ToList();
                
                Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                foreach (var item in faltastrabajador)
                {
                    FaltasTrabajador ft = new FaltasTrabajador();
                    FaltasTrabajador faltaAyuda = new FaltasTrabajador();
                    FaltasTrabajador faltaEficiencia = new FaltasTrabajador();

                    intervalo = item.FechaTermino - item.FechaInicio;
                    diasfaltas = System.Convert.ToInt32(intervalo.TotalDays) + 1;
                    totaldiasfaltas = totaldiasfaltas + diasfaltas;

                    //falta sueldo

                    ft.Importe = costos.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora * diasfaltas;
                    ft.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                    ft.IdDeduccion = NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault().IdDeduccion;
                    ft.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    NominaTrabajador.ListaFaltasTrabajador.Add(ft);

                    // falta ayuda
                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Percepciones_stPlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault() != null)
                    {
                        faltaAyuda.Importe = (decimal)(NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Percepciones_stPlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault().Importe / 15) * totaldiasfaltas;
                        faltaAyuda.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                        faltaAyuda.IdDeduccion = NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA AYUDA PARA TRANSPORTE").FirstOrDefault().IdDeduccion;
                        faltaAyuda.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        NominaTrabajador.ListaFaltasTrabajador.Add(faltaAyuda);
                    }


                    //falta eficiencia
                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Percepciones_stPlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault() != null)
                    {
                        faltaEficiencia.Importe = (decimal)(NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Percepciones_stPlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().Importe / 15) * totaldiasfaltas;
                        faltaEficiencia.IdIncidenciaTrabajador = item.IdIncidenciaTrabajador;
                        faltaEficiencia.IdDeduccion = NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Deducciones_stPlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdDeduccion;
                        faltaEficiencia.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        NominaTrabajador.ListaFaltasTrabajador.Add(faltaEficiencia);
                    }

                }

                if (diasfaltas > 0)
                {
                    DeduccionesNominaTrabajador falta = new DeduccionesNominaTrabajador();

                    falta.EsImprimibleRecibo = true;
                    falta.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    falta.IdNomina = NominaTrabajador.Nomina.IdNomina;
                    falta.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA SUELDO").FirstOrDefault().IdPlantillaNominaDeduccion;
                    falta.Importe = totaldiasfaltas * costos.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora;

                    NominaTrabajador.ListaDeduccionesTrabajadores.Add(falta);

                    if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA AYUDA PARA TRANSPORTE").FirstOrDefault() != null)
                    {
                        DeduccionesNominaTrabajador faltaayuda = new DeduccionesNominaTrabajador();

                        faltaayuda.EsImprimibleRecibo = true;
                        faltaayuda.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        faltaayuda.IdNomina = NominaTrabajador.Nomina.IdNomina;
                        faltaayuda.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA AYUDA PARA TRANSPORTE").FirstOrDefault().IdPlantillaNominaDeduccion;
                        faltaayuda.Importe = (decimal)(NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Percepciones_stPlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "AYUDA PARA TRANSPORTE").FirstOrDefault().Importe / 15) * totaldiasfaltas;

                        NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaayuda);
                    }

                    if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault() != null)
                    {
                        DeduccionesNominaTrabajador faltaeficiencia = new DeduccionesNominaTrabajador();

                        faltaeficiencia.EsImprimibleRecibo = true;
                        faltaeficiencia.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        faltaeficiencia.IdNomina = NominaTrabajador.Nomina.IdNomina;
                        faltaeficiencia.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "FALTA EFICIENCIA EN EL TRABAJO").FirstOrDefault().IdPlantillaNominaDeduccion;
                        faltaeficiencia.Importe = (decimal)(NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Percepciones_stPlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "EFICIENCIA EN EL TRABAJO").FirstOrDefault().Importe / 15) * totaldiasfaltas;
                        NominaTrabajador.ListaDeduccionesTrabajadores.Add(faltaeficiencia);
                    }

                    NominaTrabajador.DiasEfectivosLaborados = (short)(NominaTrabajador.DiasPagados - totaldiasfaltas);

                    VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();

                    vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    vnt.Concepto = "INCIDENCIAS";
                    vnt.Importe = falta.Importe;

                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);
                }

            }
        }

    }



}