﻿using Nova.Models.Nomina;
using System;
using System.Data;
using System.Data.Entity;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;

namespace Nova.Models.Calculos.Deducciones
{

    public class EnfermedadGeneralContrato : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();
            if (NominaTrabajador.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "ENFERMEDAD GENERAL").SingleOrDefault() != null)
            {

                //var egq = NominaTrabajador.IncidenciaTrabajador.Where
                //    (i => i.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                //        && i.Catalogos_ctTipoIncidencia.Incidencia == "ENFERMEDAD GENERAL"
                //        && (
                //            (i.FechaInicio <= NominaTrabajador.Nomina.FechaInicio && i.FechaTermino >= NominaTrabajador.Nomina.FechaInicio)
                //            || (i.FechaInicio <= NominaTrabajador.Nomina.FechaTermino && NominaTrabajador.Nomina.FechaTermino <= i.FechaTermino) ||
                //            (NominaTrabajador.Nomina.FechaInicio <= i.FechaInicio && i.FechaTermino <= NominaTrabajador.Nomina.FechaTermino)
                //            || (i.FechaInicio <= NominaTrabajador.Nomina.FechaInicio && i.FechaTermino >= NominaTrabajador.Nomina.FechaTermino)
                //            )
                //        ).OrderBy(j => j.FechaInicio).ToList();

                var egq = NominaTrabajador.IncidenciasTrabajadores.Where
                             (i => i.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
                                 //|| ((i.FechaInicio <= NominaTrabajador.Nomina.FechaInicio && i.FechaTermino <= NominaTrabajador.Nomina.FechaTermino) || (i.FechaInicio <= NominaTrabajador.Nomina.FechaTermino && i.FechaTermino <= NominaTrabajador.Nomina.FechaTermino))
                                 && i.Catalogos_ctTipoIncidencia.Incidencia == "INCAPACIDAD POR ENFERMEDAD GENERAL"
                                 && i.FechaAplicacionIncapacidad == NominaTrabajador.Nomina_stNomina.FechaInicio
                                 && i.EsAplicada == false
                                 ).OrderBy(j => j.FechaInicio).ToList();

                if (egq.Count() > 0)
                {
                    int Dias40Acumulados = 0;
                    //var hastadosincidencias = faltastrabajador.Take(1);
                    DateTime ff;
                    String qna = NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes;
                    decimal sumapercepcionesquincenales = (NominaTrabajador.ListaPercepcionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe));
                    decimal percepciondiaria = sumapercepcionesquincenales / 15M;
                    decimal montomaximodescuento = sumapercepcionesquincenales
                                                    - NominaTrabajador.ListaDeduccionesTrabajadores.Where(v => v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).Sum(f => f.Importe);

                    foreach (var incidencia in egq)
                    {
                        int Dias40Quincena = 0, Dias100Acumulados = 0, Dias100Quincena = 0, diasincidencia = 0;
                        if (incidencia.EsSubsecuente)
                        {
                            Dias100Acumulados = db.Nomina_IncidenciaPermisoCalculo.Where(z => z.IdIncidenciaTrabajador == incidencia.IdIncidenciaTrabajadorPadre).Select(z => z.DiasPagados100).Sum();
                        }
                        else
                        {
                            Dias100Acumulados = db.Nomina_IncidenciaPermisoCalculo.Where(z => z.IdIncidenciaTrabajador == incidencia.IdIncidenciaTrabajador).Select(z => z.DiasPagados100).Sum();
                        }
                        //else
                        //{
                        //    Dias40Acumulados= db.IncidenciaPermisoCalculo.Where(z => z.IdIncidenciaTrabajador == incidencia.IdIncidenciaTrabajador).Select(z => z.DiasPagados100).Sum();
                        //}
                        //var ic= db.IncidenciaPermisoCalculo.Where(z => z.IdIncidenciaTrabajador == incidencia.IdIncidenciaTrabajadorPadre).ToList();
                        //if (ic.Count >0)
                        //{
                        //    Dias100Acumulados = ic.Sum(x => x.DiasPagados100);
                        //}
                        Boolean EsDiscontinua = EsUnaQna(incidencia.FechaInicio, incidencia.FechaTermino.Value, NominaTrabajador);
                        //if (incidencia.IdIncidenciaTrabajadorPadre == null)
                        //{
                        if (EsDiscontinua)
                        {

                            if (NominaTrabajador.Nomina.FechaInicio < incidencia.FechaInicio && NominaTrabajador.Nomina.FechaTermino < incidencia.FechaTermino)
                            {
                                diasincidencia = (int)(NominaTrabajador.Nomina.FechaTermino - incidencia.FechaInicio).Days + 1;

                            }
                            else
                            if (NominaTrabajador.Nomina.FechaInicio > incidencia.FechaInicio && NominaTrabajador.Nomina.FechaTermino > incidencia.FechaTermino)
                            {
                                diasincidencia = (int)(incidencia.FechaTermino - incidencia.FechaInicio).Value.Days + 1;

                            }
                            else
                            {
                                diasincidencia = (int)(NominaTrabajador.Nomina.FechaTermino - NominaTrabajador.Nomina.FechaInicio).Days + 1;
                            }
                        }
                        else
                        {
                            diasincidencia = (int)(incidencia.FechaTermino - incidencia.FechaInicio).Value.Days + 1;
                        }

                        //}
                        if (diasincidencia > 15)
                        {
                            diasincidencia = 15;
                        }

                        switch (Dias100Acumulados)
                        {
                            case 0:
                                if (diasincidencia <= 3)
                                {
                                    Dias100Quincena = diasincidencia;
                                    Dias40Quincena = 0;
                                }
                                else
                                {
                                    Dias100Quincena = 3;
                                    Dias40Quincena = diasincidencia - 3;
                                }
                                break;
                            case 1:
                                if (diasincidencia <= 2)
                                {
                                    Dias100Quincena = Dias100Acumulados + diasincidencia;
                                    Dias40Quincena = 0;
                                }
                                else
                                {
                                    Dias100Quincena = 2;
                                    Dias40Quincena = diasincidencia - 2;
                                }
                                break;
                            case 2:
                                if (diasincidencia == 1)
                                {
                                    Dias100Quincena = 1;
                                    Dias40Quincena = 0;
                                }
                                else
                                {
                                    Dias100Quincena = 1;
                                    Dias40Quincena = diasincidencia - 1;
                                }
                                break;
                            case 3:
                                {
                                    Dias100Quincena = 0;
                                    Dias40Quincena = diasincidencia;
                                }
                                break;
                        }
                        Dias40Acumulados = Dias40Acumulados + Dias40Quincena;
                        GuardaDiasPago(incidencia.IdIncidenciaTrabajador, Dias100Quincena + Dias40Quincena, Dias100Quincena, Dias40Quincena, NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes, NominaTrabajador.Nomina.Año, percepciondiaria);
                    }

                    VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                    vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    vnt.Concepto = "ENFERMEDAD GENERAL";
                    vnt.Importe = Dias40Acumulados;
                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);
                    //int diaspagadosal60 = NominaTrabajador.DiasPagados - ni.DiasPagados40;
                    //decimal costodia = NominaTrabajador.CostoPorHora * NominaTrabajador.JornadaLaboral.HorasMaximo;
                    DeduccionesNominaTrabajador dt = new DeduccionesNominaTrabajador();
                    dt.EsImprimibleRecibo = true;
                    dt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    dt.IdNomina = NominaTrabajador.Nomina.IdNomina;
                    dt.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "ENFERMEDAD GENERAL").SingleOrDefault().IdPlantillaNominaDeduccion;

                    dt.Importe = Dias40Acumulados * percepciondiaria * (decimal)0.6;

                    NominaTrabajador.ListaDeduccionesTrabajadores.Add(dt);

                }


            }
        }




        private Boolean EsUnaQna(DateTime FechaIncial, DateTime FechaFinal, Nomina_stNominaTrabajador NominaTrabajador)
        {

            if (FechaIncial >= NominaTrabajador.Nomina.FechaInicio && FechaFinal <= NominaTrabajador.Nomina.FechaTermino)
                return false;
            else
                return true;

        }

        private int DiasIncidenciaQuincena(DateTime FechaIncial, DateTime FechaFinal, Nomina_stNominaTrabajador NominaTrabajador)
        {
            int diasincidencia = 0;
            if ((FechaIncial >= NominaTrabajador.Nomina.FechaInicio && FechaFinal <= NominaTrabajador.Nomina.FechaTermino)
                || (FechaIncial <= NominaTrabajador.Nomina.FechaInicio && FechaFinal >= NominaTrabajador.Nomina.FechaInicio)
                || (FechaIncial <= NominaTrabajador.Nomina.FechaInicio && FechaIncial <= NominaTrabajador.Nomina.FechaInicio))
            {
                diasincidencia = (int)(FechaFinal - FechaIncial).Days + 1;
                //aplicar = true;
                return diasincidencia;
            }

            if (FechaIncial <= NominaTrabajador.Nomina.FechaTermino && FechaFinal >= NominaTrabajador.Nomina.FechaTermino)
            {
                diasincidencia = (int)(FechaIncial - NominaTrabajador.Nomina.FechaTermino).Days + 1;
                //aplicar = true;
                return diasincidencia;
            }

            diasincidencia = (int)(NominaTrabajador.Nomina.FechaTermino - FechaIncial).Days + 1;
            //aplicar = false;
            return diasincidencia;
        }

        private void GuardaDiasPago(long IdIT, int da, int dp100, int dp40, string quincenames, short año, decimal percepciondiaria)
        {
            bdNovaEntities bd = new bdNovaEntities();
            Nomina_IncidenciaPermisoCalculo it = new Nomina_IncidenciaPermisoCalculo();
            it = bd.Nomina_IncidenciaPermisoCalculo.Where(a => a.IdIncidenciaTrabajador == IdIT).FirstOrDefault();
            if (dp100 < 0)
            {
                throw new Exception($"Existe un error al procesar al enfermedad genelar para el convenio: {IdIT}");
            }
            it.IdIncidenciaTrabajador = IdIT;
            it.DiasAcumulados = da;
            it.DiasPagados100 = dp100;
            it.DiasPagados40 = dp40;
            it.PercepcionDiaria = percepciondiaria;
            it.QuincenaMes = quincenames;
            it.Año = año;
            //bd.Nomina_IncidenciaPermisoCalculo.Add(it);
            try
            {
                bd.Entry(it).State = EntityState.Modified;
                bd.SaveChanges();
            }
            catch (Exception ex)
            {

                throw new Exception(ex.Message);
            }
            
        }

    }

}