﻿using DevExpress.Utils.Extensions;
using Nova.Models.Calculos.Percepciones;
using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Remoting.Messaging;
using System.Web;

namespace Nova.Models.Calculos.Deducciones
{
    public class DescuentosDiasEconomicosYPuntualidad : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            if (
(                NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.EndsWith("SUELDO ODES")
                 || NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CONFIANZA SUELDO")
                 || NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("BASE DEFINITIVO SUELDO")
                 || NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT")

)

&&
                    NominaTrabajador.PlantillaNominaDeducciones.Any(z => z.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO")
    && NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Any(z => z.Percepciones_ctPercepcion.Percepcion == "DÍAS ECONOMICOS NO DISFRUTADOS")
    && Libraries.ConvertToInt.ConvertToInt16(NominaTrabajador.Nomina_stNomina.Catalogos_ctQuincenaMes.QuincenaMes)<11)
            {
                int diasDerecho = 12;
                int diasAPagar = 0;

                var regresadeLicenciaLista = NominaTrabajador.LicenciasTrabajadoresDiasEconomicosPuntualidad.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToList();


                var inicio = DateTime.Parse($"{NominaTrabajador.Nomina_stNomina.Año - 1}-01-01");
                var fin = DateTime.Parse($"{NominaTrabajador.Nomina_stNomina.Año - 1}-12-31");
                int Mesultimalicencia = 0;
                foreach (var reg in regresadeLicenciaLista)
                {
                    Mesultimalicencia++;
                    var fechaini = reg.FechaInicioIncidencia;
                    if (reg.FechaInicioIncidencia.Year < NominaTrabajador.Nomina_stNomina.Año - 1)
                        fechaini = DateTime.Parse($"{NominaTrabajador.Nomina_stNomina.Año - 1}-01-01");

                    bool terminadespuesdelaño = false;
                    var fechafin = DateTime.Now;
                    if (reg.FechaTerminoIncidencia != null)
                        if (reg.FechaTerminoIncidencia.Value.Year > NominaTrabajador.Nomina_stNomina.Año - 1)
                            terminadespuesdelaño = true;

                            if (reg.FechaTerminoIncidencia <= fin && reg.FechaTerminoIncidencia.Value>fechaini
                        || terminadespuesdelaño)
                            {
                              fechafin = (DateTime)reg.FechaTerminoIncidencia.Value.AddDays(1);

                        if (reg.FechaTerminoIncidencia.Value.Year > NominaTrabajador.Nomina_stNomina.Año - 1)
                            fechafin = fin;
                        else
                        if (reg.FechaTerminoIncidencia.Value.Month == 12 && reg.FechaTerminoIncidencia.Value.Day == 31)
                                fechafin = reg.FechaTerminoIncidencia.Value;

                                diasDerecho = diasDerecho - NominaTrabajador.DiasEconomicosADescontarPorLicencias(fechafin, reg.FechaInicioIncidencia, NominaTrabajador.Nomina_stNomina.Año - 1);
                                if (Mesultimalicencia > 1 && regresadeLicenciaLista.Count<= Mesultimalicencia)
                                {
                                if (regresadeLicenciaLista[Mesultimalicencia-2].FechaTerminoIncidencia.Value.Month == reg.FechaInicioIncidencia.Month)
                                    diasDerecho = diasDerecho + 1;
                                }
                            }

                }

                var diaseconomicospagados = NominaTrabajador.Nomina_PagosDiasEconomicosyPuntualidad.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador
                && a.Año==NominaTrabajador.Nomina_stNomina.Año-1 
                && a.Catalogos_ctTipoPagoRegistro.TipoPagoRegistro== "DÍA ECONOMICO"
                ).ToList();





                //if (diasDisponibles >= 0)
                    var UltimaQnaAñoant=diaseconomicospagados.Where(z => z.IdQuincenaMes == 24).Sum(a => a.TotalDias);

                    var nuevosdias = NominaTrabajador.DiasEconomicosDifrutadosAñoAnterior.Where(a => a.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).ToList();

                var totaldias = 0;
                if (UltimaQnaAñoant > 0 && nuevosdias.Count() > 0)
                {
                    // Calcular días disponibles (12 - días ya pagados)
                    var diasDisponibles = diasDerecho - UltimaQnaAñoant;
                    var nuevosdiasqnaanterior = diaseconomicospagados.Where(x => x.IdQuincenaMes != 24).Sum(a => a.TotalDias);
                    diasDisponibles = diasDisponibles + nuevosdiasqnaanterior;
                    // Obtener días tomados en el período actual
                    var diasTomadosPeriodo = nuevosdias.Count();

                      totaldias = diasTomadosPeriodo - diasDisponibles;




                    //var totaldias = diasDerecho - diaseconomicospagados.Sum(a => a.TotalDias);
                    if (totaldias < 0)
                    //{
                    //    diasAPagar = nuevosdias.Count() - totaldias;
                    //}
                    //else
                    {
                        totaldias = Math.Abs(totaldias);  // resultado: 
                    }
                }

                diasAPagar = totaldias;

                short ipnd = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO").SingleOrDefault().IdPlantillaNominaDeduccion;
                var idpnp = NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍAS ECONOMICOS NO DISFRUTADOS").FirstOrDefault();


                    var QuincenaMes = Nova.Libraries.ConvertToInt.ConvertToInt16(NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes);


                    var trabajadorconprestacionescongasto = NominaTrabajador.TrabajadoresConPercepcionesCongasto.Where(f => f.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();

                    decimal Sueldodiario = 0;
                    decimal SueldodiarioGasto = 0;
                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                    decimal SueldoQuinquenioDiario = 0;
               

                    DeduccionesNominaTrabajador estimulo = new DeduccionesNominaTrabajador();

                    VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
 
                        Sueldodiario = NominaTrabajador.Truncate(costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMinimo * costos.CostoPorHora, 2);

                 
                    
                        Quinquenio quinqueniobase = new Quinquenio();

                        SueldoQuinquenioDiario = quinqueniobase.ImporteQuinquenioTrabajador(ConvenioLaboralTrabajadorCategoria, NominaTrabajador);
                        SueldoQuinquenioDiario = SueldoQuinquenioDiario / 15;

                    if (diasAPagar > 0)
                    {


                        var apoyoNomina = NominaTrabajador.ListaNominaApoyoEstudios.Where(z => z.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault();
                        Decimal PorcentajeApoyo = 0M;
                        if (apoyoNomina != null)
                            PorcentajeApoyo = apoyoNomina.PorcentajeApoyo;

                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral.Contains("DOCENTE"))
                        {
                            if (NominaTrabajador.SalariosDiarioDocentesParaPrima.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault() != null)
                            {
                                if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                                    Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPrima.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().Importe;
                                else
                                    Sueldodiario = NominaTrabajador.SalariosDiarioDocentesParaPrima.Where(s => s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).FirstOrDefault().ImporteSinMatQuin;
                            }
                            SueldoQuinquenioDiario = 0;
                        }

                        if (PorcentajeApoyo > 0)
                        {
                            Sueldodiario = (PorcentajeApoyo * Sueldodiario) / 100;
                            SueldoQuinquenioDiario = (PorcentajeApoyo * SueldoQuinquenioDiario) / 100;
                        }

                        decimal importetotal = ((Sueldodiario + SueldoQuinquenioDiario) * diasAPagar);



                        if (PorcentajeApoyo > 0)
                            importetotal = (PorcentajeApoyo * importetotal) / 100;

                    decimal importetotalgto = 0;


                    if (trabajadorconprestacionescongasto != null)
                    {

                        var GASTO = NominaTrabajador.PercepcionPersonalizada.Where(c => c.Percepciones_ctPercepcion.Percepcion == "GASTO ADMINISTRATIVO").FirstOrDefault();

                        if (PorcentajeApoyo > 0)
                            GASTO.Importe = (PorcentajeApoyo * GASTO.Importe) / 100;

                        SueldodiarioGasto = (GASTO.Importe / 15);
                          importetotalgto = ((SueldodiarioGasto) * diasAPagar);
                    }

                    bool debegrabar = false;

                    if (importetotalgto > 0 && NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
                    {
                        var idgto= NominaTrabajador.PlantillaNominaPercepcionesRelacionLaboral.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DÍAS ECONOMICOS NO DISFRUTADOS GASTO ADMINISTRATIVO").FirstOrDefault();
                        if (idgto != null)
                        {
                            DeduccionesNominaTrabajador diaeconomico = new DeduccionesNominaTrabajador();
                            diaeconomico.EsImprimibleRecibo = true;
                            diaeconomico.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                            diaeconomico.IdNomina = NominaTrabajador.Nomina.IdNomina;
                            diaeconomico.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO").FirstOrDefault().IdPlantillaNominaDeduccion;
                            diaeconomico.Concepto = idgto.Percepciones_ctPercepcion.Percepcion;
                            diaeconomico.Importe = importetotalgto;
                            NominaTrabajador.ListaDeduccionesTrabajadores.Add(diaeconomico);
                            debegrabar = true;
                        }
                    }

                    if (importetotal > 0 && !NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("CCT"))
                        {

                       

                   DeduccionesNominaTrabajador diaeconomico = new DeduccionesNominaTrabajador();
                        diaeconomico.EsImprimibleRecibo = true;
                        diaeconomico.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                        diaeconomico.IdNomina = NominaTrabajador.Nomina.IdNomina;
                        diaeconomico.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "DESCUENTO POR PAGO INDEBIDO").FirstOrDefault().IdPlantillaNominaDeduccion;
                        diaeconomico.Concepto= idpnp.Percepciones_ctPercepcion.Percepcion;
                        diaeconomico.Importe = importetotal;
                        NominaTrabajador.ListaDeduccionesTrabajadores.Add(diaeconomico);
                        debegrabar = true;
                    }

                    if (importetotal>0 || importetotalgto>0)
                    {
                        Nomina_PagosDiasEconomicosyPuntualidad diasbd = new Nomina_PagosDiasEconomicosyPuntualidad();
                        diasbd.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                        diasbd.IdQuincenaMes = NominaTrabajador.Nomina_stNomina.IdQuincenaMes;
                        diasbd.IdTipoPagoRegistro = 1;
                        diasbd.TotalDias = diasAPagar;
                        diasbd.IdNomina = NominaTrabajador.Nomina_stNomina.IdNomina;

                        diasbd.Año = NominaTrabajador.Nomina_stNomina.Año - 1;

                        NominaTrabajador.Lista_PagosDiasEconomicosyPuntualidad.Add(diasbd);
                    }
                }

                }
 
        }

    }
}