﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.Calculos.Deducciones
{
    public class CuotaSindicalDocente : IDeduccionBehavior
    {
                public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                if (NominaTrabajador.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "CUOTA SINDICAL").SingleOrDefault() != null)
            {

                    if (ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.EsCuotaSindical == true)
                    {
                    //short ipnd = NominaTrabajador.PlantillaNominaDeducciones.Where(x=>x.Deducciones_ctDeduccion.Deduccion=="CUOTA SINDICAL").SingleOrDefault().IdPlantillaNominaDeduccion;
                    // short idpnp= NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO DE JORNADA").FirstOrDefault().IdPlantillaNominaPercepcion;

                    //Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                    //decimal impotecuotafija = ((costos.CostoPorHora * NominaTrabajador.HorasSemanaMes * 2) + (costos.CostoPorHoraExcedente * NominaTrabajador.HorasTrabajadasExcedentes * 2)) * (decimal)0.01;
                    decimal impotecuotafija = 0;
                    PercepcionesNominaTrabajador Sueldo, SueldoExcedente ;
                    Decimal importe = 0;
                        if (!NominaTrabajador.Nomina_stNomina.NoCalcularISR)
                        {

                            if (ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.EsHomologado)
                            {
                                SueldoExcedente = NominaTrabajador.ListaPercepcionesTrabajadores.Where(lp => (lp.EsAjusteHorasExcedentes == false || lp.EsAjusteHorasInterinas == false) && lp.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && lp.IdPlantillaNominaPercepcion == NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO HORAS EXCEDENTE").FirstOrDefault().IdPlantillaNominaPercepcion).FirstOrDefault();

                                Sueldo = NominaTrabajador.ListaPercepcionesTrabajadores.Where(lp => lp.EsAjusteHorasExcedentes == false && lp.EsAjusteHorasInterinas == false && lp.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && lp.IdPlantillaNominaPercepcion == NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO JORNADA").FirstOrDefault().IdPlantillaNominaPercepcion).FirstOrDefault();
                                if (Sueldo!=null)
                                importe = Sueldo.Importe;
                                if (SueldoExcedente != null)
                                    importe = importe + SueldoExcedente.Importe;
                            }
                            else
                            {

                                Sueldo = NominaTrabajador.ListaPercepcionesTrabajadores.Where(lp => lp.EsAjusteHorasExcedentes == false && lp.EsAjusteHorasInterinas == false && lp.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && lp.IdPlantillaNominaPercepcion == NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO DOCENTE").FirstOrDefault().IdPlantillaNominaPercepcion).FirstOrDefault();
                                importe = Sueldo.Importe;
                            }
                        }
                        else {
                            Sueldo = NominaTrabajador.ListaPercepcionesTrabajadores.Where(lp => lp.EsAjusteHorasExcedentes == false && lp.EsAjusteHorasInterinas == false && lp.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && lp.IdPlantillaNominaPercepcion == NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion.Contains ("SUELDO")).FirstOrDefault().IdPlantillaNominaPercepcion).FirstOrDefault();
                            var Sueldoajuste = NominaTrabajador.ListaPercepcionesTrabajadores.Where(lp => lp.EsAjusteHorasExcedentes == false && lp.EsAjusteHorasInterinas == false && lp.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && lp.Concepto.Contains("SUELDO")).FirstOrDefault();
                            if (Sueldo != null)
                                importe = Sueldo.Importe;
                                    if (Sueldoajuste!=null)
                                    importe = Sueldoajuste.Importe;

                        }
                    impotecuotafija = Math.Round(importe * (decimal)0.01,2);

                    DeduccionesNominaTrabajador deduccioncuotafija = new DeduccionesNominaTrabajador();
                    deduccioncuotafija.EsImprimibleRecibo = true;
                    deduccioncuotafija.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    deduccioncuotafija.IdNomina = NominaTrabajador.Nomina.IdNomina;
                    deduccioncuotafija.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "CUOTA SINDICAL").SingleOrDefault().IdPlantillaNominaDeduccion;
                    deduccioncuotafija.Importe = impotecuotafija;
                        if (impotecuotafija>0)
                    NominaTrabajador.ListaDeduccionesTrabajadores.Add(deduccioncuotafija);

                        if (ConvenioLaboralTrabajadorCategoria.EsPrimerCalculo == true && ConvenioLaboralTrabajadorCategoria.EsPlazaBase==true)
                        {
                            //devoluciones
                            int mesescon31dias = 0;
                            double diasremanentes = 0;
                            var diasfeb = 0;
                            if (ConvenioLaboralTrabajadorCategoria.FechaTermino <= NominaTrabajador.Nomina_stNomina.FechaInicio)
                            {
                                //var resta = (TimeSpan)(item.FechaTermino - (DateTime)item.FechaInicio);
                                // diasremanentes = (resta.TotalDays) - (double)diaslaborados;
                                var diast = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "diasTotalesContrato").FirstOrDefault();
                                if (diast != null)
                                {
                                    var diasTotalesContrato = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "diasTotalesContrato").FirstOrDefault().Importe;
                                    diasremanentes = (double)diasTotalesContrato;
                                    mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(ConvenioLaboralTrabajadorCategoria.FechaInicio, (DateTime)ConvenioLaboralTrabajadorCategoria.FechaTermino);
                                    diasfeb = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(ConvenioLaboralTrabajadorCategoria.FechaInicio, (DateTime)ConvenioLaboralTrabajadorCategoria.FechaTermino);
                                }
                                else
                                {

                                    diasremanentes = ((NominaTrabajador.Nomina_stNomina.FechaInicio - (DateTime)ConvenioLaboralTrabajadorCategoria.FechaInicio).TotalDays);
                                    mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(ConvenioLaboralTrabajadorCategoria.FechaInicio, (DateTime)NominaTrabajador.Nomina_stNomina.FechaInicio);
                                    diasfeb = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(ConvenioLaboralTrabajadorCategoria.FechaInicio, (DateTime)NominaTrabajador.Nomina_stNomina.FechaInicio);
                                }
                            }
                            else
                                if (ConvenioLaboralTrabajadorCategoria.FechaInicioPago != null)
                            {
                                diasremanentes = (((DateTime)ConvenioLaboralTrabajadorCategoria.FechaInicioPago - (DateTime)ConvenioLaboralTrabajadorCategoria.FechaInicio).TotalDays);
                                mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(ConvenioLaboralTrabajadorCategoria.FechaInicio, (DateTime)ConvenioLaboralTrabajadorCategoria.FechaInicioPago);
                                diasfeb = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(ConvenioLaboralTrabajadorCategoria.FechaInicio, (DateTime)ConvenioLaboralTrabajadorCategoria.FechaInicioPago);
                            }
                            else
                            {
                                diasremanentes = ((NominaTrabajador.Nomina_stNomina.FechaInicio - (DateTime)ConvenioLaboralTrabajadorCategoria.FechaInicio).TotalDays);
                                mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(ConvenioLaboralTrabajadorCategoria.FechaInicio, (DateTime)NominaTrabajador.Nomina_stNomina.FechaInicio);
                                diasfeb = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(ConvenioLaboralTrabajadorCategoria.FechaInicio, (DateTime)NominaTrabajador.Nomina_stNomina.FechaInicio);
                            }

                            //se quitan los dias de los meses con 31 en dado caso de que hay mas de 30 dias de dif
                            //if (diasremanentes > 30)
                                diasremanentes = (diasremanentes - mesescon31dias)+diasfeb;
                            //else
                            //    diasremanentes = diasremanentes + diasfeb;



                            decimal importeAjuste = 0M;
                            if (diasremanentes > 0)
                            {
                                importeAjuste = ((decimal)diasremanentes * ( impotecuotafija/15));

                                if (importeAjuste > 0)
                                {
                                    DeduccionesNominaTrabajador ajustecuota = new DeduccionesNominaTrabajador();
                                    ajustecuota.EsImprimibleRecibo = true;
                                    
                                    ajustecuota.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    ajustecuota.IdNomina = NominaTrabajador.Nomina.IdNomina;
                                    ajustecuota.Concepto = "AJUSTE";
                                    ajustecuota.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "CUOTA SINDICAL").SingleOrDefault().IdPlantillaNominaDeduccion;
                                    ajustecuota.Importe = importeAjuste;
                                    NominaTrabajador.ListaDeduccionesTrabajadores.Add(ajustecuota);
                                }
                             }
                                }
                }
            }
        }

    }
}