﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.Calculos.Deducciones
{
    public class CuotaSindical : IDeduccionBehavior
    {
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            if (NominaTrabajador.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "CUOTA SINDICAL").SingleOrDefault() != null)
            { 
            if (ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.EsCuotaSindical==true)
            {
                short ipnd = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "CUOTA SINDICAL").SingleOrDefault().IdPlantillaNominaDeduccion;
                short idpnp = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().IdPlantillaNominaPercepcion;
                    

                    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                    if (costos == null) throw new ApplicationException("No existe costo-hora-jornada para la categoría: " + ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.ToString());

                    //                decimal impotecuotafija = NominaTrabajador.CostoPorHora * NominaTrabajador.DiasPagados * (decimal)0.01;
                    //decimal impotecuotafija = (((costos.CostoPorHora * NominaTrabajador.DiasNomina * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo) * NominaTrabajador.DiasPagados) / NominaTrabajador.DiasNomina)*0.01M;
                    //decimal impotecuotafija = ((((costos.CostoPorHora *  costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo)*NominaTrabajador.DiasNomina) * NominaTrabajador.DiasPagados) / NominaTrabajador.DiasNomina) * 0.01M;
                    var sueldoQna= NominaTrabajador.ListaPercepcionesTrabajadores.Where(s=> s.IdConvenioLaboralTrabajadorCategoria==ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.IdPlantillaNominaPercepcion== idpnp).FirstOrDefault();
                    decimal impotecuotafija = Math.Round(sueldoQna.Importe * 0.01M,2);

                    DeduccionesNominaTrabajador deduccioncuotafija = new DeduccionesNominaTrabajador();
                deduccioncuotafija.EsImprimibleRecibo = true;
                deduccioncuotafija.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                deduccioncuotafija.IdNomina = NominaTrabajador.Nomina.IdNomina;
                deduccioncuotafija.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(z => z.Deducciones_ctDeduccion.Deduccion == "CUOTA SINDICAL").SingleOrDefault().IdPlantillaNominaDeduccion;
                deduccioncuotafija.Importe = impotecuotafija;
                NominaTrabajador.ListaDeduccionesTrabajadores.Add(deduccioncuotafija);
            }
        }
        }

    }
}