﻿using Nova.Models.Nomina;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Models;
using Nova.Models.Calculos;
using Dapper;
 


namespace Nova.Models.Calculos.Deducciones
{

    public class Credito : IDeduccionBehavior
    {
     
        public void Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        {
            if (!NominaTrabajador.TrabajadorConIncapacipdadActiva)
                if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.AplicaCalculoCreditos)
                {
                    decimal VecesSalarioMinimo = 0, CuotaFija = 0, Porcentaje = 0, Infonavit, sueldoRemanente = 0;

                    // sueldoRemanente = NominaTrabajador.ListaVariablesNominaTrabajador.Where(c => c.Concepto == "SUELDO REMANENTE PENSION" && c.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().Importe;

                    int DiasQuincenaIMSS = 0;
                    int TotalDiasQuincenaIMSS = 0;

                    string qna = NominaTrabajador.Nomina.Catalogos_ctQuincenaMes.QuincenaMes;

                    var Remanente = NominaTrabajador.ListaVariablesNominaTrabajador.Where(c => c.Concepto == "SUELDO REMANENTE PENSION" && c.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                    var diaslaborados = NominaTrabajador.ListaVariablesNominaTrabajador.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.Concepto == "DIASLABORADOS").FirstOrDefault().Importe;

                    ////////
                    ///
                    if (Remanente == null)
                    {
                        var iddeduccionisr = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "ISR").FirstOrDefault().IdPlantillaNominaDeduccion;

                        // var iddeduccionsubsidio = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().IdPlantillaNominaDeduccion;


                        var iddeduccionsubsidio = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUBSIDIO PARA EL EMPLEO ENTREGADO").FirstOrDefault().IdPlantillaNominaPercepcion;

                        DeduccionesNominaTrabajador ISR = NominaTrabajador.ListaDeduccionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && z.IdPlantillaNominaDeduccion == iddeduccionisr).FirstOrDefault();


                        var iddeincapacidades = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "RIESGO DE TRABAJO" || x.Deducciones_ctDeduccion.Deduccion == "MATERNIDAD" || x.Deducciones_ctDeduccion.Deduccion == "ENFERMEDAD GENERAL").Select(a=> a.IdPlantillaNominaDeduccion).ToArray();

                        var incapaciadades  = NominaTrabajador.ListaDeduccionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria 
                        && iddeincapacidades.Contains(z.IdPlantillaNominaDeduccion)).ToList();

                        decimal ImporteIncapacidades = incapaciadades.Sum(a => a.Importe);

                        if (ISR == null)
                        //    ISR = NominaTrabajador.ListaDeduccionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && z.IdPlantillaNominaDeduccion == iddeduccionsubsidio).FirstOrDefault();
                        {
                            var subsidio = NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && z.IdPlantillaNominaPercepcion == iddeduccionsubsidio).FirstOrDefault();
                            DeduccionesNominaTrabajador isrtempo = new DeduccionesNominaTrabajador();
                            if (subsidio != null)
                            {
                                isrtempo.Importe = subsidio.Importe;
                                ISR = isrtempo;
                            }
                        }

                        DeduccionesNominaTrabajador IMSS = null;
                        if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault() != null)
                            IMSS = NominaTrabajador.ListaDeduccionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && z.IdPlantillaNominaDeduccion == NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "IMSS").FirstOrDefault().IdPlantillaNominaDeduccion).FirstOrDefault();

                        decimal remanente = 0;

                        if (ISR != null)
                        {
                            if (IMSS != null)
                                remanente = NominaTrabajador.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList())- ISR.Importe - IMSS.Importe;
                            else
                                remanente = NominaTrabajador.Suma(NominaTrabajador.ListaPercepcionesTrabajadores.Where(z => z.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).ToList())- ISR.Importe;
                        }

                        sueldoRemanente = remanente- ImporteIncapacidades;
                    }
                    else
                    {
                        sueldoRemanente = Remanente.Importe;
                    }

                    decimal sueldoRemanenteTemporal = 0M;

                    List<int> creditosyadesconatdos = new List<int>();

                    if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AGUINALDO ESTATAL"))
                    {
                        creditosyadesconatdos = NominaTrabajador.ListaCreditosDescontadosOtrasNominas.Where(a =>
                        a.Creditos_stCreditoTrabajador.EsAjustetSaldoInsuficiente==false && a.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Select(a => a.IdCreditoTrabajador).ToList();
                    }
                    else
                    {
                        if(!NominaTrabajador.EsRecalculoPorTrabajador)
                        creditosyadesconatdos = NominaTrabajador.ListaCreditosDescontadosOtrasNominas.Where(a => a.Nomina_stNominaTrabajador.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).Select(a => a.IdCreditoTrabajador).ToList();
                    }

                         

                     //5779
                    //6279
                    var miscreditoslista = NominaTrabajador.CreditosTrabajador.Where(s => !creditosyadesconatdos.Contains(s.IdCreditoTrabajador)
                    && s.IdTrabajador == ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador).OrderBy(a => a.Catalogos_ctTipoCredito.Orden).ToList();

                    var plazatrabajador = NominaTrabajador.Plazas_ctCategoria.Where(s => s.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.IdCategoria).FirstOrDefault();
                    
                    Decimal totalDIASIncidencias = 0;

                    foreach (var item in miscreditoslista)
                    {
                        VecesSalarioMinimo = 0;

                        Boolean NoAlcanzaPagoInfonavit = false;

                        Decimal INfonavitSaldoNoPagado = 0;

                        var creditosyadesconatdosMismaNomina = NominaTrabajador.ListaCreditosTrabajador.Where(a => a.IdCreditoTrabajador == item.IdCreditoTrabajador).FirstOrDefault();

                        bool calcularcredito = true;
                        
                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AGUINALDO ESTATAL"))
                        {
                            calcularcredito = false;
                        }

                        if (item.SoloDescuentoEnAguinaldo == true )
                        {
                            if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AGUINALDO ESTATAL"))
                            {
                                calcularcredito = true;
                            }
                            else
                                calcularcredito = false;
                        }


                        if (creditosyadesconatdosMismaNomina == null && calcularcredito)
                        {
                            decimal totalcreditos = 0;
                            CreditosTrabajador micredito = new CreditosTrabajador();
                            micredito.IdCreditoTrabajador = item.IdCreditoTrabajador;

                            if (item.Saldo!=null)
                                micredito.Saldo = (decimal)item.Saldo;

                            if (item.EsAjustetSaldoInsuficiente!=null)
                            micredito.EsAjustetSaldoInsuficiente = (bool)item.EsAjustetSaldoInsuficiente;

                            micredito.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;

                            if (item.EsAjustetSaldoInsuficiente != null)
                                if ((bool)item.EsAjustetSaldoInsuficiente == true)
                                { micredito.EsAjuste = true; }

                            if (item.Catalogos_ctTipoCredito.TipoCredito == "CRÉDITO FONACOT")
                            {
                                decimal descuentoqnal = 0;
                                bool accesoFonacot = false;

                                if (item.Creditos_ctCreditoTipoDescuento.CreditoTipoDescuento == "MENSUAL")
                                {
                                    if (item.ImporteCredito == 0)
                                    {
                                        decimal division = Math.Round((decimal)(item.CuotaFija / 2),3);


                                        if (Convert.ToInt16(qna) % 2 == 0)
                                        { // segunda quincena hacia arriba
                                            descuentoqnal = Math.Round(division, 2,MidpointRounding.AwayFromZero);
                                        }
                                        else
                                        {
                                            descuentoqnal = Math.Round(division,2, MidpointRounding.ToEven);
                                            descuentoqnal = (decimal)item.CuotaFija - (descuentoqnal) ;
                                        }
                                        

                                        totalcreditos = descuentoqnal; 

                                        micredito.Importe = totalcreditos;

                                    }
                                    else
                                        if (item.Saldo == null && item.Saldo != 0)
                                    {

                                        //descuentoqnal = Math.Round((decimal)(item.CuotaFija / 2), 3);
                                        //if (Convert.ToInt16(qna) % 2 != 0)
                                        //{
                                        //    descuentoqnal = Math.Round((decimal)item.CuotaFija - (descuentoqnal), 2);
                                        //}

                                        decimal division = Math.Round((decimal)(item.CuotaFija / 2), 3);


                                        if (Convert.ToInt16(qna) % 2 == 0)
                                        { // segunda quincena hacia arriba
                                            descuentoqnal = Math.Round(division, 2, MidpointRounding.AwayFromZero);
                                        }
                                        else
                                        {
                                            descuentoqnal = Math.Round(division, 2, MidpointRounding.ToEven);
                                            descuentoqnal = (decimal)item.CuotaFija - (descuentoqnal);
                                        }

                                        if (item.Saldo < descuentoqnal)
                                        {
                                            descuentoqnal = (decimal)item.Saldo;
                                        }
                                        else
                                        if (item.Saldo != null)
                                        {
                                            micredito.Saldo = (decimal)item.Saldo - descuentoqnal;
                                        }

                                        totalcreditos = descuentoqnal;
                                        micredito.Importe = totalcreditos;
                                    }
                                }
                                else
                                {
                                    //quincenal
                                    if (item.ImporteCredito == 0)
                                    {
                                        descuentoqnal = (decimal)item.CuotaFija;


                                        totalcreditos = descuentoqnal;
                                        micredito.Importe = totalcreditos;
                                    }
                                    else
                                           if (item.Saldo != 0)
                                    {

                                        descuentoqnal = (decimal)item.CuotaFija;
                                        if (item.Saldo < descuentoqnal)
                                        {
                                            descuentoqnal = (decimal)item.Saldo;
                                        }
                                        else
                                        if (item.Saldo != null)
                                        {
                                            micredito.Saldo = (decimal)item.Saldo - descuentoqnal;
                                        }

                                        totalcreditos = descuentoqnal;
                                        micredito.Importe = totalcreditos;
                                    }
                                }
                            }
                            else
                                if (item.Catalogos_ctTipoCredito.TipoCredito == "INFONAVIT")
                            {
                                //DIAS IMSS


                                bool EsBisiesto = DateTime.IsLeapYear(NominaTrabajador.Nomina_stNomina.Año);
                              
                                int DiasMes = 0;
                                DiasMes = DateTime.DaysInMonth(NominaTrabajador.Nomina_stNomina.Año, NominaTrabajador.Nomina_stNomina.FechaInicio.Month);




                                switch (DiasMes)
                                {
                                    case 28:
                                        if (NominaTrabajador.Nomina_stNomina.FechaInicio.Day == 1)
                                            DiasQuincenaIMSS = 15;
                                        else
                                            DiasQuincenaIMSS = 13;
                                        break;
                                    case 29:

                                        if (NominaTrabajador.Nomina_stNomina.FechaInicio.Day == 1)
                                            DiasQuincenaIMSS = 15;
                                        else
                                            DiasQuincenaIMSS = 14;
                                        break;
                                    case 30:
                                        DiasQuincenaIMSS = 15;
                                        break;
                                    case 31:
                                        if (NominaTrabajador.Nomina_stNomina.FechaInicio.Day == 1)
                                            DiasQuincenaIMSS = 15;
                                        else
                                            DiasQuincenaIMSS = 16;

                                        break;

                                    default:
                                        break;
                                }
                               
                              
                                totalDIASIncidencias = NominaTrabajador.ListaVariablesNominaTrabajador.Where(v => v.Concepto == "INCIDENCIA_DIAS_IMSS" && v.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria
            ).Sum(a => a.Importe);

                                if (totalDIASIncidencias>0)
                                if (totalDIASIncidencias < DiasQuincenaIMSS)
                                {
                                    TotalDiasQuincenaIMSS = (int)DiasQuincenaIMSS - (int)totalDIASIncidencias;
                                }


                                /////
                                if (micredito.EsAjuste && item.Saldo>0)
                                {
                                    var importecuotaf = (decimal)item.CuotaFija;

                                    if (importecuotaf > item.Saldo)
                                    { totalcreditos = (decimal)item.Saldo;
                                        micredito.Saldo = 0;
                                        micredito.Terminar = true;
                                        micredito.FechaTermino = NominaTrabajador.Nomina.FechaTermino;

                                    }
                                    else
                                    { 
                                        if (NominaTrabajador.Nomina_stNomina.Nomina_ctPlantillaNomina.Plantilla.Contains("AGUINALDO ESTATAL")
                                            && item.EsAjustetSaldoInsuficiente==true)
                                        {
                                            totalcreditos = (decimal)item.Saldo;
                                            micredito.Saldo = 0;
                                            micredito.Terminar = true;
                                            micredito.FechaTermino = NominaTrabajador.Nomina.FechaTermino;
                                        }
                                        else
                                        {
                                            totalcreditos = importecuotaf;
                                            micredito.Saldo = micredito.Saldo - importecuotaf;
                                        }
                                    }

                                    
                                    }
                                else
                                {


                                    //if (NominaTrabajador.CreditosTrabajador.Where(c => c.Catalogos_ctTipoCredito.TipoCredito == "CRÉDITO INFONAVIT").SingleOrDefault().VecesSalarioMinimo != null)
                                    if (item.VecesSalarioMinimo != null)
                                    {
                                        VecesSalarioMinimo = Convert.ToDecimal(item.VecesSalarioMinimo.Value);
                                        //VecesSalarioMinimo = VecesSalarioMinimo + (VecesSalarioMinimo*2);
                                    }
                                    else if (item.CuotaFija != null)
                                        CuotaFija = Convert.ToDecimal(item.CuotaFija.Value);
                                    else if (item.Porcentaje != null)
                                        Porcentaje = Convert.ToDecimal(item.Porcentaje.Value);
                                    else
                                        throw new Exception("Error con el cálculo del crédito infonavit del trabajador: " + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno);

                                    if (VecesSalarioMinimo != 0)
                                    {
                                        if (item.Creditos_ctCreditoTipoDescuento.CreditoTipoDescuento == "MENSUAL")
                                        {
                                            totalcreditos = (((NominaTrabajador.ctUMI.Monto * VecesSalarioMinimo) / 2) + 3.75M);

                                        }
                                        else
                                        {
                                            totalcreditos = (((NominaTrabajador.ctUMI.Monto * VecesSalarioMinimo)) + 3.75M);

                                        }
                                    }

                                    else
                                    if (CuotaFija != 0)
                                    {


                                        if (item.Creditos_ctCreditoTipoDescuento.CreditoTipoDescuento == "MENSUAL")
                                        {
                                            totalcreditos = (CuotaFija / 2);

                                            if (Convert.ToInt16(qna) % 2 == 0)
                                            {
                                                totalcreditos = (decimal)item.CuotaFija - (totalcreditos);
                                            }
                                            totalcreditos =Math.Round(totalcreditos + 3.75M,2);
                                        }
                                        else
                                            totalcreditos = Math.Round(CuotaFija + 3.75M,2);
                                    }

                                    else
                                    {
                                        totalcreditos = NominaTrabajador.ListaVariablesNominaTrabajador.Where(c =>
                                          c.Concepto == "SALARIO DIARIO INTEGRADO"
                                          && c.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria)
                                          .SingleOrDefault().Importe * (Porcentaje / 100);

                                        if (item.Creditos_ctCreditoTipoDescuento.CreditoTipoDescuento == "QUINCENAL")
                                        {
                                            totalcreditos = (((totalcreditos) / 2));

                                        }

                                    }

                                }

                            } //infonavit
                            else
                            {
                                if ((item.Saldo != 0 && item.ImporteCredito > 0) || item.Catalogos_ctTipoCredito.Deducciones_ctDeduccion.Deduccion == "SEGURO DE VIDA"
                                    || item.Catalogos_ctTipoCredito.Deducciones_ctDeduccion.Deduccion == "CRÉDITO" || (item.Parcialidades>0 && (item.ParcialidadesPagadas<item.Parcialidades)))
                                {
                                    var tienedatosVSM = false;
                                    var tienedatosCF = false;
                                    var tienedatosPorcentaje = false;
                                    if (item.VecesSalarioMinimo != null)
                                        tienedatosVSM = true;
                                    if (item.CuotaFija != null)
                                        tienedatosCF = true;

                                    if (item.Porcentaje != null)
                                        tienedatosPorcentaje = true;

                                    if (tienedatosVSM && item.VecesSalarioMinimo > 0)
                                    {
                                        totalcreditos = totalcreditos + (decimal)(item.VecesSalarioMinimo * NominaTrabajador.SalarioMinimoDF.Monto);

                                    }
                                    else
                                    if (tienedatosCF && item.CuotaFija > 0)
                                    {
                                        totalcreditos = totalcreditos + (decimal)item.CuotaFija;
                                    }
                                    else
                                        if (tienedatosPorcentaje && item.Porcentaje > 0)
                                    {
                                        totalcreditos = totalcreditos + (decimal)item.Porcentaje * NominaTrabajador.SueldoBruto;
                                    }

                                    if (item.Creditos_ctCreditoTipoDescuento.CreditoTipoDescuento == "MENSUAL")
                                    {
                                        totalcreditos = (((totalcreditos) / 2));

                                    }

                                    bool consaldo = false;
                                    if (item.Saldo != null)
                                        if (item.Saldo > 0)
                                            consaldo = true;

                                    if (consaldo)
                                        if (totalcreditos > item.Saldo)
                                        {
                                            totalcreditos = (decimal)item.Saldo;
                                            micredito.Saldo = 0;
                                            micredito.Terminar = true;
                                            micredito.FechaTermino = NominaTrabajador.Nomina.FechaTermino;
                                        }
                                        else
                                            micredito.Saldo = (decimal)item.Saldo - totalcreditos;

                                    if (item.Parcialidades > 0)
                                        if (item.ParcialidadesPagadas < item.Parcialidades)
                                            micredito.ParcialidadesPagadas = (short)(item.ParcialidadesPagadas + 1);

                                }
                            }

                            micredito.Importe = 0;
                            if (NominaTrabajador.DiasPagados > 0 )
                            {
                                bool consaldo = false;
                                if (item.Saldo != null)
                                    if (item.Saldo > 0)
                                        consaldo = true;

                                if (consaldo)
                                    if (totalcreditos > item.Saldo)
                                    {
                                        totalcreditos = (decimal)item.Saldo;
                                        micredito.Saldo = 0;
                                        micredito.Terminar = true;
                                        micredito.FechaTermino = NominaTrabajador.Nomina.FechaTermino;
                                    }
                                    else
                                        micredito.Saldo = (decimal)item.Saldo - totalcreditos;

                                bool ajusteterminado = false;
                                if (item.EsAjustetSaldoInsuficiente==true)
                                    if (consaldo==false)
                                        ajusteterminado = true;

                                if ((sueldoRemanente - totalcreditos) > 0 && !ajusteterminado)
                                {
                                    if (item.Catalogos_ctTipoCredito.TipoCredito == "INFONAVIT")
                                    {
                                        if (TotalDiasQuincenaIMSS > 0)
                                        {
                                            var diasmbanterior = NominaTrabajador.DiasBimestre();
                                            var tempocredi = (((totalcreditos * 4) / diasmbanterior) * TotalDiasQuincenaIMSS);
                                            micredito.Importe = tempocredi;
                                            totalcreditos = tempocredi;
                                            sueldoRemanente = sueldoRemanente - totalcreditos;
                                        }
                                        else
                                        {
                                            if (totalDIASIncidencias < diaslaborados)
                                            {
                                                micredito.Importe = totalcreditos;
                                                sueldoRemanente = sueldoRemanente - totalcreditos;
                                            }
                                            else
                                            {
                                                INfonavitSaldoNoPagado = totalcreditos;
                                                micredito.Importe = 0;
                                                NoAlcanzaPagoInfonavit = true;
                                            }
                                        }
                                    }
                                    else
                                    {
                                        micredito.Importe = totalcreditos;

                                        sueldoRemanente = sueldoRemanente - totalcreditos;
                                    }
                                   
                                }
                                else
                                {
                                    if (item.Catalogos_ctTipoCredito.TipoCredito == "INFONAVIT"  )
                                    {
                                        if (!ajusteterminado)
                                        {
                                            INfonavitSaldoNoPagado = totalcreditos;
                                            micredito.Importe = 0;
                                            NoAlcanzaPagoInfonavit = true;
                                        }
                                        else
                                        {
                                            totalcreditos = 0;
                                            micredito.Importe = 0;
                                        }
                                    
                                    }
                                }



                            }



                            //AJUSTE DE FACTOR
                            decimal ajustefactor = 0;
                            if (item.IdCreditoTrabajadorFactor != null && item.AjusteFactorAplicado == false)
                            {
                                Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
                                string query = @"SELECT a.Importe,d.FechaInicio,d.FechaTermino,v.CuotaFija,v.VecesSalarioMinimo,v.Porcentaje
  FROM  Creditos_stNominaCreditoTrabajador a inner join Nomina_stNominaTrabajador b
  on b.IdNominaTrabajador=a.IdNominaTrabajador
  inner join nomina_stnomina d on d.IdNomina=b.IdNomina
inner join Nomina_stNominaTrabajadorEstatus q on q.IdNominaTrabajadorEstatus=b.IdNominaTrabajadorEstatus
inner join Creditos_stCreditoTrabajador v on v.IdCreditoTrabajador=a.IdCreditoTrabajador
  where a.IdCreditoTrabajador=" + item.IdCreditoTrabajadorFactor + " and year(d.FechaInicio) =" + item.FechaInicioCredito.Year + " and month(d.FechaInicio)>=" + item.FechaInicioCredito.Month + " and EsAjuste=0 and EstatusNomina <> 'CANCELADO' order by d.FechaInicio asc";
                                var NominaCreditoTrabajadorPagados = (List<CreditosAjustesFactor>)dp.connection.Query<CreditosAjustesFactor>(query);
                                dp.Close();



                                bool afavor=false;

                                int contador = 0;
                                foreach (var dato in NominaCreditoTrabajadorPagados)
                                {
                                    contador++;
                                    if (contador ==1)
                                    {
                                        int diasajusteF = 15;
                                        //int año = dato.FechaInicio.Year;
                                        //int mes = dato.FechaInicio.Month;
                                        int mesescon31dias = 0;
                                        int diasrestantes = 0;
                                        int diasfeb = 0;

                                        decimal diasajustefactor = (decimal)( NominaTrabajador.Nomina_stNomina.FechaInicio- dato.FechaInicio).TotalDays;
                                        if (plazatrabajador.CalcularNominaDiasCalendario == false)
                                        {
                                            mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(dato.FechaInicio, NominaTrabajador.Nomina_stNomina.FechaInicio);
                                            diasfeb = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(dato.FechaInicio, NominaTrabajador.Nomina_stNomina.FechaInicio);
                                        }

                                        diasajustefactor = (diasajustefactor - mesescon31dias) + diasfeb;

                                        if (diasajustefactor > 15)
                                            diasajustefactor = diasajustefactor - 15;

                                        //if (item.FechaInicioDescuento.Day > 15)
                                        //{
                                        //    diasajusteF = DateTime.DaysInMonth(año, mes);
                                        //    diasajusteF = diasajuste - dato.FechaInicio.Day;
                                        //}
                                        //else
                                        //{ diasajuste = diasajuste - dato.FechaInicio.Day; }

                                        // ajustefactor = ajustefactor + (totalcreditos - ((dato.Importe / 15) * diasajuste));
                                    

                                        if (item.FechaInicioCredito == dato.FechaInicio)
                                        //dias completos
                                        {

                                            if (dato.Importe > totalcreditos)
                                                afavor = true;
                                            else
                                                afavor = false;

                                            if (CuotaFija > 0)
                                            {
                                                if (dato.CuotaFija == null && dato.VecesSalarioMinimo > 0)
                                                {
                                                    if (dato.Importe > totalcreditos)
                                                    {
                                                        afavor = true;
                                                        ajustefactor = ajustefactor + (totalcreditos - dato.Importe);
                                                        var tempoajuste = (ajustefactor / 15) * (diasajustefactor);
                                                        ajustefactor = ajustefactor + tempoajuste;
                                                    }
                                                    else
                                                    { //ajustefactor =ajustefactor + (dato.Importe - totalcreditos);
                                                        afavor = false;
                                                        ajustefactor = ajustefactor + (dato.Importe - totalcreditos);
                                                        var tempoajuste = (ajustefactor / 15) * (diasajustefactor);
                                                        ajustefactor = ajustefactor + tempoajuste;
                                                    }

                                                }
                                                else
                                                if (dato.CuotaFija > item.CuotaFija)
                                                {


                                                    ajustefactor = ajustefactor + (dato.Importe - totalcreditos);
                                                    var tempoajuste = (ajustefactor / 15) * (diasajustefactor);
                                                    ajustefactor = ajustefactor + tempoajuste;
                                                }
                                                else
                                                {
                                                   

                                                    ajustefactor = ajustefactor + (totalcreditos - dato.Importe);
                                                    var tempoajuste = (ajustefactor / 15) * (diasajustefactor);
                                                    ajustefactor = ajustefactor + tempoajuste;
                                                }
                                            }
                                            else
                                                if (VecesSalarioMinimo > 0)
                                                    {
                                                        if (dato.VecesSalarioMinimo > item.VecesSalarioMinimo)
                                                        {
                                                            ajustefactor = ajustefactor + (dato.Importe - totalcreditos);
                                                            var tempoajuste = (ajustefactor / 15) * (diasajustefactor);
                                                            ajustefactor = ajustefactor + tempoajuste;
                                                        }
                                                        else
                                                        {
                                                            ajustefactor = ajustefactor + (totalcreditos - dato.Importe);
                                                            var tempoajuste = (ajustefactor / 15) * (diasajustefactor);
                                                            ajustefactor = ajustefactor + tempoajuste;
                                                        }
                                                    }
                                                    else
                                                        if (Porcentaje > 0)
                                                    {
                                                        if (dato.Porcentaje > item.Porcentaje)
                                                        {
                                                            ajustefactor = ajustefactor + (dato.Importe - totalcreditos);
                                                            var tempoajuste = (ajustefactor / 15) * (diasajustefactor);
                                                            ajustefactor = ajustefactor + tempoajuste;
                                                        }
                                                        else
                                                        {
                                                            ajustefactor = ajustefactor + (totalcreditos - dato.Importe);
                                                            var tempoajuste = (ajustefactor / 15) * (diasajustefactor);
                                                            ajustefactor = ajustefactor + tempoajuste;
                                                        }
                                                    }



                                        }
                                        else
                                        {
                                            int diasajuste = 15;
                                            int año = dato.FechaInicio.Year;
                                            int mes = dato.FechaInicio.Month;
                                            if (dato.FechaInicio.Day > 15)
                                            {
                                                diasajuste = DateTime.DaysInMonth(año, mes);
                                                diasajuste = diasajuste - dato.FechaInicio.Day;
                                            }
                                            else
                                            { diasajuste = diasajuste - dato.FechaInicio.Day; }

                                            ajustefactor = ajustefactor + (totalcreditos - ((dato.Importe / 15) * diasajuste));
                                        }
                                    }
                                    //else
                                    //    ajustefactor = ajustefactor + (totalcreditos - dato.Importe);

                                }

                                if (NominaTrabajador.TrabajadorConIncapacipdadActiva == false)
                                {
                                  

                                          VariablesNominaTrabajador vnt = new VariablesNominaTrabajador();
                                    vnt.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    vnt.Concepto = "AjusteFactorAplicado";
                                    vnt.IdIncidenciaTrabajador = item.IdCreditoTrabajador;
                                    vnt.Importe = 0;


                                    NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt);

                                    if (afavor==true)
                                    {
                                        if (ajustefactor < 0)
                                        {
                                            ajustefactor = ajustefactor * -1;
                                        }
                                        PercepcionesNominaTrabajador percepcionPositiva = new PercepcionesNominaTrabajador();

                                        percepcionPositiva.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        percepcionPositiva.IdNomina = NominaTrabajador.IdNomina;
                                        percepcionPositiva.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN").FirstOrDefault().IdPlantillaNominaPercepcion;
                                        percepcionPositiva.Importe = ajustefactor ;

                                        percepcionPositiva.Tipo = "NORMAL";
                                        percepcionPositiva.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                        percepcionPositiva.Concepto = item.Catalogos_ctTipoCredito.TipoCredito + " AJUSTE DE FACTOR";
                                        percepcionPositiva.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                        percepcionPositiva.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                        NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcionPositiva);

                                    }
                                    else
                                    if (ajustefactor > 0)
                                    {
                                        DeduccionesNominaTrabajador ajustefactordeducc = new DeduccionesNominaTrabajador();
                                        ajustefactordeducc.EsImprimibleRecibo = true;
                                        ajustefactordeducc.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                        ajustefactordeducc.IdNomina = NominaTrabajador.Nomina_stNomina.IdNomina;
                                        ajustefactordeducc.IdPlantillaNominaDeduccion = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "DIFERENCIA").FirstOrDefault().IdPlantillaNominaDeduccion;
                                        ajustefactordeducc.Importe = ajustefactor;
                                        ajustefactordeducc.Concepto = item.Catalogos_ctTipoCredito.TipoCredito + " AJUSTE DE FACTOR";
                                        NominaTrabajador.ListaDeduccionesTrabajadores.Add(ajustefactordeducc);

                                    }

                                }
                            }

                            //solo si le alcanza lo agrega como dedución
                            if ((micredito.Importe > 0 && sueldoRemanente > 0 && !NominaTrabajador.TrabajadorConIncapacipdadActiva) )

                            {
                                if (item.EsParaDevolucion == false)
                                {
                                    
                                 
                                    NominaTrabajador.ListaCreditosTrabajador.Add(micredito);



                                    if (totalcreditos > 0)
                                    {
                                        if (item.IdCreditoTrabajadorFactor==null && item.EsAplicado == false && item.EsYaDevuelto == false && item.Catalogos_ctTipoCredito.TipoCredito == "INFONAVIT")
                                        {

                                            //var diasremanentes = (NominaTrabajador.Nomina_stNomina.FechaInicio - item.FechaInicioCredito).TotalDays;


                                            //Nova.Libraries.DateDifference difdias = new Nova.Libraries.DateDifference(item.FechaInicioCredito.AddDays(-1), NominaTrabajador.Nomina.FechaInicio);
                                            //Nova.Libraries.DateDifference difdias = new Nova.Libraries.DateDifference(item.FechaInicioCredito, NominaTrabajador.Nomina.FechaInicio);

                                            var diasremanentes = (NominaTrabajador.Nomina.FechaInicio - item.FechaInicioCredito).TotalDays;
                                            //var diasremanentes = difdias.Days;

                                            int mesescon31dias = 0;
                                            if (plazatrabajador.CalcularNominaDiasCalendario == false)
                                            {
                                                mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(NominaTrabajador.Nomina_stNomina.FechaInicio, item.FechaInicioCredito);
                                            }

                                            diasremanentes = diasremanentes - mesescon31dias;


                                            decimal importe100 = 0M;
                                            if (diasremanentes > 0)
                                            {
                                                //importe100 = Math.Round((totalcreditos * (decimal)diasremanentes) / 15, 2);
                                                var diasajuste = (NominaTrabajador.Nomina_stNomina.FechaInicio.AddDays(-1) - item.FechaInicioCredito).Days + 1;
                                                importe100 = Math.Round(((totalcreditos / diaslaborados) * (decimal)diasajuste), 2);

                                            }

                                            if ((sueldoRemanente - totalcreditos) > 0 || (sueldoRemanente - (importe100 + totalcreditos) < 0))
                                            {

                                                if (importe100 > 0)

                                                {
                                                    if (sueldoRemanente - (importe100 + totalcreditos) > 0)
                                                    {

                                                        // diasremanentes = (NominaTrabajador.Nomina_stNomina.FechaInicio - (DateTime)item.FechaTermino).TotalDays;
                                                        // importe100 = Math.Round(((totalcreditos / 15) * (decimal)diasremanentes), 2);


                                                        CreditosTrabajador creditoAjuste = new CreditosTrabajador();
                                                        creditoAjuste.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                                        creditoAjuste.IdCreditoTrabajador = item.IdCreditoTrabajador;
                                                        creditoAjuste.Importe = importe100;
                                                        creditoAjuste.EsAjuste = true;
                                                        NominaTrabajador.ListaCreditosTrabajador.Add(creditoAjuste);

                                                        sueldoRemanente = sueldoRemanente - importe100;
                                                    }
                                                    else
                                                    if (sueldoRemanente - (importe100 + totalcreditos) < 0)
                                                    {
                                                        //INfonavitSaldoNoPagado = importe100;
                                                        //NoAlcanzaPagoInfonavit = true;

                                                        //var numerodeparcialidades =  Math.Round(importe100 / totalcreditos,0);

                                                        decimal impotecuotafija = 0;
                                                        //if (ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.EsCuotaSindical == true)
                                                        //{

                                                        //    short idpnp = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().IdPlantillaNominaPercepcion;


                                                        //    Plazas_ctCostoHoraJornada costos = NominaTrabajador.Plazas_ctCostoHoraJornadaVigentes.Where(d => d.IdCategoria == ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.IdCategoria).FirstOrDefault();
                                                        //    if (costos == null) throw new ApplicationException("No existe costo-hora-jornada para la categoría: " + ConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Categoria.ToString());

                                                        //    //                decimal impotecuotafija = NominaTrabajador.CostoPorHora * NominaTrabajador.DiasPagados * (decimal)0.01;
                                                        //    //decimal impotecuotafija = (((costos.CostoPorHora * NominaTrabajador.DiasNomina * costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo) * NominaTrabajador.DiasPagados) / NominaTrabajador.DiasNomina)*0.01M;
                                                        //    //decimal impotecuotafija = ((((costos.CostoPorHora *  costos.Plazas_ctCategoria.Catalogos_ctJornadaLaboral.HorasMaximo)*NominaTrabajador.DiasNomina) * NominaTrabajador.DiasPagados) / NominaTrabajador.DiasNomina) * 0.01M;
                                                        //    var sueldoQna = NominaTrabajador.ListaPercepcionesTrabajadores.Where(s => s.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria && s.IdPlantillaNominaPercepcion == idpnp).FirstOrDefault();
                                                        //    impotecuotafija = sueldoQna.Importe * 0.01M;
                                                        //}
                                                        if (NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "CUOTA SINDICAL").SingleOrDefault() != null)
                                                        {       short ipnd = NominaTrabajador.PlantillaNominaDeducciones.Where(x => x.Deducciones_ctDeduccion.Deduccion == "CUOTA SINDICAL").SingleOrDefault().IdPlantillaNominaDeduccion;
                                                        var tienecuota = NominaTrabajador.ListaDeduccionesTrabajadores.Where(q => q.IdPlantillaNominaDeduccion == ipnd && q.IdConvenioLaboralTrabajadorCategoria == ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
                                                        if (tienecuota != null)
                                                        {
                                                            impotecuotafija = tienecuota.Importe;
                                                        }
                                                        }
                                                        sueldoRemanente = sueldoRemanente - impotecuotafija;
                                                        var porcentajo20 = totalcreditos;
                                                        //var porcentajo20 = sueldoRemanente - (sueldoRemanente * 0.20M);
                                                        CreditosTrabajador creditoAjuste = new CreditosTrabajador();
                                                        creditoAjuste.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                                        creditoAjuste.IdCreditoTrabajador = item.IdCreditoTrabajador;
                                                        creditoAjuste.Importe = porcentajo20;
                                                        creditoAjuste.EsAjuste = true;
                                                        NominaTrabajador.ListaCreditosTrabajador.Add(creditoAjuste);

                                                        

                                                        var cuota = creditoAjuste.Importe;
                                                        // se le genera un credito nuevo para los descuentos posteriores
                                                        Creditos_stCreditoTrabajador credito = new Creditos_stCreditoTrabajador();
                                                        credito.IdCreditoTrabajador = 1;
                                                        credito.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                                                        credito.IdTipoCredito = NominaTrabajador.Catalogos_ctTipoCredito.Where(s => s.TipoCredito == "INFONAVIT").FirstOrDefault().IdTipoCredito;
                                                        credito.VecesSalarioMinimo = null;
                                                        credito.CuotaFija = cuota;
                                                        credito.Porcentaje = null;
                                                        credito.FechaInicioCredito = NominaTrabajador.Nomina_stNomina.FechaTermino.AddDays(1);
                                                        credito.FechaInicioDescuento = NominaTrabajador.Nomina_stNomina.FechaTermino.AddDays(1);
                                                        credito.FechaTermino = null;
                                                        credito.ImporteCredito = importe100;
                                                        credito.Parcialidades = 0;
                                                        credito.Saldo = importe100- cuota;
                                                        credito.ParcialidadesPagadas = 0;

                                                        credito.NumeroCredito = item.NumeroCredito;
                                                        credito.IdEmpleado = null;
                                                        credito.NoFonacot = null;
                                                        credito.IdCreditoTipoDescuento = 1;

                                                        credito.EsAjustetSaldoInsuficiente = true;
                                                        credito.EsAplicado = true;
                                                        credito.EsParaDevolucion = false;
                                                        credito.EsYaDevuelto = false;
                                                        credito.IdCreditoTrabajadorFactor = null;
                                                        credito.AjusteFactorAplicado = false;

                                                        VariablesNominaTrabajador vnt_t = new VariablesNominaTrabajador();
                                                        vnt_t.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                                                        vnt_t.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                                        vnt_t.Concepto = "CREDITOSAPLICADOSPORCREDITOSGENERADOSPORSISTEMA";
                                                        vnt_t.Importe = item.IdCreditoTrabajador;
                                                        NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt_t);

                                                        NominaTrabajador.ListaCreditosTrabajadorPagosIndebidos.Add(credito);

                                                        //sueldoRemanente = 0;

                                                        sueldoRemanente=sueldoRemanente - porcentajo20;
                                                    }

                                                }
                                            }
                                        }


                                    }


                                }
                                else
                                {
                                    if (totalcreditos > 0)
                                    {
                                        if (item.EsYaDevuelto == false)
                                        {
                                            double difereciaHistoria = 0;
                                            decimal importeumihistoria = 0;
                                            //var diasremanentes = (NominaTrabajador.Nomina.FechaInicio - item.FechaTermino.Value.AddDays(1)).TotalDays;
                                            //Nova.Libraries.DateDifference difdias = new Nova.Libraries.DateDifference(item.FechaTermino.Value.AddDays(-1), NominaTrabajador.Nomina.FechaInicio);
                                            if (item.FechaTermino.Value < NominaTrabajador.ctUMI.FechaInicio)
                                            //se debe de buscar la umi en base a la vecha de terino del credito
                                            {
                                                var umihistoria = NominaTrabajador.ctUMIHistorial.Where(a => a.FechaInicio <= item.FechaTermino && a.FechaTermino >= item.FechaTermino.Value).FirstOrDefault();
                                                if (umihistoria != null)
                                                {
                                                    importeumihistoria = umihistoria.Monto;
                                                    //aqui se resta un dia para que cuadre caso german base
                                                    //Nova.Libraries.DateDifference difdiasH1 = new Nova.Libraries.DateDifference(item.FechaTermino.Value.AddDays(-1), umihistoria.FechaTermino);

                                                    TimeSpan difdiasH1 =    (item.FechaTermino.Value.AddDays(-1)- umihistoria.FechaTermino);
                                                    difereciaHistoria = difdiasH1.TotalDays;
                                                }
                                            }

                                            TimeSpan t =   (NominaTrabajador.Nomina.FechaInicio-item.FechaTermino.Value );

                                            double diasremanentes = t.TotalDays;

                                            var mesescon31dias = Nova.Libraries.Meses.NumeroDeMesesCon31Dias(item.FechaTermino.Value,NominaTrabajador.Nomina.FechaInicio);
                                            var diasfeb = Nova.Libraries.Meses.SumarDiasSiEsFebreroa30(item.FechaTermino.Value,NominaTrabajador.Nomina.FechaInicio );

                                            diasremanentes = (diasremanentes - mesescon31dias) + diasfeb;
                                            decimal importe100 = 0M;
                                            if (diasremanentes > 0)
                                            {
                                                if (difereciaHistoria > 0)
                                                {
                                                    decimal resultadoimporte = 0;
                                                    if (VecesSalarioMinimo > 0)
                                                    {
                                                        if (item.Creditos_ctCreditoTipoDescuento.CreditoTipoDescuento == "MENSUAL")
                                                        {
                                                            double difdiashis = diasremanentes - difereciaHistoria;
                                                            resultadoimporte = (((((importeumihistoria * VecesSalarioMinimo) / 2)/15)*(int)difereciaHistoria) );
                                                            resultadoimporte = resultadoimporte+(((((NominaTrabajador.ctUMI.Monto * VecesSalarioMinimo) / 2) / 15) * (int)difdiashis) );
                                                            resultadoimporte = resultadoimporte + 3.75M;

                                                        }
                                                        else
                                                        {
                                                            totalcreditos = (((NominaTrabajador.ctUMI.Monto * VecesSalarioMinimo)) + 3.75M);

                                                        }

                                                    }
                                                }
                                                else
                                                    //importe100 = Math.Round((totalcreditos * (decimal)diasremanentes) / 15, 2);
                                                    importe100 = Math.Round(((totalcreditos / 15) * (decimal)diasremanentes), 2);

                                            }

                                            //if ((sueldoRemanente - totalcreditos) > 0)
                                            //{

                                            if (importe100 > 0)
                                            {
                                                //sueldoRemanente = sueldoRemanente - totalcreditos;

                                                //    diasremanentes = (NominaTrabajador.Nomina.FechaInicio - (DateTime)item.FechaTermino).TotalDays;
                                                        //Nova.Libraries.DateDifference difdiascred = new Nova.Libraries.DateDifference((DateTime)item.FechaTermino.Value.AddDays(-1), NominaTrabajador.Nomina.FechaInicio);
                                                //Nova.Libraries.DateDifference difdiascred = new Nova.Libraries.DateDifference((DateTime)item.FechaTermino.Value, NominaTrabajador.Nomina.FechaInicio);
                                                //diasremanentes = difdiascred.Days;
                                                //TimeSpan t2 = (NominaTrabajador.Nomina.FechaInicio - item.FechaTermino.Value);
                                                  //diasremanentes = t2.TotalDays;
                                                importe100 = Math.Round(((totalcreditos / 15) * (decimal)diasremanentes), 2);
                                                PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

                                                percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                                percepcion.IdNomina = NominaTrabajador.IdNomina;
                                                percepcion.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN").FirstOrDefault().IdPlantillaNominaPercepcion;
                                                percepcion.Importe = importe100;

                                                percepcion.Tipo = "NORMAL";
                                                percepcion.EsGrabable = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN").FirstOrDefault().Percepciones_ctPercepcion.EsGravable;
                                                percepcion.Concepto = item.Catalogos_ctTipoCredito.TipoCredito;
                                                percepcion.EsVariable = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN").FirstOrDefault().Percepciones_ctPercepcion.EsVariable;
                                                percepcion.EsPrevisionSocial = (bool)NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "DEVOLUCIÓN").FirstOrDefault().Percepciones_ctPercepcion.EsPrevisionSocial; ;
                                                NominaTrabajador.ListaPercepcionesTrabajadores.Add(percepcion);

                                                VariablesNominaTrabajador vnt_t = new VariablesNominaTrabajador();

                                                vnt_t.IdTrabajador = ConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador;
                                                vnt_t.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                                vnt_t.Concepto = "CREDITOSDEVUELTOS";
                                                vnt_t.Importe = item.IdCreditoTrabajador;
                                                NominaTrabajador.ListaVariablesNominaTrabajador.Add(vnt_t);
                                                //CreditosTrabajador creditoAjuste = new CreditosTrabajador();
                                                //creditoAjuste.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                                //creditoAjuste.IdCreditoTrabajador = item.IdCreditoTrabajador;
                                                //creditoAjuste.Importe = importe100;
                                                //creditoAjuste.EsAjuste = true;
                                                //NominaTrabajador.ListaCreditosTrabajador.Add(creditoAjuste);
                                            }
                                            //  }// if ((sueldoRemanente - totalcreditos) > 0)
                                        }


                                    }
                                }
                            }
                            else
                            {
                                bool agregacredito = true;
                                if (item.EsAjustetSaldoInsuficiente == true && totalcreditos == 0)
                                {
                                    agregacredito = false;
                                }
                                if (agregacredito)
                                {
                                    CreditosTrabajador creditoNoAplicado = new CreditosTrabajador();
                                    creditoNoAplicado.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                    creditoNoAplicado.IdCreditoTrabajador = item.IdCreditoTrabajador;
                                    creditoNoAplicado.Importe = totalcreditos;
                                    creditoNoAplicado.EsAjuste = false;

                                    if (NominaTrabajador.TrabajadorConIncapacipdadActivaConcepto == "")
                                        creditoNoAplicado.Motivo = "SIN SALDO";
                                    else
                                        creditoNoAplicado.Motivo = NominaTrabajador.TrabajadorConIncapacipdadActivaConcepto;

                                    NominaTrabajador.ListaCreditosTrabajadorNoAplicados.Add(creditoNoAplicado);
                                }

                            }

                            if (NoAlcanzaPagoInfonavit)
                            {
                                //sueldoRemanente = sueldoRemanente - sueldoRemanente;

                                CreditosTrabajador creditoNoAplicado = new CreditosTrabajador();
                                creditoNoAplicado.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                                creditoNoAplicado.IdCreditoTrabajador = item.IdCreditoTrabajador;
                                creditoNoAplicado.Importe = INfonavitSaldoNoPagado;
                                creditoNoAplicado.EsAjuste = false;

                                if (NominaTrabajador.TrabajadorConIncapacipdadActivaConcepto == "")
                                    creditoNoAplicado.Motivo = "SIN SALDO";
                                else
                                    creditoNoAplicado.Motivo = NominaTrabajador.TrabajadorConIncapacipdadActivaConcepto;

                                NominaTrabajador.ListaCreditosTrabajadorNoAplicados.Add(creditoNoAplicado);

                            }

                        }// credito misma nomina null

                    }

                }
        }


        //public class Sueldo:ISueldo
        //{

        //    private decimal costoporhora=0,sueldo=0;
        //    private int horasjornada = 0;
        //    private int DiasNomina = 0;
        //    private int IdNomina = 0;
        //    private short IdPlantillaNominaPercepcion;
        //    public PercepcionesNominaTrabajador Calcular(Convenios_stConvenioLaboralTrabajadorCategoria ConvenioLaboralTrabajadorCategoria, Nomina_stNominaTrabajador NominaTrabajador)
        //    {

        //        PercepcionesNominaTrabajador percepcion = new PercepcionesNominaTrabajador();

        //        this.IdPlantillaNominaPercepcion = NominaTrabajador.PlantillaNominaPercepciones.Where(x => x.Percepciones_ctPercepcion.Percepcion == "SUELDO").FirstOrDefault().IdPlantillaNominaPercepcion;

        //        this.DiasNomina=NominaTrabajador.Nomina.Nomina_ctPlantillaNomina.Catalogos_ctPeriodoNomina.Dias;
        //        this.IdNomina = NominaTrabajador.Nomina.IdNomina;

        //        horasjornada = NominaTrabajador.JornadaLaboral.HorasMaximo;
        //        costoporhora = NominaTrabajador.CostoHoraJornada.CostoPorHora;
        //        NominaTrabajador.CostoPorHora = costoporhora;
        //        NominaTrabajador.CostoPorHoraExcedente = NominaTrabajador.CostoHoraJornada.CostoPorHoraExcedente;
        //        //Costo horas interinas
        //        NominaTrabajador.CostoPorHorasInterinas=0;

        //        sueldo = costoporhora * this.DiasNomina * horasjornada;

        //        percepcion.IdConvenioLaboralTrabajadorCategoria = ConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
        //        percepcion.IdNomina = this.IdNomina;
        //        percepcion.IdPlantillaNominaPercepcion = this.IdPlantillaNominaPercepcion;
        //        percepcion.Importe = sueldo;

        //        return percepcion;
        //    }

    }
    //}
}