﻿using Nova.Models.Calculos;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
 

namespace Nova.Models
{
    public class NominaParaContrato
    {
        public Decimal Sueldo { get; set; }
        public Decimal AyudaParaDespensa { get; set; }
        public Decimal MaterialDidactico { get; set; }
        public Decimal Eficiencia { get; set; }
    }

    
    public class CalculadoraSueldo
    {
        bdNovaEntities db = new bdNovaEntities();

        private Plazas_ctCostoHoraJornada ObtenerCostoPorFecha(List<Plazas_ctCostoHoraJornada> tablaNomina, DateTime fecha,short  idcategoria)
        {

            foreach (var row in tablaNomina.Where(a=> a.IdCategoria==idcategoria).ToList())
            {
                DateTime fechaInicio = Convert.ToDateTime(row.FechaInicio);
                DateTime fechaTermino = Convert.ToDateTime(row.FechaTermino);
                DateTime fechaAplicacion = Convert.ToDateTime(row.FechaAplicacion);

                if (fecha >= fechaInicio && fecha <= fechaTermino && fecha.Date >= fechaAplicacion.Date)
                {
                    return row;
                }
            }

            return null;
        }
        public NominaParaContrato getSueldoVigente(int IdConvenioLaboralTrabajadorCategoria,int horascargahoraria,DateTime fecha)
        {
            NominaParaContrato nomina = new NominaParaContrato();
            var trabajador=db.vwDatosAspirantesTrabajadoresHistorial.Where(a => a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            var plantilla=db.Percepciones_stPlantillaNominaPercepciones.Where(s =>
            s.Percepciones_ctPercepcion.Percepcion== "AYUDA PARA DESPENSA" &&
            s.Nomina_ctPlantillaNomina.EsVigente && s.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral).FirstOrDefault();
            nomina.AyudaParaDespensa = Math.Round((decimal)plantilla.Importe,2);

           var horascostos=ObtenerCostoPorFecha(db.Plazas_ctCostoHoraJornada.ToList(), fecha,(short) trabajador.IdCategoria);
            //var horascostos = db.Plazas_ctCostoHoraJornada.Where(q => q.IdCategoria == trabajador.IdCategoria
           // && DbFunctions.TruncateTime(DateTime.Now) >= q.FechaAplicacion).OrderByDescending(w=> w.FechaTermino).OrderByDescending(q=> q.FechaInicio ).FirstOrDefault();
            decimal totalsuledo = 0;
            if (trabajador.RelacionLaboral == "ADMINISTRATIVO")
            {
                totalsuledo = ((horascostos.CostoPorHora *  7) * 15);
                nomina.Sueldo = Math.Round(totalsuledo, 2);
            }
            else {
                totalsuledo = ((horascostos.CostoPorHora * 2) * horascargahoraria);
                nomina.Sueldo = Math.Round(totalsuledo, 2);
            }

            Decimal MaterialDidactico = 0;
            if (trabajador.RelacionLaboral == "ADMINISTRATIVO")
            {
                 MaterialDidactico = ((horascostos.CostoMaterialDidactico * 7) * 15);
                nomina.MaterialDidactico = Math.Round(MaterialDidactico,2);
            }
            else
            {
                 MaterialDidactico = ((horascostos.CostoMaterialDidactico * 2) * horascargahoraria) ;
                nomina.MaterialDidactico = Math.Round(MaterialDidactico,2);
            }

            decimal Eficiencia = 0;
            if (trabajador.RelacionLaboral == "ADMINISTRATIVO")
            {
                 Eficiencia = ((horascostos.CostoEficienciaJornada  * 7) * 15);
                nomina.Eficiencia = Math.Round(Eficiencia,2);
            }
            else {
                 Eficiencia = ((horascostos.CostoEficienciaJornada * 2) * horascargahoraria);
                nomina.Eficiencia = Math.Round(Eficiencia,2);
            }
            return nomina;


    }
            public Nomina_stNominaTrabajador getSueldo(int IdConvenioLaboralTrabajadorCategoria)
        {
            DateTime hoy = DateTime.Now;
            DateTime qnaini = DateTime.Now;
            DateTime qnafin = DateTime.Now;

            Nomina_stNominaTrabajador perpcecionessueldo = new Nomina_stNominaTrabajador();
            //generar el rango de una nomina ne base al dia actual
            if (hoy.Day > 15)
            {
                qnaini = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-16");
                var DaysInMonth=DateTime.DaysInMonth(qnaini.Year, qnaini.Month);
                
                qnafin = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-"+ DaysInMonth.ToString());
            }
            else
            {
                qnaini = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-01");
                qnafin = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-15");
            }


            // se busca los datos generales del trabajador para generar la nomina
            var trabajador = db.vwDatosAspirantesTrabajadoresHistorial.Where(s => s.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            Nomina_stNomina nominaaprocesar = new Nomina_stNomina();

            nominaaprocesar = db.Nomina_stNomina.Where(x => x.FechaInicio == qnaini && x.FechaTermino == qnafin && x.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral
            && x.Nomina_ctPlantillaNomina.Nomina_ctPlantillaGrupo.PlantillaGrupo == "SUELDO").FirstOrDefault();

            if (nominaaprocesar == null)
            {
                nominaaprocesar = db.Nomina_stNomina.Where(x => x.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral
            && x.Nomina_ctPlantillaNomina.Nomina_ctPlantillaGrupo.PlantillaGrupo == "SUELDO").OrderByDescending(s => s.FechaTermino).FirstOrDefault();
            }

            
            Nomina_stNominaTrabajador nt = new Nomina_stNominaTrabajador(nominaaprocesar.IdNomina, IdConvenioLaboralTrabajadorCategoria,false,false,true);

           
            switch (nt.Nomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral)
            {
                case "ADMINISTRATIVO-CONFIANZA":
                    {

                       
                        var nomina = new NominaConfianza(nt);
                   
                        nomina.CalcularSueldo();
                        perpcecionessueldo = nt;

                        break;
                    }
                case "ADMINISTRATIVO-BASE":
                    {
                         
                        var nomina = new NominaBase(nt);
                       

                        nomina.CalcularSueldo();
                        perpcecionessueldo = nt;
                        break;
                    }
                case "DOCENTE-CONTRATO":
                    {
 
                        var nomina = new NominaDocenteInterino(nt);
                        nomina.CalcularSueldo();
                        perpcecionessueldo = nt;

                        break;
                    }
                case "DOCENTE-BASE":
                    {

                        
                        var nomina = new NominaDocenteBase(nt);
                        nomina.CalcularSueldo();
                        perpcecionessueldo = nt;

                        break;
                    }


                case "DOCENTE-DEFINITIVO SPD":
                    {


                        var nomina = new NominaDocenteDefinitivo(nt);
                        nomina.CalcularSueldo();
                        perpcecionessueldo = nt;

                        break;
                    }

                case "MANDO MEDIO-SUPERIOR":
                    {


                        var nomina = new NominaMandosMedios(nt);
                        nomina.CalcularSueldo();
                        perpcecionessueldo = nt;

                        break;
                    }
                case "ADMINISTRATIVO-CONTRATO":
                    {


                        var nomina = new NominaInterinoAdministrativa(nt);
                        nomina.CalcularSueldo();
                        perpcecionessueldo = nt;

                        break;
                    }
                default:
                    break;
            }

            return perpcecionessueldo;
        }

        public Nomina_stNominaTrabajador getEficiencia(int IdConvenioLaboralTrabajadorCategoria)
        {
            DateTime hoy = DateTime.Now;
            DateTime qnaini = DateTime.Now;
            DateTime qnafin = DateTime.Now;

            Nomina_stNominaTrabajador perpcecionessueldo = new Nomina_stNominaTrabajador();
            //generar el rango de una nomina ne base al dia actual
            if (hoy.Day > 15)
            {
                qnaini = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-16");
                var DaysInMonth = DateTime.DaysInMonth(qnaini.Year, qnaini.Month);

                qnafin = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-" + DaysInMonth.ToString());
            }
            else
            {
                qnaini = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-01");
                qnafin = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-15");
            }


            // se busca los datos generales del trabajador para generar la nomina
            var trabajador = db.vwDatosAspirantesTrabajadoresHistorial.Where(s => s.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            Nomina_stNomina nominaaprocesar = new Nomina_stNomina();

            nominaaprocesar = db.Nomina_stNomina.Where(x => x.FechaInicio == qnaini && x.FechaTermino == qnafin && x.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral
            && x.Nomina_ctPlantillaNomina.Nomina_ctPlantillaGrupo.PlantillaGrupo == "SUELDO").FirstOrDefault();

            if (nominaaprocesar == null)
            {
                nominaaprocesar = db.Nomina_stNomina.Where(x => x.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral
            && x.Nomina_ctPlantillaNomina.Nomina_ctPlantillaGrupo.PlantillaGrupo == "SUELDO").OrderByDescending(s => s.FechaTermino).FirstOrDefault();
            }


            Nomina_stNominaTrabajador nt = new Nomina_stNominaTrabajador(nominaaprocesar.IdNomina, IdConvenioLaboralTrabajadorCategoria, false, false, true);


            switch (nt.Nomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral)
            {
                case "ADMINISTRATIVO-CONFIANZA":
                    {


                        var nomina = new NominaConfianza(nt);

                        throw new Exception("no hay calculo de eficiencia");
                      //  nomina.CalcularSueldo();
                        perpcecionessueldo = nt;

                        break;
                    }
                case "ADMINISTRATIVO-BASE":
                    {

                        var nomina = new NominaBase(nt);


                        throw new Exception("no hay calculo de eficiencia");
                        //  nomina.CalcularSueldo();
                        perpcecionessueldo = nt;
                        break;
                    }
                case "DOCENTE-CONTRATO":
                    {

                        var nomina = new NominaDocenteInterino(nt);
                        throw new Exception("no hay calculo de eficiencia");
                        //  nomina.CalcularSueldo();
                        perpcecionessueldo = nt;

                        break;
                    }
                case "DOCENTE-BASE":
                    {


                        var nomina = new NominaDocenteBase(nt);
                        throw new Exception("no hay calculo de eficiencia");
                        //  nomina.CalcularSueldo();
                        perpcecionessueldo = nt;

                        break;
                    }


                case "DOCENTE-DEFINITIVO SPD":
                    {


                        var nomina = new NominaDocenteDefinitivo(nt);
                        throw new Exception("no hay calculo de eficiencia");
                        //  nomina.CalcularSueldo();
                        perpcecionessueldo = nt;

                        break;
                    }

                case "MANDO MEDIO-SUPERIOR":
                    {


                        var nomina = new NominaMandosMedios(nt);
                        throw new Exception("no hay calculo de eficiencia");
                        //  nomina.CalcularSueldo();
                        perpcecionessueldo = nt;

                        break;
                    }
                case "ADMINISTRATIVO-CONTRATO":
                    {


                        var nomina = new NominaInterinoAdministrativa(nt);
                        nomina.CalcularEficiencia();
                        perpcecionessueldo = nt;

                        break;
                    }
                default:
                    break;
            }

            return perpcecionessueldo;
        }

        public Nomina_stNominaTrabajador getAyudaDespensa(int IdConvenioLaboralTrabajadorCategoria)
        {
            DateTime hoy = DateTime.Now;
            DateTime qnaini = DateTime.Now;
            DateTime qnafin = DateTime.Now;

            Nomina_stNominaTrabajador perpcecionessueldo = new Nomina_stNominaTrabajador();
            //generar el rango de una nomina ne base al dia actual
            if (hoy.Day > 15)
            {
                qnaini = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-16");
                var DaysInMonth = DateTime.DaysInMonth(qnaini.Year, qnaini.Month);

                qnafin = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-" + DaysInMonth.ToString());
            }
            else
            {
                qnaini = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-01");
                qnafin = DateTime.Parse(hoy.Year + "-" + hoy.Month + "-15");
            }


            // se busca los datos generales del trabajador para generar la nomina
            var trabajador = db.vwDatosAspirantesTrabajadoresHistorial.Where(s => s.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            Nomina_stNomina nominaaprocesar = new Nomina_stNomina();

            nominaaprocesar = db.Nomina_stNomina.Where(x => x.FechaInicio == qnaini && x.FechaTermino == qnafin && x.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral
            && x.Nomina_ctPlantillaNomina.Nomina_ctPlantillaGrupo.PlantillaGrupo == "AYUDA PARA DESPENSA").FirstOrDefault();

            if (nominaaprocesar == null)
            {
                nominaaprocesar = db.Nomina_stNomina.Where(x => x.Nomina_ctPlantillaNomina.IdRelacionConvenioLaboral == trabajador.IdRelacionConvenioLaboral
            && x.Nomina_ctPlantillaNomina.Nomina_ctPlantillaGrupo.PlantillaGrupo == "AYUDA PARA DESPENSA").OrderByDescending(s => s.FechaTermino).FirstOrDefault();
            }


            Nomina_stNominaTrabajador nt = new Nomina_stNominaTrabajador(nominaaprocesar.IdNomina, IdConvenioLaboralTrabajadorCategoria, false, false, true);


            switch (nt.Nomina.Nomina_ctPlantillaNomina.Convenios_stRelacionConvenioLaboral.RelacionConvenioLaboral)
            {
                case "ADMINISTRATIVO-CONFIANZA":
                    {


                        var nomina = new NominaConfianza(nt);

                        nomina.CalcularAyudaDespensa();
                        perpcecionessueldo = nt;

                        break;
                    }
                case "ADMINISTRATIVO-BASE":
                    {

                        var nomina = new NominaBase(nt);


                        nomina.CalcularAyudaDespensa();
                        perpcecionessueldo = nt;
                        break;
                    }
                case "DOCENTE-CONTRATO":
                    {

                        var nomina = new NominaDocenteInterino(nt);
                        nomina.CalcularAyudaDespensa();
                        perpcecionessueldo = nt;

                        break;
                    }
                case "DOCENTE-BASE":
                    {


                        var nomina = new NominaDocenteBase(nt);
                        nomina.CalcularAyudaDespensa();
                        perpcecionessueldo = nt;

                        break;
                    }


                case "DOCENTE-DEFINITIVO SPD":
                    {


                        var nomina = new NominaDocenteDefinitivo(nt);
                        nomina.CalcularAyudaDespensa();
                        perpcecionessueldo = nt;

                        break;
                    }

                case "MANDO MEDIO-SUPERIOR":
                    {


                        var nomina = new NominaMandosMedios(nt);
                        nomina.CalcularAyudaDespensa();
                        perpcecionessueldo = nt;

                        break;
                    }
                case "ADMINISTRATIVO-CONTRATO":
                    {


                        var nomina = new NominaInterinoAdministrativa(nt);
                        nomina.CalcularAyudaDespensa();
                        perpcecionessueldo = nt;

                        break;
                    }
                default:
                    break;
            }

            return perpcecionessueldo;
        }

    }
}