﻿using System;
using System.Collections.Generic;
using System.Data.Entity.SqlServer;
using System.Data.Linq.SqlClient;
using System.Data.SqlClient;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Web;
using Dapper;
using Seguridad;

namespace Nova.Models
{
    public class Busqueda
    {
        public static Image byteArrayToImage(byte[] byteArrayIn)
        {
            MemoryStream ms = new MemoryStream(byteArrayIn);
            Image returnImage = Image.FromStream(ms);
            return returnImage;
        }
        public static string getFoto(int id)
        {
            string ruta = HttpContext.Current.Server.MapPath("~/content/imagenes");

            ruta = Path.Combine(ruta, id.ToString() + ".jpg");

            string curFile = @""+ruta;
            if (File.Exists(curFile))
            {
                return "/content/imagenes/" + id.ToString() + ".jpg";
            }
            else
            {

                byte[] image = Kardex_ctDatosPersonales.getFotografia(id);
                if (image == null)
                    //return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.jpg"), "image/jpg");
                    return "/App_Themes/Nova/img/user.jpg";
                else
                {

                    //using (MemoryStream ms = new MemoryStream(image))
                    //{
                    //    Bitmap img = (Bitmap)Image.FromStream(ms);
                    //    return File(BitmapToByteArray(img), "image/jpg");
                    //}
                    Image miimagen = byteArrayToImage(image);



                    miimagen.Save(ruta, System.Drawing.Imaging.ImageFormat.Jpeg);


                    return "/content/imagenes/" + id.ToString() + ".jpg";
                }
            }
        }


        public static string getFotoCredes(int id)
        {
            string ruta = HttpContext.Current.Server.MapPath("~/content/imagenes");

            ruta = Path.Combine(ruta, id.ToString() + ".jpg");

            string curFile = @"" + ruta;
            if (File.Exists(curFile))
            {
                return "/content/imagenes/" + id.ToString() + ".jpg";
            }
            else
            {

                string image = Kardex_ctDatosPersonales.getFotografiaBase64(id);
                if (image == null)
                    //return File(StreamHelpers.FromFile("~/App_Themes/Nova/img/user.jpg"), "image/jpg");
                    return "/App_Themes/Nova/img/user.jpg";
                else
                {

                    //using (MemoryStream ms = new MemoryStream(image))
                    //{
                    //    Bitmap img = (Bitmap)Image.FromStream(ms);
                    //    return File(BitmapToByteArray(img), "image/jpg");
                    //}
                    //Image miimagen = byteArrayToImage(image);



                    //miimagen.Save(ruta, System.Drawing.Imaging.ImageFormat.Jpeg);


                    return "url('data:image/jpeg;base64,/" + image + "')";

                }
            }
        }
        public static List<vwDatosAspirantesTrabajadores> BuscarTrabajadoresExportar(string stringsearch)
        {
            bdNovaEntities db = new bdNovaEntities();
            if (stringsearch == null)

                return db.vwDatosAspirantesTrabajadores.ToList();
            else

                return db.vwDatosAspirantesTrabajadores
                    .Where(
                    d => SqlFunctions.StringConvert((decimal)d.IdTrabajador).Contains(stringsearch) || d.Nombre.Contains(stringsearch) || d.ApellidoPaterno.Contains(stringsearch)
                        || d.ApellidoMaterno.Contains(stringsearch) || d.CURP.Contains(stringsearch) || String.Concat(d.Nombre, " ", d.ApellidoPaterno).Contains(stringsearch)

                        ).ToList();


        }

        public static IQueryable BuscarTrabajadores(string stringsearch)
        {
            bdNovaEntities db = new bdNovaEntities();
            string query = @" select
Row
      , IdConvenioLaboralTrabajadorCategoria
      , RFC
      , IdKardex
      , CURP
      , Nombre
      , ApellidoPaterno
      , ApellidoMaterno
      , Sexo
      , IdTrabajador
      , FechaAsignacion
      , ConvenioLaboral
      , RelacionLaboral
      , Categoria
      , EstructuraOrganica
      , EstructuraOrganicaPadrePlaza
      , UbicacionFisica
      , EstructuraOrganicaPadre
      , EsComisionado
      , FechaInicio
      , FechaTermino
      , IdConvenioLaboralTrabajador
      , EstatusTrabajador
      , null as Fotografia
      , NSS
      , CorreoElectronico
      , IdCategoria
      , IdEstructuraOrganica
      , IdRelacionLaboral
      , IdConvenioLaboral
      , IdEstructuraOrganicaPadre
      , CorreoInstitucional
      , Telefono
      , OrdenEstructuraOrganica
      , IdEstructuraOrganicaFisica
      , Antiguedad
      , Años
      , Meses
      , Dias
      , Direccion
      , CorreoTrabajo
      , TelefonoTrabajo
      , ProcesoCompletado
      , IdModalidadEstudio
      , IdDistribucionPlazaCategoria
      , IdRelacionConvenioLaboral
      , IdeEmpleadoAnt
      , EsHomologado
      , CategoriaAnteriorNova
      , RelacionConvenioLaboral
      , Incidencia
      , RestringirMenu
      , Demanda
    , FechaInicioDemanda
,[Calle]
      ,[Colonia]
      ,[CodigoPostal]
      ,[NumeroExterior]
      ,[NumeroInterior]
      ,[MunicipioVive]
      ,[EstadoVive]
      ,[LocalidadVive]
 from vwDatosAspirantesTrabajadores  ";

            if (stringsearch.Trim()!="")
            query = query + @" WHERE 
Nombre like '%" + stringsearch + @"%' or ApellidoPaterno like '%" + stringsearch + @"%' OR 
(Nombre+' '+ApellidoPaterno like '%"+ stringsearch + @"%')
or ApellidoMaterno like '%"+ stringsearch + @"%' or 
cast(IdTrabajador as nvarchar(20))='" + stringsearch + @"'
OR Categoria like '%"+ stringsearch + "%' OR UbicacionFisica like '%"+ stringsearch + @"%'
OR CURP like '%"+ stringsearch + "%'";


            DapperQuery dp = new DapperQuery("bdNovaEntities");



            List<vwDatosAspirantesTrabajadores> tempo = new List<vwDatosAspirantesTrabajadores>();
            //.Where(
            //d => SqlFunctions.StringConvert((decimal)d.IdTrabajador).Contains(stringsearch) || d.Nombre.Contains(stringsearch) || d.ApellidoPaterno.Contains(stringsearch)
            //    || d.ApellidoMaterno.Contains(stringsearch) || d.CURP.Contains(stringsearch) || String.Concat(d.Nombre, " ", d.ApellidoPaterno).Contains(stringsearch)
            //   || d.Categoria.Contains(stringsearch)
            //    || d.EstructuraOrganica.Contains(stringsearch) || d.EstructuraOrganicaPadre.Contains(stringsearch)
            //    ).ToList();
            //List<vwDatosAspirantesTrabajadores> tempo44 = db.vwDatosAspirantesTrabajadores
            //.Where(
            //d => SqlFunctions.StringConvert((decimal)d.IdTrabajador).Contains(stringsearch) || d.Nombre.Contains(stringsearch) || d.ApellidoPaterno.Contains(stringsearch)
            //    || d.ApellidoMaterno.Contains(stringsearch) || d.CURP.Contains(stringsearch) || String.Concat(d.Nombre, " ", d.ApellidoPaterno).Contains(stringsearch)
            //   || d.Categoria.Contains(stringsearch)
            //    || d.EstructuraOrganica.Contains(stringsearch) || d.EstructuraOrganicaPadre.Contains(stringsearch)
            //    ).ToList();


            tempo = (List<vwDatosAspirantesTrabajadores>)dp.connection.Query<vwDatosAspirantesTrabajadores>(query);
            dp.Close();

            List<vwDatosAspirantesTrabajadores> resultado = new List<vwDatosAspirantesTrabajadores>();
            resultado.AddRange(tempo);

            SingletonAntiguedad antiguedad = SingletonAntiguedad.Instance;
            AntiguedadLaboralQuinquenioTrabajador t1 = antiguedad.getAntiguedad(1889);
            if (t1==null)
                antiguedad.Reset();

            foreach (var item in resultado)
            {






                //var t = antiguedad.Trabajadores.Where(f => f.IdTrabajador == item.IdTrabajador).FirstOrDefault();
                if (item.IdTrabajador == null)
                    item.Antiguedad = "";
                else
                {
                    AntiguedadLaboralQuinquenioTrabajador t = antiguedad.getAntiguedad((int)item.IdTrabajador);
                    if (t == null)
                        item.Antiguedad = "";
                    else
                    item.Antiguedad = "A " + t.AñosQuinquenio + " - M " + t.MesesQuinquenio.ToString() + " D -" + t.DiasQuinquenio;
                }
            }

            return resultado.AsQueryable();
              
        }

        public static IQueryable BuscarCapacitacion(string stringsearch)
        {
            bdNovaEntities db = new bdNovaEntities();
            var participantes = db.Capacitacion_stParticipantes.Select(p => p.IdKardex);
            return db.vwDatosAspirantesTrabajadores
                .Where(
                d => participantes.Contains(d.IdKardex) && (SqlFunctions.StringConvert((decimal)d.IdTrabajador).Contains(stringsearch) || d.Nombre.Contains(stringsearch) || d.ApellidoPaterno.Contains(stringsearch)
                    || d.ApellidoMaterno.Contains(stringsearch) || d.CURP.Contains(stringsearch) || String.Concat(d.Nombre, " ", d.ApellidoPaterno).Contains(stringsearch)
                   || d.Categoria.Contains(stringsearch)
                    || d.EstructuraOrganica.Contains(stringsearch) || d.EstructuraOrganicaPadre.Contains(stringsearch)
                    )
                    )
                .Select(s => new
                {
                    s.IdKardex,
                    s.IdTrabajador,
                    s.CURP,
                    s.Nombre,
                    s.ApellidoPaterno,
                    s.ApellidoMaterno
                    ,
                    s.IdConvenioLaboralTrabajadorCategoria,
                    s.RelacionLaboral,
                    s.ConvenioLaboral,
                    s.EstructuraOrganica,
                    s.EstructuraOrganicaPadre
                    ,
                    s.Sexo,
                    s.FechaInicio,
                    s.FechaTermino,
                    s.EstatusTrabajador,
                    s.Categoria,
                    s.Fotografia,
                    s.IdConvenioLaboralTrabajador,
                    s.UbicacionFisica
                }).AsQueryable();


        }

        public static IQueryable BuscarIncidencias(string stringsearch)
        {
            bdNovaEntities db = new bdNovaEntities();
            string EstructuraOrganica = Identidad.Usuario().Catalogos_ctEstructuraOrganica.EstructuraOrganica;
            return db.vwDatosAspirantesTrabajadores
                .Where(
                d => d.UbicacionFisica == EstructuraOrganica && (SqlFunctions.StringConvert((decimal)d.IdTrabajador).Contains(stringsearch) || d.Nombre.Contains(stringsearch) || d.ApellidoPaterno.Contains(stringsearch)
                    || d.ApellidoMaterno.Contains(stringsearch) || d.CURP.Contains(stringsearch) || String.Concat(d.Nombre, " ", d.ApellidoPaterno).Contains(stringsearch)
                   || d.Categoria.Contains(stringsearch)
                    || d.EstructuraOrganica.Contains(stringsearch) || d.EstructuraOrganicaPadre.Contains(stringsearch)
                    ))
                .Select(s => new
                {
                    s.IdKardex,
                    s.IdTrabajador,
                    s.CURP,
                    s.Nombre,
                    s.ApellidoPaterno,
                    s.ApellidoMaterno
                    ,
                    s.RFC,
                    s.IdConvenioLaboralTrabajadorCategoria,
                    s.RelacionLaboral,
                    s.ConvenioLaboral,
                    s.EstructuraOrganica,
                    s.EstructuraOrganicaPadre
                    ,
                    s.CorreoElectronico,
                    s.Sexo,
                    s.FechaInicio,
                    s.FechaTermino,
                    s.EstatusTrabajador,
                    s.Categoria,
                    s.Fotografia,
                    s.IdConvenioLaboralTrabajador,
                    s.UbicacionFisica,
                    s.EsComisionado

                }).AsQueryable();


        }

        public static IQueryable BuscarNominas(string stringsearch)
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.vwConfiguracionNomina
                .Where(d => SqlFunctions.StringConvert((decimal)d.Año).Contains(stringsearch) || d.Mes.Contains(stringsearch)
                    // .Where(d => d.Mes.Contains(stringsearch)
                || d.AliasNomina.Contains(stringsearch) || d.Plantilla.Contains(stringsearch)
                )
                .Select(s => new
                {
                    s.IdNomina,
                    s.Año,
                    s.Mes,
                    s.AliasNomina,
                    s.ConvenioLaboral,
                    s.FechaInicioNomina,
                    s.FechaTerminoNomina,
                    s.RelacionLaboral,
                    s.EsCerrada,
                    s.IdPlantillaNomina,
                    s.IdRelacionConvenioLaboral
                }).AsQueryable();


        }

        public static IQueryable BuscarProcesos(string stringsearch)
        {
            bdNovaEntities db = new bdNovaEntities();
            return db.Procesos_ctProcesosActividad
                .Where(d => d.Etiquetas.Contains(stringsearch)
                )
                .Select(s => new
                {
                    s.ProcesoActividad,
                    s.ControladorAccion,
                    s.Etiquetas,
                    s.IdProcesosActividad
                }).AsQueryable();


        }
    }
}