﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Nova.Libraries;
using System.Web.Mvc;
using System.Data;
using Dapper;
using System.Data.Entity;
using System.Transactions;
using Nova.Models.AsignarPlaza;

namespace Nova.Models
{
    public class EnroqueComisionModel
    {
        public int IdConvenioLaboralTrabajadorCategoriaSuplido { get; set; }
        public int IdConvenioLaboralTrabajadorCategoriaSuplente { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaTermino { get; set; }
        public string CicloEscolar { get; set; } 
        public string Folio { get; set; } 
        public string FolioReferencia { get; set; } 
    }
    public partial class ComisionesLicencias : vwDatosAspirantesTrabajadores
    {
        public string IncidenciaComision { get; set; }
        public string EstatusIncidencia { get; set; }

    }
    public class ConvenioUbicacionFisica
    {
        public int IdConvenioLaboralTrabajadorCategoria { get; set; }
      
       
        public bool EsComisionado { get; set; }
        public short IdEstructuraOrganica { get; set; }

        public string EstructuraOrganica { get; set; }
        public string CicloEscolar { get; set; }

        public System.DateTime FechaInicio { get; set; }
        public Nullable<System.DateTime> FechaTermino { get; set; }

        public Resultados GeneraComisionPorCambiodeUbicacionFisica()
        {
            Resultados rs = new Resultados();

            bdNovaEntities db = new bdNovaEntities();

            var convendiolabtrabcat = db.Convenios_stConvenioLaboralTrabajadorCategoria.Find(this.IdConvenioLaboralTrabajadorCategoria);
            Nomina_SuplenciasSolicitudes solicitud = new Nomina_SuplenciasSolicitudes();
            if (convendiolabtrabcat.IdEstructuraOrganica == this.IdEstructuraOrganica)
            {
                rs.IsValid = false;
                rs.Messsage = "Debe de elegir una ubicacion diferente a la actual";
            }

            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadCommitted;

            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {
                try
                {
                    var tipoIncidencia = db.Nomina_SuplenciaTipo.Where(z => z.IdTipoSuplencia == 6).FirstOrDefault();
                    int idTipoIncidencia = db.Catalogos_ctTipoIncidencia.Where(x => x.Incidencia == tipoIncidencia.TipoSuplencia).FirstOrDefault().IdTipoIncidencia;
                    int IDCLTC = this.IdConvenioLaboralTrabajadorCategoria;
                    if (convendiolabtrabcat.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral == "BASE")
                    {
                        Convenios_stConvenioLaboralTrabajadorCategoria _nuevoConvenioLaboralTrabajadorCategoria = new Convenios_stConvenioLaboralTrabajadorCategoria();
                        var _nuevoTrabajador = db.Kardex_ctTrabajador.Find(convendiolabtrabcat.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdTrabajador);
                        var _nuevoConvenioLaboral = db.Convenios_stConvenioLaboralTrabajador.Find(convendiolabtrabcat.IdConvenioLaboralTrabajador);



                        _nuevoConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajador = _nuevoConvenioLaboral.IdConvenioLaboralTrabajador;
                        _nuevoConvenioLaboralTrabajadorCategoria.IdDistribucionPlazaCategoria = convendiolabtrabcat.IdDistribucionPlazaCategoria;
                        _nuevoConvenioLaboralTrabajadorCategoria.IdEstructuraOrganica = this.IdEstructuraOrganica;
                        _nuevoConvenioLaboralTrabajadorCategoria.EsComisionado = true;
                        _nuevoConvenioLaboralTrabajadorCategoria.FechaInicio = this.FechaInicio;
                        _nuevoConvenioLaboralTrabajadorCategoria.FechaTermino = this.FechaTermino;
                        _nuevoConvenioLaboralTrabajadorCategoria.EsCancelado = false;
                        _nuevoConvenioLaboralTrabajadorCategoria.UserId = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                        _nuevoConvenioLaboralTrabajadorCategoria.FechaCreacion = DateTime.Now;
                        _nuevoConvenioLaboralTrabajadorCategoria.Observacion = "";
                        _nuevoConvenioLaboralTrabajadorCategoria.EsCuotaSindical = false;
                        _nuevoConvenioLaboralTrabajadorCategoria.FechaInicioPago = null;
                        _nuevoConvenioLaboralTrabajadorCategoria.EsPrimerCalculo = false;

                        db.Entry(_nuevoConvenioLaboralTrabajadorCategoria).State = EntityState.Added;
                        db.SaveChanges();



                        IncidenciaPermiso_stIncidenciaTrabajador inci = new IncidenciaPermiso_stIncidenciaTrabajador();
                        inci.IdTipoIncidencia = (short)idTipoIncidencia;
                        inci.EsCancelada = false;
                        inci.EsCerrada = true;
                        inci.FechaCreacion = DateTime.Now;
                        inci.FechaInicio = this.FechaInicio;

                        if (this.FechaTermino != null)
                            inci.FechaTermino = this.FechaTermino;

                        inci.IdConvenioLaboralTrabajadorCategoria = (int)(int)convendiolabtrabcat.IdConvenioLaboralTrabajadorCategoria;
                        inci.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;

                        db.Entry(inci).State = EntityState.Added;
                        db.SaveChanges();

                        IDCLTC = _nuevoConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria;
                    }

                    solicitud.IdCategoria = convendiolabtrabcat.Plazas_stDistribucionPlazaCategoria.IdCategoria;
                    solicitud.IdTipoSuplencia = 6;
                    solicitud.IdKardexSuplente = convendiolabtrabcat.Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex; ;

                    solicitud.IdEstructuraOrganica = convendiolabtrabcat.IdEstructuraOrganica;
                    solicitud.IdEstructuraOrganicaFisica = this.IdEstructuraOrganica;
                    solicitud.FolioOficio = "sn";
                    solicitud.CicloEscolar = this.CicloEscolar;
                    solicitud.FechaInicio = this.FechaInicio;
                    solicitud.FechaTermino = this.FechaTermino;
                    solicitud.EsCotejada = true;
                    solicitud.EsAtendida = true;
                    solicitud.FechaSolicitud = DateTime.Now;
                    solicitud.FechaRevision = DateTime.Now;
                    solicitud.FechaAtencion = DateTime.Now;
                    solicitud.IdConvenioLaboralTrabajadorCategoriaAtendio = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                    solicitud.IdConvenioLaboralTrabajadorCategoriaRegistro = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
                    solicitud.IdConvenioLaboralTrabajadorCategoriaCotejo = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;





                    db.Entry(solicitud).State = EntityState.Added;
                    db.SaveChanges();



                    Convenios_SuplenciasControl suplenciacontrol = new Convenios_SuplenciasControl();

                    suplenciacontrol.IdConvenioLaboralTrabajadorCategoria = IDCLTC;
                    suplenciacontrol.IdConvenioLaboralTrabajadorCategoriaAnterior = (int)convendiolabtrabcat.IdConvenioLaboralTrabajadorCategoria;
                    suplenciacontrol.IdConvenioLaboralTrabajadorCategoriaCubierto = convendiolabtrabcat.IdConvenioLaboralTrabajadorCategoria;
                    suplenciacontrol.IdSuplenciaSolicitud = solicitud.IdSuplenciaSolicitud;



                    db.Entry(suplenciacontrol).State = EntityState.Added;
                    db.SaveChanges();
                }
                catch (Exception ex)
                {

                    rs.Messsage = ex.Message;
                }

                scope.Complete();
            }
            rs.IsValid = true;
            return rs;
        }
    }
    public partial class Convenios_stConvenioLaboralTrabajadorCategoria : ValidacionModelos
    {

        public DateTime FechaInicioE;

        public override ResultadoValidacion ValidaModelo(int idt)
        {
            //parenresult = EsConvenioValido(idt);
            Convenios_stConvenioLaboralTrabajador UltimoConvenio = new Models.Convenios_stConvenioLaboralTrabajador();
            bdNovaEntities db = new bdNovaEntities();
            List<Convenios_stConvenioLaboralTrabajador> ConveniosTrabajador = db.Convenios_stConvenioLaboralTrabajador.Where(s => s.IdTrabajador == idt).OrderByDescending(s => s.IdConvenioLaboralTrabajador).ToList();
            if (ConveniosTrabajador.Count() == 0)
            {
                parenresult.Mensaje = "El trabajador no tiene un Convenio Laboral";
                parenresult.IsValid = false;
                return parenresult;
            }
            UltimoConvenio = ConveniosTrabajador.FirstOrDefault();

            if (UltimoConvenio.FechaTermino != null)
            {
                parenresult.Mensaje = "El convenio laboral del trabajador tiene fecha de término, no procede el cambio de plaza";
                parenresult.IsValid = false;
            }
            else
            {
                //Session["idclt"] = UltimoConvenio.ToString();
                parenresult.Mensaje = UltimoConvenio.IdConvenioLaboralTrabajador.ToString();
                parenresult.IsValid = true;
            }

            if (FechaInicioPago != null)
                if (FechaInicioPago < FechaInicio)
                {
                    parenresult.Mensaje = "La fecha de pago no puede ser menor a la de inicio del contrato";
                    parenresult.IsValid = false;
                }
            //return parenresult;

            return parenresult;
        }


        public Boolean EstaFechaInicioPlazaEnNominaCerrada2(DateTime fechainicio, int idrcl)
        {
            bdNovaEntities db = new bdNovaEntities();
            Boolean resultado = false;
            //int idrcl = Convert.ToInt32(Session["IdRelacionConvenioLaboral"]);
            var Nominas = from a in db.Nomina_ctPlantillaNomina
                          join b in db.Nomina_stNomina on a.IdPlantillaNomina equals b.IdPlantillaNomina
                          where b.EsCerrada == true && (b.FechaInicio <= fechainicio && b.FechaTermino >= fechainicio)
                          select new { b.IdPlantillaNomina };
            if (Nominas.Count() > 0)
            {
                resultado = true;
            }

            return resultado;
        }
        public Boolean EstaFechaInicioPlazaEnNominaAbierta2(DateTime fechainicio, int idrcl)
        {
            bdNovaEntities db = new bdNovaEntities();
            Boolean resultado = false;

            var Nominas = from a in db.Nomina_ctPlantillaNomina
                          join b in db.Nomina_stNomina on a.IdPlantillaNomina equals b.IdPlantillaNomina
                          where b.EsCerrada == false && (b.FechaInicio <= fechainicio && b.FechaTermino >= fechainicio)
                          select new { b.IdPlantillaNomina };
            if (Nominas.Count() > 0)
            {
                resultado = true;
            }

            return resultado;
        }
        public int ObtenerIdRCL2(int iddpc)
        {
            bdNovaEntities db = new bdNovaEntities();
            //int idrcl = Convert.ToInt32(Session["IdRelacionConvenioLaboral"]);
            var Vidrcl = from a in db.Plazas_stDistribucionPlazaCategoria
                         join b in db.Plazas_ctCategoria on a.IdCategoria equals b.IdCategoria
                         where a.IdDistribucionPlazaCategoria == iddpc
                         select new { b.IdRelacionConvenioLaboral };
            int idrcl = Vidrcl.First().IdRelacionConvenioLaboral;

            return idrcl;
        }

        // Obtener convenio laboral trabajador categoria
        //public int ObtenerIdCLTC(int idclt)
        //{
        //    bdNovaEntities db = new bdNovaEntities();
        //    var Vidrcltc = from a in db.Convenios_stConvenioLaboralTrabajadorCategoria
        //                   join b in db.Convenios_stConvenioLaboralTrabajador on a.IdConvenioLaboralTrabajador equals b.IdConvenioLaboralTrabajador
        //                   where a.IdConvenioLaboralTrabajador == idclt
        //                   select new { a.IdConvenioLaboralTrabajadorCategoria };
        //    int idrcltc = Vidrcltc.First().IdConvenioLaboralTrabajadorCategoria;

        //    return idrcltc;
        //}



        public String ObtenFechaInicioConvenio(int idtrabajador)
        {

            bdNovaEntities db = new bdNovaEntities();

            int x;
            x = db.Convenios_stConvenioLaboralTrabajador.Where(cl => cl.IdTrabajador == idtrabajador).Count();

            if (x > 0)
            {

                FechaInicioE = db.Convenios_stConvenioLaboralTrabajador.Max(c => c.FechaInicio);

                return db.Convenios_stConvenioLaboralTrabajador.Max(c => c.FechaInicio).ToShortDateString();
            }
            else
            {
                return null;
            }

        }

        public String ObtenFechaTerminoConvenio(int idtrabajador)
        {
            bdNovaEntities db = new bdNovaEntities();
            int y;
            y = db.Convenios_stConvenioLaboralTrabajador.Where(cl2 => cl2.IdTrabajador == idtrabajador).Count();

            if (y > 0)
            {
                //var FechaTermino = (from a in db.Convenios_stConvenioLaboralTrabajador
                //                    where a.IdTrabajador == idtrabajador
                //                    select new { FechaTermino = a.FechaTermino }).SingleOrDefault().FechaTermino;


                // return Convert.ToString(FechaTermino);

                return db.Convenios_stConvenioLaboralTrabajador.Where(j => j.FechaInicio == FechaInicioE).Max(c => c.FechaTermino).ToString();

            }
            else
            {
                return null;
            }
        }

        private static long[] getConsultaLincencias(string condicion)
        {
            bdNovaEntities db = new bdNovaEntities();
            SelectListItem x = new SelectListItem();

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string datos = @" select * from vwLicenciasTrabajadores q inner join 
            Catalogos_ctTipoIncidenciaPermiso w on q.IdTipoIncidenciaPermiso = w.IdTipoIncidenciaPermiso
            WHERE
            w.TipoIncidenciaPermiso <> 'PERMISO CON GOCE DE SUELDO' and
              ESTATUS ='ACTIVA'  " + condicion +
                                           @"  and (incidencia='LICENCIA SIN GOCE DE SUELDO PARA ATENDER SITUACIONES PERSONALES'
              or incidencia='LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE ELECCIÓN POPULAR'
               or incidencia='LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE CONFIANZA'
              or incidencia='LICENCIA SIN GOCE DE SUELDO POR ENFERMEDAD TEMPORAL DEFINITIVA'
                               )

                                 and Idkardex not in
	                            ( 
	                            select z.idkardex from vwLicenciasTrabajadores z 
			                            inner join
			                            Nomina_SuplenciasSolicitudes k on k.IdIncidenciaTrabajador=z.IdIncidenciaTrabajador
			                            
					                            
					                            where z.ESTATUS='ACTIVA' and k.EsAtendida=0
	                            )      
                                  ";



            var incidencias = dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(datos).Select(s => s.IdIncidenciaTrabajador).ToArray();

            dp.Close();
            return incidencias;
        }


        private static long[] getLicenciasBase(string condicion, int idts,string tipo)
        {
            bdNovaEntities db = new bdNovaEntities();

            DapperQuery dp = new DapperQuery("bdNovaEntities");
            string datos = "";
            if (tipo.Contains("INCAPACIDAD"))
            {
                condicion = condicion.Replace("and", " ");
                datos = @"  select * from vwLicenciasTrabajadores  
                              where   
                             " + condicion +
                                     @"  and incidencia='" + tipo + @"'
                                 and Idkardex not in
	                            ( 
	                            select z.idkardex from vwLicenciasTrabajadores z 
			                            inner join
			                            Nomina_SuplenciasSolicitudes k on k.IdIncidenciaTrabajador=z.IdIncidenciaTrabajador
					                            where k.FechaTermino>GETDATE() and k.IdKardexSuplente<>k.IdKardexSuplido
	                            )      
                                  ";
            }
            else
            if (idts == 11)
            {
                datos = @"  select * from vwLicenciasTrabajadores  
                              where ESTATUS in('ACTIVA','PROXIMA') 
                             " + condicion +
                                @"  and incidencia='" + tipo + @"'
                                 and Idkardex  in
	                            ( 
	                            select z.idkardex from vwLicenciasTrabajadores z 
			                            inner join
			                            Nomina_SuplenciasSolicitudes k on k.IdIncidenciaTrabajador=z.IdIncidenciaTrabajador
			                            
					                            
					                            where z.ESTATUS in('ACTIVA','PROXIMA') and k.EsAtendida=1
	                            )      
                                  ";
            }
            else
            {
                 
                    datos = @"  select * from vwLicenciasTrabajadores  
                              where  ESTATUS in ('ACTIVA','PROXIMA')  
                             " + condicion +
                                    @"  and incidencia='" + tipo + @"'
                                 and Idkardex not in
	                            ( 
	                            select z.idkardex from vwLicenciasTrabajadores z 
			                            inner join
			                            Nomina_SuplenciasSolicitudes k on k.IdIncidenciaTrabajador=z.IdIncidenciaTrabajador
					                            where k.FechaTermino>GETDATE() and 
					                            z.ESTATUS='ACTIVA' and ((k.IdKardexSuplido<>k.IdKardexSuplente and k.EsAtendida=1) or 
					                            (k.IdKardexSuplido=k.IdKardexSuplente and k.EsAtendida=0))
	                            )      
                                  ";
                

            }

            var incidencias = dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(datos).Select(s => s.IdIncidenciaTrabajador).ToArray();

            dp.Close();
            return incidencias;
        }
        private static long[] getCambioDeNomina(string condicion)
        {
            bdNovaEntities db = new bdNovaEntities();

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string datos = @"  select * from vwLicenciasTrabajadores  
                              where incidencia='LICENCIA SIN GOCE DE SUELDO POR CAMBIO DE NOMINA' 
                        and ESTATUS='ACTIVA' 
                             " + condicion +
                             @"  and 
                             IdTipoIncidenciaPermiso in (select  IdTipoIncidenciaPermiso 
                            from Catalogos_ctTipoIncidenciaPermiso
                            where TipoIncidenciaPermiso in ('PERMISO'))
                                 and Idkardex not in
	                            ( 
	                            select z.idkardex from vwLicenciasTrabajadores z 
			                            inner join
			                            Nomina_SuplenciasSolicitudes k on k.IdIncidenciaTrabajador=z.IdIncidenciaTrabajador
			                            
					                            
					                            where z.ESTATUS='ACTIVA' and k.EsAtendida=0
	                            )      
                                  ";

            var incidencias = dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(datos).Select(s => s.IdIncidenciaTrabajador).ToArray();

            dp.Close();
            return incidencias;
        }
        private static long[] getConsultaSuplenteEscalafon(string condicion)
        {
            bdNovaEntities db = new bdNovaEntities();

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string datos = @"  select * from vwLicenciasTrabajadores  
                              where ESTATUS in ('ACTIVA','PROXIMA')
                             " + condicion +
                             @"  and 
                             IdTipoIncidenciaPermiso in (select  IdTipoIncidenciaPermiso 
                            from Catalogos_ctTipoIncidenciaPermiso
                            where (incidencia='ESCALAFON PROVISIONAL' or incidencia='COMISIÓN PARA OCUPAR PLAZA VACANTE'
                    or TipoIncidenciaPermiso in ('INCAPACIDAD')) )

                                 and Idkardex not in
	                            ( 
	                            select z.idkardex from vwLicenciasTrabajadores z 
			                            inner join
			                            Nomina_SuplenciasSolicitudes k on k.IdIncidenciaTrabajador=z.IdIncidenciaTrabajador
			                            
					                            
					                            where z.ESTATUS='ACTIVA' and k.EsAtendida=0
	                            )      
                                  ";

            var incidencias = dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(datos).Select(s => s.IdIncidenciaTrabajador).ToArray();

            dp.Close();
            return incidencias;
        }

        private static long[] getLicenciaPorReposiciiondeVacaciones(string condicion)
        {
            bdNovaEntities db = new bdNovaEntities();

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string datos = @"  select * from vwLicenciasTrabajadores  
                              where ESTATUS in ('ACTIVA','PROXIMA')
                             " + condicion +
                             @"  and 
                             IdTipoIncidenciaPermiso in (select  IdTipoIncidenciaPermiso 
                            from Catalogos_ctTipoIncidenciaPermiso
                            where incidencia='LICENCIA CON GOCE DE SUELDO POR REPOSICIÓN DE VACACIONES') 

                                 and Idkardex not in
	                            ( 
	                            select z.idkardex from vwLicenciasTrabajadores z 
			                            inner join
			                            Nomina_SuplenciasSolicitudes k on k.IdIncidenciaTrabajador=z.IdIncidenciaTrabajador
			                            
					                            
					                            where z.ESTATUS='ACTIVA' and k.EsAtendida=0
	                            )      
                                  ";

            var incidencias = dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(datos).Select(s => s.IdIncidenciaTrabajador).ToArray();

            dp.Close();
            return incidencias;
        }
        private static long[] getConsultaSuplenteEscalafonIngreso(string condicion)
        {
            bdNovaEntities db = new bdNovaEntities();

            DapperQuery dp = new DapperQuery("bdNovaEntities");

            string datos = @"  select * from vwLicenciasTrabajadores  
                              where ESTATUS in ('ACTIVA','PROXIMA')
                             " + condicion +
                             @"  and 
                             IdTipoIncidenciaPermiso in (select  IdTipoIncidenciaPermiso 
                            from Catalogos_ctTipoIncidenciaPermiso
                            where (incidencia='ESCALAFON PROVISIONAL' or incidencia='COMISIÓN PARA OCUPAR PLAZA VACANTE'
                    or TipoIncidenciaPermiso in ('INCAPACIDAD') or  TipoIncidenciaPermiso in ('PERMISO')) )

                                 and Idkardex not in
	                            ( 
	                            select z.idkardex from vwLicenciasTrabajadores z 
			                            inner join
			                            Nomina_SuplenciasSolicitudes k on k.IdIncidenciaTrabajador=z.IdIncidenciaTrabajador
			                            
					                            
					                            where z.ESTATUS='ACTIVA' and k.EsAtendida=0
	                            )      
                                  ";

            var incidencias = dp.connection.Query<IncidenciaPermiso_stIncidenciaTrabajador>(datos).Select(s => s.IdIncidenciaTrabajador).ToArray();

            dp.Close();
            return incidencias;
        }
        public static IncidenciaPermiso_stIncidenciaTrabajador getLicenciaTrabajador(int idt)
        {
            bdNovaEntities db = new bdNovaEntities();
            string condicion = "";



            condicion = " and IdTrabajador=" + idt;

            var incidencias = getConsultaLincencias(condicion);

            var model = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(f => incidencias.Contains(f.IdIncidenciaTrabajador)).FirstOrDefault();


            return model;
        }
        public static List<IncidenciaPermiso_stIncidenciaTrabajador> getLicencias(string ConvenioLaboral = null)
        {
            bdNovaEntities db = new bdNovaEntities();
            string condicion = "";

            if (ConvenioLaboral != null)
            {
                condicion = " and ConvenioLaboral in ('" + ConvenioLaboral + "')";
            }
            var incidencias = getConsultaLincencias(condicion);

            var model = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(f => incidencias.Contains(f.IdIncidenciaTrabajador)).ToList();


            return model;
        }

        public static List<IncidenciaPermiso_stIncidenciaTrabajador> getBajasActivas()
        {
            bdNovaEntities db = new bdNovaEntities();

            var altas = db.vwDatosAspirantesTrabajadores.Where(x => x.EstatusTrabajador == "ALTA").Select(c => c.IdTrabajador).ToList();

            //var model = db.Kardex_stEstatusTrabajador.Where(f => (f.Catalogos_ctEstatusTrabajador.EstatusTrabajador== "BAJA POR DEFUNCIÓN" 
            //|| f.Catalogos_ctEstatusTrabajador.EstatusTrabajador =="BAJA POR RENUNCIA" || f.Catalogos_ctEstatusTrabajador.EstatusTrabajador == "BAJA POR ABANDONO DE EMPLEO" ) 
            //&& f.Convenios_stConvenioLaboralTrabajadorCategoria.Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.ConvenioLaboral=="BASE"
            //&& !altas.Contains(f.IdConvenioLaboralTrabajadorCategoria)
            //).ToList();


            string condicion = "";


            var solicitudes = db.Nomina_SuplenciasSolicitudes.Select(c => c.IdIncidenciaTrabajador).ToArray();

            var model = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(f => f.Catalogos_ctTipoIncidencia.Catalogos_ctTipoIncidenciaPermiso.TipoIncidenciaPermiso == "BAJAS"
            &&
            !solicitudes.Contains(f.IdIncidenciaTrabajador)
            && !altas.Contains(f.Convenios_stConvenioLaboralTrabajadorCategoria.Convenios_stConvenioLaboralTrabajador.IdTrabajador)
            ).ToList();


            return model;


          
        }

        public static List<IncidenciaPermiso_stIncidenciaTrabajador> getLicenciasDocentes()
        {
            bdNovaEntities db = new bdNovaEntities();
            string condicion = "";


            condicion = " and ConvenioLaboral in ('BASE','CONTRATO','CONFIANZA')";

            var incidencias = getConsultaLincencias(condicion);

            var model = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(f => incidencias.Contains(f.IdIncidenciaTrabajador)).ToList();


            return model;
        }
        public static List<IncidenciaPermiso_stIncidenciaTrabajador> getSuplenteEscalafon(int idts)
        {
            bdNovaEntities db = new bdNovaEntities();
            string incidencia = "";
            if (idts == 18 || idts==20)
                incidencia = "ESCALAFON PROVISIONAL";
            else
            incidencia = db.Nomina_SuplenciaTipo.Where(z => z.IdTipoSuplencia == idts).FirstOrDefault().TipoSuplencia;

            string condicion = "";

            List<IncidenciaPermiso_stIncidenciaTrabajador> model = new List<IncidenciaPermiso_stIncidenciaTrabajador>();

            condicion = " and ConvenioLaboral in ('BASE','CONTRATO','CONFIANZA') ";

            switch (idts)
            {
                //case 1:
                //    model = db.vwDatosAspirantesTrabajadores.ToList();
                //    break;
                
                case 5:
                   
            var incidenciasbajas = getBajasActivas();
                    var inci = incidenciasbajas.Select(q => q.IdIncidenciaTrabajador).ToArray();

            model = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(f => inci.Contains(f.IdIncidenciaTrabajador)).ToList();

            break;
                case 18:
                    condicion = " and ConvenioLaboral in ('BASE') ";
                    var incidencias1 = getConsultaSuplenteEscalafonIngreso(condicion);

                    model = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(f => incidencias1.Contains(f.IdIncidenciaTrabajador)).ToList();

                    break;
                case 20:
                    condicion = " and ConvenioLaboral in ('BASE') ";
                    var incidencias20 = getLicenciaPorReposiciiondeVacaciones(condicion);

                    model = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(f => incidencias20.Contains(f.IdIncidenciaTrabajador)).ToList();

                    break;
                case 8:
                    condicion = " and ConvenioLaboral in ('BASE','CONFIANZA') ";
                    //var incidencias = getConsultaSuplenteEscalafon(condicion);
                    //CAMBIO EL 05 ABRIL 2022
                    var incidencias = getConsultaSuplenteEscalafonIngreso(condicion);

                    model = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(f => incidencias.Contains(f.IdIncidenciaTrabajador)).ToList();

                    break;
                case 7:
                    condicion = " and ConvenioLaboral in ('BASE') ";
                    var incidencias2 = getCambioDeNomina(condicion);

                    model = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(f => incidencias2.Contains(f.IdIncidenciaTrabajador)).ToList();

                    break;
                case 1:
                case 10:
                case 11:
                    condicion = " and ConvenioLaboral in ('BASE') ";
                    var incidencias3 = getLicenciasBase(condicion,idts, incidencia);

                    model = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(f => incidencias3.Contains(f.IdIncidenciaTrabajador)).ToList();

                    break;
                case 12:
                case 13:
                case 14:
                case 15:
                case 16:
                    var incidencias5 = getLicenciasBase(condicion, idts, incidencia);

                    model = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(f => incidencias5.Contains(f.IdIncidenciaTrabajador)).ToList();

                    break;
                case 17:
                    condicion = " and ConvenioLaboral in ('BASE') ";
                    var incidencias4 = getLicenciasBase(condicion, idts, incidencia);

                    model = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(f => incidencias4.Contains(f.IdIncidenciaTrabajador)).ToList();

                    break;
                    
            }

            return model;
        }

        public static List<vwDatosAspirantesTrabajadores> getDocentesPosiblesSuplentes(int idts, string relcon, string tipo)
        {
            bdNovaEntities db = new bdNovaEntities();
            string[] condicion = new string[2];
            List<vwDatosAspirantesTrabajadores> model = new List<vwDatosAspirantesTrabajadores>();
            switch (idts)
            {
                //case 1:
                //    model = db.vwDatosAspirantesTrabajadores.ToList();
                //    break;
                case 21:
                    condicion[1] = "BASE";

                    model = db.vwDatosAspirantesTrabajadores.Where(f =>
                     f.EstatusTrabajador == "BAJA" 
                   && condicion.Contains(f.ConvenioLaboral)).ToList();
                    break;
                case 1:
                case 2:
                    condicion[1] = "CONTRATO";
                    model = db.vwDatosAspirantesTrabajadores.ToList();
                    break;
                case 5:
                    condicion[1] = "BASE";
                    model = db.vwDatosAspirantesTrabajadores.Where(f =>
                   (f.EstatusTrabajador == "ASPIRANTE" || f.EstatusTrabajador == "ALTA") &&
                   (condicion.Contains(f.ConvenioLaboral) || f.ConvenioLaboral == null)).ToList();
                    break;
                case 7:
                    condicion[1] = "BASE";
                    var licencias = db.vwLicenciasTrabajadores.Where
                         (a => (a.ESTATUS.Contains("ACTIVA") || a.ESTATUS.Contains("PROXIMA"))
                              && a.ConvenioLaboral.Contains("BASE") && a.Incidencia == "LICENCIA SIN GOCE DE SUELDO POR CAMBIO DE NOMINA").Select(q => q.IdTrabajador).ToArray();
                    model = db.vwDatosAspirantesTrabajadores.Where(f =>
                     f.EstatusTrabajador == "ALTA"  && licencias.Contains((int)f.IdTrabajador)
                   && condicion.Contains(f.ConvenioLaboral) ).ToList();
                    break;
             
                //case 7:
                
               
                case 14:
                        if (relcon.Contains("BASE"))
                        {
                            condicion[1] = "BASE";
                            condicion[0] = "CONTRATO";
                            model = db.vwDatosAspirantesTrabajadores.Where(f => f.EstatusTrabajador == "ASPIRANTE"
                            ||
        (condicion.Contains(f.RelacionConvenioLaboral)   || f.ConvenioLaboral != null || f.EstatusTrabajador == "BAJA")).ToList();
                        }
                        else
                            if (relcon.Contains("CONFIANZA"))
                        {
                            condicion[1] = "CONFIANZA";
                            condicion[0] = "";
                            model = db.vwDatosAspirantesTrabajadores.Where(f =>
    (condicion.Contains(f.RelacionConvenioLaboral) || f.ConvenioLaboral != null || f.EstatusTrabajador == "BAJA")).ToList();
                        }
                    break;
                case 6:
                case 10:
                case 12:
                case 13:
                case 15:
                case 16:
                    if (idts > 12)
                    { 
                    if  (relcon.Contains("BASE"))
                        {
                        condicion[1] = "BASE";
                        condicion[0] = "CONTRATO";
                        model = db.vwDatosAspirantesTrabajadores.Where(f =>
    (condicion.Contains(f.RelacionConvenioLaboral) ||  f.ConvenioLaboral != null || (f.EstatusTrabajador == "BAJA" || f.EstatusTrabajador == "ASPIRANTE"))).ToList();
                        }
                    else
                        if (relcon.Contains("CONFIANZA"))
                        {
                            condicion[1] = "CONFIANZA";
                            condicion[0] = "";
                            model = db.vwDatosAspirantesTrabajadores.Where(f =>
    (condicion.Contains(f.RelacionConvenioLaboral) || f.ConvenioLaboral != null || f.EstatusTrabajador == "BAJA")).ToList();
                        }
                    else
                            if (relcon.Contains("ADMINISTRATIVO-CONTRATO"))
                        {
                            
                            model = db.vwDatosAspirantesTrabajadores.Where(f =>
    f.EstatusTrabajador == "BAJA" || f.EstatusTrabajador == "ASPIRANTE").ToList();
                        }
                    }

                        else
                            model = db.vwDatosAspirantesTrabajadores.Where(f =>
(f.ConvenioLaboral != null)).ToList();
                    break;
                case 8:
                    if (tipo == "LICENCIA SIN GOCE DE SUELDO PARA OCUPAR PUESTO DE CONFIANZA")
                    {
                        condicion[1] = "ADMINISTRATIVO-BASE";
                        model = db.vwDatosAspirantesTrabajadores.Where(f =>
        (f.EstatusTrabajador == "ALTA" && f.ConvenioLaboral == "BASE" && f.RestringirMenu == null) &&
        (condicion.Contains(f.RelacionConvenioLaboral) || f.ConvenioLaboral == null)).ToList();
                    }
                    else
                    if (relcon.Contains("ADMINISTRATIVO"))
                    {
                        if (tipo.Contains("INCAPACIDAD"))
                        {
                            if (relcon.Contains("ADMINISTRATIVO"))
                            {
                                condicion[1] = "BASE";
                                model = db.vwDatosAspirantesTrabajadores.Where(f =>
                                ((f.RelacionLaboral == "ADMINISTRATIVO" && f.EstatusTrabajador == "ALTA") || (f.EstatusTrabajador == "BAJA" || f.EstatusTrabajador == "ASPIRANTE")) && f.ConvenioLaboral == "BASE" && f.RestringirMenu == null &&
                                (condicion.Contains(f.ConvenioLaboral) || f.ConvenioLaboral == null)).ToList();
                            }


                        }
                        else
                        {
                            condicion[1] = "ADMINISTRATIVO-BASE";
                            model = db.vwDatosAspirantesTrabajadores.Where(f =>
                            (f.EstatusTrabajador == "ALTA" && f.ConvenioLaboral == "BASE" && f.RestringirMenu == null) &&
                            (condicion.Contains(f.RelacionConvenioLaboral) || f.ConvenioLaboral == null)).ToList();
                        }
                    }
                    else {
                        condicion[1] = "DOCENTE-BASE";
                        model = db.vwDatosAspirantesTrabajadores.Where(f =>
                        (  f.ConvenioLaboral == "BASE" && f.RestringirMenu == null) &&
                        (condicion.Contains(f.RelacionConvenioLaboral) || f.ConvenioLaboral == null)).ToList();
                    }
                    break;
                case 17:
                    if (relcon.Contains("ADMINISTRATIVO"))
                        condicion[1] = "ADMINISTRATIVO-BASE";
                    else
                        if (relcon.Contains("DOCENTE"))
                        condicion[1] = "DOCENTE-BASE";
                    model = db.vwDatosAspirantesTrabajadores.Where(f =>
                        //f.EstatusTrabajador == "BAJA" || 
                            (f.EstatusTrabajador == "ALTA" && f.ConvenioLaboral == "BASE" && f.RestringirMenu == null) &&
                            (condicion.Contains(f.RelacionConvenioLaboral) || f.ConvenioLaboral == null)).ToList();
                    //agrega las licencias que haya de la otra relacion laboral para el caso de enroque
                    if (relcon.Contains("DOCENTE"))
                        condicion[1] = "ADMINISTRATIVO-BASE";
                    else
                       if (relcon.Contains("ADMINISTRATIVO"))
                        condicion[1] = "DOCENTE-BASE";
                    var model2 = db.vwDatosAspirantesTrabajadores.Where(f =>
                            //f.EstatusTrabajador == "BAJA" || 
                            (f.EstatusTrabajador == "ALTA" && f.ConvenioLaboral == "BASE" && f.Incidencia== "LICENCIA SIN GOCE DE SUELDO POR CAMBIO DE NOMINA") &&
                            (condicion.Contains(f.RelacionConvenioLaboral) || f.ConvenioLaboral == null)).ToList();
                    model.AddRange(model2);
                    break;
                case 18:
                    model = db.vwDatosAspirantesTrabajadores.Where(f => (f.EstatusTrabajador == "BAJA" || f.EstatusTrabajador == "ASPIRANTE")).ToList();
                    break;
                case 20:
                    model = db.vwDatosAspirantesTrabajadores.Where(f => (f.EstatusTrabajador == "BAJA" || f.EstatusTrabajador == "ASPIRANTE") || (f.EstatusTrabajador == "ALTA" && f.ConvenioLaboral == "CONTRATO") ).ToList();
                    break;

            }
            //            if (idts == 1)
            //            {


            //                model = db.vwDatosAspirantesTrabajadores.ToList();
            //            }
            //            else

            //            if (idts == 2)
            //            {
            //                condicion[1] = "CONTRATO";


            //                model = db.vwDatosAspirantesTrabajadores.Where(f =>
            //               (f.EstatusTrabajador == "ASPIRANTE" || f.EstatusTrabajador == "BAJA") &&
            //               (condicion.Contains(f.ConvenioLaboral) || f.ConvenioLaboral == null)).ToList();
            //            }
            //            else
            //            if (idts == 5)
            //            {
            //                condicion[1] = "BASE";


            //                model = db.vwDatosAspirantesTrabajadores.Where(f =>
            //               (f.EstatusTrabajador == "ASPIRANTE" || f.EstatusTrabajador == "ALTA") &&
            //               (condicion.Contains(f.ConvenioLaboral) || f.ConvenioLaboral == null)).ToList();
            //            }
            //            else
            //            if (idts == 6 || idts == 7 || idts == 8 || idts == 10 ||  idts == 11 || idts == 12)
            //            {
            //                condicion[1] = "BASE";
            //                model = db.vwDatosAspirantesTrabajadores.Where(f =>
            //(f.EstatusTrabajador == "ALTA" && f.ConvenioLaboral == "BASE" && f.RestringirMenu == null) &&
            //(condicion.Contains(f.ConvenioLaboral) || f.ConvenioLaboral == null)).ToList();

            //            }
            //            else
            //            {
            //                if (relcon.Contains("ADMINISTRATIVO"))
            //                {
            //                    condicion[1] = "BASE";
            //                    model = db.vwDatosAspirantesTrabajadores.Where(f =>
            //((f.RelacionLaboral == "ADMINISTRATIVO" && f.EstatusTrabajador=="ALTA") || (f.EstatusTrabajador=="BAJA" || f.EstatusTrabajador=="ASPIRANTE")) && f.ConvenioLaboral == "BASE" && f.RestringirMenu == null &&
            //(condicion.Contains(f.ConvenioLaboral) || f.ConvenioLaboral == null)).ToList();
            //                }
            //                else
            //                {

            //                    model = db.vwDatosAspirantesTrabajadores.Where(f => (f.EstatusTrabajador=="BAJA" || f.EstatusTrabajador=="ASPIRANTE")).ToList();
            //                }
            //            }



            return model;
        }


        //public   ResultadoValidacion EsConvenioValido(int idt)
        //{
        //    Convenios_stConvenioLaboralTrabajador UltimoConvenio = new Models.Convenios_stConvenioLaboralTrabajador();
        //    bdNovaEntities db = new bdNovaEntities();
        //    List<Convenios_stConvenioLaboralTrabajador> ConveniosTrabajador =  db.Convenios_stConvenioLaboralTrabajador.Where(s => s.IdTrabajador == idt).OrderByDescending(s => s.FechaInicio).ToList();
        //    if (ConveniosTrabajador.Count() == 0)
        //    {
        //        parenresult.Mensaje = "El trabajador no tiene un Convenio Laboral";
        //        parenresult.IsValid = false;
        //        return parenresult;
        //    }
        //    UltimoConvenio = ConveniosTrabajador.FirstOrDefault(); 

        //    if (UltimoConvenio.FechaTermino != null)
        //    {
        //        parenresult.Mensaje = "El convenio laboral del trabajador tiene fecha de término, no procede el cambio de plaza";
        //        parenresult.IsValid = false;
        //    }
        //    else
        //    {
        //        parenresult.Mensaje = UltimoConvenio.IdConvenioLaboralTrabajador.ToString();
        //        parenresult.IsValid = true;
        //    }
        //    return parenresult;
        //}
    }
    //public static class MyModel
    //{
    //    private static DataTable _MyDataTable;
    //    public static DataTable MyDataTable
    //    {
    //        get
    //        {
    //            if (_MyDataTable == null)
    //            {
    //                _MyDataTable = new DataTable();

    //                _MyDataTable.Columns.Add("ID", typeof(System.Int32));
    //                _MyDataTable.Columns.Add("Title", typeof(System.String));
    //                _MyDataTable.Columns.Add("ParentID", typeof(System.Int32));

    //                _MyDataTable.PrimaryKey = new DataColumn[] { _MyDataTable.Columns["ID"] };

    //                _MyDataTable.Rows.Add(1, "Nokia", 0);
    //                _MyDataTable.Rows.Add(2, "N8", 1);
    //                _MyDataTable.Rows.Add(3, "N91", 1);
    //                _MyDataTable.Rows.Add(4, "Samsung", 0);
    //                _MyDataTable.Rows.Add(5, "Corby9", 4);
    //                _MyDataTable.Rows.Add(6, "Star", 0);
    //            }

    //            return _MyDataTable;
    //        }
    //    }
    //}
}
