﻿using Nova.Libraries;
using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Transactions;

namespace Nova.Models
{



    class Reglamento5 : IReglamento
    {


        public void Evaluar(ReglamentoEvaluacion c)
        {

            if (c.Alumnos.Count > 0)
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {


                    foreach (var item in c.Alumnos)
                    {

                        c.ObtenerEvaluacionesReglamentoAlumnos(item.IdHorarioAlumno);

                        //determina qeu calificaciones solo deben de quedar en la bd
                        GenerarEliminaciones(c, item.IdHorarioAlumno);

                        // vuelve a actaulizar lod datos despues de las eliminaciones
                        c.ObtenerEvaluacionesReglamentoAlumnos(item.IdHorarioAlumno);

                        //actualiza las tablas para insertar o modificar la tira de calificaciones de todo el reglamento

                        GrabarCalificacionesMomentos(c, item.IdHorarioAlumno);




                        Acreditacion_stPeriodoCalificacion f = new Acreditacion_stPeriodoCalificacion();
                        AprobacionReprobacionEnOrdinario(c, ref f);

                        if (f.EsNp)
                        {
                            GrabaUnNP(c);

                        }
                        else
                        {
                            //si la aprobo graba la final
                            if (f.IdHorarioAlumno > 0)
                                c.PeriodosEvaluacionesAInsertar.Add(f);

                            if (f.EsReprobada == false && f.IdHorarioAlumno > 0)
                            {

                                AgregaCalificacionFinal(c, f);

                            }


                            else
                            {

                                Acreditacion_stPeriodoCalificacion r = new Acreditacion_stPeriodoCalificacion();
                                AprobacionReprobacionEnEE(c, ref r);

                                if (r.IdHorarioAlumno > 0)
                                {
                                    
                                    if (c.PeriodosEvaluacionesAInsertar.Where(w => w.IdHorarioAlumno==r.IdHorarioAlumno  && w.IdCursoPeriodoMomento == c.EvaluacionesDelAlumno.ElementAt(6).IdCursoPeriodoMomento).ToList().Count == 0)
                                        c.PeriodosEvaluacionesAInsertar.Add(r);
                                }

                                if (r.EsReprobada == false && r.IdHorarioAlumno > 0)
                                //si la aprobo graba la final
                                {
                                    AgregaCalificacionFinal(c, r);
                                }
                                else
                                {


                                    Acreditacion_stPeriodoCalificacion e = new Acreditacion_stPeriodoCalificacion();
                                    AprobacionReprobacionEnCI(c, ref e);

                                    if (e.IdHorarioAlumno > 0)
                                    {

                                        c.PeriodosEvaluacionesAInsertar.Add(e);

                                        //graba la final

                                        AgregaCalificacionFinal(c, e);
                                    }

                                }

                            }

                        }
                    }

                    GrabaListasDeCalificaciones(ref c);

                    ValidarSituacionAcademica(c);



                    //Verificar cambios de estatus por numero de materias reprobadas en el ciclo escolar

                    //grabar calificaciones faltantes en su carga cuadno es una baja




                    //Verificar cambios de estatus por numero de materias reprobadas en toda su carga

                    //
                    scope.Complete();
                }

            }

        }

        private void ObtenerCalificacionesFaltantes(ReglamentoEvaluacion c, stHorarioAlumno ha, short idcursoperiodomomento)
        {


            bdAriesEntities bd = new bdAriesEntities();

            //var inner2 = from tt in c.Alumnos where ha.Curp== tt.Curp && tt.Matricula==ha.Matricula select tt;
            HorariosAlumnos horarios = HorariosAlumnos.Instance;
            List<stHorarioAlumno> HorariosdelAlumno = horarios.getHorariosPorAlumno(ha.Curp, ha.stHorario.IdCicloEscolar);
            // var inner2 = HorariosdelAlumno;


            var finales = bd.Acreditacion_stAlumnosCalificacionFinal.Where(d => d.Curp == ha.Curp && d.Matricula == ha.Matricula && d.IdCicloEscolar == ha.stHorario.IdCicloEscolar).Select(r => r.IdPlanEstudioAsignatura).ToList();



            //      var fin = HorariosdelAlumno.GroupJoin(finales,
            //x => new { x.Curp, x.stHorario.IdPlanEstudioAsignatura, x.Matricula, x.stHorario.IdCicloEscolar, x.IdValorCiclo },
            //y => new { y.Curp, y.IdPlanEstudioAsignatura, y.Matricula, y.IdCicloEscolar, y.IdValorCiclo },
            //(x, y) => new
            //{
            //    x.stHorario.IdPlanEstudioAsignatura,
            //    x.stHorario.IdCicloEscolar,
            //    x.Curp,
            //    x.Matricula,
            //    x.IdValorCiclo,



            //}).ToList();

            var tools = HorariosdelAlumno.Where(t => !finales.Contains(t.stHorario.IdPlanEstudioAsignatura)).ToList();


            foreach (var item in tools)
            {

                Acreditacion_stAlumnosCalificacionFinal cf = new Acreditacion_stAlumnosCalificacionFinal();

                var existe = c.CalificacionesFinalesAInsertar.Where(d => d.Curp == item.Curp && d.Matricula == item.Matricula && d.IdPlanEstudioAsignatura == item.stHorario.IdPlanEstudioAsignatura && d.IdCicloEscolar == item.stHorario.IdCicloEscolar && d.IdValorCiclo == item.IdValorCiclo).Select(k => k.IdPlanEstudioAsignatura).FirstOrDefault();
                if (existe == 0)
                {
                    cf.IdCicloEscolar = item.stHorario.IdCicloEscolar;
                    cf.Calificacion = c.CalificacionNPoReprobatoria;
                    cf.Curp = item.Curp;
                    cf.Dictaminada = false;
                    cf.EsActualizacionPlanEstudio = false;
                    cf.EsNp = false;
                    cf.EsReprobada = true;
                    //cf.IdCampus = item.IdCampus;
                    cf.IdCicloEscolar = item.stHorario.IdCicloEscolar;
                    cf.rptCalificacion = c.CalificacionCadena(c.CalificacionNPoReprobatoria, TipoPromedio.Final);
                    cf.Renunciada = false;
                    cf.Matricula = item.Matricula;

                    cf.IdCampus = ha.stHorario.ctGrupoCampus.IdCampus;
                    cf.IdPlanEstudioAsignatura = item.stHorario.IdPlanEstudioAsignatura;
                    cf.IdGrupoNombre = ha.stHorario.ctGrupoCampus.IdGrupoNombre;
                    cf.IdCursoPeriodoMomento = idcursoperiodomomento;

                    cf.IdValorCiclo = ha.IdValorCiclo;

                    c.CalificacionesFinalesAInsertar.Add(cf);
                }

            }

            // AgregaCalificacionGrado(c, c.CalificacionNPoReprobatoria, true);

        }

        private void ValidarSituacionAcademica(ReglamentoEvaluacion c)
        {
            c.ObtenerCalificacionesTotalesPeriodosAlumnos();

            foreach (var item in c.Alumnos)
            {

                ValidarPeriodoOrdinario(c, item);
                ValidarPeriodoEE(c, item);
                ValidarPeriodoCI(c, item);



            }

            //GRaba en la base calificaciones finales
            // y actualiza estatus de alumnos y si son regulares o no
            GrabarBaseDatosValidacionAcedemica(c);
            //

            foreach (var item in c.Alumnos)
            {

                ValidarModulosFinales(c, item);

            }

            foreach (var item in c.Alumnos)
            {

                ValidarAsignaturasAprobadasReprobadasDelCurso(c, item);

            }

            GrabaListasDeCalificacionesGrado(ref c);

            ActualizarEstatusValidacionCalificacionesFinales(c);


        }

        private void ValidarModulosFinales(ReglamentoEvaluacion c, IdHorariosAlumnos item)
        {
            HorariosAlumnos horarios = HorariosAlumnos.Instance;
            List<stHorarioAlumno> HorariosdelAlumno = horarios.getHorariosPorAlumno(item.Curp, item.IdCicloEscolar);

            List<stHorarioAlumno> HorariosalumnoAsignaturasconPadre = HorariosdelAlumno.Where(f => f.Curp == item.Curp && f.Matricula == item.Matricula && f.stHorario.IdCicloEscolar == item.IdCicloEscolar && f.stHorario.stPlanEstudioAsignatura.ctAsignatura.IdAsignaturaPadre != null).ToList();

            List<stHorarioAlumno> ha = HorariosdelAlumno.Where(f => f.Curp == item.Curp && f.Matricula == item.Matricula && f.stHorario.IdCicloEscolar == item.IdCicloEscolar && f.stHorario.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre == "PROFESIONAL").ToList();

            var asignaturaspadres = HorariosdelAlumno.Where(f => f.stHorario.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre == "PROFESIONAL").GroupBy(w => w.stHorario.stPlanEstudioAsignatura.ctAsignatura.IdAsignaturaPadre).Select(q => q.Key.Value).ToArray();

            var asignaturas = ha.Select(w => w.stHorario.IdPlanEstudioAsignatura).ToArray();

            bdAriesEntities bd = new bdAriesEntities();


            if (ha.Count > 0 && asignaturaspadres != null)
            {
                if (asignaturaspadres.Count() > 0)
                {
                    List<Acreditacion_stAlumnosCalificacionFinal> finales = bd.Acreditacion_stAlumnosCalificacionFinal.Where(d => asignaturas.Contains(d.IdPlanEstudioAsignatura) && d.Curp == item.Curp && d.Matricula == item.Matricula && d.IdCicloEscolar == item.IdCicloEscolar && d.Renunciada == false && d.Dictaminada == false).ToList();

                    if (finales.Count == ha.Count)
                    {
                        foreach (var fila in asignaturaspadres)
                        {


                            bool EsReprobada = false;
                            bool EsNp = false;
                            double calificaciones = 0;


                            Acreditacion_stAlumnosCalificacionFinalModulos modulo = new Acreditacion_stAlumnosCalificacionFinalModulos();

                            int total = 0;
                            double totalHoras = 0;
                            short idcursoperiodomomento = 0;


                            //totalHoras = (double)finales.Where(w => w.stPlanEstudioAsignatura.ctAsignatura.IdAsignaturaPadre == fila).Sum(w => (w.stPlanEstudioAsignatura.ctAsignatura.HorasSemana * 16));

                            var asignatura = finales.Where(w => w.stPlanEstudioAsignatura.ctAsignatura.IdAsignaturaPadre == fila).FirstOrDefault().stPlanEstudioAsignatura.ctAsignatura.Nombre;
                            totalHoras = (double)finales.Where(w => w.stPlanEstudioAsignatura.ctAsignatura.IdAsignaturaPadre == fila).Sum(w => (w.stPlanEstudioAsignatura.ctAsignatura.HorasSemana * 16));
                            if (totalHoras == 0) { throw new Exception(string.Format("Las asignatura {0} no cuenta con horas a la semana", asignatura)); }


                            foreach (var ele in finales.Where(w => w.stPlanEstudioAsignatura.ctAsignatura.IdAsignaturaPadre == fila).OrderBy(w => w.IdCursoPeriodoMomento).ToList())
                            {



                                double califsubmodulo = (double)ele.Calificacion;
                                idcursoperiodomomento = (short)ele.IdCursoPeriodoMomento;
                                double horasmodulo = ((double)ele.stPlanEstudioAsignatura.ctAsignatura.HorasSemana * 16);

                                if (ele.EsNp)
                                    EsNp = true;

                                if (ele.EsReprobada == true)
                                    EsReprobada = true;
                                else
                                {

                                    calificaciones = calificaciones + Math.Round((Math.Round(horasmodulo / totalHoras, 3)) * califsubmodulo, 3);

                                }

                                total++;
                            }


                            var row = HorariosalumnoAsignaturasconPadre.Where(f => fila == f.stHorario.stPlanEstudioAsignatura.ctAsignatura.IdAsignaturaPadre).FirstOrDefault();

                            modulo.IdAsignaturaPadre = (short)row.stHorario.stPlanEstudioAsignatura.ctAsignatura.IdAsignaturaPadre;
                            modulo.IdPlanEstudio = (short)row.stHorario.stPlanEstudioAsignatura.IdPlanEstudio;
                            modulo.IdCicloEscolar = (short)row.stHorario.IdCicloEscolar;
                            modulo.IdValorCiclo = (short)row.IdValorCiclo;

                            modulo.IdCursoPeriodoMomento = idcursoperiodomomento;
                            modulo.Curp = row.Curp;
                            modulo.Matricula = row.Matricula;
                            modulo.Renunciada = false;
                            modulo.Dictaminada = false;
                            modulo.IdGrupoNombre = row.stHorario.ctGrupoCampus.IdGrupoNombre;
                            modulo.IdCampus = row.stHorario.ctGrupoCampus.IdCampus;
                            modulo.EsActualizacionPlanEstudio = false;
                            modulo.EsNp = EsNp;




                            if (EsReprobada)
                            {
                                modulo.EsReprobada = true;
                                modulo.Calificacion = c.CalificacionNPoReprobatoria;
                                modulo.rptCalificacion = c.CalificacionCadena(c.CalificacionNPoReprobatoria, TipoPromedio.Final);
                            }
                            else
                            {
                                modulo.EsReprobada = false;
                                decimal califgral = (decimal)calificaciones;
                                califgral = Math.Round(califgral);
                                modulo.Calificacion = califgral;
                                modulo.rptCalificacion = c.CalificacionCadena(califgral, TipoPromedio.Final);

                            }
                            // } row
                            bdAriesEntities context = new bdAriesEntities();

                            Acreditacion_stAlumnosCalificacionFinalModulos existemodulo = context.Acreditacion_stAlumnosCalificacionFinalModulos.Where(q => q.Curp == item.Curp && q.Matricula == item.Matricula && q.IdAsignaturaPadre == modulo.IdAsignaturaPadre
                                && q.IdCicloEscolar == modulo.IdCicloEscolar && q.IdValorCiclo == modulo.IdValorCiclo && q.IdPlanEstudio == modulo.IdPlanEstudio).FirstOrDefault();
                            context.Configuration.AutoDetectChangesEnabled = false;
                            context.Configuration.ValidateOnSaveEnabled = false;

                            if (existemodulo != null)
                            {
                                context.Entry(existemodulo).State = System.Data.Entity.EntityState.Deleted;
                                context.SaveChanges();
                            }

                            context.Entry(modulo).State = System.Data.Entity.EntityState.Added;

                            context.SaveChanges();

                            context.Configuration.AutoDetectChangesEnabled = true;
                            context.Configuration.ValidateOnSaveEnabled = true;





                        }//for padres
                    }//

                }

            }


        }

        private void ValidarAsignaturasAprobadasReprobadasDelCurso(ReglamentoEvaluacion c, IdHorariosAlumnos item)
        {
            HorariosAlumnos horarios = HorariosAlumnos.Instance;
            List<stHorarioAlumno> HorariosdelAlumno = horarios.getHorariosPorAlumno(item.Curp, item.IdCicloEscolar);

            stHorarioAlumno ha = HorariosdelAlumno.Where(f => f.IdHorarioAlumno == item.IdHorarioAlumno).First();

            bdAriesEntities bd = new bdAriesEntities();



            var finales = bd.Acreditacion_stAlumnosCalificacionFinal.Where(d => d.Curp == ha.Curp && d.Matricula == ha.Matricula && d.IdCicloEscolar == ha.stHorario.IdCicloEscolar && d.Renunciada == false && d.Dictaminada == false).ToList();

            List<stHorarioAlumno> submodulos = HorariosdelAlumno.Where(f => f.Curp == item.Curp && f.Matricula == item.Matricula && f.stHorario.IdCicloEscolar == item.IdCicloEscolar && f.stHorario.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre == "PROFESIONAL").ToList();

            var asignaturaspadres = HorariosdelAlumno.Where(f => f.stHorario.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre == "PROFESIONAL").GroupBy(w => w.stHorario.stPlanEstudioAsignatura.ctAsignatura.IdAsignaturaPadre).Select(q => q.Key.Value).ToArray();

            List<Acreditacion_stAlumnosCalificacionFinalModulos> finalesModulos = new List<Acreditacion_stAlumnosCalificacionFinalModulos>();
            if (asignaturaspadres != null)
                finalesModulos = bd.Acreditacion_stAlumnosCalificacionFinalModulos.Where(d => asignaturaspadres.Contains(d.IdAsignaturaPadre) && d.Curp == ha.Curp && d.Matricula == ha.Matricula && d.IdCicloEscolar == ha.stHorario.IdCicloEscolar && d.Renunciada == false && d.Dictaminada == false).ToList();

            int totalreprobadas = 0;
            int totalNPS = 0;
            int totalreprobadasrecursadas = 0;
            List<Acreditacion_stAlumnosCalificacionFinal> reprobadasestancia = new List<Acreditacion_stAlumnosCalificacionFinal>();
            List<stPlanEstudioAsignatura> totalAsignaturasPlan = new List<stPlanEstudioAsignatura>();
            List<Acreditacion_stAlumnosCalificacionFinal> totalFinalesEstancia = new List<Acreditacion_stAlumnosCalificacionFinal>();
            decimal calificaciongral = 0;
            int totalAsignaturas = 0;
            if (HorariosdelAlumno.Count == finales.Count)
            //ha terminado el curso con todas sus asignaturas
            {

                totalAsignaturasPlan = horarios.stPlanEstudioAsignatura.Where(v => v.IdPlanEstudio == finales.ElementAt(0).stPlanEstudioAsignatura.IdPlanEstudio).ToList();
                totalFinalesEstancia = bd.Acreditacion_stAlumnosCalificacionFinal.Where(d => d.Curp == ha.Curp && d.Matricula == ha.Matricula && d.EsReprobada == false && d.Renunciada == false && d.Dictaminada == false).ToList();

                reprobadasestancia = totalFinalesEstancia.Where(f => f.EsReprobada == true).ToList();

                foreach (var ele in finales)
                {


                    if (ele.EsReprobada)
                    {
                        if (ele.EsNp)
                        {
                            totalNPS = totalNPS + 1;
                        }
                        else
                        {
                            if (ele.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre != "PROFESIONAL")
                                calificaciongral = calificaciongral + ele.Calificacion;

                            totalreprobadas = totalreprobadas + 1;
                        }

                        bool esrecursada = HorariosdelAlumno.Where(t => t.stHorario.IdPlanEstudioAsignatura == ele.IdPlanEstudioAsignatura && t.stHorario.IdCicloEscolar == ele.IdCicloEscolar).Select(g => g.Recursada).SingleOrDefault();

                        if (esrecursada)
                        {
                            totalreprobadasrecursadas = totalreprobadasrecursadas + 1;
                        }
                        if (ele.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre != "PROFESIONAL")
                        {
                            totalAsignaturas++;
                         
                        }
                    }
                    else
                    {
                        if (ele.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre != "PROFESIONAL")
                        {
                            totalAsignaturas++;
                            calificaciongral = calificaciongral + ele.Calificacion;
                        }
                    }


                }


                foreach (var ele in finalesModulos)
                {

                    totalAsignaturas++;
                    if (ele.EsReprobada)
                    {
                        if (ele.EsNp)
                        {
                            totalNPS = totalNPS + 1;
                        }
                        else
                            calificaciongral = calificaciongral + ele.Calificacion;



                    }
                    else
                        calificaciongral = calificaciongral + ele.Calificacion;


                }


                if (calificaciongral > 0)
                {
                    // string estatus= bd.ctAlumnos.Where(f => f.Curp == item.Curp).Select(r => r.ctStatusAlumno.Nombre).FirstOrDefault();

                    if (totalreprobadas <= c.MaximoReprobadasPorCiclo )
                    {
                        if ((calificaciongral / (totalAsignaturas - totalNPS)) > c.CalificacionNPoReprobatoria)
                        {
                            decimal dd = FormatearPromedio((calificaciongral / (totalAsignaturas - totalNPS)), TipoPromedio.Grado);
                            AgregaCalificacionGrado(c, item, dd, false);
                        }
                        else
                            AgregaCalificacionGrado(c, item, c.CalificacionNPoReprobatoria, true);
                    }
                    else
                        AgregaCalificacionGrado(c, item, c.CalificacionNPoReprobatoria, true);

                }


            }


            ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                     .Select(e => new ctAlumnos
                     {

                         Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                         Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                         ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                         ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                         Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                         Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                         FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                         IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                         IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                         IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                         Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                         Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                         Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                         CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                         IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                         IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                         IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                         ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                         Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                         CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                         IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                         IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                         BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                         IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                         NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                         ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                         ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                         IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                         TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                         NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                         ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                         ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                         IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                         TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                         NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                         ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                         ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                         IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                         TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                         IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                         IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                         cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                         PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                         IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                         IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                         IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                         NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                         IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                         IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                         IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                         FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                         IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                         IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                         IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                         IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                         CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                         EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                         IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                         IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                         IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                         FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                         PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                         AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                         CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                         Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                         NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                         FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                         IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                         KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                         NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                         IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                         FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                         IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                         FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                         IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                         EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                         FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                         IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                         EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                         IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                         IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                         IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                         IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                         CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                         NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                         ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                         CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                         ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor

                     }).FirstOrDefault();


            if (HorariosdelAlumno.Count == finales.Count)
            {


                if (totalreprobadas > c.MaximoReprobadasPorCiclo)
                {


                    short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR LIMITE REPROBADAS POR CICLO").Select(f => f.IdStatusAlumno).First();

                    var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == alumno.Curp).SingleOrDefault();
                    if (exstatus == null)
                    {
                        c.AlumnosEstatusAActualizar.Add(alumno);
                        alumno.IdStatusAlumno = idstatusalumno;
                    }


                }
                else
                    if (totalreprobadasrecursadas > 10)
                    {


                        short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR RECURSAMIENTO").Select(f => f.IdStatusAlumno).First();

                        var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == alumno.Curp).SingleOrDefault();

                        if (exstatus == null)
                        {
                            alumno.IdStatusAlumno = idstatusalumno;
                            c.AlumnosEstatusAActualizar.Add(alumno);
                        }

                    }
                    else
                        if (reprobadasestancia.Count > c.MaximoReprobadasPorEstancia)
                        {


                            short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR LIMITE REPROBADAS POR CICLO").Select(f => f.IdStatusAlumno).First();

                            var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == alumno.Curp).SingleOrDefault();
                            if (exstatus == null)
                            {
                                c.AlumnosEstatusAActualizar.Add(alumno);
                                alumno.IdStatusAlumno = idstatusalumno;
                            }
                        }
                        else
                        {

                            if (totalFinalesEstancia.Count >= totalAsignaturasPlan.Count)
                            {
                                short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "EGRESADOS").Select(f => f.IdStatusAlumno).First();

                                var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == alumno.Curp).SingleOrDefault();
                                if (exstatus == null)
                                {
                                    alumno.IdStatusAlumno = idstatusalumno;
                                    c.AlumnosEstatusAActualizar.Add(alumno);
                                }


                            }
                            else
                            {
                                short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "PARA REINSCRIPCION").Select(f => f.IdStatusAlumno).First();
                                alumno.IdStatusAlumno = idstatusalumno;
                                var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == alumno.Curp).SingleOrDefault();
                                if (exstatus == null)
                                {
                                    alumno.IdStatusAlumno = idstatusalumno;
                                    c.AlumnosEstatusAActualizar.Add(alumno);
                                }

                                //if (calificaciongral > 0)
                                //    AgregaCalificacionGrado(c, (calificaciongral / HorariosdelAlumno.Count), false);

                            }

                        }


            }
            //else
            //{
            //    short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "PARA REINSCRIPCION").Select(f => f.IdStatusAlumno).First();

            //    var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == alumno.Curp).SingleOrDefault();
            //    if (exstatus == null)
            //    {
            //        c.AlumnosEstatusAActualizar.Add(alumno);
            //        alumno.IdStatusAlumno = idstatusalumno;
            //    }


            //}


            // var tools = HorariosdelAlumno.Where(t => !finales.Contains(t.stHorario.IdPlanEstudioAsignatura)).ToList();




        }
        //private  void ElminarCalificacacionesPeriodoFinalesGrado()
        // {
        //       info = c._stMomentoEvaluacionCalificacion.Where(f => (f.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre== evaluacion && f.Calificacion > -1 && f.IdMomentoEvaluacionCalificacion > -1)).Select(s => new Acreditacion_stMomentoEvaluacionCalificacion { stHorarioAlumno = s.stHorarioAlumno, IdMomentoEvaluacionCalificacion = (long)s.IdMomentoEvaluacionCalificacion, IdMomentoEvaluacion = (short)s.IdMomentoEvaluacion, Calificacion = (decimal)s.Calificacion, EsDefinitiva = (bool)s.EsDefinitiva, EsNp = (bool)s.EsNp, EsReprobada = (bool)s.EsReprobada, IdHorarioAlumno = (long)s.IdHorarioAlumno, EsReprobadaSinPago = (bool)s.EsReprobadaSinPago }).SingleOrDefault();
        //       if (info != null)
        //       {
        //           bdAriesEntities bd = new bdAriesEntities();
        //           long id = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
        //           var existe = bd.Acreditacion_stMomentoEvaluacionCalificacion.Where(w => w.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre == evaluacion && w.IdHorarioAlumno == id).FirstOrDefault();
        //       }


        // }

        private void ValidarPeriodoOrdinario(ReglamentoEvaluacion c, IdHorariosAlumnos item)
        {
            bdAriesEntities basedatos = new bdAriesEntities();
            HorariosAlumnos horarios = HorariosAlumnos.Instance;
            List<stHorarioAlumno> HorariosdelAlumno = horarios.getHorariosPorAlumno(item.Curp, item.IdCicloEscolar);

            var TotalesFinalesEnOrdinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctMomento.Nombre == "Parcial" && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();

            var TotalesP1 = basedatos.Acreditacion_stMomentoEvaluacionCalificacion.Where(s => s.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre == "P1" && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();
            var TotalesP2 = basedatos.Acreditacion_stMomentoEvaluacionCalificacion.Where(s => s.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre == "P2" && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();
            var TotalesP3 = basedatos.Acreditacion_stMomentoEvaluacionCalificacion.Where(s => s.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre == "P3" && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();


            var totalreprobadasordinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Ordinario" && s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctMomento.Nombre == "Recuperacion" && s.stHorarioAlumno.Curp == item.Curp && s.EsReprobada == true && s.EsNp == false && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();

            var totalNps = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Ordinario" && s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctMomento.Nombre == "Recuperacion" && s.stHorarioAlumno.Curp == item.Curp && s.EsReprobada == true && s.EsNp == true && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();


            var totalsubmoduloreprobadosordinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.stHorarioAlumno.stHorario.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre == "PROFESIONAL" && s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Ordinario" && s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctMomento.Nombre == "Recuperacion" && s.stHorarioAlumno.Curp == item.Curp && s.EsReprobada == true && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();

            //3 submodulos se va directo a curso Intersemestral
            //if (totalsubmoduloreprobadosordinario.Count == c.MaximoSubModulosReprobadasOrdinario)
            //{
            //    // List<Acreditacion_stMomentoEvaluacionCalificacion> submodulos = basedatos.Acreditacion_stMomentoEvaluacionCalificacion.Where(j => j.stHorarioAlumno.Curp == item.Curp && j.stHorarioAlumno.Matricula == item.Matricula && j.EsReprobada == true && j.stHorarioAlumno.stHorario.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre == "PROFESIONAL").ToList();

            //    foreach (var ism in totalsubmoduloreprobadosordinario)
            //    {


            //        Acreditacion_stMomentoEvaluacionCalificacion evaluacion = new Acreditacion_stMomentoEvaluacionCalificacion();
            //        evaluacion.IdHorarioAlumno = (long)ism.IdHorarioAlumno;
            //        evaluacion.IdMomentoEvaluacion = c._Acreditacion_stMomentoEvaluacion.Where(r => r.Acreditacion_ctEvaluacion.Nombre == "EE").FirstOrDefault().IdMomentoEvaluacion;

            //        var existeHorario = basedatos.Acreditacion_stMomentoEvaluacionCalificacion.Where(e => e.IdMomentoEvaluacion == evaluacion.IdMomentoEvaluacion && e.IdHorarioAlumno == evaluacion.IdHorarioAlumno).FirstOrDefault();

            //        if (existeHorario == null)
            //        {
            //            evaluacion.Calificacion = ism.Calificacion;
            //            evaluacion.rptCalificacion = FormatearPromedio(ism.Calificacion, TipoPromedio.Evaluacion, c._Acreditacion_stMomentoEvaluacion.Where(r => r.Acreditacion_ctEvaluacion.Nombre == "EE").FirstOrDefault().rptDecimales).ToString();

            //            evaluacion.EsNp = ism.EsNp;

            //            evaluacion.EsReprobada = ism.EsReprobada;

            //            basedatos.Entry(evaluacion).State = System.Data.Entity.EntityState.Added;
            //            basedatos.SaveChanges();

            //            Acreditacion_stPeriodoCalificacion periodo = new Acreditacion_stPeriodoCalificacion();
            //            periodo.IdHorarioAlumno = (long)ism.IdHorarioAlumno;
            //            periodo.IdCursoPeriodoMomento = c._Acreditacion_stMomentoEvaluacion.Where(r => r.Acreditacion_ctEvaluacion.Nombre == "EE").FirstOrDefault().IdCursoPeriodoMomento;
            //            periodo.Calificacion = ism.Calificacion;
            //            periodo.rptCalificacion = FormatearPromedio(ism.Calificacion, TipoPromedio.Periodo).ToString();

            //            periodo.EsNp = ism.EsNp;

            //            periodo.EsReprobada = ism.EsReprobada;

            //            basedatos.Entry(periodo).State = System.Data.Entity.EntityState.Added;
            //            basedatos.SaveChanges();
            //        }
            //    }



            //}

            //IRRGULARES
            if ((TotalesFinalesEnOrdinario.Count >= HorariosdelAlumno.Count) && totalreprobadasordinario.Count > 0)
            {
                //ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).Select(e => e.stHorarioAlumno.ctAlumnos).First();
                ctAlumnos alumno = HorariosdelAlumno[0].ctAlumnos;

                alumno.EsRegular = false;
                c.AlumnosIrregularesAActualizar.Add(alumno);
            }

            //VALIDACION DE REPROBADAS POR PERIODO ORDINARIO
            if (((TotalesP1.Count == HorariosdelAlumno.Count || TotalesP2.Count == HorariosdelAlumno.Count || TotalesP3.Count == HorariosdelAlumno.Count) &&
                (totalNps.Count > c.MaximoReprobadasOrdinario))
                || (totalreprobadasordinario.Count > c.MaximoReprobadasOrdinario + 1 && TotalesFinalesEnOrdinario.Count >= HorariosdelAlumno.Count)
                || (totalreprobadasordinario.Count + totalNps.Count > c.MaximoReprobadasOrdinario + 1 && TotalesFinalesEnOrdinario.Count >= HorariosdelAlumno.Count)
                || (totalsubmoduloreprobadosordinario.Count > c.MaximoSubModulosReprobadasOrdinario && TotalesFinalesEnOrdinario.Count >= HorariosdelAlumno.Count)
                 )
            {
                ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                          .Select(e => new ctAlumnos
                          {

                              Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                              Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                              ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                              ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                              Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                              Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                              FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                              IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                              IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                              IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                              Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                              Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                              Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                              CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                              IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                              IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                              IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                              ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                              Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                              CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                              IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                              IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                              BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                              IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                              NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                              ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                              ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                              IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                              TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                              NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                              ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                              ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                              IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                              TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                              NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                              ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                              ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                              IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                              TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                              IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                              IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                              cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                              PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                              IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                              IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                              IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                              NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                              IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                              IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                              IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                              FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                              IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                              IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                              IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                              IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                              CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                              EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                              IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                              IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                              IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                              FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                              PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                              AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                              CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                              Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                              NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                              FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                              IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                              KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                              NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                              IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                              FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                              IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                              FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                              IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                              EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                              FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                              IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                              EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                              IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                              IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                              IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                              IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                              CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                              NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                              ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                              CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                              ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor

                          }).First();



                //baja
                short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR EXCEDER REPROBADAS EN ORDINARIO").Select(f => f.IdStatusAlumno).First();
                var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                //if (exstatus != null)
                //    c.AlumnosEstatusAActualizar.Remove(exstatus);
                if (exstatus == null)
                {
                    alumno.IdStatusAlumno = idstatusalumno;
                    c.AlumnosEstatusAActualizar.Add(alumno);
                }

                stHorarioAlumno alhor = HorariosdelAlumno.Where(f => f.IdHorarioAlumno == item.IdHorarioAlumno).First();

                if ((TotalesFinalesEnOrdinario.Count == HorariosdelAlumno.Count) && totalreprobadasordinario.Count > 0)
                    ObtenerCalificacionesFaltantes(c, alhor, c.EvaluacionesDelAlumno.ElementAt(3).IdCursoPeriodoMomento);
            }
            else
                if ((TotalesFinalesEnOrdinario.Count >= HorariosdelAlumno.Count))
                {

                    if ((totalreprobadasordinario.Count > c.MaximoReprobadasOrdinario + 1)
                         || (totalreprobadasordinario.Count + totalNps.Count > c.MaximoReprobadasOrdinario + 1)
                        || (totalsubmoduloreprobadosordinario.Count > c.MaximoSubModulosReprobadasOrdinario) && TotalesFinalesEnOrdinario.Count == HorariosdelAlumno.Count

                        )
                    {
                        ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                            .Select(e => new ctAlumnos
                            {

                                Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                                Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                                ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                                ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                                Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                                Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                                FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                                IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                                IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                                IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                                Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                                Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                                Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                                CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                                IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                                IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                                IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                                ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                                Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                                CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                                IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                                IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                                BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                                IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                                NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                                ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                                ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                                IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                                TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                                NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                                ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                                ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                                IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                                TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                                NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                                ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                                ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                                IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                                TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                                IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                                IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                                cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                                PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                                IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                                IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                                IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                                NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                                IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                                IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                                IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                                FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                                IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                                IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                                IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                                IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                                CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                                EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                                IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                                IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                                IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                                FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                                PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                                AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                                CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                                Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                                NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                                FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                                IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                                KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                                NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                                IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                                FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                                IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                                FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                                IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                                EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                                FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                                IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                                EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                                IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                                IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                                IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                                IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                                CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                                NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                                ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                                CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                                ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor

                            }).First();



                        //baja
                        short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR EXCEDER REPROBADAS EN ORDINARIO").Select(f => f.IdStatusAlumno).First();
                        var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                        //if (exstatus != null)
                        //    c.AlumnosEstatusAActualizar.Remove(exstatus);
                        if (exstatus == null)
                        {
                            alumno.IdStatusAlumno = idstatusalumno;
                            c.AlumnosEstatusAActualizar.Add(alumno);
                        }

                        stHorarioAlumno alhor = HorariosdelAlumno.Where(f => f.IdHorarioAlumno == item.IdHorarioAlumno).First();

                        if ((TotalesFinalesEnOrdinario.Count == HorariosdelAlumno.Count) && totalreprobadasordinario.Count > 0)
                            ObtenerCalificacionesFaltantes(c, alhor, c.EvaluacionesDelAlumno.ElementAt(3).IdCursoPeriodoMomento);

                    }



                }
                else
                {

                    if ((totalreprobadasordinario.Count > c.MaximoReprobadasOrdinario + 1) ||
                        (totalNps.Count + totalreprobadasordinario.Count > c.MaximoReprobadasOrdinario + 1) ||
                        (totalsubmoduloreprobadosordinario.Count > c.MaximoSubModulosReprobadasOrdinario))
                    {
                        ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                            .Select(e => new ctAlumnos
                            {

                                Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                                Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                                ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                                ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                                Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                                Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                                FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                                IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                                IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                                IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                                Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                                Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                                Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                                CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                                IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                                IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                                IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                                ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                                Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                                CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                                IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                                IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                                BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                                IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                                NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                                ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                                ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                                IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                                TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                                NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                                ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                                ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                                IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                                TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                                NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                                ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                                ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                                IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                                TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                                IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                                IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                                cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                                PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                                IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                                IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                                IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                                NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                                IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                                IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                                IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                                FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                                IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                                IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                                IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                                IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                                CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                                EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                                IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                                IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                                IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                                FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                                PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                                AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                                CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                                Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                                NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                                FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                                IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                                KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                                NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                                IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                                FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                                IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                                FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                                IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                                EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                                FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                                IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                                EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                                IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                                IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                                IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                                IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                                CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                                NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                                ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                                CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                                ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor

                            }).First();

                        //baja
                        short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "PARA BAJA POR REPROBADAS EN ORDINARIO").Select(f => f.IdStatusAlumno).First();


                        var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                        //if (exstatus != null)
                        //    c.AlumnosEstatusAActualizar.Remove(exstatus);

                        if (exstatus == null)
                        {
                            alumno.IdStatusAlumno = idstatusalumno;
                            c.AlumnosEstatusAActualizar.Add(alumno);
                        }

                        //stHorarioAlumno alhor = HorariosdelAlumno.Where(f => f.IdHorarioAlumno == item.IdHorarioAlumno).First();

                        //if ((TotalesFinalesEnOrdinario.Count == HorariosdelAlumno.Count) && totalreprobadasordinario.Count > 0)
                        //    ObtenerCalificacionesFaltantes(c, alhor, TotalesFinalesEnOrdinario.ElementAt(0).IdCursoPeriodoMomento);

                    }

                }

        }

        private void ValidarPeriodoEE(ReglamentoEvaluacion c, IdHorariosAlumnos item)
        {

            //VALIDACION DE REPROBADAS POR PERIODO EE

            HorariosAlumnos horarios = HorariosAlumnos.Instance;
            List<stHorarioAlumno> HorariosdelAlumno = horarios.getHorariosPorAlumno(item.Curp, item.IdCicloEscolar);


            //var TotalesReprobadasEnOrdinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Ordinario" && s.EsReprobada == true && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();

            var TotalesReprobadasEnOrdinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s =>  s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Ordinario" && s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctMomento.Nombre == "Recuperacion" && s.stHorarioAlumno.Curp == item.Curp && s.EsReprobada == true && s.EsNp == false && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();

            var TotalesReprobadasEnOrdinarioModulos = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.stHorarioAlumno.stHorario.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre == "PROFESIONAL" && s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Extraordinario" &&  s.stHorarioAlumno.Curp == item.Curp && s.EsReprobada == true && s.EsNp == false && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();


            var TotalesCalificacionesEnOrdinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Extraordinario" && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();

            var totalreprobadasEE = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Extraordinario" && s.stHorarioAlumno.Curp == item.Curp && s.EsReprobada == true && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();

            var TotalesFinalesEnOrdinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s =>   s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctMomento.Nombre == "Parcial" && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();



            //IRRGULARES
            if ((TotalesReprobadasEnOrdinario.Count == TotalesCalificacionesEnOrdinario.Count) && totalreprobadasEE.Count > 0)
            {
                ctAlumnos alumno = HorariosdelAlumno[0].ctAlumnos;

                alumno.EsRegular = false;
                c.AlumnosIrregularesAActualizar.Add(alumno);
            }

            //VALIDACION DE REPORBADAS POR PERIODO EE
           // if (((TotalesReprobadasEnOrdinario.Count + TotalesReprobadasEnOrdinarioModulos.Count) == TotalesCalificacionesEnOrdinario.Count))
            if (((TotalesReprobadasEnOrdinario.Count ) == TotalesCalificacionesEnOrdinario.Count))
            {
                if (totalreprobadasEE.Count > c.MaximoReprobadasEE)
                {
                    ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                        .Select(e => new ctAlumnos
                        {

                            Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                            Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                            ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                            ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                            Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                            Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                            FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                            IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                            IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                            IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                            Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                            Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                            Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                            CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                            IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                            IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                            IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                            ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                            Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                            CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                            IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                            IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                            BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                            IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                            NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                            ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                            ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                            IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                            TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                            NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                            ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                            ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                            IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                            TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                            NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                            ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                            ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                            IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                            TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                            IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                            IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                            cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                            PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                            IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                            IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                            IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                            NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                            IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                            IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                            IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                            FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                            IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                            IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                            IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                            IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                            CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                            EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                            IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                            IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                            IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                            FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                            PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                            AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                            CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                            Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                            NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                            FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                            IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                            KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                            NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                            IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                            FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                            IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                            FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                            IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                            EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                            FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                            IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                            EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                            IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                            IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                            IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                            IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                            CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                            NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                            ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                            CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                            ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor
                        }).First();

                    //baja
                    short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR EXCEDER REPROBADAS EN EXTRAORDINARIO").Select(f => f.IdStatusAlumno).First();

                    var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                    //if (exstatus != null)
                    //    c.AlumnosEstatusAActualizar.Remove(exstatus);

                    if (exstatus == null)
                    {
                        alumno.IdStatusAlumno = idstatusalumno;

                        c.AlumnosEstatusAActualizar.Add(alumno);

                        stHorarioAlumno alhor = HorariosdelAlumno.Where(f => f.IdHorarioAlumno == item.IdHorarioAlumno).First();

                        if ((TotalesReprobadasEnOrdinario.Count == TotalesCalificacionesEnOrdinario.Count))
                            ObtenerCalificacionesFaltantes(c, alhor, totalreprobadasEE.ElementAt(0).IdCursoPeriodoMomento);
                    }




                }

            }
            else
            {

               // if ((totalreprobadasEE.Count +TotalesReprobadasEnOrdinarioModulos.Count) > c.MaximoReprobadasEE)
                if ((totalreprobadasEE.Count ) > c.MaximoReprobadasEE)
                {
                    ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                        .Select(e => new ctAlumnos
                        {

                            Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                            Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                            ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                            ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                            Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                            Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                            FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                            IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                            IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                            IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                            Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                            Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                            Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                            CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                            IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                            IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                            IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                            ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                            Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                            CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                            IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                            IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                            BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                            IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                            NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                            ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                            ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                            IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                            TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                            NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                            ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                            ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                            IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                            TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                            NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                            ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                            ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                            IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                            TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                            IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                            IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                            cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                            PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                            IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                            IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                            IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                            NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                            IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                            IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                            IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                            FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                            IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                            IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                            IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                            IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                            CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                            EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                            IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                            IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                            IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                            FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                            PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                            AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                            CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                            Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                            NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                            FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                            IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                            KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                            NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                            IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                            FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                            IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                            FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                            IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                            EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                            FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                            IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                            EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                            IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                            IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                            IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                            IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                            CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                            NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                            ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                            CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                            ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor
                        }).First();

                    //baja
                    if (TotalesFinalesEnOrdinario.Count == HorariosdelAlumno.Count)
                    {
                        stHorarioAlumno alhor = HorariosdelAlumno.Where(f => f.IdHorarioAlumno == item.IdHorarioAlumno).First();

                        //if ((TotalesReprobadasEnOrdinario.Count == TotalesCalificacionesEnOrdinario.Count))
                            ObtenerCalificacionesFaltantes(c, alhor, totalreprobadasEE.ElementAt(0).IdCursoPeriodoMomento);

                            short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR EXCEDER REPROBADAS EN EXTRAORDINARIO").Select(f => f.IdStatusAlumno).First();
                        var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                        //if (exstatus != null)
                        //    c.AlumnosEstatusAActualizar.Remove(exstatus);

                        if (exstatus == null)
                        {
                            alumno.IdStatusAlumno = idstatusalumno;
                            c.AlumnosEstatusAActualizar.Add(alumno);
                        }
                    }
                    else
                    {
                        short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "PARA BAJA POR REPROBADAS EN EXTRAORDINARIO").Select(f => f.IdStatusAlumno).First();

                        var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                        //if (exstatus != null)
                        //    c.AlumnosEstatusAActualizar.Remove(exstatus);

                        if (exstatus == null)
                        {
                            alumno.IdStatusAlumno = idstatusalumno;
                            c.AlumnosEstatusAActualizar.Add(alumno);
                        }

                        //stHorarioAlumno alhor = HorariosdelAlumno.Where(f => f.IdHorarioAlumno == item.IdHorarioAlumno).First();

                        //if ((TotalesReprobadasEnOrdinario.Count == TotalesCalificacionesEnOrdinario.Count))
                        //    ObtenerCalificacionesFaltantes(c, alhor, totalreprobadasEE.ElementAt(0).IdCursoPeriodoMomento);
                    }
                }

            }

        }

        private void ValidarPeriodoCI(ReglamentoEvaluacion c, IdHorariosAlumnos item)
        {

            HorariosAlumnos horarios = HorariosAlumnos.Instance;
            List<stHorarioAlumno> HorariosdelAlumno = horarios.getHorariosPorAlumno(item.Curp, item.IdCicloEscolar);


            //VALIDACION DE REPROBADAS POR PERIODO CI


            var TotalesReprobadasEnCI = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Ordinario" && s.EsReprobada == true && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();

            var TotalesCalificacionesEnCI = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Intersemestral" == true && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();

            var totalreprobadasCI = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Intersemestral" && s.stHorarioAlumno.Curp == item.Curp && s.EsReprobada == true && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();



            //IRRGULARES
            if ((TotalesReprobadasEnCI.Count == TotalesCalificacionesEnCI.Count) && totalreprobadasCI.Count > 0)
            {
                ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).Select(e => e.stHorarioAlumno.ctAlumnos).First();

                alumno.EsRegular = false;
                c.AlumnosIrregularesAActualizar.Add(alumno);
            }

            //VALIDACION DE REPORBADAS POR PERIODO CI
            if ((TotalesReprobadasEnCI.Count == TotalesCalificacionesEnCI.Count))
            {
                if (totalreprobadasCI.Count > c.MaximoReprobadasCI)
                {
                    ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                        .Select(e => new ctAlumnos
                        {

                            Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                            Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                            ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                            ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                            Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                            Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                            FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                            IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                            IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                            IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                            Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                            Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                            Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                            CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                            IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                            IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                            IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                            ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                            Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                            CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                            IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                            IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                            BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                            IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                            NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                            ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                            ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                            IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                            TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                            NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                            ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                            ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                            IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                            TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                            NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                            ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                            ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                            IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                            TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                            IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                            IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                            cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                            PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                            IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                            IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                            IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                            NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                            IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                            IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                            IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                            FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                            IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                            IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                            IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                            IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                            CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                            EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                            IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                            IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                            IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                            FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                            PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                            AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                            CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                            Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                            NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                            FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                            IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                            KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                            NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                            IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                            FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                            IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                            FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                            IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                            EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                            FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                            IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                            EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                            IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                            IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                            IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                            IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                            CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                            NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                            ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                            CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                            ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor
                        }).First();

                    //baja
                    short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR EXCEDER REPROBADAS EN INTERSEMESTRAL").Select(f => f.IdStatusAlumno).First();

                    var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                    //if (exstatus != null)
                    //    c.AlumnosEstatusAActualizar.Remove(exstatus);

                    if (exstatus == null)
                    {
                        alumno.IdStatusAlumno = idstatusalumno;
                        c.AlumnosEstatusAActualizar.Add(alumno);

                        stHorarioAlumno alhor = HorariosdelAlumno.Where(f => f.IdHorarioAlumno == item.IdHorarioAlumno).First();
                        if ((TotalesReprobadasEnCI.Count == TotalesCalificacionesEnCI.Count))
                            ObtenerCalificacionesFaltantes(c, alhor, totalreprobadasCI.ElementAt(0).IdCursoPeriodoMomento);

                    }


                }

            }
            else
            {

                if (totalreprobadasCI.Count > c.MaximoReprobadasCI)
                {
                    ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                        .Select(e => new ctAlumnos
                        {

                            Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                            Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                            ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                            ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                            Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                            Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                            FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                            IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                            IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                            IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                            Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                            Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                            Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                            CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                            IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                            IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                            IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                            ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                            Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                            CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                            IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                            IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                            BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                            IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                            NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                            ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                            ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                            IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                            TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                            NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                            ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                            ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                            IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                            TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                            NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                            ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                            ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                            IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                            TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                            IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                            IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                            cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                            PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                            IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                            IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                            IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                            NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                            IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                            IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                            IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                            FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                            IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                            IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                            IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                            IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                            CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                            EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                            IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                            IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                            IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                            FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                            PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                            AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                            CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                            Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                            NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                            FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                            IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                            KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                            NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                            IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                            FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                            IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                            FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                            IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                            EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                            FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                            IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                            EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                            IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                            IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                            IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                            IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                            CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                            NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                            ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                            CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                            ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor
                        }).First();

                    //baja
                    short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "PARA BAJA POR REPROBADAS EN INTERSEMESTRAL").Select(f => f.IdStatusAlumno).First();

                    var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                    if (exstatus == null)
                    //  c.AlumnosEstatusAActualizar.Remove(exstatus);
                    {
                        alumno.IdStatusAlumno = idstatusalumno;
                        c.AlumnosEstatusAActualizar.Add(alumno);



                    }


                }

            }

        }

        private void GrabarBaseDatosValidacionAcedemica(ReglamentoEvaluacion c)
        {
            bdAriesEntities basedatos = new bdAriesEntities();
            basedatos.Configuration.AutoDetectChangesEnabled = false;
            basedatos.Configuration.ValidateOnSaveEnabled = false;

            foreach (var item in c.CalificacionesFinalesAInsertar)
            {

                basedatos.Entry(item).State = System.Data.Entity.EntityState.Added;

            }

            try
            {
                basedatos.SaveChanges();

            }
            catch (Exception e)
            {

                throw;
            }

            //limpiar calificaciones finales
            c.CalificacionesFinalesAInsertar.Clear();





            foreach (var item in c.AlumnosEstatusAActualizar)
            {

                basedatos.Entry(item).State = System.Data.Entity.EntityState.Modified;
                basedatos.Entry(item).Property("IdStatusAlumno").IsModified = true;

                ActualizarEstatusSingleton(item);
            }


            try
            {
                basedatos.SaveChanges();

            }
            catch (Exception e)
            {

                throw;
            }



            foreach (var item in c.AlumnosEstatusAActualizar)
            {

                basedatos.Entry(item).State = System.Data.Entity.EntityState.Modified;
                basedatos.Entry(item).Property("EsRegular").IsModified = true;

                ActualizarEstatusSingleton(item);
            }


            try
            {
                basedatos.SaveChanges();

            }
            catch (Exception e)
            {

                throw;
            }

            basedatos.Configuration.AutoDetectChangesEnabled = true;
            basedatos.Configuration.ValidateOnSaveEnabled = true;

        }

        private void ActualizarEstatusValidacionCalificacionesFinales(ReglamentoEvaluacion c)
        {
            bdAriesEntities basedatos = new bdAriesEntities();
            basedatos.Configuration.AutoDetectChangesEnabled = false;
            basedatos.Configuration.ValidateOnSaveEnabled = false;



            foreach (var item in c.AlumnosEstatusAActualizar)
            {

                basedatos.Entry(item).State = System.Data.Entity.EntityState.Modified;
                basedatos.Entry(item).Property("IdStatusAlumno").IsModified = true;



                ActualizarEstatusSingleton(item);




            }


            try
            {
                basedatos.SaveChanges();

            }
            catch (Exception e)
            {

                throw e.InnerException;
            }


            basedatos.Configuration.AutoDetectChangesEnabled = true;
            basedatos.Configuration.ValidateOnSaveEnabled = true;
        }


        private string GrabaListasDeCalificacionesGrado(ref ReglamentoEvaluacion c)
        {
            string msj = "";
            bdAriesEntities basedatos = new bdAriesEntities();

            basedatos.Configuration.AutoDetectChangesEnabled = false;
            basedatos.Configuration.ValidateOnSaveEnabled = false;

            foreach (var item in c.CalificacionesFinalGradoAInsertar)
            {
                msj = msj + item.Curp + ", ";

                basedatos.Entry(item).State = System.Data.Entity.EntityState.Added;

            }



            try
            {
                basedatos.SaveChanges();

            }
            catch (Exception e)
            {

                throw;
            }



            c.CalificacionesFinalGradoAInsertar.Clear();


            basedatos.Configuration.AutoDetectChangesEnabled = true;
            basedatos.Configuration.ValidateOnSaveEnabled = true;

            return msj;

        }

        private string GrabaListasDeCalificaciones(ref ReglamentoEvaluacion c)
        {
            string msj = "";
            bdAriesEntities basedatos = new bdAriesEntities();
            basedatos.Configuration.AutoDetectChangesEnabled = false;
            basedatos.Configuration.ValidateOnSaveEnabled = false;


            //MOMENTOS******************
            foreach (var item in c.EvaluacionesAEliminar)
            {
                msj = msj + item.stHorarioAlumno.Curp + ", ";
                item.stHorarioAlumno = null;
                basedatos.Entry(item).State = System.Data.Entity.EntityState.Deleted;
            }


            var inner = from tt in c.Alumnos select tt.IdHorarioAlumno;
            var periodos = from rr in basedatos.Acreditacion_stPeriodoCalificacion where inner.Contains(rr.IdHorarioAlumno) select rr;


            foreach (var item in periodos.ToList())
            {
                msj = msj + item.stHorarioAlumno.Curp + ", ";
                item.stHorarioAlumno = null;
                basedatos.Entry(item).State = System.Data.Entity.EntityState.Deleted;
            }


            //delete calificaciones finales



            bdAriesEntities bd = new bdAriesEntities();

            var inner2 = from tt in c.Alumnos select tt.Curp;

            var finales = basedatos.Acreditacion_stAlumnosCalificacionFinal.Where(d => inner2.Contains(d.Curp)).ToList();


            var fin = finales.Join(c.Alumnos, x => new { x.Curp, x.IdPlanEstudioAsignatura, x.Matricula, x.IdCicloEscolar },
                y => new { y.Curp, y.IdPlanEstudioAsignatura, y.Matricula, y.IdCicloEscolar }, (x, y) => x).AsEnumerable()
                .Select(x =>

                   x.IdAlumnoCalificacionFinal

                ).ToList();



            var Califfinales = basedatos.Acreditacion_stAlumnosCalificacionFinal.Where(d => fin.Contains(d.IdAlumnoCalificacionFinal));


            foreach (var dd in Califfinales.ToList())
            {
                basedatos.Entry(dd).State = System.Data.Entity.EntityState.Deleted;


            }


            //seccion de eliminacion
            try
            {
                basedatos.SaveChanges();

            }
            catch (Exception e)
            {

                throw;
            }

            //seccion de eliminacion***********




            foreach (var item in c.EvaluacionesAActualizar)
            {
                msj = msj + item.stHorarioAlumno.Curp + ", ";
                item.stHorarioAlumno = null;

                bd.Entry(item).State = System.Data.Entity.EntityState.Modified;
            }

            foreach (var item in c.EvaluacionesAInsertar)
            {
//                msj = msj + item.stHorarioAlumno.Curp + ", ";
                item.stHorarioAlumno = null;
                bd.Entry(item).State = System.Data.Entity.EntityState.Added;

            }

            //MOMENTOS---------------------------

            //PERIODOS**************************


            foreach (var item in c.PeriodosEvaluacionesAInsertar)
            {
                //msj = msj + item.stHorarioAlumno.Curp + ", ";
                //item.stHorarioAlumno = null;

                bd.Entry(item).State = System.Data.Entity.EntityState.Added;

            }


            //PERIODOS--------------------------

            //FINALES************************



            foreach (var item in c.CalificacionesFinalesAInsertar)
            {
                msj = msj + item.Curp + ", ";

                bd.Entry(item).State = System.Data.Entity.EntityState.Added;

            }

            //limpiar calificaciones finales
            //c.CalificacionesFinalesAInsertar.Clear();





            try
            {
                bd.SaveChanges();

            }
            catch (Exception e)
            {

                throw;
            }



            c.CalificacionesFinalesAInsertar.Clear();
            //FINALES--------------------------




            basedatos.Configuration.AutoDetectChangesEnabled = true;
            basedatos.Configuration.ValidateOnSaveEnabled = true;


            return msj;

        }

        /// <summary>
        /// Determina si existe calificacion segun la evaluación para qeu grabe o actualize la calificacion
        /// </summary>
        /// <param name="c"></param>
        /// <param name="evaluacion"></param>
        private void ActualizarInformacionGrabarActualizar(ReglamentoEvaluacion c, string evaluacion, long IdHorarioAlumno)
        {
            Acreditacion_stMomentoEvaluacionCalificacion info = new Acreditacion_stMomentoEvaluacionCalificacion();

            info = c._stMomentoEvaluacionCalificacion.Where(f => (f.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre == evaluacion && f.Calificacion > -1 && f.IdMomentoEvaluacionCalificacion > -1 && f.IdHorarioAlumno == IdHorarioAlumno)).Select(s => new Acreditacion_stMomentoEvaluacionCalificacion { stHorarioAlumno = s.stHorarioAlumno, IdMomentoEvaluacionCalificacion = (long)s.IdMomentoEvaluacionCalificacion, IdMomentoEvaluacion = (short)s.IdMomentoEvaluacion, Calificacion = (decimal)s.Calificacion, EsDefinitiva = (bool)s.EsDefinitiva, EsNp = (bool)s.EsNp, EsReprobada = (bool)s.EsReprobada, IdHorarioAlumno = (long)s.IdHorarioAlumno, EsReprobadaSinPago = (bool)s.EsReprobadaSinPago }).SingleOrDefault();
            
            if (info != null)
            {
                info.EsDefinitiva = true;

                bdAriesEntities bd = new bdAriesEntities();
                
                long id = (long)c.EvaluacionesDelAlumno.Where(f => f.Evaluacion == evaluacion).FirstOrDefault().IdHorarioAlumno;
                var existe = bd.Acreditacion_stMomentoEvaluacionCalificacion.Where(w => w.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre == evaluacion && w.IdHorarioAlumno == id).FirstOrDefault();


                if (info.Calificacion > c.CalificacionReprobatoria)
                    info.EsReprobada = false;
                else
                    info.EsReprobada = true;

                int decimales = c._Acreditacion_stMomentoEvaluacion.Where(r => r.Acreditacion_ctEvaluacion.Nombre == evaluacion).Select(t => t.rptDecimales).First();

                info.rptCalificacion = c.CalificacionCadena(info.Calificacion, TipoPromedio.Evaluacion, decimales.ToString());
                if (existe == null)
                {

                    c.EvaluacionesAInsertar.Add(info);
                }
                else
                    c.EvaluacionesAActualizar.Add(info);
            }
        }



        /// <summary>
        /// Si la calificación de los 3 parciales es aprobatoria graba las calificaciones de cada evaluacion y ademas graba en el periodo y la calificacion final
        /// </summary>
        /// <param name="c"></param>
        private void GrabarCalificacionesMomentos(ReglamentoEvaluacion c, long IdHorarioAlumno)
        {

            ActualizarInformacionGrabarActualizar(c, "P1", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "P2", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "P3", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "R1", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "R2", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "R3", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "EE", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "CI", IdHorarioAlumno);

        }


        private void GrabaUnNP(ReglamentoEvaluacion c)
        {
            
            Acreditacion_stPeriodoCalificacion evaluacion = new Acreditacion_stPeriodoCalificacion();

            evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
            evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
            evaluacion.Calificacion = c.CalificacionNPoReprobatoria;
            evaluacion.rptCalificacion = c.CalificacionCadena(c.CalificacionNPoReprobatoria, TipoPromedio.Periodo);
            evaluacion.EsNp = true;
            evaluacion.EsReprobada = true;

            if (c.PeriodosEvaluacionesAInsertar.Where(f=> f.IdHorarioAlumno==evaluacion.IdHorarioAlumno && f.IdCursoPeriodoMomento==evaluacion.IdCursoPeriodoMomento).ToList().Count==0)
            c.PeriodosEvaluacionesAInsertar.Add(evaluacion);
          



            Acreditacion_stPeriodoCalificacion evaluacion2 = new Acreditacion_stPeriodoCalificacion();

            evaluacion2.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
            evaluacion2.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(3).IdCursoPeriodoMomento;
            evaluacion2.Calificacion = c.CalificacionNPoReprobatoria;
            evaluacion2.rptCalificacion = c.CalificacionCadena(c.CalificacionNPoReprobatoria, TipoPromedio.Periodo);
            evaluacion2.EsNp = true;
            evaluacion2.EsReprobada = true;

            if (c.PeriodosEvaluacionesAInsertar.Where(f => f.IdHorarioAlumno == evaluacion2.IdHorarioAlumno && f.IdCursoPeriodoMomento == evaluacion2.IdCursoPeriodoMomento).ToList().Count == 0)
            c.PeriodosEvaluacionesAInsertar.Add(evaluacion2);


            Acreditacion_stPeriodoCalificacion evaluacion3 = new Acreditacion_stPeriodoCalificacion();

            evaluacion3.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
            evaluacion3.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(6).IdCursoPeriodoMomento;
            evaluacion3.Calificacion = c.CalificacionNPoReprobatoria;
            evaluacion3.rptCalificacion = c.CalificacionCadena(c.CalificacionNPoReprobatoria, TipoPromedio.Periodo);
            evaluacion3.EsNp = true;
            evaluacion3.EsReprobada = true;

            if (c.PeriodosEvaluacionesAInsertar.Where(f => f.IdHorarioAlumno == evaluacion3.IdHorarioAlumno && f.IdCursoPeriodoMomento == evaluacion3.IdCursoPeriodoMomento).ToList().Count == 0)
            c.PeriodosEvaluacionesAInsertar.Add(evaluacion3);


             



        }

        /// <summary>
        /// Determina si acredito en el periodo Ordinario
        /// </summary>
        /// <param name="c"></param>
        /// <returns></returns>
        private bool AprobacionReprobacionEnOrdinario(ReglamentoEvaluacion c, ref Acreditacion_stPeriodoCalificacion evaluacion)
        {

            bool regresa = false;
            //recuperaciones
            if (c.EvaluacionesDelAlumno.ElementAt(0).EsNp == false && c.EvaluacionesDelAlumno.ElementAt(1).EsNp == false && c.EvaluacionesDelAlumno.ElementAt(2).EsNp == false)
            {
                if ((c.EvaluacionesDelAlumno.ElementAt(0).EsNp == false || c.EvaluacionesDelAlumno.ElementAt(1).EsNp == false || c.EvaluacionesDelAlumno.ElementAt(2).EsNp == false)
                    && (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false || c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false || c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false)
                    || (c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == false)
                    )
                {
                    if (c.EvaluacionesDelAlumno.ElementAt(0).Calificacion > c.CalificacionReprobatoria && c.EvaluacionesDelAlumno.ElementAt(1).Calificacion > c.CalificacionReprobatoria && c.EvaluacionesDelAlumno.ElementAt(2).Calificacion > c.CalificacionReprobatoria)
                    {
                        evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                        evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                        evaluacion.Calificacion = FormatearPromedio((decimal)(c.EvaluacionesDelAlumno.ElementAt(0).Calificacion + c.EvaluacionesDelAlumno.ElementAt(1).Calificacion + c.EvaluacionesDelAlumno.ElementAt(2).Calificacion) / 3, TipoPromedio.Periodo);
                        evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);
                        evaluacion.EsNp = false;
                        evaluacion.EsReprobada = false;


                        regresa = true;
                    }
                    else
                    {
                        decimal sumacalificaciones = 0;
                        decimal sumacalificacionesRs = 0;
                        bool haynp = false;
                        bool reproborecuperacion = false;

                        //recuperaciones
                        int totalaprobadas = 0;
                        int totalaprobadasrecuperaciones = 0;
                        int califcompletas = 0;
                        if (c.EvaluacionesDelAlumno.ElementAt(0).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(1).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(2).Calificacion > -1)
                        {
                            califcompletas = 3;

                            if (c.EvaluacionesDelAlumno.ElementAt(0).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(1).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(2).EsNp == true)
                                haynp = true;

                            if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(0).Calificacion;
                            }

                            if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(1).Calificacion;
                            }

                            if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(2).Calificacion;
                            }
                        }


                        if (c.EvaluacionesDelAlumno.ElementAt(3).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(4).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(5).EsNp == true)
                            haynp = true;

                        if (c.EvaluacionesDelAlumno.ElementAt(3).Calificacion > -1)
                        {
                            califcompletas = califcompletas + 1;
                            if (c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(3).Calificacion;
                                totalaprobadasrecuperaciones = totalaprobadasrecuperaciones + 1;
                                sumacalificacionesRs = sumacalificacionesRs + (decimal)c.EvaluacionesDelAlumno.ElementAt(3).Calificacion;
                            }
                            else
                                reproborecuperacion = true;
                        }

                        if (c.EvaluacionesDelAlumno.ElementAt(4).Calificacion > -1)
                        {
                            califcompletas = califcompletas + 1;
                            if (c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(4).Calificacion;
                                totalaprobadasrecuperaciones = totalaprobadasrecuperaciones + 1;
                                sumacalificacionesRs = sumacalificacionesRs + (decimal)c.EvaluacionesDelAlumno.ElementAt(4).Calificacion;
                            }
                            else
                                reproborecuperacion = true;
                        }

                        if (c.EvaluacionesDelAlumno.ElementAt(5).Calificacion > -1)
                        {
                            califcompletas = califcompletas + 1;
                            if (c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(5).Calificacion;
                                totalaprobadasrecuperaciones = totalaprobadasrecuperaciones + 1;
                                sumacalificacionesRs = sumacalificacionesRs + (decimal)c.EvaluacionesDelAlumno.ElementAt(5).Calificacion;
                            }
                            else
                                reproborecuperacion = true;
                        }

                        //acompleta las 6 evaluaciones si es qeu no requerie califiacion en una R
                        if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(3).Calificacion == -1)
                        {
                            califcompletas = califcompletas + 1;
                        }
                        if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(4).Calificacion == -1)
                        {
                            califcompletas = califcompletas + 1;
                        }

                        if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(5).Calificacion == -1)
                        {
                            califcompletas = califcompletas + 1;
                        }
                        //fin acompleta 


                        if (reproborecuperacion == true)
                        {

                            //submodulos si reprueba un submodulo en REcuperacion se va directo a CI
                            if (califcompletas == 6)
                            {
                                if (c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.stHorario.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre == "PROFESIONAL")
                                {
                                    evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                    evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(6).IdCursoPeriodoMomento;
                                    evaluacion.Calificacion = c.CalificacionNPoReprobatoria;
                                    evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);


                                    evaluacion.EsNp = haynp;
                                    evaluacion.EsReprobada = true;

                                    regresa = true;

                                    Acreditacion_stPeriodoCalificacion ordi = new Acreditacion_stPeriodoCalificacion();
                                    ordi.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                    ordi.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(6).IdCursoPeriodoMomento;
                                    ordi.Calificacion = c.CalificacionNPoReprobatoria;
                                    ordi.rptCalificacion = c.CalificacionCadena(ordi.Calificacion, TipoPromedio.Periodo);


                                    ordi.EsNp = haynp;
                                    ordi.EsReprobada = true;
                                    c.PeriodosEvaluacionesAInsertar.Add(ordi);
                                }
                            }

                            if (califcompletas == 6)
                            {

                                Acreditacion_stPeriodoCalificacion ordi = new Acreditacion_stPeriodoCalificacion();
                                ordi.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                ordi.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                                ordi.Calificacion = c.CalificacionNPoReprobatoria;
                                ordi.rptCalificacion = c.CalificacionCadena(ordi.Calificacion, TipoPromedio.Periodo);


                                ordi.EsNp = false;
                                ordi.EsReprobada = true;
                                c.PeriodosEvaluacionesAInsertar.Add(ordi);



                            }

                            evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                            evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(3).IdCursoPeriodoMomento;
                            evaluacion.Calificacion = c.CalificacionNPoReprobatoria;
                            evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);


                            evaluacion.EsNp = false;
                            evaluacion.EsReprobada = true;

                            regresa = true;
                        }
                        else
                            if (totalaprobadasrecuperaciones == 3 || totalaprobadas == 3)
                            {
                                //evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                //evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                                //evaluacion.Calificacion = FormatearPromedio((decimal)(c.EvaluacionesDelAlumno.ElementAt(0).Calificacion + c.EvaluacionesDelAlumno.ElementAt(1).Calificacion + c.EvaluacionesDelAlumno.ElementAt(2).Calificacion) / 3, TipoPromedio.Periodo);
                                //evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);

                                //evaluacion.EsNp = haynp;
                                //evaluacion.EsReprobada = false;
                                //regresa = true;

                                //if (califcompletas==6)
                                //{
                                //    if (c.EvaluacionesDelAlumno.ElementAt(3).Calificacion > -1 || c.EvaluacionesDelAlumno.ElementAt(4).Calificacion > -1 || c.EvaluacionesDelAlumno.ElementAt(5).Calificacion > -1)
                                //    {
                                Acreditacion_stPeriodoCalificacion ordinario = new Acreditacion_stPeriodoCalificacion();
                                ordinario.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                ordinario.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                                ordinario.Calificacion = c.CalificacionNPoReprobatoria;
                                ordinario.rptCalificacion = c.CalificacionCadena(ordinario.Calificacion, TipoPromedio.Periodo);


                                ordinario.EsNp = haynp;
                                ordinario.EsReprobada = true;
                                c.PeriodosEvaluacionesAInsertar.Add(ordinario);

                                // Acreditacion_stPeriodoCalificacion recu = new Acreditacion_stPeriodoCalificacion();
                                evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(3).IdCursoPeriodoMomento;

                                if (totalaprobadasrecuperaciones == 3)
                                    evaluacion.Calificacion = FormatearPromedio((decimal)(sumacalificacionesRs / 3), TipoPromedio.Periodo);
                                else
                                    evaluacion.Calificacion = FormatearPromedio((decimal)(sumacalificaciones / 3), TipoPromedio.Periodo);


                                evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);


                                evaluacion.EsNp = haynp;
                                evaluacion.EsReprobada = false;

                                regresa = true;
                                //    }
                                //}
                            }
                            else
                                if (califcompletas == 6)
                                {
                                    evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                    evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                                    evaluacion.Calificacion = c.CalificacionNPoReprobatoria;
                                    evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);


                                    evaluacion.EsNp = haynp;
                                    evaluacion.EsReprobada = true;

                                    regresa = true;

                                    Acreditacion_stPeriodoCalificacion recu = new Acreditacion_stPeriodoCalificacion();
                                    recu.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                    recu.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(3).IdCursoPeriodoMomento;
                                    recu.Calificacion = c.CalificacionNPoReprobatoria;
                                    recu.rptCalificacion = c.CalificacionCadena(recu.Calificacion, TipoPromedio.Periodo);


                                    recu.EsNp = haynp;
                                    recu.EsReprobada = true;
                                    c.PeriodosEvaluacionesAInsertar.Add(recu);

                                }




                    }

                }
                else
                {
                    if (c.EvaluacionesDelAlumno.ElementAt(0).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(1).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(2).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(3).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(4).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(5).Calificacion > -1)
                    {
                        if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == true || c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == true || c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == true)
                        {


                            evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                            evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                            evaluacion.Calificacion = c.CalificacionNPoReprobatoria;
                            evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);


                            evaluacion.EsNp = false;
                            evaluacion.EsReprobada = true;

                            regresa = true;


                            if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == true)
                            {
                                Acreditacion_stPeriodoCalificacion recu = new Acreditacion_stPeriodoCalificacion();
                                recu.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                recu.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(3).IdCursoPeriodoMomento;
                                recu.Calificacion = c.CalificacionNPoReprobatoria;
                                recu.rptCalificacion = c.CalificacionCadena(recu.Calificacion, TipoPromedio.Periodo);


                                recu.EsNp = false;
                                recu.EsReprobada = true;
                                c.PeriodosEvaluacionesAInsertar.Add(recu);

                                if (c.stHorarioAlumno.stHorario.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre == "PROFESIONAL")
                                {
                                    Acreditacion_stPeriodoCalificacion ee = new Acreditacion_stPeriodoCalificacion();
                                    ee.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                    ee.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(6).IdCursoPeriodoMomento;
                                    ee.Calificacion = c.CalificacionNPoReprobatoria;
                                    ee.rptCalificacion = c.CalificacionCadena(ee.Calificacion, TipoPromedio.Periodo);


                                    ee.EsNp = false;
                                    ee.EsReprobada = true;
                                    c.PeriodosEvaluacionesAInsertar.Add(ee);
                                }

                            }
                            else
                                if ((c.EvaluacionesDelAlumno.ElementAt(0).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(1).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(2).Calificacion > -1)
                                    && (c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == true || c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == true || c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == true))
                                {
                                    Acreditacion_stPeriodoCalificacion recu = new Acreditacion_stPeriodoCalificacion();
                                    recu.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                    recu.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(3).IdCursoPeriodoMomento;
                                    recu.Calificacion = c.CalificacionNPoReprobatoria;
                                    recu.rptCalificacion = c.CalificacionCadena(recu.Calificacion, TipoPromedio.Periodo);


                                    recu.EsNp = false;
                                    recu.EsReprobada = true;
                                    c.PeriodosEvaluacionesAInsertar.Add(recu);

                                    if (c.stHorarioAlumno.stHorario.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre == "PROFESIONAL")
                                    {
                                        Acreditacion_stPeriodoCalificacion ee = new Acreditacion_stPeriodoCalificacion();
                                        ee.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                        ee.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(6).IdCursoPeriodoMomento;
                                        ee.Calificacion = c.CalificacionNPoReprobatoria;
                                        ee.rptCalificacion = c.CalificacionCadena(ee.Calificacion, TipoPromedio.Periodo);


                                        ee.EsNp = false;
                                        ee.EsReprobada = true;
                                        c.PeriodosEvaluacionesAInsertar.Add(ee);
                                    }

                                }

                        }
                    }

                }
            }
            else
                if (c.EvaluacionesDelAlumno.ElementAt(0).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(1).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(2).EsNp == true)
                {

                    evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                    evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                    evaluacion.Calificacion = c.CalificacionNPoReprobatoria;
                    evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);


                    evaluacion.EsNp = true;
                    evaluacion.EsReprobada = true;

                    regresa = true;
                }

            return regresa;


        }


        /// <summary>
        /// Determina si acredito en el periodo Ordinario_recuperacion
        /// </summary>
        /// <param name="c"></param>
        /// <returns></returns>
        private bool AprobacionReprobacionEnRecuperacion(ReglamentoEvaluacion c, ref Acreditacion_stPeriodoCalificacion evaluacion)
        {

            bool regresa = false;
            //recuperaciones
            if (c.EvaluacionesDelAlumno.ElementAt(0).EsNp == false && c.EvaluacionesDelAlumno.ElementAt(1).EsNp == false && c.EvaluacionesDelAlumno.ElementAt(2).EsNp == false)
            {
                if ((c.EvaluacionesDelAlumno.ElementAt(0).EsNp == false || c.EvaluacionesDelAlumno.ElementAt(1).EsNp == false || c.EvaluacionesDelAlumno.ElementAt(2).EsNp == false) && (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == true || c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == true || c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == true))
                {
                    if (c.EvaluacionesDelAlumno.ElementAt(0).Calificacion > c.CalificacionReprobatoria && c.EvaluacionesDelAlumno.ElementAt(1).Calificacion > c.CalificacionReprobatoria && c.EvaluacionesDelAlumno.ElementAt(2).Calificacion > c.CalificacionReprobatoria)
                    {
                        evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                        evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                        evaluacion.Calificacion = FormatearPromedio((decimal)(c.EvaluacionesDelAlumno.ElementAt(0).Calificacion + c.EvaluacionesDelAlumno.ElementAt(1).Calificacion + c.EvaluacionesDelAlumno.ElementAt(2).Calificacion) / 3, TipoPromedio.Periodo);
                        evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);
                        evaluacion.EsNp = false;
                        evaluacion.EsReprobada = false;


                        regresa = true;
                    }
                    else
                    {
                        decimal sumacalificaciones = 0;
                        bool haynp = false;

                        //recuperaciones
                        int totalaprobadas = 0;
                        int califcompletas = 0;
                        if (c.EvaluacionesDelAlumno.ElementAt(0).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(1).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(2).Calificacion > -1)
                        {
                            califcompletas = 3;

                            if (c.EvaluacionesDelAlumno.ElementAt(0).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(1).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(2).EsNp == true)
                                haynp = true;

                            if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(0).Calificacion;
                            }

                            if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(1).Calificacion;
                            }

                            if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(2).Calificacion;
                            }
                        }


                        if (c.EvaluacionesDelAlumno.ElementAt(3).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(4).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(5).EsNp == true)
                            haynp = true;

                        if (c.EvaluacionesDelAlumno.ElementAt(3).Calificacion > -1)
                        {
                            califcompletas = califcompletas + 1;
                            if (c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(3).Calificacion;
                            }
                        }

                        if (c.EvaluacionesDelAlumno.ElementAt(4).Calificacion > -1)
                        {
                            califcompletas = califcompletas + 1;
                            if (c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                            } sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(4).Calificacion;
                        }

                        if (c.EvaluacionesDelAlumno.ElementAt(5).Calificacion > -1)
                        {
                            califcompletas = califcompletas + 1;
                            if (c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(5).Calificacion;
                            }
                        }

                        //acompleta las 6 evaluaciones si es qeu no requerie califiacion en una R
                        if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(3).Calificacion == -1)
                        {
                            califcompletas = califcompletas + 1;
                        }
                        if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(4).Calificacion == -1)
                        {
                            califcompletas = califcompletas + 1;
                        }

                        if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(5).Calificacion == -1)
                        {
                            califcompletas = califcompletas + 1;
                        }
                        //fin acompleta 


                        if (totalaprobadas > 2)
                        {
                            evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                            evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                            evaluacion.Calificacion = FormatearPromedio((decimal)(c.EvaluacionesDelAlumno.ElementAt(0).Calificacion + c.EvaluacionesDelAlumno.ElementAt(1).Calificacion + c.EvaluacionesDelAlumno.ElementAt(2).Calificacion) / 3, TipoPromedio.Periodo);
                            evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);

                            evaluacion.EsNp = haynp;
                            evaluacion.EsReprobada = false;
                            regresa = true;
                        }
                        else
                            if (califcompletas == 6)
                            {
                                evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                                evaluacion.Calificacion = c.CalificacionNPoReprobatoria;
                                evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);


                                evaluacion.EsNp = haynp;
                                evaluacion.EsReprobada = true;

                                regresa = true;
                            }




                    }

                }
                else
                {
                    if (c.EvaluacionesDelAlumno.ElementAt(0).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(1).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(2).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(3).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(4).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(5).Calificacion > -1)
                    {
                        if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == true || c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == true || c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == true)
                        {
                            evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                            evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                            evaluacion.Calificacion = c.CalificacionNPoReprobatoria;
                            evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);


                            evaluacion.EsNp = false;
                            evaluacion.EsReprobada = true;

                            regresa = true;
                        }
                    }

                }
            }
            else
                if (c.EvaluacionesDelAlumno.ElementAt(0).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(1).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(2).EsNp == true)
                {

                    evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                    evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                    evaluacion.Calificacion = c.CalificacionNPoReprobatoria;
                    evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);


                    evaluacion.EsNp = true;
                    evaluacion.EsReprobada = true;

                    regresa = true;
                }

            return regresa;


        }




        /// <summary>
        /// Determina si acredito en el periodo Regulariacion
        /// </summary>
        /// <param name="c"></param>
        /// <returns></returns>
        private bool AprobacionReprobacionEnEE(ReglamentoEvaluacion c, ref Acreditacion_stPeriodoCalificacion evaluacion)
        {

            bool regresa = false;


            if (c.EvaluacionesDelAlumno.ElementAt(6).Calificacion > -1)
            {
                
                bdAriesEntities vv = new bdAriesEntities();
                var Curp = c.EvaluacionesDelAlumno.ElementAt(6).stHorarioAlumno.Curp;
                var Matricula = c.EvaluacionesDelAlumno.ElementAt(6).stHorarioAlumno.Matricula;
                var IdCicloEscolar = c.EvaluacionesDelAlumno.ElementAt(6).stHorarioAlumno.stHorario.IdCicloEscolar;
                var IdPlanEstudioAsignatura = c.EvaluacionesDelAlumno.ElementAt(6).stHorarioAlumno.stHorario.IdPlanEstudioAsignatura;
                var IdMomentoEvaluacion = c.EvaluacionesDelAlumno.ElementAt(6).IdMomentoEvaluacion;
                if (c.EvaluacionesDelAlumno.ElementAt(6).EsReprobadaSinPago == false && c._Acreditacion_stMomentoEvaluacion.ElementAt(6).RequierePago == true)
                {
                    var existepago = vv.stPagosServiciosAsignaturas.Join(vv.stPagosServicios, a => new { a.IdOrden, a.IdCampus }, b => new { b.IdOrden, b.IdCampus }, (a, b) => new { stAsignaturas = a, stPagosServicios = b })
                                                                .Where(f => f.stAsignaturas.ptOrdenes.Curp == Curp && f.stAsignaturas.ptOrdenes.ctAlumnos.Matricula == Matricula
                                                                && f.stAsignaturas.ptOrdenes.IdCicloEscolar == IdCicloEscolar && f.stAsignaturas.IdPlanEstudioAsignatura == IdPlanEstudioAsignatura
                                                                && f.stAsignaturas.IdMomentoEvaluacion == IdMomentoEvaluacion && f.stPagosServicios.ptOrdenes.FechaPago.HasValue).Select(g => g.stAsignaturas.IdOrden).ToList();
                    if (existepago.Count == 0)
                    {
                        throw new Exception("No existe un pago registrado para " + c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.ctAlumnos.Nombre + " " + c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.ctAlumnos.ApPaterno + " " + c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.ctAlumnos.ApMaterno);
                    }

                }

                //long idhorarioalumnotempo = (long)c.EvaluacionesDelAlumno.ElementAt(6).IdHorarioAlumno;
                //if (c.PeriodosEvaluacionesAInsertar.Where(r => r.IdHorarioAlumno==idhorarioalumnotempo  && r.IdCursoPeriodoMomento == c.EvaluacionesDelAlumno.ElementAt(6).IdCursoPeriodoMomento).ToList().Count == 0)
                //{
                    evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(6).IdHorarioAlumno;
                    evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(6).IdCursoPeriodoMomento;
                    evaluacion.Calificacion = (decimal)c.EvaluacionesDelAlumno.ElementAt(6).Calificacion;
                    evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);

                    evaluacion.EsNp = (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsNp;

                    evaluacion.EsReprobada = (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada;
                //}
                regresa = true;



            }



            return regresa;


        }


        /// <summary>
        /// Determina si acredito en el periodo Regulariacion
        /// </summary>
        /// <param name="c"></param>
        /// <returns></returns>
        private bool AprobacionReprobacionEnCI(ReglamentoEvaluacion c, ref Acreditacion_stPeriodoCalificacion evaluacion)
        {

            bool regresa = false;


            if (c.EvaluacionesDelAlumno.ElementAt(7).Calificacion > -1)
            {
                bdAriesEntities vv = new bdAriesEntities();
                var Curp = c.EvaluacionesDelAlumno.ElementAt(7).stHorarioAlumno.Curp;
                var Matricula = c.EvaluacionesDelAlumno.ElementAt(7).stHorarioAlumno.Matricula;
                var IdCicloEscolar = c.EvaluacionesDelAlumno.ElementAt(7).stHorarioAlumno.stHorario.IdCicloEscolar;
                var IdPlanEstudioAsignatura = c.EvaluacionesDelAlumno.ElementAt(7).stHorarioAlumno.stHorario.IdPlanEstudioAsignatura;
                var IdMomentoEvaluacion = c.EvaluacionesDelAlumno.ElementAt(7).IdMomentoEvaluacion;

                if (c.EvaluacionesDelAlumno.ElementAt(7).EsReprobadaSinPago == false && c._Acreditacion_stMomentoEvaluacion.ElementAt(7).RequierePago == true)
                {
                    var existepago = vv.stPagosServiciosAsignaturas.Join(vv.stPagosServicios, a => new { a.IdOrden, a.IdCampus }, b => new { b.IdOrden, b.IdCampus }, (a, b) => new { stAsignaturas = a, stPagosServicios = b })
                                                                .Where(f => f.stAsignaturas.ptOrdenes.Curp == Curp && f.stAsignaturas.ptOrdenes.ctAlumnos.Matricula == Matricula
                                                                && f.stAsignaturas.ptOrdenes.IdCicloEscolar == IdCicloEscolar && f.stAsignaturas.IdPlanEstudioAsignatura == IdPlanEstudioAsignatura
                                                                && f.stAsignaturas.IdMomentoEvaluacion == IdMomentoEvaluacion && f.stPagosServicios.ptOrdenes.FechaPago.HasValue).Select(g => g.stAsignaturas.IdOrden).ToList();
                    if (existepago.Count == 0)
                    {
                        throw new Exception("No existe un pago registrado para " + c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.ctAlumnos.Nombre + " " + c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.ctAlumnos.ApPaterno + " " + c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.ctAlumnos.ApMaterno);
                    }

                }
                evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(7).IdHorarioAlumno;
                evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(7).IdCursoPeriodoMomento;
                evaluacion.Calificacion = (decimal)c.EvaluacionesDelAlumno.ElementAt(7).Calificacion;
                evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);

                evaluacion.EsNp = (bool)c.EvaluacionesDelAlumno.ElementAt(7).EsNp;

                evaluacion.EsReprobada = (bool)c.EvaluacionesDelAlumno.ElementAt(7).EsReprobada;
                regresa = true;
            }

            return regresa;

        }



        /// <summary>
        /// De todas la calificaciones primero se determina cuales son capturadas erronamente segun el reglamento y se eliminan antes de comenzar el proceso de evaluación
        /// </summary>
        /// <param name="c"></param>
        private void GenerarEliminaciones(ReglamentoEvaluacion c, long idhorarioalumno)
        {

            bool segrabounNPEE = false;
            bool NohayNPenbd = true;

            bool NOhayEEPorNP = true;

            if (c.stMomentoEvaluacionCalificacionBaseDatos.Where(h => h.IdHorarioAlumno == idhorarioalumno && h.EsNp == true).ToList().Count > 0)
            {
                NohayNPenbd = false;

                if (c.stMomentoEvaluacionCalificacionBaseDatos.Where(e => e.IdHorarioAlumno == idhorarioalumno && e.Nombre == "EE").ToList().Count > 0)
                    NOhayEEPorNP = false;
            }
  
            bool NpP1 = false;
            bool NpP2 = false;
            bool NpP3 = false;

            bool SehanGrabadoPeriodos= false;

            var p1 = c.stMomentoEvaluacionCalificacionBaseDatos.Where(e => e.IdHorarioAlumno == idhorarioalumno && e.EsNp==true &&  e.Nombre == "P1").FirstOrDefault();


            if (p1 != null)
                if (c.EvaluacionesDelAlumno.ElementAt(0).IdMomentoEvaluacionCalificacion !=-1)
                    NpP1 = true;

            var p2 = c.stMomentoEvaluacionCalificacionBaseDatos.Where(e => e.IdHorarioAlumno == idhorarioalumno && e.EsNp == true && e.Nombre == "P2").FirstOrDefault();

            // bool NpP1 = false;
            if (p2 != null)
                if (c.EvaluacionesDelAlumno.ElementAt(1).IdMomentoEvaluacionCalificacion != -1)
                    NpP2 = true;

            var p3 = c.stMomentoEvaluacionCalificacionBaseDatos.Where(e => e.IdHorarioAlumno == idhorarioalumno && e.EsNp == true && e.Nombre == "P3").FirstOrDefault();

            //bool NpP1 = false;
            if (p3 != null)
                if (c.EvaluacionesDelAlumno.ElementAt(2).IdMomentoEvaluacionCalificacion != -1)
                    NpP3 = true;

            //PARCIAL 1
            if (c.EvaluacionesDelAlumno.ElementAt(0).Calificacion == -1)
            {
              

                if (NOhayEEPorNP || (NpP1))
                {
                    if (NOhayEEPorNP)
                    {
                        c.ObtenerEvaluacionAEliminar("EE", false, true, idhorarioalumno);

                        c.ObtenerEvaluacionAEliminar("CI", false, true, idhorarioalumno);
                    }
                }
                else
                    if (!NpP1 )
                {
                    Acreditacion_stPeriodoCalificacion ordi = new Acreditacion_stPeriodoCalificacion();
                    ordi.IdHorarioAlumno = c.stHorarioAlumno.IdHorarioAlumno;
                    ordi.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                    ordi.Calificacion = c.CalificacionNPoReprobatoria;
                    ordi.rptCalificacion = c.CalificacionCadena(ordi.Calificacion, TipoPromedio.Periodo);


                    ordi.EsNp = true;
                    ordi.EsReprobada = true;
                    c.PeriodosEvaluacionesAInsertar.Add(ordi);

                    Acreditacion_stPeriodoCalificacion rec = new Acreditacion_stPeriodoCalificacion();
                    rec.IdHorarioAlumno = c.stHorarioAlumno.IdHorarioAlumno;
                    rec.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(3).IdCursoPeriodoMomento;
                    rec.Calificacion = c.CalificacionNPoReprobatoria;
                    rec.rptCalificacion = c.CalificacionCadena(rec.Calificacion, TipoPromedio.Periodo);


                    rec.EsNp = true;
                    rec.EsReprobada = true;
                    c.PeriodosEvaluacionesAInsertar.Add(rec);

                    Acreditacion_stPeriodoCalificacion ee = new Acreditacion_stPeriodoCalificacion();
                    ee.IdHorarioAlumno = c.stHorarioAlumno.IdHorarioAlumno;
                    ee.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(6).IdCursoPeriodoMomento;
                    ee.Calificacion = c.CalificacionNPoReprobatoria;
                    ee.rptCalificacion = c.CalificacionCadena(ee.Calificacion, TipoPromedio.Periodo);
                    

                    ee.EsNp = true;
                    ee.EsReprobada = true;
                    c.PeriodosEvaluacionesAInsertar.Add(ee);
                    SehanGrabadoPeriodos = true;


                }
                if (NohayNPenbd)
                    c.ObtenerEvaluacionAEliminar("EE", false, false, idhorarioalumno);


            }

            if (c.EvaluacionesDelAlumno.ElementAt(1).Calificacion == -1)
            {
                

                if (NOhayEEPorNP || (NpP2))
                {
                   

                    if (NOhayEEPorNP)
                    {
                        c.ObtenerEvaluacionAEliminar("P2", false, true, idhorarioalumno);
                        c.ObtenerEvaluacionAEliminar("EE", false, true, idhorarioalumno);
                        c.ObtenerEvaluacionAEliminar("CI", false, true, idhorarioalumno);
                     
                    }
                }
                else
                    if (!SehanGrabadoPeriodos)
                                     {
                    Acreditacion_stPeriodoCalificacion ordi = new Acreditacion_stPeriodoCalificacion();
                    ordi.IdHorarioAlumno = c.stHorarioAlumno.IdHorarioAlumno;
                    ordi.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(1).IdCursoPeriodoMomento;
                    ordi.Calificacion = c.CalificacionNPoReprobatoria;
                    ordi.rptCalificacion = c.CalificacionCadena(ordi.Calificacion, TipoPromedio.Periodo);


                    ordi.EsNp = true;
                    ordi.EsReprobada = true;
                    c.PeriodosEvaluacionesAInsertar.Add(ordi);

                    Acreditacion_stPeriodoCalificacion rec = new Acreditacion_stPeriodoCalificacion();
                    rec.IdHorarioAlumno = c.stHorarioAlumno.IdHorarioAlumno;
                    rec.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(3).IdCursoPeriodoMomento;
                    rec.Calificacion = c.CalificacionNPoReprobatoria;
                    rec.rptCalificacion = c.CalificacionCadena(rec.Calificacion, TipoPromedio.Periodo);


                    rec.EsNp = true;
                    rec.EsReprobada = true;
                    c.PeriodosEvaluacionesAInsertar.Add(rec);

                    Acreditacion_stPeriodoCalificacion ee = new Acreditacion_stPeriodoCalificacion();
                    ee.IdHorarioAlumno = c.stHorarioAlumno.IdHorarioAlumno;
                    ee.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(6).IdCursoPeriodoMomento;
                    ee.Calificacion = c.CalificacionNPoReprobatoria;
                    ee.rptCalificacion = c.CalificacionCadena(ee.Calificacion, TipoPromedio.Periodo);


                    ee.EsNp = true;
                    ee.EsReprobada = true;
                    c.PeriodosEvaluacionesAInsertar.Add(ee);
                    SehanGrabadoPeriodos = true;


                }
                if (NohayNPenbd)
                    c.ObtenerEvaluacionAEliminar("EE", false, false, idhorarioalumno);


            }

            if (c.EvaluacionesDelAlumno.ElementAt(2).Calificacion == -1)
            {
                

                if (NOhayEEPorNP || (NpP3))
                {


                    if (NOhayEEPorNP)
                    {
                        c.ObtenerEvaluacionAEliminar("P3", false, true, idhorarioalumno);
                        c.ObtenerEvaluacionAEliminar("EE", false, true, idhorarioalumno);
                        c.ObtenerEvaluacionAEliminar("CI", false, true, idhorarioalumno);
                    }
                }
                else
                    if (!SehanGrabadoPeriodos)
                {
                    Acreditacion_stPeriodoCalificacion ordi = new Acreditacion_stPeriodoCalificacion();
                    ordi.IdHorarioAlumno = c.stHorarioAlumno.IdHorarioAlumno;
                    ordi.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(2).IdCursoPeriodoMomento;
                    ordi.Calificacion = c.CalificacionNPoReprobatoria;
                    ordi.rptCalificacion = c.CalificacionCadena(ordi.Calificacion, TipoPromedio.Periodo);


                    ordi.EsNp = true;
                    ordi.EsReprobada = true;
                    c.PeriodosEvaluacionesAInsertar.Add(ordi);

                    Acreditacion_stPeriodoCalificacion rec = new Acreditacion_stPeriodoCalificacion();
                    rec.IdHorarioAlumno = c.stHorarioAlumno.IdHorarioAlumno;
                    rec.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(3).IdCursoPeriodoMomento;
                    rec.Calificacion = c.CalificacionNPoReprobatoria;
                    rec.rptCalificacion = c.CalificacionCadena(rec.Calificacion, TipoPromedio.Periodo);


                    rec.EsNp = true;
                    rec.EsReprobada = true;
                    c.PeriodosEvaluacionesAInsertar.Add(rec);

                    Acreditacion_stPeriodoCalificacion ee = new Acreditacion_stPeriodoCalificacion();
                    ee.IdHorarioAlumno = c.stHorarioAlumno.IdHorarioAlumno;
                    ee.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(6).IdCursoPeriodoMomento;
                    ee.Calificacion = c.CalificacionNPoReprobatoria;
                    ee.rptCalificacion = c.CalificacionCadena(ee.Calificacion, TipoPromedio.Periodo);


                    ee.EsNp = true;
                    ee.EsReprobada = true;
                    c.PeriodosEvaluacionesAInsertar.Add(ee);
                    SehanGrabadoPeriodos = true;


                }
                if (NohayNPenbd)
                    c.ObtenerEvaluacionAEliminar("EE", false, false, idhorarioalumno);


            }
            //if (c.EvaluacionesDelAlumno.ElementAt(1).Calificacion == -1 && NohayNPenbd)
            //{
            //    if (NOhayEEPorNP)
            //    c.ObtenerEvaluacionAEliminar("P2", false, false, idhorarioalumno);
            //    if (NohayNPenbd )
            //        c.ObtenerEvaluacionAEliminar("EE", false, false, idhorarioalumno);
            //}

            //else
            //    if (c.EvaluacionesDelAlumno.ElementAt(1).Calificacion == -1 && NohayNPenbd == false)
            //    {
            //        c.ObtenerEvaluacionAEliminar("P3", false, false, idhorarioalumno);
            //        c.ObtenerEvaluacionAEliminar("EE", false, false, idhorarioalumno);
            //    }


            //if (c.EvaluacionesDelAlumno.ElementAt(2).Calificacion == -1 && NohayNPenbd)
            //{
            //    if (NOhayEEPorNP)
            //    c.ObtenerEvaluacionAEliminar("P3", false, false, idhorarioalumno);
            //    if (NohayNPenbd )
            //        c.ObtenerEvaluacionAEliminar("EE", false, false, idhorarioalumno);
            //}

            //else
            //    if (c.EvaluacionesDelAlumno.ElementAt(2).Calificacion == -1 && NohayNPenbd==false)
            //    {
            //            c.ObtenerEvaluacionAEliminar("P3", false, false, idhorarioalumno);
            //            c.ObtenerEvaluacionAEliminar("EE", false, false, idhorarioalumno);
            //    }

            if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false)
            {
                c.ObtenerEvaluacionAEliminar("R1", true, false, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("R1", false, false, idhorarioalumno);
            }

            if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false)
            {
                c.ObtenerEvaluacionAEliminar("R2", true, false, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("R2", false, false, idhorarioalumno);
            }
            if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false)
            {
                c.ObtenerEvaluacionAEliminar("R3", true, false, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("R3", false, false, idhorarioalumno);
            }

            //if (c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == false)


            if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == false)
                c.ObtenerEvaluacionAEliminar("R1", false, false, idhorarioalumno);
            else
                if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada != true && c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada != false)
                    c.ObtenerEvaluacionAEliminar("R1", (bool)c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada, idhorarioalumno);





            //PARCIAL 2
            if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == false)
                c.ObtenerEvaluacionAEliminar("R2", false, false, idhorarioalumno);
            else
                if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada != true && c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada != false)
                    c.ObtenerEvaluacionAEliminar("R2", (bool)c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada, idhorarioalumno);

            //PARCIAL 3

            if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == false)
                c.ObtenerEvaluacionAEliminar("R3", false, false, idhorarioalumno);
            else
                if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada != true && c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada != false)
                    c.ObtenerEvaluacionAEliminar("R3", (bool)c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada, idhorarioalumno);



            if (c.EvaluacionesDelAlumno.ElementAt(2).Calificacion == -1 && c.EvaluacionesDelAlumno.ElementAt(5).Calificacion > -1)
                c.ObtenerEvaluacionAEliminar("R3", true, true, idhorarioalumno);


            //EE
            if (c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == true || c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == true || c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == true)
            {

                if (c.EvaluacionesDelAlumno.ElementAt(6).Calificacion == -1)
                    c.ObtenerEvaluacionAEliminar("EE", false, (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada, idhorarioalumno);


                if (c.EvaluacionesDelAlumno.ElementAt(6).Calificacion > -1)
                {
                    if (c.stHorarioAlumno.stHorario.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre != "PROFESIONAL")
                    {
                         if (c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada == false)
                        {
                            c.ObtenerEvaluacionAEliminar("CI", true, false, idhorarioalumno);
                            c.ObtenerEvaluacionAEliminar("CI", false, false, idhorarioalumno);
                        }
                    
                    }
                    else
                    {
                        // if (c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada == false)
                        //{
                        c.ObtenerEvaluacionAEliminar("EE", false, false, idhorarioalumno);

                        //}
                        Acreditacion_stMomentoEvaluacionCalificacion info = new Acreditacion_stMomentoEvaluacionCalificacion();
                        info.Calificacion = c.CalificacionNPoReprobatoria;
                        info.EsDefinitiva = true;
                        info.EsReprobada = true;
                        info.EsNp = false;
                        info.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                        info.rptCalificacion = c.CalificacionCadena((decimal)info.Calificacion, TipoPromedio.Evaluacion);
                        info.IdMomentoEvaluacion = (short)c.EvaluacionesDelAlumno.ElementAt(6).IdMomentoEvaluacion;
                        info.EsReprobadaSinPago = true;
                        segrabounNPEE = true;

                        c.EvaluacionesAInsertar.Add(info);

                        if (c.EvaluacionesDelAlumno.ElementAt(7).Calificacion == -1)
                            c.ObtenerEvaluacionAEliminar("CI", true, true, idhorarioalumno);
                    }

                }
                else

                    if (c.stHorarioAlumno.stHorario.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre == "PROFESIONAL")
                    {
                        //bdAriesEntities context = new bdAriesEntities();

                        //    Acreditacion_stMomentoEvaluacionCalificacion existemodulo = context.Acreditacion_stMomentoEvaluacionCalificacion.Where(q => q.IdHorarioAlumno==(long) c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno
                        //        && q.IdMomentoEvaluacion==c.EvaluacionesDelAlumno.ElementAt(6).IdMomentoEvaluacion ).FirstOrDefault();
                        //    context.Configuration.AutoDetectChangesEnabled = false;
                        //    context.Configuration.ValidateOnSaveEnabled = false;

                        //    if (existemodulo == null)
                        //    {
                        //agrega por defualt el 5 para un submodulo
                        Acreditacion_stMomentoEvaluacionCalificacion info = new Acreditacion_stMomentoEvaluacionCalificacion();
                        info.Calificacion = c.CalificacionNPoReprobatoria;
                        info.EsDefinitiva = true;
                        info.EsReprobada = true;
                        info.EsNp = false;
                        info.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                        info.rptCalificacion = c.CalificacionCadena((decimal)info.Calificacion, TipoPromedio.Evaluacion);
                        info.IdMomentoEvaluacion = (short)c.EvaluacionesDelAlumno.ElementAt(6).IdMomentoEvaluacion;
                        info.EsReprobadaSinPago = true;
                        segrabounNPEE = true;
                        c.EvaluacionesAInsertar.Add(info);
                        // }
                    }
            }

            //aprobo en parcial
            if (c.EvaluacionesDelAlumno.ElementAt(0).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(1).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(2).Calificacion > -1)
                if ((c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false))
                {

                    c.ObtenerEvaluacionAEliminar("EE", false, (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada, idhorarioalumno);
                    c.ObtenerEvaluacionAEliminar("CI", true, false, idhorarioalumno);

                }

            int totalaprobadasordinario = 0;
            if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(0).Calificacion > -1)
                totalaprobadasordinario = totalaprobadasordinario + 1;
            if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(1).Calificacion > -1)
                totalaprobadasordinario = totalaprobadasordinario + 1;
            if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(2).Calificacion > -1)
                totalaprobadasordinario = totalaprobadasordinario + 1;
            if (c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(3).Calificacion > -1)
                totalaprobadasordinario = totalaprobadasordinario + 1;
            if (c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(4).Calificacion > -1)
                totalaprobadasordinario = totalaprobadasordinario + 1;
            if (c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(5).Calificacion > -1)
                totalaprobadasordinario = totalaprobadasordinario + 1;

            if (totalaprobadasordinario >= 3)
            {

                c.ObtenerEvaluacionAEliminar("EE", false, (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("EE", true, false, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("CI", false, (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("CI", true, false, idhorarioalumno);

            }


            //especial
            if (c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada == false)
            {
                if (c.EvaluacionesDelAlumno.ElementAt(6).Calificacion == -1 && c.stHorarioAlumno.stHorario.stPlanEstudioAsignatura.ctAsignatura.ctTipoComponente.Nombre != "PROFESIONAL")
                {
                    if (NohayNPenbd)
                    {
                        c.ObtenerEvaluacionAEliminar("CI", false, (bool)c.EvaluacionesDelAlumno.ElementAt(7).EsReprobada, idhorarioalumno);
                        c.ObtenerEvaluacionAEliminar("CI", true, false, idhorarioalumno);
                    }
                }

            }

            //aprobo en parcial
            if (c.EvaluacionesDelAlumno.ElementAt(0).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(1).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(2).Calificacion > -1)
                if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false)
                {

                    c.ObtenerEvaluacionAEliminar("CI", false, (bool)c.EvaluacionesDelAlumno.ElementAt(7).EsReprobada, idhorarioalumno);

                }

            if (c.EvaluacionesDelAlumno.ElementAt(0).EsNp == true)
            {
                c.ObtenerEvaluacionAEliminar("P2", false, false, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("P3", false, false, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("R1", (bool)c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("R2", (bool)c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("R3", (bool)c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("EE", false, (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("EE", true, false, idhorarioalumno);

                //if (segrabounNPEE)
                //{
                //    c.EvaluacionesAInsertar.Where(r => r.IdMomentoEvaluacion == (short)c.EvaluacionesDelAlumno.ElementAt(6).IdMomentoEvaluacion).FirstOrDefault().EsNp = true;
                //}
                //else
                if (!segrabounNPEE)
                {
                    Acreditacion_stMomentoEvaluacionCalificacion info = new Acreditacion_stMomentoEvaluacionCalificacion();
                    info.Calificacion = c.CalificacionNPoReprobatoria;
                    info.EsDefinitiva = true;
                    info.EsReprobada = true;
                    info.EsNp = true;
                    info.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                    info.rptCalificacion = c.CalificacionCadena((decimal)info.Calificacion, TipoPromedio.Evaluacion);
                    info.IdMomentoEvaluacion = (short)c.EvaluacionesDelAlumno.ElementAt(6).IdMomentoEvaluacion;
                    info.EsReprobadaSinPago = true;
                    c.EvaluacionesAInsertar.Add(info);
                }
                if (NOhayEEPorNP)
                {
                    c.ObtenerEvaluacionAEliminar("CI", false, (bool)c.EvaluacionesDelAlumno.ElementAt(7).EsReprobada, idhorarioalumno);
                    c.ObtenerEvaluacionAEliminar("CI", true, false, idhorarioalumno);
                }
            }

            if (c.EvaluacionesDelAlumno.ElementAt(1).EsNp == true)
            {

                c.ObtenerEvaluacionAEliminar("P3", false, false, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("R2", (bool)c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("R3", (bool)c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("EE", false, (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("EE", true, false, idhorarioalumno);
                //if (segrabounNPEE)
                //{
                //    c.EvaluacionesAInsertar.Where(r => r.IdMomentoEvaluacion == (short)c.EvaluacionesDelAlumno.ElementAt(6).IdMomentoEvaluacion).FirstOrDefault().EsNp = true;
                //}
                //else
                if (!segrabounNPEE)
                {
                    Acreditacion_stMomentoEvaluacionCalificacion info = new Acreditacion_stMomentoEvaluacionCalificacion();
                    info.Calificacion = c.CalificacionNPoReprobatoria;
                    info.EsDefinitiva = true;
                    info.EsReprobada = true;
                    info.EsNp = true;
                    info.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                    info.rptCalificacion = c.CalificacionCadena((decimal)info.Calificacion, TipoPromedio.Evaluacion);
                    info.IdMomentoEvaluacion = (short)c.EvaluacionesDelAlumno.ElementAt(6).IdMomentoEvaluacion;
                    info.EsReprobadaSinPago = true;
                    c.EvaluacionesAInsertar.Add(info);
                }
                if (NOhayEEPorNP)
                {
                    c.ObtenerEvaluacionAEliminar("CI", false, (bool)c.EvaluacionesDelAlumno.ElementAt(7).EsReprobada, idhorarioalumno);
                    c.ObtenerEvaluacionAEliminar("CI", true, false, idhorarioalumno);
                }
            }

            if (c.EvaluacionesDelAlumno.ElementAt(2).EsNp == true)
            {

                c.ObtenerEvaluacionAEliminar("R3", (bool)c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("EE", false, (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("EE", true, false, idhorarioalumno);
                //if (segrabounNPEE)
                //{
                //    c.EvaluacionesAInsertar.Where(r => r.IdMomentoEvaluacion == (short)c.EvaluacionesDelAlumno.ElementAt(6).IdMomentoEvaluacion).FirstOrDefault().EsNp = true;
                //}
                //else
                if (!segrabounNPEE)
                {
                    Acreditacion_stMomentoEvaluacionCalificacion info = new Acreditacion_stMomentoEvaluacionCalificacion();
                    info.Calificacion = c.CalificacionNPoReprobatoria;
                    info.EsDefinitiva = true;
                    info.EsReprobada = true;
                    info.EsNp = true;
                    info.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                    info.rptCalificacion = c.CalificacionCadena((decimal)info.Calificacion, TipoPromedio.Evaluacion);
                    info.IdMomentoEvaluacion = (short)c.EvaluacionesDelAlumno.ElementAt(6).IdMomentoEvaluacion;
                    info.EsReprobadaSinPago = true;
                    c.EvaluacionesAInsertar.Add(info);
                }
                if (NOhayEEPorNP)
                {
                    c.ObtenerEvaluacionAEliminar("CI", false, (bool)c.EvaluacionesDelAlumno.ElementAt(7).EsReprobada, idhorarioalumno);
                    c.ObtenerEvaluacionAEliminar("CI", true, false, idhorarioalumno);
                }
            }

            if (c.EvaluacionesDelAlumno.ElementAt(6).EsNp == true)
            {

                c.ObtenerEvaluacionAEliminar("CI", false, (bool)c.EvaluacionesDelAlumno.ElementAt(7).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("CI", true, false, idhorarioalumno);
            }




            bdAriesEntities basedatos = new bdAriesEntities();


            var inner4 = from tt in c.Alumnos select tt.Curp;

            var finalesgrado = basedatos.Acreditacion_stAlumnosCalificacionGrado.Where(d => inner4.Contains(d.Curp)).ToList();


            var fingrado = finalesgrado.Join(c.Alumnos, x => new { x.Curp, x.IdValorCiclo, x.Matricula, x.IdCicloEscolar },
                y => new { y.Curp, y.IdValorCiclo, y.Matricula, y.IdCicloEscolar }, (x, y) => x).AsEnumerable()
                .Select(x =>

                   x.IdCalificacionGrado

                ).ToList();



            var Califfinalesgrado = basedatos.Acreditacion_stAlumnosCalificacionGrado.Where(d => fingrado.Contains(d.IdCalificacionGrado));


            basedatos.Configuration.AutoDetectChangesEnabled = false;
            basedatos.Configuration.ValidateOnSaveEnabled = false;

            foreach (var dd in Califfinalesgrado.ToList())
            {
                basedatos.Entry(dd).State = System.Data.Entity.EntityState.Deleted;


            }


            //seccion de eliminacion
            try
            {
                basedatos.SaveChanges();

            }
            catch (Exception e)
            {

                throw;
            }

            basedatos.Configuration.AutoDetectChangesEnabled = true;
            basedatos.Configuration.ValidateOnSaveEnabled = true;
        }


        public void CrearReglas(ReglamentoEvaluacion c)
        {
            c.MascaraNumericaCalificacionFinal = "99";
            c.MascaraNumericaCalificacionGrado = "99.9";
            c.MascaraNumericaCalificacionPeriodo = "99.9";

            c.CalificacionReprobatoria = 5.9M;
            c.CalificacionNPoReprobatoria = 5;
            c.MaximoSubModulosReprobadasOrdinario = 2;
            c.CalificacionMaxima = 10;
            c.CalificacionMinima = 5;
            c.MaximoReprobadasEE = 2;
            c.MaximoReprobadasCI = 2;
            c.MaximoReprobadasOrdinario = 2;
            c.MaximoReprobadasPorCiclo = 2;
            c.MaximoReprobadasPorEstancia = 10;
            c.MaximoGradoEstancia = 10;

            CalificacionesPermitidasEvaluacion califP1 = new CalificacionesPermitidasEvaluacion();
            califP1.Evaluacion = "P1";
            califP1.CalificacionMinima = 0;
            califP1.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califP1);

            CalificacionesPermitidasEvaluacion califP2 = new CalificacionesPermitidasEvaluacion();
            califP2.Evaluacion = "P2";
            califP2.CalificacionMinima = 0;
            califP2.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califP2);

            CalificacionesPermitidasEvaluacion califP3 = new CalificacionesPermitidasEvaluacion();
            califP3.Evaluacion = "P3";
            califP3.CalificacionMinima = 0;
            califP3.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califP3);

            CalificacionesPermitidasEvaluacion califR1 = new CalificacionesPermitidasEvaluacion();
            califR1.Evaluacion = "R1";
            califR1.CalificacionMinima = 0;
            califR1.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califR1);

            CalificacionesPermitidasEvaluacion califR2 = new CalificacionesPermitidasEvaluacion();
            califR2.Evaluacion = "R2";
            califR2.CalificacionMinima = 0;
            califR2.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califR2);

            CalificacionesPermitidasEvaluacion califR3 = new CalificacionesPermitidasEvaluacion();
            califR3.Evaluacion = "R3";
            califR3.CalificacionMinima = 0;
            califR3.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califR3);


            CalificacionesPermitidasEvaluacion califEE = new CalificacionesPermitidasEvaluacion();
            califEE.Evaluacion = "EE";
            califEE.CalificacionMinima = 5;
            califEE.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califEE);

            CalificacionesPermitidasEvaluacion califCI = new CalificacionesPermitidasEvaluacion();
            califCI.Evaluacion = "CI";
            califCI.CalificacionMinima = 5;
            califCI.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califCI);

            //if (c._stMomentoEvaluacionCalificacion.Where(g => g.Calificacion > (Decimal)c.CalificacionMaxima || (g.Calificacion>-1 && g.Calificacion < (Decimal)c.CalificacionMinima && g.EsNp==false)).ToList().Count > 0)
            //{
            //    throw new Exception("Existen calificaciones que no se encuentran dentro del rango permitido de " + c.CalificacionMinima +" y "+c.CalificacionMaxima);
            //}

        }

        public decimal Truncate(decimal pImporte, int pNumDecimales)
        {
            decimal wRt = 0;
            decimal wPot10 = 1;

            for (int i = 1; i <= pNumDecimales; i++)
            {
                wPot10 = wPot10 * 10;
            }

            wRt = pImporte * wPot10;
            wRt = decimal.Truncate(wRt);
            wRt = wRt / wPot10;
            wRt = decimal.Round(wRt, 2);

            return wRt;
        }
        public decimal FormatearPromedio(decimal promedio, TipoPromedio tipo, int rptdecimales = 0)
        {
            switch (tipo)
            {
                case TipoPromedio.Periodo:
                    {
                        promedio = Math.Round(promedio, 0, MidpointRounding.AwayFromZero);
                    }
                    break;
                case TipoPromedio.Final:
                    {
                        promedio = Math.Round(promedio, 0, MidpointRounding.AwayFromZero);
                    }
                    break;
                case TipoPromedio.Grado:
                    {
                        //  promedio = Math.Round(promedio, 1, MidpointRounding.AwayFromZero)
                        promedio = Truncate(promedio, 1);
                    }
                    break;
                case TipoPromedio.Evaluacion:
                    {
                        if (rptdecimales != 0)
                            promedio = Truncate(promedio, rptdecimales);
                        else
                            promedio = Truncate(promedio, 0);
                    }
                    break;
            }

            return promedio;
        }


        private void AgregaCalificacionFinal(ReglamentoEvaluacion c, Acreditacion_stPeriodoCalificacion f)
        {
            Acreditacion_stAlumnosCalificacionFinal cf = new Acreditacion_stAlumnosCalificacionFinal();

            cf.Calificacion = f.Calificacion;
            cf.Curp = c.stHorarioAlumno.Curp;
            cf.Dictaminada = false;
            cf.EsNp = f.EsNp;
            cf.EsReprobada = f.EsReprobada;
            cf.IdValorCiclo = c.stHorarioAlumno.IdValorCiclo;
            cf.Matricula = c.stHorarioAlumno.Matricula;
            cf.Renunciada = false;
            cf.rptCalificacion = c.CalificacionCadena(f.Calificacion, TipoPromedio.Final);

            cf.EsActualizacionPlanEstudio = false;
            cf.IdCampus = c.stHorarioAlumno.stHorario.ctGrupoCampus.IdCampus;
            cf.IdCicloEscolar = c.stHorarioAlumno.stHorario.IdCicloEscolar;
            cf.IdCursoPeriodoMomento = f.IdCursoPeriodoMomento;
            cf.IdGrupoNombre = c.stHorarioAlumno.stHorario.ctGrupoCampus.IdGrupoNombre;
            cf.IdPlanEstudioAsignatura = c.stHorarioAlumno.stHorario.IdPlanEstudioAsignatura;


            c.CalificacionesFinalesAInsertar.Add(cf);
        }


        private void AgregaCalificacionGrado(ReglamentoEvaluacion t, IdHorariosAlumnos c, decimal calificacion, bool esreprobada)
        {
            HorariosAlumnos horarioalumno = HorariosAlumnos.Instance;


            stHorarioAlumno Alumno = horarioalumno.HorarioAlumnos.Where(p => p.Curp == c.Curp).OrderByDescending(q => q.stHorario.IdCicloEscolar).FirstOrDefault();

            Acreditacion_stAlumnosCalificacionGrado cf = new Acreditacion_stAlumnosCalificacionGrado();

            cf.Calificacion = calificacion;
            cf.Curp = Alumno.Curp;

            cf.EsReprobada = esreprobada;
            cf.IdValorCiclo = Alumno.IdValorCiclo;
            cf.Matricula = Alumno.Matricula;

            cf.rptCalificacion = t.CalificacionCadena(calificacion, TipoPromedio.Grado);


            cf.IdCampus = Alumno.ctAlumnos.IdCampus;
            cf.IdCicloEscolar = Alumno.stHorario.IdCicloEscolar;

            cf.IdGrupoNombre = Alumno.stHorario.ctGrupoCampus.IdGrupoNombre;

            bdAriesEntities bd = new bdAriesEntities();

            int totalaprobadasenEE = bd.Acreditacion_stMomentoEvaluacionCalificacion.Where(y => y.stHorarioAlumno.Curp == cf.Curp && y.stHorarioAlumno.stHorario.IdCicloEscolar == cf.IdCicloEscolar
                && (y.Acreditacion_stMomentoEvaluacion.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Extraordinario" || y.Acreditacion_stMomentoEvaluacion.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Intersemestral")).ToList().Count;

            if (totalaprobadasenEE == 0)
                cf.EsRegular = true;
            else
                cf.EsRegular = false;



            t.CalificacionesFinalGradoAInsertar.Add(cf);
        }

        private void ActualizarEstatusSingleton(ctAlumnos item)
        {

            HorariosAlumnos horarios1 = HorariosAlumnos.Instance;

            ctStatusAlumno ct = horarios1.ctStatusAlumno.Where(r => r.IdStatusAlumno == item.IdStatusAlumno).First();

            horarios1.HorarioAlumnos.Where(e => e.Curp == item.Curp).OrderByDescending(q => q.IdHorario).Select(g => g.ctAlumnos).First().ctStatusAlumno = ct;




        }
    }




}
