﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Transactions;

namespace Nova.Models
{



    class Reglamento1 : IReglamento
    {


        public void Evaluar(ReglamentoEvaluacion c)
        {

            if (c.Alumnos.Count > 0)
            {
                TransactionOptions transactionoptions1 = new TransactionOptions();
                transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
                {


                    foreach (var item in c.Alumnos)
                    {

                        c.ObtenerEvaluacionesReglamentoAlumnos(item.IdHorarioAlumno);

                        //determina qeu calificaciones solo deben de quedar en la bd
                        GenerarEliminaciones(c, item.IdHorarioAlumno);



                        //actualiza las tablas para insertar o modificar la tira de calificaciones de todo el reglamento

                        GrabarCalificacionesMomentos(c, item.IdHorarioAlumno);




                        Acreditacion_stPeriodoCalificacion f = new Acreditacion_stPeriodoCalificacion();
                        AprobacionReprobacionEnOrdinario(c, ref f);

                        if (f.EsNp)
                        {
                            GrabaUnNP(c);
                        }
                        else
                        {
                            //si la aprobo graba la final
                            if (f.IdHorarioAlumno > 0)
                                c.PeriodosEvaluacionesAInsertar.Add(f);

                            if (f.EsReprobada == false && f.IdHorarioAlumno > 0)
                            {

                                AgregaCalificacionFinal(c, f);

                            }


                            else
                            {

                                Acreditacion_stPeriodoCalificacion r = new Acreditacion_stPeriodoCalificacion();
                                AprobacionReprobacionEnRegularizacion(c, ref r);

                                if (r.IdHorarioAlumno > 0)
                                    c.PeriodosEvaluacionesAInsertar.Add(r);

                                if (r.EsReprobada == false && r.IdHorarioAlumno > 0)
                                //si la aprobo graba la final
                                {
                                    AgregaCalificacionFinal(c, r);
                                }
                                else
                                {


                                    Acreditacion_stPeriodoCalificacion e = new Acreditacion_stPeriodoCalificacion();
                                    AprobacionReprobacionEnExtraOrdinario(c, ref e);

                                    if (e.IdHorarioAlumno > 0)
                                    {

                                        c.PeriodosEvaluacionesAInsertar.Add(e);

                                        //graba la final

                                        AgregaCalificacionFinal(c, e);
                                    }

                                }

                            }

                        }
                    }

                    GrabaListasDeCalificaciones(ref c);

                    ValidarSituacionAcademica(c);



                    //Verificar cambios de estatus por numero de materias reprobadas en el ciclo escolar

                    //grabar calificaciones faltantes en su carga cuadno es una baja




                    //Verificar cambios de estatus por numero de materias reprobadas en toda su carga

                    //
                    scope.Complete();
                }

            }

        }

        private void ObtenerCalificacionesFaltantes(ReglamentoEvaluacion c, stHorarioAlumno ha, short idcursoperiodomomento)
        {


            bdAriesEntities bd = new bdAriesEntities();

            //var inner2 = from tt in c.Alumnos where ha.Curp== tt.Curp && tt.Matricula==ha.Matricula select tt;
            HorariosAlumnos horarios = HorariosAlumnos.Instance;
            List<stHorarioAlumno> HorariosdelAlumno = horarios.getHorariosPorAlumno(ha.Curp, ha.stHorario.IdCicloEscolar);
            // var inner2 = HorariosdelAlumno;


            var finales = bd.Acreditacion_stAlumnosCalificacionFinal.Where(d => d.Curp == ha.Curp && d.Matricula == ha.Matricula && d.IdCicloEscolar == ha.stHorario.IdCicloEscolar).Select(r => r.IdPlanEstudioAsignatura).ToList();



            //      var fin = HorariosdelAlumno.GroupJoin(finales,
            //x => new { x.Curp, x.stHorario.IdPlanEstudioAsignatura, x.Matricula, x.stHorario.IdCicloEscolar, x.IdValorCiclo },
            //y => new { y.Curp, y.IdPlanEstudioAsignatura, y.Matricula, y.IdCicloEscolar, y.IdValorCiclo },
            //(x, y) => new
            //{
            //    x.stHorario.IdPlanEstudioAsignatura,
            //    x.stHorario.IdCicloEscolar,
            //    x.Curp,
            //    x.Matricula,
            //    x.IdValorCiclo,



            //}).ToList();

            var tools = HorariosdelAlumno.Where(t => !finales.Contains(t.stHorario.IdPlanEstudioAsignatura)).ToList();


            foreach (var item in tools)
            {

                Acreditacion_stAlumnosCalificacionFinal cf = new Acreditacion_stAlumnosCalificacionFinal();

                var existe = c.CalificacionesFinalesAInsertar.Where(d => d.Curp == item.Curp && d.Matricula == item.Matricula && d.IdPlanEstudioAsignatura == item.stHorario.IdPlanEstudioAsignatura && d.IdCicloEscolar == item.stHorario.IdCicloEscolar && d.IdValorCiclo == item.IdValorCiclo).Select(k => k.IdPlanEstudioAsignatura).FirstOrDefault();
                if (existe == 0)
                {
                    cf.IdCicloEscolar = item.stHorario.IdCicloEscolar;
                    cf.Calificacion = c.CalificacionNPoReprobatoria;
                    cf.Curp = item.Curp;
                    cf.Dictaminada = false;
                    cf.EsActualizacionPlanEstudio = false;
                    cf.EsNp = false;
                    cf.EsReprobada = true;
                    //cf.IdCampus = item.IdCampus;
                    cf.IdCicloEscolar = item.stHorario.IdCicloEscolar;
                    cf.rptCalificacion = c.CalificacionCadena(c.CalificacionNPoReprobatoria, TipoPromedio.Final);
                    cf.Renunciada = false;
                    cf.Matricula = item.Matricula;

                    cf.IdCampus = ha.stHorario.ctGrupoCampus.IdCampus;
                    cf.IdPlanEstudioAsignatura = item.stHorario.IdPlanEstudioAsignatura;
                    cf.IdGrupoNombre = ha.stHorario.ctGrupoCampus.IdGrupoNombre;
                    cf.IdCursoPeriodoMomento = idcursoperiodomomento;

                    cf.IdValorCiclo = ha.IdValorCiclo;

                    c.CalificacionesFinalesAInsertar.Add(cf);
                }

            }

        }

        private void ValidarSituacionAcademica(ReglamentoEvaluacion c)
        {
            c.ObtenerCalificacionesTotalesPeriodosAlumnos();

            foreach (var item in c.Alumnos)
            {

                ValidarPeriodoOrdinario(c, item);
                ValidarPeriodoRegularizacion(c, item);
                ValidarPeriodoExtraOrdinario(c, item);



            }

            //GRaba en la base calificaciones finales
            // y actualiza estatus de alumnos y si son regulares o no
            GrabarBaseDatosValidacionAcedemica(c);
            //


            foreach (var item in c.Alumnos)
            {

                ValidarAsignaturasAprobadasReprobadasDelCurso(c, item);

            }

            ActualizarEstatusValidacionCalificacionesFinales(c);
        }

        private void ValidarAsignaturasAprobadasReprobadasDelCurso(ReglamentoEvaluacion c, IdHorariosAlumnos item)
        {
            HorariosAlumnos horarios = HorariosAlumnos.Instance;
            List<stHorarioAlumno> HorariosdelAlumno = horarios.getHorariosPorAlumno(item.Curp, item.IdCicloEscolar);

            stHorarioAlumno ha = HorariosdelAlumno.Where(f => f.IdHorarioAlumno == item.IdHorarioAlumno).First();

            bdAriesEntities bd = new bdAriesEntities();



            var finales = bd.Acreditacion_stAlumnosCalificacionFinal.Where(d => d.Curp == ha.Curp && d.Matricula == ha.Matricula && d.IdCicloEscolar == ha.stHorario.IdCicloEscolar && d.Renunciada == false && d.Dictaminada == false).ToList();

            int totalreprobadas = 0;
            int totalreprobadasrecursadas = 0;
            List<Acreditacion_stAlumnosCalificacionFinal> reprobadasestancia = new List<Acreditacion_stAlumnosCalificacionFinal>();
            List<stPlanEstudioAsignatura> totalAsignaturasPlan = new List<stPlanEstudioAsignatura>();
            List<Acreditacion_stAlumnosCalificacionFinal> totalFinalesEstancia = new List<Acreditacion_stAlumnosCalificacionFinal>();


            if (HorariosdelAlumno.Count == finales.Count)
            //ha terminado el curso con todas sus asignaturas
            {

                totalAsignaturasPlan = horarios.stPlanEstudioAsignatura.Where(v => v.IdPlanEstudio == finales.ElementAt(0).stPlanEstudioAsignatura.IdPlanEstudio).ToList();
                totalFinalesEstancia = bd.Acreditacion_stAlumnosCalificacionFinal.Where(d => d.Curp == ha.Curp && d.Matricula == ha.Matricula && d.EsReprobada == false && d.Renunciada == false && d.Dictaminada == false).ToList();

                reprobadasestancia = totalFinalesEstancia.Where(f => f.EsReprobada == true).ToList();

                foreach (var ele in finales)
                {


                    if (ele.EsReprobada)
                    {
                        totalreprobadas = totalreprobadas + 1;
                        bool esrecursada = HorariosdelAlumno.Where(t => t.stHorario.IdPlanEstudioAsignatura == ele.IdPlanEstudioAsignatura && t.stHorario.IdCicloEscolar == ele.IdCicloEscolar).Select(g => g.Recursada).SingleOrDefault();

                        if (esrecursada)
                        {
                            totalreprobadasrecursadas = totalreprobadasrecursadas + 1;
                        }
                    }

                }


            }


            if (totalreprobadas > 0)
            {
                ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                       .Select(e => new ctAlumnos
                       {

                           Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                           Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                           ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                           ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                           Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                           Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                           FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                           IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                           IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                           IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                           Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                           Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                           Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                           CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                           IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                           IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                           IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                           ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                           Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                           CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                           IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                           IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                           BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                           IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                           NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                           ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                           ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                           IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                           TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                           NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                           ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                           ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                           IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                           TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                           NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                           ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                           ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                           IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                           TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                           IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                           IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                           cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                           PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                           IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                           IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                           IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                           NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                           IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                           IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                           IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                           FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                           IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                           IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                           IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                           IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                           CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                           EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                           IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                           IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                           IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                           FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                           PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                           AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                           CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                           Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                           NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                           FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                           IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                           KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                           NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                           IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                           FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                           IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                           FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                           IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                           EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                           FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                           IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                           EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                           IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                           IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                           IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                           IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                           CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                           NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                           ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                           CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                           ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor

                       }).First();

                if (totalreprobadas > c.MaximoReprobadasPorCiclo)
                {


                    short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR LIMITE REPROBADAS POR CICLO").Select(f => f.IdStatusAlumno).First();
                    alumno.IdStatusAlumno = idstatusalumno;
                    c.AlumnosEstatusAActualizar.Add(alumno);

                }
                else
                    if (totalreprobadasrecursadas > 0)
                    {


                        short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR RECURSAMIENTO").Select(f => f.IdStatusAlumno).First();
                        alumno.IdStatusAlumno = idstatusalumno;
                        c.AlumnosEstatusAActualizar.Add(alumno);

                    }
                    else
                        if (reprobadasestancia.Count > c.MaximoReprobadasPorEstancia)
                        {


                            short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR LIMITE REPROBADAS POR CICLO").Select(f => f.IdStatusAlumno).First();
                            alumno.IdStatusAlumno = idstatusalumno;
                            c.AlumnosEstatusAActualizar.Add(alumno);

                        }
                        else
                        {

                            if (totalFinalesEstancia.Count > totalAsignaturasPlan.Count)
                            {
                                short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "EGRESADOS").Select(f => f.IdStatusAlumno).First();
                                alumno.IdStatusAlumno = idstatusalumno;
                                c.AlumnosEstatusAActualizar.Add(alumno);
                            }
                            else
                            {
                                short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "PARA REINSCRIPCION").Select(f => f.IdStatusAlumno).First();
                                alumno.IdStatusAlumno = idstatusalumno;
                                c.AlumnosEstatusAActualizar.Add(alumno);

                            }

                        }


            }


            // var tools = HorariosdelAlumno.Where(t => !finales.Contains(t.stHorario.IdPlanEstudioAsignatura)).ToList();




        }
        //private  void ElminarCalificacacionesPeriodoFinalesGrado()
        // {
        //       info = c._stMomentoEvaluacionCalificacion.Where(f => (f.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre== evaluacion && f.Calificacion > -1 && f.IdMomentoEvaluacionCalificacion > -1)).Select(s => new Acreditacion_stMomentoEvaluacionCalificacion { stHorarioAlumno = s.stHorarioAlumno, IdMomentoEvaluacionCalificacion = (long)s.IdMomentoEvaluacionCalificacion, IdMomentoEvaluacion = (short)s.IdMomentoEvaluacion, Calificacion = (decimal)s.Calificacion, EsDefinitiva = (bool)s.EsDefinitiva, EsNp = (bool)s.EsNp, EsReprobada = (bool)s.EsReprobada, IdHorarioAlumno = (long)s.IdHorarioAlumno, EsReprobadaSinPago = (bool)s.EsReprobadaSinPago }).SingleOrDefault();
        //       if (info != null)
        //       {
        //           bdAriesEntities bd = new bdAriesEntities();
        //           long id = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
        //           var existe = bd.Acreditacion_stMomentoEvaluacionCalificacion.Where(w => w.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre == evaluacion && w.IdHorarioAlumno == id).FirstOrDefault();
        //       }


        // }


        private void ValidarPeriodoOrdinario(ReglamentoEvaluacion c, IdHorariosAlumnos item)
        {

            HorariosAlumnos horarios = HorariosAlumnos.Instance;
            List<stHorarioAlumno> HorariosdelAlumno = horarios.getHorariosPorAlumno(item.Curp, item.IdCicloEscolar);

            var TotalesFinalesEnOrdinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Ordinario" && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();
            var totalreprobadasordinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Ordinario" && s.stHorarioAlumno.Curp == item.Curp && s.EsReprobada == true && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();



            //IRRGULARES
            if ((TotalesFinalesEnOrdinario.Count == HorariosdelAlumno.Count) && totalreprobadasordinario.Count > 0)
            {
                ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).Select(e => e.stHorarioAlumno.ctAlumnos).First();

                alumno.EsRegular = false;
                c.AlumnosIrregularesAActualizar.Add(alumno);
            }

            //VALIDACION DE REPROBADAS POR PERIODO ORDINARIO
            if ((TotalesFinalesEnOrdinario.Count == HorariosdelAlumno.Count))
            {
                if (totalreprobadasordinario.Count >= c.MaximoReprobadasOrdinario)
                {
                    ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                        .Select(e => new ctAlumnos
                        {

                            Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                            Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                            ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                            ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                            Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                            Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                            FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                            IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                            IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                            IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                            Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                            Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                            Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                            CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                            IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                            IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                            IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                            ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                            Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                            CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                            IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                            IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                            BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                            IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                            NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                            ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                            ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                            IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                            TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                            NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                            ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                            ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                            IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                            TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                            NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                            ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                            ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                            IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                            TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                            IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                            IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                            cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                            PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                            IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                            IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                            IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                            NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                            IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                            IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                            IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                            FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                            IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                            IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                            IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                            IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                            CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                            EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                            IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                            IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                            IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                            FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                            PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                            AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                            CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                            Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                            NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                            FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                            IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                            KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                            NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                            IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                            FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                            IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                            FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                            IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                            EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                            FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                            IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                            EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                            IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                            IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                            IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                            IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                            CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                            NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                            ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                            CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                            ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor

                        }).First();



                    //baja
                    short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR EXCEDER REPROBADAS EN ORDINARIO").Select(f => f.IdStatusAlumno).First();
                    var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                    if (exstatus != null)
                        c.AlumnosEstatusAActualizar.Remove(exstatus);

                    alumno.IdStatusAlumno = idstatusalumno;
                    c.AlumnosEstatusAActualizar.Add(alumno);


                }

            }
            else
            {

                if (totalreprobadasordinario.Count >= c.MaximoReprobadasOrdinario)
                {
                    ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                        .Select(e => new ctAlumnos
                        {

                            Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                            Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                            ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                            ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                            Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                            Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                            FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                            IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                            IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                            IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                            Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                            Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                            Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                            CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                            IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                            IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                            IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                            ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                            Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                            CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                            IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                            IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                            BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                            IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                            NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                            ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                            ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                            IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                            TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                            NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                            ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                            ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                            IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                            TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                            NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                            ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                            ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                            IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                            TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                            IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                            IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                            cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                            PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                            IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                            IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                            IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                            NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                            IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                            IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                            IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                            FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                            IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                            IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                            IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                            IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                            CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                            EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                            IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                            IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                            IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                            FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                            PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                            AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                            CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                            Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                            NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                            FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                            IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                            KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                            NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                            IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                            FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                            IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                            FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                            IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                            EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                            FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                            IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                            EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                            IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                            IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                            IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                            IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                            CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                            NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                            ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                            CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                            ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor

                        }).First();

                    //baja
                    short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "PARA BAJA POR REPROBADAS EN ORDINARIO").Select(f => f.IdStatusAlumno).First();
                    alumno.IdStatusAlumno = idstatusalumno;

                    var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                    if (exstatus != null)
                        c.AlumnosEstatusAActualizar.Remove(exstatus);

                    c.AlumnosEstatusAActualizar.Add(alumno);

                    stHorarioAlumno alhor = HorariosdelAlumno.Where(f => f.IdHorarioAlumno == item.IdHorarioAlumno).First();

                    ObtenerCalificacionesFaltantes(c, alhor, TotalesFinalesEnOrdinario.ElementAt(0).IdCursoPeriodoMomento);
                }

            }

        }

        private void ValidarPeriodoRegularizacion(ReglamentoEvaluacion c, IdHorariosAlumnos item)
        {

            //VALIDACION DE REPROBADAS POR PERIODO REGULARIZACION

            HorariosAlumnos horarios = HorariosAlumnos.Instance;
            List<stHorarioAlumno> HorariosdelAlumno = horarios.getHorariosPorAlumno(item.Curp, item.IdCicloEscolar);


            var TotalesReprobadasEnOrdinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Ordinario" && s.EsReprobada == true && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();

            var TotalesCalificacionesEnOrdinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Regularizacion" == true && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();

            var totalreprobadasRegularizacion = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Regularizacion" && s.stHorarioAlumno.Curp == item.Curp && s.EsReprobada == true && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();



            //IRRGULARES
            if ((TotalesReprobadasEnOrdinario.Count == TotalesCalificacionesEnOrdinario.Count) && totalreprobadasRegularizacion.Count > 0)
            {
                ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).Select(e => e.stHorarioAlumno.ctAlumnos).First();

                alumno.EsRegular = false;
                c.AlumnosIrregularesAActualizar.Add(alumno);
            }

            //VALIDACION DE REPORBADAS POR PERIODO REGULARIZACION
            if ((TotalesReprobadasEnOrdinario.Count == TotalesCalificacionesEnOrdinario.Count))
            {
                if (totalreprobadasRegularizacion.Count >= c.MaximoReprobadasRegularizacion)
                {
                    ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                        .Select(e => new ctAlumnos
                        {

                            Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                            Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                            ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                            ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                            Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                            Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                            FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                            IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                            IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                            IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                            Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                            Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                            Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                            CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                            IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                            IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                            IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                            ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                            Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                            CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                            IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                            IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                            BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                            IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                            NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                            ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                            ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                            IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                            TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                            NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                            ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                            ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                            IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                            TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                            NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                            ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                            ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                            IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                            TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                            IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                            IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                            cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                            PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                            IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                            IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                            IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                            NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                            IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                            IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                            IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                            FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                            IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                            IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                            IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                            IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                            CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                            EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                            IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                            IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                            IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                            FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                            PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                            AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                            CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                            Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                            NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                            FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                            IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                            KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                            NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                            IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                            FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                            IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                            FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                            IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                            EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                            FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                            IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                            EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                            IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                            IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                            IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                            IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                            CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                            NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                            ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                            CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                            ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor
                        }).First();

                    //baja
                    short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR EXCEDER REPROBADAS EN REGULARIZACION").Select(f => f.IdStatusAlumno).First();
                    alumno.IdStatusAlumno = idstatusalumno;
                    var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                    if (exstatus != null)
                        c.AlumnosEstatusAActualizar.Remove(exstatus);

                    c.AlumnosEstatusAActualizar.Add(alumno);


                }

            }
            else
            {

                if (totalreprobadasRegularizacion.Count >= c.MaximoReprobadasRegularizacion)
                {
                    ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                        .Select(e => new ctAlumnos
                        {

                            Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                            Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                            ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                            ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                            Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                            Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                            FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                            IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                            IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                            IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                            Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                            Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                            Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                            CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                            IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                            IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                            IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                            ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                            Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                            CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                            IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                            IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                            BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                            IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                            NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                            ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                            ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                            IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                            TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                            NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                            ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                            ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                            IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                            TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                            NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                            ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                            ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                            IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                            TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                            IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                            IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                            cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                            PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                            IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                            IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                            IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                            NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                            IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                            IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                            IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                            FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                            IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                            IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                            IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                            IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                            CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                            EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                            IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                            IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                            IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                            FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                            PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                            AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                            CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                            Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                            NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                            FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                            IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                            KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                            NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                            IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                            FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                            IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                            FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                            IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                            EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                            FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                            IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                            EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                            IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                            IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                            IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                            IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                            CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                            NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                            ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                            CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                            ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor
                        }).First();

                    //baja
                    short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "PARA BAJA POR REPROBADAS EN REGULARIZACION").Select(f => f.IdStatusAlumno).First();
                    alumno.IdStatusAlumno = idstatusalumno;
                    var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                    if (exstatus != null)
                        c.AlumnosEstatusAActualizar.Remove(exstatus);

                    c.AlumnosEstatusAActualizar.Add(alumno);

                    stHorarioAlumno alhor = HorariosdelAlumno.Where(f => f.IdHorarioAlumno == item.IdHorarioAlumno).First();


                    ObtenerCalificacionesFaltantes(c, alhor, totalreprobadasRegularizacion.ElementAt(0).IdCursoPeriodoMomento);
                }

            }

        }

        private void ValidarPeriodoExtraOrdinario(ReglamentoEvaluacion c, IdHorariosAlumnos item)
        {

            HorariosAlumnos horarios = HorariosAlumnos.Instance;
            List<stHorarioAlumno> HorariosdelAlumno = horarios.getHorariosPorAlumno(item.Curp, item.IdCicloEscolar);


            //VALIDACION DE REPROBADAS POR PERIODO Extraordinario


            var TotalesReprobadasEnExtraOrdinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Ordinario" && s.EsReprobada == true && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();

            var TotalesCalificacionesEnExtraOrdinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Extraordinario" == true && s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();

            var totalreprobadasExtraordinario = c.CalificacionesTotalesPeriodosAlumnos.Where(s => s.Acreditacion_stCursoPeriodoMomento.Acreditacion_ctPeriodo.Nombre == "Extraordinario" && s.stHorarioAlumno.Curp == item.Curp && s.EsReprobada == true && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).ToList();



            //IRRGULARES
            if ((TotalesReprobadasEnExtraOrdinario.Count == TotalesCalificacionesEnExtraOrdinario.Count) && totalreprobadasExtraordinario.Count > 0)
            {
                ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula).Select(e => e.stHorarioAlumno.ctAlumnos).First();

                alumno.EsRegular = false;
                c.AlumnosIrregularesAActualizar.Add(alumno);
            }

            //VALIDACION DE REPORBADAS POR PERIODO EXTRAORDINARIO
            if ((TotalesReprobadasEnExtraOrdinario.Count == TotalesCalificacionesEnExtraOrdinario.Count))
            {
                if (totalreprobadasExtraordinario.Count >= c.MaximoReprobadasExtraOrdinario)
                {
                    ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                        .Select(e => new ctAlumnos
                        {

                            Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                            Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                            ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                            ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                            Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                            Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                            FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                            IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                            IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                            IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                            Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                            Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                            Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                            CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                            IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                            IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                            IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                            ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                            Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                            CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                            IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                            IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                            BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                            IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                            NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                            ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                            ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                            IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                            TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                            NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                            ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                            ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                            IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                            TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                            NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                            ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                            ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                            IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                            TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                            IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                            IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                            cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                            PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                            IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                            IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                            IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                            NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                            IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                            IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                            IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                            FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                            IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                            IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                            IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                            IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                            CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                            EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                            IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                            IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                            IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                            FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                            PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                            AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                            CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                            Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                            NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                            FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                            IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                            KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                            NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                            IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                            FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                            IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                            FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                            IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                            EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                            FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                            IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                            EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                            IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                            IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                            IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                            IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                            CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                            NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                            ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                            CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                            ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor
                        }).First();

                    //baja
                    short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "BAJA POR EXCEDER REPROBADAS EN EXTRAORDINARIO").Select(f => f.IdStatusAlumno).First();
                    alumno.IdStatusAlumno = idstatusalumno;
                    var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                    if (exstatus != null)
                        c.AlumnosEstatusAActualizar.Remove(exstatus);

                    c.AlumnosEstatusAActualizar.Add(alumno);


                }

            }
            else
            {

                if (totalreprobadasExtraordinario.Count >= c.MaximoReprobadasExtraOrdinario)
                {
                    ctAlumnos alumno = c._stMomentoEvaluacionCalificacion.Where(s => s.stHorarioAlumno.Curp == item.Curp && s.stHorarioAlumno.stHorario.IdCicloEscolar == item.IdCicloEscolar && s.stHorarioAlumno.Matricula == item.Matricula)
                        .Select(e => new ctAlumnos
                        {

                            Matricula = e.stHorarioAlumno.ctAlumnos.Matricula,
                            Nombre = e.stHorarioAlumno.ctAlumnos.Nombre,
                            ApPaterno = e.stHorarioAlumno.ctAlumnos.ApPaterno,
                            ApMaterno = e.stHorarioAlumno.ctAlumnos.ApMaterno,
                            Curp = e.stHorarioAlumno.ctAlumnos.Curp,
                            Sexo = e.stHorarioAlumno.ctAlumnos.Sexo,
                            FechaNacimiento = e.stHorarioAlumno.ctAlumnos.FechaNacimiento,
                            IdLocalidadNac = e.stHorarioAlumno.ctAlumnos.IdLocalidadNac,
                            IdMpioNac = e.stHorarioAlumno.ctAlumnos.IdMpioNac,
                            IdEstadoNac = e.stHorarioAlumno.ctAlumnos.IdEstadoNac,
                            Calle = e.stHorarioAlumno.ctAlumnos.Calle,
                            Numero = e.stHorarioAlumno.ctAlumnos.Numero,
                            Colonia = e.stHorarioAlumno.ctAlumnos.Colonia,
                            CodigoPostal = e.stHorarioAlumno.ctAlumnos.CodigoPostal,
                            IdLocalidadViv = e.stHorarioAlumno.ctAlumnos.IdLocalidadViv,
                            IdMpioViv = e.stHorarioAlumno.ctAlumnos.IdMpioViv,
                            IdEstadoViv = e.stHorarioAlumno.ctAlumnos.IdEstadoViv,
                            ClaveLada = e.stHorarioAlumno.ctAlumnos.ClaveLada,
                            Telefono = e.stHorarioAlumno.ctAlumnos.Telefono,
                            CorreoElectronico = e.stHorarioAlumno.ctAlumnos.CorreoElectronico,
                            IdTipoSanguineo = e.stHorarioAlumno.ctAlumnos.IdTipoSanguineo,
                            IdGrupoEtnico = e.stHorarioAlumno.ctAlumnos.IdGrupoEtnico,
                            BecaOportunidades = e.stHorarioAlumno.ctAlumnos.BecaOportunidades,
                            IdEstadoCivil = e.stHorarioAlumno.ctAlumnos.IdEstadoCivil,
                            NombrePadre = e.stHorarioAlumno.ctAlumnos.NombrePadre,
                            ApPaternoPadre = e.stHorarioAlumno.ctAlumnos.ApPaternoPadre,
                            ApMaternoPadre = e.stHorarioAlumno.ctAlumnos.ApMaternoPadre,
                            IdOcupacionPadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionPadre,
                            TelefonoPadre = e.stHorarioAlumno.ctAlumnos.TelefonoPadre,
                            NombreMadre = e.stHorarioAlumno.ctAlumnos.NombreMadre,
                            ApPaternoMadre = e.stHorarioAlumno.ctAlumnos.ApPaternoMadre,
                            ApMaternoMadre = e.stHorarioAlumno.ctAlumnos.ApMaternoMadre,
                            IdOcupacionMadre = e.stHorarioAlumno.ctAlumnos.IdOcupacionMadre,
                            TelefonoMadre = e.stHorarioAlumno.ctAlumnos.TelefonoMadre,
                            NombreTutor = e.stHorarioAlumno.ctAlumnos.NombreTutor,
                            ApPaternoTutor = e.stHorarioAlumno.ctAlumnos.ApPaternoTutor,
                            ApMaternoTutor = e.stHorarioAlumno.ctAlumnos.ApMaternoTutor,
                            IdOcupacionTutor = e.stHorarioAlumno.ctAlumnos.IdOcupacionTutor,
                            TelefonoTutor = e.stHorarioAlumno.ctAlumnos.TelefonoTutor,
                            IdTiempoTranslado = e.stHorarioAlumno.ctAlumnos.IdTiempoTranslado,
                            IdTransporte = e.stHorarioAlumno.ctAlumnos.IdTransporte,
                            cveSecundaria = e.stHorarioAlumno.ctAlumnos.cveSecundaria,
                            PromedioSecundaria = e.stHorarioAlumno.ctAlumnos.PromedioSecundaria,
                            IdPlanEstudio = e.stHorarioAlumno.ctAlumnos.IdPlanEstudio,
                            IdValorCicloIngreso = e.stHorarioAlumno.ctAlumnos.IdValorCicloIngreso,
                            IdCicloEscolar = e.stHorarioAlumno.ctAlumnos.IdCicloEscolar,
                            NoImss = e.stHorarioAlumno.ctAlumnos.NoImss,
                            IdStatusAlumno = e.stHorarioAlumno.ctAlumnos.IdStatusAlumno,
                            IdCampus = e.stHorarioAlumno.ctAlumnos.IdCampus,
                            IdValorCiclo = e.stHorarioAlumno.ctAlumnos.IdValorCiclo,
                            FechaModificacion = e.stHorarioAlumno.ctAlumnos.FechaModificacion,
                            IdUsuario = e.stHorarioAlumno.ctAlumnos.IdUsuario,
                            IdStatusProceso = e.stHorarioAlumno.ctAlumnos.IdStatusProceso,
                            IdPlanEstudioA = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioA,
                            IdPlanEstudioB = e.stHorarioAlumno.ctAlumnos.IdPlanEstudioB,
                            CurpPorSistema = e.stHorarioAlumno.ctAlumnos.CurpPorSistema,
                            EsRegular = e.stHorarioAlumno.ctAlumnos.EsRegular,
                            IdGrupoCampus = e.stHorarioAlumno.ctAlumnos.IdGrupoCampus,
                            IdGrupoNombre = e.stHorarioAlumno.ctAlumnos.IdGrupoNombre,
                            IdCicloEscolarIngreso = e.stHorarioAlumno.ctAlumnos.IdCicloEscolarIngreso,
                            FechaSolicitud = e.stHorarioAlumno.ctAlumnos.FechaSolicitud,
                            PromedioSecundariaAdmision = e.stHorarioAlumno.ctAlumnos.PromedioSecundariaAdmision,
                            AsistenciaExamen = e.stHorarioAlumno.ctAlumnos.AsistenciaExamen,
                            CalificacionExamenIngreso = e.stHorarioAlumno.ctAlumnos.CalificacionExamenIngreso,
                            Condicionado = e.stHorarioAlumno.ctAlumnos.Condicionado,
                            NumeroBajasTemporales = e.stHorarioAlumno.ctAlumnos.NumeroBajasTemporales,
                            FechaUltimaBajaTemporal = e.stHorarioAlumno.ctAlumnos.FechaUltimaBajaTemporal,
                            IngresoFamiliar = e.stHorarioAlumno.ctAlumnos.IngresoFamiliar,
                            KmCasaaCampus = e.stHorarioAlumno.ctAlumnos.KmCasaaCampus,
                            NoRequiereTitulo = e.stHorarioAlumno.ctAlumnos.NoRequiereTitulo,
                            IdAlumno = e.stHorarioAlumno.ctAlumnos.IdAlumno,
                            FechaNacimientoTutor = e.stHorarioAlumno.ctAlumnos.FechaNacimientoTutor,
                            IdGradoEstudiosTutor = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosTutor,
                            FechaNacimientoPadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoPadre,
                            IdGradoEstudiosPadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosPadre,
                            EsFinadoPadre = e.stHorarioAlumno.ctAlumnos.EsFinadoPadre,
                            FechaNacimientoMadre = e.stHorarioAlumno.ctAlumnos.FechaNacimientoMadre,
                            IdGradoEstudiosMadre = e.stHorarioAlumno.ctAlumnos.IdGradoEstudiosMadre,
                            EsFinadaMadre = e.stHorarioAlumno.ctAlumnos.EsFinadaMadre,
                            IdSituacionFamiliar = e.stHorarioAlumno.ctAlumnos.IdSituacionFamiliar,
                            IdLocalidadVivTutor = e.stHorarioAlumno.ctAlumnos.IdLocalidadVivTutor,
                            IdMpioVivTutor = e.stHorarioAlumno.ctAlumnos.IdMpioVivTutor,
                            IdEstadoVivTutor = e.stHorarioAlumno.ctAlumnos.IdEstadoVivTutor,
                            CalleTutor = e.stHorarioAlumno.ctAlumnos.CalleTutor,
                            NumeroTutor = e.stHorarioAlumno.ctAlumnos.NumeroTutor,
                            ColoniaTutor = e.stHorarioAlumno.ctAlumnos.ColoniaTutor,
                            CodigoPostalTutor = e.stHorarioAlumno.ctAlumnos.CodigoPostalTutor,
                            ClaveLadaTutor = e.stHorarioAlumno.ctAlumnos.ClaveLadaTutor
                        }).First();

                    //baja
                    short idstatusalumno = horarios.ctStatusAlumno.Where(r => r.Nombre == "PARA BAJA POR REPROBADAS EN EXTRAORDINARIO").Select(f => f.IdStatusAlumno).First();
                    alumno.IdStatusAlumno = idstatusalumno;
                    var exstatus = c.AlumnosEstatusAActualizar.Where(r => r.Curp == item.Curp).SingleOrDefault();
                    if (exstatus != null)
                        c.AlumnosEstatusAActualizar.Remove(exstatus);

                    c.AlumnosEstatusAActualizar.Add(alumno);

                    stHorarioAlumno alhor = HorariosdelAlumno.Where(f => f.IdHorarioAlumno == item.IdHorarioAlumno).First();

                    ObtenerCalificacionesFaltantes(c, alhor, totalreprobadasExtraordinario.ElementAt(0).IdCursoPeriodoMomento);
                }

            }

        }

        private void GrabarBaseDatosValidacionAcedemica(ReglamentoEvaluacion c)
        {
            bdAriesEntities basedatos = new bdAriesEntities();

            foreach (var item in c.CalificacionesFinalesAInsertar)
            {

                basedatos.Entry(item).State = System.Data.Entity.EntityState.Added;

            }

            try
            {
                basedatos.SaveChanges();

            }
            catch (Exception e)
            {

                throw;
            }

            //limpiar calificaciones finales
            c.CalificacionesFinalesAInsertar.Clear();





            foreach (var item in c.AlumnosEstatusAActualizar)
            {

                basedatos.Entry(item).State = System.Data.Entity.EntityState.Modified;
                basedatos.Entry(item).Property("IdStatusAlumno").IsModified = true;

                ActualizarEstatusSingleton(item);
            }


            try
            {
                basedatos.SaveChanges();

            }
            catch (Exception e)
            {

                throw;
            }



            foreach (var item in c.AlumnosEstatusAActualizar)
            {

                basedatos.Entry(item).State = System.Data.Entity.EntityState.Modified;
                basedatos.Entry(item).Property("EsRegular").IsModified = true;

                ActualizarEstatusSingleton(item);
            }


            try
            {
                basedatos.SaveChanges();

            }
            catch (Exception e)
            {

                throw;
            }

            c.AlumnosEstatusAActualizar.Clear();

        }

        private void ActualizarEstatusValidacionCalificacionesFinales(ReglamentoEvaluacion c)
        {
            bdAriesEntities basedatos = new bdAriesEntities();




            foreach (var item in c.AlumnosEstatusAActualizar)
            {

                basedatos.Entry(item).State = System.Data.Entity.EntityState.Modified;
                basedatos.Entry(item).Property("IdStatusAlumno").IsModified = true;

                ActualizarEstatusSingleton(item);




            }


            try
            {
                basedatos.SaveChanges();

            }
            catch (Exception e)
            {

                throw e.InnerException;
            }


        }

        private string GrabaListasDeCalificaciones(ref ReglamentoEvaluacion c)
        {
            string msj = "";
            bdAriesEntities basedatos = new bdAriesEntities();

            //MOMENTOS******************
            foreach (var item in c.EvaluacionesAEliminar)
            {
                msj = msj + item.stHorarioAlumno.Curp + ", ";
                item.stHorarioAlumno = null;
                basedatos.Entry(item).State = System.Data.Entity.EntityState.Deleted;
            }

            var inner = from tt in c.Alumnos select tt.IdHorarioAlumno;
            var periodos = from rr in basedatos.Acreditacion_stPeriodoCalificacion where inner.Contains(rr.IdHorarioAlumno) select rr;


            foreach (var item in periodos.ToList())
            {
                msj = msj + item.stHorarioAlumno.Curp + ", ";
                item.stHorarioAlumno = null;
                basedatos.Entry(item).State = System.Data.Entity.EntityState.Deleted;
            }


            //delete calificaciones finales



            bdAriesEntities bd = new bdAriesEntities();

            var inner2 = from tt in c.Alumnos select tt.Curp;

            var finales = basedatos.Acreditacion_stAlumnosCalificacionFinal.Where(d => inner2.Contains(d.Curp)).ToList();


            var fin = finales.Join(c.Alumnos, x => new { x.Curp, x.IdPlanEstudioAsignatura, x.Matricula, x.IdCicloEscolar },
                y => new { y.Curp, y.IdPlanEstudioAsignatura, y.Matricula, y.IdCicloEscolar }, (x, y) => x).AsEnumerable()
                .Select(x =>

                   x.IdAlumnoCalificacionFinal

                ).ToList();



            var Califfinales = basedatos.Acreditacion_stAlumnosCalificacionFinal.Where(d => fin.Contains(d.IdAlumnoCalificacionFinal));


            foreach (var dd in Califfinales.ToList())
            {
                basedatos.Entry(dd).State = System.Data.Entity.EntityState.Deleted;


            }


            //seccion de eliminacion
            try
            {
                basedatos.SaveChanges();

            }
            catch (Exception e)
            {

                throw;
            }

            //seccion de eliminacion***********




            foreach (var item in c.EvaluacionesAActualizar)
            {
                msj = msj + item.stHorarioAlumno.Curp + ", ";
                item.stHorarioAlumno = null;

                basedatos.Entry(item).State = System.Data.Entity.EntityState.Modified;
            }

            foreach (var item in c.EvaluacionesAInsertar)
            {
                msj = msj + item.stHorarioAlumno.Curp + ", ";
                item.stHorarioAlumno = null;
                basedatos.Entry(item).State = System.Data.Entity.EntityState.Added;

            }

            //MOMENTOS---------------------------

            //PERIODOS**************************


            foreach (var item in c.PeriodosEvaluacionesAInsertar)
            {
                //msj = msj + item.stHorarioAlumno.Curp + ", ";
                //item.stHorarioAlumno = null;

                basedatos.Entry(item).State = System.Data.Entity.EntityState.Added;

            }

            //PERIODOS--------------------------

            //FINALES************************



            foreach (var item in c.CalificacionesFinalesAInsertar)
            {
                msj = msj + item.Curp + ", ";

                basedatos.Entry(item).State = System.Data.Entity.EntityState.Added;

            }

            //limpiar calificaciones finales
            //c.CalificacionesFinalesAInsertar.Clear();





            try
            {
                basedatos.SaveChanges();

            }
            catch (Exception e)
            {

                throw;
            }



            c.CalificacionesFinalesAInsertar.Clear();
            //FINALES--------------------------

            return msj;

        }

        /// <summary>
        /// Determina si existe calificacion segun la evaluación para qeu grabe o actualize la calificacion
        /// </summary>
        /// <param name="c"></param>
        /// <param name="evaluacion"></param>
        private void ActualizarInformacionGrabarActualizar(ReglamentoEvaluacion c, string evaluacion, long IdHorarioAlumno)
        {
            Acreditacion_stMomentoEvaluacionCalificacion info = new Acreditacion_stMomentoEvaluacionCalificacion();

            info = c._stMomentoEvaluacionCalificacion.Where(f => (f.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre == evaluacion && f.Calificacion > -1 && f.IdMomentoEvaluacionCalificacion > -1 && f.IdHorarioAlumno == IdHorarioAlumno)).Select(s => new Acreditacion_stMomentoEvaluacionCalificacion { stHorarioAlumno = s.stHorarioAlumno, IdMomentoEvaluacionCalificacion = (long)s.IdMomentoEvaluacionCalificacion, IdMomentoEvaluacion = (short)s.IdMomentoEvaluacion, Calificacion = (decimal)s.Calificacion, EsDefinitiva = (bool)s.EsDefinitiva, EsNp = (bool)s.EsNp, EsReprobada = (bool)s.EsReprobada, IdHorarioAlumno = (long)s.IdHorarioAlumno, EsReprobadaSinPago = (bool)s.EsReprobadaSinPago }).SingleOrDefault();
            if (info != null)
            {
                bdAriesEntities bd = new bdAriesEntities();
                long id = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                var existe = bd.Acreditacion_stMomentoEvaluacionCalificacion.Where(w => w.Acreditacion_stMomentoEvaluacion.Acreditacion_ctEvaluacion.Nombre == evaluacion && w.IdHorarioAlumno == id).FirstOrDefault();




                info.rptCalificacion = c.CalificacionCadena(info.Calificacion, TipoPromedio.Evaluacion);
                if (existe == null)
                {

                    c.EvaluacionesAInsertar.Add(info);
                }
                else
                    c.EvaluacionesAActualizar.Add(info);
            }
        }



        /// <summary>
        /// Si la calificación de los 3 parciales es aprobatoria graba las calificaciones de cada evaluacion y ademas graba en el periodo y la calificacion final
        /// </summary>
        /// <param name="c"></param>
        private void GrabarCalificacionesMomentos(ReglamentoEvaluacion c, long IdHorarioAlumno)
        {

            ActualizarInformacionGrabarActualizar(c, "P1", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "P2", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "P3", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "R1", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "R2", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "R3", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "REG", IdHorarioAlumno);
            ActualizarInformacionGrabarActualizar(c, "ESP", IdHorarioAlumno);

        }


        private void GrabaUnNP(ReglamentoEvaluacion c)
        {
            Acreditacion_stPeriodoCalificacion evaluacion = new Acreditacion_stPeriodoCalificacion();

            evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
            evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
            evaluacion.Calificacion = c.CalificacionNPoReprobatoria;
            evaluacion.rptCalificacion = c.CalificacionCadena(c.CalificacionNPoReprobatoria, TipoPromedio.Periodo);
            evaluacion.EsNp = true;
            evaluacion.EsReprobada = true;

            c.PeriodosEvaluacionesAInsertar.Add(evaluacion);
            AgregaCalificacionFinal(c, evaluacion);



            Acreditacion_stPeriodoCalificacion evaluacion2 = new Acreditacion_stPeriodoCalificacion();

            evaluacion2.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
            evaluacion2.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(3).IdCursoPeriodoMomento;
            evaluacion2.Calificacion = c.CalificacionNPoReprobatoria;
            evaluacion2.rptCalificacion = c.CalificacionCadena(c.CalificacionNPoReprobatoria, TipoPromedio.Periodo);
            evaluacion2.EsNp = true;
            evaluacion2.EsReprobada = true;

            c.PeriodosEvaluacionesAInsertar.Add(evaluacion2);


            Acreditacion_stPeriodoCalificacion evaluacion3 = new Acreditacion_stPeriodoCalificacion();

            evaluacion3.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
            evaluacion3.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(6).IdCursoPeriodoMomento;
            evaluacion3.Calificacion = c.CalificacionNPoReprobatoria;
            evaluacion3.rptCalificacion = c.CalificacionCadena(c.CalificacionNPoReprobatoria, TipoPromedio.Periodo);
            evaluacion3.EsNp = true;
            evaluacion3.EsReprobada = true;

            c.PeriodosEvaluacionesAInsertar.Add(evaluacion3);


            Acreditacion_stPeriodoCalificacion evaluacion4 = new Acreditacion_stPeriodoCalificacion();

            evaluacion4.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
            evaluacion4.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(7).IdCursoPeriodoMomento;
            evaluacion4.Calificacion = c.CalificacionNPoReprobatoria;
            evaluacion4.rptCalificacion = c.CalificacionCadena(c.CalificacionNPoReprobatoria, TipoPromedio.Periodo);
            evaluacion4.EsNp = true;
            evaluacion4.EsReprobada = true;

            c.PeriodosEvaluacionesAInsertar.Add(evaluacion4);



        }

        /// <summary>
        /// Determina si acredito en el periodo Ordinario
        /// </summary>
        /// <param name="c"></param>
        /// <returns></returns>
        private bool AprobacionReprobacionEnOrdinario(ReglamentoEvaluacion c, ref Acreditacion_stPeriodoCalificacion evaluacion)
        {

            bool regresa = false;
            //recuperaciones
            if (c.EvaluacionesDelAlumno.ElementAt(0).EsNp == false && c.EvaluacionesDelAlumno.ElementAt(1).EsNp == false && c.EvaluacionesDelAlumno.ElementAt(2).EsNp == false)
            {
                if ((c.EvaluacionesDelAlumno.ElementAt(0).EsNp == false || c.EvaluacionesDelAlumno.ElementAt(1).EsNp == false || c.EvaluacionesDelAlumno.ElementAt(2).EsNp == false) && c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false || c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false || c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false)
                {
                    if (c.EvaluacionesDelAlumno.ElementAt(0).Calificacion > c.CalificacionReprobatoria && c.EvaluacionesDelAlumno.ElementAt(1).Calificacion > c.CalificacionReprobatoria && c.EvaluacionesDelAlumno.ElementAt(2).Calificacion > c.CalificacionReprobatoria)
                    {
                        evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                        evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                        evaluacion.Calificacion = FormatearPromedio((decimal)(c.EvaluacionesDelAlumno.ElementAt(0).Calificacion + c.EvaluacionesDelAlumno.ElementAt(1).Calificacion + c.EvaluacionesDelAlumno.ElementAt(2).Calificacion) / 3, TipoPromedio.Periodo);
                        evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);
                        evaluacion.EsNp = false;
                        evaluacion.EsReprobada = false;


                        regresa = true;
                    }
                    else
                    {
                        decimal sumacalificaciones = 0;
                        bool haynp = false;
                        bool reproborecuperacion = false;

                        //recuperaciones
                        int totalaprobadas = 0;
                        int califcompletas = 0;
                        if (c.EvaluacionesDelAlumno.ElementAt(0).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(1).Calificacion > -1 && c.EvaluacionesDelAlumno.ElementAt(2).Calificacion > -1)
                        {
                            califcompletas = 3;

                            if (c.EvaluacionesDelAlumno.ElementAt(0).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(1).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(2).EsNp == true)
                                haynp = true;

                            if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(0).Calificacion;
                            }

                            if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(1).Calificacion;
                            }

                            if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(2).Calificacion;
                            }
                        }


                        if (c.EvaluacionesDelAlumno.ElementAt(3).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(4).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(5).EsNp == true)
                            haynp = true;


                        if (c.EvaluacionesDelAlumno.ElementAt(3).Calificacion > -1)
                        {
                            califcompletas = califcompletas + 1;
                            if (c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(3).Calificacion;
                            }
                            else
                                reproborecuperacion = true;
                        }

                        if (c.EvaluacionesDelAlumno.ElementAt(4).Calificacion > -1)
                        {
                            califcompletas = califcompletas + 1;
                            if (c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(4).Calificacion;
                            }
                            else
                                reproborecuperacion = true;
                        }

                        if (c.EvaluacionesDelAlumno.ElementAt(5).Calificacion > -1)
                        {
                            califcompletas = califcompletas + 1;
                            if (c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == false)
                            {
                                totalaprobadas = totalaprobadas + 1;
                                sumacalificaciones = sumacalificaciones + (decimal)c.EvaluacionesDelAlumno.ElementAt(5).Calificacion;
                            }
                            else
                                reproborecuperacion = true;
                        }



                        //acompleta las 6 evaluaciones si es qeu no requerie califiacion en una R
                        if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(3).Calificacion == -1)
                        {
                            califcompletas = califcompletas + 1;
                        }
                        if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(4).Calificacion == -1)
                        {
                            califcompletas = califcompletas + 1;
                        }

                        if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(5).Calificacion == -1)
                        {
                            califcompletas = califcompletas + 1;
                        }
                        //fin acompleta 


                        if (reproborecuperacion == true)
                        {
                            evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                            evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                            evaluacion.Calificacion = c.CalificacionNPoReprobatoria;
                            evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);


                            evaluacion.EsNp = false;
                            evaluacion.EsReprobada = true;

                            regresa = true;
                        }
                        else
                            if (totalaprobadas > 2)
                            {
                                evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                                evaluacion.Calificacion = FormatearPromedio((decimal)(c.EvaluacionesDelAlumno.ElementAt(0).Calificacion + c.EvaluacionesDelAlumno.ElementAt(1).Calificacion + c.EvaluacionesDelAlumno.ElementAt(2).Calificacion) / 3, TipoPromedio.Periodo);
                                evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);

                                evaluacion.EsNp = haynp;
                                evaluacion.EsReprobada = false;
                                regresa = true;
                            }
                            else
                                if (califcompletas == 6)
                                {
                                    evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                                    evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                                    evaluacion.Calificacion = c.CalificacionNPoReprobatoria;
                                    evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);


                                    evaluacion.EsNp = haynp;
                                    evaluacion.EsReprobada = true;

                                    regresa = true;
                                }




                    }

                }
            }
            else
                if (c.EvaluacionesDelAlumno.ElementAt(0).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(1).EsNp == true || c.EvaluacionesDelAlumno.ElementAt(2).EsNp == true)
                {

                    evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(0).IdHorarioAlumno;
                    evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
                    evaluacion.Calificacion = c.CalificacionNPoReprobatoria;
                    evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);


                    evaluacion.EsNp = true;
                    evaluacion.EsReprobada = true;

                    regresa = true;
                }

            return regresa;


        }




        /// <summary>
        /// Determina si acredito en el periodo Regulariacion
        /// </summary>
        /// <param name="c"></param>
        /// <returns></returns>
        private bool AprobacionReprobacionEnRegularizacion(ReglamentoEvaluacion c, ref Acreditacion_stPeriodoCalificacion evaluacion)
        {

            bool regresa = false;


            if (c.EvaluacionesDelAlumno.ElementAt(6).Calificacion > -1)
            {
                evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(6).IdHorarioAlumno;
                evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(6).IdCursoPeriodoMomento;
                evaluacion.Calificacion = (decimal)c.EvaluacionesDelAlumno.ElementAt(6).Calificacion;
                evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);

                evaluacion.EsNp = (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsNp;

                evaluacion.EsReprobada = (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada;
                regresa = true;
            }



            return regresa;


        }


        /// <summary>
        /// Determina si acredito en el periodo Regulariacion
        /// </summary>
        /// <param name="c"></param>
        /// <returns></returns>
        private bool AprobacionReprobacionEnExtraOrdinario(ReglamentoEvaluacion c, ref Acreditacion_stPeriodoCalificacion evaluacion)
        {

            bool regresa = false;


            if (c.EvaluacionesDelAlumno.ElementAt(7).Calificacion > -1)
            {
                evaluacion.IdHorarioAlumno = (long)c.EvaluacionesDelAlumno.ElementAt(7).IdHorarioAlumno;
                evaluacion.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(7).IdCursoPeriodoMomento;
                evaluacion.Calificacion = (decimal)c.EvaluacionesDelAlumno.ElementAt(7).Calificacion;
                evaluacion.rptCalificacion = c.CalificacionCadena(evaluacion.Calificacion, TipoPromedio.Periodo);

                evaluacion.EsNp = (bool)c.EvaluacionesDelAlumno.ElementAt(7).EsNp;

                evaluacion.EsReprobada = (bool)c.EvaluacionesDelAlumno.ElementAt(7).EsReprobada;
                regresa = true;
            }

            return regresa;

        }



        /// <summary>
        /// De todas la calificaciones primero se determina cuales son capturadas erronamente segun el reglamento y se eliminan antes de comenzar el proceso de evaluación
        /// </summary>
        /// <param name="c"></param>
        private void GenerarEliminaciones(ReglamentoEvaluacion c, long idhorarioalumno)
        {

            //PARCIAL 1
            if (c.EvaluacionesDelAlumno.ElementAt(0).Calificacion == -1)
                c.ObtenerEvaluacionAEliminar("P1", false, false, idhorarioalumno);
            if (c.EvaluacionesDelAlumno.ElementAt(1).Calificacion == -1)
                c.ObtenerEvaluacionAEliminar("P2", false, false, idhorarioalumno);
            if (c.EvaluacionesDelAlumno.ElementAt(2).Calificacion == -1)
                c.ObtenerEvaluacionAEliminar("P3", false, false, idhorarioalumno);



            if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == false)
                c.ObtenerEvaluacionAEliminar("R1", false, false, idhorarioalumno);
            else
                if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada != true && c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada != false)
                    c.ObtenerEvaluacionAEliminar("R1", (bool)c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada, idhorarioalumno);
                else
                    if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == true)
                        c.ObtenerEvaluacionAEliminar("R1", (bool)c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada, idhorarioalumno);



            //PARCIAL 2
            if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == false)
                c.ObtenerEvaluacionAEliminar("R2", false, false, idhorarioalumno);
            else
                if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada != true && c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada != false)
                    c.ObtenerEvaluacionAEliminar("R2", (bool)c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada, idhorarioalumno);
                else
                    if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == true)
                        c.ObtenerEvaluacionAEliminar("R2", (bool)c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada, idhorarioalumno);

            //PARCIAL 3

            if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == false)
                c.ObtenerEvaluacionAEliminar("R3", false, false, idhorarioalumno);
            else
                if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada != true && c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada != false)
                    c.ObtenerEvaluacionAEliminar("R3", (bool)c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada, idhorarioalumno);
                else
                    if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == true && c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == true)
                        c.ObtenerEvaluacionAEliminar("R3", (bool)c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada, (bool)c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada, idhorarioalumno);


            if (c.EvaluacionesDelAlumno.ElementAt(2).Calificacion == -1 && c.EvaluacionesDelAlumno.ElementAt(5).Calificacion > -1)
                c.ObtenerEvaluacionAEliminar("R3", true, true, idhorarioalumno);


            //regularizacion
            if (c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == true || c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == true || c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == true)
            {

                if (c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada == true)
                    c.ObtenerEvaluacionAEliminar("REG", true, (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada, idhorarioalumno);

            }

            //aprobo en parcial
            if ((c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false))
            {

                c.ObtenerEvaluacionAEliminar("REG", false, (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada, idhorarioalumno);

            }

            int totalaprobadasordinario = 0;
            if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(0).Calificacion > -1)
                totalaprobadasordinario = totalaprobadasordinario + 1;
            if (c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(1).Calificacion > -1)
                totalaprobadasordinario = totalaprobadasordinario + 1;
            if (c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(2).Calificacion > -1)
                totalaprobadasordinario = totalaprobadasordinario + 1;
            if (c.EvaluacionesDelAlumno.ElementAt(3).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(3).Calificacion > -1)
                totalaprobadasordinario = totalaprobadasordinario + 1;
            if (c.EvaluacionesDelAlumno.ElementAt(4).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(4).Calificacion > -1)
                totalaprobadasordinario = totalaprobadasordinario + 1;
            if (c.EvaluacionesDelAlumno.ElementAt(5).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(5).Calificacion > -1)
                totalaprobadasordinario = totalaprobadasordinario + 1;

            if (totalaprobadasordinario == 3)
            {

                c.ObtenerEvaluacionAEliminar("REG", false, (bool)c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("REG", true, false, idhorarioalumno);

            }


            //especial
            if (c.EvaluacionesDelAlumno.ElementAt(6).EsReprobada == false)
            {

                c.ObtenerEvaluacionAEliminar("ESP", false, (bool)c.EvaluacionesDelAlumno.ElementAt(7).EsReprobada, idhorarioalumno);
                c.ObtenerEvaluacionAEliminar("ESP", true, false, idhorarioalumno);

            }

            //aprobo en parcial
            if (c.EvaluacionesDelAlumno.ElementAt(0).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(1).EsReprobada == false && c.EvaluacionesDelAlumno.ElementAt(2).EsReprobada == false)
            {

                c.ObtenerEvaluacionAEliminar("ESP", false, (bool)c.EvaluacionesDelAlumno.ElementAt(7).EsReprobada, idhorarioalumno);

            }

        }


        public void CrearReglas(ReglamentoEvaluacion c)
        {
            c.MascaraNumericaCalificacionFinal = "99";
            c.MascaraNumericaCalificacionGrado = "99.9";
            c.MascaraNumericaCalificacionPeriodo = "99";
            c.CalificacionReprobatoria = 5.9M;
            c.CalificacionNPoReprobatoria = 5;
            c.CalificacionMaxima = 10;
            c.CalificacionMinima = 5;
            c.MaximoReprobadasRegularizacion = 2;
            c.MaximoReprobadasExtraOrdinario = 2;
            c.MaximoReprobadasOrdinario = 3;
            c.MaximoReprobadasPorCiclo = 2;
            c.MaximoReprobadasPorEstancia = 10;
            c.MaximoGradoEstancia = 10;

            CalificacionesPermitidasEvaluacion califP1 = new CalificacionesPermitidasEvaluacion();
            califP1.Evaluacion = "P1";
            califP1.CalificacionMinima = 0;
            califP1.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califP1);

            CalificacionesPermitidasEvaluacion califP2 = new CalificacionesPermitidasEvaluacion();
            califP2.Evaluacion = "P2";
            califP2.CalificacionMinima = 0;
            califP2.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califP2);

            CalificacionesPermitidasEvaluacion califP3 = new CalificacionesPermitidasEvaluacion();
            califP3.Evaluacion = "P3";
            califP3.CalificacionMinima = 0;
            califP3.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califP3);

            CalificacionesPermitidasEvaluacion califR1 = new CalificacionesPermitidasEvaluacion();
            califR1.Evaluacion = "R1";
            califR1.CalificacionMinima = 0;
            califR1.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califR1);

            CalificacionesPermitidasEvaluacion califR2 = new CalificacionesPermitidasEvaluacion();
            califR2.Evaluacion = "R2";
            califR2.CalificacionMinima = 0;
            califR2.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califR2);

            CalificacionesPermitidasEvaluacion califR3 = new CalificacionesPermitidasEvaluacion();
            califR3.Evaluacion = "R3";
            califR3.CalificacionMinima = 0;
            califR3.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califR3);


            CalificacionesPermitidasEvaluacion califEE = new CalificacionesPermitidasEvaluacion();
            califEE.Evaluacion = "EE";
            califEE.CalificacionMinima = 5;
            califEE.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califEE);

            CalificacionesPermitidasEvaluacion califCI = new CalificacionesPermitidasEvaluacion();
            califCI.Evaluacion = "CI";
            califCI.CalificacionMinima = 5;
            califCI.CalificacionMaxima = 10;

            c.CalificacionesPermitidasEvaluacion.Add(califCI);
        }

        public decimal Truncate(decimal pImporte, int pNumDecimales)
        {
            decimal wRt = 0;
            decimal wPot10 = 1;

            for (int i = 1; i <= pNumDecimales; i++)
            {
                wPot10 = wPot10 * 10;
            }

            wRt = pImporte * wPot10;
            wRt = decimal.Truncate(wRt);
            wRt = wRt / wPot10;
            wRt = decimal.Round(wRt, 2);

            return wRt;
        }
        public decimal FormatearPromedio(decimal promedio, TipoPromedio tipo, int rptdecimales = 0)
        {
            switch (tipo)
            {
                case TipoPromedio.Periodo:
                    {
                        promedio = Math.Round(promedio, 0, MidpointRounding.AwayFromZero);
                    }
                    break;
                case TipoPromedio.Final:
                    {
                        promedio = Math.Round(promedio, 0, MidpointRounding.AwayFromZero);
                    }
                    break;
                case TipoPromedio.Grado:
                    {
                        //  promedio = Math.Round(promedio, 1, MidpointRounding.AwayFromZero)
                        promedio = Truncate(promedio, 1);
                    }
                    break;
            }

            return promedio;
        }


        private void AgregaCalificacionFinal(ReglamentoEvaluacion c, Acreditacion_stPeriodoCalificacion f)
        {
            Acreditacion_stAlumnosCalificacionFinal cf = new Acreditacion_stAlumnosCalificacionFinal();

            cf.Calificacion = f.Calificacion;
            cf.Curp = c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.Curp;
            cf.Dictaminada = false;
            cf.EsNp = f.EsNp;
            cf.EsReprobada = f.EsReprobada;
            cf.IdValorCiclo = c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.IdValorCiclo;
            cf.Matricula = c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.Matricula;
            cf.Renunciada = false;
            cf.rptCalificacion = c.CalificacionCadena(f.Calificacion, TipoPromedio.Final);

            cf.EsActualizacionPlanEstudio = false;
            cf.IdCampus = c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.stHorario.ctGrupoCampus.IdCampus;
            cf.IdCicloEscolar = c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.stHorario.IdCicloEscolar;
            cf.IdCursoPeriodoMomento = c.EvaluacionesDelAlumno.ElementAt(0).IdCursoPeriodoMomento;
            cf.IdGrupoNombre = c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.stHorario.ctGrupoCampus.IdGrupoNombre;
            cf.IdPlanEstudioAsignatura = c.EvaluacionesDelAlumno.ElementAt(0).stHorarioAlumno.stHorario.IdPlanEstudioAsignatura;


            c.CalificacionesFinalesAInsertar.Add(cf);
        }


        private void ActualizarEstatusSingleton(ctAlumnos item)
        {

            HorariosAlumnos horarios1 = HorariosAlumnos.Instance;

            ctStatusAlumno ct = horarios1.ctStatusAlumno.Where(r => r.IdStatusAlumno == item.IdStatusAlumno).First();

            horarios1.HorarioAlumnos.Where(e => e.Curp == item.Curp).Select(g => g.ctAlumnos).First().ctStatusAlumno = ct;




        }
    }




}
