﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Nova.Models;

namespace Nova.Models
{
    class Evaluar : ReglamentoEvaluacion
    {


        // Algorithm invokes a strategy method
        public void ProcesarEvaluacion()
        {
            // return Strategy.Evaluar(this);
            Estrategia.Evaluar(this);
        }
        //// Changing strategies
        //public void SwitchStrategy()
        //{
        //    if (Strategy is Parcial1)
        //        Strategy = new Parcial2();
        //    //else
        //    //    Strategy = new Parcial1();
        //}


        public Evaluar(Int16 idreglamento)
        {


            this._IdReglamento = idreglamento;



            switch (idreglamento)
            {
                case 5:
                    Estrategia = new Reglamento5();
                    this.CrearReglas();

                    break;
                case 6:
                    Estrategia = new Reglamento6();
                    this.CrearReglas();

                    break;
                default:
                    throw new Exception("No hay reglamento definido para el id :  " + idreglamento);


            }
        }

        public Evaluar(Int16 idreglamento, List<Acreditacion_stMomentoEvaluacionCalificacion> calificaciones)
        {
            //inicia variables con informacion general de la evaluación

            this._stMomentoEvaluacionCalificacion.AddRange(calificaciones);

            this._IdReglamento = idreglamento;
            EvaluacionesdelReglamento reglamento1 = EvaluacionesdelReglamento.Instance;
            this._Acreditacion_stMomentoEvaluacion = reglamento1.getReglamento(idreglamento);


            //agrupa a los alumnos a evaluar segun su idhorarioalumno
            this.ObtenerIdHorariosAlumnos();




            //


            switch (idreglamento)
            {
                case 5:
                    Estrategia = new Reglamento5();
                    this.CrearReglas();
                    this.ProcesarEvaluacion();
                    break;
                case 6:
                    Estrategia = new Reglamento6();
                    this.CrearReglas();
                    this.ProcesarEvaluacion();
                    break;
                default:
                    throw new Exception("No hay reglamento definido para " + idreglamento);


            }
        }

        public Evaluar(IEvaluar eval)
        {
            Strategy = eval;
            CrearReglas();
        }

        public override void CrearReglas()
        {
            Estrategia.CrearReglas(this);

        }
    }



}
