﻿using Dapper;
using Nova.Libraries;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Nova.Models.ARIES
{
    public class MejoresPromedios
    {
        public string CURP { get; set; }
        public string Alumno { get; set; }
        public string Campus { get; set; }
        public int Semestre { get; set; }
        public decimal Calificacion { get; set; }
    

    public static List<MejoresPromedios> Promedios()
    {
        List<MejoresPromedios> mp = new List<Models.ARIES.MejoresPromedios>();

        DapperQuery dp = new DapperQuery("bdNovaEntities");
        string query;

        query = @"select a.CURP,Alumno
                        ,Campus,Semestre,Calificacion
                        from Aries_stAlumnosMejoresPromedios a
                        inner join bdCtlEscSeg.dbo.ctAlumnos b on a.curp=b.curp
                        inner join bdCentrosEducativos.dbo.ptCentrosEducativos c on b.IdCampus=c.IdCampus
                        order by c.IdTipoCentro,c.IdCampus,Semestre,Calificacion desc,a.Curp";
        mp = (List<MejoresPromedios>)dp.connection.Query<MejoresPromedios>(query);
        dp.Close();
        return mp;
    }

    }
}