﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using log4net;
namespace Nova.Libraries
{
    [AttributeUsage(AttributeTargets.Method)]
    public class TiempoEjecucionAttribute : Attribute { }

    public class LoggerAttribute
    {
        public static readonly ILog log = LogManager.GetLogger(typeof(MvcApplication));

        public static void LogTiempoEjecucion(string nombreMetodo, TimeSpan tiempo)
        {
            
            log.Info($"{nombreMetodo} finalizado. Tiempo transcurrido: {tiempo}");
        }
    }
    public class Logger
    {
        public static readonly ILog log = LogManager.GetLogger(typeof(MvcApplication));

        private Dictionary<string, DateTime> inicioProcesos = new Dictionary<string, DateTime>();

        public static void LogTiempoEjecucion(string nombreMetodo, TimeSpan tiempo)
        {
            log.Info($"{nombreMetodo} finalizado. Tiempo transcurrido: {tiempo}");
           
        }

        public void Mensaje(string msj)
        {
            

                log.Info(msj);
            
        }
        public void IniciarProceso(string nombreProceso)
        {
            if (!inicioProcesos.ContainsKey(nombreProceso))
            {
                inicioProcesos[nombreProceso] = DateTime.Now;
            }
            else
            {
                // Si el proceso ya ha comenzado, puedes manejarlo según tus necesidades

                log.Info($"El proceso {nombreProceso} ya ha comenzado. {DateTime.Now}");
            }
        }

        public void FinalizarProceso(string nombreProceso)
        {
            if (inicioProcesos.ContainsKey(nombreProceso))
            {
                DateTime finProceso = DateTime.Now;
                TimeSpan tiempoTranscurrido = finProceso - inicioProcesos[nombreProceso];
                string tiempoTranscurridoFormateado = tiempoTranscurrido.ToString();


                log.Info($"El proceso {nombreProceso} finalizado {finProceso}: Tiempo transcurrido: {tiempoTranscurridoFormateado}");
                // Puedes eliminar el proceso del diccionario si lo deseas
                inicioProcesos.Remove(nombreProceso);
            }
            else
            {
                // El proceso no se inició correctamente
                Console.WriteLine($"El proceso {nombreProceso} no se inició correctamente.");
            }
        }
    }
}