﻿using System;
using System.Collections.Generic;
using System.Data.Entity.Infrastructure;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using System.Web;

namespace Nova.Models
{
    public static class ExceptionExtensions
    {
        // Obtiene la excepción más interna y proporciona un contexto detallado
        public static Exception GetOriginalException(this Exception ex)
        {
            Exception originalException = ex;
            StringBuilder exceptionMessage = new StringBuilder();
            bool isduplicated = false;
            // Recorre todas las excepciones internas para acumular sus mensajes
            while (ex != null)
            {
                exceptionMessage.AppendLine(ex.Message);
                originalException = ex;
                ex = ex.InnerException;
                if (ex!=null)
                if (ex.ToString().ToLower().Contains("duplicad") && !isduplicated)

                {
                        isduplicated = true;
                   // exceptionMessage.AppendLine(new String('*', 80)); // Línea de asteriscos para separar
                    exceptionMessage.AppendLine("Registro Duplicado, revise su información");
                }
            }
            if (!isduplicated)
            {
                // Agrega una línea de separación y luego el stack trace
                exceptionMessage.AppendLine(new String('*', 80)); // Línea de asteriscos para separar
                exceptionMessage.AppendLine("Stack Trace:");
                exceptionMessage.AppendLine(originalException.StackTrace);
            }
            // Opcional: registrar la excepción completa usando un sistema de registro
            // Logger.LogError(exceptionMessage.ToString());

            // Retorna una nueva excepción con el mensaje detallado o simplemente retorna la excepción original
            return new Exception(exceptionMessage.ToString(), originalException);
          //  return isduplicated ? new Exception(exceptionMessage.ToString(), originalException) : originalException;
        }
    }


    public static class AjaxRequestExtension
    {
        public static bool IsAjaxRequest(this HttpRequest request)
        {
            return (request.Headers["X-Requested-With"] != null && request.Headers["X-Requested-With"] == "XMLHttpRequest");
        }
    }
}