﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Mail;
using System.Security.Policy;
using System.Web;
using System.Web.Http.Routing;


namespace Nova.Libraries
{
    public class Email
    {
        public Int64 IdIncidenciaTrabajador { get; set; }
        public string correo { get; set; }
        public string TituloCorreo { get; set; }
        public string areaRemitente { get; set; }
        public string TituloEncabezado { get; set; }
        public string Encabezado { get; set; }
        public string Detalle { get; set; }
        public string TextoLink { get; set; }
        public string urlLink { get; set; }

        Nova.Models.bdNovaEntities bd = new Models.bdNovaEntities();

        private Nova.Models.vwDatosAspirantesTrabajadores getMailJefeArea()
        {
          
            var jefe=bd.vwDatosAspirantesTrabajadores.Where(a => a.UbicacionFisica == this.areaRemitente
            && (a.Categoria.Contains("JEFE DE DEPAR") || a.Categoria.Contains("DIRECTOR") || a.Categoria.Contains("SUBDIRECTOR"))
            && a.EstatusTrabajador == "ALTA").FirstOrDefault();

            return jefe;

        }

        public void setMailLicenciasBajasPermisos()
        {
            // IdIncidenciaTrabajador = idcltc;

            var incidencia = bd.IncidenciaPermiso_stIncidenciaTrabajador.Find(this.IdIncidenciaTrabajador);
            var datosUsuario = bd.vwDatosAspirantesTrabajadoresHistorial.Where(a => a.IdConvenioLaboralTrabajadorCategoria == incidencia.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();
            this.areaRemitente = datosUsuario.UbicacionFisica;

            if (datosUsuario.IdModalidadEstudio == 1)
            //plantel
            {
                this.areaRemitente = "DEPARTAMENTO DE SERVICIOS DOCENTES";

            }
            else
                if (datosUsuario.IdModalidadEstudio == 2)
            {
                this.areaRemitente = "DIRECCIÓN DE EDUCACIÓN A DISTANCIA";
            }

            var correojefe = getMailJefeArea();
            if (correojefe != null)
            {

                this.TituloEncabezado = "Estimado(a):" + correojefe.Nombre + " " + correojefe.ApellidoPaterno + " " + correojefe.ApellidoMaterno + " ";
            this.Encabezado = "el Departamento de Recursos Humanos ha aplicado en el sistema una nueva licencia,permiso o baja";
                this.Detalle= "NOMBRE: "+datosUsuario.Nombre+" " +datosUsuario.ApellidoPaterno+ " "+ datosUsuario.ApellidoMaterno +"| LUGAR:" + datosUsuario.UbicacionFisica +" | FECHA:" +incidencia.FechaInicio.ToShortDateString() + " | TIPO: " + incidencia.Catalogos_ctTipoIncidencia.Incidencia;

            correo = correojefe.CorreoInstitucional;


            setMail();
            }

        }
        public Email(Int64 it,  string TituloCorreo,  string TituloEncabezado, string Encabezado, string Detalle = null, string TextoLink = null, string urlLink = null)
        {
            this.IdIncidenciaTrabajador = it;
            this.correo = correo;
            this.TituloCorreo = TituloCorreo;
            this.areaRemitente = areaRemitente;
            this.TituloEncabezado = TituloEncabezado;

            this.Encabezado = Encabezado;
            this.Detalle = Detalle;
            this.TextoLink = TextoLink;
            this.urlLink = urlLink;

        }

        

        public void SendMail()
        {
           

            setMail();


        }
            public bool setMail()
        {
                       

            string mailusuario = correo;
            bool regresa = true;

            string mail = @"<!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional //EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>

<html xmlns='http://www.w3.org/1999/xhtml' xmlns:o='urn:schemas-microsoft-com:office:office' xmlns:v='urn:schemas-microsoft-com:vml'>
<head>
<!--[if gte mso 9]><xml><o:OfficeDocumentSettings><o:AllowPNG/><o:PixelsPerInch>96</o:PixelsPerInch></o:OfficeDocumentSettings></xml><![endif]-->
<meta content='text/html; charset=utf-8' http-equiv='Content-Type'/>
<meta content='width=device-width' name='viewport'/>
<!--[if !mso]><!-->
<meta content='IE=edge' http-equiv='X-UA-Compatible'/>
<!--<![endif]-->
<title></title>
<!--[if !mso]><!-->
<link href='https://fonts.googleapis.com/css?family=Montserrat' rel='stylesheet' type='text/css'/>
<link href='https://fonts.googleapis.com/css?family=Open+Sans' rel='stylesheet' type='text/css'/>
<!--<![endif]-->
<style type='text/css'>
		body {
			margin: 0;
			padding: 0;
		}

		table,
		td,
		tr {
			vertical-align: top;
			border-collapse: collapse;
		}

		* {
			line-height: inherit;
		}

		a[x-apple-data-detectors=true] {
			color: inherit !important;
			text-decoration: none !important;
		}
	</style>
<style id='media-query' type='text/css'>
		@media (max-width: 720px) {

			.block-grid,
			.col {
				min-width: 320px !important;
				max-width: 100% !important;
				display: block !important;
			}

			.block-grid {
				width: 100% !important;
			}

			.col {
				width: 100% !important;
			}

			.col>div {
				margin: 0 auto;
			}

			img.fullwidth,
			img.fullwidthOnMobile {
				max-width: 100% !important;
			}

			.no-stack .col {
				min-width: 0 !important;
				display: table-cell !important;
			}

			.no-stack.two-up .col {
				width: 50% !important;
			}

			.no-stack .col.num4 {
				width: 33% !important;
			}

			.no-stack .col.num8 {
				width: 66% !important;
			}

			.no-stack .col.num4 {
				width: 33% !important;
			}

			.no-stack .col.num3 {
				width: 25% !important;
			}

			.no-stack .col.num6 {
				width: 50% !important;
			}

			.no-stack .col.num9 {
				width: 75% !important;
			}

			.video-block {
				max-width: none !important;
			}

			.mobile_hide {
				min-height: 0px;
				max-height: 0px;
				max-width: 0px;
				display: none;
				overflow: hidden;
				font-size: 0px;
			}

			.desktop_hide {
				display: block !important;
				max-height: none !important;
			}
		}
	</style>
</head>
<body class='clean-body' style='margin: 0; padding: 0; -webkit-text-size-adjust: 100%; background-color: #FFFFFF;'>
<!--[if IE]><div class='ie-browser'><![endif]-->
<table bgcolor='#FFFFFF' cellpadding='0' cellspacing='0' class='nl-container' role='presentation' style='table-layout: fixed; vertical-align: top; min-width: 320px; Margin: 0 auto; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #FFFFFF; width: 100%;' valign='top' width='100%'>
<tbody>
<tr style='vertical-align: top;' valign='top'>
<td style='word-break: break-word; vertical-align: top;' valign='top'>
<!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td align='center' style='background-color:#FFFFFF'><![endif]-->
<div style='background-color:#FFFFFF;'>
<div class='block-grid' style='Margin: 0 auto; min-width: 320px; max-width: 700px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;'>
<div style='border-collapse: collapse;display: table;width: 100%;background-color:transparent;'>
<!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-color:#FFFFFF;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:700px'><tr class='layout-full-width' style='background-color:transparent'><![endif]-->
<!--[if (mso)|(IE)]><td align='center' width='700' style='background-color:transparent;width:700px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:0px; padding-bottom:0px;'><![endif]-->
<div class='col num12' style='min-width: 320px; max-width: 700px; display: table-cell; vertical-align: top; width: 700px;'>
<div style='width:100% !important;'>
<!--[if (!mso)&(!IE)]><!-->
<div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:0px; padding-bottom:0px; padding-right: 0px; padding-left: 0px;'>
<!--<![endif]-->
<table border='0' cellpadding='0' cellspacing='0' class='divider' role='presentation' style='table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;' valign='top' width='100%'>
<tbody>
<tr style='vertical-align: top;' valign='top'>
<td class='divider_inner' style='word-break: break-word; vertical-align: top; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; padding-top: 0px; padding-right: 0px; padding-bottom: 0px; padding-left: 0px;' valign='top'>
<table align='center' border='0' cellpadding='0' cellspacing='0' class='divider_content' height='30' role='presentation' style='table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-top: 0px solid transparent; height: 30px; width: 100%;' valign='top' width='100%'>
<tbody>
<tr style='vertical-align: top;' valign='top'>
<td height='30' style='word-break: break-word; vertical-align: top; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;' valign='top'><span></span></td>
</tr>
</tbody>
</table>
</td>
</tr>
</tbody>
</table>
<!--[if (!mso)&(!IE)]><!-->
</div>
<!--<![endif]-->
</div>
</div>
<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
</div>
</div>
</div>
<div style='background-color:transparent;'>
<div class='block-grid two-up no-stack' style='Margin: 0 auto; min-width: 320px; max-width: 700px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;'>
<div style='border-collapse: collapse;display: table;width: 100%;background-color:transparent;'>
<!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-color:transparent;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:700px'><tr class='layout-full-width' style='background-color:transparent'><![endif]-->
<!--[if (mso)|(IE)]><td align='center' width='350' style='background-color:transparent;width:350px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 20px; padding-left: 20px; padding-top:10px; padding-bottom:10px;'><![endif]-->
<div class='col num6' style='min-width: 320px; max-width: 350px; display: table-cell; vertical-align: top; width: 350px;'>
<div style='width:100% !important;'>
<!--[if (!mso)&(!IE)]><!-->
<div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:10px; padding-bottom:10px; padding-right: 20px; padding-left: 20px;'>
<!--<![endif]-->
<div align='left' class='img-container left fixedwidth' style='padding-right: 0px;padding-left: 0px;'>
<!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr style='line-height:0px'><td style='padding-right: 0px;padding-left: 0px;' align='left'><![endif]--><img alt='Image' border='0' class='left fixedwidth' src='http://www.cecyteo.edu.mx/Nova/App_Themes/Site2015/img/icons/logo7.png' style='text-decoration: none; -ms-interpolation-mode: bicubic; border: 0; height: auto; width: 100%; max-width: 155px; display: block;' title='Image' width='155'/>
<!--[if mso]></td></tr></table><![endif]-->
</div>
<!--[if (!mso)&(!IE)]><!-->
</div>
<!--<![endif]-->
</div>
</div>
<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
<!--[if (mso)|(IE)]></td><td align='center' width='350' style='background-color:transparent;width:350px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px;'><![endif]-->
<div class='col num6' style='min-width: 320px; max-width: 350px; display: table-cell; vertical-align: top; width: 350px;'>
<div style='width:100% !important;'>
<!--[if (!mso)&(!IE)]><!-->
<div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;'>
<!--<![endif]-->
<!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 10px; padding-left: 10px; padding-top: 20px; padding-bottom: 10px; font-family: Arial, sans-serif'><![endif]-->
<div style='color:#E3E3E3;font-family:Open Sans, Helvetica Neue, Helvetica, Arial, sans-serif;line-height:1.2;padding-top:20px;padding-right:10px;padding-bottom:10px;padding-left:10px;'>
<div style='font-size: 12px; line-height: 1.2; color: #E3E3E3; font-family: Open Sans, Helvetica Neue, Helvetica, Arial, sans-serif; mso-line-height-alt: 14px;'>
<p style='font-size: 12px; line-height: 1.2; text-align: right; word-break: break-word; mso-line-height-alt: 14px; margin: 0;'><span style='font-size: 12px;'>"+areaRemitente+@"</span></p>
</div>
</div>
<!--[if mso]></td></tr></table><![endif]-->
<!--[if (!mso)&(!IE)]><!-->
</div>
<!--<![endif]-->
</div>
</div>
<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
</div>
</div>
</div>
<div style='background-image:url('http://www.cecyteo.edu.mx/humanos/content/imagesmail/bg_wave_1.png');background-position:top center;background-repeat:repeat;background-color:#F4F4F4;'>
<div class='block-grid' style='Margin: 0 auto; min-width: 320px; max-width: 700px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;'>
<div style='border-collapse: collapse;display: table;width: 100%;background-color:transparent;'>
<!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-image:url('http://www.cecyteo.edu.mx/humanos/content/imagesmail/bg_wave_1.png');background-position:top center;background-repeat:repeat;background-color:#F4F4F4;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:700px'><tr class='layout-full-width' style='background-color:transparent'><![endif]-->
<!--[if (mso)|(IE)]><td align='center' width='700' style='background-color:transparent;width:700px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:0px;'><![endif]-->
<div class='col num12' style='min-width: 320px; max-width: 700px; display: table-cell; vertical-align: top; width: 700px;'>
<div style='width:100% !important;'>
<!--[if (!mso)&(!IE)]><!-->
<div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:0px; padding-right: 0px; padding-left: 0px;'>
<!--<![endif]-->
<table border='0' cellpadding='0' cellspacing='0' class='divider' role='presentation' style='table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;' valign='top' width='100%'>
<tbody>
<tr style='vertical-align: top;' valign='top'>
<td class='divider_inner' style='word-break: break-word; vertical-align: top; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; padding-top: 10px; padding-right: 10px; padding-bottom: 10px; padding-left: 10px;' valign='top'>
<table align='center' border='0' cellpadding='0' cellspacing='0' class='divider_content' height='70' role='presentation' style='table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-top: 0px solid transparent; height: 70px; width: 100%;' valign='top' width='100%'>
<tbody>
<tr style='vertical-align: top;' valign='top'>
<td height='70' style='word-break: break-word; vertical-align: top; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;' valign='top'><span></span></td>
</tr>
</tbody>
</table>
</td>
</tr>
</tbody>
</table>
<!--[if (!mso)&(!IE)]><!-->
</div>
<!--<![endif]-->
</div>
</div>
<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
</div>
</div>
</div>
<div style='background-color:#F4F4F4;'>
<div class='block-grid' style='Margin: 0 auto; min-width: 320px; max-width: 700px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;'>
<div style='border-collapse: collapse;display: table;width: 100%;background-color:transparent;'>
<!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-color:#F4F4F4;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:700px'><tr class='layout-full-width' style='background-color:transparent'><![endif]-->
<!--[if (mso)|(IE)]><td align='center' width='700' style='background-color:transparent;width:700px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px;'><![endif]-->
<div class='col num12' style='min-width: 320px; max-width: 700px; display: table-cell; vertical-align: top; width: 700px;'>
<div style='width:100% !important;'>
<!--[if (!mso)&(!IE)]><!-->
<div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;'>
<!--<![endif]-->
<!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 30px; padding-left: 30px; padding-top: 10px; padding-bottom: 0px; font-family: 'Trebuchet MS', Tahoma, sans-serif'><![endif]-->
<div style='color:#555555;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;line-height:1.2;padding-top:10px;padding-right:30px;padding-bottom:0px;padding-left:30px;'>
<div style='font-size: 12px; line-height: 1.2; font-family: 'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif; color: #555555; mso-line-height-alt: 14px;'>
<p style='font-size: 14px; line-height: 1.2; word-break: break-word; font-family: Montserrat,; mso-line-height-alt: 17px; margin: 0;'><strong><span style='font-size: 46px;'><span style='color: #3d3bee; font-size: 46px;'>" + TituloEncabezado + @"</span></span></strong></p>
</div>
</div>
<!--[if mso]></td></tr></table><![endif]-->
<!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 30px; padding-left: 30px; padding-top: 15px; padding-bottom: 5px; font-family: Arial, sans-serif'><![endif]-->
<div style='color:#555555;font-family:Open Sans, Helvetica Neue, Helvetica, Arial, sans-serif;line-height:1.5;padding-top:15px;padding-right:30px;padding-bottom:5px;padding-left:30px;'>
<div style='font-size: 12px; line-height: 1.5; color: #555555; font-family: Open Sans, Helvetica Neue, Helvetica, Arial, sans-serif; mso-line-height-alt: 18px;'>
<p style='font-size: 12px; line-height: 1.5; word-break: break-word; mso-line-height-alt: 18px; margin: 0;'><strong><span style='font-size: 20px;'>" + Encabezado + @"</span></strong></p>
</div>
</div>
<!--[if mso]></td></tr></table><![endif]-->
<!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 30px; padding-left: 30px; padding-top: 15px; padding-bottom: 20px; font-family: Arial, sans-serif'><![endif]-->
<div style='color:#7C7C7C;font-family:Open Sans, Helvetica Neue, Helvetica, Arial, sans-serif;line-height:1.5;padding-top:15px;padding-right:30px;padding-bottom:20px;padding-left:30px;'>
<div style='font-size: 12px; line-height: 1.5; color: #7C7C7C; font-family: Open Sans, Helvetica Neue, Helvetica, Arial, sans-serif; mso-line-height-alt: 18px;'>
<p style='line-height: 1.5; word-break: break-word; text-align: center; font-size: 10px; mso-line-height-alt: 15px; margin: 0;'><span style='font-size: 10px;'>Este correo ha sido generado de manera automática, no es necesario que lo responda.</span></p>
<p style='font-size: 12px; line-height: 1.5; word-break: break-word; mso-line-height-alt: 18px; margin: 0;'> </p>
<p style='font-size: 12px; line-height: 1.5; word-break: break-word; mso-line-height-alt: 18px; margin: 0;'> </p>
</div>
</div>
<!--[if mso]></td></tr></table><![endif]-->
<!--[if (!mso)&(!IE)]><!-->
</div>
<!--<![endif]-->
</div>
</div>
<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
</div>
</div>
</div>
<div style='background-color:#F4F4F4;'>
<div class='block-grid' style='Margin: 0 auto; min-width: 320px; max-width: 700px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: #FFFFFF;'>
<div style='border-collapse: collapse;display: table;width: 100%;background-color:#FFFFFF;'>
<!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-color:#F4F4F4;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:700px'><tr class='layout-full-width' style='background-color:#FFFFFF'><![endif]-->
<!--[if (mso)|(IE)]><td align='center' width='700' style='background-color:#FFFFFF;width:700px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 5px; padding-left: 5px; padding-top:5px; padding-bottom:5px;'><![endif]-->
<div class='col num12' style='min-width: 320px; max-width: 700px; display: table-cell; vertical-align: top; width: 700px;'>
<div style='width:100% !important;'>
<!--[if (!mso)&(!IE)]><!-->
<div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 5px; padding-left: 5px;'>
<!--<![endif]-->
<!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 10px; padding-left: 35px; padding-top: 25px; padding-bottom: 0px; font-family: 'Trebuchet MS', Tahoma, sans-serif'><![endif]-->
<div style='color:#444444;font-family:'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif;line-height:1.2;padding-top:25px;padding-right:10px;padding-bottom:0px;padding-left:35px;'>
<div style='font-size: 12px; line-height: 1.2; font-family: 'Montserrat', 'Trebuchet MS', 'Lucida Grande', 'Lucida Sans Unicode', 'Lucida Sans', Tahoma, sans-serif; color: #444444; mso-line-height-alt: 14px;'>
<p style='font-size: 14px; line-height: 1.2; word-break: break-word; font-family: Montserrat,; mso-line-height-alt: 17px; margin: 0;'><span style='background-color: #93f5ed; font-size: 14px;'><span style='font-size: 24px; background-color: #93f5ed;'><span style='font-size: 24px; background-color: #93f5ed;'> Detalles: </span></span></span></p>
</div>
</div>
<!--[if mso]></td></tr></table><![endif]-->
<!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 20px; padding-left: 30px; padding-top: 15px; padding-bottom: 30px; font-family: Arial, sans-serif'><![endif]-->
<div style='color:#555555;font-family:Open Sans, Helvetica Neue, Helvetica, Arial, sans-serif;line-height:1.8;padding-top:15px;padding-right:20px;padding-bottom:30px;padding-left:30px;'>
<div style='line-height: 1.8; font-size: 12px; font-family: Open Sans, Helvetica Neue, Helvetica, Arial, sans-serif; color: #555555; mso-line-height-alt: 22px;'>
<ul style='font-size: 12px;'>";
            var elementos = Detalle.Split('|');
            
            foreach (var item in elementos)
            {
                mail = mail + @"<li style='font-size: 16px; line-height: 1.8; mso-line-height-alt: 29px;'><span style='font-size: 16px;'><strong>"+item+"</strong></span></li>";
            }

 mail=mail+ @"</ul>
</div>
</div>
<!--[if mso]></td></tr></table><![endif]-->
<!--[if (!mso)&(!IE)]><!-->
</div>
<!--<![endif]-->
</div>
</div>
<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
</div>
</div>
</div>
<div style='background-color:#F4F4F4;'>
<div class='block-grid' style='Margin: 0 auto; min-width: 320px; max-width: 700px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;'>
<div style='border-collapse: collapse;display: table;width: 100%;background-color:transparent;'>
<!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-color:#F4F4F4;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:700px'><tr class='layout-full-width' style='background-color:transparent'><![endif]-->
<!--[if (mso)|(IE)]><td align='center' width='700' style='background-color:transparent;width:700px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:25px; padding-bottom:60px;'><![endif]-->
<div class='col num12' style='min-width: 320px; max-width: 700px; display: table-cell; vertical-align: top; width: 700px;'>
<div style='width:100% !important;'>
<!--[if (!mso)&(!IE)]><!-->
<div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:25px; padding-bottom:60px; padding-right: 0px; padding-left: 0px;'>
<!--<![endif]-->
<div align='center' class='button-container' style='padding-top:10px;padding-right:10px;padding-bottom:10px;padding-left:10px;'>

<!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='border-spacing: 0; border-collapse: collapse; mso-table-lspace:0pt; mso-table-rspace:0pt;'><tr><td style='padding-top: 10px; padding-right: 10px; padding-bottom: 10px; padding-left: 10px' align='center'><v:roundrect xmlns:v='urn:schemas-microsoft-com:vml' xmlns:w='urn:schemas-microsoft-com:office:word' href='' style='height:54pt; width:484.5pt; v-text-anchor:middle;' arcsize='13%' stroke='false' fillcolor='#3D3BEE'><w:anchorlock/><v:textbox inset='0,0,0,0'><center style='color:#ffffff; font-family:Arial, sans-serif; font-size:26px'><![endif]-->
<div style='text-decoration:none;display:inline-block;color:#ffffff;background-color:#3D3BEE;border-radius:9px;-webkit-border-radius:9px;-moz-border-radius:9px;width:auto; width:auto;;border-top:1px solid #3D3BEE;border-right:1px solid #3D3BEE;border-bottom:1px solid #3D3BEE;border-left:1px solid #3D3BEE;padding-top:10px;padding-bottom:10px;font-family:Open Sans, Helvetica Neue, Helvetica, Arial, sans-serif;text-align:center;mso-border-alt:none;word-break:keep-all;'>
<a  href='" + urlLink + @"' ><span style='padding-left:45px;padding-right:45px;font-size:26px;display:inline-block;'><span style='font-size: 16px; line-height: 2; word-break: break-word; mso-line-height-alt: 32px;'><span data-mce-style='font-size: 26px; line-height: 52px;' style='font-size: 26px; line-height: 52px;'><strong>" + TextoLink + @"</strong></span></span></span></a>
</div>
<!--[if mso]></center></v:textbox></v:roundrect></td></tr></table><![endif]-->
</div>
<!--[if (!mso)&(!IE)]><!-->
</div>
<!--<![endif]-->
</div>
</div>
<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
</div>
</div>
</div>
<div style='background-image:url('http://www.cecyteo.edu.mx/humanos/Content/imagesmail/bg_wave_2.png');background-position:top center;background-repeat:repeat;background-color:#F4F4F4;'>
<div class='block-grid' style='Margin: 0 auto; min-width: 320px; max-width: 700px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;'>
<div style='border-collapse: collapse;display: table;width: 100%;background-color:transparent;'>
<!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-image:url('http://www.cecyteo.edu.mx/humanos/Content/imagesmail/bg_wave_2.png');background-position:top center;background-repeat:repeat;background-color:#F4F4F4;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:700px'><tr class='layout-full-width' style='background-color:transparent'><![endif]-->
<!--[if (mso)|(IE)]><td align='center' width='700' style='background-color:transparent;width:700px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:0px;'><![endif]-->
<div class='col num12' style='min-width: 320px; max-width: 700px; display: table-cell; vertical-align: top; width: 700px;'>
<div style='width:100% !important;'>
<!--[if (!mso)&(!IE)]><!-->
<div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:0px; padding-right: 0px; padding-left: 0px;'>
<!--<![endif]-->
<table border='0' cellpadding='0' cellspacing='0' class='divider' role='presentation' style='table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;' valign='top' width='100%'>
<tbody>
<tr style='vertical-align: top;' valign='top'>
<td class='divider_inner' style='word-break: break-word; vertical-align: top; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; padding-top: 10px; padding-right: 10px; padding-bottom: 10px; padding-left: 10px;' valign='top'>
<table align='center' border='0' cellpadding='0' cellspacing='0' class='divider_content' height='70' role='presentation' style='table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; border-top: 0px solid transparent; height: 70px; width: 100%;' valign='top' width='100%'>
<tbody>
<tr style='vertical-align: top;' valign='top'>
<td height='70' style='word-break: break-word; vertical-align: top; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;' valign='top'><span></span></td>
</tr>
</tbody>
</table>
</td>
</tr>
</tbody>
</table>
<!--[if (!mso)&(!IE)]><!-->
</div>
<!--<![endif]-->
</div>
</div>
<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
</div>
</div>
</div>
<div style='background-color:#FFFFFF;'>
<div class='block-grid' style='Margin: 0 auto; min-width: 320px; max-width: 700px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: #FFFFFF;'>
<div style='border-collapse: collapse;display: table;width: 100%;background-color:#FFFFFF;'>
<!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-color:#FFFFFF;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:700px'><tr class='layout-full-width' style='background-color:#FFFFFF'><![endif]-->
<!--[if (mso)|(IE)]><td align='center' width='700' style='background-color:#FFFFFF;width:700px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:15px; padding-bottom:35px;'><![endif]-->
<div class='col num12' style='min-width: 320px; max-width: 700px; display: table-cell; vertical-align: top; width: 700px;'>
<div style='width:100% !important;'>
<!--[if (!mso)&(!IE)]><!-->
<div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:15px; padding-bottom:35px; padding-right: 0px; padding-left: 0px;'>
<!--<![endif]-->
<!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 10px; font-family: Arial, sans-serif'><![endif]-->
<div style='color:#838383;font-family:Open Sans, Helvetica Neue, Helvetica, Arial, sans-serif;line-height:1.5;padding-top:10px;padding-right:10px;padding-bottom:10px;padding-left:10px;'>
<div style='font-size: 12px; line-height: 1.5; color: #838383; font-family: Open Sans, Helvetica Neue, Helvetica, Arial, sans-serif; mso-line-height-alt: 18px;'>
<p style='font-size: 14px; line-height: 1.5; text-align: center; word-break: break-word; mso-line-height-alt: 21px; margin: 0;'><span style='color: #000000; font-size: 14px;'><strong>Colegio de Estudios Científicos y Tecnológicos del Estado de Oaxaca.</strong></span></p>
<p style='font-size: 14px; line-height: 1.5; text-align: center; word-break: break-word; mso-line-height-alt: 21px; margin: 0;'><span style='color: #000000; font-size: 14px;'><strong>Gobierno del Estado de Oaxaca.</strong></span></p>
<p style='font-size: 14px; line-height: 1.5; text-align: center; word-break: break-word; mso-line-height-alt: 21px; margin: 0;'><span style='color: #000000; font-size: 14px;'><strong>" + DateTime.Now.Year+@"</strong></span></p>
</div>
</div>
<!--[if mso]></td></tr></table><![endif]-->
<table cellpadding='0' cellspacing='0' class='social_icons' role='presentation' style='table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt;' valign='top' width='100%'>
<tbody>
<tr style='vertical-align: top;' valign='top'>
<td style='word-break: break-word; vertical-align: top; padding-top: 10px; padding-right: 10px; padding-bottom: 10px; padding-left: 10px;' valign='top'>
<table activate='activate' align='center' alignment='alignment' cellpadding='0' cellspacing='0' class='social_table' role='presentation' style='table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: undefined; mso-table-tspace: 0; mso-table-rspace: 0; mso-table-bspace: 0; mso-table-lspace: 0;' to='to' valign='top'>
<tbody>
<tr align='center' style='vertical-align: top; display: inline-block; text-align: center;' valign='top'>
<td style='word-break: break-word; vertical-align: top; padding-bottom: 5px; padding-right: 3px; padding-left: 3px;' valign='top'><a href='https://www.facebook.com/CECyTEO/' target='_blank'><img alt='Facebook' height='32' src='http://www.cecyteo.edu.mx/humanos/content/imagesmail/facebook@2x.png' style='text-decoration: none; -ms-interpolation-mode: bicubic; height: auto; border: none; display: block;' title='Facebook' width='32'/></a></td>
<td style='word-break: break-word; vertical-align: top; padding-bottom: 5px; padding-right: 3px; padding-left: 3px;' valign='top'><a href='https://twitter.com/cecyteoaxaca' target='_blank'><img alt='Twitter' height='32' src='http://www.cecyteo.edu.mx/humanos/content/imagesmail/twitter@2x.png' style='text-decoration: none; -ms-interpolation-mode: bicubic; height: auto; border: none; display: block;' title='Twitter' width='32'/></a></td>
</tr>
</tbody>
</table>
</td>
</tr>
</tbody>
</table>
<!--[if (!mso)&(!IE)]><!-->
</div>
<!--<![endif]-->
</div>
</div>
<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
<!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
</div>
</div>
</div>
<!--[if (mso)|(IE)]></td></tr></table><![endif]-->
</td>
</tr>
</tbody>
</table>
<!--[if (IE)]></div><![endif]-->
</body>
</html>";


            MailMessage msg = new MailMessage();

            msg.From = new MailAddress("sistemas@cecyteo.edu.mx");
            //msg.To.Add(mailusuario);
            msg.To.Add("jcmc2@hotmail.com");
            msg.Bcc.Add("juan.carlos.manuel@cecyteo.edu.mx");
            msg.Subject = TituloCorreo;
            msg.IsBodyHtml = true;


            //UrlHelper u = new UrlHelper(this.ControllerContext.RequestContext);



            msg.Body = mail;
            SmtpClient client = new SmtpClient();


            client.Credentials = new NetworkCredential("sistemas@cecyteo.edu.mx", "calendario2016");
            client.Host = "smtp.gmail.com";
            client.Port = 587;
            client.DeliveryMethod = SmtpDeliveryMethod.Network;
            client.EnableSsl = true;
            // client.UseDefaultCredentials = false;




            try
            {
                client.Send(msg);

            }
            catch (Exception)
            {
                regresa = false;
                // throw new Exception(" El mail no ha podido ser enviado , intente más tarde");
            }
            return regresa;


        }
    }
}