﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Dapper;

namespace IdentityTutores
{
    public sealed class Tutores
    {

        private static volatile Tutores instance;
        private static object syncRoot = new Object();
        private static bdAriesTutores db = new bdAriesTutores();




        public List<IdentityTutores.ctTutores> ctTutores;

        private void setTutores()
        {
            DapperQuery dp = new DapperQuery("bdAriesTutores");
            string query;

            //           query = @"SELECT c.IdKardex,a.IdConvenioLaboralTrabajadorCategoria ,a.FechaTermino FROM Convenios_stConvenioLaboralTrabajadorCategoria a
            //            inner join Convenios_stConvenioLaboralTrabajador b on a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
            //            inner join Kardex_ctTrabajador c on b.IdTrabajador=c.IdTrabajador
            //            inner join Catalogos_ctEstructuraOrganica d on  a.IdEstructuraOrganica = d.IdEstructuraOrganica
            //            order by a.FechaInicio desc";
            //           ConveniosUsuarios = (List<ConvenioLaboralTrabajadorCategoriaValido>)dp.connection.Query<ConvenioLaboralTrabajadorCategoriaValido>(query);
            query = @"SELECT Matricula
      ,Nombre
      ,ApPaterno
      ,ApMaterno
      ,Curp
      ,Sexo
      ,FechaNacimiento
      ,IdLocalidadNac
      ,IdMpioNac
      ,IdEstadoNac
      ,Calle
      ,Numero
      ,Colonia
      ,CodigoPostal
      ,IdLocalidadViv
      ,IdMpioViv
      ,IdEstadoViv
      ,ClaveLada
      ,Telefono
      ,CorreoElectronico
      ,IdTipoSanguineo
      ,IdGrupoEtnico
      ,BecaOportunidades
      ,IdEstadoCivil
      ,NombrePadre
      ,ApPaternoPadre
      ,ApMaternoPadre
      ,IdOcupacionPadre
      ,TelefonoPadre
      ,NombreMadre
      ,ApPaternoMadre
      ,ApMaternoMadre
      ,IdOcupacionMadre
      ,TelefonoMadre
      ,NombreTutor
      ,ApPaternoTutor
      ,ApMaternoTutor
      ,IdOcupacionTutor
      ,TelefonoTutor
      ,IdTiempoTranslado
      ,IdTransporte
      ,cveSecundaria
      ,PromedioSecundaria
      ,IdPlanEstudio
      ,IdValorCicloIngreso
      ,IdCicloEscolar
      ,NoImss
      ,IdStatusAlumno
      ,IdCampus
      ,IdValorCiclo
      ,FechaModificacion
      ,IdUsuario
      ,IdStatusProceso
      ,IdPlanEstudioA
      ,IdPlanEstudioB
      ,CurpPorSistema
      ,EsRegular
      ,IdGrupoCampus
      ,IdGrupoNombre
      ,IdCicloEscolarIngreso
      ,FechaSolicitud
      ,PromedioSecundariaAdmision
      ,AsistenciaExamen
      ,CalificacionExamenIngreso
      ,Condicionado
      ,NumeroBajasTemporales
      ,FechaUltimaBajaTemporal
      ,IngresoFamiliar
      ,KmCasaaCampus
      ,NoRequiereTitulo
      ,IdAlumno
      ,FechaNacimientoTutor
      ,IdGradoEstudiosTutor
      ,FechaNacimientoPadre
      ,IdGradoEstudiosPadre
      ,EsFinadoPadre
      ,FechaNacimientoMadre
      ,IdGradoEstudiosMadre
      ,EsFinadaMadre
      ,IdSituacionFamiliar
      ,IdLocalidadVivTutor
      ,IdMpioVivTutor
      ,IdEstadoVivTutor
      ,CalleTutor
      ,NumeroTutor
      ,ColoniaTutor
      ,CodigoPostalTutor
      ,ClaveLadaTutor
  FROM ctAlumnos";
            this.ctTutores = (List<ctTutores>)dp.connection.Query<ctTutores>(query);

            dp.Close();
            
            this.ctTutores = db.ctAlumnos.ToList();
            
            
        }
        public void Reset()
        {
            setTutores();
        }
        private Tutores()
        {

            setTutores();

        }

        public static Tutores Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        if (instance == null)
                            instance = new Tutores();
                    }
                }

                return instance;
            }
        }

        public IdentityTutores.ctTutores Logeado(string email)
        {
            if (email.Trim() == "")
                return new IdentityTutores.ctTutores();
            else
            return ctTutores.Where(s => s.CorreoElectronico == email).FirstOrDefault();
        }


        public class LoginStatus
        {
            public bool Success { get; set; }
            public string Message { get; set; }
            public string TargetURL { get; set; }
            public string Curp { get; set; }

        }

        public LoginStatus ValidateUser(string email)
        {
            LoginStatus status = new LoginStatus();


            status.Success = true;


            var usuario = Instance.ctTutores.Where(b => b.CorreoElectronico == email.ToLower()).FirstOrDefault();




            if (usuario == null)
            {
                status.Message = "Estimado usuario, no existe el correo electronico en nuestra base de datos, le sugerimos verificar en la tu oficina de control escolar su cuenta y/o actualizar su información";
                status.Success = false;
            }
            else
            {
                status.Curp = usuario.Curp;


            }


            return status;

        }



    }
}
