﻿using IdentityAlumnos.DataModel;
using System.Collections.Generic;
using System.Linq;

namespace IdentityAlumnos
{
    internal class UserRolesRepository
    {
        private readonly DatabaseAlumnosContext _databaseContext;

        public UserRolesRepository(DatabaseAlumnosContext database)
        {
            _databaseContext = database;
        }

        /// <summary>
        /// Returns a list of user's roles
        /// </summary>
        /// <param name="userId">The user's id</param>
        /// <returns></returns>
        public IList<string> FindByUserId(string userId)
        {
            var roles = _databaseContext.AspNetUsers.
                Where(u => u.Id == userId).SelectMany(r => r.AspNetRoles);
            return roles.Select(r => r.Name).ToList();
        }
    }
}