﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Dapper;

namespace IdentityAlumnos
{
    public sealed class Alumnos
    {

        private static volatile Alumnos instance;
        private static object syncRoot = new Object();
        private static bdAriesAlumnos db = new bdAriesAlumnos();




        public List<IdentityAlumnos.ctAlumnos> ctAlumnos;

        private void setAlumnos()
        {
            DapperQuery dp = new DapperQuery("bdAriesAlumnos");
            string query;

            //           query = @"SELECT c.IdKardex,a.IdConvenioLaboralTrabajadorCategoria ,a.FechaTermino FROM Convenios_stConvenioLaboralTrabajadorCategoria a
            //            inner join Convenios_stConvenioLaboralTrabajador b on a.IdConvenioLaboralTrabajador = b.IdConvenioLaboralTrabajador
            //            inner join Kardex_ctTrabajador c on b.IdTrabajador=c.IdTrabajador
            //            inner join Catalogos_ctEstructuraOrganica d on  a.IdEstructuraOrganica = d.IdEstructuraOrganica
            //            order by a.FechaInicio desc";
            //           ConveniosUsuarios = (List<ConvenioLaboralTrabajadorCategoriaValido>)dp.connection.Query<ConvenioLaboralTrabajadorCategoriaValido>(query);
            query = @"SELECT Matricula
      ,Nombre
      ,ApPaterno
      ,ApMaterno
      ,Curp
      ,Sexo
      ,FechaNacimiento
      ,IdLocalidadNac
      ,IdMpioNac
      ,IdEstadoNac
      ,Calle
      ,Numero
      ,Colonia
      ,CodigoPostal
      ,IdLocalidadViv
      ,IdMpioViv
      ,IdEstadoViv
      ,ClaveLada
      ,Telefono
      ,CorreoElectronico
      ,IdTipoSanguineo
      ,IdGrupoEtnico
      ,BecaOportunidades
      ,IdEstadoCivil
      ,NombrePadre
      ,ApPaternoPadre
      ,ApMaternoPadre
      ,IdOcupacionPadre
      ,TelefonoPadre
      ,NombreMadre
      ,ApPaternoMadre
      ,ApMaternoMadre
      ,IdOcupacionMadre
      ,TelefonoMadre
      ,NombreTutor
      ,ApPaternoTutor
      ,ApMaternoTutor
      ,IdOcupacionTutor
      ,TelefonoTutor
      ,IdTiempoTranslado
      ,IdTransporte
      ,cveSecundaria
      ,PromedioSecundaria
      ,IdPlanEstudio
      ,IdValorCicloIngreso
      ,IdCicloEscolar
      ,NoImss
      ,IdStatusAlumno
      ,IdCampus
      ,IdValorCiclo
      ,FechaModificacion
      ,IdUsuario
      ,IdStatusProceso
      ,IdPlanEstudioA
      ,IdPlanEstudioB
      ,CurpPorSistema
      ,EsRegular
      ,IdGrupoCampus
      ,IdGrupoNombre
      ,IdCicloEscolarIngreso
      ,FechaSolicitud
      ,PromedioSecundariaAdmision
      ,AsistenciaExamen
      ,CalificacionExamenIngreso
      ,Condicionado
      ,NumeroBajasTemporales
      ,FechaUltimaBajaTemporal
      ,IngresoFamiliar
      ,KmCasaaCampus
      ,NoRequiereTitulo
      ,IdAlumno
      ,FechaNacimientoTutor
      ,IdGradoEstudiosTutor
      ,FechaNacimientoPadre
      ,IdGradoEstudiosPadre
      ,EsFinadoPadre
      ,FechaNacimientoMadre
      ,IdGradoEstudiosMadre
      ,EsFinadaMadre
      ,IdSituacionFamiliar
      ,IdLocalidadVivTutor
      ,IdMpioVivTutor
      ,IdEstadoVivTutor
      ,CalleTutor
      ,NumeroTutor
      ,ColoniaTutor
      ,CodigoPostalTutor
      ,ClaveLadaTutor
  FROM ctAlumnos";
            this.ctAlumnos = (List<ctAlumnos>)dp.connection.Query<ctAlumnos>(query);

            dp.Close();
            
            
        }
        public void Reset()
        {
            setAlumnos();
        }
        private Alumnos()
        {

            setAlumnos();

        }

        public static Alumnos Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        if (instance == null)
                            instance = new Alumnos();
                    }
                }

                return instance;
            }
        }

        public IdentityAlumnos.ctAlumnos Logeado(string email)
        {
            if (email.Trim() == "")
                return new IdentityAlumnos.ctAlumnos();
            else
            return ctAlumnos.Where(s => s.CorreoElectronico == email).FirstOrDefault();
        }

       
        public class LoginStatus
        {
            public bool Success { get; set; }
            public string Message { get; set; }
            public string TargetURL { get; set; }
            public string Curp { get; set; }

        }

        public LoginStatus ValidateUser(string email)
        {
            LoginStatus status = new LoginStatus();
           

            status.Success = true;


            var usuario = Instance.ctAlumnos.Where(b => b.CorreoElectronico == email.ToLower()).FirstOrDefault();




            if (usuario == null)
            {
                status.Message = "Estimado usuario, no existe el correo electronico en nuestra base de datos, te sugerimos verificar con tu oficina de control escolar tu cuenta y/o actualizar tu información";
                status.Success = false;
            }
            else
            {
                status.Curp = usuario.Curp;
     

            }

         
            return status;

        }

    }
}
