﻿using Nova.Models;
using Nova.Models.Trabajador;
using System;
using System.Linq;
using System.Threading.Tasks;
using System.Web.Mvc;

namespace Nova.Controllers.Trabajador
{
    public class ComprobantePagoController : BaseController
    {
        // GET: ComprobantePago
        public async Task<ActionResult> Index()
        {
            var usuario = Seguridad.Identidad.Usuario();
            var años = await Comprobante.ObtenerAñosPagoTrabajadorAsync(usuario.Convenios_stConvenioLaboralTrabajador.IdTrabajador);
            ViewBag.Años = new SelectList(años);
            return View();
        }

        public async Task<JsonResult> ComprobantePago(int año)
        {
            var usuario = Seguridad.Identidad.Usuario();
            var idTrabjador = usuario.Convenios_stConvenioLaboralTrabajador.IdTrabajador;

            try
            {
                var comprobantes = await Comprobante.ObtenerDatosComprobantePagoTrabajadorAsync(idTrabjador, año);
                var model = comprobantes.Select(c => new
                {
                    c.IdNominaTrabajador,
                    c.Periodo,
                    c.GrupoPagoNomina,
                    c.TipoNomina,
                    c.EtiquetaReporte,
                    c.UUID,
                    c.EsCancelado,
                    c.Nomina,
                }).ToList();

                return Json(model, JsonRequestBehavior.AllowGet);
            }
            catch (Exception e)
            {
                var mensaje = ExceptionExtensions.GetOriginalException(e).Message.Split(new[] { "Stack Trace:" }, StringSplitOptions.None)[0];
                return Json(new { success = false, Message = mensaje }, JsonRequestBehavior.AllowGet);
            }

        }

        public async Task<ActionResult> DescargarCFDIAsync(int idNominaTrabajador, string uuid)
        {
            var archivoBytes = await Comprobante.ObtenerComprobantePDF(idNominaTrabajador, uuid);

            if (archivoBytes != null && archivoBytes.Length > 0)
            {
                return File(archivoBytes, "application/pdf", "CFDI_" + uuid + ".pdf");
            }

            return HttpNotFound("El archivo no existe.");
        }
    }
}