﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Libraries;

namespace Nova.Controllers.Suplencia
{
    public class SuplenciaController : Controller
    {
        // GET: SuplenciaPlazas
        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();
        public ActionResult Index(int IdConvenioLaboralTrabajadorCategoria = 0)
        {
            if (IdConvenioLaboralTrabajadorCategoria > 0)
            {
                ViewBag.Trabajador = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(i => i.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).FirstOrDefault();

                int IdConvenioLaboralTrabajador = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(i => i.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().IdConvenioLaboralTrabajador;

                Session["IdConvenioLaboralTrabajador"] = IdConvenioLaboralTrabajador;

                var EsPermisoSinGoceDeSueldo = db.IncidenciaPermiso_stIncidenciaTrabajador.Where(i => i.Convenios_stConvenioLaboralTrabajadorCategoria.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria && i.FechaTermino > DateTime.Now && i.Catalogos_ctTipoIncidencia.Incidencia == "LICENCIA SIN GOCE DE SUELDO").ToList();

                if (EsPermisoSinGoceDeSueldo.Count() > 0)
                {


                    List<Convenios_stConvenioLaboralTrabajadorCategoria> Universo = new List<Convenios_stConvenioLaboralTrabajadorCategoria>();
                    var IdConveniosLaboralesActuales = db.Convenios_stConvenioLaboralTrabajadorCategoria.GroupBy(g => g.IdConvenioLaboralTrabajador).Select(g => g.Max(r => r.IdConvenioLaboralTrabajadorCategoria)).ToArray();
                    int n = IdConveniosLaboralesActuales.Count();
                    Universo = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(p => (p.FechaTermino != null && p.FechaTermino >= DateTime.Now) && IdConveniosLaboralesActuales.Contains(p.IdConvenioLaboralTrabajadorCategoria)).ToList();
                    return View(Universo);
                }
                else throw new InvalidOperationException("El trabajador no puede ejercer esta acción");

            }
            else throw new InvalidOperationException("Error de parámetros");
        }

        [ValidateInput(false)]
        public ActionResult DatosTrabajdor()
        {

            Int16 id = System.Convert.ToInt16(Session["IdConvenioLaboralTrabajador"]);
            var model = db.vwDatosAspirantesTrabajadores.Where(d => d.IdConvenioLaboralTrabajador == id).ToList();
            return PartialView("_pvDatosTrabajador", model);
        }
    }
}