﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class SpdSedesController : Controller
    {
        //
        // GET: /SpdSedes/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvSpdSedes()
        {
            var model = db.spd_ctSedes;
            return PartialView("_pvSpdSedes", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvSpdSedesAddNew(Nova.Models.spd_ctSedes item)
        {
            var model = db.spd_ctSedes;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvSpdSedes", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSpdSedesUpdate(Nova.Models.spd_ctSedes item)
        {
            var model = db.spd_ctSedes;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdSede == item.IdSede);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvSpdSedes", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSpdSedesDelete(System.Int16 IdSede)
        {
            var model = db.spd_ctSedes;
            if (IdSede != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdSede == IdSede);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvSpdSedes", model.ToList());
        }
    }
}
