﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class SpdConvocatoriasController : Controller
    {
        //
        // GET: /SpdConvocatorias/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvSpdConvocatorias()
        {
            var model = db.spd_ctConvocatorias;
            return PartialView("_pvSpdConvocatorias", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvSpdConvocatoriasAddNew(Nova.Models.spd_ctConvocatorias item)
        {
            var model = db.spd_ctConvocatorias;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvSpdConvocatorias", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSpdConvocatoriasUpdate(Nova.Models.spd_ctConvocatorias item)
        {
            var model = db.spd_ctConvocatorias;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdConvocatoria == item.IdConvocatoria);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvSpdConvocatorias", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSpdConvocatoriasDelete(System.Int16 IdConvocatoria)
        {
            var model = db.spd_ctConvocatorias;
            if (IdConvocatoria != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdConvocatoria == IdConvocatoria);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvSpdConvocatorias", model.ToList());
        }
    }
}
