﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

using Dapper;
using Seguridad;
using Nova.Models.Kardex;
using DevExpress.Xpo.Helpers;
using Rotativa;
using System.Web.Razor.Parser.SyntaxTree;

namespace Nova.Controllers.SistemaArchivos.Catalogos
{
    public class SistemaArchivos_DocumentalTramiteController :  BaseController
    {
        int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"select a.IdArchivoDocumental,b.IdKardexResponsableEstructuraSeccion,a.ClaveExpediente, a.Contenido, a.FechaElaboracion, a.FechaUltimaModificacion, a.FechaValidacion,a.Anio, h.EstructuraOrganica
                        , h.Direccion,a.UbicacionTopografica,a.Observaciones
                        , j.Nombre as NombreResponsable, j.ApellidoPaterno as ApellidoPaternoResponsable, j.ApellidoMaterno as ApellidoMaternoResponsable
                        ,b.Seccion, b.NombreSeccion, b.Serie, b.NombreSerie, b.Subserie, b.NombreSubserie, b.ValosDocumental_Administrativo, b.ValosDocumental_Legal, b.ValosDocumental_Fiscal
                        , b.Clasificacion_Publica, b.Clasificacion_Reservada, b.Clasificacion_Confidencial, b.VigenciaDoc_Tramite, b.VigenciaDoc_Concentrado, b.EsVigente, 
                        b.Anio, c.Caja,
                        d.Nombre as NombreCreador, d.ApellidoPaterno as ApellidoPaternoCreador, d.ApellidoMaterno as ApellidoMaternoCreador
                        , j.Nombre as NombreActualizo, j.ApellidoPaterno as ApellidoPaternoActualizo, j.ApellidoMaterno as ApellidoMaternoActualizo
                        ,g.Estatus
                        ,k.Nombre as NombreElaboro, k.ApellidoPaterno as ApellidoPaternoElaboro, k.ApellidoMaterno as ApellidoMaternoElaboro,a.IdKardexElaboro,a.NumeroProgresivo
                        

                         from ArchivoConcentracion_ptArchivoDocumental a
                        
                        inner join ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable b on a.IdEstructuraOrganicaSeccionResponsable = b.IdEstructuraOrganicaSeccionResponsable
                        inner join Catalogos_ctEstructuraOrganica h on b.IdEstructuraOrganica = h.IdEstructuraOrganica
                        inner join ArchivoConcentracion_ctCajas c on a.IdCaja = c.IdCaja
                        inner join Kardex_ctDatosPersonales d on a.IdKardexCreador = d.IdKardex
                        inner join Kardex_ctDatosPersonales f on a.IdKardexActualizo = f.IdKardex
                        inner join Kardex_ctDatosPersonales k on a.IdKardexElaboro = k.IdKardex
                        inner join Kardex_ctDatosPersonales j on b.IdKardexResponsableEstructuraSeccion = j.IdKardex
                        inner join ArchivoConcentracion_ctEstatus g on a.IdEstatus = g.IdEstatus
                         where b.IdKardexResponsableEstructuraSeccion = @IdKardex and g.Estatus='Trámite'
                        order by a.NumeroProgresivo, a.IdArchivoDocumental asc ";
        
        string queryordenar = @"select a.IdArchivoDocumental,b.IdKardexResponsableEstructuraSeccion,a.ClaveExpediente, a.Contenido, 
                        b.Anio, g.Estatus, a.NumeroProgresivo                       
                         from ArchivoConcentracion_ptArchivoDocumental a                        
                        inner join ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable b on a.IdEstructuraOrganicaSeccionResponsable = b.IdEstructuraOrganicaSeccionResponsable
                        inner join Catalogos_ctEstructuraOrganica h on b.IdEstructuraOrganica = h.IdEstructuraOrganica
                        inner join ArchivoConcentracion_ctCajas c on a.IdCaja = c.IdCaja inner join ArchivoConcentracion_ctEstatus g on a.IdEstatus = g.IdEstatus
                        where b.IdKardexResponsableEstructuraSeccion =  @IdKardex and g.Estatus='Trámite'
                        order by a.NumeroProgresivo,  a.IdArchivoDocumental asc";






        // GET: SistemaArchivos_CatalogoVigenciaDocumental
        public ActionResult Index()
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
     
            var datosArchivos = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(query, new { IdKardex });
            dp.Close();

            return View(datosArchivos.ToList());  // Ordenar por IdVigenciaDocumental de forma descendente

            

        }

        public ActionResult Ordenamiento()
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            //int IdKardex = 252;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            var datosArchivos = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(queryordenar, new { IdKardex });
            dp.Close();

            return View(datosArchivos.ToList());  // Ordenar por IdVigenciaDocumental de forma descendente



        }

        

        [HttpPost]
        public ActionResult GuardarValores(List<ValorArchivoDTO> Valores)
        {
            foreach (var item in Valores)
            {
                var registro = db.ArchivoConcentracion_ptArchivoDocumental
                                 .FirstOrDefault(a => a.IdArchivoDocumental == item.Id);
                if (registro != null)
                {
                    registro.NumeroProgresivo = item.Valor;
                }
            }

            db.SaveChanges();
            return RedirectToAction("Index");
        }


        public ActionResult ReporteArchivosTramitePdf()
        {
            
            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;
        
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            var result = (List<DatosArchivos>)dp.connection.Query<DatosArchivos>(query, new { IdKardex });

          


            dp.Close();

            string modalidad = "ReporteArchivosTramite" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".pdf";

            
            Rotativa.Options.Margins m = new Rotativa.Options.Margins();
            m.Bottom = 0;
            m.Left = 4;
            m.Right = 4;
            m.Top = 7;
            

            ////return View("IncidenciasporAplicar", result.ToList());
            return new ViewAsPdf(result) { PageSize = Rotativa.Options.Size.Tabloid, PageOrientation = Rotativa.Options.Orientation.Landscape, PageMargins = m, FileName = modalidad };

    
        }

        // GET: SistemaArchivos_CatalogoVigenciaDocumental/Details/5
        public ActionResult Details(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental.Find(id);
            if (archivoconcentracion_ptArchivoDocumental == null)
            {
                return HttpNotFound();
            }
            return View(archivoconcentracion_ptArchivoDocumental);
        }

        // GET: SistemaArchivos_CatalogoVigenciaDocumental/Create
        public ActionResult Create()
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            var IdEstructuraOrgResp = db.ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable.Where(a => a.IdKardexResponsableEstructuraSeccion == IdKardex).ToList();

            // Supón que "nombres" es tu lista original
            var nombres = db.vwDatosAspirantesTrabajadores
                                .Where(e => e.EstatusTrabajador == "ALTA" && e.IdModalidadEstudio == 0)
                                .ToList();
            var nombrecompleto = nombres.Select(n => new
            {
                IdKardexElaboro = n.IdKardex,
                NombreCompleto = n.Nombre + " " + n.ApellidoPaterno + " " + n.ApellidoMaterno   // Concatenar NombreCompleto y Apellido
            }).ToList();

            // Concatenar los campos NombreCompleto y Apellido
            var IdEstructuraOrganicaResp = IdEstructuraOrgResp.Select(n => new
            {
                IdEstructuraOrganicaSeccionResponsable = n.IdEstructuraOrganicaSeccionResponsable,
                SeccionSerie = n.Serie + " " + n.NombreSerie + " / " + n.Anio  // Concatenar NombreCompleto y Apellido
            }).ToList();

            // Crear el SelectList con la propiedad concatenada
            ViewBag.IdEstructuraOrganicaSeccionResponsable = new SelectList(IdEstructuraOrganicaResp, "IdEstructuraOrganicaSeccionResponsable", "SeccionSerie");
            ViewBag.IdKardexElaboro = new SelectList(nombrecompleto, "IdKardexElaboro", "NombreCompleto");
            ViewBag.IdCaja = new SelectList(db.ArchivoConcentracion_ctCajas, "IdCaja", "Caja");
            
        
            return PartialView();
        }

        // POST: SistemaArchivos_CatalogoVigenciaDocumental/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdArchivoDocumental, IdEstructuraOrganicaSeccionResponsable, ClaveExpediente, Contenido, IdCaja, IdKardexCreador, FechaElaboracion, FechaUltimaModificacion, FechaValidacion, IdKardexActualizo, Anio, IdEstatus,UbicacionTopografica,Observaciones,Validado,IdKardexElaboro,Medida, Capacidad")] ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental)
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            ArchivoConcentracion_ptArchivoDocumental ptArchivoDocumental = new ArchivoConcentracion_ptArchivoDocumental();
            ArchivoConcentracion_ptArchivoDocumentalHistoriales ptArchivoDocumentalHistorial = new ArchivoConcentracion_ptArchivoDocumentalHistoriales();
            int IdEstatus = db.ArchivoConcentracion_ctEstatus.Where(x => x.Estatus == "Trámite").FirstOrDefault().IdEstatus;
            var existe = db.ArchivoConcentracion_ptArchivoDocumental.Where(s => s.ClaveExpediente == archivoconcentracion_ptArchivoDocumental.ClaveExpediente && s.Contenido == archivoconcentracion_ptArchivoDocumental.Contenido && s.Anio == archivoconcentracion_ptArchivoDocumental.Anio).ToList();

            if (ModelState.IsValid)
            {

                var RegistrosRepetidos = db.ArchivoConcentracion_ptArchivoDocumental.Where(g => g.IdArchivoDocumental == archivoconcentracion_ptArchivoDocumental.IdArchivoDocumental).ToArray();
                int valor = RegistrosRepetidos.Count();
                if (valor > 0)
                {


                    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                }

                else
                {

                    try
                    {
                        
                            using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                            {

                                ptArchivoDocumental.IdEstructuraOrganicaSeccionResponsable = archivoconcentracion_ptArchivoDocumental.IdEstructuraOrganicaSeccionResponsable;
                                ptArchivoDocumental.ClaveExpediente = archivoconcentracion_ptArchivoDocumental.ClaveExpediente;
                                ptArchivoDocumental.Contenido = archivoconcentracion_ptArchivoDocumental.Contenido;
                                ptArchivoDocumental.IdCaja = archivoconcentracion_ptArchivoDocumental.IdCaja;
                                ptArchivoDocumental.IdKardexCreador = IdKardex;
                                ptArchivoDocumental.FechaElaboracion = DateTime.Now;
                                ptArchivoDocumental.FechaUltimaModificacion = DateTime.Now;
                                ptArchivoDocumental.IdKardexActualizo = IdKardex;
                                ptArchivoDocumental.Anio = archivoconcentracion_ptArchivoDocumental.Anio;
                                ptArchivoDocumental.IdEstatus = IdEstatus;
                                ptArchivoDocumental.UbicacionTopografica = archivoconcentracion_ptArchivoDocumental.UbicacionTopografica;
                                ptArchivoDocumental.Observaciones = archivoconcentracion_ptArchivoDocumental.Observaciones;
                                ptArchivoDocumental.IdKardexElaboro = archivoconcentracion_ptArchivoDocumental.IdKardexElaboro;
                                ptArchivoDocumental.Medida = archivoconcentracion_ptArchivoDocumental.Medida;
                            ptArchivoDocumental.Capacidad = archivoconcentracion_ptArchivoDocumental.Capacidad;
                            //ptArchivoDocumental.Validado = false;
                            db.ArchivoConcentracion_ptArchivoDocumental.Add(ptArchivoDocumental);
                                db.SaveChanges();

                                ptArchivoDocumentalHistorial.IdArchivoDocumental = ptArchivoDocumental.IdArchivoDocumental;
                                ptArchivoDocumentalHistorial.UbicacionTopografica = archivoconcentracion_ptArchivoDocumental.UbicacionTopografica;
                                ptArchivoDocumentalHistorial.Observaciones = archivoconcentracion_ptArchivoDocumental.Observaciones;                                
                                ptArchivoDocumentalHistorial.Anio = archivoconcentracion_ptArchivoDocumental.Anio;
                                ptArchivoDocumentalHistorial.IdKardexActualizo = IdKardex;
                                ptArchivoDocumentalHistorial.FechaModificacion = DateTime.Now;
                                ptArchivoDocumentalHistorial.ClaveExpediente = ptArchivoDocumental.ClaveExpediente;
                                ptArchivoDocumentalHistorial.IdEstatus = ptArchivoDocumental.IdEstatus;
                                ptArchivoDocumentalHistorial.IdKardexElaboro = archivoconcentracion_ptArchivoDocumental.IdKardexElaboro;
                                ptArchivoDocumentalHistorial.Medida = archivoconcentracion_ptArchivoDocumental.Medida;
                            ptArchivoDocumentalHistorial.Capacidad = archivoconcentracion_ptArchivoDocumental.Capacidad;
                            db.ArchivoConcentracion_ptArchivoDocumentalHistoriales.Add(ptArchivoDocumentalHistorial);
                                db.SaveChanges();

                                trans.Complete();

                            }
                           

                        
                        return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });

                    }
                    catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                    return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                }



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }


        // GET: SistemaArchivos_CatalogoVigenciaDocumental/Edit/5
        public ActionResult Edit(int id)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;


            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }

            ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental.Find(id);
            var IdEstructuraOrgResp = db.ArchivoConcentracion_ptEstructuraOrganicaSeccionResponsable.Where(a => a.IdKardexResponsableEstructuraSeccion == IdKardex).ToList();


            
            var IdEstructuraOrganicaResp = IdEstructuraOrgResp.Select(n => new
            {
                IdEstructuraOrganicaSeccionResponsable = n.IdEstructuraOrganicaSeccionResponsable,
                SeccionSerie = n.Serie + " " + n.NombreSerie   // Concatenar NombreCompleto y Apellido
            }).ToList();

            // Supón que "nombres" es tu lista original
            var nombres = db.vwDatosAspirantesTrabajadores
                                .Where(e => e.EstatusTrabajador == "ALTA" && e.IdModalidadEstudio == 0)
                                .ToList();
            var nombrecompleto = nombres.Select(n => new
            {
                IdKardexElaboro = n.IdKardex,
                NombreCompleto = n.Nombre + " " + n.ApellidoPaterno + " " + n.ApellidoMaterno   // Concatenar NombreCompleto y Apellido
            }).ToList();

            // Crear el SelectList con la propiedad concatenada
            ViewBag.IdEstructuraOrganicaSeccionResponsable = new SelectList(IdEstructuraOrganicaResp, "IdEstructuraOrganicaSeccionResponsable", "SeccionSerie", archivoconcentracion_ptArchivoDocumental.IdEstructuraOrganicaSeccionResponsable);

            ViewBag.IdKardexElaboro = new SelectList(nombrecompleto, "IdKardexElaboro", "NombreCompleto",archivoconcentracion_ptArchivoDocumental.IdKardexElaboro);
            ViewBag.IdCaja = new SelectList(db.ArchivoConcentracion_ctCajas, "IdCaja", "Caja",archivoconcentracion_ptArchivoDocumental.IdCaja);

            ViewBag.IdEstatus = new SelectList(db.ArchivoConcentracion_ctEstatus, "IdEstatus", "Estatus", archivoconcentracion_ptArchivoDocumental.IdEstatus);


            if (archivoconcentracion_ptArchivoDocumental == null)
            {
                return HttpNotFound();
            }
            return View(archivoconcentracion_ptArchivoDocumental);
        }

        // POST: SistemaArchivos_CatalogoVigenciaDocumental/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdArchivoDocumental, IdEstructuraOrganicaSeccionResponsable, ClaveExpediente, Contenido, IdCaja, IdKardexCreador, FechaElaboracion, FechaUltimaModificacion, FechaValidacion, IdKardexActualizo, Anio, IdEstatus,UbicacionTopografica,Observaciones,Validado,IdKardexElaboro,Medida, Capacidad")] ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental)
        {
            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            //ArchivoConcentracion_ptArchivoDocumental ptArchivoDocumental = new ArchivoConcentracion_ptArchivoDocumental();
            ArchivoConcentracion_ptArchivoDocumentalHistoriales ptArchivoDocumentalHistorial = new ArchivoConcentracion_ptArchivoDocumentalHistoriales();

            if (ModelState.IsValid)
            {
                var ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental
                .FirstOrDefault(x => x.IdArchivoDocumental == archivoconcentracion_ptArchivoDocumental.IdArchivoDocumental);
                try
                {
                    if (ptArchivoDocumental == null)
                    {
                        return Json(new { Valid = false, Message = "El archivo no fue encontrado en la base de datos." });
                    }
                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                        // Asignar los valores que se han recibido en el modelo de vista
                        ptArchivoDocumental.ClaveExpediente = archivoconcentracion_ptArchivoDocumental.ClaveExpediente;
                        ptArchivoDocumental.UbicacionTopografica = archivoconcentracion_ptArchivoDocumental.UbicacionTopografica;
                        ptArchivoDocumental.Contenido = archivoconcentracion_ptArchivoDocumental.Contenido;
                        ptArchivoDocumental.IdCaja = archivoconcentracion_ptArchivoDocumental.IdCaja;
                        ptArchivoDocumental.IdEstatus = archivoconcentracion_ptArchivoDocumental.IdEstatus;
                        ptArchivoDocumental.Anio = archivoconcentracion_ptArchivoDocumental.Anio;
                        ptArchivoDocumental.Observaciones = archivoconcentracion_ptArchivoDocumental.Observaciones;
                        ptArchivoDocumental.FechaUltimaModificacion = DateTime.Now;
                        ptArchivoDocumental.IdKardexActualizo = IdKardex;
                        ptArchivoDocumental.Validado = false; // Si este es el nuevo valor
                        ptArchivoDocumental.IdKardexElaboro = archivoconcentracion_ptArchivoDocumental.IdKardexElaboro;
                        ptArchivoDocumental.Medida = archivoconcentracion_ptArchivoDocumental.Medida;
                        ptArchivoDocumental.Capacidad = archivoconcentracion_ptArchivoDocumental.Capacidad;
                        // No es necesario usar EntityState.Modified aquí si estás modificando una entidad existente
                        // Entity Framework detectará los cambios automáticamente

                        // Guardar los cambios en la base de datos
                        db.SaveChanges();

                        ptArchivoDocumentalHistorial.IdArchivoDocumental = ptArchivoDocumental.IdArchivoDocumental;
                        ptArchivoDocumentalHistorial.UbicacionTopografica = archivoconcentracion_ptArchivoDocumental.UbicacionTopografica;
                        ptArchivoDocumentalHistorial.Observaciones = archivoconcentracion_ptArchivoDocumental.Observaciones;
                        ptArchivoDocumentalHistorial.Anio = archivoconcentracion_ptArchivoDocumental.Anio;
                        ptArchivoDocumentalHistorial.IdKardexActualizo = IdKardex;
                        ptArchivoDocumentalHistorial.FechaModificacion = DateTime.Now;
                        ptArchivoDocumentalHistorial.ClaveExpediente = ptArchivoDocumental.ClaveExpediente;
                        ptArchivoDocumentalHistorial.IdEstatus = ptArchivoDocumental.IdEstatus;
                        ptArchivoDocumentalHistorial.IdKardexElaboro = archivoconcentracion_ptArchivoDocumental.IdKardexElaboro;
                        ptArchivoDocumentalHistorial.Medida = archivoconcentracion_ptArchivoDocumental.Medida;
                        ptArchivoDocumentalHistorial.Capacidad = archivoconcentracion_ptArchivoDocumental.Capacidad;
                        db.ArchivoConcentracion_ptArchivoDocumentalHistoriales.Add(ptArchivoDocumentalHistorial);
                        db.SaveChanges();
                        trans.Complete();
                    }
                    return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                    


                    
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
               
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: SistemaArchivos_CatalogoVigenciaDocumental/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental.Find(id);
            if (archivoconcentracion_ptArchivoDocumental == null)
            {
                return HttpNotFound();
            }
            return View(archivoconcentracion_ptArchivoDocumental);
        }

        // POST: SistemaArchivos_CatalogoVigenciaDocumental/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
           
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {
                    
                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                           

                            ArchivoConcentracion_ptArchivoDocumental archivoconcentracion_ptArchivoDocumental = db.ArchivoConcentracion_ptArchivoDocumental.Find(id);
                            db.ArchivoConcentracion_ptArchivoDocumental.Remove(archivoconcentracion_ptArchivoDocumental);
                            db.SaveChanges();



                            trans.Complete();
                        }
                    
                   
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
