﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Dapper;
using System.Data.SqlClient;
using System.Configuration;
using DevExpress.Web.ASPxHtmlEditor.Internal;
using DevExpress.XtraLayout.Filtering.Templates;
using Nova.Models.Kardex;
using WebGrease.Activities;
using System.Web.UI.WebControls;
using Seguridad;
using System.Net.Sockets;
using System.Runtime.InteropServices.ComTypes;
using DevExpress.CodeParser;
using DevExpress.Utils.About;
using DevExpress.XtraEditors.Filtering.Templates;
using DevExpress.Utils.Extensions;
using DevExpress.XtraSpreadsheet.Import.Xls;
using DotNet.Highcharts.Helpers;
using Nova.Libraries;
using System.Security.Cryptography;
using DevExpress.DataAccess.Sql.DataApi;
using DevExpress.DataProcessing.InMemoryDataProcessor;
using DevExpress.Data.Linq.Helpers;
using System.Text.RegularExpressions;

namespace Nova.Controllers.Kardex
{
    public class Kardex_SolicitudEvaluacionesController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.Archivo,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente";


        string queryexpediente = @"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente";

        string queryseguimiento = @"select x.IdKardex, x.Nombre,x.ApellidoPaterno,x.ApellidoMaterno,x.UbicacionFisica,x.RelacionLaboral,x.RelacionConvenioLaboral,x.IdConvenioLaboral, z.Archivos from	 (select a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral    from bdNova.dbo.vwDatosAspirantesTrabajadores  a
								 left join bdNova.dbo.Kardex_DocumentosExpediente b on a.IdKardex=b.IdKardex
								 left join bdNova.dbo.Kardex_TipoDocumento c on b.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on b.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
									 where  A.EstatusTrabajador = 'ALTA'
								  group by a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral)	 x
								  left join ( select  a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                  b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,b.RelacionLaboral,b.RelacionConvenioLaboral 
                                 ,COUNT(*) as Archivos from bdNova.dbo.Kardex_DocumentosExpediente a
                                 left join bdNova.dbo.vwDatosAspirantesTrabajadores b on a.IdKardex=b.IdKardex
                                 left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 inner join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
								 
								  group by a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                 b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,
								 b.RelacionLaboral,b.RelacionConvenioLaboral) z on  x.IdKardex= z.IdKardex";



        string queryubicacionfisica = @"SELECT EstructuraOrganica FROM bdNova.dbo.Catalogos_ctEstructuraOrganica
                                        WHERE EsVigente= 1";

        string queryrelacionlaboral = @" SELECT RelacionConvenioLaboral FROM bdNova.dbo.Convenios_stRelacionConvenioLaboral";





        // GET: KardexGradoAcademico
        public ActionResult Index()
        {
            //Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            //var kardex_GradoAcademicodapper= (List<Kardex_GradoAcademicoFotografia>)dp.connection.Query<Kardex_GradoAcademicoFotografia>(query);
            var kardex_GradoAcademico = db.Kardex_GradoAcademico.Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia); ;
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "Crear Grado Académico";
            ViewBag.TituloSwal = "Eliminar Grado Académico";
            ViewBag.PreguntaSwal = "¿Está seguro de eliminar el Grado Académico?";
            //dp.Close();
            return View(kardex_GradoAcademico.ToList());
        }

        // GET: KardexGradoAcademico/Details/5

        //public ActionResult Details(int id)
        public ActionResult Details()
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            string query = string.Format(@" select IdKardex, IdConvenioLaboralTrabajadorCategoria, Nombre,ApellidoPaterno, ApellidoMaterno ,CURP, TelefonoCelular,CorreoElectronico, 
                                (select top 1 NivelEstudioDescripcion from  Kardex_GradoAcademico z  
								inner join Kardex_NivelEstudio a on a.IdKardexNivelEstudio = z.IdKardexNivelEstudio
								where z.Idkardex = y.IdKardex 
								order by a.orden desc ) as GradoAcademico
                                from  vwDatosAspirantesTrabajadores y
                                where IdKardex in  (Select  IdKardex from  Kardex_ctDatosPersonales where EsAltaSindicato = 1 )						
                                order by ApellidoPaterno,ApellidoMaterno,Nombre  desc
                        ");
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DatosSindicato = (List<TrabajadoresEvaluaciones>)dp.connection.Query<TrabajadoresEvaluaciones>(query);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            dp.Close();
            return View(kardex_DatosSindicato);
        }


        public ActionResult SolicitudesXls()
        //String[] proyectos,
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            string query = string.Format(@"  select IdKardex, IdConvenioLaboralTrabajadorCategoria, Nombre,ApellidoPaterno, ApellidoMaterno ,CURP, TelefonoCelular,CorreoElectronico, 
                                (select Top 1 NivelEstudioDescripcion from  Kardex_GradoAcademico z  where z.Idkardex = y.IdKardex order by 1 desc ) as GradoAcademico
                                from  vwDatosAspirantesTrabajadores y
                                where IdKardex in  (Select  IdKardex from  Kardex_ctDatosPersonales where EsAltaSindicato = 1 )						
                                order by IdKardex desc 
                        ");
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var result = (List<TrabajadoresEvaluaciones>)dp.connection.Query<TrabajadoresEvaluaciones>(query);


            string modalidad = "Reporte_Solicitudes" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);

            return View(result);
        }

        [HttpPost]
        public ActionResult Historico(int IdKardex)
        {
            string query = string.Format(@"select b.Nombre, b.ApellidoPaterno,b.ApellidoMaterno ,c.Nombre as NombreC, c.ApellidoPaterno as ApellidoPaternoC,c.ApellidoMaterno as ApellidoMaternoC, d.TipoSuplencia , a.FechaInicio, a.FechaTermino, a.CicloEscolar, a.NumeroOficio from Kardex_SolicitudEvaluaciones a
		                                inner join vwDatosAspirantesTrabajadores b  on  a.IdKardexCandidato = b.IdKardex 
		                                left join  vwDatosAspirantesTrabajadores c on  a.IdConvenioLaboralTrabajadorCategoriaaCubrir  = c.IdConvenioLaboralTrabajadorCategoria 
		                                inner join Nomina_SuplenciaTipo d on a.IdTipoSuplencia = d.IdTipoSuplencia
		                                where a.IdKardexCandidato ={0}", IdKardex);
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DatosSindicato = (List<TrabajadoresHistorico>)dp.connection.Query<TrabajadoresHistorico>(query);
            if (kardex_DatosSindicato.Count() >= 1)
            {
                ViewBag.Nombre = kardex_DatosSindicato.FirstOrDefault().Nombre + " " + kardex_DatosSindicato.FirstOrDefault().ApellidoPaterno + " " + kardex_DatosSindicato.FirstOrDefault().ApellidoMaterno;


            }
            else
            {
                ViewBag.Nombre = "No existe historial del trabajador";
            }

            dp.Close();
            return View(kardex_DatosSindicato);



            //var historico = db.Kardex_SolicitudEvaluaciones.Where(x => x.IdConvenioLaboralTrabajadorCategoriaRegistro == 8301);
            //return View(historico.ToList());
        }
        public ActionResult Trabajadores(int id,int idrelacion)

        {


            //var aprendizaje = from t in dbaries.ctSecuenciaDidacticaAprendizajeEsperado
            //                  where t.IdSecuenciaDidacticaContenidoEspecifico == id
            //                  select new { t.IdSecuenciaDidacticaAprendizajeEsperado, t.Nombre };

            var trabajadores = Nova.Models.TrabajadoresEvaluacionesSuplir.getTrabajadoresSuplir(id , idrelacion);

            List<SelectListItem> items3 = new List<SelectListItem>();
            if (id == 5) 
            {
                foreach (var item in trabajadores)
                {
                    items3.Add(new SelectListItem()
                    {
                        Text = (item.Nombre + " " + item.ApellidoPaterno + " " + item.ApellidoMaterno + " /  CURP:" + item.CURP + " / Categoria:" + item.Categoria + " / Adscripción:" + item.EstructuraOrganica + " / Ubicación Fisica:" + item.UbicacionFisica),
                        //Text = (item.Nombre + " " + item.ApellidoPaterno + " " + item.ApellidoMaterno + " /  CURP:" + item.CURP + " / Categoria:" + item.Categoria + " / Adscripción:" + item.EstructuraOrganica ),
                        Value = item.IdConvenioLaboralTrabajadorCategoria.ToString()
                    });

                }
            }
            else
            {
                foreach (var item in trabajadores)
                {
                    items3.Add(new SelectListItem()
                    {
                        Text = (item.Nombre + " " + item.ApellidoPaterno + " " + item.ApellidoMaterno + " /  CURP:" + item.CURP + " / Categoria:" + item.Categoria + " / Adscripción:" + item.EstructuraOrganica + " / Ubicación Fisica:" + item.UbicacionFisica + "/ FechaInicio: " + item.FechaInicioIncidencia.ToShortDateString() + "/ FechaTermino:" + item.FechaTerminoIncidencia.ToShortDateString()),
                        //Text = (item.Nombre + " " + item.ApellidoPaterno + " " + item.ApellidoMaterno + " /  CURP:" + item.CURP + " / Categoria:" + item.Categoria + " / Adscripción:" + item.EstructuraOrganica + "/ FechaInicio: " + item.FechaInicioIncidencia.ToShortDateString() + "/ FechaTermino:" + item.FechaTerminoIncidencia.ToShortDateString()),
                        Value = item.IdConvenioLaboralTrabajadorCategoria.ToString() + "|" + item.IdIncidenciaTrabajador.ToString()
                    });

                }
            }
         

            return Json(items3, JsonRequestBehavior.AllowGet);
        }
        public ActionResult AreaConocimiento(int id,int idrelacion)

        {


            //var aprendizaje = from t in dbaries.ctSecuenciaDidacticaAprendizajeEsperado
            //                  where t.IdSecuenciaDidacticaContenidoEspecifico == id
            //                  select new { t.IdSecuenciaDidacticaAprendizajeEsperado, t.Nombre };

            var trabajadores = Nova.Models.TrabajadoresEvaluacionesSuplir.getAreasConocimiento(id, idrelacion);

            List<SelectListItem> items3 = new List<SelectListItem>();

            foreach (var item in trabajadores)
            {
                items3.Add(new SelectListItem()
                {
                    Text = item.AreaConocimiento,
                    Value = item.IdAreaConocimiento.ToString()
                });

            }

            return Json(items3, JsonRequestBehavior.AllowGet);
        }



        public ActionResult Evaluacion(int? IdKardex)
        {
            var DatosTrabajador = db.Kardex_ctDatosPersonales.Where(a => a.IdKardex == IdKardex);

            ViewBag.IdKardexCandidato = IdKardex;
            ViewBag.NombreCompletoCandidato = DatosTrabajador.FirstOrDefault().Nombre + ' ' + DatosTrabajador.FirstOrDefault().ApellidoPaterno + ' ' + DatosTrabajador.FirstOrDefault().ApellidoMaterno;



            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            int IdConvenioLaboral = Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral;

            string query;

            query = @"select  IdKardex, IdConvenioLaboralTrabajadorCategoria, Nombre,ApellidoPaterno, ApellidoMaterno , Telefono,CorreoElectronico from  vwDatosAspirantesTrabajadores
                                 where EstatusTrabajador = 'ALTA'  and  IdModalidadEstudio>0 and ConvenioLaboral='BASE' and (RestringirMenu is null or Incidencia like '%INCAPACIDAD%')
								 and  IdKardex = 100000
                                order by IdKardex desc  ";
            var Trabajadores = (List<TrabajadoresEvaluaciones>)dpcg.connection.Query<TrabajadoresEvaluaciones>(query);

            dpcg.Close();

            ViewBag.IdTipoSuplencia = new SelectList(db.Nomina_SuplenciaTipo.Where(a => a.EsSolicitudevaluacion == true), "IdTipoSuplencia", "TipoSuplencia");
            ViewBag.IdEstructuraOrganicaLaboraFisicamente = new SelectList(db.Catalogos_ctEstructuraOrganica.Where(a => a.EsVigente == true), "IdEstructuraOrganica", "EstructuraOrganica");
            //ViewBag.IdEstructuraOrganicaAdscripcion = new SelectList(db.Catalogos_ctEstructuraOrganica.Where(a => a.EsVigente == true), "IdEstructuraOrganica", "EstructuraOrganica");
            ViewBag.IdEstructuraOrganicaAdscripcion = new SelectList(db.Catalogos_ctEstructuraOrganica.Where(a => a.EsVigente == true && a.IdEstructuraOrganica != 144), "IdEstructuraOrganica", "EstructuraOrganica");
            ViewBag.IdCategoriaAspirante = new SelectList(db.Plazas_ctCategoria.Where(a => a.IdRelacionConvenioLaboral == 10), "IdCategoria", "Categoria");


            IEnumerable<SelectListItem> selectList = from s in Trabajadores
                                                     select new SelectListItem
                                                     {
                                                         Value = s.IdConvenioLaboralTrabajadorCategoria.ToString() ,
                                                         Text = s.Nombre.ToString() + ' ' + s.ApellidoPaterno + ' ' + s.ApellidoMaterno
                                                     };
            ViewBag.IdConvenioLaboralTrabajadorCategoriaIncidencia = new SelectList(selectList, "Value", "Text");
            string queryrelacion;

            queryrelacion = @" select  IdRelacionLaboral, RelacionLaboral from  Catalogos_ctRelacionLaboral
                                 where IdRelacionLaboral in (1,2) 
                                order by IdRelacionLaboral asc ";

            var Trabajadoresrelacion = (List<Nova.Models.Catalogos_ctRelacionLaboral>)dpcg.connection.Query<Nova.Models.Catalogos_ctRelacionLaboral>(queryrelacion);

            IEnumerable<SelectListItem> selectListrelacion = from s in Trabajadoresrelacion
                                                             select new SelectListItem
                                                             {
                                                                 Value = s.IdRelacionLaboral.ToString(),
                                                                 Text = s.RelacionLaboral
                                                             };
            ViewBag.IdRelacionLaboral = new SelectList(selectListrelacion, "Value", "Text");

            ViewBag.IdAreaConocimiento = new SelectList(db.Kardex_ctAreaConocimiento.Where(a => a.EsVigente == true), "IdAreaConocimiento", "AreaConocimiento");
            ViewBag.CicloEscolar = Nova.Models.cicloescolarvigente.GetCiclosEscolares().FirstOrDefault().CicloEscolar;

            return PartialView();
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Evaluacion([Bind(Include = "IdKardexSolicitudEvaluacion,FechaSolicitud,IdConvenioLaboralTrabajadorCategoriaRegistro,IdEstructuraOrganicaLaboraFisicamente, IdEstructuraOrganicaAdscripcion,IdTipoSuplencia,IdKardexCandidato,IdConvenioLaboralTrabajadorCategoriaaCubrir,IdCategoriaAspirante,FechaInicio,FechaTermino,NumeroOficio,Observaciones,IdEstatusContratacion,IdAreaConocimiento,IdRelacionLaboral,HorasSemanaMes,CicloEscolar, IdConvenioLaboralTrabajadorCategoriaIncidencia,HorasExcedentes")] Kardex_SolicitudEvaluacionesIncidencia Kardex_solicitudevaluaciones)
        {
            int IdConvenioLaboralTrabajadorCategoriaaCubrirInt;
            int IdIncidenciaTrabajador;

            if (Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaIncidencia != "0")
            {

                string[] datosIdCubrir = Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaIncidencia.Split('|');
                if (datosIdCubrir.Count() > 1)
                {
                    var suplencia = db.Nomina_SuplenciaTipo.Find(Kardex_solicitudevaluaciones.IdTipoSuplencia);

                    if (suplencia.TipoSuplencia == "COMISIÓN PARA OCUPAR PLAZA VACANTE")
                    {
                        int IDLTC = System.Convert.ToInt32(datosIdCubrir[0]);
                        int kardexexiste = db.vwDatosAspirantesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == IDLTC).FirstOrDefault().IdKardex;
                     
                        //var trabajadorEstatusProximamente = db.vwDatosAspirantesTrabajadores.Where(x => x.IdKardex == kardexexiste && x.FechaTermino != null && x.EstatusTrabajador == "PROXIMAMENTE");
                        IQueryable<vwDatosAspirantesTrabajadores> idCLTCReal;
                        idCLTCReal = db.vwDatosAspirantesTrabajadores.Where(x => x.IdKardex == kardexexiste && x.EstatusTrabajador == "ALTA" && x.EsPlazaBase == true);
                        //if (trabajadorEstatusProximamente.Count() > 0)
                        //{
                        //    idCLTCReal = db.vwDatosAspirantesTrabajadores.Where(x => x.IdKardex == kardexexiste && x.EstatusTrabajador == "ALTA");

                        //}
                        //else
                        //{
                        //    idCLTCReal = db.vwDatosAspirantesTrabajadores.Where(x => x.IdKardex == kardexexiste && x.FechaTermino == null && x.Incidencia == "COMISIÓN PARA OCUPAR PLAZA VACANTE");
                        //}
                        IdIncidenciaTrabajador = System.Convert.ToInt32(datosIdCubrir[1]);
                        Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir = idCLTCReal.FirstOrDefault().IdConvenioLaboralTrabajadorCategoria;

                    }
                    else
                    {
                        IdConvenioLaboralTrabajadorCategoriaaCubrirInt = System.Convert.ToInt32(datosIdCubrir[0]);
                        IdIncidenciaTrabajador = System.Convert.ToInt32(datosIdCubrir[1]);
                        Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir = IdConvenioLaboralTrabajadorCategoriaaCubrirInt;
                    }

                }


                else
                {
                    Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir = System.Convert.ToInt32(Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaIncidencia);
                    IdIncidenciaTrabajador = 0;
                }



            }
            else
            {

                IdConvenioLaboralTrabajadorCategoriaaCubrirInt = 0;
                IdIncidenciaTrabajador = 0;
                Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir = 0;

            }
            int IdCLTCR = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            var datosmensajenotificacion = db.vwDatosAspirantesTrabajadores.Where(p => p.IdConvenioLaboralTrabajadorCategoria == IdCLTCR).FirstOrDefault();
            int IdKardexUsuario = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Kardex_SolicitudEvaluaciones solicitudeval = new Kardex_SolicitudEvaluaciones();
            Kardex_ResultadoEvaluacion evaluaciones = new Kardex_ResultadoEvaluacion();
            Kardex_stGradoAcademicoFotografia kardex_stGradoAcademicoFotografia = new Kardex_stGradoAcademicoFotografia();
            var vigencia = db.Nomina_ContratosConfiguracion.Where(a => a.EsVigente == true).FirstOrDefault();
            var idkardexexiste = db.Kardex_ResultadoEvaluacion.Where(z => z.IdKardex == Kardex_solicitudevaluaciones.IdKardexCandidato).FirstOrDefault();
            var tiposuplencia = db.Nomina_SuplenciaTipo.Where(y => y.IdTipoSuplencia == Kardex_solicitudevaluaciones.IdTipoSuplencia).FirstOrDefault();
            var datos = db.Catalogos_ctEstructuraOrganica.Find(Kardex_solicitudevaluaciones.IdEstructuraOrganicaLaboraFisicamente);
            var trabajadorexiste = db.Kardex_SolicitudEvaluaciones.Where(z => z.IdKardexCandidato == Kardex_solicitudevaluaciones.IdKardexCandidato && z.CicloEscolar == Kardex_solicitudevaluaciones.CicloEscolar);
            var adscripcion = db.vwDatosAspirantesTrabajadores.Where(y => y.IdConvenioLaboralTrabajadorCategoria == Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir);
            var plazabasesuplido = db.vwDatosAspirantesTrabajadores.Where(y => y.IdTrabajador == adscripcion.FirstOrDefault().IdTrabajador && y.EsPlazaBase == true);
            var trabajadorduplicado = db.Kardex_SolicitudEvaluaciones.Where(z => z.IdConvenioLaboralTrabajadorCategoriaaCubrir == Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir
            && z.CicloEscolar == Kardex_solicitudevaluaciones.CicloEscolar
            );
            //var trabajadorescubrir = db.vwLicenciasTrabajadores.Where(y => y.ESTATUS == "ACTIVA" && y.IdConvenioLaboralTrabajadorCategoria == Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir);
            var trabajadoresLIC = Nova.Models.TrabajadoresEvaluacionesSuplir.getTrabajadoresSuplir(tiposuplencia.IdTipoSuplencia, Kardex_solicitudevaluaciones.IdRelacionLaboral);

            List<TrabajadoresEvaluaciones> trabajadorLIC = new List<TrabajadoresEvaluaciones>();

            if (IdIncidenciaTrabajador == 0)
            {
                trabajadorLIC = trabajadoresLIC.Where(z => z.IdConvenioLaboralTrabajadorCategoria == Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir).ToList();
            }
            else
            { trabajadorLIC = trabajadoresLIC.Where(z => z.IdConvenioLaboralTrabajadorCategoria == Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir && z.IdIncidenciaTrabajador == IdIncidenciaTrabajador).ToList(); }


            var trabajadornuevoingreso = db.Kardex_ctTrabajador.Where(p => p.IdKardex == Kardex_solicitudevaluaciones.IdKardexCandidato);
            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string query = string.Format(@"SELECT        a.FechaSolicitud, a.FechaInicio, a.FechaTermino, b.IdConvenioLaboralTrabajadorCategoriaCubierto, a.EsAtendida, a.CicloEscolar, b.IdConvenioLaboralTrabajadorCategoria AS IdSuplente, 
                                     c.IdConvenioLaboralTrabajadorCategoria, c.Nombre, c.ApellidoPaterno, c.ApellidoMaterno
                                     FROM dbo.Nomina_SuplenciasSolicitudes AS a 
                                    INNER JOIN dbo.Convenios_SuplenciasControl AS b ON a.IdSuplenciaSolicitud = b.IdSuplenciaSolicitud 
                                    INNER JOIN dbo.vwDatosAspirantesTrabajadores AS c ON b.IdConvenioLaboralTrabajadorCategoria = c.IdConvenioLaboralTrabajadorCategoria
		                            where a.EsAtendida = 1 
                                and a.IdKardexSuplente<>a.IdKardexSuplido
		                             AND a.FechaTermino>=GETDATE()
                                    and b.IdConvenioLaboralTrabajadorCategoriaCubierto ={0}", Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir);


            var trabajadoresrelacioncubiertos = (List<TrabajadoresCubiertos>)dpcg.connection.Query<TrabajadoresCubiertos>(query);

            query = $@"SELECT FechaInicio,FechaTermino,CicloEscolar,b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno
  FROM  [Kardex_SolicitudEvaluaciones] a
  inner join Kardex_ctDatosPersonales b on a.IdKardexCandidato=b.IdKardex
 where  IdKardexCandidato={Kardex_solicitudevaluaciones.IdKardexCandidato}
 and  (year(fechainicio)={Kardex_solicitudevaluaciones.FechaInicio.Year} or year(fechatermino)={Kardex_solicitudevaluaciones.FechaTermino.Year})";


            var trabajadoresconsolicitudes = (List<TrabajadoresCubiertos>)dpcg.connection.Query<TrabajadoresCubiertos>(query);

            dpcg.Close();
            bool haytraslape = false;
            if (trabajadorexiste.Count() > 0)
            {
                foreach (var item in trabajadorexiste)
                {
                    haytraslape = Nova.Models.TrabajadoresEvaluacionesSuplir.getValidarFechas(Kardex_solicitudevaluaciones.FechaInicio, Kardex_solicitudevaluaciones.FechaTermino, item.FechaInicio, item.FechaTermino);
                    if (haytraslape)
                    {
                        string msj = $"Existe un translape en el Tipo de Suplencia: " + tiposuplencia.TipoSuplencia + " con Fecha de Inicio: " + trabajadorexiste.OrderByDescending(z => z.IdKardexSolicitudEvaluacion).FirstOrDefault().FechaInicio.ToShortDateString() + " y Fecha de  Termino " + trabajadorexiste.OrderByDescending(z => z.IdKardexSolicitudEvaluacion).FirstOrDefault().FechaTermino.ToShortDateString() + " de " + item.Kardex_ctDatosPersonales.Nombre + " " + item.Kardex_ctDatosPersonales.ApellidoPaterno + " " + item.Kardex_ctDatosPersonales.ApellidoMaterno;
                        return JsonView(false, msj);
                    }
                }
            }


            if (trabajadoresconsolicitudes.Count() > 0)
            {
                foreach (var item in trabajadoresconsolicitudes)
                {
                    haytraslape = Nova.Models.TrabajadoresEvaluacionesSuplir.getValidarFechas(Kardex_solicitudevaluaciones.FechaInicio, Kardex_solicitudevaluaciones.FechaTermino, item.FechaInicio, item.FechaTermino);
                    if (haytraslape)
                    {
                        string msj = $"El candidato ya tiene un solicitud con Fecha de Inicio: " + item.FechaInicio.ToShortDateString() + " y Fecha de  Termino " + item.FechaTermino.ToShortDateString();
                        return JsonView(false, msj);
                    }
                }
            }

            bool hayduplicado = false;
            if (trabajadorduplicado.Count() > 0)
            {
                foreach (var item in trabajadorduplicado)
                {
                    hayduplicado = Nova.Models.TrabajadoresEvaluacionesSuplir.getValidarFechasTrabajadorDuplicado(Kardex_solicitudevaluaciones.FechaInicio, Kardex_solicitudevaluaciones.FechaTermino, Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir, item.FechaInicio, item.FechaTermino, item.IdConvenioLaboralTrabajadorCategoriaaCubrir);
                    if (hayduplicado)
                    {
                        var nombrecubrir = db.vwDatosAspirantesTrabajadores.Where(y => y.IdConvenioLaboralTrabajadorCategoria == Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir);

                        string msj = $"Existe ya una solicitud  de evaluación o ingreso  del  Personal de BASE o Interino: " + nombrecubrir.FirstOrDefault().Nombre + " " + nombrecubrir.FirstOrDefault().ApellidoPaterno + " " + nombrecubrir.FirstOrDefault().ApellidoMaterno + " de Tipo de Suplencia: " + tiposuplencia.TipoSuplencia + " con Fecha de Inicio: " + trabajadorduplicado.OrderByDescending(z => z.IdKardexSolicitudEvaluacion).FirstOrDefault().FechaInicio.ToShortDateString() + " y Fecha de  Termino " + trabajadorduplicado.OrderByDescending(z => z.IdKardexSolicitudEvaluacion).FirstOrDefault().FechaTermino.ToShortDateString() + "";
                        return JsonView(false, msj);
                    }
                }
            }

            bool hayduplicadocubierto = false;
            if (trabajadoresrelacioncubiertos.Count() > 0)
            {
                foreach (var item in trabajadoresrelacioncubiertos)
                {
                    hayduplicadocubierto = Nova.Models.TrabajadoresEvaluacionesSuplir.getValidarFechasTrabajadorDuplicado(Kardex_solicitudevaluaciones.FechaInicio, Kardex_solicitudevaluaciones.FechaTermino, Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir, item.FechaInicio, item.FechaTermino, item.IdConvenioLaboralTrabajadorCategoriaCubierto);
                    if (hayduplicadocubierto)
                    {
                        string msj = $"No es posible agregar la solicitud debido a que actualmente existe una solicitud de ingreso activa para : " + item.Nombre + " " + item.ApellidoPaterno + " " + item.ApellidoMaterno + " de Tipo de Suplencia: " + tiposuplencia.TipoSuplencia + " con Fecha de Inicio: " + item.FechaInicio.ToShortDateString() + " y Fecha de  Termino " + item.FechaTermino.ToShortDateString() + "";
                        return JsonView(false, msj);
                    }
                }
            }
            bool hayduplicadoLIC = false;
            if (trabajadorLIC.Count() > 0)
            {
                if (tiposuplencia.IdTipoSuplencia != 5)
                {
                    foreach (var item in trabajadorLIC)
                    {
                        hayduplicadoLIC = Nova.Models.TrabajadoresEvaluacionesSuplir.getValidarFechasTrabajadorDuplicadoLIC(Kardex_solicitudevaluaciones.FechaInicio, Kardex_solicitudevaluaciones.FechaTermino, Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir, item.FechaInicioIncidencia, item.FechaTerminoIncidencia, item.IdConvenioLaboralTrabajadorCategoria);
                        if (hayduplicadoLIC)
                        {
                            var nombrecubrir = db.vwDatosAspirantesTrabajadores.Where(y => y.IdConvenioLaboralTrabajadorCategoria == Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir);

                            string msj = $"La solicitud  de evaluación o ingreso  del  Personal de BASE o Interino: " + nombrecubrir.FirstOrDefault().Nombre + " " + nombrecubrir.FirstOrDefault().ApellidoPaterno + " " + nombrecubrir.FirstOrDefault().ApellidoMaterno + " de Tipo de Suplencia: " + tiposuplencia.TipoSuplencia + " con Fecha de Inicio: " + trabajadorLIC.OrderByDescending(z => z.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().FechaInicioIncidencia.ToShortDateString() + " y Fecha de  Termino " + trabajadorLIC.OrderByDescending(z => z.IdConvenioLaboralTrabajadorCategoria).FirstOrDefault().FechaTerminoIncidencia.ToShortDateString() + " no corresponde a las fecha del tipo de suplencia" + "";
                            return JsonView(false, msj);
                        }
                    }



                }


            }
            //Trabajadores nuevos

            if (trabajadornuevoingreso.Count() == 0)
            {
                //DateTime FechaIngreso = DateTime.Parse("2024-02-12");
                DateTime FechaIngreso = db.Nomina_ContratosConfiguracion.Where(a=> a.EsVigente == true).FirstOrDefault().FechaInicioContrato;

                if (Kardex_solicitudevaluaciones.FechaInicio.Date < FechaIngreso.Date && Kardex_solicitudevaluaciones.CicloEscolar == vigencia.CicloEscolar)
                {

                    string msj = $"La Fecha de Inicio debe ser mayor o igual al " + FechaIngreso.ToShortDateString();
                    return JsonView(false, msj);

                }


            }

            if (tiposuplencia.TipoSuplencia == "POR NECESIDADES DEL CENTRO")
            {
                if (Kardex_solicitudevaluaciones.Observaciones != null)
                {
                    if (Kardex_solicitudevaluaciones.Observaciones.ToLower().Contains("licencia") || Kardex_solicitudevaluaciones.Observaciones.ToLower().Contains("comisi") || Kardex_solicitudevaluaciones.Observaciones.ToLower().Contains("incapacidad"))
                    {
                        string msj = $"No se puede realizar la solicitud por el tipo de suplencia, es necesario  elejir la correcta";
                        return JsonView(false, msj);

                    }
                }

            }

            //DateTime.Now
            if (Kardex_solicitudevaluaciones.FechaInicio >= vigencia.FechaInicioProceso)

            {
                if (Kardex_solicitudevaluaciones.FechaInicio >= Kardex_solicitudevaluaciones.FechaTermino)
                {
                    string msj = $"La Fecha de Inicio no debe ser mayor a la Fecha de Termino";
                    return JsonView(false, msj);
                }
                if (tiposuplencia == null)

                {
                    string msj = $"Es necesario seleccionar un Tipo de Movimiento";
                    return JsonView(false, msj);
                }

                if (Kardex_solicitudevaluaciones.IdRelacionLaboral == 2)
                {
                    if (tiposuplencia.TipoSuplencia == "POR NECESIDADES DEL CENTRO")
                    {
                        if (Kardex_solicitudevaluaciones.IdEstructuraOrganicaAdscripcion == null || Kardex_solicitudevaluaciones.IdCategoriaAspirante == null || Kardex_solicitudevaluaciones.NumeroOficio == null)

                        {
                            string msj = $"Es necesario capturar todos los campos";
                            return JsonView(false, msj);
                        }
                    }
                    else
                    {
                        if (Kardex_solicitudevaluaciones.NumeroOficio == null)

                        {
                            string msj = $"Es necesario capturar el numero de Oficio";
                            return JsonView(false, msj);
                        }

                    }



                }
                if (Kardex_solicitudevaluaciones.IdRelacionLaboral == 1)
                {
                    if (tiposuplencia.TipoSuplencia == "POR NECESIDADES DEL CENTRO")
                    {
                        if (Kardex_solicitudevaluaciones.IdEstructuraOrganicaAdscripcion == null || Kardex_solicitudevaluaciones.NumeroOficio == null)

                        {
                            string msj = $"Es necesario capturar todos los campos";
                            return JsonView(false, msj);
                        }
                    }
                    else
                    {
                        if (Kardex_solicitudevaluaciones.NumeroOficio == null)

                        {
                            string msj = $"Es necesario capturar todos los campos";
                            return JsonView(false, msj);
                        }

                    }
                }
                if (Kardex_solicitudevaluaciones.FechaInicio >= vigencia.FechaInicioContrato && Kardex_solicitudevaluaciones.FechaTermino <= vigencia.FechaTerminoContrato)
                {
                    if (Kardex_solicitudevaluaciones.HorasSemanaMes <= 40 || Kardex_solicitudevaluaciones.HorasSemanaMes == null)
                    {

                        if (tiposuplencia.TipoSuplencia != "POR NECESIDADES DEL CENTRO" && Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir == 0)

                        {
                            string msj = $"Es necesario seleccionar Personal BASE o Interino a Suplir";
                            return JsonView(false, msj);
                        }

                        else
                        {
                            if (ModelState.IsValid)
                            {
                                try
                                {
                                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                                    {

                                        solicitudeval.FechaSolicitud = DateTime.Now;
                                        solicitudeval.IdConvenioLaboralTrabajadorCategoriaRegistro = IdCLTCR;
                                        solicitudeval.IdEstructuraOrganicaLaboraFisicamente = Kardex_solicitudevaluaciones.IdEstructuraOrganicaLaboraFisicamente;

                                        if (tiposuplencia.TipoSuplencia != "POR NECESIDADES DEL CENTRO")
                                        {
                                            if (Kardex_solicitudevaluaciones.IdRelacionLaboral == 2)
                                            { solicitudeval.IdEstructuraOrganicaAdscripcion = (short)adscripcion.FirstOrDefault().IdEstructuraOrganica; }
                                            else
                                            {
                                                // cambio por la solicitud hecha por el encargado de la nomina docente
                                                //solicitudeval.IdEstructuraOrganicaAdscripcion = (short)adscripcion.FirstOrDefault().IdEstructuraOrganica;
                                                solicitudeval.IdEstructuraOrganicaAdscripcion = Kardex_solicitudevaluaciones.IdEstructuraOrganicaLaboraFisicamente;
                                            }
                                            // cambio por la solicitud hecha por el encargado de la nomina docente
                                            //solicitudeval.IdEstructuraOrganicaAdscripcion = (short)adscripcion.FirstOrDefault().IdEstructuraOrganica;
                                            //solicitudeval.IdEstructuraOrganicaAdscripcion = Kardex_solicitudevaluaciones.IdEstructuraOrganicaLaboraFisicamente;
                                        }
                                        else
                                        {
                                            solicitudeval.IdEstructuraOrganicaAdscripcion = Kardex_solicitudevaluaciones.IdEstructuraOrganicaAdscripcion;

                                        }

                                        if (tiposuplencia.TipoSuplencia == "POR NECESIDADES DEL CENTRO")
                                        {
                                            if (Kardex_solicitudevaluaciones.IdRelacionLaboral == 2)
                                            {
                                                solicitudeval.IdCategoriaAspirante = Kardex_solicitudevaluaciones.IdCategoriaAspirante;
                                            }
                                            else
                                            {
                                                if (datos.IdModalidadEstudio == 1)
                                                {
                                                    solicitudeval.IdCategoriaAspirante = 118;

                                                }
                                                else if (datos.IdModalidadEstudio == 2)
                                                {
                                                    solicitudeval.IdCategoriaAspirante = 120;

                                                }
                                                else
                                                {
                                                    solicitudeval.IdCategoriaAspirante = 0;

                                                }

                                            }

                                        }
                                        else
                                        {
                                            if (Kardex_solicitudevaluaciones.IdRelacionLaboral == 2)
                                            {
                                                string categoriasuplir = adscripcion.FirstOrDefault().Categoria;
                                                var categoriaaspirante = db.Plazas_ctCategoria.Where(y => y.Categoria == categoriasuplir && y.IdRelacionConvenioLaboral == 10);

                                                solicitudeval.IdCategoriaAspirante = categoriaaspirante.FirstOrDefault().IdCategoria;
                                            }
                                            else
                                            {
                                                if (adscripcion.FirstOrDefault().IdModalidadEstudio == 1)
                                                {
                                                    solicitudeval.IdCategoriaAspirante = 118;

                                                }
                                                else if (adscripcion.FirstOrDefault().IdModalidadEstudio == 2)
                                                {
                                                    solicitudeval.IdCategoriaAspirante = 120;

                                                }
                                                else
                                                {
                                                    if (plazabasesuplido.Any(a => a.EstructuraOrganica.ToUpper().Contains("PLANTEL") && a.RelacionLaboral == "DOCENTE" && a.EsPlazaBase == true))
                                                    {
                                                        solicitudeval.IdCategoriaAspirante = 118;

                                                    }

                                                    else if (plazabasesuplido.Any(a => a.EstructuraOrganica.ToUpper().Contains("EMSAD") && a.RelacionLaboral == "DOCENTE" && a.EsPlazaBase == true))
                                                    {
                                                        solicitudeval.IdCategoriaAspirante = 120;

                                                    }

                                                    else { solicitudeval.IdCategoriaAspirante = 0; }

                                                }

                                            }


                                        }

                                        if (Kardex_solicitudevaluaciones.IdTipoSuplencia == 6)//COMISIÓN PARA OCUPAR PLAZA VACANTE
                                        {
                                            Kardex_solicitudevaluaciones.IdTipoSuplencia = 18;
                                        }


                                            solicitudeval.IdTipoSuplencia = Kardex_solicitudevaluaciones.IdTipoSuplencia;
                                        solicitudeval.IdKardexCandidato = Kardex_solicitudevaluaciones.IdKardexCandidato;
                                        if (Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir == 0)
                                        {
                                            solicitudeval.IdConvenioLaboralTrabajadorCategoriaaCubrir = null;
                                        }
                                        else { solicitudeval.IdConvenioLaboralTrabajadorCategoriaaCubrir = Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir; }

                                        solicitudeval.FechaInicio = Kardex_solicitudevaluaciones.FechaInicio;
                                        solicitudeval.FechaTermino = Kardex_solicitudevaluaciones.FechaTermino;
                                        solicitudeval.NumeroOficio = "STSCECyTEO/SRH/" + Kardex_solicitudevaluaciones.NumeroOficio + "/" + DateTime.Now.Year;
                                        solicitudeval.Observaciones = Kardex_solicitudevaluaciones.Observaciones;
                                        //if (idkardexexiste == null)
                                        //{
                                        //    solicitudeval.IdEstatusContratacion = 1;
                                        //}
                                        //else
                                        //{
                                        //    if (idkardexexiste.IdAreaConocimiento == Kardex_solicitudevaluaciones.IdAreaConocimiento)
                                        //    {

                                        //        if (idkardexexiste.EsAceptable == true)
                                        //        {

                                        //            solicitudeval.IdEstatusContratacion = 2;



                                        //        }
                                        //        else { solicitudeval.IdEstatusContratacion = 3; }

                                        //    }
                                        //    else { solicitudeval.IdEstatusContratacion = 1; }

                                        //}

                                        //---------------------------Inicia estatus contrato --------------
                                        if (idkardexexiste == null)
                                        {
                                            solicitudeval.IdEstatusContratacion = 1;
                                        }
                                        else
                                        {
                                            if (Kardex_solicitudevaluaciones.IdRelacionLaboral == 2)
                                            {
                                                if (tiposuplencia.TipoSuplencia == "POR NECESIDADES DEL CENTRO")
                                                {
                                                    var plaza = db.Plazas_ctCategoria.Where(a => a.IdCategoria == Kardex_solicitudevaluaciones.IdCategoriaAspirante);
                                                    var areaconocimientoplaza = db.Kardex_ctAreaConocimiento.Where(a => a.AreaConocimiento == plaza.FirstOrDefault().Categoria && a.IdModalidadEstudio == datos.IdModalidadEstudio && a.IdRelacionLaboral == Kardex_solicitudevaluaciones.IdRelacionLaboral);
                                                    var idkardexexistecapacitacion = db.Kardex_ResultadoEvaluacion.Where(z => z.IdKardex == Kardex_solicitudevaluaciones.IdKardexCandidato && z.IdAreaConocimiento == areaconocimientoplaza.FirstOrDefault().IdAreaConocimiento).FirstOrDefault();
                                                    if (idkardexexistecapacitacion != null)
                                                    {
                                                        if (idkardexexistecapacitacion.EsAceptable == true)
                                                        {
                                                            solicitudeval.IdEstatusContratacion = 2;
                                                        }
                                                        else { solicitudeval.IdEstatusContratacion = 3; }

                                                    }
                                                    else { solicitudeval.IdEstatusContratacion = 1; }
                                                }
                                                else
                                                {
                                                    string categoriabaja = adscripcion.FirstOrDefault().Categoria;
                                                    //var plaza = db.Plazas_ctCategoria.Where(a => a.IdCategoria == Kardex_solicitudevaluaciones.IdCategoriaAspirante);
                                                    var areaconocimientoplaza = db.Kardex_ctAreaConocimiento.Where(a => a.AreaConocimiento == categoriabaja && a.IdModalidadEstudio == datos.IdModalidadEstudio && a.IdRelacionLaboral == Kardex_solicitudevaluaciones.IdRelacionLaboral);
                                                    var idkardexexistecapacitacion = db.Kardex_ResultadoEvaluacion.Where(z => z.IdKardex == Kardex_solicitudevaluaciones.IdKardexCandidato && z.IdAreaConocimiento == areaconocimientoplaza.FirstOrDefault().IdAreaConocimiento).FirstOrDefault();
                                                    if (idkardexexistecapacitacion != null)
                                                    {
                                                        if (idkardexexistecapacitacion.EsAceptable == true)
                                                        {
                                                            solicitudeval.IdEstatusContratacion = 2;
                                                        }
                                                        else { solicitudeval.IdEstatusContratacion = 3; }
                                                    }
                                                    else { solicitudeval.IdEstatusContratacion = 1; }
                                                }
                                            }
                                            else
                                            {
                                                var idkardexexistecap = db.Kardex_ResultadoEvaluacion.Where(z => z.IdKardex == Kardex_solicitudevaluaciones.IdKardexCandidato && z.IdAreaConocimiento == Kardex_solicitudevaluaciones.IdAreaConocimiento).FirstOrDefault();

                                                if (idkardexexistecap != null)
                                                {
                                                    if (idkardexexistecap.EsAceptable == true)
                                                    {
                                                        solicitudeval.IdEstatusContratacion = 2;
                                                    }
                                                    else { solicitudeval.IdEstatusContratacion = 3; }

                                                }
                                                else { solicitudeval.IdEstatusContratacion = 1; }
                                            }
                                        }
                                        //---------------------------Termina  estatus contrato  --------------
                                        if (Kardex_solicitudevaluaciones.IdRelacionLaboral == 2)
                                        {
                                            if (tiposuplencia.TipoSuplencia == "POR NECESIDADES DEL CENTRO")
                                            {
                                                //string categoriabaja = adscripcion.FirstOrDefault().Categoria;
                                                var plaza = db.Plazas_ctCategoria.Where(a => a.IdCategoria == Kardex_solicitudevaluaciones.IdCategoriaAspirante);
                                                var areaconocimientoplaza = db.Kardex_ctAreaConocimiento.Where(a => a.AreaConocimiento == plaza.FirstOrDefault().Categoria && a.IdModalidadEstudio == datos.IdModalidadEstudio && a.IdRelacionLaboral == Kardex_solicitudevaluaciones.IdRelacionLaboral);
                                                solicitudeval.IdAreaConocimiento = areaconocimientoplaza.FirstOrDefault().IdAreaConocimiento;

                                            }
                                            else
                                            {
                                                string categoriabaja = adscripcion.FirstOrDefault().Categoria;
                                                //var plaza = db.Plazas_ctCategoria.Where(a => a.IdCategoria == Kardex_solicitudevaluaciones.IdCategoriaAspirante);
                                                var areaconocimientoplaza = db.Kardex_ctAreaConocimiento.Where(a => a.AreaConocimiento == categoriabaja && a.IdModalidadEstudio == datos.IdModalidadEstudio && a.IdRelacionLaboral == Kardex_solicitudevaluaciones.IdRelacionLaboral);
                                                solicitudeval.IdAreaConocimiento = areaconocimientoplaza.FirstOrDefault().IdAreaConocimiento;

                                            }


                                        }
                                        else
                                        {
                                            solicitudeval.IdAreaConocimiento = Kardex_solicitudevaluaciones.IdAreaConocimiento;
                                        }
                                        solicitudeval.IdRelacionLaboral = Kardex_solicitudevaluaciones.IdRelacionLaboral;

                                        if (Kardex_solicitudevaluaciones.IdRelacionLaboral == 2)
                                        {
                                            solicitudeval.HorasSemanaMes = 35;
                                            solicitudeval.HorasExcedentes = 0;

                                        }
                                        else
                                        {
                                            solicitudeval.HorasSemanaMes = Kardex_solicitudevaluaciones.HorasSemanaMes;
                                            solicitudeval.HorasExcedentes = Kardex_solicitudevaluaciones.HorasExcedentes;
                                        }



                                        solicitudeval.CicloEscolar = Kardex_solicitudevaluaciones.CicloEscolar;
                                        db.Kardex_SolicitudEvaluaciones.Add(solicitudeval);
                                        db.SaveChanges();


                                        //evaluaciones.IdKardex = Kardex_solicitudevaluaciones.IdKardexCandidato;
                                        //evaluaciones.EsAceptable = false;
                                        //evaluaciones.FechaEvaluacion = DateTime.Now;                                   
                                        //evaluaciones.IdAreaConocimiento = Kardex_solicitudevaluaciones.IdAreaConocimiento;
                                        //evaluaciones.IdKardexUsuario = IdKardexUsuario;
                                        //evaluaciones.FechaRegistro = DateTime.Now;
                                        //db.Kardex_ResultadoEvaluacion.Add(evaluaciones);
                                        //db.SaveChanges();



                                        if (idkardexexiste != null)
                                        {
                                            if (idkardexexiste.EsAceptable == true && idkardexexiste.IdAreaConocimiento == Kardex_solicitudevaluaciones.IdAreaConocimiento)
                                            {

                                                UrlEncryptor crip = new UrlEncryptor(new { Id = solicitudeval.IdKardexSolicitudEvaluacion });
                                                string baseUrl = Request.Url.GetLeftPart(UriPartial.Authority) + Url.Action("Index", "Seleccion", new { token = crip.EncryptedQueryString });
                                                Nova.Models.IngresoPersonal.IngresoPersonal.enviaMailIngresoPersonal(baseUrl, solicitudeval.IdKardexSolicitudEvaluacion);


                                            }
                                        }


                                        if (trabajadornuevoingreso.Count() == 0)
                                        {
                                            bool existeevaluacion = false;

                                            if (idkardexexiste != null)
                                                existeevaluacion = true;


                                            if (existeevaluacion)
                                            {
                                                if (idkardexexiste.EsAceptable == true)
                                                {

                                                    UrlEncryptor crip = new UrlEncryptor(new { Id = solicitudeval.IdKardexSolicitudEvaluacion });
                                                    string baseUrl = Request.Url.GetLeftPart(UriPartial.Authority) + Url.Action("Index", "Seleccion", new { token = crip.EncryptedQueryString });
                                                    Nova.Models.IngresoPersonal.IngresoPersonal.enviaMailIngresoPersonal(baseUrl, solicitudeval.IdKardexSolicitudEvaluacion);


                                                }
                                                else
                                                {
                                                    Nova.Models.IngresoPersonal.IngresoPersonal.enviaMailNuevoIngreso("", solicitudeval.IdKardexSolicitudEvaluacion);
                                                }


                                            }
                                            else
                                            {
                                                Nova.Models.IngresoPersonal.IngresoPersonal.enviaMailNuevoIngreso("", solicitudeval.IdKardexSolicitudEvaluacion);
                                            }

                                        }

                                        string msj = $"se ha guardado la solicitud para: {datosmensajenotificacion.Nombre + " " + datosmensajenotificacion.ApellidoPaterno + " " + datosmensajenotificacion.ApellidoMaterno}";
                                        SendPushNotification(msj, TypePushNotification.success, "Nómina");
                                        trans.Complete();
                                    }

                                    return JsonView(true, "El archivo es agregado satisfactoriamente");


                                }
                                catch (Exception e)
                                {
                                    string msj = ExceptionExtensions.GetOriginalException(e).Message;
                                    if (msj.Contains("clave duplicada"))
                                    {
                                        msj = "Ya existe un registro, revisar su información";

                                    }
                                    return JsonView(false, msj);


                                }


                                return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                                //}



                            }
                            else
                            {
                                string msj = "";

                                foreach (var item in ModelState.Values.Where(z => z.Errors.Count() > 0))
                                {
                                    foreach (var error in item.Errors)
                                    {
                                        if (!string.IsNullOrEmpty(error.ErrorMessage))
                                        {
                                            msj += $"<p>{error.ErrorMessage}</p>";
                                        }
                                    }


                                }
                                return Json(new { Valid = false, Message = msj });

                            }
                        }
                    }
                    else
                    {
                        string msj = $"Las horas/semana/mes no pueden ser mayor a 40";
                        return JsonView(false, msj);
                    }
                }
                else
                {


                    string msj = $"Las fechas no estan dentro del rango aceptado Fecha de Inicio{vigencia.FechaInicioContrato}  Fecha Termino {vigencia.FechaTerminoContrato} ";
                    return JsonView(false, msj);
                }

            }
            else
            {

                string msj = $"La fecha de inicio del proceso inicia {vigencia.FechaInicioProceso} ";
                return JsonView(false, msj);
            }
            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }






        public ActionResult VerDetails(int id)
        {

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryexpediente);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = id;
            dp.Close();
            var Expediente = kardex_DocumentosExpediente.Where(z => z.IdKardex == id);

            ViewBag.NombreTrabajador = Expediente.FirstOrDefault().Nombre + " " + Expediente.FirstOrDefault().ApellidoPaterno + " " + Expediente.FirstOrDefault().ApellidoMaterno;

            return View(Expediente);
            //return View(kardex_DocumentosExpediente.Where(z => z.IdKardex == IdKardex));
        }



        // GET: KardexGradoAcademico/Create
        public ActionResult Create()
        {


            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");

            return PartialView();
        }

        // POST: KardexGradoAcademico/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdKardex, Nombre, ApellidoPaterno, ApellidoMaterno,CURP,Telefono, CorreoElectronico, IdKardexNivelEstudio,NivelEstudioDescripcion,AbreviaturaProfesion")] Nova.Models.Kardex_ctDatosPersonalesCandidato kardex_ctdatospersonalescandidato)
        {
            //IdKardex, IdeEmpleadoAnt, CURP, Nombre, ApellidoPaterno, ApellidoMaterno, FechaNacimiento, Sexo, RFC, Calle, NumeroInterior, Letra, NumeroExterior, Colonia, CodigoPostal, IdLocalidadVive, IdMunicipioVive, IdEstadoVive, Telefono, TelefonoCelular, CorreoElectronico, IdLocalidadNacimiento, IdMunicipioNacimiento, IdEstadoNacimiento, IdPais, LaboraFisicamente, Id, ProcesoCompletado, SinNumero, NSS, IdTipoSangre, FechaUltimaActualizacion, EsDocente, Padecimientos, Alergias, IdEstadoCivil, CorreoElectronicoGmail, AceptaAviso, FechaDatosContacto, IdDiscapacidad, IdLenguasIndigenas, IdPueblosIndigenas, EsAltaSindicato,IdKardexNivelEstudio
            Kardex_GradoAcademico kardex_GradoAcademico = new Kardex_GradoAcademico();

            Nova.Models.Kardex_ctDatosPersonales kardex_ctDatosPersonales = new Nova.Models.Kardex_ctDatosPersonales();
            int IdConveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ViewBag.CicloEscolar = Nova.Models.cicloescolarvigente.GetCiclosEscolares().FirstOrDefault().CicloEscolar;
            //oficialia_stAnexoDocumentoEntradaTemporal.UsuarioFechaAnexo = usuarioactual;

            //if (ModelState.IsValid)
            //{

            //var RegistrosRepetidos = db.Kardex_DocumentosExpediente.Where(g => g.IdKardexDocumentosExpediente == kardex_DocumentosExpediente.IdKardexDocumentosExpediente).ToArray();
            //int valor = RegistrosRepetidos.Count();
            //if (valor > 0)
            //{


            //    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
            //}



            //else
            //{

            try
            {
                using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                {


                    kardex_ctDatosPersonales.IdeEmpleadoAnt = 0;
                    kardex_ctDatosPersonales.CURP = kardex_ctdatospersonalescandidato.CURP.ToUpper();
                    kardex_ctDatosPersonales.Nombre = kardex_ctdatospersonalescandidato.Nombre.ToUpper();
                    kardex_ctDatosPersonales.ApellidoPaterno = kardex_ctdatospersonalescandidato.ApellidoPaterno.ToUpper();
                    kardex_ctDatosPersonales.ApellidoMaterno = kardex_ctdatospersonalescandidato.ApellidoMaterno.ToUpper();
                    kardex_ctDatosPersonales.FechaNacimiento = DateTime.Now;
                    kardex_ctDatosPersonales.Sexo = "x";
                    kardex_ctDatosPersonales.RFC = "MAEJ860512123";
                    kardex_ctDatosPersonales.Calle = "X";
                    kardex_ctDatosPersonales.NumeroInterior = 0;
                    kardex_ctDatosPersonales.Letra = "";
                    kardex_ctDatosPersonales.NumeroExterior = 0;
                    kardex_ctDatosPersonales.Colonia = "X";
                    kardex_ctDatosPersonales.CodigoPostal = 0;
                    kardex_ctDatosPersonales.IdLocalidadVive = 0;
                    kardex_ctDatosPersonales.IdMunicipioVive = 0;
                    kardex_ctDatosPersonales.IdEstadoVive = 0;
                    kardex_ctDatosPersonales.Telefono = "";
                    kardex_ctDatosPersonales.TelefonoCelular = kardex_ctdatospersonalescandidato.Telefono;
                    kardex_ctDatosPersonales.CorreoElectronico = kardex_ctdatospersonalescandidato.CorreoElectronico.ToLower();
                    kardex_ctDatosPersonales.IdLocalidadNacimiento = 0;
                    kardex_ctDatosPersonales.IdMunicipioNacimiento = 0;
                    kardex_ctDatosPersonales.IdEstadoNacimiento = 0;
                    kardex_ctDatosPersonales.IdPais = 154;
                    kardex_ctDatosPersonales.LaboraFisicamente = "";
                    kardex_ctDatosPersonales.Id = 0;
                    kardex_ctDatosPersonales.ProcesoCompletado = false;
                    kardex_ctDatosPersonales.SinNumero = false;
                    kardex_ctDatosPersonales.NSS = "";
                    kardex_ctDatosPersonales.IdTipoSangre = 0;
                    kardex_ctDatosPersonales.FechaUltimaActualizacion = DateTime.Now;
                    kardex_ctDatosPersonales.EsDocente = false;
                    kardex_ctDatosPersonales.Padecimientos = "";
                    kardex_ctDatosPersonales.Alergias = "";
                    kardex_ctDatosPersonales.IdEstadoCivil = 1;
                    kardex_ctDatosPersonales.CorreoElectronicoGmail = "";
                    kardex_ctDatosPersonales.AceptaAviso = false;
                    kardex_ctDatosPersonales.FechaDatosContacto = DateTime.Now;
                    kardex_ctDatosPersonales.IdDiscapacidad = 13;
                    kardex_ctDatosPersonales.IdLenguasIndigenas = 12;
                    kardex_ctDatosPersonales.IdPueblosIndigenas = 14;
                    kardex_ctDatosPersonales.EsAltaSindicato = true;
                    kardex_ctDatosPersonales.CorreoElectronicoCFDI = kardex_ctdatospersonalescandidato.CorreoElectronico.ToLower();
                    db.Kardex_ctDatosPersonales.Add(kardex_ctDatosPersonales);
                    db.SaveChanges();

                    kardex_GradoAcademico.IdKardex = kardex_ctDatosPersonales.IdKardex;
                    kardex_GradoAcademico.IdKardexNivelEstudio = Convert.ToInt16(kardex_ctdatospersonalescandidato.IdKardexNivelEstudio);
                    kardex_GradoAcademico.NivelEstudioDescripcion = kardex_ctdatospersonalescandidato.NivelEstudioDescripcion.ToUpper();
                    kardex_GradoAcademico.NumeroCedulaProfesional = 0;
                    kardex_GradoAcademico.AbreviaturaProfesion = kardex_ctdatospersonalescandidato.AbreviaturaProfesion.ToUpper();
                    kardex_GradoAcademico.NombreInstiitucionEscolar = "";
                    kardex_GradoAcademico.AñoTermino = 0;
                    db.Kardex_GradoAcademico.Add(kardex_GradoAcademico);
                    db.SaveChanges();


                    CreaRegistroBdPersonal(kardex_ctDatosPersonales);



                    trans.Complete();
                    return Json(new { Valid = true, Message = "El registro fue agregado satisfactoriamente" });


                }




            }


            catch (Exception e)
            {

                string msj = ExceptionExtensions.GetOriginalException(e).Message;
                if (msj.Contains("clave duplicada"))
                {
                    msj = "Ya existe un registro, revisar su información";
                 }
                return JsonView(false, msj);


            }


            //return JsonView(ModelState.IsValid, "Es necesario capturar todos los campos");
            //}



            //}

            ////ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            //return JsonView(ModelState.IsValid, "El registro  se agrego satisfactoriamente");


        }

        private void CreaRegistroBdPersonal(Nova.Models.Kardex_ctDatosPersonales item)
        {

            TransactionOptions transactionoptions1 = new TransactionOptions();
            transactionoptions1.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;


            using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, transactionoptions1))
            {
                bdPersonalEntities bd = new bdPersonalEntities();
                ctPersonal personal = new ctPersonal();

                personal.Nombre = item.Nombre;
                personal.ApPaterno = item.ApellidoPaterno;
                personal.ApMaterno = item.ApellidoMaterno;
                //personal.CURP2 = item.CURP;
                personal.Curp = "";
                personal.FechaNacimiento = item.FechaNacimiento;
                //personal.Sexo = item.Sexo;
                if (item.IdEstadoCivil == 1)
                    personal.IdEstadoCivil = 1;
                else
                    personal.IdEstadoCivil = 17;

                personal.IdNova = item.IdKardex;
                personal.IdEmpleado = "0";
                personal.IdEstadoNac = item.IdEstadoNacimiento;
                personal.IdEstadoViv = item.IdEstadoVive;
                personal.IdMpioViv = item.IdMunicipioVive;
                personal.IdMpioNac = item.IdMunicipioNacimiento;
                personal.IdLocalidadNac = item.IdLocalidadNacimiento;
                personal.IdLocalidadViv = item.IdLocalidadVive;
                personal.Sexo = item.Sexo;
                personal.Calle = item.Calle;
                personal.Colonia = item.Colonia;

                if (item.SinNumero)
                    personal.Numero = "Sin número";
                else
                    personal.Numero = item.NumeroExterior.ToString() + " " + item.NumeroInterior.ToString();

                personal.CodigoPostal = item.CodigoPostal.ToString();
                personal.NoImss = item.NSS;
                personal.TelefonoFijoParticular = item.Telefono;
                personal.TelefonoCelular1 = item.TelefonoCelular;

                personal.IdPersonalStatus = 1;


                bd.ctPersonal.Add(personal);
                bd.SaveChanges();
                scope.Complete();
            }
        }


        public ActionResult Edit(int IdKardex)
        {

            if (IdKardex == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Kardex_ctDatosPersonalesCandidato kardexcandidato = new Kardex_ctDatosPersonalesCandidato();
            Nova.Models.Kardex_ctDatosPersonales kardextrabajador = db.Kardex_ctDatosPersonales.Find(IdKardex);
            Kardex_GradoAcademico kardexgrado = db.Kardex_GradoAcademico.Where(a => a.IdKardex == IdKardex).OrderByDescending(z => z.IdKardexNivelEstudio).FirstOrDefault();
            ViewBag.IdKardex = IdKardex;
            kardexcandidato.Nombre = kardextrabajador.Nombre;
            kardexcandidato.ApellidoPaterno = kardextrabajador.ApellidoPaterno;
            kardexcandidato.ApellidoMaterno = kardextrabajador.ApellidoMaterno;
            kardexcandidato.CURP = kardextrabajador.CURP;
            kardexcandidato.Telefono = kardextrabajador.TelefonoCelular;
            kardexcandidato.CorreoElectronico = kardextrabajador.CorreoElectronico;
            if (kardexgrado != null)
            {
                kardexcandidato.IdKardexNivelEstudio = kardexgrado.IdKardexNivelEstudio;
                kardexcandidato.NivelEstudioDescripcion = kardexgrado.NivelEstudioDescripcion;
                kardexcandidato.AbreviaturaProfesion = kardexgrado.AbreviaturaProfesion;
                ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio", kardexgrado.IdKardexNivelEstudio);

            }
            else
            {

                kardexcandidato.NivelEstudioDescripcion = "";
                kardexcandidato.AbreviaturaProfesion = "";

                ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            }
            return PartialView(kardexcandidato);

            //return View(kardex_GradoAcademico);
        }

        static string ObtenerSoloNumeros(string input)
        {
            // Utilizar una expresión regular para encontrar solo los dígitos
            Regex regex = new Regex(@"[^\d]");
            string soloNumeros = regex.Replace(input, "");

            return soloNumeros;
        }

        // POST: KardexGradoAcademico/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdKardex, Nombre, ApellidoPaterno, ApellidoMaterno,CURP,Telefono, CorreoElectronico, IdKardexNivelEstudio,NivelEstudioDescripcion,AbreviaturaProfesion")] Nova.Models.Kardex_ctDatosPersonalesCandidato kardex_ctdatospersonalescandidato)
        {
            string msj = "El Grado académico ha sido editado existosamente!";

            Nova.Models.Kardex_ctDatosPersonales kardexdatosPersonales = new Models.Kardex_ctDatosPersonales();
            Kardex_GradoAcademico kardexgrado = new Kardex_GradoAcademico();
            Kardex_GradoAcademico kardexgradonuevo = new Kardex_GradoAcademico();


            if (ModelState.IsValid)
            {

                try
                {

                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {
                       
                        kardexdatosPersonales = db.Kardex_ctDatosPersonales.Find(kardex_ctdatospersonalescandidato.IdKardex);
                        if (kardexdatosPersonales.NSS != null)
                        {
                             kardexdatosPersonales.NSS=ObtenerSoloNumeros(kardexdatosPersonales.NSS);
                        }
                        if (kardexdatosPersonales.Calle == "")
                        {
                            kardexdatosPersonales.Calle = "_";
                        }
                        if (kardexdatosPersonales.Colonia == "")
                        {
                            kardexdatosPersonales.Colonia = "_";
                        }
                        if(kardexdatosPersonales.IdTipoSangre == null)
                        {
                            kardexdatosPersonales.IdTipoSangre = 1;
                        }
                       kardexdatosPersonales.TelefonoCelular = kardex_ctdatospersonalescandidato.Telefono;
                        kardexdatosPersonales.CorreoElectronico = kardex_ctdatospersonalescandidato.CorreoElectronico;

                        db.Entry(kardexdatosPersonales).State = EntityState.Modified;
                        db.SaveChanges();

                        kardexgrado = db.Kardex_GradoAcademico.Where(a => a.IdKardex == kardex_ctdatospersonalescandidato.IdKardex).OrderByDescending(z => z.IdKardexNivelEstudio).FirstOrDefault();
                       if (kardexgrado != null)
                        {
                            kardexgrado.IdKardexNivelEstudio = Convert.ToInt16(kardex_ctdatospersonalescandidato.IdKardexNivelEstudio);
                            kardexgrado.NivelEstudioDescripcion = kardex_ctdatospersonalescandidato.NivelEstudioDescripcion.ToUpper(); ;
                            kardexgrado.AbreviaturaProfesion = kardex_ctdatospersonalescandidato.AbreviaturaProfesion.ToUpper(); ;

                            db.Entry(kardexgrado).State = EntityState.Modified;
                            db.SaveChanges();


                        }
                       else
                        {
                            
                            kardexgradonuevo.IdKardex = kardex_ctdatospersonalescandidato.IdKardex;
                            kardexgradonuevo.IdKardexNivelEstudio = Convert.ToInt16(kardex_ctdatospersonalescandidato.IdKardexNivelEstudio);
                            kardexgradonuevo.NivelEstudioDescripcion = kardex_ctdatospersonalescandidato.NivelEstudioDescripcion.ToUpper();
                            kardexgradonuevo.NumeroCedulaProfesional = 0;
                            kardexgradonuevo.AbreviaturaProfesion = kardex_ctdatospersonalescandidato.AbreviaturaProfesion.ToUpper();
                            kardexgradonuevo.NombreInstiitucionEscolar = "";
                            kardexgradonuevo.AñoTermino = 0;
                            db.Kardex_GradoAcademico.Add(kardexgradonuevo);
                            db.SaveChanges();


                        }

                    


                        trans.Complete();


                    }
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: KardexGradoAcademico/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            if (kardex_GradoAcademico == null)
            {
                return HttpNotFound();
            }
            return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            //db.Kardex_GradoAcademico.Remove(kardex_GradoAcademico);
            string msj = "El registro ha sido eliminado existosamente!";
            var existe = db.Kardex_SolicitudEvaluaciones.Where(a => a.IdKardexCandidato == id).ToList();
            if (existe.Count > 0)
            {
                return Json(new { Valid = false, Message = "El aspirante no se  puede eliminar debido a que existe un proceso de ingreso o evaluación" });
            }
            if (ModelState.IsValid)
            {

                try
                {

                    Nova.Models.Kardex_ctDatosPersonales kardex_ctDatosPersonales = db.Kardex_ctDatosPersonales.Find(id);
                    db.Kardex_ctDatosPersonales.Remove(kardex_ctDatosPersonales);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });




            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
