﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.IO;
using System.Linq;
using System.Net;
using System.Transactions;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Dapper;
using System.Data.SqlClient;
using System.Configuration;
using DevExpress.Web.ASPxHtmlEditor.Internal;
using DevExpress.XtraLayout.Filtering.Templates;
using Nova.Models.Kardex;
using WebGrease.Activities;
using System.Web.UI.WebControls;
using Seguridad;
using System.Net.Sockets;
using System.Runtime.InteropServices.ComTypes;
using DevExpress.CodeParser;
using DevExpress.Utils.About;
using DevExpress.XtraEditors.Filtering.Templates;
using DevExpress.Utils.Extensions;
using DevExpress.XtraSpreadsheet.Import.Xls;
using DotNet.Highcharts.Helpers;
using Nova.Libraries;
using System.Security.Cryptography;
using Nova.Models.Correo;

namespace Nova.Controllers.Kardex
{
    public class Kardex_EvaluacionesController : BaseController
    {
        private bdNovaEntities db = new bdNovaEntities();

        string query = @"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.Archivo,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente";


        string queryexpediente = @"select a.IdKardexDocumentosExpediente,a.IdKardex,a.IdKardexTipoDocumento, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                         a.FechaActualizacion,a.FechaEntrega,a.CicloEscolar, b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.IdKardexTipoDocumento,
                         c.DocumentoExpediente, d.IdKardexDocumentosExpedienteTrabajador,d.TipoDocumento,
                         d.NombreArchivo,d.FechaRegistro from bdNova.dbo.Kardex_DocumentosExpediente a
                         left join bdNova.dbo.Kardex_ctDatosPersonales b on a.IdKardex=b.IdKardex
                         left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                         left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente";

        string queryseguimiento = @"select x.IdKardex, x.Nombre,x.ApellidoPaterno,x.ApellidoMaterno,x.UbicacionFisica,x.RelacionLaboral,x.RelacionConvenioLaboral,x.IdConvenioLaboral, z.Archivos from	 (select a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral    from bdNova.dbo.vwDatosAspirantesTrabajadores  a
								 left join bdNova.dbo.Kardex_DocumentosExpediente b on a.IdKardex=b.IdKardex
								 left join bdNova.dbo.Kardex_TipoDocumento c on b.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 left join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on b.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
									 where  A.EstatusTrabajador = 'ALTA'
								  group by a.IdKardex, a.Nombre,a.ApellidoPaterno,a.ApellidoMaterno,UbicacionFisica,a.RelacionLaboral,a.RelacionConvenioLaboral,a.IdConvenioLaboral)	 x
								  left join ( select  a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                  b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,b.RelacionLaboral,b.RelacionConvenioLaboral 
                                 ,COUNT(*) as Archivos from bdNova.dbo.Kardex_DocumentosExpediente a
                                 left join bdNova.dbo.vwDatosAspirantesTrabajadores b on a.IdKardex=b.IdKardex
                                 left join bdNova.dbo.Kardex_TipoDocumento c on a.IdKardexTipoDocumento = c.IdKardexTipoDocumento
                                 inner join bdNovaDocumentacion.dbo.Kardex_DocumentosExpedienteTrabajador d  on a.IdKardexDocumentosExpediente = d.IdKardexDocumentosExpediente
								 
								  group by a.IdKardex, a.IdConvenioLaboralTrabajadorCategoriaRegistro,
                                 b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,b.UbicacionFisica,
								 b.RelacionLaboral,b.RelacionConvenioLaboral) z on  x.IdKardex= z.IdKardex";



        string queryubicacionfisica = @"SELECT EstructuraOrganica FROM bdNova.dbo.Catalogos_ctEstructuraOrganica
                                        WHERE EsVigente= 1";

        string queryrelacionlaboral = @" SELECT RelacionConvenioLaboral FROM bdNova.dbo.Convenios_stRelacionConvenioLaboral";





        // GET: KardexGradoAcademico
        public ActionResult Index()
        {
            //Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            //var kardex_GradoAcademicodapper= (List<Kardex_GradoAcademicoFotografia>)dp.connection.Query<Kardex_GradoAcademicoFotografia>(query);
            var kardex_GradoAcademico = db.Kardex_GradoAcademico.Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia); ;
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "Crear Grado Académico";
            ViewBag.TituloSwal = "Eliminar Grado Académico";
            ViewBag.PreguntaSwal = "¿Está seguro de eliminar el Grado Académico?";
            //dp.Close();
            return View(kardex_GradoAcademico.ToList()); 
        }

        // GET: KardexGradoAcademico/Details/5

        //public ActionResult Details(int id)
        public ActionResult Details()
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            string CicloEscolar = Nova.Models.cicloescolarvigente.GetCiclosEscolares().FirstOrDefault().CicloEscolar;
           // string query = string.Format(@"select a.IdKardexSolicitudEvaluacion,a.IdKardexCandidato, a.IdConvenioLaboralTrabajadorCategoriaaCubrir, b.Nombre,b.ApellidoPaterno,B.ApellidoMaterno, a.CicloEscolar, d.TipoSuplencia, c.EstructuraOrganica, a.FechaInicio, a.FechaTermino, a.FechaSolicitud, f.EstatusContratos,
           //                             (select Top 1 NivelEstudioDescripcion from  Kardex_GradoAcademico z  where z.Idkardex = a.IdKardexCandidato order by 1 desc ) as GradoAcademico,
											//g.AreaConocimiento, g.IdAreaConocimiento, HorasSemanaMes,  l.Nombre as NombreRegistro,l.ApellidoPaterno  as ApellidoPaternoRegistro,l.ApellidoMaterno  as ApellidoMaternoRegistro,b.CorreoElectronico,m.EsAceptable
	          //                               , m.NumeroOficio,z.Categoria, w.RelacionLaboral,y.TelefonoCelular
											// from Kardex_SolicitudEvaluaciones a
           //                                 inner join  Kardex_ctDatosPersonales b on a.IdKardexCandidato = b .IdKardex
           //                                 inner join  Catalogos_ctEstructuraOrganica c on a.IdEstructuraOrganicaLaboraFisicamente= c.IdEstructuraOrganica
           //                                 inner join  Nomina_SuplenciaTipo d on a.IdTipoSuplencia= d.IdTipoSuplencia
											//left join  Kardex_ResultadoEvaluacion m on a.IdKardexCandidato = m.IdKardex and m.IdAreaConocimiento = a.IdAreaConocimiento											
           //                                 inner join  Catalogos_ctEstatusContratos f on a.IdEstatusContratacion = f.IdEstatusContratos 
											//inner join  Kardex_ctAreaConocimiento g on a.IdAreaConocimiento = g.IdAreaConocimiento
											//inner join  Convenios_stConvenioLaboralTrabajadorCategoria h on a.IdConvenioLaboralTrabajadorCategoriaRegistro = h.IdConvenioLaboralTrabajadorCategoria
											//inner join  Convenios_stConvenioLaboralTrabajador j on h.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
											//inner join  Kardex_ctTrabajador k on j.IdTrabajador= k.IdTrabajador
											//inner join  Kardex_ctDatosPersonales l on l.IdKardex = k.IdKardex
											//Inner join Plazas_ctCategoria z on a.IdCategoriaAspirante = z.IdCategoria
											//inner join Catalogos_ctRelacionLaboral w on a.IdRelacionLaboral = w.IdRelacionLaboral
											//inner join vwDatosAspirantesTrabajadores y on a.IdKardexCandidato = y.IdKardex
           //                                 where  a.CicloEscolar = '{0}'", CicloEscolar);
            string query = string.Format(@"select a.IdKardexSolicitudEvaluacion,a.IdKardexCandidato, a.IdConvenioLaboralTrabajadorCategoriaaCubrir, b.Nombre,b.ApellidoPaterno,B.ApellidoMaterno, a.CicloEscolar, d.TipoSuplencia, c.EstructuraOrganica, a.FechaInicio, a.FechaTermino, a.FechaSolicitud, f.EstatusContratos,
                                        (select  Top 1 NivelEstudioDescripcion from  Kardex_GradoAcademico z
                                            inner join Kardex_NivelEstudio x on z.IdKardexNivelEstudio = x.IdKardexNivelEstudio
                                            where z.Idkardex = a.IdKardexCandidato order by x.Orden desc ) as GradoAcademico,
											g.AreaConocimiento, g.IdAreaConocimiento, HorasSemanaMes,  l.Nombre as NombreRegistro,l.ApellidoPaterno as ApellidoPaternoRegistro,l.ApellidoMaterno as ApellidoMaternoRegistro,b.CorreoElectronico,m.EsAceptable
	                                         , m.NumeroOficio,z.Categoria, w.RelacionLaboral,y.TelefonoCelular
                                             from Kardex_SolicitudEvaluaciones a
                                            inner join  Kardex_ctDatosPersonales b on a.IdKardexCandidato = b.IdKardex
                                            inner join  Catalogos_ctEstructuraOrganica c on a.IdEstructuraOrganicaLaboraFisicamente = c.IdEstructuraOrganica
                                            inner join  Nomina_SuplenciaTipo d on a.IdTipoSuplencia = d.IdTipoSuplencia
                                            left join  Kardex_ResultadoEvaluacion m on a.IdKardexCandidato = m.IdKardex and m.IdAreaConocimiento = a.IdAreaConocimiento
                                            inner join  Catalogos_ctEstatusContratos f on a.IdEstatusContratacion = f.IdEstatusContratos
                                            inner join  Kardex_ctAreaConocimiento g on a.IdAreaConocimiento = g.IdAreaConocimiento
                                            inner join  Convenios_stConvenioLaboralTrabajadorCategoria h on a.IdConvenioLaboralTrabajadorCategoriaRegistro = h.IdConvenioLaboralTrabajadorCategoria
                                            inner join  Convenios_stConvenioLaboralTrabajador j on h.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
                                            inner join  Kardex_ctTrabajador k on j.IdTrabajador = k.IdTrabajador
                                            inner join  Kardex_ctDatosPersonales l on l.IdKardex = k.IdKardex
                                            Inner join Plazas_ctCategoria z on a.IdCategoriaAspirante = z.IdCategoria
                                            inner join Catalogos_ctRelacionLaboral w on a.IdRelacionLaboral = w.IdRelacionLaboral
                                            inner join vwDatosAspirantesTrabajadores y on a.IdKardexCandidato = y.IdKardex
                                            where  a.CicloEscolar = '{0}'", CicloEscolar);

            


            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DatosContratos = (List<TrabajadoresContratos>)dp.connection.Query<TrabajadoresContratos>(query);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            ViewBag.Solicitudes = 0;

            string querycicloescolar = @" select CicloEscolar from Kardex_SolicitudEvaluaciones
                                            group by CicloEscolar";

            var ciclosescolares = (List<TodosCiclosEscolares>)dp.connection.Query<TodosCiclosEscolares>(querycicloescolar);

            IEnumerable<SelectListItem> selectList = from s in ciclosescolares
                                                     select new SelectListItem
                                                     {
                                                         Value = s.CicloEscolar.ToString(),
                                                         Text = s.CicloEscolar
                                                     };
   

            if (selectList.Count() > 0)
            {
                var ciclos = selectList.Where(x => x.Value == CicloEscolar).FirstOrDefault();

                if (ciclos == null)
                {
                    ViewBag.IdCicloEscolar = new SelectList(selectList, "Value", "Text");
                }

                else
                {
                    ViewBag.IdCicloEscolar = new SelectList(selectList, "Value", "Text", selectList.Where(x => x.Value == CicloEscolar).FirstOrDefault().Value);
                }
            }
            else { ViewBag.IdCicloEscolar = new SelectList(selectList, "Value", "Text"); }


            dp.Close();
           
                return View(kardex_DatosContratos);
            
         
        }



        public ActionResult Contratos()
        {

            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            string CicloEscolar = Nova.Models.cicloescolarvigente.GetCiclosEscolares().FirstOrDefault().CicloEscolar;

            string query = string.Format(@"SELECT 
                                                    y.IdTrabajador, max (b.Nombre) as Nombre,max (b.ApellidoPaterno) as ApellidoPaterno,  max ( b.ApellidoMaterno) as ApellidoMaterno,max ( c.EstructuraOrganica) as EstructuraOrganica,
                                                   max ( grado.NivelEstudioDescripcion) as GradoAcademico, max ( grado.NumeroCedulaProfesional) as NumeroCedulaProfesional,max (g.AreaConocimiento) as AreaConocimiento, max (HorasSemanaMes) as HorasSemanaMes, 
                                                   -- m.EsAceptable,
                                                   max (cat.Categoria) as Categoria,max (w.RelacionLaboral) as RelacionLaboral, max ( y.TelefonoCelular) as TelefonoCelular
                                                FROM Kardex_SolicitudEvaluaciones a
                                                INNER JOIN Kardex_ctDatosPersonales b  ON a.IdKardexCandidato = b.IdKardex
                                                INNER JOIN Catalogos_ctEstructuraOrganica c  ON a.IdEstructuraOrganicaLaboraFisicamente = c.IdEstructuraOrganica
                                                INNER JOIN Nomina_SuplenciaTipo d   ON a.IdTipoSuplencia = d.IdTipoSuplencia
                                                LEFT JOIN Kardex_ResultadoEvaluacion m ON a.IdKardexCandidato = m.IdKardex AND m.IdAreaConocimiento = a.IdAreaConocimiento
                                                INNER JOIN Catalogos_ctEstatusContratos f ON a.IdEstatusContratacion = f.IdEstatusContratos
                                                INNER JOIN Kardex_ctAreaConocimiento g  ON a.IdAreaConocimiento = g.IdAreaConocimiento
                                                INNER JOIN Convenios_stConvenioLaboralTrabajadorCategoria h  ON a.IdConvenioLaboralTrabajadorCategoriaRegistro = h.IdConvenioLaboralTrabajadorCategoria
                                                INNER JOIN Convenios_stConvenioLaboralTrabajador j ON h.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
                                                INNER JOIN Kardex_ctTrabajador k  ON j.IdTrabajador = k.IdTrabajador
                                                INNER JOIN Kardex_ctDatosPersonales l  ON l.IdKardex = k.IdKardex
                                                INNER JOIN Plazas_ctCategoria cat   ON a.IdCategoriaAspirante = cat.IdCategoria
                                                INNER JOIN Catalogos_ctRelacionLaboral w  ON a.IdRelacionLaboral = w.IdRelacionLaboral
                                                INNER JOIN vwDatosAspirantesTrabajadores y  ON a.IdKardexCandidato = y.IdKardex

                                                -- Subconsulta para Grado Académico y Cédula Profesional
                                                OUTER APPLY (
                                                    SELECT TOP 1 
                                                        z.NivelEstudioDescripcion,
                                                        z.NumeroCedulaProfesional
                                                    FROM Kardex_GradoAcademico z
                                                    INNER JOIN Kardex_NivelEstudio x 
                                                        ON z.IdKardexNivelEstudio = x.IdKardexNivelEstudio
                                                    WHERE z.IdKardex = a.IdKardexCandidato
                                                    ORDER BY x.Orden DESC
                                                ) grado

                                                group by  y.IdTrabajador
                                            ");


            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DatosContratos = (List<TrabajadoresContratosHistorial>)dp.connection.Query<TrabajadoresContratosHistorial>(query);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            ViewBag.Solicitudes = 0;

            string querycicloescolar = @" select CicloEscolar from Kardex_SolicitudEvaluaciones
                                            group by CicloEscolar";

            var ciclosescolares = (List<TodosCiclosEscolares>)dp.connection.Query<TodosCiclosEscolares>(querycicloescolar);

            IEnumerable<SelectListItem> selectList = from s in ciclosescolares
                                                     select new SelectListItem
                                                     {
                                                         Value = s.CicloEscolar.ToString(),
                                                         Text = s.CicloEscolar
                                                     };


            if (selectList.Count() > 0)
            {
                var ciclos = selectList.Where(x => x.Value == CicloEscolar).FirstOrDefault();

                if (ciclos == null)
                {
                    ViewBag.IdCicloEscolar = new SelectList(selectList, "Value", "Text");
                }

                else
                {
                    ViewBag.IdCicloEscolar = new SelectList(selectList, "Value", "Text", selectList.Where(x => x.Value == CicloEscolar).FirstOrDefault().Value);
                }
            }
            else { ViewBag.IdCicloEscolar = new SelectList(selectList, "Value", "Text"); }


            dp.Close();

            return View(kardex_DatosContratos);


        }

        [HttpPost]
        public ActionResult Historico(int IdKardex)
        {
            string query = string.Format(@"SELECT 
                                   y.IdTrabajador, 
                                    b.Nombre, 
                                    b.ApellidoPaterno, 
                                    b.ApellidoMaterno,  
                                    c.EstructuraOrganica,
                                    grado.NivelEstudioDescripcion AS GradoAcademico,
                                    grado.NumeroCedulaProfesional,
                                    g.AreaConocimiento, 
									d.TipoSuplencia,
									a.CicloEscolar,
                                    HorasSemanaMes, 
                                    m.EsAceptable,
                                    m.EsEvaluado,
                                    m.FechaEvaluacion,
                                    cat.Categoria, 
                                    w.RelacionLaboral,
                                    y.TelefonoCelular

                                FROM Kardex_SolicitudEvaluaciones a

                                INNER JOIN Kardex_ctDatosPersonales b 
                                    ON a.IdKardexCandidato = b.IdKardex

                                INNER JOIN Catalogos_ctEstructuraOrganica c 
                                    ON a.IdEstructuraOrganicaLaboraFisicamente = c.IdEstructuraOrganica

                                INNER JOIN Nomina_SuplenciaTipo d 
                                    ON a.IdTipoSuplencia = d.IdTipoSuplencia

                                LEFT JOIN Kardex_ResultadoEvaluacion m 
                                    ON a.IdKardexCandidato = m.IdKardex 
                                    AND m.IdAreaConocimiento = a.IdAreaConocimiento

                                INNER JOIN Catalogos_ctEstatusContratos f 
                                    ON a.IdEstatusContratacion = f.IdEstatusContratos

                                INNER JOIN Kardex_ctAreaConocimiento g 
                                    ON a.IdAreaConocimiento = g.IdAreaConocimiento

                                INNER JOIN Convenios_stConvenioLaboralTrabajadorCategoria h 
                                    ON a.IdConvenioLaboralTrabajadorCategoriaRegistro = h.IdConvenioLaboralTrabajadorCategoria

                                INNER JOIN Convenios_stConvenioLaboralTrabajador j 
                                    ON h.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador

                                INNER JOIN Kardex_ctTrabajador k 
                                    ON j.IdTrabajador = k.IdTrabajador

                                INNER JOIN Kardex_ctDatosPersonales l 
                                    ON l.IdKardex = k.IdKardex

                                INNER JOIN Plazas_ctCategoria cat 
                                    ON a.IdCategoriaAspirante = cat.IdCategoria

                                INNER JOIN Catalogos_ctRelacionLaboral w 
                                    ON a.IdRelacionLaboral = w.IdRelacionLaboral

                                INNER JOIN vwDatosAspirantesTrabajadores y 
                                    ON a.IdKardexCandidato = y.IdKardex

	
                                -- Subconsulta para Grado Académico y Cédula Profesional
                                OUTER APPLY (
                                    SELECT TOP 1 
                                        z.NivelEstudioDescripcion,
                                        z.NumeroCedulaProfesional
                                    FROM Kardex_GradoAcademico z
                                    INNER JOIN Kardex_NivelEstudio x 
                                        ON z.IdKardexNivelEstudio = x.IdKardexNivelEstudio
                                    WHERE z.IdKardex = a.IdKardexCandidato
                                    ORDER BY x.Orden DESC
                                ) grado
		                                where  y.IdTrabajador ={0}", IdKardex);
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DatosSindicato = (List<TrabajadoresContratosHistorial>)dp.connection.Query<TrabajadoresContratosHistorial>(query);
            if (kardex_DatosSindicato.Count() >= 1)
            {
                ViewBag.Nombre = kardex_DatosSindicato.FirstOrDefault().Nombre + " " + kardex_DatosSindicato.FirstOrDefault().ApellidoPaterno + " " + kardex_DatosSindicato.FirstOrDefault().ApellidoMaterno;
                ViewBag.Ide = kardex_DatosSindicato.FirstOrDefault().IdTrabajador;
                ViewBag.Cedula = kardex_DatosSindicato.FirstOrDefault().NumeroCedulaProfesional;
                ViewBag.GradoEstudios = kardex_DatosSindicato.FirstOrDefault().GradoAcademico;
                ViewBag.Aceptable = kardex_DatosSindicato.FirstOrDefault().EsAceptable;
                ViewBag.Evaluado = kardex_DatosSindicato.FirstOrDefault().EsEvaluado;
                ViewBag.FechaEvaluacion = kardex_DatosSindicato.FirstOrDefault().FechaEvaluacion.ToString("dd/MM/yyyy");


            }
            else
            {
                ViewBag.Nombre = "No existe historial del trabajador";
            }

            dp.Close();
            return View(kardex_DatosSindicato);



            //var historico = db.Kardex_SolicitudEvaluaciones.Where(x => x.IdConvenioLaboralTrabajadorCategoriaRegistro == 8301);
            //return View(historico.ToList());
        }

        [HttpPost]
        public ActionResult Solicitudes(string IdCicloEscolar)
        {

            string Filtro = string.Empty;



            if (IdCicloEscolar != "")
            {
        
                Filtro = "where a.CicloEscolar ='" + IdCicloEscolar + "'";
            }
            if (IdCicloEscolar == "")
            {
                Filtro = "";
            }
           


            int IdKardex = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string querybuscar = @"select a.IdKardexSolicitudEvaluacion,a.IdKardexCandidato, a.IdConvenioLaboralTrabajadorCategoriaaCubrir, b.Nombre,b.ApellidoPaterno,B.ApellidoMaterno, a.CicloEscolar, d.TipoSuplencia, c.EstructuraOrganica, a.FechaInicio, a.FechaTermino, a.FechaSolicitud, f.EstatusContratos,
                                        (select  Top 1 NivelEstudioDescripcion from  Kardex_GradoAcademico z
                                            inner join Kardex_NivelEstudio x on z.IdKardexNivelEstudio = x.IdKardexNivelEstudio
                                            where z.Idkardex = a.IdKardexCandidato order by x.Orden desc ) as GradoAcademico,
											g.AreaConocimiento, g.IdAreaConocimiento, HorasSemanaMes,  l.Nombre as NombreRegistro,l.ApellidoPaterno  as ApellidoPaternoRegistro,l.ApellidoMaterno  as ApellidoMaternoRegistro,b.CorreoElectronico,m.EsAceptable
	                                         , m.NumeroOficio,z.Categoria, w.RelacionLaboral,y.TelefonoCelular
											 from Kardex_SolicitudEvaluaciones a
                                            inner join  Kardex_ctDatosPersonales b on a.IdKardexCandidato = b .IdKardex
                                            inner join  Catalogos_ctEstructuraOrganica c on a.IdEstructuraOrganicaLaboraFisicamente= c.IdEstructuraOrganica
                                            inner join  Nomina_SuplenciaTipo d on a.IdTipoSuplencia= d.IdTipoSuplencia
											left join  Kardex_ResultadoEvaluacion m on a.IdKardexCandidato = m.IdKardex and m.IdAreaConocimiento = a.IdAreaConocimiento											
                                            inner join  Catalogos_ctEstatusContratos f on a.IdEstatusContratacion = f.IdEstatusContratos 
											inner join  Kardex_ctAreaConocimiento g on a.IdAreaConocimiento = g.IdAreaConocimiento
											inner join  Convenios_stConvenioLaboralTrabajadorCategoria h on a.IdConvenioLaboralTrabajadorCategoriaRegistro = h.IdConvenioLaboralTrabajadorCategoria
											inner join  Convenios_stConvenioLaboralTrabajador j on h.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
											inner join  Kardex_ctTrabajador k on j.IdTrabajador= k.IdTrabajador
											inner join  Kardex_ctDatosPersonales l on l.IdKardex = k.IdKardex
											Inner join Plazas_ctCategoria z on a.IdCategoriaAspirante = z.IdCategoria
											inner join Catalogos_ctRelacionLaboral w on a.IdRelacionLaboral = w.IdRelacionLaboral
											inner join vwDatosAspirantesTrabajadores y on a.IdKardexCandidato = y.IdKardex
                                            " + Filtro + " order by a.IdKardexSolicitudEvaluacion DESC ";

            var DatosTrabajador = (List<TrabajadoresContratos>)dp.connection.Query<TrabajadoresContratos>(querybuscar, new { IdCicloEscolar });

            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = IdKardex;
            
            dp.Close();
            return View(DatosTrabajador);
        }


        public ActionResult ResultadoEval(int? id)
        {
            Kardex_ResultadoEvaluacion kardexresultado = new Kardex_ResultadoEvaluacion();
            int IdKardexUsuario = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            string query = string.Format(@" select a.IdKardexSolicitudEvaluacion,a.IdKardexCandidato, a.IdConvenioLaboralTrabajadorCategoriaaCubrir, b.Nombre,b.ApellidoPaterno,B.ApellidoMaterno, a.CicloEscolar, d.TipoSuplencia, c.EstructuraOrganica, a.FechaInicio, a.FechaTermino, a.FechaSolicitud, f.EstatusContratos,
                                        (select  Top 1 NivelEstudioDescripcion from  Kardex_GradoAcademico z
                                            inner join Kardex_NivelEstudio x on z.IdKardexNivelEstudio = x.IdKardexNivelEstudio
                                            where z.Idkardex = a.IdKardexCandidato order by x.Orden desc ) as GradoAcademico,
											g.AreaConocimiento, g.IdAreaConocimiento, HorasSemanaMes,  l.Nombre as NombreRegistro,l.ApellidoPaterno  as ApellidoPaternoRegistro,l.ApellidoMaterno  as ApellidoMaternoRegistro,b.CorreoElectronico,m.EsAceptable
                                            , m.NumeroOficio
											 from Kardex_SolicitudEvaluaciones a
                                            inner join  Kardex_ctDatosPersonales b on a.IdKardexCandidato = b .IdKardex
                                            inner join  Catalogos_ctEstructuraOrganica c on a.IdEstructuraOrganicaLaboraFisicamente= c.IdEstructuraOrganica
                                            inner join  Nomina_SuplenciaTipo d on a.IdTipoSuplencia= d.IdTipoSuplencia
											left join  Kardex_ResultadoEvaluacion m on a.IdKardexCandidato = m.IdKardex and m.IdAreaConocimiento = a.IdAreaConocimiento											
                                            inner join  Catalogos_ctEstatusContratos f on a.IdEstatusContratacion = f.IdEstatusContratos 
											inner join  Kardex_ctAreaConocimiento g on a.IdAreaConocimiento = g.IdAreaConocimiento
											inner join  Convenios_stConvenioLaboralTrabajadorCategoria h on a.IdConvenioLaboralTrabajadorCategoriaRegistro = h.IdConvenioLaboralTrabajadorCategoria
											inner join  Convenios_stConvenioLaboralTrabajador j on h.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
											inner join  Kardex_ctTrabajador k on j.IdTrabajador= k.IdTrabajador
											inner join  Kardex_ctDatosPersonales l on l.IdKardex = k.IdKardex
                                            where  a.IdKardexSolicitudEvaluacion = {0}", id);
            var kardex_DatosContratos = (List<TrabajadoresContratos>)dp.connection.Query<TrabajadoresContratos>(query);

             int IdKardex = kardex_DatosContratos.FirstOrDefault().IdKardexCandidato;
             int IdAreaConocimiento = kardex_DatosContratos.FirstOrDefault().IdAreaConocimiento;


            Kardex_ResultadoEvaluacion resultadoeval = db.Kardex_ResultadoEvaluacion.Where(a => a.IdKardex == IdKardex && a.IdAreaConocimiento == IdAreaConocimiento).FirstOrDefault();
            ViewBag.AñoVigente = "/"+ DateTime.Now.Year;
            
            dp.Close();

            ViewBag.NombreAspirante = kardex_DatosContratos.FirstOrDefault().Nombre + " " + kardex_DatosContratos.FirstOrDefault().ApellidoPaterno + " " + kardex_DatosContratos.FirstOrDefault().ApellidoMaterno;
            ViewBag.IdKardexSolicitudEvaluacion = id;
            
            ViewBag.IdKardex = kardex_DatosContratos.FirstOrDefault().IdKardexCandidato;
            ViewBag.IdAreaConocimiento = kardex_DatosContratos.FirstOrDefault().IdAreaConocimiento;
            ViewBag.IdKardexUsuario = IdKardexUsuario;
            if (resultadoeval == null)
            {ViewBag.NumeroOficio = null; }
            else {ViewBag.NumeroOficio = resultadoeval.NumeroOficio;}
            


            if (resultadoeval != null)
            {
                ViewBag.IdEvaluacionIngreso = resultadoeval.IdEvaluacionIngreso;
                kardexresultado.EsAceptable = resultadoeval.EsAceptable;
                kardexresultado.FechaEvaluacion = resultadoeval.FechaEvaluacion;
                kardexresultado.IdAreaConocimiento = resultadoeval.IdAreaConocimiento;
                kardexresultado.IdKardexUsuario = resultadoeval.IdKardexUsuario;
                kardexresultado.FechaRegistro = resultadoeval.FechaRegistro;
                kardexresultado.NumeroOficio = resultadoeval.NumeroOficio;
                kardexresultado.EsEvaluado = resultadoeval.EsEvaluado;
                return View(kardexresultado);
            }
            else
            {
                ViewBag.IdEvaluacionIngreso = 0;
                return View();

            }
            
        }

        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult ResultadoEval([Bind(Include = "IdEvaluacionIngreso, IdKardex, EsAceptable, FechaEvaluacion, IdAreaConocimiento, IdKardexUsuario, FechaRegistro,NumeroOficio,EsEvaluado")] Kardex_ResultadoEvaluacion Kardex_resultadoevaluacion, int IdKardexSolicitudEvaluacion, bool EnviarCorreo)
        {
            int IdCLTCR = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            var datosmensajenotificacion = db.vwDatosAspirantesTrabajadores.Where(p => p.IdConvenioLaboralTrabajadorCategoria == IdCLTCR).FirstOrDefault();
            int IdKardexUsuario = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Kardex_ResultadoEvaluacion resulteval = new Kardex_ResultadoEvaluacion();
            Kardex_SolicitudEvaluaciones solicitudevaluaciones = new Kardex_SolicitudEvaluaciones();
            var idkardexexiste = db.Kardex_ResultadoEvaluacion.Find(Kardex_resultadoevaluacion.IdEvaluacionIngreso);
            string CicloEscolar = Nova.Models.cicloescolarvigente.GetCiclosEscolares().FirstOrDefault().CicloEscolar;
            var IdrelacionIdkardex = db.Kardex_SolicitudEvaluaciones.Where(x => x.IdKardexCandidato == Kardex_resultadoevaluacion.IdKardex && x.CicloEscolar == CicloEscolar);
            var SolicitudRelacionLaboral = db.Kardex_SolicitudEvaluaciones.Find(IdKardexSolicitudEvaluacion);
            //DateTime.Now

            if (Kardex_resultadoevaluacion.FechaEvaluacion.Year == 0001)
            {
                string msj = $"La Fecha de Evaluación es un dato requerido ";
                return JsonView(false, msj);
            }
            if (Kardex_resultadoevaluacion.NumeroOficio == null)
            {
                string msj = $"El Número de Oficio es un dato requerido ";
                return JsonView(false, msj);
            }

            if (idkardexexiste == null)
            {

                if (ModelState.IsValid)
                {

                    try
                    {

                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                            resulteval.IdKardex = Kardex_resultadoevaluacion.IdKardex;
                            resulteval.EsAceptable = Kardex_resultadoevaluacion.EsAceptable;
                            resulteval.FechaEvaluacion = Kardex_resultadoevaluacion.FechaEvaluacion;
                            resulteval.IdAreaConocimiento = Kardex_resultadoevaluacion.IdAreaConocimiento;
                            resulteval.IdKardexUsuario =Kardex_resultadoevaluacion.IdKardexUsuario;
                            resulteval.FechaRegistro = DateTime.Now;
                            resulteval.NumeroOficio = "CECyTEO/DIFP/" + Kardex_resultadoevaluacion.NumeroOficio;
                            resulteval.EsEvaluado = Kardex_resultadoevaluacion.EsEvaluado;
                            db.Kardex_ResultadoEvaluacion.Add(resulteval);
                            db.SaveChanges();


                            solicitudevaluaciones = db.Kardex_SolicitudEvaluaciones.Where(a => a.IdKardexSolicitudEvaluacion == IdKardexSolicitudEvaluacion).FirstOrDefault();
                            solicitudevaluaciones.IdAreaConocimiento = Kardex_resultadoevaluacion.IdAreaConocimiento;
                            if (Kardex_resultadoevaluacion.EsAceptable == true)
                            {
                                solicitudevaluaciones.IdEstatusContratacion = 2;
                                
                              
                            }

                            else { 
                                
                                solicitudevaluaciones.IdEstatusContratacion = 3;
     
         

                                Nova.Models.IngresoPersonal.IngresoPersonal.enviaResultadoEvaluacionNegativo(solicitudevaluaciones.IdKardexSolicitudEvaluacion);
                            }                           
                            

                            db.Entry(solicitudevaluaciones).State = EntityState.Modified;
                            db.SaveChanges();

                            if (Kardex_resultadoevaluacion.EsAceptable == true 
                                //&& SolicitudRelacionLaboral.IdRelacionLaboral==2
                                )

                            {
                               
                                UrlEncryptor crip = new UrlEncryptor(new { Id = solicitudevaluaciones.IdKardexSolicitudEvaluacion });
                                string baseUrl = Request.Url.GetLeftPart(UriPartial.Authority) + Url.Action("Index", "Seleccion", new { token = crip.EncryptedQueryString });
                                if (EnviarCorreo == true)
                                { Nova.Models.IngresoPersonal.IngresoPersonal.enviaMailIngresoPersonal(baseUrl, solicitudevaluaciones.IdKardexSolicitudEvaluacion); }

                            }




                            string msj = $"se ha guardado la solicitud para: {datosmensajenotificacion.Nombre + " " + datosmensajenotificacion.ApellidoPaterno + " " + datosmensajenotificacion.ApellidoMaterno}";
                            SendPushNotification(msj, TypePushNotification.success, "Nómina");


                            trans.Complete();
                        }
                    }
                    catch (Exception e)
                    {
                        string msj = ExceptionExtensions.GetOriginalException(e).Message;
                        if (msj.Contains("clave duplicada"))
                        {
                            msj = "Ya existe un registro, revisar su información";

                        }
                        return JsonView(false, msj);


                    }



                }



            }
            else 
            
            {
                if (ModelState.IsValid)
                {

                    try
                    {

                        using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                            idkardexexiste.IdEvaluacionIngreso = Kardex_resultadoevaluacion.IdEvaluacionIngreso;
                            idkardexexiste.IdKardex = Kardex_resultadoevaluacion.IdKardex;
                            idkardexexiste.FechaEvaluacion = Kardex_resultadoevaluacion.FechaEvaluacion;
                            idkardexexiste.EsAceptable = Kardex_resultadoevaluacion.EsAceptable;                          
                            idkardexexiste.IdAreaConocimiento = Kardex_resultadoevaluacion.IdAreaConocimiento;
                            idkardexexiste.IdKardexUsuario = Kardex_resultadoevaluacion.IdKardexUsuario;
                            idkardexexiste.FechaRegistro = DateTime.Now;
                            idkardexexiste.NumeroOficio = Kardex_resultadoevaluacion.NumeroOficio;
                            idkardexexiste.EsEvaluado = Kardex_resultadoevaluacion.EsEvaluado;
                            db.Entry(idkardexexiste).State = EntityState.Modified;
                            db.SaveChanges();


                            solicitudevaluaciones = db.Kardex_SolicitudEvaluaciones.Where(a => a.IdKardexSolicitudEvaluacion == IdKardexSolicitudEvaluacion).FirstOrDefault();
                            solicitudevaluaciones.IdAreaConocimiento = Kardex_resultadoevaluacion.IdAreaConocimiento;
                            if (Kardex_resultadoevaluacion.EsAceptable == true)
                            {
                                solicitudevaluaciones.IdEstatusContratacion = 2;
                             
                                
                            }
                            else { 
                                
                                solicitudevaluaciones.IdEstatusContratacion = 3;

                                Nova.Models.IngresoPersonal.IngresoPersonal.enviaResultadoEvaluacionNegativo(solicitudevaluaciones.IdKardexSolicitudEvaluacion);


                            }

                            db.Entry(solicitudevaluaciones).State = EntityState.Modified;
                            db.SaveChanges();

                            if (Kardex_resultadoevaluacion.EsAceptable == true && SolicitudRelacionLaboral.IdRelacionLaboral == 2)

                            {
                                UrlEncryptor crip = new UrlEncryptor(new { Id = solicitudevaluaciones.IdKardexSolicitudEvaluacion });
                                string baseUrl = Request.Url.GetLeftPart(UriPartial.Authority) + Url.Action("Index", "Seleccion", new { token = crip.EncryptedQueryString });
                                if (EnviarCorreo == true)
                                { Nova.Models.IngresoPersonal.IngresoPersonal.enviaMailIngresoPersonal(baseUrl, solicitudevaluaciones.IdKardexSolicitudEvaluacion); }

                            }

                            string msj = $"se ha guardado la solicitud para: {datosmensajenotificacion.Nombre + " " + datosmensajenotificacion.ApellidoPaterno + " " + datosmensajenotificacion.ApellidoMaterno}";
                            SendPushNotification(msj, TypePushNotification.success, "Nómina");

                            

                            trans.Complete();
                           

                        }
                    }
                    catch (Exception e)
                    {
                        string msj = ExceptionExtensions.GetOriginalException(e).Message;
                        if (msj.Contains("clave duplicada"))
                        {
                            msj = "Ya existe un registro, revisar su información";

                        }
                        return JsonView(false, msj);


                    }



                }




            }
            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El registro de evaluación se agrego satisfactoriamente");


        }



        public ActionResult SolicitudXls(string IdCicloEscolar)
        //String[] proyectos,
        {
            string Filtro = string.Empty;



            if (IdCicloEscolar != "")
            {
                Filtro = "where a.CicloEscolar ='" + IdCicloEscolar + "'";
            }
            if (IdCicloEscolar == "")
            {
                Filtro = "";
            }

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            string query = string.Format(@"select a.IdKardexSolicitudEvaluacion,a.IdKardexCandidato, a.IdConvenioLaboralTrabajadorCategoriaaCubrir, b.Nombre,b.ApellidoPaterno,B.ApellidoMaterno, a.CicloEscolar, d.TipoSuplencia, c.EstructuraOrganica, a.FechaInicio, a.FechaTermino, a.FechaSolicitud, f.EstatusContratos,
                                        (select  Top 1 NivelEstudioDescripcion from  Kardex_GradoAcademico z
                                            inner join Kardex_NivelEstudio x on z.IdKardexNivelEstudio = x.IdKardexNivelEstudio
                                            where z.Idkardex = a.IdKardexCandidato order by x.Orden desc ) as GradoAcademico,
											g.AreaConocimiento, g.IdAreaConocimiento, HorasSemanaMes,  l.Nombre as NombreRegistro,l.ApellidoPaterno  as ApellidoPaternoRegistro,l.ApellidoMaterno  as ApellidoMaternoRegistro,b.CorreoElectronico,m.EsAceptable
	                                         , m.NumeroOficio,z.Categoria, w.RelacionLaboral,y.TelefonoCelular
											 from Kardex_SolicitudEvaluaciones a
                                            inner join  Kardex_ctDatosPersonales b on a.IdKardexCandidato = b .IdKardex
                                            inner join  Catalogos_ctEstructuraOrganica c on a.IdEstructuraOrganicaLaboraFisicamente= c.IdEstructuraOrganica
                                            inner join  Nomina_SuplenciaTipo d on a.IdTipoSuplencia= d.IdTipoSuplencia
											left join  Kardex_ResultadoEvaluacion m on a.IdKardexCandidato = m.IdKardex and m.IdAreaConocimiento = a.IdAreaConocimiento											
                                            inner join  Catalogos_ctEstatusContratos f on a.IdEstatusContratacion = f.IdEstatusContratos 
											inner join  Kardex_ctAreaConocimiento g on a.IdAreaConocimiento = g.IdAreaConocimiento
											inner join  Convenios_stConvenioLaboralTrabajadorCategoria h on a.IdConvenioLaboralTrabajadorCategoriaRegistro = h.IdConvenioLaboralTrabajadorCategoria
											inner join  Convenios_stConvenioLaboralTrabajador j on h.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
											inner join  Kardex_ctTrabajador k on j.IdTrabajador= k.IdTrabajador
											inner join  Kardex_ctDatosPersonales l on l.IdKardex = k.IdKardex
											Inner join Plazas_ctCategoria z on a.IdCategoriaAspirante = z.IdCategoria
											inner join Catalogos_ctRelacionLaboral w on a.IdRelacionLaboral = w.IdRelacionLaboral
											inner join vwDatosAspirantesTrabajadores y on a.IdKardexCandidato = y.IdKardex
                                            " + Filtro + " order by a.IdKardexSolicitudEvaluacion DESC");
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var result = (List<TrabajadoresContratos>)dp.connection.Query<TrabajadoresContratos>(query);


            string modalidad = "Reporte_Solicitudes" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);

            return View(result);
        }

        [HttpPost]
        public ActionResult Historicos(int IdKardex)
        {
           string query = string.Format(@"select b.Nombre, b.ApellidoPaterno,b.ApellidoMaterno ,c.Nombre as NombreC, c.ApellidoPaterno as ApellidoPaternoC,c.ApellidoMaterno as ApellidoMaternoC, d.TipoSuplencia , a.FechaInicio, a.FechaTermino, a.CicloEscolar from Kardex_SolicitudEvaluaciones a
		                                inner join vwDatosAspirantesTrabajadores b  on  a.IdKardexCandidato = b.IdKardex 
		                                left join  vwDatosAspirantesTrabajadores c on  a.IdConvenioLaboralTrabajadorCategoriaaCubrir  = c.IdConvenioLaboralTrabajadorCategoria 
		                                inner join Nomina_SuplenciaTipo d on a.IdTipoSuplencia = d.IdTipoSuplencia
		                                where a.IdKardexCandidato ={0}", IdKardex);
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DatosSindicato = (List<TrabajadoresHistorico>)dp.connection.Query<TrabajadoresHistorico>(query);
            if (kardex_DatosSindicato.Count() >= 1)
            {
                ViewBag.Nombre = kardex_DatosSindicato.FirstOrDefault().Nombre + " " + kardex_DatosSindicato.FirstOrDefault().ApellidoPaterno + " " + kardex_DatosSindicato.FirstOrDefault().ApellidoMaterno;


            }
            else
            {
                ViewBag.Nombre = "No existe historial del trabajador";
            }

            dp.Close();
            return View(kardex_DatosSindicato);



            //var historico = db.Kardex_SolicitudEvaluaciones.Where(x => x.IdConvenioLaboralTrabajadorCategoriaRegistro == 8301);
            //return View(historico.ToList());
        }


        public ActionResult ReporteGralSolicitudes()
        //String[] proyectos,
        {

            ViewBag.JefeRecursosHumanos = Models.Kardex_ctDatosPersonales.getJefeRecursosHumanos();
            ViewBag.DirectorAdministrativo = Models.Kardex_ctDatosPersonales.getDirectorAdministrativo();
            ViewBag.Elaboro = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.Nombre + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoPaterno + " " + Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.Kardex_ctDatosPersonales.ApellidoMaterno;

            string query = string.Format(@"SELECT   y.IdTrabajador,b.Nombre,b.ApellidoPaterno,b.ApellidoMaterno,c.EstructuraOrganica,cat.Categoria,
                                            w.RelacionLaboral,y.TelefonoCelular, grado.NivelEstudioDescripcion,grado.NumeroCedulaProfesional,
                                            g.AreaConocimiento,HorasSemanaMes,
                                            CASE WHEN m.EsAceptable = 1 THEN 'SI' ELSE 'NO' END AS EsAceptable,
                                            CASE WHEN m.EsEvaluado = 1 THEN 'SI' ELSE 'NO' END AS EsEvaluado,
                                             CONVERT(date, m.FechaEvaluacion) AS FechaEvaluacion,m.NumeroOficio
                                                 FROM Kardex_SolicitudEvaluaciones a
                                                INNER JOIN Kardex_ctDatosPersonales b  ON a.IdKardexCandidato = b.IdKardex
                                                INNER JOIN Catalogos_ctEstructuraOrganica c  ON a.IdEstructuraOrganicaLaboraFisicamente = c.IdEstructuraOrganica
                                                INNER JOIN Nomina_SuplenciaTipo d   ON a.IdTipoSuplencia = d.IdTipoSuplencia
                                                LEFT JOIN Kardex_ResultadoEvaluacion m ON a.IdKardexCandidato = m.IdKardex AND m.IdAreaConocimiento = a.IdAreaConocimiento
                                                INNER JOIN Catalogos_ctEstatusContratos f ON a.IdEstatusContratacion = f.IdEstatusContratos
                                                INNER JOIN Kardex_ctAreaConocimiento g  ON a.IdAreaConocimiento = g.IdAreaConocimiento
                                                INNER JOIN Convenios_stConvenioLaboralTrabajadorCategoria h  ON a.IdConvenioLaboralTrabajadorCategoriaRegistro = h.IdConvenioLaboralTrabajadorCategoria
                                                INNER JOIN Convenios_stConvenioLaboralTrabajador j ON h.IdConvenioLaboralTrabajador = j.IdConvenioLaboralTrabajador
                                                INNER JOIN Kardex_ctTrabajador k  ON j.IdTrabajador = k.IdTrabajador
                                                INNER JOIN Kardex_ctDatosPersonales l  ON l.IdKardex = k.IdKardex
                                                INNER JOIN Plazas_ctCategoria cat   ON a.IdCategoriaAspirante = cat.IdCategoria
                                                INNER JOIN Catalogos_ctRelacionLaboral w  ON a.IdRelacionLaboral = w.IdRelacionLaboral
                                                INNER JOIN vwDatosAspirantesTrabajadores y  ON a.IdKardexCandidato = y.IdKardex

                                                -- Subconsulta para Grado Académico y Cédula Profesional
                                                OUTER APPLY (
                                                    SELECT TOP 1 
                                                        z.NivelEstudioDescripcion,
                                                        z.NumeroCedulaProfesional
                                                    FROM Kardex_GradoAcademico z
                                                    INNER JOIN Kardex_NivelEstudio x 
                                                        ON z.IdKardexNivelEstudio = x.IdKardexNivelEstudio
                                                    WHERE z.IdKardex = a.IdKardexCandidato
                                                    ORDER BY x.Orden DESC
                                                ) grado

                                             order by y.IdTrabajador");
            List<dynamic> result = new List<dynamic>();
            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");

            result = (List<dynamic>)dp.connection.Query<dynamic>(query);

            dp.Close();

            string modalidad = "Reporte_Solicitudes" + "_Fecha_" + DateTime.Now.ToShortDateString() + ".xls";


            Response.AddHeader("Content-Type", "application/vnd.ms-excel");
            Response.AddHeader("Content-Disposition", "attachment;filename=/" + modalidad);

            return View(result);
        }
        public ActionResult Trabajadores(int id, int idrelacion )

        {
       

            //var aprendizaje = from t in dbaries.ctSecuenciaDidacticaAprendizajeEsperado
            //                  where t.IdSecuenciaDidacticaContenidoEspecifico == id
            //                  select new { t.IdSecuenciaDidacticaAprendizajeEsperado, t.Nombre };

            var trabajadores = Nova.Models.TrabajadoresEvaluacionesSuplir.getTrabajadoresSuplir(id, idrelacion);

            List<SelectListItem> items3 = new List<SelectListItem>();

            foreach (var item in trabajadores)
            {
                items3.Add(new SelectListItem() { 
                                                  Text = (item.Nombre + " " +item.ApellidoPaterno + " " + item.ApellidoMaterno + " /  CURP:"+ item.CURP),
                                                  Value = item.IdKardex.ToString() 
                                                });

            }

            return Json(items3, JsonRequestBehavior.AllowGet);
        }



        public ActionResult Evaluacion(int? IdKardex)
        {
            var DatosTrabajador = db.Kardex_ctDatosPersonales.Where(a => a.IdKardex == IdKardex);

            ViewBag.IdKardexCandidato = IdKardex;
            ViewBag.NombreCompletoCandidato = DatosTrabajador.FirstOrDefault().Nombre + ' ' + DatosTrabajador.FirstOrDefault().ApellidoPaterno + ' ' + DatosTrabajador.FirstOrDefault().ApellidoMaterno;

            

            Nova.Libraries.DapperQuery dpcg = new Nova.Libraries.DapperQuery("bdNovaEntities");

            int IdConvenioLaboral = Seguridad.Identidad.Usuario().Plazas_stDistribucionPlazaCategoria.Plazas_ctCategoria.Convenios_stRelacionConvenioLaboral.Catalogos_ctConvenioLaboral.IdConvenioLaboral;

            string query;

            query = @" select  IdKardex, IdConvenioLaboralTrabajadorCategoria, Nombre,ApellidoPaterno, ApellidoMaterno , Telefono,CorreoElectronico from  vwDatosAspirantesTrabajadores
                                 where EstatusTrabajador = 'ALTA'  and  IdModalidadEstudio>0 and ConvenioLaboral='BASE' and (RestringirMenu is null or Incidencia like '%INCAPACIDAD%')
                                order by IdKardex desc ";
            var Trabajadores = (List<TrabajadoresEvaluaciones>)dpcg.connection.Query<TrabajadoresEvaluaciones>(query);

            dpcg.Close();

            ViewBag.IdTipoSuplencia = new SelectList(db.Nomina_SuplenciaTipo.Where(a=> a.EsSolicitudevaluacion == true), "IdTipoSuplencia", "TipoSuplencia");
            ViewBag.IdEstructuraOrganica = new SelectList(db.Catalogos_ctEstructuraOrganica.Where(a => a.EsVigente == true && a.IdModalidadEstudio > 0), "IdEstructuraOrganica", "EstructuraOrganica");
            

            IEnumerable<SelectListItem> selectList = from s in Trabajadores
                                                     select new SelectListItem
                                                     {
                                                         Value = s.IdConvenioLaboralTrabajadorCategoria.ToString(),
                                                         Text = s.Nombre.ToString() + ' ' + s.ApellidoPaterno + ' ' + s.ApellidoMaterno
                                                     };
            ViewBag.IdConvenioLaboralTrabajadorCategoriaaCubrir = new SelectList(selectList, "Value", "Text");
            string queryrelacion;

            queryrelacion = @" select  IdRelacionLaboral, RelacionLaboral from  Catalogos_ctRelacionLaboral
                                 where IdRelacionLaboral in (1,2) 
                                order by IdRelacionLaboral asc ";

            var Trabajadoresrelacion = (List<Nova.Models.Catalogos_ctRelacionLaboral>)dpcg.connection.Query<Nova.Models.Catalogos_ctRelacionLaboral>(queryrelacion);
            
            IEnumerable<SelectListItem> selectListrelacion = from s in Trabajadoresrelacion
                                                     select new SelectListItem
                                                     {
                                                         Value = s.IdRelacionLaboral.ToString(),
                                                         Text = s.RelacionLaboral
                                                     };
            ViewBag.IdRelacionLaboral = new SelectList(selectListrelacion, "Value", "Text");

            ViewBag.IdAreaConocimiento = new SelectList(db.Kardex_ctAreaConocimiento.Where(a => a.EsVigente == true), "IdAreaConocimiento", "AreaConocimiento");
            ViewBag.CicloEscolar = Nova.Models.cicloescolarvigente.GetCiclosEscolares().FirstOrDefault().CicloEscolar;

            return PartialView();
        }


        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Evaluacion([Bind(Include = "IdKardexSolicitudEvaluacion,FechaSolicitud,IdConvenioLaboralTrabajadorCategoriaRegistro,IdEstructuraOrganicaLaboraFisicamente,IdTipoSuplencia,IdKardexCandidato,IdConvenioLaboralTrabajadorCategoriaaCubrir,FechaInicio,FechaTermino,NumeroOficio,Observaciones,IdEstatusContratacion,IdAreaConocimiento,IdRelacionLaboral,HorasSemanaMes,CicloEscolar")] Kardex_SolicitudEvaluaciones Kardex_solicitudevaluaciones)
        {
            int IdCLTCR = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            int IdKardexUsuario = Seguridad.Identidad.Usuario().Convenios_stConvenioLaboralTrabajador.Kardex_ctTrabajador.IdKardex;
            Kardex_SolicitudEvaluaciones solicitudeval = new Kardex_SolicitudEvaluaciones();
            Kardex_ResultadoEvaluacion evaluaciones = new Kardex_ResultadoEvaluacion();
            Kardex_stGradoAcademicoFotografia kardex_stGradoAcademicoFotografia = new Kardex_stGradoAcademicoFotografia();
            var vigencia = db.Nomina_ContratosConfiguracion.Where(a => a.EsVigente == true).FirstOrDefault();
            var idkardexexiste = db.Kardex_ResultadoEvaluacion.Where(z => z.IdKardex == Kardex_solicitudevaluaciones.IdKardexCandidato).FirstOrDefault();
                //DateTime.Now
            if (Kardex_solicitudevaluaciones.FechaInicio >= vigencia.FechaInicioProceso) 
            
            { 
                if (Kardex_solicitudevaluaciones.FechaInicio >= vigencia.FechaInicioContrato && Kardex_solicitudevaluaciones.FechaTermino <= vigencia.FechaTerminoContrato) 
                {
                    if (Kardex_solicitudevaluaciones.HorasSemanaMes <= 40)
                    { 
                        if (ModelState.IsValid)
                        {
                            try
                            {
                                using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                                {
                              
                                        solicitudeval.FechaSolicitud = DateTime.Now;
                                        solicitudeval.IdConvenioLaboralTrabajadorCategoriaRegistro = IdCLTCR;
                                        solicitudeval.IdEstructuraOrganicaLaboraFisicamente = Kardex_solicitudevaluaciones.IdEstructuraOrganicaLaboraFisicamente;
                                        solicitudeval.IdTipoSuplencia = Kardex_solicitudevaluaciones.IdTipoSuplencia;
                                        solicitudeval.IdKardexCandidato = Kardex_solicitudevaluaciones.IdKardexCandidato;
                                        if (Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir == 0)
                                        {
                                            solicitudeval.IdConvenioLaboralTrabajadorCategoriaaCubrir = null;
                                        }
                                        else { solicitudeval.IdConvenioLaboralTrabajadorCategoriaaCubrir = Kardex_solicitudevaluaciones.IdConvenioLaboralTrabajadorCategoriaaCubrir; }

                                        solicitudeval.FechaInicio = Kardex_solicitudevaluaciones.FechaInicio;
                                        solicitudeval.FechaTermino = Kardex_solicitudevaluaciones.FechaTermino;
                                        solicitudeval.NumeroOficio = Kardex_solicitudevaluaciones.NumeroOficio;
                                        solicitudeval.Observaciones = Kardex_solicitudevaluaciones.Observaciones;
                                           if (idkardexexiste == null)
                                            {
                                                solicitudeval.IdEstatusContratacion = 1;
                                            }
                                           else
                                            {
                                                if (idkardexexiste.IdAreaConocimiento == Kardex_solicitudevaluaciones.IdAreaConocimiento)
                                                    {
                                                        if (idkardexexiste.EsAceptable == true) { solicitudeval.IdEstatusContratacion = 2; }
                                                        else { solicitudeval.IdEstatusContratacion = 3; }
                                                    
                                                    }
                                                    else { solicitudeval.IdEstatusContratacion = 1; }

                                            }
                                    solicitudeval.IdAreaConocimiento = Kardex_solicitudevaluaciones.IdAreaConocimiento;
                                        solicitudeval.IdRelacionLaboral = Kardex_solicitudevaluaciones.IdRelacionLaboral;
                                    solicitudeval.HorasSemanaMes = Kardex_solicitudevaluaciones.HorasSemanaMes;
                                    solicitudeval.CicloEscolar = Kardex_solicitudevaluaciones.CicloEscolar;
                                        db.Kardex_SolicitudEvaluaciones.Add(solicitudeval);
                                        db.SaveChanges();


                                        //evaluaciones.IdKardex = Kardex_solicitudevaluaciones.IdKardexCandidato;
                                        //evaluaciones.EsAceptable = false;
                                        //evaluaciones.FechaEvaluacion = DateTime.Now;                                   
                                        //evaluaciones.IdAreaConocimiento = Kardex_solicitudevaluaciones.IdAreaConocimiento;
                                        //evaluaciones.IdKardexUsuario = IdKardexUsuario;
                                        //evaluaciones.FechaRegistro = DateTime.Now;
                                        //db.Kardex_ResultadoEvaluacion.Add(evaluaciones);
                                        //db.SaveChanges();






                               
                             


                                    trans.Complete();


                                }

                                return JsonView(true, "El archivo es agregado satisfactoriamente");


                            }
                            catch (Exception e)
                            {
                                string msj = ExceptionExtensions.GetOriginalException(e).Message;
                                if (msj.Contains("clave duplicada"))
                                {
                                    msj = "Ya existe un registro, revisar su información";

                                }
                                return JsonView(false, msj);


                            }


                            return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                            //}



                        }
                        else
                        {
                            string msj = "";
                            foreach (var item in ModelState.Select(q => new { ErrorTxt = q.Key }).ToList())
                            {
                                string Control = item.ErrorTxt;
                                if (item.ErrorTxt == "IdEstructuraOrganica")
                                {
                                    Control = "Centro Educátivo";
                                    msj = msj + "<p> " + Control + " es requerido </p>";
                                }
                                else if (item.ErrorTxt == "IdTipoSuplencia")
                                {
                                    Control = "Tipo de Movimiento";
                                    msj = msj + "<p> " + Control + " es requerido </p>";
                                }
                                else if (item.ErrorTxt == "IdConvenioLaboralTrabajadorCategoriaaCubrir")
                                {
                                    Control = "Personal BASE o Interino a Suplir";
                                    msj = msj + "<p> " + Control + " es requerido </p>";
                                }
                                else if (item.ErrorTxt == "IdKardexCandidato")
                                {
                                    Control = "";
                                }
                                else
                                {
                                    msj = msj + "<p> " + Control + " es requerido </p>";
                                }


                            }
                            return Json(new { Valid = false, Message = msj });

                        }
                    }
                    else 
                    {
                        string msj = $"Las horas/semana/mes no pueden ser mayor a 40";
                        return JsonView(false, msj);
                    }
                }
                else {
                    

                    string msj = $"Las fechas no estan dentro del rango aceptado Fecha de Inicio{vigencia.FechaInicioContrato}  Fecha Termino {vigencia.FechaTerminoContrato} ";                    
                    return JsonView(false, msj);
                }
            
            }
              else {
               
                string msj = $"La fecha de inicio del proceso inicia { vigencia.FechaInicioProceso } ";
                return JsonView(false, msj);
            }
            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }


      





        public ActionResult VerDetails(int id)
        {

            Nova.Libraries.DapperQuery dp = new Nova.Libraries.DapperQuery("bdNovaEntities");
            var kardex_DocumentosExpediente = (List<KardexDocumentosExpedienteTrabajador>)dp.connection.Query<KardexDocumentosExpedienteTrabajador>(queryexpediente);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z => z.IdKardex == id).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k => k.Kardex_stGradoAcademicoFotografia);
            //var kardex_GradoAcademico = db.Kardex_GradoAcademico.Where(z=>z.IdKardex== IdKardex).Include(k => k.Kardex_ctDatosPersonales).Include(k => k.Kardex_NivelEstudio).Include(k=> k.Kardex_stGradoAcademicoFotografia);
            ViewBag.Controlador = "KardexGradoAcademico";
            ViewBag.TituloModal = "CREAR GRADO ACADEMICO";
            ViewBag.TituloSwal = "ELIMINAR GRADO ACADEMICO";
            ViewBag.PreguntaSwal = "¿ESTA SEGURO DE ELIMINAR EL GRADO ACADEMICO?";
            //ViewBag.IdKardex = id;
            ViewBag.IdKardex = id;
            dp.Close();
            var Expediente = kardex_DocumentosExpediente.Where(z => z.IdKardex == id);

            ViewBag.NombreTrabajador = Expediente.FirstOrDefault().Nombre + " " + Expediente.FirstOrDefault().ApellidoPaterno + " " + Expediente.FirstOrDefault().ApellidoMaterno;
                
            return View(Expediente);
            //return View(kardex_DocumentosExpediente.Where(z => z.IdKardex == IdKardex));
        }


      
        // GET: KardexGradoAcademico/Create
        public ActionResult Create()
        {
           
                    
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
           
            return PartialView();
        }

        // POST: KardexGradoAcademico/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdKardex, Nombre, ApellidoPaterno, ApellidoMaterno,CURP,Telefono, CorreoElectronico, IdKardexNivelEstudio,NivelEstudioDescripcion,AbreviaturaProfesion")] Nova.Models.Kardex_ctDatosPersonalesCandidato kardex_ctdatospersonalescandidato)
        {
            //IdKardex, IdeEmpleadoAnt, CURP, Nombre, ApellidoPaterno, ApellidoMaterno, FechaNacimiento, Sexo, RFC, Calle, NumeroInterior, Letra, NumeroExterior, Colonia, CodigoPostal, IdLocalidadVive, IdMunicipioVive, IdEstadoVive, Telefono, TelefonoCelular, CorreoElectronico, IdLocalidadNacimiento, IdMunicipioNacimiento, IdEstadoNacimiento, IdPais, LaboraFisicamente, Id, ProcesoCompletado, SinNumero, NSS, IdTipoSangre, FechaUltimaActualizacion, EsDocente, Padecimientos, Alergias, IdEstadoCivil, CorreoElectronicoGmail, AceptaAviso, FechaDatosContacto, IdDiscapacidad, IdLenguasIndigenas, IdPueblosIndigenas, EsAltaSindicato,IdKardexNivelEstudio
            Kardex_GradoAcademico kardex_GradoAcademico = new Kardex_GradoAcademico();
            
            Nova.Models.Kardex_ctDatosPersonales kardex_ctDatosPersonales = new Nova.Models.Kardex_ctDatosPersonales();
            int IdConveniolaboraltrabajadorcategoria = Seguridad.Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria;
            ViewBag.CicloEscolar = Nova.Models.cicloescolarvigente.GetCiclosEscolares().FirstOrDefault().CicloEscolar;
                        //oficialia_stAnexoDocumentoEntradaTemporal.UsuarioFechaAnexo = usuarioactual;

            if (ModelState.IsValid)
            {

                //var RegistrosRepetidos = db.Kardex_DocumentosExpediente.Where(g => g.IdKardexDocumentosExpediente == kardex_DocumentosExpediente.IdKardexDocumentosExpediente).ToArray();
                //int valor = RegistrosRepetidos.Count();
                //if (valor > 0)
                //{


                //    return Json(new { Valid = false, Message = "Ya existe un  archivo igual " });
                //}



                //else
                //{

                    try
                {
                    using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                    {

                       
                        kardex_ctDatosPersonales.IdeEmpleadoAnt = 0;
                        kardex_ctDatosPersonales.CURP = kardex_ctdatospersonalescandidato.CURP;
                        kardex_ctDatosPersonales.Nombre = kardex_ctdatospersonalescandidato.Nombre;
                        kardex_ctDatosPersonales.ApellidoPaterno = kardex_ctdatospersonalescandidato.ApellidoPaterno;
                        kardex_ctDatosPersonales.ApellidoMaterno = kardex_ctdatospersonalescandidato.ApellidoMaterno;
                        kardex_ctDatosPersonales.FechaNacimiento = DateTime.Now; 
                        kardex_ctDatosPersonales.Sexo = "x";
                        kardex_ctDatosPersonales.RFC = "MAEJ860512123";
                        kardex_ctDatosPersonales.Calle = "X";
                        kardex_ctDatosPersonales.NumeroInterior = 0;
                        kardex_ctDatosPersonales.Letra = "";
                        kardex_ctDatosPersonales.NumeroExterior = 0;
                        kardex_ctDatosPersonales.Colonia = "X";
                        kardex_ctDatosPersonales.CodigoPostal = 0;
                        kardex_ctDatosPersonales.IdLocalidadVive = 0;
                        kardex_ctDatosPersonales.IdMunicipioVive = 0;
                        kardex_ctDatosPersonales.IdEstadoVive = 0;
                        kardex_ctDatosPersonales.Telefono = "";
                        kardex_ctDatosPersonales.TelefonoCelular = kardex_ctdatospersonalescandidato.Telefono;
                        kardex_ctDatosPersonales.CorreoElectronico = kardex_ctdatospersonalescandidato.CorreoElectronico;
                        kardex_ctDatosPersonales.IdLocalidadNacimiento = 0;
                        kardex_ctDatosPersonales.IdMunicipioNacimiento = 0;
                        kardex_ctDatosPersonales.IdEstadoNacimiento = 0;
                        kardex_ctDatosPersonales.IdPais = 154;
                        kardex_ctDatosPersonales.LaboraFisicamente = "";
                        kardex_ctDatosPersonales.Id = 0;
                        kardex_ctDatosPersonales.ProcesoCompletado = false;
                        kardex_ctDatosPersonales.SinNumero = false;
                        kardex_ctDatosPersonales.NSS = "";
                        kardex_ctDatosPersonales.IdTipoSangre = 0;
                        kardex_ctDatosPersonales.FechaUltimaActualizacion = DateTime.Now; 
                        kardex_ctDatosPersonales.EsDocente = false;
                        kardex_ctDatosPersonales.Padecimientos = "";
                        kardex_ctDatosPersonales.Alergias = "";
                        kardex_ctDatosPersonales.IdEstadoCivil = 1;
                        kardex_ctDatosPersonales.CorreoElectronicoGmail = "";
                        kardex_ctDatosPersonales.AceptaAviso = false;
                        kardex_ctDatosPersonales.FechaDatosContacto = DateTime.Now; 
                        kardex_ctDatosPersonales.IdDiscapacidad =13;
                        kardex_ctDatosPersonales.IdLenguasIndigenas = 12;
                        kardex_ctDatosPersonales.IdPueblosIndigenas = 14;
                        kardex_ctDatosPersonales.EsAltaSindicato = true;                     
                        db.Kardex_ctDatosPersonales.Add(kardex_ctDatosPersonales);
                        db.SaveChanges();

                        kardex_GradoAcademico.IdKardex = kardex_ctDatosPersonales.IdKardex;
                        kardex_GradoAcademico.IdKardexNivelEstudio = Convert.ToInt16( kardex_ctdatospersonalescandidato.IdKardexNivelEstudio);
                        kardex_GradoAcademico.NivelEstudioDescripcion = kardex_ctdatospersonalescandidato.NivelEstudioDescripcion; ;
                        kardex_GradoAcademico.NumeroCedulaProfesional = 0;
                        kardex_GradoAcademico.AbreviaturaProfesion = kardex_ctdatospersonalescandidato.AbreviaturaProfesion; ;
                        kardex_GradoAcademico.NombreInstiitucionEscolar = "";
                        kardex_GradoAcademico.AñoTermino = 0;
                        db.Kardex_GradoAcademico.Add(kardex_GradoAcademico);
                        db.SaveChanges();

                        trans.Complete();
                                return Json(new { Valid = true, Message = "El archivo fue agregado satisfactoriamente" });


                            }

                     
                       
                        
                    }

                    
                    catch (Exception e)
                    {

                        return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                    }


                    return JsonView(ModelState.IsValid, "El archivo no fue agregado satisfactoriamente");
                //}



            }

            //ViewBag.IdTipoAnexoDocumento = new SelectList(db.Oficialia_ctTipoAnexoDocumento, "IdTipoAnexoDocumento", "TipoAnexoDocumento", oficialia_stAnexoDocumentoSalida.IdTipoAnexoDocumento);
            return JsonView(ModelState.IsValid, "El archivo se agregado satisfactoriamente");


        }




        public ActionResult Edit(int IdKardex)
        {

            if(IdKardex == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Kardex_ctDatosPersonalesCandidato kardexcandidato = new Kardex_ctDatosPersonalesCandidato();
            Nova.Models.Kardex_ctDatosPersonales kardextrabajador = db.Kardex_ctDatosPersonales.Find(IdKardex);
            Kardex_GradoAcademico kardexgrado = db.Kardex_GradoAcademico.Where(a => a.IdKardex == IdKardex).OrderByDescending(z=> z.IdKardexNivelEstudio).FirstOrDefault();
            ViewBag.IdKardex = IdKardex;
            kardexcandidato.Nombre = kardextrabajador.Nombre;
            kardexcandidato.ApellidoPaterno = kardextrabajador.ApellidoPaterno;
            kardexcandidato.ApellidoMaterno = kardextrabajador.ApellidoMaterno;
            kardexcandidato.CURP = kardextrabajador.CURP;
            kardexcandidato.Telefono = kardextrabajador.TelefonoCelular;
            kardexcandidato.CorreoElectronico = kardextrabajador.CorreoElectronico;
            if (kardexgrado != null)
            {
                kardexcandidato.IdKardexNivelEstudio = kardexgrado.IdKardexNivelEstudio;
                kardexcandidato.NivelEstudioDescripcion = kardexgrado.NivelEstudioDescripcion;
                kardexcandidato.AbreviaturaProfesion = kardexgrado.AbreviaturaProfesion;
                ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio", kardexgrado.IdKardexNivelEstudio);

            }
            else { 
            
            kardexcandidato.NivelEstudioDescripcion = "";
            kardexcandidato.AbreviaturaProfesion = "";
           
            ViewBag.IdKardexNivelEstudio = new SelectList(db.Kardex_NivelEstudio, "IdKardexNivelEstudio", "KardexNivelEstudio");
            }
            return PartialView(kardexcandidato);

            //return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea https://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        //[ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdKardex, Nombre, ApellidoPaterno, ApellidoMaterno,CURP,Telefono, CorreoElectronico, IdKardexNivelEstudio,NivelEstudioDescripcion,AbreviaturaProfesion")] Nova.Models.Kardex_ctDatosPersonalesCandidato kardex_ctdatospersonalescandidato)
        {
            string msj = "El Grado académico ha sido editado existosamente!";

            Nova.Models.Kardex_ctDatosPersonales kardexdatosPersonales = new Models.Kardex_ctDatosPersonales();
            Kardex_GradoAcademico kardexgrado = new Kardex_GradoAcademico();


            if (ModelState.IsValid)
            {

                try
                {

                   using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                        {
                        kardexdatosPersonales = db.Kardex_ctDatosPersonales.Find(kardex_ctdatospersonalescandidato.IdKardex);
                        kardexdatosPersonales.TelefonoCelular = kardex_ctdatospersonalescandidato.Telefono;
                        kardexdatosPersonales.CorreoElectronico = kardex_ctdatospersonalescandidato. CorreoElectronico;                        
                        db.Entry(kardexdatosPersonales).State = EntityState.Modified;
                        db.SaveChanges();

                        kardexgrado = db.Kardex_GradoAcademico.Where(a => a.IdKardex == kardex_ctdatospersonalescandidato.IdKardex).OrderByDescending(z => z.IdKardexNivelEstudio).FirstOrDefault();
                        kardexgrado.IdKardexNivelEstudio = Convert.ToInt16(kardex_ctdatospersonalescandidato.IdKardexNivelEstudio);
                        kardexgrado.NivelEstudioDescripcion = kardex_ctdatospersonalescandidato.NivelEstudioDescripcion;
                        kardexgrado.AbreviaturaProfesion = kardex_ctdatospersonalescandidato.AbreviaturaProfesion;
                       
                        db.Entry(kardexgrado).State = EntityState.Modified;
                        db.SaveChanges();


                        trans.Complete();


                        }
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });
            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        // GET: KardexGradoAcademico/Delete/5
        public ActionResult Delete(int? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            if (kardex_GradoAcademico == null)
            {
                return HttpNotFound();
            }
            return View(kardex_GradoAcademico);
        }

        // POST: KardexGradoAcademico/Delete/5
        [HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public ActionResult DeleteConfirmed(int id)
        {
            //Kardex_GradoAcademico kardex_GradoAcademico = db.Kardex_GradoAcademico.Find(id);
            //db.Kardex_GradoAcademico.Remove(kardex_GradoAcademico);
            string msj = "El registro ha sido eliminado existosamente!";
            if (ModelState.IsValid)
            {

                try
                {

                    Nova.Models.Kardex_ctDatosPersonales kardex_ctDatosPersonales = db.Kardex_ctDatosPersonales.Find(id);
                    db.Kardex_ctDatosPersonales.Remove(kardex_ctDatosPersonales);
                    db.SaveChanges();
                }
                catch (Exception e)
                {


                    return Json(new { Valid = false, Message = ExceptionExtensions.GetOriginalException(e).Message });
                }
                return Json(new { Valid = true, Message = msj });


              

            }
            string messages = string.Join("; ", ModelState.Values
                       .SelectMany(x => x.Errors)
                       .Select(x => x.ErrorMessage));

            return JsonView(ModelState.IsValid, messages, null, null);
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
