﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace Nova.Controllers
{
    public class SieCategoriaEventosController : Controller
    {
        //
        // GET: /SieCategoriaEventos/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvSieCategoriaEventos()
        {
            var model = db.SieCategoriaEventos;
            return PartialView("_pvSieCategoriaEventos", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvSieCategoriaEventosAddNew(Nova.Models.SieCategoriaEventos item)
        {
            var model = db.SieCategoriaEventos;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvSieCategoriaEventos", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSieSubcategoriaEventosUpdate(Nova.Models.SieCategoriaEventos item)
        {
            var model = db.SieCategoriaEventos;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdCategoriaEvento == item.IdCategoriaEvento);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Por favor, corriga los errores.";
            return PartialView("_pvSieCategoriaEventos", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvSieCategoriaEventosDelete(System.Int16 IdCategoriaEvento)
        {
            var model = db.SieCategoriaEventos;
            if (IdCategoriaEvento != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdCategoriaEvento == IdCategoriaEvento);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                                       
                    
                }
            }


            return PartialView("_pvSieCategoriaEventos", model.ToList());
        }
    }
}
