﻿using Nova.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Dapper;
using Seguridad;

namespace Nova.Controllers.ServicioSocial
{
    public class MiServicioSocialController : Controller
    {
        // GET: MiServicioSocial
        [AllowAnonymous]
        [HttpGet]
        [Route("MiServicioSocial/{folio}")]
        public ActionResult MiServicioSocial(string folio)
        {
            bdAriesEntities bd = new bdAriesEntities();
            DapperQuery dp = new DapperQuery("bdAriesEntities");

            string query = @"
                select  
                    TipoPlantel
                    ,CCT
                    ,NombreNumeroPlantel
                    ,c.ApPaterno
                    ,c.ApMaterno
                    ,c.Nombre
                    ,Empresa=d.Nombre
                    ,FechaInicio
                    ,FechaLiberacion
                    ,Folio=b.AnioMatricula+REPLICATE('0', 5-len(rtrim(cast( b.Folio as nvarchar(5)))))+ rtrim(cast(b.Folio as nvarchar(5)))
                    from stServicioSocialSolicitud a
                    inner join stServicioSocialFolios b on a.Curp=b.Curp
                    inner join ctAlumnos c on c.Curp=b.Curp
                    inner join ctServicioSocialEmpresa d on a.IdServicioSocialEmpresa=d.IdServicioSocialEmpresa
                  
                    where b.AnioMatricula+REPLICATE('0', 5-len(rtrim(cast( b.Folio as nvarchar(5)))))+ rtrim(cast(b.Folio as nvarchar(5)))=@folio";

            var model = (ServicioSocial_stServicioSocialFolios)dp.connection.QuerySingleOrDefault<ServicioSocial_stServicioSocialFolios>(query, new { folio });

            return View(model);
        }
    }

    public partial class ServicioSocial_stServicioSocialFolios
    {
        public string TipoPlantel { get; set; }
        public string CCT { get; set; }
        public string NombreNumeroPlantel { get; set; }
        public string ApPaterno { get; set; }
        public string ApMaterno { get; set; }
        public string Nombre { get; set; }
        public string Empresa { get; set; }
        public DateTime FechaInicio { get; set; }
        public DateTime FechaLiberacion { get; set; }
        public string Folio { get; set; }
    }
}