﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
namespace Nova.Controllers.Roles
{
    public class ControladorAccion
    {
         

    
        public int IdControlador { get; set; }

        public string Controlador { get; set; }
      
    }

    public class GrupoAplicacion
    {



        public int IdGrupoRolAplicacion { get; set; }
        public int IdGrupo { get; set; }

        public string Grupo { get; set; }

    }

    public class Aplicaciones
    {



        public int IdAplicacion { get; set; }

        public string Aplicacion { get; set; }
        public string CssAplicacion  { get; set; }
        

    }
    public class RolAplicacionController : Controller
    {
        bdNovaEntities bd = new bdNovaEntities();
        // GET: RolAplicacion
        public ActionResult Index()
        {
            string nombre = "xxxxxxxxxxxxxxxxxxxxxxx";
            if (Request["hfusersearch"] != null && Request["hfusersearch"] != "")
            {
                nombre = Request["hfusersearch"];
                ViewBag.buscarusuario = nombre;
            }
            else
            {
                ViewBag.buscarusuario = "";
            }

            ViewData["Usuario"] = bd.Kardex_ctDatosPersonales.Where(r => r.Nombre.Contains(nombre) || r.ApellidoPaterno.Contains(nombre) || r.ApellidoMaterno.Contains(nombre)).ToList();

            ViewData["Roles"] = bd.RolAplicacion.OrderBy(item => new { item.Aplicacion.Aplicacion1, item.Rol.Rol1 }).ToList();
            ViewData["Accesos"] = bd.AccesoRolAplicacion.OrderBy(item => new { item.RolAplicacion.Aplicacion.Aplicacion1, item.RolAplicacion.Rol.Rol1 }).ToList();
            
            return View();
        }

           [HttpPost]
        public ActionResult AsignarCategoria(FormCollection form)
        {
            Nova.Models.GrupoRolAplicacionCategoria categoria = new Nova.Models.GrupoRolAplicacionCategoria();
            categoria.IdGrupo = System.Convert.ToInt16(Request["hffrmcategoriaidgrupo"]);
            categoria.IdCategoria = System.Convert.ToInt16(Request["hffrmcategoriaidcategoria"]);

            bd.GrupoRolAplicacionCategoria.Add(categoria);

          
            try
            {  bd.SaveChanges();
            Seguridad.Identidad.ResetSingleton();
 
            }
            catch (Exception e)
            {
               throw new ApplicationException (ExceptionExtensions.GetOriginalException(e).Message);
            }


            return RedirectToAction("Index");
        }
    

    
    
           [HttpPost]
        public ActionResult EliminarCategoria(FormCollection form)
        {
               
               Int16 igr=System.Convert.ToInt16(Request["hfdelidgruporolaplicacion"]);
               Int16 icategoria=System.Convert.ToInt16(Request["hfdelcategoriaidcategoria"]);

            GrupoRolAplicacionCategoria categoria = bd.GrupoRolAplicacionCategoria.Where(f=> f.IdGrupo ==igr && f.IdCategoria==icategoria).FirstOrDefault();
            

            bd.GrupoRolAplicacionCategoria.Remove(categoria);

          
            try
            {  bd.SaveChanges();
            Seguridad.Identidad.ResetSingleton();
 
            }
            catch (Exception e)
            {
               throw new ApplicationException (ExceptionExtensions.GetOriginalException(e).Message);
            }


            return RedirectToAction("Index");
        }

           [HttpPost]
           public ActionResult AsignarConvenio(FormCollection form)
           {
               GrupoRolAplicacionConvenioLaboral categoria = new GrupoRolAplicacionConvenioLaboral();
               categoria.IdGrupo = System.Convert.ToInt16(Request["hfconvidgruporolaplicacion"]);
               categoria.IdConvenioLaboral = System.Convert.ToInt16(Request["hfconvidconvenio"]);

               bd.GrupoRolAplicacionConvenioLaboral.Add(categoria);


               try
               {
                   bd.SaveChanges();
                   Seguridad.Identidad.ResetSingleton();

               }
               catch (Exception e)
               {
                   throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
               }


               return RedirectToAction("Index");
           }

           [HttpPost]
           public ActionResult EliminarConvenio(FormCollection form)
           {

               Int16 igr = System.Convert.ToInt16(Request["hfdelconvidgruporolaplicacion"]);
               Int16 idconvenio = System.Convert.ToInt16(Request["hfdelconvidconvenio"]);

               GrupoRolAplicacionConvenioLaboral convenio = bd.GrupoRolAplicacionConvenioLaboral.Where(f => f.IdGrupo == igr && f.IdConvenioLaboral == idconvenio).FirstOrDefault();


               bd.GrupoRolAplicacionConvenioLaboral.Remove(convenio);


               try
               {
                   bd.SaveChanges();
                   Seguridad.Identidad.ResetSingleton();

               }
               catch (Exception e)
               {
                   throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
               }


               return RedirectToAction("Index");
           }


           [HttpPost]
           public ActionResult AsignarRelacion(FormCollection form)
           {
               GrupoRolAplicacionRelacionLaboral relacion = new GrupoRolAplicacionRelacionLaboral();
               relacion.IdGrupo = System.Convert.ToInt16(Request["hfrelidgruporolaplicacion"]);
               relacion.IdRelacionLaboral = System.Convert.ToInt16(Request["hfrelidrelacion"]);

               bd.GrupoRolAplicacionRelacionLaboral.Add(relacion);


               try
               {
                   bd.SaveChanges();
                   Seguridad.Identidad.ResetSingleton();

               }
               catch (Exception e)
               {
                   throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
               }


               return RedirectToAction("Index");
           }

           [HttpPost]
           public ActionResult EliminarRelacion(FormCollection form)
           {

               Int16 igr = System.Convert.ToInt16(Request["hfdelrelidgruporolaplicacion"]);
               Int16 idconvenio = System.Convert.ToInt16(Request["hfdelrelidrelacion"]);

               GrupoRolAplicacionRelacionLaboral convenio = bd.GrupoRolAplicacionRelacionLaboral.Where(f => f.IdGrupo == igr && f.IdRelacionLaboral == idconvenio).FirstOrDefault();


               bd.GrupoRolAplicacionRelacionLaboral.Remove(convenio);


               try
               {
                   bd.SaveChanges();
                   Seguridad.Identidad.ResetSingleton();

               }
               catch (Exception e)
               {
                   throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
               }


               return RedirectToAction("Index");
           }

           [HttpPost]
           public ActionResult AsignarClasificacion(FormCollection form)
           {
               GrupoRolAplicacionClasificacionLaboral relacion = new GrupoRolAplicacionClasificacionLaboral();
               relacion.IdGrupo = System.Convert.ToInt16(Request["hfclaidgruporolaplicacion"]);
               relacion.IdClasificacionLaboral = System.Convert.ToInt16(Request["hfclaidclasificacion"]);

               bd.GrupoRolAplicacionClasificacionLaboral.Add(relacion);


               try
               {
                   bd.SaveChanges();
                   Seguridad.Identidad.ResetSingleton();

               }
               catch (Exception e)
               {
                   throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
               }


               return RedirectToAction("Index");
           }

           [HttpPost]
           public ActionResult EliminarClasificacion(FormCollection form)
           {

               Int16 igr = System.Convert.ToInt16(Request["hfdelclaidgruporolaplicacion"]);
               Int16 idconvenio = System.Convert.ToInt16(Request["hfdelclaidclasificacion"]);

               GrupoRolAplicacionClasificacionLaboral convenio = bd.GrupoRolAplicacionClasificacionLaboral.Where(f => f.IdGrupo== igr && f.IdClasificacionLaboral== idconvenio).FirstOrDefault();


               bd.GrupoRolAplicacionClasificacionLaboral.Remove(convenio);


               try
               {
                   bd.SaveChanges();
                   Seguridad.Identidad.ResetSingleton();

               }
               catch (Exception e)
               {
                   throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
               }


               return RedirectToAction("Index");
           }

           [HttpPost]
           public ActionResult AsignarUsuario(FormCollection form)
           {
               if (Request["hfusersearch"] != null && Request["hfusersearch"] != "")
               {

                   ViewBag.buscarusuario = Request["hfusersearch"];
               }
               else
               {
                   ViewBag.buscarusuario = "";
               }

               GrupoRolAplicacionUsuarioKardex categoria = new GrupoRolAplicacionUsuarioKardex();
               categoria.IdGrupo = System.Convert.ToInt16(Request["hffrmusuarioidgrupo"]);
               categoria.IdUsuarioKardex = System.Convert.ToInt16(Request["hffrmusuarioidkardex"]);

               bd.GrupoRolAplicacionUsuarioKardex.Add(categoria);


               try
               {
                   bd.SaveChanges();
                   Seguridad.Identidad.ResetSingleton();

               }
               catch (Exception e)
               {
                   throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
               }


               return RedirectToAction("Index");
           }

           [HttpPost]
           public ActionResult EliminarUsuario(FormCollection form)
           {
               if (Request["hfusersearch"] != null && Request["hfusersearch"] != "")
               {

                   ViewBag.buscarusuario = Request["hfusersearch"];
               }
               else
               {
                   ViewBag.buscarusuario = "";
               }

               Int16 igr = System.Convert.ToInt16(Request["hfdelidgruporolaplicacion"]);

               if (Request["hfdelusuarioidkardex"]=="")
                   throw  new ApplicationException("No se puede eliminar un grupo heredado");
               

               Int16 idconvenio = System.Convert.ToInt16(Request["hfdelusuarioidkardex"]);

             


               GrupoRolAplicacionUsuarioKardex convenio = bd.GrupoRolAplicacionUsuarioKardex.Where(f => f.IdGrupo == igr && f.IdUsuarioKardex == idconvenio).FirstOrDefault();


               bd.GrupoRolAplicacionUsuarioKardex.Remove(convenio);


               try
               {
                   bd.SaveChanges();
                   Seguridad.Identidad.ResetSingleton();

               }
               catch (Exception e)
               {
                   throw new ApplicationException(ExceptionExtensions.GetOriginalException(e).Message);
               }


               return RedirectToAction("Index");
           }
    
    }
}