﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Nova.Models;
using Nova.Models.Designpattern;
using System.Transactions;
namespace Nova.Controllers.Renuncias
{
    public class RenunciasController : BaseController
    {
        //
        // GET: /Renuncias/
        private Kardex_stEstatusTrabajador kardex = new Kardex_stEstatusTrabajador();
        bdNovaEntities db = new bdNovaEntities();
        public ActionResult Index(int IdConvenioLaboralTrabajadorCategoria)
        {

            //var model = Nova.Models.Permuta.PermutasTrabajador.GetPermutas2(db.vwIdConvenioLaboralTrabajadorCategoria, IdTrabajador);
            var model = db.vwDatosAspirantesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).ToList();

            if (model.Count == 0)
            { throw new ApplicationException("No existen convenios laborales para este trabajador, primero debe de asignar una plaza"); }
            else
            {
                Session["IdConvenioLaboralTrabajadorCategoria"] = IdConvenioLaboralTrabajadorCategoria;

                Session["Idconveniolaboraltrabajador"] = model.First().IdConvenioLaboralTrabajador;
                Session["Idtrabajador"] = model.First().IdTrabajador;
                Session["Iddistribucionplazacategoria"] = db.Convenios_stConvenioLaboralTrabajadorCategoria.Where(b => b.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria).First().IdDistribucionPlazaCategoria;
                //ViewBag.IdEstatusTrabajador = new SelectList(db.Catalogos_ctEstatusTrabajador.Where(s => s.IdGrupoEstatusTrabajador == 3), "IdEstatusTrabajador", "EstatusTrabajador");
                ViewBag.IdEstatusTrabajador = new SelectList(from p in db.Catalogos_ctEstatusTrabajador
                                                             join w in db.Catalogos_ctGrupoEstatusTrabajador
                                                             on p.IdGrupoEstatusTrabajador
                                                             equals w.IdGrupoEstatusTrabajador
                                                             where w.GrupoEstatusTrabajador == "BAJA"
                                                             select p, "IdEstatusTrabajador", "EstatusTrabajador");

                var model2 = from p in db.Catalogos_ctEstatusTrabajador
                             join w in db.Catalogos_ctGrupoEstatusTrabajador
                             on p.IdGrupoEstatusTrabajador
                             equals w.IdGrupoEstatusTrabajador
                             where w.GrupoEstatusTrabajador == "BAJA"
                             select new
                             {
                                 IdEstatusTrabajador = p.IdEstatusTrabajador,
                                 EstatusTrabajador = p.EstatusTrabajador,
                             };

                String Estatus = kardex.ObtenEstatusTrabajador(IdConvenioLaboralTrabajadorCategoria);
                if (Estatus == "BAJA")
                    throw new System.InvalidOperationException("El trabajador terminó su relación de trabajo");

                if (model.Count() == 0)
                {

                    ModelState.AddModelError("", "Verifique el trabajador");
                    ViewData["EditError"] = "Verifique el trabajador";
                    //MessageBox.Show(ViewData, TipoMensaje.Error, "El trabajador ya tiene asignada una plaza, Verifique el Ide");
                    throw new System.ArgumentException("El trabajador terminó su relación de trabajo");

                }
                if (!model2.Any())
                {

                    ModelState.AddModelError("", "Verifique el trabajador");
                    ViewData["EditError"] = "Verifique el trabajador";
                    //MessageBox.Show(ViewData, TipoMensaje.Error, "El trabajador ya tiene asignada una plaza, Verifique el Ide");
                    throw new System.ArgumentException("Revisar sus catalogos de estatus de trabajador");

                }
            }
            return View(model);
            //return View();
        }

        public ActionResult Asignada()
        {

            return PartialView("Renuncia");
        }




        [ValidateInput(false)]
        public ActionResult pvRenuncias()
        {
            int id = (int)Session["IdTrabajador"];
            int Idconvenioabaroraltrabajadorcategoria = (int)Session["IdConvenioLaboralTrabajadorCategoria"];

            //var model = Nova.Models.Permuta.PermutasTrabajador.GetPermutas2(db.vwIdConvenioLaboralTrabajadorCategoria, id);
            //var model = db.vwIdConvenioLaboralTrabajadorCategoria;
            var model = db.vwDatosAspirantesTrabajadores.Where(a => a.IdConvenioLaboralTrabajadorCategoria == Idconvenioabaroraltrabajadorcategoria).ToList();

            return PartialView("_pvRenuncias", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvRenunciasAddNew(Nova.Models.vwIdConvenioLaboralTrabajadorCategoria item)
        {
            var model = db.vwIdConvenioLaboralTrabajadorCategoria;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvRenuncias", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvRenunciasUpdate(Nova.Models.vwIdConvenioLaboralTrabajadorCategoria item)
        {
            var model = db.vwIdConvenioLaboralTrabajadorCategoria;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdConvenioLaboralTrabajadorCategoria == item.IdConvenioLaboralTrabajadorCategoria);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvRenuncias", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvRenunciasDelete(System.Int32 IdConvenioLaboralTrabajadorCategoria)
        {
            var model = db.vwIdConvenioLaboralTrabajadorCategoria;
            if (IdConvenioLaboralTrabajadorCategoria != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdConvenioLaboralTrabajadorCategoria == IdConvenioLaboralTrabajadorCategoria);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            return PartialView("_pvRenuncias", model.ToList());
        }

        [HttpPost]
        public ActionResult ActualizarRenuncias( string FechaTermino, short IdEstatusTrabajador)
        {
           
            int id = (int)Session["Idtrabajador"];
            int idpc = (int)Session["Iddistribucionplazacategoria"];
            int idcltc = (int)Session["IdConvenioLaboralTrabajadorCategoria"];
            short idclt = (short)Session["Idconveniolaboraltrabajador"];
            DateTime FT = Convert.ToDateTime(FechaTermino);

            String Estatus = kardex.ObtenEstatusTrabajador(idcltc);
            if (Estatus == "BAJA")
                throw new System.InvalidOperationException("El trabajador terminó su relación de trabajo");


            //var FechaTermino = form["FechaTermino"];
            ViewBag.IdEstatusTrabajador = IdEstatusTrabajador;

            //var FechaRenuncia2 = FechaTermino;
            //ViewBag.FechaTermino = FechaTermino;
            //var model = Nova.Models.Permuta.PermutasTrabajador.GetPermutas(db.vwIdConvenioLaboralTrabajadorCategoria, id);
            //var model = db.Convenios_stConvenioLaboralTrabajador;


            //////var model = Nova.Models.Permuta.PermutasTrabajador.GetRenuncia(db.Convenios_stConvenioLaboralTrabajador, id);
            //////var IdConvenio= model.First(a=> a.IdTrabajador==id);

            ////// var model2 = Nova.Models.Permuta.PermutasTrabajador.GetRenuncia2(db.Convenios_stConvenioLaboralTrabajadorCategoria, IdConvenio.IdConvenioLaboralTrabajador);
            ////// var IdPlaza = model2.First(b=> b.IdConvenioLaboralTrabajador == IdConvenio.IdConvenioLaboralTrabajador);

            ////// var model3 = Nova.Models.Permuta.PermutasTrabajador.GetRenuncia3(db.Plazas_stDistribucionPlazaCategoria, IdPlaza.IdDistribucionPlazaCategoria);

            ////// var model4 = db.Kardex_stEstatusTrabajador;
            //var model4 = Nova.Models.Permuta.PermutasTrabajador.GetRenuncia4(db.Kardex_stEstatusTrabajador,IdPlaza.IdConvenioLaboralTrabajadorCategoria);

            var model = db.Convenios_stConvenioLaboralTrabajador.ToList();

            var model2 = db.Convenios_stConvenioLaboralTrabajadorCategoria.ToList();


            var model3 = db.Plazas_stDistribucionPlazaCategoria.ToList();
            var model4 = db.Kardex_stEstatusTrabajador.ToList();

            //DateTime dt = DateTime.ParseExact(FechaTermino.ToString(), "MM/dd/yyyy hh:mm:ss tt", System.Globalization.CultureInfo.InvariantCulture);

            //string s = dt.ToString("dd/M/yyyy");
            //FechaTermino = s; 

            if (FT == null)
            {
                ModelState.AddModelError("", "Los Datos son requeridos");
            }



           
            
            //if (Convert.ToDateTime(FechaTermino) > DateTime.Now)
            //{

            //    ModelState.AddModelError("", "Verifique el trabajador");
            //    ViewData["EditError"] = "Verifique el trabajador";
            //    //MessageBox.Show(ViewData, TipoMensaje.Error, "El trabajador ya tiene asignada una plaza, Verifique el Ide");
            //    throw new System.ArgumentException("La fecha termino debe ser mayor a la fecha actual");

            //}


            //if (ModelState.IsValid)
            //{

                
                using (TransactionScope trans = new TransactionScope(TransactionScopeOption.Required))
                {
                    
                     TransactionOptions GrabarPlaza = new TransactionOptions();
                GrabarPlaza.IsolationLevel = System.Transactions.IsolationLevel.ReadUncommitted;
                using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, GrabarPlaza))
                {

                try
                {
                    //using (TransactionScope scope = new TransactionScope(TransactionScopeOption.RequiresNew, GrabarRenuncia))
                    //{

                  
                        var modelItem = model.Find(it => it.IdConvenioLaboralTrabajador == idclt);
                        if (Convert.ToDateTime(FT) < modelItem.FechaInicio)
                        {

                            return Json(new { Valid = true, Message = "Los fecha de férmino es menor a la fecha de inicio " });
                            //throw new System.InvalidOperationException("Los fecha de férmino es menor a la fecha de inicio ");
                            //ModelState.AddModelError("", "Los fecha de férmino es menor a la fecha de inicio ");
                        }
                        else
                        { 
                            if (modelItem != null)
                            {
                                modelItem.FechaTermino = Convert.ToDateTime(FT);
                                this.UpdateModel(modelItem);
                                db.SaveChanges();
                            }

                            var modelItem2 = model2.Find(x => x.IdConvenioLaboralTrabajadorCategoria == idcltc);
                            if (modelItem2 != null)
                            {
                                modelItem2.FechaTermino = Convert.ToDateTime(FT);
                                this.UpdateModel(modelItem2);
                                db.SaveChanges();
                            }

                            var modelItem3 = model3.Find(y => y.IdDistribucionPlazaCategoria == idpc);
                            if (modelItem3 != null)
                            {
                                //bool valor = true;
                                modelItem3.EsVacante = true;
                                //modelItem3.EsVigente = (bool)valor;
                                this.UpdateModel(modelItem3);
                                db.SaveChanges();

                            }
                            kardex.GrabaEstatusTrabajador(idcltc, IdEstatusTrabajador);
                                //var model44 = new Kardex_stEstatusTrabajador();
                                //model44.IdConvenioLaboralTrabajadorCategoria = idcltc;
                                //model44.IdEstatusTrabajador = Convert.ToInt16(ViewBag.IdEstatusTrabajador);
                                //model44.FechaEstatusTrabajador = DateTime.Now;
                                //db.Kardex_stEstatusTrabajador.Add(model44);
                                //db.SaveChanges();
                                //    scope.Complete();
                                //}
                        }



                    }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }

                scope.Complete();
                }
                } // transaction scope end
            //}

            //else
            //{
            //    ViewData["EditError"] = "Please, correct all errors.";
            //    throw new System.ArgumentException("La Fecha es un dato requerido", "FechaTermino");
            //}

            //return RedirectToAction("Index", new { IdTrabajador = id });
            //return View("Renuncia");
            return RedirectToAction("Index", new { IdConvenioLaboralTrabajadorCategoria = idcltc });




        }



    }
}
