﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using DevExpress.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers
{
    public class QuincenaMesController : Controller
    {
        //
        // GET: /QuincenaMes/

        public ActionResult Index()
        {
            return View();
        }

        Nova.Models.bdNovaEntities db = new Nova.Models.bdNovaEntities();

        [ValidateInput(false)]
        public ActionResult pvQuincenaMes()
        {
            var model = db.Catalogos_ctQuincenaMes;
            return PartialView("_pvQuincenaMes", model.ToList());
        }

        [HttpPost, ValidateInput(false)]
        public ActionResult pvQuincenaMesAddNew(Nova.Models.Catalogos_ctQuincenaMes item)
        {
            var model = db.Catalogos_ctQuincenaMes;
            if (ModelState.IsValid)
            {
                try
                {
                    model.Add(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;
                }
            }
            else
                ViewData["EditError"] = ModelState.Values.SelectMany(m => m.Errors)
                             .Select(e => e.ErrorMessage).ToList().Aggregate((i, j) => i + " " + j);
            return PartialView("_pvQuincenaMes", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvQuincenaMesUpdate(Nova.Models.Catalogos_ctQuincenaMes item)
        {
            var model = db.Catalogos_ctQuincenaMes;
            if (ModelState.IsValid)
            {
                try
                {
                    var modelItem = model.FirstOrDefault(it => it.IdQuincenaMes == item.IdQuincenaMes);
                    if (modelItem != null)
                    {
                        this.UpdateModel(modelItem);
                        db.SaveChanges();
                    }
                }
                catch (Exception e)
                {
                    ViewData["EditError"] = e.Message;
                }
            }
            else
                ViewData["EditError"] = "Please, correct all errors.";
            return PartialView("_pvQuincenaMes", model.ToList());
        }
        [HttpPost, ValidateInput(false)]
        public ActionResult pvQuincenaMesDelete(System.Int16 IdQuincenaMes)
        {
            var model = db.Catalogos_ctQuincenaMes;
            if (IdQuincenaMes != null)
            {
                try
                {
                    var item = model.FirstOrDefault(it => it.IdQuincenaMes == IdQuincenaMes);
                    if (item != null)
                        model.Remove(item);
                    db.SaveChanges();
                }
                catch (Exception e)
                {
                    //ViewData["EditError"] = e.Message;
                    ViewData["EditError"] = ExceptionExtensions.GetOriginalException(e).Message;

                }
            }
            return PartialView("_pvQuincenaMes", model.ToList());
        }
    }
}
