﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Dapper;
using Nova.Models;
using Nova.Models.Calculos;
using Seguridad;
using Nova.Libraries;

namespace Nova.Controllers
{
    public class ProyeccionController : Controller
    {
        //
        // GET: /Proyeccion/

        public ActionResult QuincenaMes()
        {
            
            ViewData["Quincenas"] = Nomina_stNominaTrabajador.ObtenerQuincenas();
            return PartialView("_pvQuincenaMes");
        }

        public ActionResult Index()
        {
            //int anio = DateTime.Now.Year;

            ViewBag.UltimaProyeccion = Nomina_stNominaTrabajador.ObtenerUltimaProyeccion();

           
             
            return View();
        }
        [HttpPost]
        public ActionResult Index( short idqna=0)
        {
            int anio = DateTime.Now.Year;

            ViewBag.UltimaProyeccion = Nomina_stNominaTrabajador.ObtenerUltimaProyeccion();

            if (anio == 0 && idqna == 0)
            { 
            
            }
            else
            {
                bdNovaEntities bd = new bdNovaEntities();
                Nomina_stNominaTrabajador nominagral = new Nomina_stNominaTrabajador();

                DateTime HoraInicioProceso = DateTime.Now;

                foreach (var item in bd.Nomina_ctPlantillaNomina.ToList())
                {
                    Nomina_stNomina nomina = bd.Nomina_stNomina.Where(w => w.EsCerrada==false &&  w.IdPlantillaNomina == item.IdPlantillaNomina && w.Año == anio && w.IdQuincenaMes == idqna).FirstOrDefault();

                    if (nomina != null)
                    {
                        nominagral.IdNomina = nomina.IdNomina;


                        Nomina_stNominaTrabajador nt = new Nomina_stNominaTrabajador(nomina.IdNomina, 0, true);
                        CalculosNomina calculosnomina = new CalculosNomina(nt);


                        nt.GrabrarProyeccionBaseDatos((short)anio, idqna, Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria);


                    }
                    else
                        throw new ApplicationException("No existe nómina configurada para la quincena " + idqna.ToString()+ " y la siguiente plantila: " + item.Plantilla+" , notifique al área correspondiente.");



                }
                DateTime HoraFinProceso = DateTime.Now;


                TimeSpan difference = HoraFinProceso - HoraInicioProceso;
                double seconds = Math.Round(difference.TotalSeconds, 2);

                //nominagral.GrabrarProyeccionBaseDatos(anio, idqna, Identidad.Usuario().IdConvenioLaboralTrabajadorCategoria);      
                MessageBox.Show(ViewData, TipoMensaje.Success, " Se ha generado la proyeccion correctamente en " + seconds.ToString() + " segs.");
            }
            return View();
        }
	}
}