﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.Entity;
using System.Linq;
using System.Net;
using System.Web;
using System.Web.Mvc;
using Nova.Models;

namespace Nova.Controllers.ProcesoJuridico
{
    public class ProcesoJuridicoController : Controller
    {
        private bdNovaEntities db = new bdNovaEntities();

        // GET: ProcesoJuridico
        public ActionResult Index()
        {
            return View(db.Juridico_ctProceso.ToList());
        }

        // GET: ProcesoJuridico/Details/5
        public ActionResult Details(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Juridico_ctProceso juridico_ctProceso = db.Juridico_ctProceso.Find(id);
            if (juridico_ctProceso == null)
            {
                return HttpNotFound();
            }
            return View(juridico_ctProceso);
        }

        // GET: ProcesoJuridico/Create
        [HttpPost]
        public ActionResult Crear()
        {
            return View("Create");
        }

        // POST: ProcesoJuridico/Create
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Create([Bind(Include = "IdProceso,Proceso")] Juridico_ctProceso juridico_ctProceso)
        {
            if (ModelState.IsValid)
            {
                db.Juridico_ctProceso.Add(juridico_ctProceso);
                db.SaveChanges();
                return RedirectToAction("Index");
            }

            return View(juridico_ctProceso);
        }

        // GET: ProcesoJuridico/Edit/5
        public ActionResult Edit(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Juridico_ctProceso juridico_ctProceso = db.Juridico_ctProceso.Find(id);
            if (juridico_ctProceso == null)
            {
                return HttpNotFound();
            }
            return View(juridico_ctProceso);
        }

        // POST: ProcesoJuridico/Edit/5
        // Para protegerse de ataques de publicación excesiva, habilite las propiedades específicas a las que desea enlazarse. Para obtener 
        // más información vea http://go.microsoft.com/fwlink/?LinkId=317598.
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Edit([Bind(Include = "IdProceso,Proceso")] Juridico_ctProceso juridico_ctProceso)
        {
            if (ModelState.IsValid)
            {
                db.Entry(juridico_ctProceso).State = System.Data.Entity.EntityState.Modified;
                db.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(juridico_ctProceso);
        }

        // GET: ProcesoJuridico/Delete/5
        public ActionResult Delete(short? id)
        {
            if (id == null)
            {
                return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
            }
            Juridico_ctProceso juridico_ctProceso = db.Juridico_ctProceso.Find(id);
            if (juridico_ctProceso == null)
            {
                return HttpNotFound();
            }
            return View(juridico_ctProceso);
        }

        // POST: ProcesoJuridico/Delete/5
        //[HttpPost, ActionName("Delete")]
        //[ValidateAntiForgeryToken]
        public JsonResult DeleteConfirmed(short id)
        {
            Juridico_ctProceso juridico_ctProceso = db.Juridico_ctProceso.Find(id);
            db.Juridico_ctProceso.Remove(juridico_ctProceso);
            db.SaveChanges();
            return new JsonResult() { Data = "Registro eliminado exitosamente" };
        }

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                db.Dispose();
            }
            base.Dispose(disposing);
        }
    }
}
